package sample;

import java.awt.BorderLayout;
import java.net.URISyntaxException;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import com.kitfox.svg.SVGDisplayPanel;
import com.kitfox.svg.SVGUniverse;

public class SampleView extends JFrame
{
    private static final long serialVersionUID = 4893106215507853316L;

    public SampleView()
    {
        super("SVG Sample");
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        setLayout(new BorderLayout());

        SVGDisplayPanel pnl = new SVGDisplayPanel();
        try
        {
            pnl
                .setDiagram((new SVGUniverse())
                    .getDiagram(SampleView.class.getResource("sample.svg").toURI()));
            pnl.setScale(1);
        }
        catch (URISyntaxException e)
        {
            e.printStackTrace();
        }

        add(pnl, BorderLayout.CENTER);

        pack();
        setLocationRelativeTo(null);
        setVisible(true);
    }

    public static void main(String[] args) throws Exception
    {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable()
        {
            @Override
            public void run()
            {
                new SampleView();
            }
        });
    }
}
