/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWSTATUS_H
#define _WCVIEWSTATUS_H

// sc
#include "WcViewItem.h"
#include "svn/WcStatusTypes.h"

// qt
#include <QtCore/QVariant>


/** WcViewTreeModel item implementation for svn::WcStatus objects. */
class WcViewStatus : public WcViewItem
{
public:
  WcViewStatus( svn::WcStatusPtr status );

  svn::WcStatusPtr status() const;

  // WcViewItem
  const sc::String& path() const;
  bool isDir() const;

  bool isChanged() const;
  bool isIgnored() const;
  bool isSwitched() const;
  bool isOutOfDate() const;

  StatusId getTextStatus() const;

private:
  svn::WcStatusPtr _status;
};


/** WcViewItemData implemetation for WcViewStatus items. */
class WcViewStatusData : public WcViewItemData
{
public:
  WcViewStatusData();

  /* WcViewItem overwrites. */
  int columns() const;

  QString data( int column, const WcViewItem* ) const;
  QColor color( int column, const WcViewItem* ) const;
  QVariant dataSort( int column, const WcViewItem* ) const;

  QString header( int column ) const;
  Qt::Alignment alignment( int column ) const;
  bool deep( int column ) const;
};

#endif //  _WCVIEWSTATUS_H
