#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    shared
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Sem
  require_relative 'dp'                                 # dp.rb
  class Tags
    def initialize(para,md)
      @para,@md=para,md
    end
    def rgx
      def exclude
        /^(?:<:code>|%+ )/
      end
      def each_csc
        /(?:;|(?:[a-z]+(?:[_:.][a-z]+)+|[a-z]*):)\{|\}[:;][a-z]+(?:[_:.][a-z]+)*/m
      end
      def each_c
        /(?:[a-z]+(?:[_:.][a-z]+)+|[a-z]*):\{|\}:[a-z]+(?:[_:.][a-z]+)*/m
      end
      def each_sc
        /(?:[a-z]+(?:[_:.][a-z]+)+|[a-z]*);\{|\};[a-z]+(?:[_:.][a-z]+)*/m
      end
      def pair_csc
        /(([a-z]+(?:[_:.][a-z]+)+|[a-z]+)(?::\{(.+?)\}:\2)|([:;])\{(.+?)\}\4[a-z]+(?:[_:.][a-z]+)*)/m
      end
      def pair_c
        /(([a-z]+(?:[_:.][a-z]+)*)(?::\{(.+?)\}:\2)|:\{(.+?)\}:[a-z]+(?:[_:.][a-z]+)*)/m
      end
      def pair_sc
        /(;\{.+?\};[a-z]+(?:[_:.][a-z]+)*)/m
      end
      def whole_csc_ae
        /(([a-z]+(?:[_.][a-z]+)+|[a-z]*)(?::\[(.+?)\]:\2)|;\{(.+?)\};(?:[a-z]+(?:[_:.][a-z]+)+|[a-z]+)\b)/m
      end
      def each_csc_ae
        /(?:;|(?:[a-z]+(?:[_:.][a-z]+)+)*:|[a-z]*:)\[|\][:;](?:[a-z]+(?:[_:.][a-z]+)+|[a-z]+)/m
      end
      self
    end
    def print
      def scan_pair_c
        if @para =~ rgx.pair_c
          matched=@para.scan(rgx.pair_c).flatten
          puts matched[0] unless matched[0].nil?
        end
      end
      def scan_pair_sc
        matched=@para.scan(rgx.pair_sc).flatten
        puts matched[0] unless matched[0].nil?
      end
      def if_pair_c
        if @para=~/([a-z](?:[a-z_:.]+?[a-z])?)+(?::\{(.+?)\}:\1)/m
          puts "#{$1}:{ #{$2} }:#{$1}"
        end
      end
      def if_pair_sc
        if @para=~/;\{\s*(.+?)\s*\};([a-z]+(?:[_:.][a-z]+)*)/
          puts ";{ #{$1} };#{$2}"
        end
      end
      def match_pair_c
        matched=[]
        matched=rgx.pair_c.match(@para)[1] if @para =~ rgx.pair_c
        puts matched unless matched.nil?
      end
      def match_pair_sc
        matched=[]
        matched=rgx.pair_sc.match(@para)[1] if @para =~ rgx.pair_sc
        puts matched unless matched.nil?
      end
      def matching
        scan_pair_c
      end
      self
    end
    def rm
      def sem_marker_parts
        unless @para =~ rgx.exclude
          @para.gsub!(rgx.each_csc,'')
        end
        @para
      end
      def sem_marker_added_extra_parts
        unless @para =~ rgx.exclude
          @para.gsub!(rgx.whole_csc_ae,'')
          if @para =~rgx.each_csc_ae
            STDERR.puts "WARNING semantic tagging error: #{@para}"
          end
        end
        @para
      end
      def all
        if @md.sem_tag
          sem_marker_parts
          sem_marker_added_extra_parts
        end
        @para
      end
      self
    end
  end
end
__END__
