/* registers.h - Register definition for E1 ASIC
 * 
 * Copyright (C) 2004, 2005 Anderson Lizardo
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

/* FIXME: This code was initially taken from pxscan-0.41 and is based on the
 * E3 ASIC definition. Probably some of the registers below are incorrect for
 * E1 or even do not exist on it.
 */

/* ASIC ID - R */
struct REG0
{
    unsigned AsicType:8;
};

/* General Register 0 - R/W */
struct REG1
{
    unsigned Data:8;
};

/* General Register 1 - R/W */
struct REG2
{
    unsigned Data:8;
};

/* Command Register 0 - R/W */
struct REG3
{
    unsigned SysReset:1;
    unsigned FiFoReset:1;
    unsigned EppUsb:1;
    unsigned WatchDog:1;
    unsigned SelfTest:1;
    unsigned ScanSpeed:3;
};

/* Command Register 1 - R/W */
struct REG4
{
    unsigned AsicTest:1;
    unsigned NoLineOffset:1;
    unsigned Refresh:1;
    unsigned RefreshForever:1;
    unsigned WaitDelay:2;
    unsigned ScanMode:2;
};

/* Command Register 2 - R/W */
struct REG5
{
    unsigned Sensor:2;
    unsigned SensorRes:2;       /* Sensor Resolution: 0 - 300 dpi; 1 - 600 dpi */
    unsigned Afe:3;
    unsigned Adc1210:1;
};

/* Motor Control - R/W */
struct REG6
{
    unsigned MotorPower:1;
    unsigned HalfFull:1;        /* 0 - Full Step;  1 - Half Step */
    unsigned Operation:3;
    unsigned LineOffset:3;
};

/* Motor Move Steps High Byte - R/W */
struct REG7
{
    unsigned Data:8;
};

/* Motor Move Steps Low Byte - R/W */
struct REG8
{
    unsigned Data:8;
};

/* Motor Back Steps (Scanning) - R/W */
struct REG9
{
    unsigned Data:8;
};

/* Motor Trigger Period High Byte (Unit: 0.5 us) - R/W */
struct REG10
{
    unsigned Data:8;
};

/* Motor Trigger Period Low Byte (Unit: 0.5 us) - R/W */
struct REG11
{
    unsigned Data:8;
};

/* Sensor Status - R/W */
struct REG12
{
    unsigned Lamp:1;
    unsigned KeyButton:1;
    unsigned HomeSensor:1;
    unsigned FinishFlag:1;
    unsigned FiFoEmpty:2;
    unsigned Reserved:2;
};

/* AFE Programming Register - R/W */
struct REG13
{
    unsigned SDI:1;
    unsigned SDO:1;             /* Data to scanner's ADC ( = SDI of SDC ) */
    unsigned SCLK:1;
    unsigned SEN:1;
    unsigned Reserved:1;
    unsigned VSMP:3;            /* VSMP = Video SAMPle sync pulse */
};

/* Memory Address Port (MSB) - R/W */
struct REG14
{
    unsigned Mem:5;
    unsigned Reserved:2;
    unsigned Mem_512_2048:1;
};

/* Memory Address Port High Byte - R/W */
struct REG15
{
    unsigned Data:8;
};

/* Memory Address Port Low Byte - R/W */
struct REG16
{
    unsigned Data:8;
};

/* Memory Data Port - R/W */
struct REG17
{
    unsigned Data:8;
};

/* Data Size High Byte - R/W */
struct REG18
{
    unsigned Data:8;
};

/* Data Size Low Byte - R/W */
struct REG19
{
    unsigned Data:8;
};

/* Scan Area Start Point High Byte - R/W */
struct REG20
{
    unsigned AreaStart:6;
    unsigned Reserved:2;
};

/* Scan Area Start Point Low Byte - R/W */
struct REG21
{
    unsigned AreaStart:8;
};

/* Scan Area Width High Byte - R/W */
struct REG22
{
    unsigned AreaWidth:6;
    unsigned Reserved:2;
};

/* Scan Area Width Low Byte - R/W */
struct REG23
{
    unsigned AreaWidth:8;
};

/* General Purpose I/O Register 0 - R */
struct REG24
{
    unsigned ProductID:5;
    unsigned Gio5:1;
    unsigned Gio6:1;
    unsigned Reserved:1;
};

/* General Purpose I/O Register 1 - R/W */
struct REG25
{
    unsigned Gio11:1;
    unsigned Gio12:1;
    unsigned Gio13:1;
    unsigned Gio14:1;
    unsigned Gio11ctl:1;
    unsigned Gio12ctl:1;
    unsigned Gio13ctl:1;
    unsigned Gio14ctl:1;
};

/* Buffer Bank R/W Difference Motor Start & Stop - R/W */
struct REG26
{
    unsigned Stop:4;
    unsigned Start:4;
};

/* X-Direction & Y-Direction Resolution Control High Byte - R/W */
struct REG27
{
    unsigned YRes:3;
    unsigned AutoPattern:1;
    unsigned XRes:3;
    unsigned True16Bit:1;
};

/* X-Direction Resolution Control Low Byte - R/W */
struct REG28
{
    unsigned XRes:8;
};

/* Y-Direction Resolution Control Low Byte - R/W */
struct REG29
{
    unsigned YRes:8;
};

union
{
    struct REG0 r;
    unsigned char w;
} reg0;

union
{
    struct REG1 r;
    unsigned char w;
} reg1;

union
{
    struct REG2 r;
    unsigned char w;
} reg2;

union
{
    struct REG3 r;
    unsigned char w;
} reg3;

union
{
    struct REG4 r;
    unsigned char w;
} reg4;

union
{
    struct REG5 r;
    unsigned char w;
} reg5;

union
{
    struct REG6 r;
    unsigned char w;
} reg6;

union
{
    struct REG7 r;
    unsigned char w;
} reg7;

union
{
    struct REG8 r;
    unsigned char w;
} reg8;

union
{
    struct REG9 r;
    unsigned char w;
} reg9;

union
{
    struct REG10 r;
    unsigned char w;
} reg10;

union
{
    struct REG11 r;
    unsigned char w;
} reg11;

union
{
    struct REG12 r;
    unsigned char w;
} reg12;

union
{
    struct REG13 r;
    unsigned char w;
} reg13;

union
{
    struct REG14 r;
    unsigned char w;
} reg14;

union
{
    struct REG15 r;
    unsigned char w;
} reg15;

union
{
    struct REG16 r;
    unsigned char w;
} reg16;

union
{
    struct REG17 r;
    unsigned char w;
} reg17;

union
{
    struct REG18 r;
    unsigned char w;
} reg18;

union
{
    struct REG19 r;
    unsigned char w;
} reg19;

union
{
    struct REG20 r;
    unsigned char w;
} reg20;

union
{
    struct REG21 r;
    unsigned char w;
} reg21;

union
{
    struct REG22 r;
    unsigned char w;
} reg22;

union
{
    struct REG23 r;
    unsigned char w;
} reg23;

union
{
    struct REG24 r;
    unsigned char w;
} reg24;

union
{
    struct REG25 r;
    unsigned char w;
} reg25;

union
{
    struct REG26 r;
    unsigned char w;
} reg26;

union
{
    struct REG27 r;
    unsigned char w;
} reg27;

union
{
    struct REG28 r;
    unsigned char w;
} reg28;

union
{
    struct REG29 r;
    unsigned char w;
} reg29;
