/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file Exceptions.h
    \author Romain BONDUE
    \date 05/07/2005 */
#ifndef __EXCEPTIONS_H__
#define __EXCEPTIONS_H__

#include <exception>
#include <string>
#include <cerrno>



namespace nsErrors
{
    class CException : public std::exception
    {
      public :
        CException (const std::string&, int) throw();
        ~CException () throw();
        const char* what () const throw();
        const std::string& GetMsg () const throw();
        int GetCode () const throw();


      private :
        std::string m_Msg;
        int m_Code;

    }; // CException


    class CSystemExc : public CException
    {
      public :
        CSystemExc (const std::string&, int = errno) throw();

    }; // CSystemExc


    template<class CExcType>
    class CRTExc : public std::exception // RT for RunTime
    {
      public :
        const char* what () const throw();

    }; // CRTExc

} // namespace nsErrors

#include "private/Exceptions.hxx"

#endif // __EXCEPTIONS_H__
