#### Note: this error code is no longer emitted by the compiler.

An intrinsic was declared without being a function.

Erroneous code example:

```ignore (no longer emitted)
#![feature(intrinsics)]
#![allow(internal_features)]

extern "C" {
    #[rustc_intrinsic]
    pub static atomic_singlethreadfence_seqcst: unsafe fn();
    // error: intrinsic must be a function
}

fn main() { unsafe { atomic_singlethreadfence_seqcst(); } }
```

An intrinsic is a function available for use in a given programming language
whose implementation is handled specially by the compiler. In order to fix this
error, just declare a function. Example:

```ignore (no longer emitted)
#![feature(intrinsics)]
#![allow(internal_features)]

#[rustc_intrinsic]
pub unsafe fn atomic_singlethreadfence_seqcst(); // ok!

fn main() { unsafe { atomic_singlethreadfence_seqcst(); } }
```
