// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::{ffi, GLContext, GLDisplayType, GLWindow, GLAPI};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GstGLDisplay")]
    pub struct GLDisplay(Object<ffi::GstGLDisplay, ffi::GstGLDisplayClass>) @extends gst::Object;

    match fn {
        type_ => || ffi::gst_gl_display_get_type(),
    }
}

impl GLDisplay {
    pub const NONE: Option<&'static GLDisplay> = None;

    #[doc(alias = "gst_gl_display_new")]
    pub fn new() -> GLDisplay {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_gl_display_new()) }
    }

    #[cfg(feature = "v1_20")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_20")))]
    #[doc(alias = "gst_gl_display_new_with_type")]
    #[doc(alias = "new_with_type")]
    pub fn with_type(type_: GLDisplayType) -> Option<GLDisplay> {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_gl_display_new_with_type(type_.into_glib())) }
    }
}

impl Default for GLDisplay {
    fn default() -> Self {
        Self::new()
    }
}

unsafe impl Send for GLDisplay {}
unsafe impl Sync for GLDisplay {}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::GLDisplay>> Sealed for T {}
}

pub trait GLDisplayExt: IsA<GLDisplay> + sealed::Sealed + 'static {
    #[doc(alias = "gst_gl_display_create_window")]
    fn create_window(&self) -> Result<GLWindow, glib::BoolError> {
        unsafe {
            Option::<_>::from_glib_full(ffi::gst_gl_display_create_window(
                self.as_ref().to_glib_none().0,
            ))
            .ok_or_else(|| glib::bool_error!("Failed to create window"))
        }
    }

    #[doc(alias = "gst_gl_display_filter_gl_api")]
    fn filter_gl_api(&self, gl_api: GLAPI) {
        unsafe {
            ffi::gst_gl_display_filter_gl_api(self.as_ref().to_glib_none().0, gl_api.into_glib());
        }
    }

    #[doc(alias = "gst_gl_display_get_gl_api")]
    #[doc(alias = "get_gl_api")]
    fn gl_api(&self) -> GLAPI {
        unsafe {
            from_glib(ffi::gst_gl_display_get_gl_api(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_gl_display_get_gl_api_unlocked")]
    #[doc(alias = "get_gl_api_unlocked")]
    fn gl_api_unlocked(&self) -> GLAPI {
        unsafe {
            from_glib(ffi::gst_gl_display_get_gl_api_unlocked(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_gl_display_get_handle_type")]
    #[doc(alias = "get_handle_type")]
    fn handle_type(&self) -> GLDisplayType {
        unsafe {
            from_glib(ffi::gst_gl_display_get_handle_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gst_gl_display_remove_window")]
    fn remove_window(&self, window: &impl IsA<GLWindow>) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_gl_display_remove_window(
                    self.as_ref().to_glib_none().0,
                    window.as_ref().to_glib_none().0
                ),
                "Failed to remove window"
            )
        }
    }

    //#[cfg(feature = "v1_18")]
    //#[cfg_attr(docsrs, doc(cfg(feature = "v1_18")))]
    //#[doc(alias = "gst_gl_display_retrieve_window")]
    //fn retrieve_window(&self, data: /*Unimplemented*/Option<Basic: Pointer>, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Option<Basic: Pointer>) -> i32) -> Option<GLWindow> {
    //    unsafe { TODO: call ffi:gst_gl_display_retrieve_window() }
    //}

    #[doc(alias = "create-context")]
    fn connect_create_context<
        F: Fn(&Self, &GLContext) -> Option<GLContext> + Send + Sync + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_context_trampoline<
            P: IsA<GLDisplay>,
            F: Fn(&P, &GLContext) -> Option<GLContext> + Send + Sync + 'static,
        >(
            this: *mut ffi::GstGLDisplay,
            context: *mut ffi::GstGLContext,
            f: glib::ffi::gpointer,
        ) -> *mut ffi::GstGLContext {
            let f: &F = &*(f as *const F);
            f(
                GLDisplay::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(context),
            )
            .to_glib_full()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"create-context\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    create_context_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<GLDisplay>> GLDisplayExt for O {}
