/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "RipOffPlugin.h"

RipOffPlugin ripoff_plugin_new(RipOffPluginRaw raw, gpointer *lib_handler)
{
	RipOffPlugin plugin = g_new(struct RipOffPlugin_, 1);
	plugin->raw = raw;
	plugin->lib_handler = lib_handler;
	return plugin;
}

const gchar *ripoff_plugin_get_name(RipOffPlugin plugin)
{
	gpointer (*get_name)(RipOffPluginRaw);
	const gchar* error_msg;

	get_name = dlsym(plugin->lib_handler, "ripoff_plugin_raw_get_name");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
		return "Not a RipOffPluginRaw object";
	}

	return get_name(plugin->raw);
}

const gchar *ripoff_plugin_get_label(RipOffPlugin plugin)
{
	gpointer (*get_label)(RipOffPluginRaw);
	const gchar* error_msg;

	get_label = dlsym(plugin->lib_handler, "ripoff_plugin_raw_get_label");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
		return "Not a RipOffPluginRaw object";
	}

	return get_label(plugin->raw);
}

const gchar *ripoff_plugin_get_extension(RipOffPlugin plugin)
{
	gpointer(*get_extension)(RipOffPluginRaw);
	const gchar* error_msg;

	get_extension = dlsym(plugin->lib_handler, "ripoff_plugin_raw_get_extension");
	error_msg = dlerror();

	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
		return "Not a RipOffPluginRaw object";
	}

	return get_extension(plugin->raw);
}

GtkWidget *ripoff_plugin_prefs(RipOffPlugin plugin)
{
	gpointer (*prefs)(RipOffPluginRaw);
	const gchar* error_msg;

	prefs = dlsym(plugin->lib_handler, "ripoff_plugin_raw_prefs");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
	}

	return  prefs(plugin->raw); 
}

GtkWidget * ripoff_plugin_about(RipOffPlugin plugin)
{
	gpointer (*about)(RipOffPluginRaw);
	const gchar* error_msg;

	about = dlsym(plugin->lib_handler, "ripoff_plugin_raw_about");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
	}

	return about(plugin->raw); 
}

/* returns whether the plugin has a preferences dialog */
gboolean ripoff_plugin_has_prefs(RipOffPlugin plugin)
{
	gboolean (*has_prefs)(RipOffPluginRaw);
	const gchar* error_msg;

	has_prefs = dlsym(plugin->lib_handler, "ripoff_plugin_raw_has_prefs");
	error_msg = dlerror();

	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
	}

	return  (gboolean) has_prefs(plugin->raw); 
}

/* returns whether the plugin has an about dialog */
gboolean ripoff_plugin_has_about(RipOffPlugin plugin)
{
	gboolean (*has_about)(RipOffPluginRaw);
	const gchar* error_msg;

	has_about = dlsym(plugin->lib_handler, "ripoff_plugin_raw_has_about");
	error_msg = dlerror();

	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
	}

	return  has_about(plugin->raw); 
}

gboolean ripoff_plugin_perform_setup(	RipOffPlugin plugin,
					long total_bytes_to_encode,
					FILE *output_descriptor,
					RipOffTrack track)
{
	gboolean (*perform_setup)(RipOffPluginRaw, long, FILE *, RipOffTrack);

	const gchar* error_msg;

	perform_setup = dlsym(plugin->lib_handler, "ripoff_plugin_raw_perform_setup");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
		return TRUE;
	}

	return perform_setup(plugin->raw, total_bytes_to_encode, output_descriptor, track);
}

gboolean ripoff_plugin_encode_buffer(	RipOffPlugin plugin,
					long total_bytes_to_encode,
					int16_t *audio_data,
					FILE *output_descriptor,
					RipOffTrack track)
{

	gboolean (*perform_encode_buffer)(RipOffPluginRaw, long, int16_t *, FILE *, RipOffTrack);

	const gchar* error_msg;

	perform_encode_buffer = dlsym(plugin->lib_handler, "ripoff_plugin_raw_encode_buffer");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
		return TRUE;
	}

	return perform_encode_buffer(plugin->raw, total_bytes_to_encode, audio_data, output_descriptor, track);
}

gboolean ripoff_plugin_perform_cleanup(	RipOffPlugin plugin,
					long total_bytes_to_encode,
					FILE *output_descriptor,
					RipOffTrack track)
{
	gboolean (*perform_cleanup)(RipOffPluginRaw, long, FILE *, RipOffTrack);

	const gchar* error_msg;

	perform_cleanup = dlsym(plugin->lib_handler, "ripoff_plugin_raw_perform_cleanup");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
		return TRUE;
	}

	return perform_cleanup(plugin->raw, total_bytes_to_encode, output_descriptor, track);
}

/* Informs the plugin that RipOff is shutting down and that it needs to save its settings
   accordingly */
void ripoff_plugin_close(RipOffPlugin plugin)
{
	gpointer (*close)(RipOffPluginRaw);
	const gchar* error_msg;

	close = dlsym(plugin->lib_handler, "ripoff_plugin_raw_close");
	error_msg = dlerror();
	
	if(error_msg)
	{
		fprintf(stderr, "Error locating 'function' - %s\n", error_msg);
	}

	/* return */ close(plugin->raw);
}
