#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main() {
  Float inv_lambda;
  field uh, ph;
  cin  >> catchmark("inv_lambda")  >> inv_lambda
       >> catchmark("u")  >> uh
       >> catchmark("p")  >> ph;
  const space& Vh = uh.get_space();
  const space& Qh = ph.get_space();
  size_t d = Vh.dimension();
  field fh (Vh, 0.);
  fh[d-1] = -1;
  form mu (Vh, Vh, "mass");
  form mp (Qh, Qh, "mass");
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div"); b = -b;
  form c = inv_lambda*mp;
  ssk<Float> fact_mp = ldlt(mp.uu);
  field m_ru = a*uh + b.trans_mult(ph) - mu*fh;
  field m_rp = b*uh - c*ph;
  m_ru["bottom"] = m_ru["left"] = 0;
  if (d == 3) { m_ru["right"] = m_ru["back"] = 0; }
  field rp (Qh);
  rp.u = fact_mp.solve(m_rp.u);
  Float res_u = m_ru.u.max_abs();
  Float res_p = sqrt(mp(rp,rp));
  Float res = max(res_u, res_p);
  cerr << "check: residue(uh) = " << res_u << endl;
  cerr << "check: residue(ph) = " << res_p << endl;
  check_macro (res < 1e-6, "unexpected residue");
  return 0;
}
