# Announce: Rakudo Perl 6 compiler, Release #97 (2016.03)

On behalf of the Rakudo development team, I’m very happy to announce the
March 2016 release of Rakudo Perl 6 #97. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to insure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, but please bear
with us post-Christmas. We are working hard to insure that we don’t break
anything now that we have a released spec, and it make take us a few months
to settle back into a rhythm.

The changes in this release are outlined below:

New in 2016.03:
 + Fixes:
   + Buf.push|append|unshift|prepend now can take int arrays
   + Better error messages when trying to put illegal values into Blob|Buf
   + The REPL now allows statements spread over multiple lines
   + No longer show compilation error twice when loading module with errors
   + Only Bufs can now be specified as parameter to subbuf-rw
   + Values in %*ENV now have allomorphic semantics
   + Supply.Channel / Channel.Supply no longer lose exceptions
   + Calling .prepend on a native array no longer infiniloops
   + Blob.WHICH now indicates a value (immutable) type
   + Better error reporting for problems with sprintf()
   + Some obscure unicode codepoints causing segfaults no longer segfault
   + Directory listings now handle wrongly encoded data using utf8-c8
 + Additions:
   + Native str arrays (my str @a)
   + Buf.pop, Buf.shift and Buf.splice (similar to List.*)
   + Blob|Buf.allocate($elems, @init-pattern)
   + Buf.reallocate($elems) added
   + &*EXIT can be set to handle exit() statements (for embedding Perl 6)
 + Efficiency:
   + Auto-generated accessors/mutators use less memory and are faster
   + Most Blob|Buf related options use less memory and/or are (much) faster
   + Same for much of the native array support and IO reading operations
   + Many Parameter/Signature related options are much faster
   + Punning a role is much faster
   + Modules can now be shared between rakudo versions

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The following people contributed to this release:

Elizabeth Mattijsen, Jonathan Worthington, Pawel Murias, Timo Paulssen, Tobias Leich, Will "Coke" Coleda, Pepe Schwarz, Rob Hoelz, Salvador Ortiz, Donald Hunter, Moritz Lenz, Steve Mynott, Simon Ruderich, Nick Logan, skids, Jonathan Scott Duff, Andy Weidenbaum, Stefan Seifert, Gerd Pokorra

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#98), is tentatively scheduled for 16 April 2016.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility. Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
