% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_along.R
\name{tween_along}
\alias{tween_along}
\title{Interpolate data along a given dimension}
\usage{
tween_along(.data, ease, nframes, along, id = NULL, range = NULL,
  history = TRUE, keep_last = FALSE)
}
\arguments{
\item{.data}{A data.frame with components at different stages}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{nframes}{The number of frames to calculate for the tween}

\item{along}{The "time" point for each row}

\item{id}{An unquoted expression giving the component id for each row. Will
be evaluated in the context of \code{.data} so can refer to a column from that}

\item{range}{The range of time points to include in the tween. If \code{NULL} it
will use the range of \code{time}}

\item{history}{Should earlier datapoints be kept in subsequent frames}

\item{keep_last}{Should the last point of each id be kept beyond its time}
}
\value{
A data.frame with the same columns as \code{.data} along with \code{.id} giving
the component id, \code{.phase} giving the state of each component in each frame,
and \code{.frame} giving the frame membership of each row.
}
\description{
This tween takes groups of rows along with the time for each row and
calculates the exact value at each at each frame. Further it allows for
keeping the subsequent raw data from previous frame as well as letting the
final row linger beyond its time. It especially useful for data that should
be visualised as lines that are drawn along the x-axis, but can of course
also be used for other dimensions as well (even dimensions not corresponding
to any axis).
}
\seealso{
Other data.frame tween: \code{\link{tween_appear}},
  \code{\link{tween_components}},
  \code{\link{tween_elements}}, \code{\link{tween_events}},
  \code{\link{tween_states}}
}
\concept{data.frame tween}
