% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id2name.R
\name{id2name}
\alias{id2name}
\alias{id2name.default}
\alias{id2name.tolid}
\alias{id2name.tsn}
\alias{id2name.uid}
\alias{id2name.wormsid}
\alias{id2name.gbifid}
\alias{id2name.boldid}
\title{Taxonomic IDs to taxonomic names}
\usage{
id2name(id, db = NULL, x = NULL, ...)

\method{id2name}{default}(id, db = NULL, x = NULL, ...)

\method{id2name}{tolid}(id, ...)

\method{id2name}{tsn}(id, ...)

\method{id2name}{uid}(id, ...)

\method{id2name}{wormsid}(id, ...)

\method{id2name}{gbifid}(id, ...)

\method{id2name}{boldid}(id, ...)
}
\arguments{
\item{id}{vector of taxonomic IDs (character or numeric)}

\item{db}{(character) database to query. One or more of \code{tol}, \code{itis},
\code{ncbi}, \code{worms}, \code{gbif}, or \code{bold}. Note that each
taxonomic data source has their own  identifiers, so that if you provide
the wrong \code{db} value for the identifier you could get a result,
but it will likely be wrong (not what you were expecting). If using ncbi
we recommend getting API keys; see \link{taxize-authentication}}

\item{x}{Deprecated, see \code{id}}

\item{...}{Further args passed on to \code{tol_id2name} or
\link{itis_getrecord}, or other internal functions.
See those functions for what parameters can be passed on.}
}
\value{
A named list of data.frames, named by the input taxonomic ids
}
\description{
Taxonomic IDs to taxonomic names
}
\section{HTTP version for NCBI requests}{

We hard code \code{http_version = 2L} to use HTTP/1.1 in HTTP requests to
the Entrez API. See \code{curl::curl_symbols('CURL_HTTP_VERSION')}
}

\examples{
\dontrun{
# ITIS
id2name(19322, db = "itis")

# TOL
id2name(515698, db = "tol")
# get NCBI ID and pass to classification()
x <- id2name(515698, db = "tol")
classification(as.uid(x[[1]]$tax_sources_ncbi))

# NCBI
id2name(315567, db = "ncbi")
id2name(3339, db = "ncbi")
id2name(9696, db = "ncbi")
id2name(c(9695, 9696), db = "ncbi")

# WORMS
id2name(105706, db = "worms")

# GBIF
id2name(2441176, db = "gbif")

# BOLD
id2name(88899, db = "bold")
}
}
