% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{progress_estimated}
\alias{progress_estimated}
\title{Progress bar with estimated time.}
\usage{
progress_estimated(n, min_time = 0)
}
\arguments{
\item{n}{Total number of items}

\item{min_time}{Progress bar will wait until at least \code{min_time}
seconds have elapsed before displaying any results.}
}
\value{
A ref class with methods \code{tick()}, \code{print()},
\code{pause()}, and \code{stop()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This progress bar has been deprecated since providing progress bars is not
the responsibility of dplyr. Instead, you might try the more powerful
\href{https://github.com/r-lib/progress}{progress} package.

This reference class represents a text progress bar displayed estimated
time remaining. When finished, it displays the total duration.  The
automatic progress bar can be disabled by setting option
\code{dplyr.show_progress} to \code{FALSE}.
}
\examples{
p <- progress_estimated(3)
p$tick()
p$tick()
p$tick()

p <- progress_estimated(3)
for (i in 1:3) p$pause(0.1)$tick()$print()

p <- progress_estimated(3)
p$tick()$print()$
 pause(1)$stop()

# If min_time is set, progress bar not shown until that many
# seconds have elapsed
p <- progress_estimated(3, min_time = 3)
for (i in 1:3) p$pause(0.1)$tick()$print()

\dontrun{
p <- progress_estimated(10, min_time = 3)
for (i in 1:10) p$pause(0.5)$tick()$print()
}
}
\keyword{internal}
