% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adk.R
\name{glance.adk}
\alias{glance.adk}
\title{Glance at a \code{adk} (Anderson--Darling k-Sample) object}
\usage{
\method{glance}{adk}(x, ...)
}
\arguments{
\item{x}{an \code{adk} object}

\item{...}{Additional arguments. Not used. Included only to match generic
signature.}
}
\value{
A one-row \code{\link[tibble:tibble]{tibble::tibble()}} with the following
columns:
\itemize{
\item \code{alpha} the significance level for the test
\item \code{n} the sample size for the test
\item \code{k} the number of samples
\item \code{sigma} the computed standard deviation of the test statistic
\item \code{ad} the test statistic
\item \code{p} the p-value of the test
\item \code{reject_same_dist} whether the test concludes that the samples
are drawn from different populations
}
}
\description{
Glance accepts an object of type \code{adk} and returns a
\code{\link[tibble:tibble]{tibble::tibble()}} with
one row of summaries.

Glance does not do any calculations: it just gathers the results in a
tibble.
}
\examples{
x <- c(rnorm(20, 100, 5), rnorm(20, 105, 6))
k <- c(rep(1, 20), rep(2, 20))
a <- ad_ksample(x = x, groups = k)
glance(a)

## A tibble: 1 x 7
##   alpha     n     k sigma    ad       p reject_same_dist
##   <dbl> <int> <int> <dbl> <dbl>   <dbl> <lgl>
## 1 0.025    40     2 0.727  4.37 0.00487 TRUE

}
\seealso{
\code{\link[=ad_ksample]{ad_ksample()}}
}
