% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{hash_animal}
\alias{hash_animal}
\alias{hash_raw_animal}
\alias{hash_obj_animal}
\title{Adjective-animal hash}
\usage{
hash_animal(x, n_adj = 2)

hash_raw_animal(x, n_adj = 2)

hash_obj_animal(x, n_adj = 2, serialize_version = 2)
}
\arguments{
\item{x}{Character vector. \code{NA} entries will have an \code{NA} hash.}

\item{n_adj}{Number of adjectives to use. It must be from 0 through 3.}

\item{serialize_version}{Workspace format version to use, see
\code{\link[base:serialize]{base::serialize()}}.}
}
\value{
A data frame with columns
\itemize{
\item \code{hash}: the hash value, a string.
\item \code{words}: list column with the adjectives and the animal name in a
character vector.
}

\code{hash_raw_animal()} and \code{hash_obj_animal()} return a list
with entries:
\itemize{
\item \code{hash}: the hash value, a string,
\item `words: the adjectives and the animal name in a character vector.
}
}
\description{
Adjective-animal hash
}
\details{
It uses the first 13 hexadecimal characters (out of the 32) of the MD5
hash of the input, and converts them into an adjective-animal form to
create a human readable hash.
\subsection{Number of possible hash values}{

\code{hash_animal()} uses 1748 animal names and
8946 different adjectives. The number of
different hashes you can get for different values of \code{n_adj}:\tabular{rr}{
   \code{n_adj} \tab size of the hash table space \cr
   0 \tab 1,748 \cr
   1 \tab 15,637,608 \cr
   2 \tab 139,894,041,168 \cr
   3 \tab 1,251,492,092,288,928 \cr
}

}

\subsection{Source}{

The list of adjectives and animals comes from the ids package,
and in turn from
\url{https://github.com/a-type/adjective-adjective-animal}, and
from \verb{https://gfycat.com} (now gone).
}

\code{hash_raw_animal()} calculates the adjective-animal hash of
the bytes of a raw vector.

\code{hash_obj_animal()} calculates the adjective-animal hash of
an R object. The object is serialized into a binary vector first.
}
\examples{
hash_animal(c("foo", "bar"))

# if you increase `n_adj`, the shorter hash is a suffix of the longer:
hash_animal("cli package", 0)$hash
hash_animal("cli package", 1)$hash
hash_animal("cli package", 2)$hash
hash_animal("cli package", 3)$hash
}
\seealso{
the ids package for generating random adjective-animal ids

Other hash functions: 
\code{\link{hash_emoji}()},
\code{\link{hash_md5}()},
\code{\link{hash_sha1}()},
\code{\link{hash_sha256}()}
}
\concept{hash functions}
