% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box-styles.R, R/boxes.R
\name{list_border_styles}
\alias{list_border_styles}
\alias{boxx}
\title{Draw a banner-like box in the console}
\usage{
list_border_styles()

boxx(label, border_style = "single", padding = 1, margin = 0,
  float = c("left", "center", "right"), col = NULL, background_col = NULL,
  border_col = col, align = c("left", "center", "right"),
  width = console_width())
}
\arguments{
\item{label}{Label to show, a character vector. Each element will be
in a new line. You can color it using the \code{crayon} packag, see
examples below.}

\item{border_style}{String that specifies the border style.
\code{list_border_styles} lists all current styles.}

\item{padding}{Padding within the box. Either an integer vector of
four numbers (bottom, left, top, right), or a single number \code{x}, which
is interpreted as \code{c(x, 3*x, x, 3*x)}.}

\item{margin}{Margin around the box. Either an integer vector of four
numbers (bottom, left, top, right), or a single number \code{x}, which is
interpreted as \code{c(x, 3*x, x, 3*x)}.}

\item{float}{Whether to display the box on the \code{"left"}, \code{"center"}, or
the \code{"right"} of the screen.}

\item{col}{Color of text, and default border color. Either a \code{crayon} style
function or a color name that is passed to \code{\link[crayon:make_style]{crayon::make_style()}}.}

\item{background_col}{Background color of the inside of the box.
Either a \code{crayon} style function, or a color name which will be used
in \code{\link[crayon:make_style]{crayon::make_style()}} to create a \emph{background} style
(i.e. \code{bg = TRUE} is used).}

\item{border_col}{Color of the border. Either a \code{crayon} style
function or a color name that is passed to \code{\link[crayon:make_style]{crayon::make_style()}}.}

\item{align}{Alignment of the label within the box: \code{"left"},
\code{"center"}, or \code{"right"}.}

\item{width}{Width of the screen, defaults to \code{getOption("width")}.}
}
\description{
Draw a banner-like box in the console
}
\section{About fonts and terminal settings}{

The boxes might or might not look great in your terminal, depending
on the box style you use and the font the terminal uses. We found that
the Menlo font looks nice in most terminals an also in Emacs.

RStudio currently has a line height greater than one for console output,
which makes the boxes ugly.
}

\examples{
## Simple box
boxx("Hello there!")

## All border styles
list_border_styles()

## Change border style
boxx("Hello there!", border_style = "double")

## Multiple lines
boxx(c("Hello", "there!"), padding = 1)

## Padding
boxx("Hello there!", padding = 1)
boxx("Hello there!", padding = c(1, 5, 1, 5))

## Margin
boxx("Hello there!", margin = 1)
boxx("Hello there!", margin = c(1, 5, 1, 5))
boxx("Hello there!", padding = 1, margin = c(1, 5, 1, 5))

## Floating
boxx("Hello there!", padding = 1, float = "center")
boxx("Hello there!", padding = 1, float = "right")

## Text color
boxx(crayon::cyan("Hello there!"), padding = 1, float = "center")

## Backgorund color
boxx("Hello there!", padding = 1, background_col = "brown")
boxx("Hello there!", padding = 1, background_col = crayon::bgRed)

## Border color
boxx("Hello there!", padding = 1, border_col = "green")
boxx("Hello there!", padding = 1, border_col = crayon::red)

## Label alignment
boxx(c("Hi", "there", "you!"), padding = 1, align = "left")
boxx(c("Hi", "there", "you!"), padding = 1, align = "center")
boxx(c("Hi", "there", "you!"), padding = 1, align = "right")

## A very customized box
star <- symbol$star
label <- c(paste(star, "Hello", star), "  there!")
boxx(
  crayon::white(label),
  border_style="round",
  padding = 1,
  float = "center",
  border_col = "tomato3",
  background_col="darkolivegreen"
)
}
