##############################################################################
#
#  XAMPP for Linux text Parameter Multiple XSS Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/07
#
#  Revision: 1.2
#
#  Log: schandan
#  Issue #0093
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900023);
 script_cve_id("CVE-2008-3569");
 script_bugtraq_id(30535);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_name("XAMPP for Linux text Parameter Multiple XSS Vulnerabilities");
 script_summary("Check for the vulnerable version of XAMPP");
 desc = "
 Overview : The host is running Xampp, which is prone to multiple cross site
 scripting vulnerabilities.

 Vulnerability Insight :

        The flaw is due the input passed to the parameter text in iart.php and
        ming.php files are not santised before being returned to the user.

        Impact : Successful exploitation could allow remote attackers to execute
        arbitrary HTML and script code.

 Impact Level : Application

 Affected Software/OS: 
        Xampp Linux 1.6.7 and prior on Linux (All).
 
 Solution : Upgrade to Xampp Linux version 1.7.3 or later,
 For updates check, http://www.apachefriends.org/en/xampp-linux.html

 References : http://www.securityfocus.com/archive/1/495096
              
 CVSS Score :
        CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
        CVSS Temporal Score : 5.2
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


 include("http_func.inc");
 include("http_keepalive.inc");

 port = get_http_port(default:80);
 if(!port){
        exit(0);
 }

 foreach path (make_list("/xampp", cgi_dirs()))
 {
        sndReq = http_get(item:string(path, "/start.php"), port:port);
        rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
        if(rcvRes == NULL){
                exit(0);
        }

	if(egrep(pattern:"XAMPP for Linux", string:rcvRes) &&
           egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
	{
		if(safe_checks())
		{
			if(egrep(pattern:"XAMPP for Linux 1\.([0-5]\..*|6\.[0-7])" +
					 "($|[^.0-9])", string:rcvRes)){
				security_warning(port);
			}
			exit(0);
		}

		# XSS request sent to parameter text in iart.php
                sndReq = http_get(item:string(path, "/iart.php?text=%22%3E%" +
			 "3E%3C%3C%3E%3E%22%22%3Cscript%3Ealert(document.alert)" +
			 "%3C/script%3E"), port:port);
                rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
                if(rcvRes == NULL){
                        exit(0);
                }

                if('<script>alert(document.alert)</script>' >< rcvRes){
                        security_warning(port);
                }
                exit(0);
        }
 }
