# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1458-1 (openafs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60135);
 script_cve_id("CVE-2007-6599");
 script_bugtraq_id(27132);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1458-1 (openafs)";
 script_name(name);

 desc = "The remote host is missing an update to openafs
announced via advisory DSA 1458-1.

A race condition in the OpenAFS fileserver allows remote attackers to
cause a denial of service (daemon crash) by simultaneously acquiring and
giving back file callbacks, which causes the handler for the
GiveUpAllCallBacks RPC to perform linked-list operations without the
host_glock lock.

For the stable distribution (etch), this problem has been fixed in
version 1.4.2-6etch1

For the old stable distribution (sarge), this problem has been fixed in
version 1.3.81-3sarge3

We recommend that you upgrade your openafs packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201458-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1458-1 (openafs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openafs-modules-source", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-fileserver", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-openafs-kaserver", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbserver", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-kpasswd", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-client", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenafs-dev", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-doc", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-krb5", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openafs-dbg", ver:"1.4.2-6etch1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
