###############################################################################
# OpenVAS Vulnerability Test
# $Id: barracuda_web_application_firewall_detect.nasl 7197 2010-04-01 09:20:01Z chandra $
#
# Barracuda Web Application Firewall Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running Barracuda Web Application Firewall. The
Barracuda Web Application Firewall is a security solution for Web
applications and Web sites. 

See also:
http://www.barracudanetworks.com

Risk factor : None";

if (description)
{
 script_id(100419);
 script_version ("1.0-$Revision: 7197 $");
 script_tag(name:"risk_factor", value:"None");

 script_name("Barracuda Web Application Firewall Detection");
 script_description(desc);
 script_summary("Checks for the presence of Barracuda Web Application Firewall");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

 url = string(dir, "/cgi-mod/index.cgi");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;

 if(egrep(pattern: "<title>Barracuda Web Application Firewall", string: buf, icase: TRUE)) {

    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "barracuda.css\?v=([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
    }

    set_kb_item(name: string("www/", port, "/barracuda_web_application_firewall"), value: vers);

    info = string("None\n\nBarracuda Web Application Firewall Version '");
    info += string(vers);
    info += string("' was detected on the remote host.\n");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }

exit(0);

