/* 
 * Copyright (c) 2011, 2014, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
 
package javafx.animation;

/**
Builder class for javafx.animation.Animation
@see javafx.animation.Animation
@deprecated This class is deprecated and will be removed in the next version
* @since JavaFX 2.0
*/
@javax.annotation.Generated("Generated by javafx.builder.processor.BuilderProcessor")
@Deprecated
public abstract class AnimationBuilder<B extends javafx.animation.AnimationBuilder<B>> {
    protected AnimationBuilder() {
    }
    
    
    private int __set;
    public void applyTo(javafx.animation.Animation x) {
        int set = __set;
        if ((set & (1 << 0)) != 0) x.setAutoReverse(this.autoReverse);
        if ((set & (1 << 1)) != 0) x.setCycleCount(this.cycleCount);
        if ((set & (1 << 2)) != 0) x.setDelay(this.delay);
        if ((set & (1 << 3)) != 0) x.setOnFinished(this.onFinished);
        if ((set & (1 << 4)) != 0) x.setRate(this.rate);
    }
    
    private boolean autoReverse;
    /**
    Set the value of the {@link javafx.animation.Animation#isAutoReverse() autoReverse} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B autoReverse(boolean x) {
        this.autoReverse = x;
        __set |= 1 << 0;
        return (B) this;
    }
    
    private int cycleCount;
    /**
    Set the value of the {@link javafx.animation.Animation#getCycleCount() cycleCount} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B cycleCount(int x) {
        this.cycleCount = x;
        __set |= 1 << 1;
        return (B) this;
    }
    
    private javafx.util.Duration delay;
    /**
    Set the value of the {@link javafx.animation.Animation#getDelay() delay} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B delay(javafx.util.Duration x) {
        this.delay = x;
        __set |= 1 << 2;
        return (B) this;
    }
    
    private javafx.event.EventHandler<javafx.event.ActionEvent> onFinished;
    /**
    Set the value of the {@link javafx.animation.Animation#getOnFinished() onFinished} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B onFinished(javafx.event.EventHandler<javafx.event.ActionEvent> x) {
        this.onFinished = x;
        __set |= 1 << 3;
        return (B) this;
    }
    
    private double rate;
    /**
    Set the value of the {@link javafx.animation.Animation#getRate() rate} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B rate(double x) {
        this.rate = x;
        __set |= 1 << 4;
        return (B) this;
    }
    
    private double targetFramerate;
    /**
    Set the value of the {@link javafx.animation.Animation#getTargetFramerate() targetFramerate} property for the instance constructed by this builder.
    */
    @SuppressWarnings("unchecked")
    public B targetFramerate(double x) {
        this.targetFramerate = x;
        return (B) this;
    }
    
}
