//
// AUTOGENERATED, DO NOT EDIT
//
#include "precomp.hpp"

#ifdef HAVE_CLAMDBLAS

#include "opencv2/ocl/cl_runtime/cl_runtime.hpp"
#include "opencv2/ocl/cl_runtime/clamdblas_runtime.hpp"

#if defined(_WIN32)
    static void* WinGetProcAddress(const char* name)
    {
        static HMODULE opencl_module = NULL;
        if (!opencl_module)
        {
            opencl_module = GetModuleHandleA("clAmdBlas.dll");
            if (!opencl_module)
            {
                opencl_module = LoadLibraryA("clAmdBlas.dll");
                if (!opencl_module)
                    return NULL;
            }
        }
        return (void*)GetProcAddress(opencl_module, name);
    }
    #define CV_CL_GET_PROC_ADDRESS(name) WinGetProcAddress(name)
#endif // _WIN32

#if defined(linux)
    #include <dlfcn.h>
    #include <stdio.h>

    static void* GetProcAddress (const char* name)
    {
        static void* h = NULL;
        if (!h)
        {
            h = dlopen("libclAmdBlas.so", RTLD_LAZY | RTLD_GLOBAL);
            if (!h)
                return NULL;
        }

        return dlsym(h, name);
    }
    #define CV_CL_GET_PROC_ADDRESS(name) GetProcAddress(name)
#endif

#ifndef CV_CL_GET_PROC_ADDRESS
#define CV_CL_GET_PROC_ADDRESS(name) NULL
#endif

// generated by parser_clamdblas.py
enum OPENCLAMDBLAS_FN_ID {
    OPENCLAMDBLAS_FN_clAmdBlasGetVersion = 0,
    OPENCLAMDBLAS_FN_clAmdBlasSetup,
    OPENCLAMDBLAS_FN_clAmdBlasTeardown,
    OPENCLAMDBLAS_FN_clAmdBlasAddScratchImage,
    OPENCLAMDBLAS_FN_clAmdBlasRemoveScratchImage,
    OPENCLAMDBLAS_FN_clAmdBlasSswap,
    OPENCLAMDBLAS_FN_clAmdBlasDswap,
    OPENCLAMDBLAS_FN_clAmdBlasCswap,
    OPENCLAMDBLAS_FN_clAmdBlasZswap,
    OPENCLAMDBLAS_FN_clAmdBlasSscal,
    OPENCLAMDBLAS_FN_clAmdBlasDscal,
    OPENCLAMDBLAS_FN_clAmdBlasCscal,
    OPENCLAMDBLAS_FN_clAmdBlasZscal,
    OPENCLAMDBLAS_FN_clAmdBlasCsscal,
    OPENCLAMDBLAS_FN_clAmdBlasZdscal,
    OPENCLAMDBLAS_FN_clAmdBlasScopy,
    OPENCLAMDBLAS_FN_clAmdBlasDcopy,
    OPENCLAMDBLAS_FN_clAmdBlasCcopy,
    OPENCLAMDBLAS_FN_clAmdBlasZcopy,
    OPENCLAMDBLAS_FN_clAmdBlasSaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasDaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasCaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasZaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasSdot,
    OPENCLAMDBLAS_FN_clAmdBlasDdot,
    OPENCLAMDBLAS_FN_clAmdBlasCdotu,
    OPENCLAMDBLAS_FN_clAmdBlasZdotu,
    OPENCLAMDBLAS_FN_clAmdBlasCdotc,
    OPENCLAMDBLAS_FN_clAmdBlasZdotc,
    OPENCLAMDBLAS_FN_clAmdBlasSrotg,
    OPENCLAMDBLAS_FN_clAmdBlasDrotg,
    OPENCLAMDBLAS_FN_clAmdBlasCrotg,
    OPENCLAMDBLAS_FN_clAmdBlasZrotg,
    OPENCLAMDBLAS_FN_clAmdBlasSrotmg,
    OPENCLAMDBLAS_FN_clAmdBlasDrotmg,
    OPENCLAMDBLAS_FN_clAmdBlasSrot,
    OPENCLAMDBLAS_FN_clAmdBlasDrot,
    OPENCLAMDBLAS_FN_clAmdBlasCsrot,
    OPENCLAMDBLAS_FN_clAmdBlasZdrot,
    OPENCLAMDBLAS_FN_clAmdBlasSrotm,
    OPENCLAMDBLAS_FN_clAmdBlasDrotm,
    OPENCLAMDBLAS_FN_clAmdBlasSnrm2,
    OPENCLAMDBLAS_FN_clAmdBlasDnrm2,
    OPENCLAMDBLAS_FN_clAmdBlasScnrm2,
    OPENCLAMDBLAS_FN_clAmdBlasDznrm2,
    OPENCLAMDBLAS_FN_clAmdBlasiSamax,
    OPENCLAMDBLAS_FN_clAmdBlasiDamax,
    OPENCLAMDBLAS_FN_clAmdBlasiCamax,
    OPENCLAMDBLAS_FN_clAmdBlasiZamax,
    OPENCLAMDBLAS_FN_clAmdBlasSasum,
    OPENCLAMDBLAS_FN_clAmdBlasDasum,
    OPENCLAMDBLAS_FN_clAmdBlasScasum,
    OPENCLAMDBLAS_FN_clAmdBlasDzasum,
    OPENCLAMDBLAS_FN_clAmdBlasSgemv,
    OPENCLAMDBLAS_FN_clAmdBlasDgemv,
    OPENCLAMDBLAS_FN_clAmdBlasCgemv,
    OPENCLAMDBLAS_FN_clAmdBlasZgemv,
    OPENCLAMDBLAS_FN_clAmdBlasSgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasDgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasCgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasZgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsymv,
    OPENCLAMDBLAS_FN_clAmdBlasDsymv,
    OPENCLAMDBLAS_FN_clAmdBlasSsymvEx,
    OPENCLAMDBLAS_FN_clAmdBlasDsymvEx,
    OPENCLAMDBLAS_FN_clAmdBlasChemv,
    OPENCLAMDBLAS_FN_clAmdBlasZhemv,
    OPENCLAMDBLAS_FN_clAmdBlasStrmv,
    OPENCLAMDBLAS_FN_clAmdBlasDtrmv,
    OPENCLAMDBLAS_FN_clAmdBlasCtrmv,
    OPENCLAMDBLAS_FN_clAmdBlasZtrmv,
    OPENCLAMDBLAS_FN_clAmdBlasStrsv,
    OPENCLAMDBLAS_FN_clAmdBlasDtrsv,
    OPENCLAMDBLAS_FN_clAmdBlasCtrsv,
    OPENCLAMDBLAS_FN_clAmdBlasZtrsv,
    OPENCLAMDBLAS_FN_clAmdBlasSger,
    OPENCLAMDBLAS_FN_clAmdBlasDger,
    OPENCLAMDBLAS_FN_clAmdBlasCgeru,
    OPENCLAMDBLAS_FN_clAmdBlasZgeru,
    OPENCLAMDBLAS_FN_clAmdBlasCgerc,
    OPENCLAMDBLAS_FN_clAmdBlasZgerc,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr,
    OPENCLAMDBLAS_FN_clAmdBlasCher,
    OPENCLAMDBLAS_FN_clAmdBlasZher,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr2,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr2,
    OPENCLAMDBLAS_FN_clAmdBlasCher2,
    OPENCLAMDBLAS_FN_clAmdBlasZher2,
    OPENCLAMDBLAS_FN_clAmdBlasStpmv,
    OPENCLAMDBLAS_FN_clAmdBlasDtpmv,
    OPENCLAMDBLAS_FN_clAmdBlasCtpmv,
    OPENCLAMDBLAS_FN_clAmdBlasZtpmv,
    OPENCLAMDBLAS_FN_clAmdBlasStpsv,
    OPENCLAMDBLAS_FN_clAmdBlasDtpsv,
    OPENCLAMDBLAS_FN_clAmdBlasCtpsv,
    OPENCLAMDBLAS_FN_clAmdBlasZtpsv,
    OPENCLAMDBLAS_FN_clAmdBlasSspmv,
    OPENCLAMDBLAS_FN_clAmdBlasDspmv,
    OPENCLAMDBLAS_FN_clAmdBlasChpmv,
    OPENCLAMDBLAS_FN_clAmdBlasZhpmv,
    OPENCLAMDBLAS_FN_clAmdBlasSspr,
    OPENCLAMDBLAS_FN_clAmdBlasDspr,
    OPENCLAMDBLAS_FN_clAmdBlasChpr,
    OPENCLAMDBLAS_FN_clAmdBlasZhpr,
    OPENCLAMDBLAS_FN_clAmdBlasSspr2,
    OPENCLAMDBLAS_FN_clAmdBlasDspr2,
    OPENCLAMDBLAS_FN_clAmdBlasChpr2,
    OPENCLAMDBLAS_FN_clAmdBlasZhpr2,
    OPENCLAMDBLAS_FN_clAmdBlasSgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasDgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasCgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasZgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasStbmv,
    OPENCLAMDBLAS_FN_clAmdBlasDtbmv,
    OPENCLAMDBLAS_FN_clAmdBlasCtbmv,
    OPENCLAMDBLAS_FN_clAmdBlasZtbmv,
    OPENCLAMDBLAS_FN_clAmdBlasSsbmv,
    OPENCLAMDBLAS_FN_clAmdBlasDsbmv,
    OPENCLAMDBLAS_FN_clAmdBlasChbmv,
    OPENCLAMDBLAS_FN_clAmdBlasZhbmv,
    OPENCLAMDBLAS_FN_clAmdBlasStbsv,
    OPENCLAMDBLAS_FN_clAmdBlasDtbsv,
    OPENCLAMDBLAS_FN_clAmdBlasCtbsv,
    OPENCLAMDBLAS_FN_clAmdBlasZtbsv,
    OPENCLAMDBLAS_FN_clAmdBlasSgemm,
    OPENCLAMDBLAS_FN_clAmdBlasDgemm,
    OPENCLAMDBLAS_FN_clAmdBlasCgemm,
    OPENCLAMDBLAS_FN_clAmdBlasZgemm,
    OPENCLAMDBLAS_FN_clAmdBlasSgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasDgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasCgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasZgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasStrmm,
    OPENCLAMDBLAS_FN_clAmdBlasDtrmm,
    OPENCLAMDBLAS_FN_clAmdBlasCtrmm,
    OPENCLAMDBLAS_FN_clAmdBlasZtrmm,
    OPENCLAMDBLAS_FN_clAmdBlasStrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasDtrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasCtrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasZtrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasStrsm,
    OPENCLAMDBLAS_FN_clAmdBlasDtrsm,
    OPENCLAMDBLAS_FN_clAmdBlasCtrsm,
    OPENCLAMDBLAS_FN_clAmdBlasZtrsm,
    OPENCLAMDBLAS_FN_clAmdBlasStrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasDtrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasCtrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasZtrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasDsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasCsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasZsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasSsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasDsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasCsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasZsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasCsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasZsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasCsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasZsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsymm,
    OPENCLAMDBLAS_FN_clAmdBlasDsymm,
    OPENCLAMDBLAS_FN_clAmdBlasCsymm,
    OPENCLAMDBLAS_FN_clAmdBlasZsymm,
    OPENCLAMDBLAS_FN_clAmdBlasChemm,
    OPENCLAMDBLAS_FN_clAmdBlasZhemm,
    OPENCLAMDBLAS_FN_clAmdBlasCherk,
    OPENCLAMDBLAS_FN_clAmdBlasZherk,
    OPENCLAMDBLAS_FN_clAmdBlasCher2k,
    OPENCLAMDBLAS_FN_clAmdBlasZher2k,
};
// generated by parser_clamdblas.py
const char* openclamdblas_fn_names[] = {
    "clAmdBlasGetVersion",
    "clAmdBlasSetup",
    "clAmdBlasTeardown",
    "clAmdBlasAddScratchImage",
    "clAmdBlasRemoveScratchImage",
    "clAmdBlasSswap",
    "clAmdBlasDswap",
    "clAmdBlasCswap",
    "clAmdBlasZswap",
    "clAmdBlasSscal",
    "clAmdBlasDscal",
    "clAmdBlasCscal",
    "clAmdBlasZscal",
    "clAmdBlasCsscal",
    "clAmdBlasZdscal",
    "clAmdBlasScopy",
    "clAmdBlasDcopy",
    "clAmdBlasCcopy",
    "clAmdBlasZcopy",
    "clAmdBlasSaxpy",
    "clAmdBlasDaxpy",
    "clAmdBlasCaxpy",
    "clAmdBlasZaxpy",
    "clAmdBlasSdot",
    "clAmdBlasDdot",
    "clAmdBlasCdotu",
    "clAmdBlasZdotu",
    "clAmdBlasCdotc",
    "clAmdBlasZdotc",
    "clAmdBlasSrotg",
    "clAmdBlasDrotg",
    "clAmdBlasCrotg",
    "clAmdBlasZrotg",
    "clAmdBlasSrotmg",
    "clAmdBlasDrotmg",
    "clAmdBlasSrot",
    "clAmdBlasDrot",
    "clAmdBlasCsrot",
    "clAmdBlasZdrot",
    "clAmdBlasSrotm",
    "clAmdBlasDrotm",
    "clAmdBlasSnrm2",
    "clAmdBlasDnrm2",
    "clAmdBlasScnrm2",
    "clAmdBlasDznrm2",
    "clAmdBlasiSamax",
    "clAmdBlasiDamax",
    "clAmdBlasiCamax",
    "clAmdBlasiZamax",
    "clAmdBlasSasum",
    "clAmdBlasDasum",
    "clAmdBlasScasum",
    "clAmdBlasDzasum",
    "clAmdBlasSgemv",
    "clAmdBlasDgemv",
    "clAmdBlasCgemv",
    "clAmdBlasZgemv",
    "clAmdBlasSgemvEx",
    "clAmdBlasDgemvEx",
    "clAmdBlasCgemvEx",
    "clAmdBlasZgemvEx",
    "clAmdBlasSsymv",
    "clAmdBlasDsymv",
    "clAmdBlasSsymvEx",
    "clAmdBlasDsymvEx",
    "clAmdBlasChemv",
    "clAmdBlasZhemv",
    "clAmdBlasStrmv",
    "clAmdBlasDtrmv",
    "clAmdBlasCtrmv",
    "clAmdBlasZtrmv",
    "clAmdBlasStrsv",
    "clAmdBlasDtrsv",
    "clAmdBlasCtrsv",
    "clAmdBlasZtrsv",
    "clAmdBlasSger",
    "clAmdBlasDger",
    "clAmdBlasCgeru",
    "clAmdBlasZgeru",
    "clAmdBlasCgerc",
    "clAmdBlasZgerc",
    "clAmdBlasSsyr",
    "clAmdBlasDsyr",
    "clAmdBlasCher",
    "clAmdBlasZher",
    "clAmdBlasSsyr2",
    "clAmdBlasDsyr2",
    "clAmdBlasCher2",
    "clAmdBlasZher2",
    "clAmdBlasStpmv",
    "clAmdBlasDtpmv",
    "clAmdBlasCtpmv",
    "clAmdBlasZtpmv",
    "clAmdBlasStpsv",
    "clAmdBlasDtpsv",
    "clAmdBlasCtpsv",
    "clAmdBlasZtpsv",
    "clAmdBlasSspmv",
    "clAmdBlasDspmv",
    "clAmdBlasChpmv",
    "clAmdBlasZhpmv",
    "clAmdBlasSspr",
    "clAmdBlasDspr",
    "clAmdBlasChpr",
    "clAmdBlasZhpr",
    "clAmdBlasSspr2",
    "clAmdBlasDspr2",
    "clAmdBlasChpr2",
    "clAmdBlasZhpr2",
    "clAmdBlasSgbmv",
    "clAmdBlasDgbmv",
    "clAmdBlasCgbmv",
    "clAmdBlasZgbmv",
    "clAmdBlasStbmv",
    "clAmdBlasDtbmv",
    "clAmdBlasCtbmv",
    "clAmdBlasZtbmv",
    "clAmdBlasSsbmv",
    "clAmdBlasDsbmv",
    "clAmdBlasChbmv",
    "clAmdBlasZhbmv",
    "clAmdBlasStbsv",
    "clAmdBlasDtbsv",
    "clAmdBlasCtbsv",
    "clAmdBlasZtbsv",
    "clAmdBlasSgemm",
    "clAmdBlasDgemm",
    "clAmdBlasCgemm",
    "clAmdBlasZgemm",
    "clAmdBlasSgemmEx",
    "clAmdBlasDgemmEx",
    "clAmdBlasCgemmEx",
    "clAmdBlasZgemmEx",
    "clAmdBlasStrmm",
    "clAmdBlasDtrmm",
    "clAmdBlasCtrmm",
    "clAmdBlasZtrmm",
    "clAmdBlasStrmmEx",
    "clAmdBlasDtrmmEx",
    "clAmdBlasCtrmmEx",
    "clAmdBlasZtrmmEx",
    "clAmdBlasStrsm",
    "clAmdBlasDtrsm",
    "clAmdBlasCtrsm",
    "clAmdBlasZtrsm",
    "clAmdBlasStrsmEx",
    "clAmdBlasDtrsmEx",
    "clAmdBlasCtrsmEx",
    "clAmdBlasZtrsmEx",
    "clAmdBlasSsyrk",
    "clAmdBlasDsyrk",
    "clAmdBlasCsyrk",
    "clAmdBlasZsyrk",
    "clAmdBlasSsyrkEx",
    "clAmdBlasDsyrkEx",
    "clAmdBlasCsyrkEx",
    "clAmdBlasZsyrkEx",
    "clAmdBlasSsyr2k",
    "clAmdBlasDsyr2k",
    "clAmdBlasCsyr2k",
    "clAmdBlasZsyr2k",
    "clAmdBlasSsyr2kEx",
    "clAmdBlasDsyr2kEx",
    "clAmdBlasCsyr2kEx",
    "clAmdBlasZsyr2kEx",
    "clAmdBlasSsymm",
    "clAmdBlasDsymm",
    "clAmdBlasCsymm",
    "clAmdBlasZsymm",
    "clAmdBlasChemm",
    "clAmdBlasZhemm",
    "clAmdBlasCherk",
    "clAmdBlasZherk",
    "clAmdBlasCher2k",
    "clAmdBlasZher2k",
};

static void* openclamdblas_check_fn(int ID)
{
    void* func = CV_CL_GET_PROC_ADDRESS(openclamdblas_fn_names[ID]);
    if (!func)
    {
        std::ostringstream msg;
        msg << "OpenCL AMD BLAS function is not available: [" << openclamdblas_fn_names[ID] << "]";
        CV_Error(CV_StsBadFunc, msg.str());
    }
    extern void* openclamdblas_fn_ptrs[];
    *(void**)(openclamdblas_fn_ptrs[ID]) = func;
    return func;
}

namespace {
// generated by parser_clamdblas.py
template <int ID, typename _R>
struct openclamdblas_fn0
{
    typedef _R (*FN)();
    static _R switch_fn()
    { return ((FN)openclamdblas_check_fn(ID))(); }
};

template <int ID, typename _R, typename _T1>
struct openclamdblas_fn1
{
    typedef _R (*FN)(_T1);
    static _R switch_fn(_T1 p1)
    { return ((FN)openclamdblas_check_fn(ID))(p1); }
};

template <int ID, typename _R, typename _T1, typename _T2>
struct openclamdblas_fn2
{
    typedef _R (*FN)(_T1, _T2);
    static _R switch_fn(_T1 p1, _T2 p2)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3>
struct openclamdblas_fn3
{
    typedef _R (*FN)(_T1, _T2, _T3);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4>
struct openclamdblas_fn4
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5>
struct openclamdblas_fn5
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6>
struct openclamdblas_fn6
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7>
struct openclamdblas_fn7
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8>
struct openclamdblas_fn8
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9>
struct openclamdblas_fn9
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10>
struct openclamdblas_fn10
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11>
struct openclamdblas_fn11
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12>
struct openclamdblas_fn12
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13>
struct openclamdblas_fn13
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14>
struct openclamdblas_fn14
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15>
struct openclamdblas_fn15
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16>
struct openclamdblas_fn16
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16, typename _T17>
struct openclamdblas_fn17
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16, _T17);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16, _T17 p17)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16, typename _T17, typename _T18>
struct openclamdblas_fn18
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16, _T17, _T18);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16, _T17 p17, _T18 p18)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16, typename _T17, typename _T18, typename _T19>
struct openclamdblas_fn19
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16, _T17, _T18, _T19);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16, _T17 p17, _T18 p18, _T19 p19)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16, typename _T17, typename _T18, typename _T19, typename _T20>
struct openclamdblas_fn20
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16, _T17, _T18, _T19, _T20);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16, _T17 p17, _T18 p18, _T19 p19, _T20 p20)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16, typename _T17, typename _T18, typename _T19, typename _T20, typename _T21>
struct openclamdblas_fn21
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16, _T17, _T18, _T19, _T20, _T21);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16, _T17 p17, _T18 p18, _T19 p19, _T20 p20, _T21 p21)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21); }
};

template <int ID, typename _R, typename _T1, typename _T2, typename _T3, typename _T4, typename _T5, typename _T6, typename _T7, typename _T8, typename _T9, typename _T10, typename _T11, typename _T12, typename _T13, typename _T14, typename _T15, typename _T16, typename _T17, typename _T18, typename _T19, typename _T20, typename _T21, typename _T22>
struct openclamdblas_fn22
{
    typedef _R (*FN)(_T1, _T2, _T3, _T4, _T5, _T6, _T7, _T8, _T9, _T10, _T11, _T12, _T13, _T14, _T15, _T16, _T17, _T18, _T19, _T20, _T21, _T22);
    static _R switch_fn(_T1 p1, _T2 p2, _T3 p3, _T4 p4, _T5 p5, _T6 p6, _T7 p7, _T8 p8, _T9 p9, _T10 p10, _T11 p11, _T12 p12, _T13 p13, _T14 p14, _T15 p15, _T16 p16, _T17 p17, _T18 p18, _T19 p19, _T20 p20, _T21 p21, _T22 p22)
    { return ((FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22); }
};

}

// generated by parser_clamdblas.py
clAmdBlasStatus (*clAmdBlasGetVersion)(cl_uint*, cl_uint*, cl_uint*) = openclamdblas_fn3<OPENCLAMDBLAS_FN_clAmdBlasGetVersion, clAmdBlasStatus, cl_uint*, cl_uint*, cl_uint*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSetup)() = openclamdblas_fn0<OPENCLAMDBLAS_FN_clAmdBlasSetup, clAmdBlasStatus>::switch_fn;
void (*clAmdBlasTeardown)() = openclamdblas_fn0<OPENCLAMDBLAS_FN_clAmdBlasTeardown, void>::switch_fn;
cl_ulong (*clAmdBlasAddScratchImage)(cl_context, size_t, size_t, clAmdBlasStatus*) = openclamdblas_fn4<OPENCLAMDBLAS_FN_clAmdBlasAddScratchImage, cl_ulong, cl_context, size_t, size_t, clAmdBlasStatus*>::switch_fn;
clAmdBlasStatus (*clAmdBlasRemoveScratchImage)(cl_ulong) = openclamdblas_fn1<OPENCLAMDBLAS_FN_clAmdBlasRemoveScratchImage, clAmdBlasStatus, cl_ulong>::switch_fn;
clAmdBlasStatus (*clAmdBlasSswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasSswap, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasDswap, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasCswap, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasZswap, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSscal)(size_t, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn10<OPENCLAMDBLAS_FN_clAmdBlasSscal, clAmdBlasStatus, size_t, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDscal)(size_t, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn10<OPENCLAMDBLAS_FN_clAmdBlasDscal, clAmdBlasStatus, size_t, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCscal)(size_t, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn10<OPENCLAMDBLAS_FN_clAmdBlasCscal, clAmdBlasStatus, size_t, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZscal)(size_t, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn10<OPENCLAMDBLAS_FN_clAmdBlasZscal, clAmdBlasStatus, size_t, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsscal)(size_t, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn10<OPENCLAMDBLAS_FN_clAmdBlasCsscal, clAmdBlasStatus, size_t, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZdscal)(size_t, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn10<OPENCLAMDBLAS_FN_clAmdBlasZdscal, clAmdBlasStatus, size_t, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasScopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasScopy, clAmdBlasStatus, size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDcopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasDcopy, clAmdBlasStatus, size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCcopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasCcopy, clAmdBlasStatus, size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZcopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasZcopy, clAmdBlasStatus, size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSaxpy)(size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasSaxpy, clAmdBlasStatus, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDaxpy)(size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasDaxpy, clAmdBlasStatus, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCaxpy)(size_t, cl_float2, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasCaxpy, clAmdBlasStatus, size_t, cl_float2, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZaxpy)(size_t, cl_double2, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasZaxpy, clAmdBlasStatus, size_t, cl_double2, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSdot)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasSdot, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDdot)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasDdot, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCdotu)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasCdotu, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZdotu)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasZdotu, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCdotc)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasCdotc, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZdotc)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasZdotc, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasSrotg, clAmdBlasStatus, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasDrotg, clAmdBlasStatus, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasCrotg, clAmdBlasStatus, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn13<OPENCLAMDBLAS_FN_clAmdBlasZrotg, clAmdBlasStatus, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSrotmg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasSrotmg, clAmdBlasStatus, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDrotmg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasDrotmg, clAmdBlasStatus, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_float, cl_float, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasSrot, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_float, cl_float, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_double, cl_double, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasDrot, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_double, cl_double, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_float, cl_float, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasCsrot, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_float, cl_float, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZdrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_double, cl_double, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasZdrot, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_double, cl_double, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSrotm)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, const cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasSrotm, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, const cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDrotm)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, const cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasDrotm, clAmdBlasStatus, size_t, cl_mem, size_t, int, cl_mem, size_t, int, const cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSnrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasSnrm2, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDnrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasDnrm2, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasScnrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasScnrm2, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDznrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasDznrm2, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasiSamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasiSamax, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasiDamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasiDamax, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasiCamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasiCamax, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasiZamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasiZamax, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasSasum, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasDasum, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasScasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasScasum, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDzasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn12<OPENCLAMDBLAS_FN_clAmdBlasDzasum, clAmdBlasStatus, size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasSgemv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasDgemv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasCgemv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasZgemv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasSgemvEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasDgemvEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasCgemvEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasZgemvEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsymv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasSsymv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsymv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDsymv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsymvEx)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasSsymvEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsymvEx)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasDsymvEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasChemv)(clAmdBlasOrder, clAmdBlasUplo, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasChemv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZhemv)(clAmdBlasOrder, clAmdBlasUplo, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasZhemv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasStrmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasDtrmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasCtrmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasZtrmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasStrsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasDtrsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasCtrsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasZtrsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSger)(clAmdBlasOrder, size_t, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasSger, clAmdBlasStatus, clAmdBlasOrder, size_t, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDger)(clAmdBlasOrder, size_t, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDger, clAmdBlasStatus, clAmdBlasOrder, size_t, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgeru)(clAmdBlasOrder, size_t, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCgeru, clAmdBlasStatus, clAmdBlasOrder, size_t, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgeru)(clAmdBlasOrder, size_t, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZgeru, clAmdBlasStatus, clAmdBlasOrder, size_t, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgerc)(clAmdBlasOrder, size_t, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCgerc, clAmdBlasStatus, clAmdBlasOrder, size_t, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgerc)(clAmdBlasOrder, size_t, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZgerc, clAmdBlasStatus, clAmdBlasOrder, size_t, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsyr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasSsyr, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsyr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasDsyr, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCher)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasCher, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZher)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasZher, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsyr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasSsyr2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsyr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDsyr2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCher2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCher2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZher2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZher2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasStpmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasDtpmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasCtpmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasZtpmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasStpsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasDtpsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasCtpsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn15<OPENCLAMDBLAS_FN_clAmdBlasZtpsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSspmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasSspmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDspmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDspmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasChpmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasChpmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZhpmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZhpmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSspr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasSspr, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDspr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasDspr, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasChpr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasChpr, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZhpr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn14<OPENCLAMDBLAS_FN_clAmdBlasZhpr, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSspr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasSspr2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDspr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasDspr2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasChpr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasChpr2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZhpr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasZhpr2, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasSgbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasDgbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasCgbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasZgbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasStbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDtbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCtbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZtbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasSsbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasDsbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasChbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasChbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZhbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn20<OPENCLAMDBLAS_FN_clAmdBlasZhbmv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasStbsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasDtbsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasCtbsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasZtbsv, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasSgemm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasDgemm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasCgemm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasZgemm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasSgemmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasDgemmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasCgemmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn22<OPENCLAMDBLAS_FN_clAmdBlasZgemmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasStrmm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasDtrmm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasCtrmm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasZtrmm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasStrmmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasDtrmmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasCtrmmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasZtrmmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasStrsm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasDtrsm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasCtrsm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn17<OPENCLAMDBLAS_FN_clAmdBlasZtrsm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasStrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasStrsmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDtrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasDtrsmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCtrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasCtrsmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZtrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn19<OPENCLAMDBLAS_FN_clAmdBlasZtrsmEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasSsyrk, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasDsyrk, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasCsyrk, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn16<OPENCLAMDBLAS_FN_clAmdBlasZsyrk, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasSsyrkEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDsyrkEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCsyrkEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZsyrkEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasSsyr2k, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasDsyr2k, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCsyr2k, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZsyr2k, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasSsyr2kEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasDsyr2kEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasCsyr2kEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasZsyr2kEx, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasSsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasSsymm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasDsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasDsymm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasCsymm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasZsymm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasChemm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasChemm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZhemm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasZhemm, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCherk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, float, const cl_mem, size_t, size_t, float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasCherk, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, float, const cl_mem, size_t, size_t, float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZherk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, double, const cl_mem, size_t, size_t, double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn18<OPENCLAMDBLAS_FN_clAmdBlasZherk, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, double, const cl_mem, size_t, size_t, double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasCher2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasCher2k, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;
clAmdBlasStatus (*clAmdBlasZher2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) = openclamdblas_fn21<OPENCLAMDBLAS_FN_clAmdBlasZher2k, clAmdBlasStatus, clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*>::switch_fn;

// generated by parser_clamdblas.py
void* openclamdblas_fn_ptrs[] = {
    &clAmdBlasGetVersion,
    &clAmdBlasSetup,
    &clAmdBlasTeardown,
    &clAmdBlasAddScratchImage,
    &clAmdBlasRemoveScratchImage,
    &clAmdBlasSswap,
    &clAmdBlasDswap,
    &clAmdBlasCswap,
    &clAmdBlasZswap,
    &clAmdBlasSscal,
    &clAmdBlasDscal,
    &clAmdBlasCscal,
    &clAmdBlasZscal,
    &clAmdBlasCsscal,
    &clAmdBlasZdscal,
    &clAmdBlasScopy,
    &clAmdBlasDcopy,
    &clAmdBlasCcopy,
    &clAmdBlasZcopy,
    &clAmdBlasSaxpy,
    &clAmdBlasDaxpy,
    &clAmdBlasCaxpy,
    &clAmdBlasZaxpy,
    &clAmdBlasSdot,
    &clAmdBlasDdot,
    &clAmdBlasCdotu,
    &clAmdBlasZdotu,
    &clAmdBlasCdotc,
    &clAmdBlasZdotc,
    &clAmdBlasSrotg,
    &clAmdBlasDrotg,
    &clAmdBlasCrotg,
    &clAmdBlasZrotg,
    &clAmdBlasSrotmg,
    &clAmdBlasDrotmg,
    &clAmdBlasSrot,
    &clAmdBlasDrot,
    &clAmdBlasCsrot,
    &clAmdBlasZdrot,
    &clAmdBlasSrotm,
    &clAmdBlasDrotm,
    &clAmdBlasSnrm2,
    &clAmdBlasDnrm2,
    &clAmdBlasScnrm2,
    &clAmdBlasDznrm2,
    &clAmdBlasiSamax,
    &clAmdBlasiDamax,
    &clAmdBlasiCamax,
    &clAmdBlasiZamax,
    &clAmdBlasSasum,
    &clAmdBlasDasum,
    &clAmdBlasScasum,
    &clAmdBlasDzasum,
    &clAmdBlasSgemv,
    &clAmdBlasDgemv,
    &clAmdBlasCgemv,
    &clAmdBlasZgemv,
    &clAmdBlasSgemvEx,
    &clAmdBlasDgemvEx,
    &clAmdBlasCgemvEx,
    &clAmdBlasZgemvEx,
    &clAmdBlasSsymv,
    &clAmdBlasDsymv,
    &clAmdBlasSsymvEx,
    &clAmdBlasDsymvEx,
    &clAmdBlasChemv,
    &clAmdBlasZhemv,
    &clAmdBlasStrmv,
    &clAmdBlasDtrmv,
    &clAmdBlasCtrmv,
    &clAmdBlasZtrmv,
    &clAmdBlasStrsv,
    &clAmdBlasDtrsv,
    &clAmdBlasCtrsv,
    &clAmdBlasZtrsv,
    &clAmdBlasSger,
    &clAmdBlasDger,
    &clAmdBlasCgeru,
    &clAmdBlasZgeru,
    &clAmdBlasCgerc,
    &clAmdBlasZgerc,
    &clAmdBlasSsyr,
    &clAmdBlasDsyr,
    &clAmdBlasCher,
    &clAmdBlasZher,
    &clAmdBlasSsyr2,
    &clAmdBlasDsyr2,
    &clAmdBlasCher2,
    &clAmdBlasZher2,
    &clAmdBlasStpmv,
    &clAmdBlasDtpmv,
    &clAmdBlasCtpmv,
    &clAmdBlasZtpmv,
    &clAmdBlasStpsv,
    &clAmdBlasDtpsv,
    &clAmdBlasCtpsv,
    &clAmdBlasZtpsv,
    &clAmdBlasSspmv,
    &clAmdBlasDspmv,
    &clAmdBlasChpmv,
    &clAmdBlasZhpmv,
    &clAmdBlasSspr,
    &clAmdBlasDspr,
    &clAmdBlasChpr,
    &clAmdBlasZhpr,
    &clAmdBlasSspr2,
    &clAmdBlasDspr2,
    &clAmdBlasChpr2,
    &clAmdBlasZhpr2,
    &clAmdBlasSgbmv,
    &clAmdBlasDgbmv,
    &clAmdBlasCgbmv,
    &clAmdBlasZgbmv,
    &clAmdBlasStbmv,
    &clAmdBlasDtbmv,
    &clAmdBlasCtbmv,
    &clAmdBlasZtbmv,
    &clAmdBlasSsbmv,
    &clAmdBlasDsbmv,
    &clAmdBlasChbmv,
    &clAmdBlasZhbmv,
    &clAmdBlasStbsv,
    &clAmdBlasDtbsv,
    &clAmdBlasCtbsv,
    &clAmdBlasZtbsv,
    &clAmdBlasSgemm,
    &clAmdBlasDgemm,
    &clAmdBlasCgemm,
    &clAmdBlasZgemm,
    &clAmdBlasSgemmEx,
    &clAmdBlasDgemmEx,
    &clAmdBlasCgemmEx,
    &clAmdBlasZgemmEx,
    &clAmdBlasStrmm,
    &clAmdBlasDtrmm,
    &clAmdBlasCtrmm,
    &clAmdBlasZtrmm,
    &clAmdBlasStrmmEx,
    &clAmdBlasDtrmmEx,
    &clAmdBlasCtrmmEx,
    &clAmdBlasZtrmmEx,
    &clAmdBlasStrsm,
    &clAmdBlasDtrsm,
    &clAmdBlasCtrsm,
    &clAmdBlasZtrsm,
    &clAmdBlasStrsmEx,
    &clAmdBlasDtrsmEx,
    &clAmdBlasCtrsmEx,
    &clAmdBlasZtrsmEx,
    &clAmdBlasSsyrk,
    &clAmdBlasDsyrk,
    &clAmdBlasCsyrk,
    &clAmdBlasZsyrk,
    &clAmdBlasSsyrkEx,
    &clAmdBlasDsyrkEx,
    &clAmdBlasCsyrkEx,
    &clAmdBlasZsyrkEx,
    &clAmdBlasSsyr2k,
    &clAmdBlasDsyr2k,
    &clAmdBlasCsyr2k,
    &clAmdBlasZsyr2k,
    &clAmdBlasSsyr2kEx,
    &clAmdBlasDsyr2kEx,
    &clAmdBlasCsyr2kEx,
    &clAmdBlasZsyr2kEx,
    &clAmdBlasSsymm,
    &clAmdBlasDsymm,
    &clAmdBlasCsymm,
    &clAmdBlasZsymm,
    &clAmdBlasChemm,
    &clAmdBlasZhemm,
    &clAmdBlasCherk,
    &clAmdBlasZherk,
    &clAmdBlasCher2k,
    &clAmdBlasZher2k,
};

#endif
