// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_EntityList_HeaderFile
#define _Interface_EntityList_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
class Standard_Transient;
class Standard_OutOfRange;
class Interface_InterfaceError;
class Standard_NullObject;
class Interface_EntityIterator;
class Standard_Type;


//! This class defines a list of Entities (Transient Objects), <br>
//!           it can be used as a field of other Transient classes, with <br>
//!           these features : <br>
//!           - oriented to define a little list, that is, slower than an <br>
//!             Array or a Map of Entities for a big count (about 100 and <br>
//!             over), but faster than a Sequence <br>
//!           - allows to work as a Sequence, limited to Clear, Append, <br>
//!             Remove, Access to an Item identified by its rank in the list <br>
//!           - space saving, compared to a Sequence, especially for little <br>
//!             amounts; better than an Array for a very little amount (less <br>
//!             than 10) but less good for a greater amount <br>
//! <br>
//!           Works in conjunction with EntityCluster <br>
//!           An EntityList gives access to a list of Entity Clusters, which <br>
//!           are chained (in one sense : Single List) <br>
//!           Remark : a new Item may not be Null, because this is the <br>
//!           criterium used for "End of List" <br>
class Interface_EntityList  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates a List as beeing empty <br>
  Standard_EXPORT   Interface_EntityList();
  //! Clears the List <br>
  Standard_EXPORT     void Clear() ;
  //! Appends an Entity, that is to the END of the list <br>
//!           (keeps order, but works slowerly than Add, see below) <br>
  Standard_EXPORT     void Append(const Handle(Standard_Transient)& ent) ;
  //! Adds an Entity to the list, that is, with NO REGARD about the <br>
//!           order (faster than Append if count becomes greater than 10) <br>
  Standard_EXPORT     void Add(const Handle(Standard_Transient)& ent) ;
  //! Removes an Entity from the list, if it is there <br>
  Standard_EXPORT     void Remove(const Handle(Standard_Transient)& ent) ;
  //! Removes an Entity from the list, given its rank <br>
  Standard_EXPORT     void Remove(const Standard_Integer num) ;
  //! Returns True if the list is empty <br>
  Standard_EXPORT     Standard_Boolean IsEmpty() const;
  //! Returns count of recorded Entities <br>
  Standard_EXPORT     Standard_Integer NbEntities() const;
  //! Returns an Item given its number. Beware about the way the <br>
//!           list was filled (see above, Add and Append) <br>
  Standard_EXPORT    const Handle_Standard_Transient& Value(const Standard_Integer num) const;
  //! Returns an Item given its number. Beware about the way the <br>
//!           list was filled (see above, Add and Append) <br>
  Standard_EXPORT     void SetValue(const Standard_Integer num,const Handle(Standard_Transient)& ent) ;
  //! fills an Iterator with the content of the list <br>
//!           (normal way to consult a list which has been filled with Add) <br>
  Standard_EXPORT     void FillIterator(Interface_EntityIterator& iter) const;
  //! Returns count of Entities of a given Type (0 : none) <br>
  Standard_EXPORT     Standard_Integer NbTypedEntities(const Handle(Standard_Type)& atype) const;
  //! Returns the Entity which is of a given type. <br>
//!           If num = 0 (D), there must be ONE AND ONLY ONE <br>
//!           If num > 0, returns the num-th entity of this type <br>
  Standard_EXPORT     Handle_Standard_Transient TypedEntity(const Handle(Standard_Type)& atype,const Standard_Integer num = 0) const;





protected:





private:



Handle_Standard_Transient theval;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
