      logical function tce_property(rtdb)
c
c $Id: tce_property.F 19706 2010-10-29 17:52:31Z d3y133 $
c
c Main routine for many-electron theory calculations.
c Some of the subroutines have been generated by
c operator/tensor contraction engines.
c
c Written by Jeff Hammond, January 2008.
c
      implicit none
#include "mafdecls.fh"
#include "tcgmsg.fh"
#include "global.fh"
#include "bas.fh"
#include "geom.fh"
#include "rtdb.fh"
#include "sym.fh"
#include "util.fh"
#include "msgids.fh"
#include "stdio.fh"
#include "sf.fh"
#include "inp.fh"
#include "errquit.fh"
#include "tce.fh"
#include "tce_main.fh"
#include "tce_prop.fh"
#include "tce_ints.fh"
#include "tce_amps.fh"
#include "tce_diis.fh"
c
c     CI, CC, & MBPT
c
      integer rtdb             ! Run-time database
      logical nodezero,recompf,debugprint
      double precision cpu,wall
      integer irrep
      integer irrep_g
      double precision ref,corr
      double precision r1,r2,r3,r4,residual
      integer i,j,dummy
      integer l_shell,l_subshell,l_sh_size
      character*255 filename
      character*8 title
      character*20 dtitle      ! Title to pass to drivers
      character*4 irrepname
      logical dft_energy,scf
      external dft_energy,scf
      logical tce_ccsd_driver
      external tce_ccsd_driver
      logical tce_ccsdt_driver
      external tce_ccsdt_driver
      logical tce_ccsdtq_driver
      external tce_ccsdtq_driver
      logical tce_ccsd_lambda_driver
      external tce_ccsd_lambda_driver
      logical tce_ccsdt_lambda_driver
      external tce_ccsdt_lambda_driver
      logical tce_ccsdtq_lambda_driver
      external tce_ccsdtq_lambda_driver
      logical tce_ccsd_response_driver
      external tce_ccsd_response_driver
      logical tce_ccsdt_response_driver
      external tce_ccsdt_response_driver
      logical tce_ccsdtq_response_driver
      external tce_ccsdtq_response_driver
      double precision tce_ccsd_symm_polar
      external tce_ccsd_symm_polar
      logical tce_ccsd_lambda_response_driver
      external tce_ccsd_lambda_response_driver
      double precision tce_ccsd_asym_polar
      external tce_ccsd_asym_polar
      double precision tce_ccsdt_symm_polar
      external tce_ccsdt_symm_polar
      double precision tce_ccsdtq_symm_polar
      external tce_ccsdtq_symm_polar
      double precision rr1        ! Residual tr1
      double precision rr2        ! Residual tr2
      double precision rr3        ! Residual tr3
      double precision rr4        ! Residual tr4
      double precision omega       ! The frequency used in (A-Iw)x=b
      double precision lambda      ! The damping of Ab in (A^2-Iw^2)+lambda*Ab=0
      double precision omega1     ! The frequency used in (A-Iw)x=b
      double precision omega2     ! The frequency used in (A-Iw)x=b
      double precision omega3     ! The frequency used in (A-Iw)x=b
      integer omegacount,omegasign,dynfreq,dynaxis
      integer axisA,axisB,axisC,axisD
      integer d_a0                ! Dipole polarizability component handle
      integer l_a0_offset         ! Offset for a0 file
      integer k_a0_offset         ! Offset for a0 file
      integer size_a0             ! File size in doubles
      double precision alpha(3,3) ! Dipole polarizability tensor
      double precision alpha1     ! Dipole polarizability term 1
      double precision alpha2     ! Dipole polarizability term 2
      double precision alpha3     ! Dipole polarizability term 3
      double precision alpha4     ! Dipole polarizability term 4
      integer d_b0                ! Dipole hyperpolarizability component handle
      integer l_b0_offset         ! Offset for b0 file
      integer k_b0_offset         ! Offset for b0 file
      integer size_b0             ! File size in doubles
      double precision beta(3,3,3)! Dipole hyperpolarizability tensor
      double precision beta1      ! Dipole hyperpolarizability term 1
      double precision beta2      ! Dipole hyperpolarizability term 2
      double precision beta3      ! Dipole hyperpolarizability term 3
      double precision beta4      ! Dipole hyperpolarizability term 4
      integer d_g0                ! Dipole second hyperpolarizability component handle
      integer l_g0_offset         ! Offset for g0 file
      integer k_g0_offset         ! Offset for g0 file
      integer size_g0             ! File size in doubles
      double precision gamm(3,3,3,3)! Dipole second hyperpolarizability tensor (gamma not safe variable name)
      double precision gamm1        ! Dipole second hyperpolarizability term 1
      double precision gamm2        ! Dipole second hyperpolarizability term 2
      double precision gamm3        ! Dipole second hyperpolarizability term 3
      double precision gamm4        ! Dipole second hyperpolarizability term 4
      double precision dipole_scf(3),dipole_cor(3),dipole_exc(3)
      double precision cdipole   ! Dipole moment correlation
      double precision ddotfile
      external ddotfile
      integer sym_abelian_axis ! Move this and the following to "sym.fh"
      external sym_abelian_axis
      integer irrep_d1(3)
      double precision au2ev   ! Conversion factor from a.u. to eV
c      double precision numerator   ! <L|D exp(T)|R>
c      double precision denominator ! <L|exp(T)|R>
c      double precision transition(3) ! Transition moments
      parameter (au2ev=27.2113961d0)
      character*255 modelname
      integer type,dim1,dim2
      nodezero=(ga_nodeid().eq.0)
      tce_property = .false.
#ifdef TURN_ON
c
c     =========================
c     Ground-state HF/DFT first
c     =========================
c
      call tce_reference_check(rtdb,ref)
c
c     ===================
c     Print utility start
c     ===================
c
      call util_print_push
      call util_print_rtdb_load(rtdb,'tce')
c
c     ==========
c     Initialize
c     ==========
c
      call tce_init_new(rtdb)
c
c     ===================
c     Initializing irreps
c     ===================
c
      irrep_x = 0
      irrep_y = 0
      irrep_c = 0
      irrep_g = 0
c
c     ==============
c     Create a mutex
c     ==============
c
      if (.not.ga_create_mutexes(1))
     1  call errquit('tce_property: GA problem',0,GA_ERR)
c
c     =========================
c     Reorder and tile orbitals
c     =========================
c
      call tce_tile_new(rtdb)
      call sf_test
c
c     ================================
c     Parallel integral transformation
c     ================================
c
      call tce_fock_create(rtdb,d_f1,l_f1_offset,k_f1_offset)
      call tce_multipole_create(rtdb,d_d1,l_d1_offset,k_d1_offset)
      call tce_fourindex_driver(rtdb,d_v2,l_v2_offset,k_v2_offset)
c
c     ====================
c     Initial t amplitudes
c     ====================
c
      needt1 = .false.
      needt2 = .false.
      needt3 = .false.
      needt4 = .false.
      if (model.eq.'ccsd') then
        needt1 = .true.
        needt2 = .true.
      else if (model.eq.'ccsdt') then
        needt1 = .true.
        needt2 = .true.
        needt3 = .true.
      else if (model.eq.'ccsdtq') then
        needt1 = .true.
        needt2 = .true.
        needt3 = .true.
        needt4 = .true.
      endif
c
c     t1 amplitudes
c
      if (needt1) then
        call tce_create_t1(d_t1,l_t1_offset,k_t1_offset,
     &                     size_t1,irrep_t,'t1      ')
        if (left) then
          call tce_create_y1(d_lambda1,l_l1_offset,k_l1_offset,
     &                       size_l1,irrep_t,'lambda1 ')
        endif
        if (lineresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_x1(d_tr1(axis),l_tr1_offset(axis),
     1           k_tr1_offset(axis),size_tr1(axis),
     2           sym_abelian_axis(geom,axis),tr1filename(axis))
            call tce_clone_x1(d_tr1(axis+3),size_tr1(axis),
     1           sym_abelian_axis(geom,axis),tr1filename(axis+3))
            call tce_clone_x1(d_tr1(axis+6),size_tr1(axis),
     1           sym_abelian_axis(geom,axis),tr1filename(axis+6))
            call tce_clone_x1(d_tr1(axis+9),size_tr1(axis),
     1           sym_abelian_axis(geom,axis),tr1filename(axis+9))
          endif
          enddo ! axis
        endif ! lineresp
        if (leftresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_y1(d_yr1(axis),l_yr1_offset(axis),
     1           k_yr1_offset(axis),size_yr1(axis),
     2           sym_abelian_axis(geom,axis),yr1filename(axis))
            call tce_clone_y1(d_yr1(axis+3),size_yr1(axis),
     1           sym_abelian_axis(geom,axis),yr1filename(axis+3))
            call tce_clone_y1(d_yr1(axis+6),size_yr1(axis),
     1           sym_abelian_axis(geom,axis),yr1filename(axis+6))
            call tce_clone_y1(d_yr1(axis+9),size_yr1(axis),
     1           sym_abelian_axis(geom,axis),yr1filename(axis+9))
          endif
          enddo ! axis
        endif ! leftresp
      endif
c
c     t2 amplitudes
c
      if (needt2) then
        call tce_create_t2(d_t2,l_t2_offset,k_t2_offset,size_t2,
     &                         irrep_t,'t2      ',
     &                         d_t1,k_t1_offset,size_t1,
     &                         d_f1,k_f1_offset,size_1e,
     &                         d_v2,k_v2_offset,size_2e,
     &                         ref,needt1,ioalg,model)
        if (left) then
          call tce_create_y2(d_lambda2,l_l2_offset,k_l2_offset,
     &                             size_l2,irrep_t,'lambda2 ')
        endif
        if (lineresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_x2(d_tr2(axis),l_tr2_offset(axis),
     1           k_tr2_offset(axis),size_tr2(axis),
     2           sym_abelian_axis(geom,axis),tr2filename(axis))
            call tce_clone_x2(d_tr2(axis+3),size_tr2(axis),
     1           sym_abelian_axis(geom,axis),tr2filename(axis+3))
            call tce_clone_x2(d_tr2(axis+6),size_tr2(axis),
     1           sym_abelian_axis(geom,axis),tr2filename(axis+6))
            call tce_clone_x2(d_tr2(axis+9),size_tr2(axis),
     1           sym_abelian_axis(geom,axis),tr2filename(axis+9))
          endif
          enddo ! axis
        endif ! lineresp
        if (leftresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_y2(d_yr2(axis),l_yr2_offset(axis),
     1           k_yr2_offset(axis),size_yr2(axis),
     2           sym_abelian_axis(geom,axis),yr2filename(axis))
            call tce_clone_y2(d_yr2(axis+3),size_yr2(axis),
     1           sym_abelian_axis(geom,axis),yr2filename(axis+3))
            call tce_clone_y2(d_yr2(axis+6),size_yr2(axis),
     1           sym_abelian_axis(geom,axis),yr2filename(axis+6))
            call tce_clone_y2(d_yr2(axis+9),size_yr2(axis),
     1           sym_abelian_axis(geom,axis),yr2filename(axis+9))
          endif
          enddo ! axis
        endif ! leftresp
      endif
c
c     t3 amplitudes
c
      if (needt3) then
        call tce_create_t3(d_t3,l_t3_offset,k_t3_offset,size_t3,
     &                         irrep_t,'t3      ')
        if (left) then
          call tce_create_y3(d_lambda3,l_l3_offset,k_l3_offset,
     &                             size_l3,irrep_t,'lambda3 ')
        endif
        if (lineresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_x3(d_tr3(axis),l_tr3_offset(axis),
     1           k_tr3_offset(axis),size_tr3(axis),
     2           sym_abelian_axis(geom,axis),tr3filename(axis))
            call tce_clone_x3(d_tr3(axis+3),size_tr3(axis),
     1           sym_abelian_axis(geom,axis),tr3filename(axis+3))
          endif
          enddo ! axis
        endif ! lineresp
        if (leftresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_y3(d_yr3(axis),l_yr3_offset(axis),
     1           k_yr3_offset(axis),size_yr3(axis),
     2           sym_abelian_axis(geom,axis),yr3filename(axis))
            call tce_clone_y3(d_yr3(axis+3),size_yr3(axis),
     1           sym_abelian_axis(geom,axis),yr3filename(axis+3))
          endif
          enddo ! axis
        endif ! leftresp
      endif
c
c     t4 amplitudes
c
      if (needt4) then
        call tce_filename('t4',filename)
        call tce_create_t4(d_t4,l_t4_offset,k_t4_offset,size_t4,
     &                         irrep_t,'t4      ')

        if (left) then
          call tce_filename('lambda4',filename)
          call tce_create_y4(d_lambda4,l_l4_offset,k_l4_offset,
     &                             size_l4,irrep_t,'lambda4 ')
        endif
        if (lineresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_x4(d_tr4(axis),l_tr4_offset(axis),
     1           k_tr4_offset(axis),size_tr4(axis),
     2           sym_abelian_axis(geom,axis),tr4filename(axis))
            call tce_clone_x4(d_tr4(axis+3),size_tr4(axis),
     1           sym_abelian_axis(geom,axis),tr4filename(axis+3))
          endif
          enddo ! axis
        endif ! lineresp
        if (leftresp) then
          do axis = 1, 3
          if (respaxis(axis)) then
            call tce_create_y4(d_yr4(axis),l_yr4_offset(axis),
     1           k_yr4_offset(axis),size_yr4(axis),
     2           sym_abelian_axis(geom,axis),yr4filename(axis))
            call tce_clone_y4(d_yr4(axis+3),size_yr4(axis),
     1           sym_abelian_axis(geom,axis),yr4filename(axis+3))
          endif
          enddo ! axis
        endif ! leftresp
      endif
      if (nodezero) write(LuOut,*) '============================='
c
c ----------------------------------- c
c Coupled Cluster Singles and Doubles c
c ----------------------------------- c
#ifdef MULTILEVEL
      if ( ( (model.eq.'ccsd').or.(model.eq.'ccsdt') ) 
     &   .or.(model.eq.'ccsdtq') ) then
#else
      if (model.eq.'ccsd') then
#endif
c ----------- c
c CCSD Energy c
c ----------- c
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsd_tdiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsd_tdiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsd_tdiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsd_tthresh',mt_dbl,1,thresh)) 
     &  call errquit('tce_property: need to define tce:ccsd_tthresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsd_tthresh = ',thresh
#endif
        dtitle='CCSD'
        if (.not.tce_ccsd_driver(dtitle,ref,corr,thresh,maxiter,
     &           d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &           d_f1,k_f1_offset,d_v2,k_v2_offset)) then
          call errquit('tce_property: CCSD failed',0,CALC_ERR)
        endif
c -------------- c
c CCSD(T) Energy c
c -------------- c

c ----------- c
c CCSD Lambda c
c ----------- c
        if (left) then
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsd_ydiis',mt_int,1,diis))
     &  call errquit('tce_property: need to define tce:ccsd_ydiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsd_ydiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsd_ythresh',mt_dbl,1,thresh)) 
     &  call errquit('tce_property: need to define tce:ccsd_ythresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsd_ythresh = ',thresh
#endif
          dtitle='CCSD Lambda'
          if (.not.tce_ccsd_lambda_driver(dtitle,thresh,maxiter,
     &             d_lambda1,k_l1_offset,size_l1,
     &             d_lambda2,k_l2_offset,size_l2,
     &             d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &             d_f1,k_f1_offset,d_v2,k_v2_offset)) then
            call errquit('tce_property: CCSD Lambda failed',0,CALC_ERR)
          endif
        endif
c ------------------------------ c
c CCSD Dipole Moments (OLD CODE) c
c ------------------------------ c

c --------------------------------- c
c CCSD Multipole Moments (NEW CODE) c
c --------------------------------- c

c --------------------- c
c CCSD Density Matrices c
c --------------------- c

c --------------------------------- c
c CCSD Expectation Value Properties c
c --------------------------------- c

c --------------------- c
c Lambda-CCSD(T) Energy c
c --------------------- c

c ------- c
c CCSD-LR c
c ------- c
        if (lineresp) then
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsd_rdiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsd_rdiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsd_rdiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsd_rthresh',mt_dbl,1,thresh))
     &  call errquit('tce_property: need to define tce:ccsd_rthresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsd_rthresh = ',thresh
#endif
c
          do omegacount=1,min(anumfreq,bnumfreq)
            omega1 = afreq(omegacount)
            omega2 = bfreq(omegacount)
            if ((omega1.eq.(0.0d0)).and.(omega2.eq.(0.0d0))) then
              dynfreq = 1
            else
              dynfreq = 4
            endif
c
          do axis = 1, 3
          if (respaxis(axis)) then
            irrep_d=sym_abelian_axis(geom,axis)
            call sym_irrepname(geom,irrep_d+1,irrepname)
            if (nodezero.and.util_print('mod1',print_default)) then
              write(LuOut,*)
              write(LuOut,9440) axisname(axis),irrepname
            endif
            irrep_o=irrep_d
            irrep_x=irrep_d
c
          do omegasign=1,dynfreq
            if (omegasign.eq.1) then
              omega = (-1.0d0)*afreq(omegacount)
              dynaxis = 0
            elseif (omegasign.eq.2) then
              omega = (1.0d0)*afreq(omegacount)
              dynaxis = 3
            elseif (omegasign.eq.3) then
              omega = (-1.0d0)*bfreq(omegacount)
              dynaxis = 6
            elseif (omegasign.eq.4) then
              omega = (1.0d0)*bfreq(omegacount)
              dynaxis = 9
            endif
            if (nodezero) write(LuOut,9431) omega
c
            dtitle='CCSD-LR'
            if (.not.tce_ccsd_response_driver(dtitle,thresh,maxiter,
     &        d_tr1(axis+dynaxis),k_tr1_offset(axis),size_tr1(axis),
     &        d_tr2(axis+dynaxis),k_tr2_offset(axis),size_tr2(axis),
     &        d_t1,k_t1_offset,d_t2,k_t2_offset,
     &        d_f1,k_f1_offset,d_v2,k_v2_offset,
     &        d_d1(axis),k_d1_offset(axis),omega)) then
              call errquit('tce_property: CCSD-LR failed',0,CALC_ERR)
            endif
c
          enddo ! omegasign loop
c
          endif ! respaxis(axis)
          enddo ! axis loop
c ------------------------------------------------ c
c CCSD Polarizabilities using symmetric evaluation c
c ------------------------------------------------ c
          cpu=-util_cpusec()
          wall=-util_wallsec()
          do axisA = 1, 3
          do axisB = 1, axisA
          alpha(axisA,axisB) = 0.0d0
          if (respaxis(axisA).and.respaxis(axisB)) then
            irrep_a=sym_abelian_axis(geom,axisA)
            irrep_b=sym_abelian_axis(geom,axisB)
            irrep_y=irrep_g
c
            if (nodezero) then
              write(LuOut,*)
              write(LuOut,9350) 'CCSD-LR Polarizability'
            endif
            if (omega1.eq.0.0d0) then
              dynaxis = 0
            else
              dynaxis = 3
            endif
            alpha(axisA,axisB)=tce_ccsd_symm_polar(omega1,
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),
     &         irrep_b,d_d1(axisB),k_d1_offset(axisB),
     &         d_f1,k_f1_offset,d_v2,k_v2_offset,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisA),d_tr1(axisA+dynaxis),k_tr1_offset(axisA),
     &         d_tr2(axisA),d_tr2(axisA+dynaxis),k_tr2_offset(axisA),
     &         d_tr1(axisB),d_tr1(axisB+dynaxis),k_tr1_offset(axisB),
     &         d_tr2(axisB),d_tr2(axisB+dynaxis),k_tr2_offset(axisB))
c
          endif ! respaxis(axis)
          enddo ! axisB loop
          enddo ! axisA loop
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
c
          if (nodezero) write(LuOut,9434) "CCSD Linear Response",
     1        afreq(omegacount),
     2        alpha(1,1),alpha(2,1),alpha(3,1),
     3        alpha(2,1),alpha(2,2),alpha(3,2),
     4        alpha(3,1),alpha(3,2),alpha(3,3)
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c
          do axisA = 1, 3
          do axisB = 1, axisA
          alpha(axisA,axisB) = 0.0d0
          if (respaxis(axisA).and.respaxis(axisB)) then
            irrep_a=sym_abelian_axis(geom,axisA)
            irrep_b=sym_abelian_axis(geom,axisB)
            irrep_y=irrep_g
c
            if (nodezero) then
              write(LuOut,*)
              write(LuOut,9350) 'CCSD-LR Polarizability'
            endif
            if (omega2.eq.0.0d0) then
              dynaxis = 6
            else
              dynaxis = 9
            endif
            alpha(axisA,axisB)=tce_ccsd_symm_polar(omega2,
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),
     &         irrep_b,d_d1(axisB),k_d1_offset(axisB),
     &         d_f1,k_f1_offset,d_v2,k_v2_offset,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisA+6),d_tr1(axisA+dynaxis),k_tr1_offset(axisA),
     &         d_tr2(axisA+6),d_tr2(axisA+dynaxis),k_tr2_offset(axisA),
     &         d_tr1(axisB+6),d_tr1(axisB+dynaxis),k_tr1_offset(axisB),
     &         d_tr2(axisB+6),d_tr2(axisB+dynaxis),k_tr2_offset(axisB))
c
          endif ! respaxis(axis)
          enddo ! axisB loop
          enddo ! axisA loop
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
c
          if (nodezero) write(LuOut,9434) "CCSD Linear Response",
     1        bfreq(omegacount),
     2        alpha(1,1),alpha(2,1),alpha(3,1),
     3        alpha(2,1),alpha(2,2),alpha(3,2),
     4        alpha(3,1),alpha(3,2),alpha(3,3)
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c
          enddo ! omegacount loop
c
        endif ! lineresp
c
c ------- c
c CCSD-YR c
c ------- c
        if (leftresp) then
c
          do omegacount=1,min(anumfreq,bnumfreq)
            omega1 = afreq(omegacount)
            omega2 = bfreq(omegacount)
            if ((omega1.eq.(0.0d0)).and.(omega2.eq.(0.0d0))) then
              dynfreq = 1
            else
              dynfreq = 4
            endif
c
          do axis = 1, 3
          if (respaxis(axis)) then
            irrep_d=sym_abelian_axis(geom,axis)
            call sym_irrepname(geom,irrep_d+1,irrepname)
            if (nodezero.and.util_print('mod1',print_default)) then
              write(LuOut,*)
              write(LuOut,9440) axisname(axis),irrepname
            endif
            irrep_o=irrep_d
            irrep_x=irrep_d
c
          do omegasign=1,dynfreq
            if (omegasign.eq.1) then
              omega = (1.0d0)*afreq(omegacount)
              dynaxis = 0
            elseif (omegasign.eq.2) then
              omega = (-1.0d0)*afreq(omegacount)
              dynaxis = 3
            elseif (omegasign.eq.3) then
              omega = (1.0d0)*bfreq(omegacount)
              dynaxis = 6
            elseif (omegasign.eq.4) then
              omega = (-1.0d0)*bfreq(omegacount)
              dynaxis = 9
            endif
            if (nodezero) write(LuOut,9431) omega
            dtitle='CCSD-YR'
            if (.not.tce_ccsd_lambda_response_driver(dtitle,
     &        thresh,maxiter,
     &        d_yr1(axis+dynaxis),k_yr1_offset(axis),size_yr1(axis),
     &        d_yr2(axis+dynaxis),k_yr2_offset(axis),size_yr2(axis),
     &        d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &        d_tr1(axis+dynaxis),k_tr1_offset(axis),size_tr1(axis),
     &        d_tr2(axis+dynaxis),k_tr2_offset(axis),size_tr2(axis),
     &        d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &        d_f1,k_f1_offset,d_v2,k_v2_offset,
     &        d_d1(axis),k_d1_offset(axis),omega)) then
              call errquit('tce_property: CCSD-YR failed',0,CALC_ERR)
            endif
c
          enddo ! omegasign loop
c
          endif ! respaxis(axis)
          enddo ! axis loop
c ------------------------------------------------- c
c CCSD Polarizabilities using asymmetric evaluation c
c ------------------------------------------------- c
          cpu=-util_cpusec()
          wall=-util_wallsec()
          do axisA = 1, 3
          do axisB = 1, 3
          alpha(axisA,axisB) = 0.0d0
          if ( respaxis(axisA).and.respaxis(axisB) ) then
c
            irrep_a=sym_abelian_axis(geom,axisA)
            irrep_b=sym_abelian_axis(geom,axisB)
c
#if defined(DEBUG_PRINT)
              write(LuOut,9350) 'CCSD-YR Polarizability'
#endif
            if (afreq(omegacount).eq.(0.0d0)) then
              dynaxis = 0
            else
              dynaxis = 3
            endif
            alpha(axisA,axisB)=0.0
            alpha(axisA,axisB)=alpha(axisA,axisB)+
     &         tce_ccsd_asym_polar(
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),irrep_b,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisB),k_tr1_offset(axisB),
     &         d_tr2(axisB),k_tr2_offset(axisB),
     &         d_yr1(axisB),k_yr1_offset(axisB),
     &         d_yr2(axisB),k_yr2_offset(axisB))
            alpha(axisA,axisB)=alpha(axisA,axisB)+
     &         tce_ccsd_asym_polar(
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),irrep_b,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisB+dynaxis),k_tr1_offset(axisB),
     &         d_tr2(axisB+dynaxis),k_tr2_offset(axisB),
     &         d_yr1(axisB+dynaxis),k_yr1_offset(axisB),
     &         d_yr2(axisB+dynaxis),k_yr2_offset(axisB))
c
          endif ! respaxis(axisA,axisB)
          enddo ! axisB loop
          enddo ! axisA loop
c
          if (nodezero) write(LuOut,9434) "CCSD Lambda Response",
     1      afreq(omegacount),
     2      alpha(1,1),alpha(1,2),alpha(1,3),
     3      alpha(2,1),alpha(2,2),alpha(2,3),
     4      alpha(3,1),alpha(3,2),alpha(3,3)
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c
          cpu=-util_cpusec()
          wall=-util_wallsec()
          do axisA = 1, 3
          do axisB = 1, 3
          alpha(axisA,axisB) = 0.0d0
          if ( respaxis(axisA).and.respaxis(axisB) ) then
c
            irrep_a=sym_abelian_axis(geom,axisA)
            irrep_b=sym_abelian_axis(geom,axisB)
c
#if defined(DEBUG_PRINT)
              write(LuOut,9350) 'CCSD-YR Polarizability'
#endif
            if (bfreq(omegacount).eq.(0.0d0)) then
              dynaxis = 0
            else
              dynaxis = 3
            endif
            alpha(axisA,axisB)=0.0
            alpha(axisA,axisB)=alpha(axisA,axisB)+
     &         tce_ccsd_asym_polar(
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),irrep_b,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisB+6),k_tr1_offset(axisB),
     &         d_tr2(axisB+6),k_tr2_offset(axisB),
     &         d_yr1(axisB+6),k_yr1_offset(axisB),
     &         d_yr2(axisB+6),k_yr2_offset(axisB))
            alpha(axisA,axisB)=alpha(axisA,axisB)+
     &         tce_ccsd_asym_polar(
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),irrep_b,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisB+6+dynaxis),k_tr1_offset(axisB),
     &         d_tr2(axisB+6+dynaxis),k_tr2_offset(axisB),
     &         d_yr1(axisB+6+dynaxis),k_yr1_offset(axisB),
     &         d_yr2(axisB+6+dynaxis),k_yr2_offset(axisB))
c
          endif ! respaxis(axisA,axisB)
          enddo ! axisB loop
          enddo ! axisA loop
c
          if (nodezero) write(LuOut,9434) "CCSD Lambda Response",
     1      bfreq(omegacount),
     2      alpha(1,1),alpha(1,2),alpha(1,3),
     3      alpha(2,1),alpha(2,2),alpha(2,3),
     4      alpha(3,1),alpha(3,2),alpha(3,3)
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c -------------------------- c
c CCSD Hyperpolarizabilities c
c -------------------------- c
          do axis = 1, 3
            irrep_d1(axis)=sym_abelian_axis(geom,axis)
          enddo
c
          call tce_ccsd_hyperpolar(beta,respaxis,
     1         irrep_d1,d_d1,k_d1_offset,
     2         d_f1,k_f1_offset,d_v2,k_v2_offset,
     3         d_t1,k_t1_offset,d_t2,k_t2_offset,
     4         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     5         d_tr1,k_tr1_offset,d_tr2,k_tr2_offset,
     6         d_yr1,k_yr1_offset,d_yr2,k_yr2_offset)
c
          cpu=-util_cpusec()
          wall=-util_wallsec()
          if (nodezero) then
            write(LuOut,*)
            write(LuOut,9120) "CCSD Quadratic Response"
            write(LuOut,9504)
            write(LuOut,9502)
            do axisA = 1, 3
              do axisB = 1, 3
                do axisC = 1, 3
                  if (dabs(beta(axisA,axisB,axisC)).gt.1.0d-8)
     1              write(LuOut,9503) axisname(axisA),axisname(axisB),
     2              axisname(axisC),beta(axisA,axisB,axisC),' / au'
                enddo
              enddo
            enddo
            write(LuOut,9502)
          endif
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c
          enddo ! omegacount loop
c
        endif ! leftresp
c        call errquit('tce_property: manual stop',0,CALC_ERR)
c -------------------------------------------- c
c Coupled Cluster Singles, Doubles and Triples c
c -------------------------------------------- c
#ifdef MULTILEVEL
      endif
      if ( (model.eq.'ccsdt').or.(model.eq.'ccsdtq') ) then
#else
      else if (model.eq.'ccsdt') then
#endif
c ------------ c
c CCSDT Energy c
c ------------ c
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsdt_tdiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsdt_tdiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdt_tdiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsdt_tthresh',mt_dbl,1,thresh)) 
     &  call errquit('tce_property: need to define tce:ccsdt_tthresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdt_tthresh = ',thresh
#endif
        dtitle='CCSDT'
        if (.not.tce_ccsdt_driver(dtitle,ref,corr,thresh,maxiter,
     &           d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &           d_t3,k_t3_offset,size_t3,d_f1,k_f1_offset,
     &           d_v2,k_v2_offset,.true.)) then
          call errquit('tce_property: CCSDT failed',0,CALC_ERR)
        endif
c ------------ c
c CCSDT Lambda c
c ------------ c
        if (left.and..true.) then
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsdt_ydiis',mt_int,1,diis))
     &  call errquit('tce_property: need to define tce:ccsdt_ydiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdt_ydiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsdt_ythresh',mt_dbl,1,thresh))
     &  call errquit('tce_property: need to define tce:ccsdt_ythresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdt_ythresh = ',thresh
#endif
          irrep_y=0
          dtitle='CCSDT Lambda'
          if (.not.tce_ccsdt_lambda_driver(dtitle,thresh,maxiter,
     &             d_lambda1,k_l1_offset,size_l1,
     &             d_lambda2,k_l2_offset,size_l2,
     &             d_lambda3,k_l3_offset,size_l3,
     &             d_t1,k_t1_offset,d_t2,k_t2_offset,d_t3,k_t3_offset,
     &             d_f1,k_f1_offset,d_v2,k_v2_offset,.true.)) then
            call errquit('tce_property: CCSDT Lambda failed',0,CALC_ERR)
          endif
        endif
c        call errquit('tce_property: manual stop',0,CALC_ERR)
c -------- c
c CCSDT-LR c
c -------- c
        if (lineresp) then
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsdt_rdiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsdt_rdiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdt_rdiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsdt_rthresh',mt_dbl,1,thresh))
     &  call errquit('tce_property: need to define tce:ccsdt_rthresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdt_rthresh = ',thresh
#endif
c
          do omegacount=1,anumfreq
            omega = afreq(omegacount)
            if (omega.eq.(0.0d0)) then
              dynfreq = 1
            else
              dynfreq = 2
            endif
c
          do axis = 1, 3
          if (respaxis(axis)) then
            irrep_d=sym_abelian_axis(geom,axis)
            call sym_irrepname(geom,irrep_d+1,irrepname)
            if (nodezero.and.util_print('mod1',print_default)) then
              write(LuOut,*)
              write(LuOut,9440) axisname(axis),irrepname
            endif
            irrep_o=irrep_d
            irrep_x=irrep_d
c
          do omegasign=1,dynfreq
            if (omegasign.eq.1) then
              omega = (-1.0d0)*afreq(omegacount)
              dynaxis = 0
            elseif (omegasign.eq.2) then
              omega = (1.0d0)*afreq(omegacount)
              dynaxis = 3
            endif
            if (nodezero) write(LuOut,9431) omega
c
            dtitle='CCSDT-LR'
            if (.not.tce_ccsdt_response_driver(dtitle,thresh,maxiter,
     &        d_tr1(axis+dynaxis),k_tr1_offset(axis),size_tr1(axis),
     &        d_tr2(axis+dynaxis),k_tr2_offset(axis),size_tr2(axis),
     &        d_tr3(axis+dynaxis),k_tr3_offset(axis),size_tr3(axis),
     &        d_t1,k_t1_offset,d_t2,k_t2_offset,d_t3,k_t3_offset,
     &        d_f1,k_f1_offset,d_v2,k_v2_offset,
     &        d_d1(axis),k_d1_offset(axis),omega,.true.)) then
              call errquit('tce_property: CCSDT-LR failed',0,CALC_ERR)
            endif
c
          enddo ! omegasign loop
c
          endif ! respaxis(axis)
          enddo ! axis loop
c ------------------------------------------------- c
c CCSDT Polarizabilities using symmetric evaluation c
c ------------------------------------------------- c
          cpu=-util_cpusec()
          wall=-util_wallsec()
          do axisA = 1, 3
          do axisB = 1, axisA
          alpha(axisA,axisB)=0.0d0
          if (respaxis(axisA).and.respaxis(axisB)) then
            irrep_a=sym_abelian_axis(geom,axisA)
            irrep_b=sym_abelian_axis(geom,axisB)
            irrep_y=irrep_g
c
            if (nodezero) then
              write(LuOut,*)
              write(LuOut,9350) 'CCSDT-LR Polarizability'
            endif
            alpha(axisA,axisB)=tce_ccsdt_symm_polar(omega,
     &         irrep_a,d_d1(axisA),k_d1_offset(axisA),
     &         irrep_b,d_d1(axisB),k_d1_offset(axisB),
     &         d_f1,k_f1_offset,d_v2,k_v2_offset,
     &         d_t1,k_t1_offset,d_t2,k_t2_offset,
     &         d_lambda1,k_l1_offset,d_lambda2,k_l2_offset,
     &         d_tr1(axisA),d_tr1(axisA+dynaxis),k_tr1_offset(axisA),
     &         d_tr2(axisA),d_tr2(axisA+dynaxis),k_tr2_offset(axisA),
     &         d_tr1(axisB),d_tr1(axisB+dynaxis),k_tr1_offset(axisB),
     &         d_tr2(axisB),d_tr2(axisB+dynaxis),k_tr2_offset(axisB))
c
          endif ! respaxis(axis)
          enddo ! axisB loop
          enddo ! axisA loop
          cpu=cpu+util_cpusec()
          wall=wall+util_wallsec()
c
          if (nodezero) write(LuOut,9434) "CCSDT Linear Response",
     1        afreq(omegacount),
     2        alpha(1,1),alpha(2,1),alpha(3,1),
     3        alpha(2,1),alpha(2,2),alpha(3,2),
     4        alpha(3,1),alpha(3,2),alpha(3,3)
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c
          enddo ! omegacount loop
c
        endif ! lineresp
c
c -------------------------------------------------------- c
c Coupled Cluster Singles, Doubles, Triples and Quadruples c
c -------------------------------------------------------- c
#ifdef MULTILEVEL
      endif
      if (model.eq.'ccsdtq') then
#else
      else if (model.eq.'ccsdtq') then
#endif
c ------------- c
c CCSDTQ Energy c
c ------------- c
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsdtq_tdiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsdtq_tdiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdtq_tdiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsdtq_tthresh',mt_dbl,1,thresh)) 
     &  call errquit('tce_property: need to define tce:ccsdtq_tthresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdtq_tthresh = ',thresh
#endif
        dtitle='CCSDTQ'
        if (.not.tce_ccsdtq_driver(dtitle,ref,corr,thresh,maxiter,
     &           d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &           d_t3,k_t3_offset,size_t3,d_t4,k_t4_offset,size_t4,
     &           d_f1,k_f1_offset,d_v2,k_v2_offset,.true.)) then
          call errquit('tce_property: CCSDTQ failed',0,CALC_ERR)
        endif
c ------------ c
c CCSDTQ Lambda c
c ------------ c
        if (left.and..true.) then
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsdtq_ydiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsdtq_ydiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdtq_ydiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsdtq_ythresh',mt_dbl,1,thresh)) 
     &  call errquit('tce_property: need to define tce:ccsdtq_ythresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdtq_ythresh = ',thresh
#endif
          irrep_y=0
          dtitle='CCSDTQ Lambda'
          if (.not.tce_ccsdtq_lambda_driver(dtitle,thresh,maxiter,
     &             d_lambda1,k_l1_offset,size_l1,
     &             d_lambda2,k_l2_offset,size_l2,
     &             d_lambda3,k_l3_offset,size_l3,
     &             d_lambda4,k_l4_offset,size_l4,
     &             d_t1,k_t1_offset,size_t1,d_t2,k_t2_offset,size_t2,
     &             d_t3,k_t3_offset,size_t3,d_t4,k_t4_offset,size_t4,
     &             d_f1,k_f1_offset,d_v2,k_v2_offset,.true.)) then
            call errquit('tce_property: CCSDTQ Lambda failed',
     &                    0,CALC_ERR)
          endif
        endif
c        call errquit('tce_property: manual stop',0,CALC_ERR)
c --------- c
c CCSDTQ-LR c
c --------- c
        if (lineresp) then
#ifdef MULTILEVEL
      if (.not.rtdb_get(rtdb,'tce:ccsdtq_rdiis',mt_int,1,diis)) 
     &  call errquit('tce_property: need to define tce:ccsdtq_rdiis',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdtq_rdiis = ',diis
      if (.not.rtdb_get(rtdb,'tce:ccsdtq_rthresh',mt_dbl,1,thresh)) 
     &  call errquit('tce_property: need to define tce:ccsdtq_rthresh',
     &               0,CALC_ERR)
      write(LuOut,*) 'ccsdtq_rthresh = ',thresh
#endif
c
          do omegacount=1,anumfreq
            omega = afreq(omegacount)
            if (omega.eq.(0.0d0)) then
              dynfreq = 1
            else
              dynfreq = 2
            endif
c
          do axis = 1, 3
          if (respaxis(axis)) then
            irrep_d=sym_abelian_axis(geom,axis)
            call sym_irrepname(geom,irrep_d+1,irrepname)
            if (nodezero.and.util_print('mod1',print_default)) then
              write(LuOut,*)
              write(LuOut,9440) axisname(axis),irrepname
            endif
            irrep_o=irrep_d
            irrep_x=irrep_d
c
          do omegasign=1,dynfreq
            if (omegasign.eq.1) then
              omega = (-1.0d0)*afreq(omegacount)
              dynaxis = 0
            elseif (omegasign.eq.2) then
              omega = (1.0d0)*afreq(omegacount)
              dynaxis = 3
            endif
            if (nodezero) write(LuOut,9431) omega
c
            dtitle='CCSDTQ-LR'
            if (.not.tce_ccsdtq_response_driver(dtitle,thresh,maxiter,
     &        d_tr1(axis+dynaxis),k_tr1_offset(axis),size_tr1(axis),
     &        d_tr2(axis+dynaxis),k_tr2_offset(axis),size_tr2(axis),
     &        d_tr3(axis+dynaxis),k_tr3_offset(axis),size_tr3(axis),
     &        d_tr4(axis+dynaxis),k_tr4_offset(axis),size_tr4(axis),
     &        d_t1,k_t1_offset,d_t2,k_t2_offset,
     &        d_t3,k_t3_offset,d_t4,k_t4_offset,
     &        d_f1,k_f1_offset,d_v2,k_v2_offset,
     &        d_d1(axis),k_d1_offset(axis),omega,.true.)) then
              call errquit('tce_property: CCSDTQ-LR failed',0,CALC_ERR)
            endif
c
          enddo ! omegasign loop
c
          endif ! respaxis(axis)
          enddo ! axis loop

c -------------
c CCSDTQ-LR
c -------------
c
c         Evaluate Dipole Polarizability
c
          do axisA = 1, 3
          do axisB = 1, axisA
          alpha(axisA,axisB)=0.0d0
          if (respaxis(axisA).and.respaxis(axisB)) then
            irrep_a=sym_abelian_axis(geom,axisA)
            irrep_b=sym_abelian_axis(geom,axisB)
            irrep_y=irrep_g
c
c            if (nodezero) write(LuOut,*) "axisA = ",axisA
c            if (nodezero) write(LuOut,*) "axisB = ",axisB
c
            call tce_filename('a0',filename)
            call createfile(filename,d_a0,size_a0)
c
              alpha1=0.0d0
              alpha2=0.0d0
c
              if (omega.ne.0.0d0) then
                dynaxis = 3
              else
                dynaxis = 0
              endif
c
              irrep_c=irrep_a
              irrep_oa=irrep_a
              irrep_ob=irrep_b
              irrep_tra=irrep_a
              irrep_trb=irrep_b
c              if (nodezero) write(LuOut,*) "ccsdtq_lr_alpha"
              call ccsdtq_lr_alpha(d_f1,d_a0,d_d1(axisA),d_d1(axisB),
     1             d_t1,d_t2,d_t3,d_t4,
     2             d_tr1(axisA+dynaxis),d_tr2(axisA+dynaxis),
     3             d_tr3(axisA+dynaxis),d_tr4(axisA+dynaxis),
     4             d_tr1(axisB),d_tr2(axisB),d_tr3(axisB),d_tr4(axisB),
     5             d_v2,d_lambda1,d_lambda2,d_lambda3,d_lambda4,
     6             k_f1_offset,k_a0_offset,k_d1_offset(axisA),
     7             k_d1_offset(axisB),k_t1_offset,k_t2_offset,
     8             k_t3_offset,k_t4_offset,k_tr1_offset(axisA),
     9             k_tr2_offset(axisA),k_tr3_offset(axisA),
     1             k_tr4_offset(axisA),k_tr1_offset(axisB),
     2             k_tr2_offset(axisB),k_tr3_offset(axisB),
     3             k_tr4_offset(axisB),k_v2_offset,k_l1_offset,
     4             k_l2_offset,k_l3_offset,k_l4_offset)
c
              call reconcilefile(d_a0,size_a0)
              call get_block(d_a0,alpha1,1,0)
              call tce_zero(d_a0,size_a0)
c              write(LuOut,*) "alpha1 = ",alpha1
c
              if (omega.eq.0.0d0) then
                alpha2=alpha1
              else
c                if (nodezero) write(LuOut,*) "ccsdtq_lr_alpha"
                call ccsdtq_lr_alpha(d_f1,d_a0,d_d1(axisA),d_d1(axisB),
     1             d_t1,d_t2,d_t3,d_t4,
     2             d_tr1(axisA),d_tr2(axisA),d_tr3(axisA),d_tr4(axisA),
     3             d_tr1(axisB+dynaxis),d_tr2(axisB+dynaxis),
     4             d_tr3(axisB+dynaxis),d_tr4(axisB+dynaxis),
     5             d_v2,d_lambda1,d_lambda2,d_lambda3,d_lambda4,
     6             k_f1_offset,k_a0_offset,k_d1_offset(axisA),
     7             k_d1_offset(axisB),k_t1_offset,k_t2_offset,
     8             k_t3_offset,k_t4_offset,k_tr1_offset(axisA),
     9             k_tr2_offset(axisA),k_tr3_offset(axisA),
     1             k_tr4_offset(axisA),k_tr1_offset(axisB),
     2             k_tr2_offset(axisB),k_tr3_offset(axisB),
     3             k_tr4_offset(axisB),k_v2_offset,k_l1_offset,
     4             k_l2_offset,k_l3_offset,k_l4_offset)
c
                call reconcilefile(d_a0,size_a0)
                call get_block(d_a0,alpha2,1,0)
                call tce_zero(d_a0,size_a0)
              endif ! axisA.eq.axisB
c              write(LuOut,*) "alpha2 = ",alpha2
c
              alpha(axisA,axisB)=(-0.5d0)*(alpha1+alpha2)
c
            call deletefile(d_a0)
c
c            write(LuOut,*) "alpha(axisA,axisB) = ",alpha(axisA,axisB)
c            if (nodezero) write(LuOut,9020) cpu, wall
c
          endif ! respaxis(axis)
          enddo ! axisB loop
          enddo ! axisA loop
c
          if (nodezero) write(LuOut,9434) "CCSDTQ Linear Response",
     1        afreq(omegacount),
     2        alpha(1,1),alpha(2,1),alpha(3,1),
     3        alpha(2,1),alpha(2,2),alpha(3,2),
     4        alpha(3,1),alpha(3,2),alpha(3,3)
          if (nodezero) write(LuOut,9020) cpu, wall
          call util_flush(LuOut)
c
          enddo ! omegacount loop
c
        endif ! lineresp
c
      endif ! model
c  100 continue
c
      if (nodezero) call util_flush(LuOut)
c
      tce_property=.true.
      call errquit('tce_property: manual stop',0,CALC_ERR)
c
c      endif
c
c     ===========================
c     End of all TCE calculations
c     ===========================
c
c->d3p975
c      do i = 1, ipol
c        if (.not.ga_destroy(g_movecs(i)))
c     1    call errquit('tce_property: GA problem',0,GA_ERR)
c      enddo
c<-d3p975
c
c      call deletefile(d_v2)
c      if (multipole.gt.0) then
c        do l_shell = multipole,1,-1
c          l_sh_size = (l_shell+1)*(l_shell+2)/2
c          do l_subshell = 1, l_sh_size
cccc            call deletefile(d_mo_mp1(l_shell,l_subshell))
c          enddo
c        enddo
c      endif
      if (left) then
        do axis=3,1,-1
          call deletefile(d_d1(axis))
        enddo
      endif
c      call deletefile(d_f1)
      if (needt4) then
        if (leftresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_yr4(axis))
            call deletefile(d_yr4(axis+3))
            if (.not.ma_pop_stack(l_yr4_offset(axis)))
     1        call errquit("tce_property: MA problem",86,MA_ERR)
          endif
          enddo ! axis
        endif ! leftresp
        if (lineresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_tr4(axis))
            call deletefile(d_tr4(axis+3))
            if (.not.ma_pop_stack(l_tr4_offset(axis)))
     1        call errquit("tce_property: MA problem",89,MA_ERR)
          endif
          enddo ! axis
        endif ! lineresp
        if (left) then
          call deletefile(d_lambda4)
          if (.not.ma_pop_stack(l_l4_offset))
     1      call errquit("tce_property: MA problem",26,MA_ERR)
        endif
        call deletefile(d_t4)
        if (.not.ma_pop_stack(l_t4_offset))
     1    call errquit("tce_property: MA problem",26,MA_ERR)
      endif
      if (needt3) then
        if (leftresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_yr3(axis))
            call deletefile(d_yr3(axis+3))
            if (.not.ma_pop_stack(l_yr3_offset(axis)))
     1        call errquit("tce_property: MA problem",86,MA_ERR)
          endif
          enddo ! axis
        endif ! leftresp
        if (lineresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_tr3(axis))
            call deletefile(d_tr3(axis+3))
            if (.not.ma_pop_stack(l_tr3_offset(axis)))
     1        call errquit("tce_property: MA problem",88,MA_ERR)
          endif
          enddo ! axis
        endif ! lineresp
        if (left) then
          call deletefile(d_lambda3)
          if (.not.ma_pop_stack(l_l3_offset))
     1      call errquit("tce_property: MA problem",25,MA_ERR)
        endif
        call deletefile(d_t3)
        if (.not.ma_pop_stack(l_t3_offset))
     1    call errquit("tce_property: MA problem",25,MA_ERR)
      endif
      if (needt2) then
        if (leftresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_yr2(axis))
            call deletefile(d_yr2(axis+3))
            if (.not.ma_pop_stack(l_yr2_offset(axis)))
     1        call errquit("tce_property: MA problem",86,MA_ERR)
          endif
          enddo ! axis
        endif ! leftresp
        if (lineresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_tr2(axis))
            call deletefile(d_tr2(axis+3))
            if (.not.ma_pop_stack(l_tr2_offset(axis)))
     1        call errquit("tce_property: MA problem",87,MA_ERR)
          endif
          enddo ! axis
        endif ! lineresp
        if (left) then
          call deletefile(d_lambda2)
          if (.not.ma_pop_stack(l_l2_offset))
     1      call errquit("tce_property: MA problem",0,MA_ERR)
        endif
        call deletefile(d_t2)
        if (.not.ma_pop_stack(l_t2_offset))
     1    call errquit("tce_property: MA problem",0,MA_ERR)
      endif
      if (needt1) then
        if (leftresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_yr1(axis))
            call deletefile(d_yr1(axis+3))
            if (.not.ma_pop_stack(l_yr1_offset(axis)))
     1        call errquit("tce_property: MA problem",86,MA_ERR)
          endif
          enddo ! axis
        endif ! leftresp
        if (lineresp) then
          do axis = 3, 1, -1
          if (respaxis(axis)) then
            call deletefile(d_tr1(axis))
            call deletefile(d_tr1(axis+3))
            if (.not.ma_pop_stack(l_tr1_offset(axis)))
     1        call errquit("tce_property: MA problem",86,MA_ERR)
          endif
          enddo ! axis
        endif ! lineresp
        if (left) then
          call deletefile(d_lambda1)
          if (.not.ma_pop_stack(l_l1_offset))
     1      call errquit("tce_property: MA problem",1,MA_ERR)
        endif
        call deletefile(d_t1)
        if (.not.ma_pop_stack(l_t1_offset))
     1    call errquit("tce_property: MA problem",1,MA_ERR)
      endif
      if(intorb) then
       if (.not.ma_pop_stack(l_v2spin_offset))
     1  call errquit("tce_property: MA problem",59,MA_ERR)
c--       if (.not.ma_pop_stack(l_o2ot_offset))
c--     1  call errquit("tce_property: MA problem",58,MA_ERR)
c--       if (.not.ma_pop_stack(l_o2o_offset))
c--     1  call errquit("tce_property: MA problem",57,MA_ERR)
       if (.not.ma_pop_stack(l_v2_alpha_offset))
     1  call errquit("tce_property: MA problem",56,MA_ERR)
      end if
      if(.not.intorb) then
      if (.not.ma_pop_stack(l_v2_offset))
     1  call errquit("tce_property: MA problem",2,MA_ERR)
      end if
c      if (.not.ma_pop_stack(l_f1_offset))
c     1  call errquit("tce_property: MA problem",3,MA_ERR)
c      if (multipole.gt.0) then
c        do l_shell = multipole,1,-1
c          l_sh_size = (l_shell+1)*(l_shell+2)/2
c          if(nodezero) write(LuOut,*) 'l_shell = ',l_shell
c          if(nodezero) write(LuOut,*) 'l_sh_size = ',l_sh_size
c          do l_subshell = 1, l_sh_size
c            if(nodezero) write(LuOut,*) 'l_subshell = ',l_subshell
cccc            if (.not.ma_pop_stack(l_mo_mp1_offset(l_shell,l_subshell)))
cccc     1        call errquit("tce_property: MA problem",100,MA_ERR)
c          enddo
c        enddo
c      endif
      if (left) then
        do axis=3,1,-1
          if (.not.ma_pop_stack(l_d1_offset(axis)))
     1      call errquit("tce_property: MA problem",3,MA_ERR)
        enddo
      endif
      if(intorb) then
       if (.not.ma_pop_stack(l_offset_alpha))
     1  call errquit("tce_property: MA problem",55,MA_ERR)
       if (.not.ma_pop_stack(l_range_alpha))
     1  call errquit("tce_property: MA problem",54,MA_ERR)
       if (.not.ma_pop_stack(l_sym_alpha))
     1  call errquit("tce_property: MA problem",53,MA_ERR)
       if (.not.ma_pop_stack(l_spin_alpha))
     1  call errquit("tce_property: MA problem",52,MA_ERR)
       if (.not.ma_pop_stack(l_b2am))
     1  call errquit("tce_property: MA problem",51,MA_ERR)
      end if
c ---
      if (.not.ma_pop_stack(l_alpha))
     1  call errquit("tce_property: MA problem",4,MA_ERR)
      if (.not.ma_pop_stack(l_offset))
     1  call errquit("tce_property: MA problem",5,MA_ERR)
      if (.not.ma_pop_stack(l_range))
     1  call errquit("tce_property: MA problem",6,MA_ERR)
      if (.not.ma_pop_stack(l_sym))
     1  call errquit("tce_property: MA problem",7,MA_ERR)
      if (.not.ma_pop_stack(l_spin))
     1  call errquit("tce_property: MA problem",8,MA_ERR)
      if (.not.ma_pop_stack(l_evl_sorted))
     1  call errquit("tce_property: MA problem",9,MA_ERR)
      if (.not.ma_pop_stack(l_irs_sorted))
     1  call errquit("tce_property: MA problem",10,MA_ERR)
      if (.not.ma_pop_stack(l_spin_sorted))
     1  call errquit("tce_property: MA problem",11,MA_ERR)
      if (.not.ma_pop_stack(l_movecs_sorted))
     1  call errquit("tce_property: MA problem",12,MA_ERR)
c
c     ===============
c     Destroy a mutex
c     ===============
c
      if (.not.ga_destroy_mutexes())
     1  call errquit('tce_property: GA problem',1,GA_ERR)
c
c     =========
c     Terminate
c     =========
c
      call tce_tidy(rtdb)
      call util_print_pop
#endif
      return
c
c     ======
c     Format
c     ======
c
 9020 format(1x,'Cpu & wall time / sec',2f15.1)
 9120 format(1x,A)
 9350 format(1x,'Evaluating ',A)
 9430 format(/,1x,A,' dipole moments / hartree & Debye',/,
     1  1x,'--------------------------------',/
     2  1x,'X ',2f15.7,/
     3  1x,'Y ',2f15.7,/
     4  1x,'Z ',2f15.7,/
     5  1x,'--------------------------------')
 9431 format(/,1x,'Frequency = ',f7.5,' / au')
 9434 format(/,1x,A,' polarizability / au ',/
     1  1x,'Frequency = ',f7.5,' / au',/
     2  1x,'      X              Y              Z',/
     3  1x,'-----------------------------------------------',/
     4  1x,'X ',3f15.7,/
     5  1x,'Y ',3f15.7,/
     6  1x,'Z ',3f15.7,/
     7  1x,'-----------------------------------------------')
 9440 format(1x,A1,' axis ( ',A4,'symmetry)')
 9501 format(/,1x,A,' hyperpolarizability / au ')
 9502 format(1x,'-----------------------------------------------')
 9503 format(1x,'beta(',a1,',',a1,',',a1,') = ',f13.7,a)
 9504 format(1x,'Static Hyperpolarizability')
c 9505 format(1x,'Second Harmonic Generation (SHG)')
c 9506 format(1x,'Optical Rectification (OR)')
c 9507 format(1x,'Electro-Optic Pockels Effect (EOPE)')
c 9508 format(1x,'beta(',f1.5,',',f1.5,',',f1.5,')')
      end
