"use strict";

var hasToStringTag = require("has-to-string-tag-x");

var isObject = require("is-object");

var _require = require("./props"),
    lenientProperties = _require.lenientProperties,
    strictProperties = _require.strictProperties;

var searchParamsClass = "[object URLSearchParams]";
var toStringTag = Object.prototype.toString;

var isURLSearchParams = function isURLSearchParams(searchParams) {
  var supportIncomplete = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  if (!isObject(searchParams)) {
    return false;
  } else if (hasToStringTag && toStringTag.call(searchParams) !== searchParamsClass) {
    // Shimmed implementation with incorrect constructor name
    return false;
  } else if (!strictProperties.every(function (prop) {
    return prop in searchParams;
  })) {
    return false;
  } else if (supportIncomplete) {
    return true;
  } else {
    return lenientProperties.every(function (prop) {
      return prop in searchParams;
    });
  }
};

isURLSearchParams.lenient = function (searchParams) {
  return isURLSearchParams(searchParams, true);
};

module.exports = isURLSearchParams;
//# sourceMappingURL=index.js.map