/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.util;

import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class TypeHelper {
    public static Type getType(Class cl) {
        if (cl.equals(Boolean.TYPE)) {
            return Type.BOOLEAN;
        }
        if (cl.equals(Character.TYPE)) {
            return Type.CHAR;
        }
        if (cl.equals(Byte.TYPE)) {
            return Type.BYTE;
        }
        if (cl.equals(Short.TYPE)) {
            return Type.SHORT;
        }
        if (cl.equals(Integer.TYPE)) {
            return Type.INT;
        }
        if (cl.equals(Long.TYPE)) {
            return Type.LONG;
        }
        if (cl.equals(Float.TYPE)) {
            return Type.FLOAT;
        }
        if (cl.equals(Double.TYPE)) {
            return Type.DOUBLE;
        }
        if (cl.isArray()) {
            return new ArrayType(TypeHelper.getType(cl.getComponentType()), 1);
        }
        if (cl.equals(Void.TYPE)) {
            return Type.VOID;
        }
        return new ObjectType(cl.getName());
    }

    public static Type[] getTypes(Class[] cls) {
        Type[] types = new Type[cls.length];
        for (int i = 0; i < cls.length; ++i) {
            types[i] = TypeHelper.getType(cls[i]);
        }
        return types;
    }
}

