/*!
 * Modest Maps JS v3.3.6
 * http://modestmaps.com/
 *
 * Copyright (c) 2011 Stamen Design, All Rights Reserved.
 *
 * Open source under the BSD License.
 * http://creativecommons.org/licenses/BSD/
 *
 * Versioned using Semantic Versioning (v.major.minor.patch)
 * See CHANGELOG and http://semver.org/ for more details.
 *
 */var previousMM=MM;if(!com){var com={};com.modestmaps||(com.modestmaps={})}var MM=com.modestmaps={noConflict:function(){return MM=previousMM,this}};(function(a){a.extend=function(a,b){for(var c in b.prototype)typeof a.prototype[c]=="undefined"&&(a.prototype[c]=b.prototype[c]);return a},a.getFrame=function(){return function(a){(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){window.setTimeout(function(){a(+(new Date))},10)})(a)}}(),a.transformProperty=function(a){if(!this.document)return;var b=document.documentElement.style;for(var c=0;c<a.length;c++)if(a[c]in b)return a[c];return!1}(["transform","WebkitTransform","OTransform","MozTransform","msTransform"]),a.matrixString=function(b){b.scale*b.width%1&&(b.scale+=(1-b.scale*b.width%1)/b.width);var c=b.scale||1;return a._browser.webkit3d?"translate3d("+b.x.toFixed(0)+"px,"+b.y.toFixed(0)+"px, 0px)"+"scale3d("+c+","+c+", 1)":"translate("+b.x.toFixed(6)+"px,"+b.y.toFixed(6)+"px)"+"scale("+c+","+c+")"},a._browser=function(a){return{webkit:"WebKitCSSMatrix"in a,webkit3d:"WebKitCSSMatrix"in a&&"m11"in new WebKitCSSMatrix}}(this),a.moveElement=function(b,c){if(a.transformProperty){c.scale||(c.scale=1),c.width||(c.width=0),c.height||(c.height=0);var d=a.matrixString(c);b[a.transformProperty]!==d&&(b.style[a.transformProperty]=b[a.transformProperty]=d)}else b.style.left=c.x+"px",b.style.top=c.y+"px",c.width&&c.height&&c.scale&&(b.style.width=Math.ceil(c.width*c.scale)+"px",b.style.height=Math.ceil(c.height*c.scale)+"px")},a.cancelEvent=function(a){return a.cancelBubble=!0,a.cancel=!0,a.returnValue=!1,a.stopPropagation&&a.stopPropagation(),a.preventDefault&&a.preventDefault(),!1},a.coerceLayer=function(b){return typeof b=="string"?new a.Layer(new a.TemplatedLayer(b)):"draw"in b&&typeof b.draw=="function"?b:new a.Layer(b)},a.addEvent=function(a,b,c){a.addEventListener?(a.addEventListener(b,c,!1),b=="mousewheel"&&a.addEventListener("DOMMouseScroll",c,!1)):a.attachEvent&&(a["e"+b+c]=c,a[b+c]=function(){a["e"+b+c](window.event)},a.attachEvent("on"+b,a[b+c]))},a.removeEvent=function(a,b,c){a.removeEventListener?(a.removeEventListener(b,c,!1),b=="mousewheel"&&a.removeEventListener("DOMMouseScroll",c,!1)):a.detachEvent&&(a.detachEvent("on"+b,a[b+c]),a[b+c]=null)},a.getStyle=function(a,b){if(a.currentStyle)return a.currentStyle[b];if(window.getComputedStyle)return document.defaultView.getComputedStyle(a,null).getPropertyValue(b)},a.Point=function(a,b){this.x=parseFloat(a),this.y=parseFloat(b)},a.Point.prototype={x:0,y:0,toString:function(){return"("+this.x.toFixed(3)+", "+this.y.toFixed(3)+")"},copy:function(){return new a.Point(this.x,this.y)}},a.Point.distance=function(a,b){return Math.sqrt(Math.pow(b.x-a.x,2)+Math.pow(b.y-a.y,2))},a.Point.interpolate=function(b,c,d){return new a.Point(b.x+(c.x-b.x)*d,b.y+(c.y-b.y)*d)},a.Coordinate=function(a,b,c){this.row=a,this.column=b,this.zoom=c},a.Coordinate.prototype={row:0,column:0,zoom:0,toString:function(){return"("+this.row.toFixed(3)+", "+this.column.toFixed(3)+" @"+this.zoom.toFixed(3)+")"},toKey:function(){return this.zoom+","+this.row+","+this.column},copy:function(){return new a.Coordinate(this.row,this.column,this.zoom)},container:function(){return new a.Coordinate(Math.floor(this.row),Math.floor(this.column),Math.floor(this.zoom))},zoomTo:function(b){var c=Math.pow(2,b-this.zoom);return new a.Coordinate(this.row*c,this.column*c,b)},zoomBy:function(b){var c=Math.pow(2,b);return new a.Coordinate(this.row*c,this.column*c,this.zoom+b)},up:function(b){return b===undefined&&(b=1),new a.Coordinate(this.row-b,this.column,this.zoom)},right:function(b){return b===undefined&&(b=1),new a.Coordinate(this.row,this.column+b,this.zoom)},down:function(b){return b===undefined&&(b=1),new a.Coordinate(this.row+b,this.column,this.zoom)},left:function(b){return b===undefined&&(b=1),new a.Coordinate(this.row,this.column-b,this.zoom)}},a.Location=function(a,b){this.lat=parseFloat(a),this.lon=parseFloat(b)},a.Location.prototype={lat:0,lon:0,toString:function(){return"("+this.lat.toFixed(3)+", "+this.lon.toFixed(3)+")"},copy:function(){return new a.Location(this.lat,this.lon)}},a.Location.distance=function(a,b,c){c||(c=6378e3);var d=Math.PI/180,e=a.lat*d,f=a.lon*d,g=b.lat*d,h=b.lon*d,i=Math.cos(e)*Math.cos(f)*Math.cos(g)*Math.cos(h),j=Math.cos(e)*Math.sin(f)*Math.cos(g)*Math.sin(h),k=Math.sin(e)*Math.sin(g);return Math.acos(i+j+k)*c},a.Location.interpolate=function(b,c,d){if(b.lat===c.lat&&b.lon===c.lon)return new a.Location(b.lat,b.lon);var e=Math.PI/180,f=b.lat*e,g=b.lon*e,h=c.lat*e,i=c.lon*e,j=2*Math.asin(Math.sqrt(Math.pow(Math.sin((f-h)/2),2)+Math.cos(f)*Math.cos(h)*Math.pow(Math.sin((g-i)/2),2))),k=Math.sin((1-d)*j)/Math.sin(j),l=Math.sin(d*j)/Math.sin(j),m=k*Math.cos(f)*Math.cos(g)+l*Math.cos(h)*Math.cos(i),n=k*Math.cos(f)*Math.sin(g)+l*Math.cos(h)*Math.sin(i),o=k*Math.sin(f)+l*Math.sin(h),p=Math.atan2(o,Math.sqrt(Math.pow(m,2)+Math.pow(n,2))),q=Math.atan2(n,m);return new a.Location(p/e,q/e)},a.Location.bearing=function(a,b){var c=Math.PI/180,d=a.lat*c,e=a.lon*c,f=b.lat*c,g=b.lon*c,h=Math.atan2(Math.sin(e-g)*Math.cos(f),Math.cos(d)*Math.sin(f)-Math.sin(d)*Math.cos(f)*Math.cos(e-g))/-(Math.PI/180);return h<0?h+360:h},a.Extent=function(b,c,d,e){if(b instanceof a.Location&&c instanceof a.Location){var f=b,g=c;b=f.lat,c=f.lon,d=g.lat,e=g.lon}isNaN(d)&&(d=b),isNaN(e)&&(e=c),this.north=Math.max(b,d),this.south=Math.min(b,d),this.east=Math.max(e,c),this.west=Math.min(e,c)},a.Extent.prototype={north:0,south:0,east:0,west:0,copy:function(){return new a.Extent(this.north,this.west,this.south,this.east)},toString:function(a){return isNaN(a)&&(a=3),[this.north.toFixed(a),this.west.toFixed(a),this.south.toFixed(a),this.east.toFixed(a)].join(", ")},northWest:function(){return new a.Location(this.north,this.west)},southEast:function(){return new a.Location(this.south,this.east)},northEast:function(){return new a.Location(this.north,this.east)},southWest:function(){return new a.Location(this.south,this.west)},center:function(){return new a.Location(this.south+(this.north-this.south)/2,this.east+(this.west-this.east)/2)},encloseLocation:function(a){a.lat>this.north&&(this.north=a.lat),a.lat<this.south&&(this.south=a.lat),a.lon>this.east&&(this.east=a.lon),a.lon<this.west&&(this.west=a.lon)},encloseLocations:function(a){var b=a.length;for(var c=0;c<b;c++)this.encloseLocation(a[c])},setFromLocations:function(a){var b=a.length,c=a[0];this.north=this.south=c.lat,this.east=this.west=c.lon;for(var d=1;d<b;d++)this.encloseLocation(a[d])},encloseExtent:function(a){a.north>this.north&&(this.north=a.north),a.south<this.south&&(this.south=a.south),a.east>this.east&&(this.east=a.east),a.west<this.west&&(this.west=a.west)},containsLocation:function(a){return a.lat>=this.south&&a.lat<=this.north&&a.lon>=this.west&&a.lon<=this.east},toArray:function(){return[this.northWest(),this.southEast()]}},a.Extent.fromString=function(b){var c=b.split(/\s*,\s*/);if(c.length!=4)throw"Invalid extent string (expecting 4 comma-separated numbers)";return new a.Extent(parseFloat(c[0]),parseFloat(c[1]),parseFloat(c[2]),parseFloat(c[3]))},a.Extent.fromArray=function(b){var c=new a.Extent;return c.setFromLocations(b),c},a.Transformation=function(a,b,c,d,e,f){this.ax=a,this.bx=b,this.cx=c,this.ay=d,this.by=e,this.cy=f},a.Transformation.prototype={ax:0,bx:0,cx:0,ay:0,by:0,cy:0,transform:function(b){return new a.Point(this.ax*b.x+this.bx*b.y+this.cx,this.ay*b.x+this.by*b.y+this.cy)},untransform:function(b){return new a.Point((b.x*this.by-b.y*this.bx-this.cx*this.by+this.cy*this.bx)/(this.ax*this.by-this.ay*this.bx),(b.x*this.ay-b.y*this.ax-this.cx*this.ay+this.cy*this.ax)/(this.bx*this.ay-this.by*this.ax))}},a.deriveTransformation=function(b,c,d,e,f,g,h,i,j,k,l,m){var n=a.linearSolution(b,c,d,f,g,h,j,k,l),o=a.linearSolution(b,c,e,f,g,i,j,k,m);return new a.Transformation(n[0],n[1],n[2],o[0],o[1],o[2])},a.linearSolution=function(a,b,c,d,e,f,g,h,i){a=parseFloat(a),b=parseFloat(b),c=parseFloat(c),d=parseFloat(d),e=parseFloat(e),f=parseFloat(f),g=parseFloat(g),h=parseFloat(h),i=parseFloat(i);var j=((f-i)*(b-e)-(c-f)*(e-h))/((d-g)*(b-e)-(a-d)*(e-h)),k=((f-i)*(a-d)-(c-f)*(d-g))/((e-h)*(a-d)-(b-e)*(d-g)),l=c-a*j-b*k;return[j,k,l]},a.Projection=function(b,c){c||(c=new a.Transformation(1,0,0,0,1,0)),this.zoom=b,this.transformation=c},a.Projection.prototype={zoom:0,transformation:null,rawProject:function(a){throw"Abstract method not implemented by subclass."},rawUnproject:function(a){throw"Abstract method not implemented by subclass."},project:function(a){return a=this.rawProject(a),this.transformation&&(a=this.transformation.transform(a)),a},unproject:function(a){return this.transformation&&(a=this.transformation.untransform(a)),a=this.rawUnproject(a),a},locationCoordinate:function(b){var c=new a.Point(Math.PI*b.lon/180,Math.PI*b.lat/180);return c=this.project(c),new a.Coordinate(c.y,c.x,this.zoom)},coordinateLocation:function(b){b=b.zoomTo(this.zoom);var c=new a.Point(b.column,b.row);return c=this.unproject(c),new a.Location(180*c.y/Math.PI,180*c.x/Math.PI)}},a.LinearProjection=function(b,c){a.Projection.call(this,b,c)},a.LinearProjection.prototype={rawProject:function(b){return new a.Point(b.x,b.y)},rawUnproject:function(b){return new a.Point(b.x,b.y)}},a.extend(a.LinearProjection,a.Projection),a.MercatorProjection=function(b,c){a.Projection.call(this,b,c)},a.MercatorProjection.prototype={rawProject:function(b){return new a.Point(b.x,Math.log(Math.tan(.25*Math.PI+.5*b.y)))},rawUnproject:function(b){return new a.Point(b.x,2*Math.atan(Math.pow(Math.E,b.y))-.5*Math.PI)}},a.extend(a.MercatorProjection,a.Projection),a.MapProvider=function(a){a&&(this.getTile=a)},a.MapProvider.prototype={tileLimits:[new a.Coordinate(0,0,0),(new a.Coordinate(1,1,0)).zoomTo(18)],getTileUrl:function(a){throw"Abstract method not implemented by subclass."},getTile:function(a){throw"Abstract method not implemented by subclass."},releaseTile:function(a){},setZoomRange:function(a,b){this.tileLimits[0]=this.tileLimits[0].zoomTo(a),this.tileLimits[1]=this.tileLimits[1].zoomTo(b)},sourceCoordinate:function(b){var c=this.tileLimits[0].zoomTo(b.zoom).container(),d=this.tileLimits[1].zoomTo(b.zoom),e=Math.pow(2,b.zoom),f;return d=new a.Coordinate(Math.ceil(d.row),Math.ceil(d.column),Math.floor(d.zoom)),b.column<0?f=(b.column%e+e)%e:f=b.column%e,b.row<c.row||b.row>=d.row?null:f<c.column||f>=d.column?null:new a.Coordinate(b.row,f,b.zoom)}},a.Template=function(b,c){function f(a,b,c){var d="";for(var e=1;e<=c;e++)d+=(a>>c-e&1)<<1|b>>c-e&1;return d||"0"}var d=b.match(/{(Q|quadkey)}/);d&&(b=b.replace("{subdomains}","{S}").replace("{zoom}","{Z}").replace("{quadkey}","{Q}"));var e=c&&c.length&&b.indexOf("{S}")>=0,g=function(a){var g=this.sourceCoordinate(a);if(!g)return null;var h=b;if(e){var i=parseInt(g.zoom+g.row+g.column,10)%c.length;h=h.replace("{S}",c[i])}return d?h.replace("{Z}",g.zoom.toFixed(0)).replace("{Q}",f(g.row,g.column,g.zoom)):h.replace("{Z}",g.zoom.toFixed(0)).replace("{X}",g.column.toFixed(0)).replace("{Y}",g.row.toFixed(0))};a.MapProvider.call(this,g)},a.Template.prototype={getTile:function(a){return this.getTileUrl(a)}},a.extend(a.Template,a.MapProvider),a.TemplatedLayer=function(b,c,d){return new a.Layer(new a.Template(b,c),null,d)},a.getMousePoint=function(b,c){var d=new a.Point(b.clientX,b.clientY);d.x+=document.body.scrollLeft+document.documentElement.scrollLeft,d.y+=document.body.scrollTop+document.documentElement.scrollTop;for(var e=c.parent;e;e=e.offsetParent)d.x-=e.offsetLeft,d.y-=e.offsetTop;return d},a.MouseWheelHandler=function(){function g(b){var g=0;e=e||(new Date).getTime();try{d.scrollTop=1e3,d.dispatchEvent(b),g=1e3-d.scrollTop}catch(h){g=b.wheelDelta||-b.detail*5}var i=(new Date).getTime()-e,j=a.getMousePoint(b,c);return Math.abs(g)>0&&i>200&&!f?(c.zoomByAbout(g>0?1:-1,j),e=(new Date).getTime()):f&&c.zoomByAbout(g*.001,j),a.cancelEvent(b)}var b={},c,d,e,f=!1;return b.init=function(e){c=e,d=document.body.appendChild(document.createElement("div")),d.style.cssText="visibility:hidden;top:0;height:0;width:0;overflow-y:scroll";var f=d.appendChild(document.createElement("div"));return f.style.height="2000px",a.addEvent(c.parent,"mousewheel",g),b},b.precise=function(a){return arguments.length?(f=a,b):f},b.remove=function(){a.removeEvent(c.parent,"mousewheel",g),d.parentNode.removeChild(d)},b},a.DoubleClickHandler=function(){function d(b){var d=a.getMousePoint(b,c);return c.zoomByAbout(b.shiftKey?-1:1,d),a.cancelEvent(b)}var b={},c;return b.init=function(e){return c=e,a.addEvent(c.parent,"dblclick",d),b},b.remove=function(){a.removeEvent(c.parent,"dblclick",d)},b},a.DragHandler=function(){function e(b){if(b.shiftKey||b.button==2)return;return a.addEvent(document,"mouseup",f),a.addEvent(document,"mousemove",g),c=new a.Point(b.clientX,b.clientY),d.parent.style.cursor="move",a.cancelEvent(b)}function f(b){return a.removeEvent(document,"mouseup",f),a.removeEvent(document,"mousemove",g),c=null,d.parent.style.cursor="",a.cancelEvent(b)}function g(b){return c&&(d.panBy(b.clientX-c.x,b.clientY-c.y),c.x=b.clientX,c.y=b.clientY,c.t=+(new Date)),a.cancelEvent(b)}var b={},c,d;return b.init=function(c){return d=c,a.addEvent(d.parent,"mousedown",e),b},b.remove=function(){a.removeEvent(d.parent,"mousedown",e)},b},a.MouseHandler=function(){var b={},c,d;return b.init=function(e){return c=e,d=[a.DragHandler().init(c),a.DoubleClickHandler().init(c),a.MouseWheelHandler().init(c)],b},b.remove=function(){for(var a=0;a<d.length;a++)d[a].remove();return b},b},a.TouchHandler=function(){function l(){var a=document.createElement("div");return a.setAttribute("ongesturestart","return;"),typeof a.ongesturestart=="function"}function m(a){for(var b=0;b<a.touches.length;b+=1){var c=a.touches[b];if(c.identifier in g){var d=g[c.identifier];d.x=c.clientX,d.y=c.clientY,d.scale=a.scale}else g[c.identifier]={scale:a.scale,startPos:{x:c.clientX,y:c.clientY},x:c.clientX,y:c.clientY,time:(new Date).getTime()}}}function n(a,b){return a&&a.touch&&b.identifier==a.touch.identifier}function o(a){m(a)}function p(b){switch(b.touches.length){case 1:u(b.touches[0]);break;case 2:v(b)}return m(b),a.cancelEvent(b)}function q(b){var c=(new Date).getTime();b.touches.length===0&&j&&w(k);for(var f=0;f<b.changedTouches.length;f+=1){var h=b.changedTouches[f],i=g[h.identifier];if(!i||i.wasPinch)continue;var l={x:h.clientX,y:h.clientY},m=c-i.time,n=a.Point.distance(l,i.startPos);n>e||(m>d?(l.end=c,l.duration=m,r(l)):(l.time=c,s(l)))}var o={};for(var p=0;p<b.touches.length;p++)o[b.touches[p].identifier]=!0;for(var q in g)q in o||delete o[q];return a.cancelEvent(b)}function r(a){}function s(a){if(h.length&&a.time-h[0].time<f){t(a),h=[];return}h=[a]}function t(b){var d=c.getZoom(),e=Math.round(d)+1,f=e-d,g=new a.Point(b.x,b.y);c.zoomByAbout(f,g)}function u(a){var b={x:a.clientX,y:a.clientY},d=g[a.identifier];c.panBy(b.x-d.x,b.y-d.y)}function v(b){var d=b.touches[0],e=b.touches[1],f=new a.Point(d.clientX,d.clientY),h=new a.Point(e.clientX,e.clientY),i=g[d.identifier],l=g[e.identifier];i.wasPinch=!0,l.wasPinch=!0;var m=a.Point.interpolate(f,h,.5);c.zoomByAbout(Math.log(b.scale)/Math.LN2-Math.log(i.scale)/Math.LN2,m);var n=a.Point.interpolate(i,l,.5);c.panBy(m.x-n.x,m.y-n.y),j=!0,k=m}function w(a){if(i){var b=c.getZoom(),d=Math.round(b);c.zoomByAbout(d-b,a)}j=!1}var b={},c,d=250,e=30,f=350,g={},h=[],i=!0,j=!1,k=null;return b.init=function(d){return c=d,l()?(a.addEvent(c.parent,"touchstart",o),a.addEvent(c.parent,"touchmove",p),a.addEvent(c.parent,"touchend",q),b):b},b.remove=function(){return l()?(a.removeEvent(c.parent,"touchstart",o),a.removeEvent(c.parent,"touchmove",p),a.removeEvent(c.parent,"touchend",q),b):b},b},a.CallbackManager=function(a,b){this.owner=a,this.callbacks={};for(var c=0;c<b.length;c++)this.callbacks[b[c]]=[]},a.CallbackManager.prototype={owner:null,callbacks:null,addCallback:function(a,b){typeof b=="function"&&this.callbacks[a]&&this.callbacks[a].push(b)},removeCallback:function(a,b){if(typeof b=="function"&&this.callbacks[a]){var c=this.callbacks[a],d=c.length;for(var e=0;e<d;e++)if(c[e]===b){c.splice(e,1);break}}},dispatchCallback:function(a,b){if(this.callbacks[a])for(var c=0;c<this.callbacks[a].length;c+=1)try{this.callbacks[a][c](this.owner,b)}catch(d){}}},a.RequestManager=function(){this.loadingBay=document.createDocumentFragment(),this.requestsById={},this.openRequestCount=0,this.maxOpenRequests=4,this.requestQueue=[],this.callbackManager=new a.CallbackManager(this,["requestcomplete","requesterror"])},a.RequestManager.prototype={loadingBay:null,requestsById:null,requestQueue:null,openRequestCount:null,maxOpenRequests:null,callbackManager:null,addCallback:function(a,b){this.callbackManager.addCallback(a,b)},removeCallback:function(a,b){this.callbackManager.removeCallback(a,b)},dispatchCallback:function(a,b){this.callbackManager.dispatchCallback(a,b)},clear:function(){this.clearExcept({})},clearRequest:function(a){a in this.requestsById&&delete this.requestsById[a];for(var b=0;b<this.requestQueue.length;b++){var c=this.requestQueue[b];c&&c.id==a&&(this.requestQueue[b]=null)}},clearExcept:function(a){for(var b=0;b<this.requestQueue.length;b++){var c=this.requestQueue[b];c&&!(c.id in a)&&(this.requestQueue[b]=null)}var d=this.loadingBay.childNodes;for(var e=d.length-1;e>=0;e--){var f=d[e];f.id in a||(this.loadingBay.removeChild(f),this.openRequestCount--,f.src=f.coord=f.onload=f.onerror=null)}for(var g in this.requestsById)if(!(g in a)&&this.requestsById.hasOwnProperty(g)){var h=this.requestsById[g];delete this.requestsById[g],h!==null&&(h=h.id=h.coord=h.url=null)}},hasRequest:function(a){return a in this.requestsById},requestTile:function(a,b,c){if(!(a in this.requestsById)){var d={id:a,coord:b.copy(),url:c};this.requestsById[a]=d,c&&this.requestQueue.push(d)}},getProcessQueue:function(){if(!this._processQueue){var a=this;this._processQueue=function(){a.processQueue()}}return this._processQueue},processQueue:function(a){a&&this.requestQueue.length>8&&this.requestQueue.sort(a);while(this.openRequestCount<this.maxOpenRequests&&this.requestQueue.length>0){var b=this.requestQueue.pop();if(b){this.openRequestCount++;var c=document.createElement("img");c.id=b.id,c.style.position="absolute",c.coord=b.coord,this.loadingBay.appendChild(c),c.onload=c.onerror=this.getLoadComplete(),c.src=b.url,b=b.id=b.coord=b.url=null}}},_loadComplete:null,getLoadComplete:function(){if(!this._loadComplete){var a=this;this._loadComplete=function(b){b=b||window.event;var c=b.srcElement||b.target;c.onload=c.onerror=null,a.loadingBay.removeChild(c),a.openRequestCount--,delete a.requestsById[c.id],b.type==="load"&&(c.complete||c.readyState&&c.readyState=="complete")?a.dispatchCallback("requestcomplete",c):(a.dispatchCallback("requesterror",{element:c,url:""+c.src}),c.src=null),setTimeout(a.getProcessQueue(),0)}}return this._loadComplete}},a.Layer=function(b,c,d){this.parent=c||document.createElement("div"),this.parent.style.cssText="position: absolute; top: 0px; left: 0px; width: 100%; height: 100%; margin: 0; padding: 0; z-index: 0",this.name=d,this.levels={},this.requestManager=new a.RequestManager,this.requestManager.addCallback("requestcomplete",this.getTileComplete()),this.requestManager.addCallback("requesterror",this.getTileError()),b&&this.setProvider(b)},a.Layer.prototype={map:null,parent:null,name:null,enabled:!0,tiles:null,levels:null,requestManager:null,provider:null,_tileComplete:null,getTileComplete:function(){if(!this._tileComplete){var a=this;this._tileComplete=function(b,c){a.tiles[c.id]=c,a.positionTile(c)}}return this._tileComplete},getTileError:function(){if(!this._tileError){var a=this;this._tileError=function(b,c){c.element.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",a.tiles[c.element.id]=c.element,a.positionTile(c.element)}}return this._tileError},draw:function(){function c(a,c){if(a&&c){var d=a.coord,e=c.coord;if(d.zoom==e.zoom){var f=Math.abs(b.row-d.row-.5)+Math.abs(b.column-d.column-.5),g=Math.abs(b.row-e.row-.5)+Math.abs(b.column-e.column-.5);return f<g?1:f>g?-1:0}return d.zoom<e.zoom?1:d.zoom>e.zoom?-1:0}return a?1:c?-1:0}if(!this.enabled||!this.map)return;var b=this.map.coordinate.zoomTo(Math.round(this.map.coordinate.zoom)),d=Math.round(this.map.coordinate.zoom),e=this.map.pointCoordinate(new a.Point(0,0)).zoomTo(d).container(),f=this.map.pointCoordinate(this.map.dimensions).zoomTo(d).container().right().down(),g={},h=this.createOrGetLevel(e.zoom),i=e.copy();for(i.column=e.column;i.column<=f.column;i.column++)for(i.row=e.row;i.row<=f.row;i.row++){var j=this.inventoryVisibleTile(h,i);while(j.length)g[j.pop()]=!0}for(var k in this.levels)if(this.levels.hasOwnProperty(k)){var l=parseInt(k,10);if(l>=e.zoom-5&&l<e.zoom+2)continue;var m=this.levels[k];m.style.display="none";var n=this.tileElementsInLevel(m);while(n.length)this.provider.releaseTile(n[0].coord),this.requestManager.clearRequest(n[0].coord.toKey()),m.removeChild(n[0]),n.shift()}var o=e.zoom-5,p=e.zoom+2;for(var q=o;q<p;q++)this.adjustVisibleLevel(this.levels[q],q,g);this.requestManager.clearExcept(g),this.requestManager.processQueue(c)},inventoryVisibleTile:function(a,b){var c=b.toKey(),d=[c];if(c in this.tiles){var e=this.tiles[c];return e.parentNode!=a&&(a.appendChild(e),"reAddTile"in this.provider&&this.provider.reAddTile(c,b,e)),d}if(!this.requestManager.hasRequest(c)){var f=this.provider.getTile(b);typeof f=="string"?this.addTileImage(c,b,f):f&&this.addTileElement(c,b,f)}var g=!1,h=b.zoom;for(var i=1;i<=h;i++){var j=b.zoomBy(-i).container(),k=j.toKey();if(k in this.tiles){d.push(k),g=!0;break}}if(!g){var l=b.zoomBy(1);d.push(l.toKey()),l.column+=1,d.push(l.toKey()),l.row+=1,d.push(l.toKey()),l.column-=1,d.push(l.toKey())}return d},tileElementsInLevel:function(a){var b=[];for(var c=a.firstChild;c;c=c.nextSibling)c.nodeType==1&&b.push(c);return b},adjustVisibleLevel:function(b,c,d){if(!b)return;var e=1,f=this.map.coordinate.copy();if(b.childNodes.length>0)b.style.display="block",e=Math.pow(2,this.map.coordinate.zoom-c),f=f.zoomTo(c);else return b.style.display="none",!1;var g=this.map.tileSize.x*e,h=this.map.tileSize.y*e,i=new a.Point(this.map.dimensions.x/2,this.map.dimensions.y/2),j=this.tileElementsInLevel(b);while(j.length){var k=j.pop();d[k.id]?a.moveElement(k,{x:Math.round(i.x+(k.coord.column-f.column)*g),y:Math.round(i.y+(k.coord.row-f.row)*h),scale:e,width:this.map.tileSize.x,height:this.map.tileSize.y}):(this.provider.releaseTile(k.coord),this.requestManager.clearRequest(k.coord.toKey()),b.removeChild(k))}},createOrGetLevel:function(a){if(a in this.levels)return this.levels[a];var b=document.createElement("div");return b.id=this.parent.id+"-zoom-"+a,b.style.cssText="position: absolute; top: 0px; left: 0px; width: 100%; height: 100%; margin: 0; padding: 0;",b.style.zIndex=a,this.parent.appendChild(b),this.levels[a]=b,b},addTileImage:function(a,b,c){this.requestManager.requestTile(a,b,c)},addTileElement:function(a,b,c){c.id=a,c.coord=b.copy(),this.positionTile(c)},positionTile:function(b){var c=this.map.coordinate.zoomTo(b.coord.zoom);b.style.cssText="position:absolute;-webkit-user-select:none;-webkit-user-drag:none;-moz-user-drag:none;-webkit-transform-origin:0 0;-moz-transform-origin:0 0;-o-transform-origin:0 0;-ms-transform-origin:0 0;width:"+this.map.tileSize.x+"px; height: "+this.map.tileSize.y+"px;",b.ondragstart=function(){return!1};var d=Math.pow(2,this.map.coordinate.zoom-b.coord.zoom);a.moveElement(b,{x:Math.round(this.map.dimensions.x/2+(b.coord.column-c.column)*this.map.tileSize.x),y:Math.round(this.map.dimensions.y/2+(b.coord.row-c.row)*this.map.tileSize.y),scale:d,width:this.map.tileSize.x,height:this.map.tileSize.y});var e=this.levels[b.coord.zoom];e.appendChild(b),b.className="map-tile-loaded",Math.round(this.map.coordinate.zoom)==b.coord.zoom&&(e.style.display="block"),this.requestRedraw()},_redrawTimer:undefined,requestRedraw:function(){this._redrawTimer||(this._redrawTimer=setTimeout(this.getRedraw(),1e3))},_redraw:null,getRedraw:function(){if(!this._redraw){var a=this;this._redraw=function(){a.draw(),a._redrawTimer=0}}return this._redraw},setProvider:function(a){var b=this.provider===null;if(!b){this.requestManager.clear();for(var c in this.levels)if(this.levels.hasOwnProperty(c)){var d=this.levels[c];while(d.firstChild)this.provider.releaseTile(d.firstChild.coord),d.removeChild(d.firstChild)}}this.tiles={},this.provider=a,b||this.draw()},enable:function(){return this.enabled=!0,this.parent.style.display="",this.draw(),this},disable:function(){return this.enabled=!1,this.requestManager.clear(),this.parent.style.display="none",this},destroy:function(){this.requestManager.clear(),this.requestManager.removeCallback("requestcomplete",this.getTileComplete()),this.requestManager.removeCallback("requesterror",this.getTileError()),this.provider=null,this.parent.parentNode&&this.parent.parentNode.removeChild(this.parent),this.map=null}},a.Map=function(b,c,d,e){if(typeof b=="string"){b=document.getElementById(b);if(!b)throw"The ID provided to modest maps could not be found."}this.parent=b,this.parent.style.padding="0",this.parent.style.overflow="hidden";var f=a.getStyle(this.parent,"position");f!="relative"&&f!="absolute"&&(this.parent.style.position="relative"),this.layers=[],c||(c=[]),c instanceof Array||(c=[c]);for(var g=0;g<c.length;g++)this.addLayer(c[g]);this.projection=new a.MercatorProjection(0,a.deriveTransformation(-Math.PI,Math.PI,0,0,Math.PI,Math.PI,1,0,-Math.PI,-Math.PI,0,1)),this.tileSize=new a.Point(256,256),this.coordLimits=[new a.Coordinate(0,-Infinity,0),(new a.Coordinate(1,Infinity,0)).zoomTo(18)],this.coordinate=new a.Coordinate(.5,.5,0),d?(this.autoSize=!1,this.parent.style.width=Math.round(d.x)+"px",this.parent.style.height=Math.round(d.y)+"px"):(d=new a.Point(this.parent.offsetWidth,this.parent.offsetHeight),this.autoSize=!0,a.addEvent(window,"resize",this.windowResize())),this.dimensions=d,this.callbackManager=new a.CallbackManager(this,["zoomed","panned","centered","extentset","resized","drawn"]);if(e===undefined)this.eventHandlers=[a.MouseHandler().init(this),a.TouchHandler().init(this)];else{this.eventHandlers=e;if(e instanceof Array)for(var h=0;h<e.length;h++)e[h].init(this)}},a.Map.prototype={parent:null,dimensions:null,projection:null,coordinate:null,tileSize:null,coordLimits:null,layers:null,callbackManager:null,eventHandlers:null,autoSize:null,toString:function(){return"Map(#"+this.parent.id+")"},addCallback:function(a,b){return this.callbackManager.addCallback(a,b),this},removeCallback:function(a,b){return this.callbackManager.removeCallback(a,b),this},dispatchCallback:function(a,b){return this.callbackManager.dispatchCallback(a,b),this},windowResize:function(){if(!this._windowResize){var b=this;this._windowResize=function(c){b.dimensions=new a.Point(b.parent.offsetWidth,b.parent.offsetHeight),b.draw(),b.dispatchCallback("resized",[b.dimensions])}}return this._windowResize},setZoomRange:function(a,b){return this.coordLimits[0]=this.coordLimits[0].zoomTo(a),this.coordLimits[1]=this.coordLimits[1].zoomTo(b),this},zoomBy:function(b){return this.coordinate=this.enforceLimits(this.coordinate.zoomBy(b)),a.getFrame(this.getRedraw()),this.dispatchCallback("zoomed",b),this},zoomIn:function(){return this.zoomBy(1)},zoomOut:function(){return this.zoomBy(-1)},setZoom:function(a){return this.zoomBy(a-this.coordinate.zoom)},zoomByAbout:function(a,b){var c=this.pointLocation(b);this.coordinate=this.enforceLimits(this.coordinate.zoomBy(a));var d=this.locationPoint(c);return this.dispatchCallback("zoomed",a),this.panBy(b.x-d.x,b.y-d.y)},panBy:function(b,c){return this.coordinate.column-=b/this.tileSize.x,this.coordinate.row-=c/this.tileSize.y,this.coordinate=this.enforceLimits(this.coordinate),a.getFrame(this.getRedraw()),this.dispatchCallback("panned",[b,c]),this},panLeft:function(){return this.panBy(100,0)},panRight:function(){return this.panBy(-100,0)},panDown:function(){return this.panBy(0,-100)},panUp:function(){return this.panBy(0,100)},setCenter:function(a){return this.setCenterZoom(a,this.coordinate.zoom)},setCenterZoom:function(b,c){return this.coordinate=this.projection.locationCoordinate(b).zoomTo(parseFloat(c)||0),this.coordinate=this.enforceLimits(this.coordinate),a.getFrame(this.getRedraw()),this.dispatchCallback("centered",[b,c]),this},extentCoordinate:function(b,c){b instanceof a.Extent&&(b=b.toArray());var d,e;for(var f=0;f<b.length;f++){var g=this.projection.locationCoordinate(b[f]);d?(d.row=Math.min(d.row,g.row),d.column=Math.min(d.column,g.column),d.zoom=Math.min(d.zoom,g.zoom),e.row=Math.max(e.row,g.row),e.column=Math.max(e.column,g.column),e.zoom=Math.max(e.zoom,g.zoom)):(d=g.copy(),e=g.copy())}var h=this.dimensions.x+1,i=this.dimensions.y+1,j=(e.column-d.column)/(h/this.tileSize.x),k=Math.log(j)/Math.log(2),l=d.zoom-(c?k:Math.ceil(k)),m=(e.row-d.row)/(i/this.tileSize.y),n=Math.log(m)/Math.log(2),o=d.zoom-(c?n:Math.ceil(n)),p=Math.min(l,o);p=Math.min(p,this.coordLimits[1].zoom),p=Math.max(p,this.coordLimits[0].zoom);var q=(d.row+e.row)/2,r=(d.column+e.column)/2,s=d.zoom;return(new a.Coordinate(q,r,s)).zoomTo(p)},setExtent:function(b,c){return this.coordinate=this.extentCoordinate(b,c),this.coordinate=this.enforceLimits(this.coordinate),a.getFrame(this.getRedraw()),this.dispatchCallback("extentset",b),this},setSize:function(b){return this.dimensions=new a.Point(b.x,b.y),this.parent.style.width=Math.round(this.dimensions.x)+"px",this.parent.style.height=Math.round(this.dimensions.y)+"px",this.autoSize&&(a.removeEvent(window,"resize",this.windowResize()),this.autoSize=!1),this.draw(),this.dispatchCallback("resized",this.dimensions),this},coordinatePoint:function(b){b.zoom!=this.coordinate.zoom&&(b=b.zoomTo(this.coordinate.zoom));var c=new a.Point(this.dimensions.x/2,this.dimensions.y/2);return c.x+=this.tileSize.x*(b.column-this.coordinate.column),c.y+=this.tileSize.y*(b.row-this.coordinate.row),c},pointCoordinate:function(a){var b=this.coordinate.copy();return b.column+=(a.x-this.dimensions.x/2)/this.tileSize.x,b.row+=(a.y-this.dimensions.y/2)/this.tileSize.y,b},locationCoordinate:function(a){return this.projection.locationCoordinate(a)},coordinateLocation:function(a){return this.projection.coordinateLocation(a)},locationPoint:function(a){return this.coordinatePoint(this.locationCoordinate(a))},pointLocation:function(a){return this.coordinateLocation(this.pointCoordinate(a))},getExtent:function(){return new a.Extent(this.pointLocation(new a.Point(0,0)),this.pointLocation(this.dimensions))},extent:function(a,b){return a?this.setExtent(a,b):this.getExtent()},getCenter:function(){return this.projection.coordinateLocation(this.coordinate)},center:function(a){return a?this.setCenter(a):this.getCenter()},getZoom:function(){return this.coordinate.zoom},zoom:function(a){return a!==undefined?this.setZoom(a):this.getZoom()},getLayers:function(){return this.layers.slice()},getLayer:function(a){for(var b=0;b<this.layers.length;b++)if(a==this.layers[b].name)return this.layers[b]},getLayerAt:function(a){return this.layers[a]},addLayer:function(b){return this.layers.push(b),this.parent.appendChild(b.parent),b.map=this,this.coordinate&&a.getFrame(this.getRedraw()),this},removeLayer:function(a){for(var b=0;b<this.layers.length;b++)if(a==this.layers[b]||a==this.layers[b].name){this.removeLayerAt(b);break}return this},setLayerAt:function(b,c){if(b<0||b>=this.layers.length)throw new Error("invalid index in setLayerAt(): "+b);if(this.layers[b]!=c){if(b<this.layers.length){var d=this.layers[b];this.parent.insertBefore(c.parent,d.parent),d.destroy()}else this.parent.appendChild(c.parent);this.layers[b]=c,c.map=this,a.getFrame(this.getRedraw())}return this},insertLayerAt:function(b,c){if(b<0||b>this.layers.length)throw new Error("invalid index in insertLayerAt(): "+b);if(b==this.layers.length)this.layers.push(c),this.parent.appendChild(c.parent);else{var d=this.layers[b];this.parent.insertBefore(c.parent,d.parent),this.layers.splice(b,0,c)}return c.map=this,a.getFrame(this.getRedraw()),this},removeLayerAt:function(a){if(a<0||a>=this.layers.length)throw new Error("invalid index in removeLayer(): "+a);var b=this.layers[a];return this.layers.splice(a,1),b.destroy(),this},swapLayersAt:function(a,b){if(a<0||a>=this.layers.length||b<0||b>=this.layers.length)throw new Error("invalid index in swapLayersAt(): "+index);var c=
this.layers[a],d=this.layers[b],e=document.createElement("div");return this.parent.replaceChild(e,d.parent),this.parent.replaceChild(d.parent,c.parent),this.parent.replaceChild(c.parent,e),this.layers[a]=d,this.layers[b]=c,this},enableLayer:function(a){var b=this.getLayer(a);return b&&b.enable(),this},enableLayerAt:function(a){var b=this.getLayerAt(a);return b&&b.enable(),this},disableLayer:function(a){var b=this.getLayer(a);return b&&b.disable(),this},disableLayerAt:function(a){var b=this.getLayerAt(a);return b&&b.disable(),this},enforceZoomLimits:function(a){var b=this.coordLimits;if(b){var c=b[0].zoom,d=b[1].zoom;a.zoom<c?a=a.zoomTo(c):a.zoom>d&&(a=a.zoomTo(d))}return a},enforcePanLimits:function(b){if(this.coordLimits){b=b.copy();var c=this.coordLimits[0].zoomTo(b.zoom),d=this.coordLimits[1].zoomTo(b.zoom),e=this.pointCoordinate(new a.Point(0,0)).zoomTo(b.zoom),f=this.pointCoordinate(this.dimensions).zoomTo(b.zoom);d.row-c.row<f.row-e.row?b.row=(d.row+c.row)/2:e.row<c.row?b.row+=c.row-e.row:f.row>d.row&&(b.row-=f.row-d.row),d.column-c.column<f.column-e.column?b.column=(d.column+c.column)/2:e.column<c.column?b.column+=c.column-e.column:f.column>d.column&&(b.column-=f.column-d.column)}return b},enforceLimits:function(a){return this.enforcePanLimits(this.enforceZoomLimits(a))},draw:function(){this.coordinate=this.enforceLimits(this.coordinate);if(this.dimensions.x<=0||this.dimensions.y<=0){if(!this.autoSize)return;var b=this.parent.offsetWidth,c=this.parent.offsetHeight;this.dimensions=new a.Point(b,c);if(b<=0||c<=0)return}for(var d=0;d<this.layers.length;d++)this.layers[d].draw();this.dispatchCallback("drawn")},_redrawTimer:undefined,requestRedraw:function(){this._redrawTimer||(this._redrawTimer=setTimeout(this.getRedraw(),1e3))},_redraw:null,getRedraw:function(){if(!this._redraw){var a=this;this._redraw=function(){a.draw(),a._redrawTimer=0}}return this._redraw},destroy:function(){for(var b=0;b<this.layers.length;b++)this.layers[b].destroy();this.layers=[],this.projection=null;for(var c=0;c<this.eventHandlers.length;c++)this.eventHandlers[c].remove();this.autoSize&&a.removeEvent(window,"resize",this.windowResize())}},a.mapByCenterZoom=function(b,c,d,e){var f=a.coerceLayer(c),g=new a.Map(b,f,!1);return g.setCenterZoom(d,e).draw(),g},a.mapByExtent=function(b,c,d,e){var f=a.coerceLayer(c),g=new a.Map(b,f,!1);return g.setExtent([d,e]).draw(),g},typeof module!="undefined"&&module.exports&&(module.exports={Point:a.Point,Projection:a.Projection,MercatorProjection:a.MercatorProjection,LinearProjection:a.LinearProjection,Transformation:a.Transformation,Location:a.Location,MapProvider:a.MapProvider,Template:a.Template,Coordinate:a.Coordinate,deriveTransformation:a.deriveTransformation})})(MM)