/**
 * @file core/kernels/kernels.hpp
 * @author Ryan Curtin
 *
 * Convenience include for all kernels implemented in mlpack.
 *
 * mlpack is free software; you may redistribute it and/or modify it under the
 * terms of the 3-clause BSD license.  You should have received a copy of the
 * 3-clause BSD license along with mlpack.  If not, see
 * http://www.opensource.org/licenses/BSD-3-Clause for more information.
 */
#ifndef MLPACK_CORE_KERNELS_KERNELS_HPP
#define MLPACK_CORE_KERNELS_KERNELS_HPP

#include "kernel_traits.hpp"

#include "cauchy_kernel.hpp"
#include "cosine_distance.hpp"
#include "epanechnikov_kernel.hpp"
#include "example_kernel.hpp"
#include "gaussian_kernel.hpp"
#include "hyperbolic_tangent_kernel.hpp"
#include "laplacian_kernel.hpp"
#include "linear_kernel.hpp"
#include "polynomial_kernel.hpp"
#include "pspectrum_string_kernel.hpp"
#include "spherical_kernel.hpp"
#include "triangular_kernel.hpp"

#endif
