/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * Authors:
 *    Jussi Pakkanen <jussi.pakkanen@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of version 3 of the GNU General Public License as published
 * by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef EXTRACTOR_DETECTEDFILE_H
#define EXTRACTOR_DETECTEDFILE_H

#include <cstdint>
#include <string>
#include "../mediascanner/scannercore.hh"

namespace mediascanner {

struct DetectedFile {
    DetectedFile(const std::string &filename,
                 const std::string &etag,
                 const std::string &content_type,
                 uint64_t mtime,
                 MediaType type)
        : filename(filename), etag(etag), content_type(content_type)
        , mtime(mtime), type(type) {}

    std::string filename;
    std::string etag;
    std::string content_type;
    uint64_t mtime;
    MediaType type;
};

}

#endif
