
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file IsoShadingAttributes.h
    \\brief Definition of IsoShading Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "IsoShadingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

IsoShadingAttributes::IsoShadingAttributes():
	
	technique_(MagTranslator<string, ShadingTechnique>().magics("contour_shade_technique")),
	colourMethod_(MagTranslator<string, ColourTechnique>().magics("contour_shade_colour_method"))
	
{
}


IsoShadingAttributes::~IsoShadingAttributes()
{

}


void IsoShadingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(5);
	int i = 0;
	prefix[i++] = "contour";
	prefix[i++] = "contour";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	prefix[i++] = "contour_shade";
	
	
	setMember(prefix, "contour_shade_technique", technique_, params);
	setMember(prefix, "contour_shade_colour_method", colourMethod_, params);
	
}

void IsoShadingAttributes::copy(const IsoShadingAttributes& other)
{
	technique_ = unique_ptr<ShadingTechnique>(other.technique_->clone());
	colourMethod_ = unique_ptr<ColourTechnique>(other.colourMethod_->clone());
	
}


bool IsoShadingAttributes::accept(const string& node)
{

	if ( magCompare(node, "shading")  )
		return true;
	if ( acceptNode(node, technique_) )
		return true;
	if ( acceptNode(node, colourMethod_) )
		return true;
	
	return false;
}

void IsoShadingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "shading")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), technique_, node);
		setMember(node.name(), colourMethod_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), technique_, *elt);
		setMember(elt->name(), colourMethod_, *elt);
		
	}
}

void IsoShadingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " technique = " <<  *technique_;
	out << " colourMethod = " <<  *colourMethod_;
	
	out << "]" << "\n";
}

void IsoShadingAttributes::toxml(ostream& out)  const
{
	out <<  "\"shading\"";
	out << ", \"contour_shade_technique\":";
	technique_->toxml(out);
	out << ", \"contour_shade_colour_method\":";
	colourMethod_->toxml(out);
	
}

static MagicsParameter<string> contour_shade_technique("contour_shade_technique", "polygon_shading");
static MagicsParameter<string> contour_shade_colour_method("contour_shade_colour_method", "calculate");
#include "PolyShadingTechnique.h"
#include "CellShading.h"
#include "MarkerShadingTechnique.h"
#include "CalculateColourTechnique.h"
#include "ListColourTechnique.h"
#include "GradientsColourTechnique.h"
#include "ColourTechnique.h"
static SimpleObjectMaker<PolyShadingTechnique , ShadingTechnique> polygon_PolyShadingTechnique("polygon");
static SimpleObjectMaker<PolyShadingTechnique , ShadingTechnique> polygon_shading_PolyShadingTechnique("polygon_shading");
static SimpleObjectMaker<GridShading , ShadingTechnique> grid_shading_GridShading("grid_shading");
static SimpleObjectMaker<CellShading , ShadingTechnique> cell_shading_CellShading("cell_shading");
static SimpleObjectMaker<DumpShading , ShadingTechnique> dump_shading_DumpShading("dump_shading");
static SimpleObjectMaker<MarkerShadingTechnique , ShadingTechnique> marker_MarkerShadingTechnique("marker");
static SimpleObjectMaker<CalculateColourTechnique , ColourTechnique> calculate_CalculateColourTechnique("calculate");
static SimpleObjectMaker<ListColourTechnique , ColourTechnique> list_ListColourTechnique("list");
static SimpleObjectMaker<GradientsColourTechnique , ColourTechnique> gradients_GradientsColourTechnique("gradients");
static SimpleObjectMaker<PaletteColourTechnique , ColourTechnique> palette_PaletteColourTechnique("palette");
