/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file HiLoAttributes.cc
    \brief Implementation of HiLo Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Mon Apr 15 17:55:24 2013
*/    

#include "HiLoAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


HiLoAttributes::HiLoAttributes():
	type_(MagTranslator<string, HiLoTechnique>().magics("contour_hilo_type")),
	window_size_(ParameterManager::getInt("contour_hilo_window_size")),
	suppress_radius_(ParameterManager::getDouble("contour_hilo_suppress_radius")),
	hilo_max_value_(ParameterManager::getDouble("contour_hilo_max_value")),
	hilo_min_value_(ParameterManager::getDouble("contour_hilo_min_value")),
	hi_max_value_(ParameterManager::getDouble("contour_hi_max_value")),
	hi_min_value_(ParameterManager::getDouble("contour_hi_min_value")),
	lo_max_value_(ParameterManager::getDouble("contour_lo_max_value")),
	lo_min_value_(ParameterManager::getDouble("contour_lo_min_value")),
	marker_(MagTranslator<string, HiLoMarkerBase>().magics("contour_hilo_marker"))
{
} 



HiLoAttributes::~HiLoAttributes()
{
}

    
void HiLoAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "contour_hilo";
	prefix[1] = "contour";

	setMember(prefix, "contour_hilo_type", type_, params);
	setAttribute(prefix, "contour_hilo_window_size", window_size_, params);
	setAttribute(prefix, "contour_hilo_suppress_radius", suppress_radius_, params);
	setAttribute(prefix, "contour_hilo_max_value", hilo_max_value_, params);
	setAttribute(prefix, "contour_hilo_min_value", hilo_min_value_, params);
	setAttribute(prefix, "contour_hi_max_value", hi_max_value_, params);
	setAttribute(prefix, "contour_hi_min_value", hi_min_value_, params);
	setAttribute(prefix, "contour_lo_max_value", lo_max_value_, params);
	setAttribute(prefix, "contour_lo_min_value", lo_min_value_, params);
	setMember(prefix, "contour_hilo_marker", marker_, params);
}

void HiLoAttributes::copy(const HiLoAttributes& other)
{
	type_ = auto_ptr<HiLoTechnique>(other.type_->clone());
	window_size_ = other.window_size_;
	suppress_radius_ = other.suppress_radius_;
	hilo_max_value_ = other.hilo_max_value_;
	hilo_min_value_ = other.hilo_min_value_;
	hi_max_value_ = other.hi_max_value_;
	hi_min_value_ = other.hi_min_value_;
	lo_max_value_ = other.lo_max_value_;
	lo_min_value_ = other.lo_min_value_;
	marker_ = auto_ptr<HiLoMarkerBase>(other.marker_->clone());
} 


bool HiLoAttributes::accept(const string& node)
{	
	if ( magCompare(node, "hilo")  )
		return true;

	if ( acceptNode(node, type_) )
		return true;

	if ( acceptNode(node, marker_) )
		return true;
	return false;
}

void HiLoAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "hilo") )
		set(node.attributes());
	else {
		setMember(node.name(), type_, node);
		setMember(node.name(), marker_, node);
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
		setMember((*elt)->name(), type_, *(*elt)); 
		setMember((*elt)->name(), marker_, *(*elt)); 
	}
}

void HiLoAttributes::print(ostream& out)  const
{
	out << "HiLoAttributes[";
	out << "type = " << *type_;
	out << ", window_size = " << window_size_;
	out << ", suppress_radius = " << suppress_radius_;
	out << ", hilo_max_value = " << hilo_max_value_;
	out << ", hilo_min_value = " << hilo_min_value_;
	out << ", hi_max_value = " << hi_max_value_;
	out << ", hi_min_value = " << hi_min_value_;
	out << ", lo_max_value = " << lo_max_value_;
	out << ", lo_min_value = " << lo_min_value_;
	out << ", marker = " << *marker_;
	out << "]" << "\n";
}


void HiLoAttributes::toxml(ostream& out)  const
{
     out <<  "\"hilo\"";
	 out << ", \"contour_hilo_type\":";
	 type_->toxml(out);
	 out << ", \"contour_hilo_window_size\":";
	 niceprint(out,window_size_);
	 out << ", \"contour_hilo_suppress_radius\":";
	 niceprint(out,suppress_radius_);
	 out << ", \"contour_hilo_max_value\":";
	 niceprint(out,hilo_max_value_);
	 out << ", \"contour_hilo_min_value\":";
	 niceprint(out,hilo_min_value_);
	 out << ", \"contour_hi_max_value\":";
	 niceprint(out,hi_max_value_);
	 out << ", \"contour_hi_min_value\":";
	 niceprint(out,hi_min_value_);
	 out << ", \"contour_lo_max_value\":";
	 niceprint(out,lo_max_value_);
	 out << ", \"contour_lo_min_value\":";
	 niceprint(out,lo_min_value_);
	 out << ", \"contour_hilo_marker\":";
	 marker_->toxml(out);
}
static MagicsParameter<string> contour_hilo_type("contour_hilo_type", "text", " New Magics: Parameter contour_hilo_type sent to new Magics[HiLo].  ");
static MagicsParameter<int> contour_hilo_window_size("contour_hilo_window_size", 3, " New Magics: Parameter contour_hilo_window_size sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hilo_suppress_radius("contour_hilo_suppress_radius", 15.0, " New Magics: Parameter contour_hilo_suppress_radius sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hilo_max_value("contour_hilo_max_value", 1.0e+21, " New Magics: Parameter contour_hilo_max_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hilo_min_value("contour_hilo_min_value", -1.0e+21, " New Magics: Parameter contour_hilo_min_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hi_max_value("contour_hi_max_value", 1.0e+21, " New Magics: Parameter contour_hi_max_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_hi_min_value("contour_hi_min_value", -1.0e+21, " New Magics: Parameter contour_hi_min_value sent to new Magics[HiLo].  ");
static MagicsParameter<double> contour_lo_max_value("contour_lo_max_value", 1.0e+21, "");
static MagicsParameter<double> contour_lo_min_value("contour_lo_min_value", -1.0e+21, "");
static MagicsParameter<string> contour_hilo_marker("contour_hilo_marker", "off", "");
#include "HiLoBoth.h"
#include "HiLoText.h"
#include "HiLoNumber.h"
static SimpleObjectMaker<HiLoText, HiLoTechnique> text_HiLoText("text");
static SimpleObjectMaker<HiLoNumber, HiLoTechnique> number_HiLoNumber("number");
static SimpleObjectMaker<HiLoBoth, HiLoTechnique> both_HiLoBoth("both");
#include "HiLoMarker.h"
static SimpleObjectMaker<HiLoMarker, HiLoMarkerBase> on_HiLoMarker("on");
static SimpleObjectMaker<HiLoMarker, HiLoMarkerBase> marker_HiLoMarker("marker");
static SimpleObjectMaker<NoHiLoMarker, HiLoMarkerBase> off_NoHiLoMarker("off");
static SimpleObjectMaker<NoHiLoMarker, HiLoMarkerBase> nomarker_NoHiLoMarker("nomarker");
