; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-CVT
; RUN: llc < %s -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

; Round towards minus infinity (fcvtmu).

define i32 @testmuwh(half %a) {
; CHECK-CVT-LABEL: testmuwh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintm s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testmuwh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtmu w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.floor.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testmuxh(half %a) {
; CHECK-CVT-LABEL: testmuxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintm s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testmuxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtmu x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.floor.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testmuws(float %a) {
; CHECK-LABEL: testmuws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtmu w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @floorf(float %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testmuxs(float %a) {
; CHECK-LABEL: testmuxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtmu x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @floorf(float %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testmuwd(double %a) {
; CHECK-LABEL: testmuwd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtmu w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @floor(double %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testmuxd(double %a) {
; CHECK-LABEL: testmuxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtmu x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @floor(double %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f64(double %r)
  ret i64 %i
}

; Round towards plus infinity (fcvtpu).

define i32 @testpuwh(half %a) {
; CHECK-CVT-LABEL: testpuwh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintp s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testpuwh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtpu w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.ceil.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testpuxh(half %a) {
; CHECK-CVT-LABEL: testpuxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintp s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testpuxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtpu x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.ceil.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testpuws(float %a) {
; CHECK-LABEL: testpuws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtpu w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @ceilf(float %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testpuxs(float %a) {
; CHECK-LABEL: testpuxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtpu x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @ceilf(float %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testpuwd(double %a) {
; CHECK-LABEL: testpuwd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtpu w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @ceil(double %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testpuxd(double %a) {
; CHECK-LABEL: testpuxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtpu x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @ceil(double %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f64(double %r)
  ret i64 %i
}

; Round towards zero (fcvtzu).

define i32 @testzuwh(half %a) {
; CHECK-CVT-LABEL: testzuwh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintz s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testzuwh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzu w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.trunc.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testzuxh(half %a) {
; CHECK-CVT-LABEL: testzuxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frintz s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testzuxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtzu x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.trunc.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testzuws(float %a) {
; CHECK-LABEL: testzuws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @truncf(float %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testzuxs(float %a) {
; CHECK-LABEL: testzuxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @truncf(float %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testzuwd(double %a) {
; CHECK-LABEL: testzuwd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @trunc(double %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testzuxd(double %a) {
; CHECK-LABEL: testzuxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtzu x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @trunc(double %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f64(double %r)
  ret i64 %i
}

; Round to nearest, ties away from zero (fcvtau).

define i32 @testauwh(half %a) {
; CHECK-CVT-LABEL: testauwh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frinta s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu w0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testauwh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtau w0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.round.f16(half %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f16(half %r)
  ret i32 %i
}

define i64 @testauxh(half %a) {
; CHECK-CVT-LABEL: testauxh:
; CHECK-CVT:       // %bb.0: // %entry
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    frinta s0, s0
; CHECK-CVT-NEXT:    fcvt h0, s0
; CHECK-CVT-NEXT:    fcvt s0, h0
; CHECK-CVT-NEXT:    fcvtzu x0, s0
; CHECK-CVT-NEXT:    ret
;
; CHECK-FP16-LABEL: testauxh:
; CHECK-FP16:       // %bb.0: // %entry
; CHECK-FP16-NEXT:    fcvtau x0, h0
; CHECK-FP16-NEXT:    ret
entry:
  %r = call half @llvm.round.f16(half %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f16(half %r)
  ret i64 %i
}

define i32 @testauws(float %a) {
; CHECK-LABEL: testauws:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtau w0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @roundf(float %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f32(float %r)
  ret i32 %i
}

define i64 @testauxs(float %a) {
; CHECK-LABEL: testauxs:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtau x0, s0
; CHECK-NEXT:    ret
entry:
  %r = call float @roundf(float %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f32(float %r)
  ret i64 %i
}

define i32 @testauwd(double %a) {
; CHECK-LABEL: testauwd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtau w0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @round(double %a) nounwind readnone
  %i = call i32 @llvm.fptoui.sat.i32.f64(double %r)
  ret i32 %i
}

define i64 @testauxd(double %a) {
; CHECK-LABEL: testauxd:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcvtau x0, d0
; CHECK-NEXT:    ret
entry:
  %r = call double @round(double %a) nounwind readnone
  %i = call i64 @llvm.fptoui.sat.i64.f64(double %r)
  ret i64 %i
}

declare i32 @llvm.fptoui.sat.i32.f16 (half)
declare i64 @llvm.fptoui.sat.i64.f16 (half)
declare i32 @llvm.fptoui.sat.i32.f32 (float)
declare i64 @llvm.fptoui.sat.i64.f32 (float)
declare i32 @llvm.fptoui.sat.i32.f64 (double)
declare i64 @llvm.fptoui.sat.i64.f64 (double)

declare half @llvm.floor.f16(half) nounwind readnone
declare half @llvm.ceil.f16(half) nounwind readnone
declare half @llvm.trunc.f16(half) nounwind readnone
declare half @llvm.round.f16(half) nounwind readnone
declare float @floorf(float) nounwind readnone
declare float @ceilf(float) nounwind readnone
declare float @truncf(float) nounwind readnone
declare float @roundf(float) nounwind readnone
declare double @floor(double) nounwind readnone
declare double @ceil(double) nounwind readnone
declare double @trunc(double) nounwind readnone
declare double @round(double) nounwind readnone
