/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.preferences;

import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.LisaacPlugin;

public class LisaacColoringPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Group colorGroup;
    private String[][] comboValues;

    public LisaacColoringPage() {
        super(1);
        this.setPreferenceStore(LisaacPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        this.colorGroup = new Group(this.getFieldEditorParent(), 16);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        this.colorGroup.setLayoutData((Object)gd);
        this.colorGroup.setLayout((Layout)new GridLayout(2, false));
        this.colorGroup.setText(LisaacMessages.getString("LisaacColoringPage.0"));
        String bold = LisaacMessages.getString("LisaacColoringPage.20");
        String italics = LisaacMessages.getString("LisaacColoringPage.21");
        String normal = LisaacMessages.getString("LisaacColoringPage.22");
        String underline = LisaacMessages.getString("LisaacColoringPage.23");
        String[][] values = new String[][]{{normal, "normal"}, {bold, "bold"}, {italics, "italic"}, {underline, "underline"}};
        this.comboValues = values;
        this.addField((FieldEditor)new ColorFieldEditor("comment_color", LisaacMessages.getString("LisaacColoringPage.2"), (Composite)this.colorGroup));
        this.createColorField("prototype_color", "prototype_style", LisaacMessages.getString("LisaacColoringPage.3"));
        this.createColorField("prototype_style_color", "prototype_style_style", LisaacMessages.getString("LisaacColoringPage.4"));
        this.createColorField("keyword_color", "keyword_style", LisaacMessages.getString("LisaacColoringPage.5"));
        this.createColorField("slot_color", "slot_style", LisaacMessages.getString("LisaacColoringPage.11"));
        this.createColorField("local_slot_color", "local_slot_style", LisaacMessages.getString("LisaacColoringPage.12"));
        this.createColorField("character_color", "character_style", LisaacMessages.getString("LisaacColoringPage.6"));
        this.createColorField("string_color", "string_style", LisaacMessages.getString("LisaacColoringPage.7"));
        this.createColorField("number_color", "number_style", LisaacMessages.getString("LisaacColoringPage.8"));
        this.createColorField("operator_color", "operator_style", LisaacMessages.getString("LisaacColoringPage.9"));
        this.addField((FieldEditor)new ColorFieldEditor("external_color", LisaacMessages.getString("LisaacColoringPage.10"), (Composite)this.colorGroup));
    }

    private void createColorField(String prefColor, String prefStyle, String tokenName) {
        Composite c = new Composite((Composite)this.colorGroup, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        c.setLayoutData((Object)gd);
        Label label = new Label(c, 0);
        gd = new GridData(80, 15);
        label.setLayoutData((Object)gd);
        label.setText(tokenName);
        Composite c2 = new Composite(c, 0);
        this.addField((FieldEditor)new ColorFieldEditor(prefColor, "", c2));
        c2 = new Composite(c, 0);
        this.addField((FieldEditor)new ComboFieldEditor(prefStyle, "", this.comboValues, c2));
    }

    public void init(IWorkbench workbench) {
    }
}

