/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.outline;

import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.lisaac.ldt.model.Position;
import org.lisaac.ldt.model.items.Slot;
import org.lisaac.ldt.outline.OutlineImages;
import org.lisaac.ldt.outline.OutlineItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineSlot
extends OutlineItem {
    protected Slot slot;

    public OutlineSlot(Slot slot) {
        this.slot = slot;
        Position position = slot.getPosition();
        this.fstartOffset = position.getStartOffset();
        this.fLength = position.length();
    }

    @Override
    public String getText() {
        String result = null;
        if (this.slot != null) {
            result = this.slot.getSignature(false);
        }
        return result;
    }

    @Override
    public StyledString getStyledText() {
        if (this.slot != null) {
            return this.slot.getStyledSignature(false, false);
        }
        return null;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public Image getImage() {
        if (this.slot != null) {
            if (this.slot.getStyle() == '+') {
                if (this.slot.getSectionId() != null && this.slot.getSectionId().isPrivateStyle()) {
                    return OutlineImages.PRIVATE_NONSHARED;
                }
                return OutlineImages.PUBLIC_NONSHARED;
            }
            if (this.slot.getSectionId() != null && this.slot.getSectionId().isPrivateStyle()) {
                return OutlineImages.PRIVATE_SHARED;
            }
            return OutlineImages.PUBLIC_SHARED;
        }
        return null;
    }

    @Override
    public List<OutlineItem> getChildren() {
        return null;
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof OutlineSlot) {
            OutlineSlot slot = (OutlineSlot)obj;
            return this.getText().compareTo(slot.getText());
        }
        return 0;
    }
}

