/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_SHELL32_DLL_LOOKUP_H_
#define LIEF_PE_SHELL32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> shell32_dll_lookup {
    { 0x00ff, "AppCompat_RunDLLW"                       },
    { 0x0107, "AssocCreateForClasses"                   },
    { 0x010b, "AssocGetDetailsOfPropKey"                },
    { 0x02bd, "CDefFolderMenu_Create2"                  },
    { 0x0053, "CIDLData_CreateFromIDArray"              },
    { 0x010c, "CheckEscapesW"                           },
    { 0x010d, "CommandLineToArgvW"                      },
    { 0x0110, "Control_RunDLL"                          },
    { 0x0111, "Control_RunDLLA"                         },
    { 0x0112, "Control_RunDLLAsUserW"                   },
    { 0x0113, "Control_RunDLLW"                         },
    { 0x0081, "DAD_AutoScroll"                          },
    { 0x0083, "DAD_DragEnterEx"                         },
    { 0x0016, "DAD_DragEnterEx2"                        },
    { 0x0084, "DAD_DragLeave"                           },
    { 0x0086, "DAD_DragMove"                            },
    { 0x0088, "DAD_SetDragImage"                        },
    { 0x0089, "DAD_ShowDragImage"                       },
    { 0x0114, "DllCanUnloadNow"                         },
    { 0x0115, "DllGetActivationFactory"                 },
    { 0x0116, "DllGetClassObject"                       },
    { 0x0117, "DllGetVersion"                           },
    { 0x0118, "DllInstall"                              },
    { 0x0119, "DllRegisterServer"                       },
    { 0x011a, "DllUnregisterServer"                     },
    { 0x011b, "DoEnvironmentSubstA"                     },
    { 0x011c, "DoEnvironmentSubstW"                     },
    { 0x011d, "DragAcceptFiles"                         },
    { 0x011e, "DragFinish"                              },
    { 0x011f, "DragQueryFile"                           },
    { 0x0120, "DragQueryFileA"                          },
    { 0x0121, "DragQueryFileAorW"                       },
    { 0x0122, "DragQueryFileW"                          },
    { 0x0123, "DragQueryPoint"                          },
    { 0x0040, "DriveType"                               },
    { 0x0124, "DuplicateIcon"                           },
    { 0x0125, "ExtractAssociatedIconA"                  },
    { 0x0126, "ExtractAssociatedIconExA"                },
    { 0x0127, "ExtractAssociatedIconExW"                },
    { 0x0128, "ExtractAssociatedIconW"                  },
    { 0x0129, "ExtractIconA"                            },
    { 0x012a, "ExtractIconEx"                           },
    { 0x012b, "ExtractIconExA"                          },
    { 0x012c, "ExtractIconExW"                          },
    { 0x012d, "ExtractIconW"                            },
    { 0x012e, "FindExecutableA"                         },
    { 0x012f, "FindExecutableW"                         },
    { 0x0130, "FreeIconList"                            },
    { 0x0131, "GetCurrentProcessExplicitAppUserModelID" },
    { 0x003f, "GetFileNameFromBrowse"                   },
    { 0x009a, "ILAppendID"                              },
    { 0x0012, "ILClone"                                 },
    { 0x0013, "ILCloneFirst"                            },
    { 0x0019, "ILCombine"                               },
    { 0x009d, "ILCreateFromPath"                        },
    { 0x00bd, "ILCreateFromPathA"                       },
    { 0x00be, "ILCreateFromPathW"                       },
    { 0x0018, "ILFindChild"                             },
    { 0x0010, "ILFindLastID"                            },
    { 0x009b, "ILFree"                                  },
    { 0x0099, "ILGetNext"                               },
    { 0x0098, "ILGetSize"                               },
    { 0x0015, "ILIsEqual"                               },
    { 0x0017, "ILIsParent"                              },
    { 0x034e, "ILLoadFromStreamEx"                      },
    { 0x0011, "ILRemoveLastID"                          },
    { 0x001b, "ILSaveToStream"                          },
    { 0x0132, "InitNetworkAddressControl"               },
    { 0x0133, "InternalExtractIconListA"                },
    { 0x0134, "InternalExtractIconListW"                },
    { 0x0077, "IsLFNDrive"                              },
    { 0x0029, "IsLFNDriveA"                             },
    { 0x002a, "IsLFNDriveW"                             },
    { 0x0042, "IsNetDrive"                              },
    { 0x02a8, "IsUserAnAdmin"                           },
    { 0x0135, "LaunchMSHelp_RunDLLW"                    },
    { 0x0051, "OpenAs_RunDLL"                           },
    { 0x007d, "OpenAs_RunDLLA"                          },
    { 0x0085, "OpenAs_RunDLLW"                          },
    { 0x0055, "OpenRegStream"                           },
    { 0x0136, "Options_RunDLL"                          },
    { 0x0137, "Options_RunDLLA"                         },
    { 0x0138, "Options_RunDLLW"                         },
    { 0x00ab, "PathCleanupSpec"                         },
    { 0x0139, "PathCleanupSpecWorker"                   },
    { 0x005c, "PathGetShortPath"                        },
    { 0x002b, "PathIsExe"                               },
    { 0x013a, "PathIsExeWorker"                         },
    { 0x00f0, "PathIsSlowA"                             },
    { 0x00ef, "PathIsSlowW"                             },
    { 0x002f, "PathMakeUniqueName"                      },
    { 0x0031, "PathQualify"                             },
    { 0x0033, "PathResolve"                             },
    { 0x004b, "PathYetAnotherMakeUniqueName"            },
    { 0x003e, "PickIconDlg"                             },
    { 0x000d, "PifMgr_CloseProperties"                  },
    { 0x000a, "PifMgr_GetProperties"                    },
    { 0x0009, "PifMgr_OpenProperties"                   },
    { 0x000b, "PifMgr_SetProperties"                    },
    { 0x0087, "PrepareDiscForBurnRunDllW"               },
    { 0x008a, "PrintersGetCommand_RunDLL"               },
    { 0x008b, "PrintersGetCommand_RunDLLA"              },
    { 0x0096, "PrintersGetCommand_RunDLLW"              },
    { 0x028e, "ReadCabinetState"                        },
    { 0x020c, "RealDriveType"                           },
    { 0x00c7, "RealShellExecuteA"                       },
    { 0x00cf, "RealShellExecuteExA"                     },
    { 0x00d0, "RealShellExecuteExW"                     },
    { 0x00e2, "RealShellExecuteW"                       },
    { 0x013b, "RegenerateUserEnvironment"               },
    { 0x003b, "RestartDialog"                           },
    { 0x02da, "RestartDialogEx"                         },
    { 0x013c, "RunAsNewUser_RunDLLW"                    },
    { 0x013d, "SHAddDefaultPropertiesByExt"             },
    { 0x00a7, "SHAddFromPropSheetExtArray"              },
    { 0x013e, "SHAddToRecentDocs"                       },
    { 0x00c4, "SHAlloc"                                 },
    { 0x013f, "SHAppBarMessage"                         },
    { 0x0140, "SHAssocEnumHandlers"                     },
    { 0x0141, "SHAssocEnumHandlersForProtocolByApplication" },
    { 0x0142, "SHBindToFolderIDListParent"              },
    { 0x0143, "SHBindToFolderIDListParentEx"            },
    { 0x0144, "SHBindToObject"                          },
    { 0x0145, "SHBindToParent"                          },
    { 0x0146, "SHBrowseForFolder"                       },
    { 0x0147, "SHBrowseForFolderA"                      },
    { 0x0148, "SHBrowseForFolderW"                      },
    { 0x0093, "SHCLSIDFromString"                       },
    { 0x0284, "SHChangeNotification_Lock"               },
    { 0x0285, "SHChangeNotification_Unlock"             },
    { 0x0149, "SHChangeNotify"                          },
    { 0x0004, "SHChangeNotifyDeregister"                },
    { 0x0002, "SHChangeNotifyRegister"                  },
    { 0x014a, "SHChangeNotifyRegisterThread"            },
    { 0x014b, "SHChangeNotifySuspendResume"             },
    { 0x0059, "SHCloneSpecialIDList"                    },
    { 0x0066, "SHCoCreateInstance"                      },
    { 0x014c, "SHCoCreateInstanceWorker"                },
    { 0x014d, "SHCreateAssociationRegistration"         },
    { 0x014e, "SHCreateDataObject"                      },
    { 0x014f, "SHCreateDefaultContextMenu"              },
    { 0x0150, "SHCreateDefaultExtractIcon"              },
    { 0x0151, "SHCreateDefaultPropertiesOp"             },
    { 0x00a5, "SHCreateDirectory"                       },
    { 0x0152, "SHCreateDirectoryExA"                    },
    { 0x0153, "SHCreateDirectoryExW"                    },
    { 0x0154, "SHCreateDirectoryExWWorker"              },
    { 0x02e7, "SHCreateFileExtractIconW"                },
    { 0x0155, "SHCreateItemFromIDList"                  },
    { 0x0156, "SHCreateItemFromParsingName"             },
    { 0x0157, "SHCreateItemFromRelativeName"            },
    { 0x0158, "SHCreateItemInKnownFolder"               },
    { 0x0159, "SHCreateItemWithParent"                  },
    { 0x015a, "SHCreateLocalServerRunDll"               },
    { 0x015b, "SHCreateProcessAsUserW"                  },
    { 0x00a8, "SHCreatePropSheetExtArray"               },
    { 0x015c, "SHCreateQueryCancelAutoPlayMoniker"      },
    { 0x0100, "SHCreateShellFolderView"                 },
    { 0x00ae, "SHCreateShellFolderViewEx"               },
    { 0x015d, "SHCreateShellItem"                       },
    { 0x015e, "SHCreateShellItemArray"                  },
    { 0x015f, "SHCreateShellItemArrayFromDataObject"    },
    { 0x0160, "SHCreateShellItemArrayFromIDLists"       },
    { 0x0161, "SHCreateShellItemArrayFromShellItem"     },
    { 0x004a, "SHCreateStdEnumFmtEtc"                   },
    { 0x0003, "SHDefExtractIconA"                       },
    { 0x0006, "SHDefExtractIconW"                       },
    { 0x00a9, "SHDestroyPropSheetExtArray"              },
    { 0x0058, "SHDoDragDrop"                            },
    { 0x0162, "SHEmptyRecycleBinA"                      },
    { 0x0163, "SHEmptyRecycleBinW"                      },
    { 0x0164, "SHEnableServiceObject"                   },
    { 0x0165, "SHEnumerateUnreadMailAccountsW"          },
    { 0x0166, "SHEvaluateSystemCommandTemplate"         },
    { 0x0167, "SHExtractIconsW"                         },
    { 0x0168, "SHFileOperation"                         },
    { 0x0169, "SHFileOperationA"                        },
    { 0x016a, "SHFileOperationW"                        },
    { 0x005a, "SHFindFiles"                             },
    { 0x0095, "SHFind_InitMenuPopup"                    },
    { 0x020e, "SHFlushSFCache"                          },
    { 0x016b, "SHFormatDrive"                           },
    { 0x00c3, "SHFree"                                  },
    { 0x016c, "SHFreeNameMappings"                      },
    { 0x02ee, "SHGetAttributesFromDataObject"           },
    { 0x016d, "SHGetDataFromIDListA"                    },
    { 0x016e, "SHGetDataFromIDListW"                    },
    { 0x016f, "SHGetDesktopFolder"                      },
    { 0x0170, "SHGetDesktopFolderWorker"                },
    { 0x0171, "SHGetDiskFreeSpaceA"                     },
    { 0x0172, "SHGetDiskFreeSpaceExA"                   },
    { 0x0173, "SHGetDiskFreeSpaceExW"                   },
    { 0x0174, "SHGetDriveMedia"                         },
    { 0x0175, "SHGetFileInfo"                           },
    { 0x0176, "SHGetFileInfoA"                          },
    { 0x0177, "SHGetFileInfoW"                          },
    { 0x0178, "SHGetFileInfoWWorker"                    },
    { 0x0179, "SHGetFolderLocation"                     },
    { 0x017a, "SHGetFolderLocationWorker"               },
    { 0x017b, "SHGetFolderPathA"                        },
    { 0x017c, "SHGetFolderPathAWorker"                  },
    { 0x017d, "SHGetFolderPathAndSubDirA"               },
    { 0x017e, "SHGetFolderPathAndSubDirW"               },
    { 0x017f, "SHGetFolderPathAndSubDirWWorker"         },
    { 0x0180, "SHGetFolderPathEx"                       },
    { 0x0181, "SHGetFolderPathW"                        },
    { 0x0182, "SHGetFolderPathWWorker"                  },
    { 0x0183, "SHGetIDListFromObject"                   },
    { 0x0184, "SHGetIconOverlayIndexA"                  },
    { 0x0185, "SHGetIconOverlayIndexW"                  },
    { 0x02d7, "SHGetImageList"                          },
    { 0x0186, "SHGetInstanceExplorer"                   },
    { 0x0187, "SHGetInstanceExplorerWorker"             },
    { 0x0188, "SHGetItemFromDataObject"                 },
    { 0x0189, "SHGetItemFromObject"                     },
    { 0x018a, "SHGetKnownFolderIDList"                  },
    { 0x018b, "SHGetKnownFolderItem"                    },
    { 0x018c, "SHGetKnownFolderPath"                    },
    { 0x018d, "SHGetKnownFolderPathWorker"              },
    { 0x018e, "SHGetLocalizedName"                      },
    { 0x018f, "SHGetMalloc"                             },
    { 0x0190, "SHGetNameFromIDList"                     },
    { 0x0191, "SHGetNewLinkInfo"                        },
    { 0x00b3, "SHGetNewLinkInfoA"                       },
    { 0x00b4, "SHGetNewLinkInfoW"                       },
    { 0x0192, "SHGetPathFromIDList"                     },
    { 0x0193, "SHGetPathFromIDListA"                    },
    { 0x0194, "SHGetPathFromIDListEx"                   },
    { 0x0195, "SHGetPathFromIDListW"                    },
    { 0x0196, "SHGetPropertyStoreForWindow"             },
    { 0x0197, "SHGetPropertyStoreFromIDList"            },
    { 0x0198, "SHGetPropertyStoreFromParsingName"       },
    { 0x0062, "SHGetRealIDL"                            },
    { 0x02c5, "SHGetSetFolderCustomSettings"            },
    { 0x0044, "SHGetSetSettings"                        },
    { 0x0199, "SHGetSettings"                           },
    { 0x019a, "SHGetSpecialFolderLocation"              },
    { 0x019b, "SHGetSpecialFolderPathA"                 },
    { 0x019c, "SHGetSpecialFolderPathAWorker"           },
    { 0x019d, "SHGetSpecialFolderPathW"                 },
    { 0x019e, "SHGetSpecialFolderPathWWorker"           },
    { 0x019f, "SHGetStockIconInfo"                      },
    { 0x01a0, "SHGetTemporaryPropertyForItem"           },
    { 0x01a1, "SHGetUnreadMailCountW"                   },
    { 0x00c1, "SHHandleUpdateImage"                     },
    { 0x00e4, "SHHelpShortcuts_RunDLL"                  },
    { 0x00e5, "SHHelpShortcuts_RunDLLA"                 },
    { 0x00ee, "SHHelpShortcuts_RunDLLW"                 },
    { 0x001c, "SHILCreateFromPath"                      },
    { 0x01a2, "SHInvokePrinterCommandA"                 },
    { 0x01a3, "SHInvokePrinterCommandW"                 },
    { 0x01a4, "SHIsFileAvailableOffline"                },
    { 0x02eb, "SHLimitInputEdit"                        },
    { 0x01a5, "SHLoadInProc"                            },
    { 0x01a6, "SHLoadNonloadedIconOverlayIdentifiers"   },
    { 0x004d, "SHMapPIDLToSystemImageListIndex"         },
    { 0x02cc, "SHMultiFileProperties"                   },
    { 0x00b2, "SHObjectProperties"                      },
    { 0x01a7, "SHOpenFolderAndSelectItems"              },
    { 0x0050, "SHOpenPropSheetW"                        },
    { 0x01a8, "SHOpenWithDialog"                        },
    { 0x01a9, "SHParseDisplayName"                      },
    { 0x01aa, "SHPathPrepareForWriteA"                  },
    { 0x01ab, "SHPathPrepareForWriteW"                  },
    { 0x02ad, "SHPropStgCreate"                         },
    { 0x02b0, "SHPropStgReadMultiple"                   },
    { 0x02b1, "SHPropStgWriteMultiple"                  },
    { 0x01ac, "SHQueryRecycleBinA"                      },
    { 0x01ad, "SHQueryRecycleBinW"                      },
    { 0x01ae, "SHQueryUserNotificationState"            },
    { 0x01af, "SHRemoveLocalizedName"                   },
    { 0x00aa, "SHReplaceFromPropSheetExtArray"          },
    { 0x01b0, "SHResolveLibrary"                        },
    { 0x0064, "SHRestricted"                            },
    { 0x01b1, "SHSetDefaultProperties"                  },
    { 0x00e7, "SHSetFolderPathA"                        },
    { 0x00e8, "SHSetFolderPathW"                        },
    { 0x00b0, "SHSetInstanceExplorer"                   },
    { 0x01b2, "SHSetKnownFolderPath"                    },
    { 0x01b3, "SHSetKnownFolderPathWorker"              },
    { 0x01b4, "SHSetLocalizedName"                      },
    { 0x01b5, "SHSetTemporaryPropertyForItem"           },
    { 0x01b6, "SHSetUnreadMailCountW"                   },
    { 0x0049, "SHShellFolderView_Message"               },
    { 0x01b7, "SHShowManageLibraryUI"                   },
    { 0x00a2, "SHSimpleIDListFromPath"                  },
    { 0x000e, "SHStartNetConnectionDialogW"             },
    { 0x00f5, "SHTestTokenMembership"                   },
    { 0x00bf, "SHUpdateImageA"                          },
    { 0x00c0, "SHUpdateImageW"                          },
    { 0x01b8, "SHUpdateRecycleBinIcon"                  },
    { 0x00ad, "SHValidateUNC"                           },
    { 0x01b9, "SetCurrentProcessExplicitAppUserModelID" },
    { 0x01ba, "SheChangeDirA"                           },
    { 0x01bb, "SheChangeDirExW"                         },
    { 0x01bc, "SheGetDirA"                              },
    { 0x01bd, "SheSetCurDrive"                          },
    { 0x01be, "ShellAboutA"                             },
    { 0x01bf, "ShellAboutW"                             },
    { 0x01c0, "ShellExec_RunDLL"                        },
    { 0x01c1, "ShellExec_RunDLLA"                       },
    { 0x01c2, "ShellExec_RunDLLW"                       },
    { 0x01c3, "ShellExecuteA"                           },
    { 0x01c4, "ShellExecuteEx"                          },
    { 0x01c5, "ShellExecuteExA"                         },
    { 0x01c6, "ShellExecuteExW"                         },
    { 0x01c7, "ShellExecuteW"                           },
    { 0x01c8, "ShellHookProc"                           },
    { 0x00b7, "ShellMessageBoxA"                        },
    { 0x00b6, "ShellMessageBoxW"                        },
    { 0x0048, "Shell_GetCachedImageIndex"               },
    { 0x01c9, "Shell_GetCachedImageIndexA"              },
    { 0x01ca, "Shell_GetCachedImageIndexW"              },
    { 0x0047, "Shell_GetImageLists"                     },
    { 0x0043, "Shell_MergeMenus"                        },
    { 0x01cb, "Shell_NotifyIcon"                        },
    { 0x01cc, "Shell_NotifyIconA"                       },
    { 0x01cd, "Shell_NotifyIconGetRect"                 },
    { 0x01ce, "Shell_NotifyIconW"                       },
    { 0x0067, "SignalFileOpen"                          },
    { 0x02aa, "StgMakeUniqueName"                       },
    { 0x01cf, "StrChrA"                                 },
    { 0x01d0, "StrChrIA"                                },
    { 0x01d1, "StrChrIW"                                },
    { 0x01d2, "StrChrW"                                 },
    { 0x01d3, "StrCmpNA"                                },
    { 0x01d4, "StrCmpNIA"                               },
    { 0x01d5, "StrCmpNIW"                               },
    { 0x01d6, "StrCmpNW"                                },
    { 0x01d7, "StrNCmpA"                                },
    { 0x01d8, "StrNCmpIA"                               },
    { 0x01d9, "StrNCmpIW"                               },
    { 0x01da, "StrNCmpW"                                },
    { 0x01db, "StrRChrA"                                },
    { 0x01dc, "StrRChrIA"                               },
    { 0x01dd, "StrRChrIW"                               },
    { 0x01de, "StrRChrW"                                },
    { 0x01df, "StrRStrA"                                },
    { 0x01e0, "StrRStrIA"                               },
    { 0x01e1, "StrRStrIW"                               },
    { 0x01e2, "StrRStrW"                                },
    { 0x01e3, "StrStrA"                                 },
    { 0x01e4, "StrStrIA"                                },
    { 0x01e5, "StrStrIW"                                },
    { 0x01e6, "StrStrW"                                 },
    { 0x01e7, "WOWShellExecute"                         },
    { 0x01e8, "WaitForExplorerRestartW"                 },
    { 0x00a4, "Win32DeleteFile"                         },
    { 0x028c, "WriteCabinetState"                       },
};


}
}

#endif

