#!/bin/bash

set -e
set -u

testdir=$PWD/src/python/test
cd $AUTOPKGTEST_TMP

for py3ver in $(py3versions -vs)
do
    echo "Running tests with Python ${py3ver}."
    for t in $(find $testdir -type f -name 'test_*.py')
    do
        echo "Running test ${t}."
        /usr/bin/python${py3ver} -B $t
    done
done
