/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableSetMultimapAsMapImplementsMapTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testClear() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testClear();
}

public void testContainsKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testContainsKey();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testContainsValue();
}

public void testEntrySet() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySet();
}

public void testEntrySetAddAndAddAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetAddAndAddAll();
}

public void testEntrySetClear() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetClear();
}

public void testEntrySetContainsEntryIncompatibleKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetContainsEntryIncompatibleKey();
}

public void testEntrySetContainsEntryNullKeyMissing() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetContainsEntryNullKeyMissing();
}

public void testEntrySetContainsEntryNullKeyPresent() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetContainsEntryNullKeyPresent();
}

public void testEntrySetForEmptyMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetForEmptyMap();
}

public void testEntrySetIteratorRemove() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetIteratorRemove();
}

public void testEntrySetRemove() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemove();
}

public void testEntrySetRemoveAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveAll();
}

public void testEntrySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveAllNullFromEmpty();
}

public void testEntrySetRemoveDifferentValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveDifferentValue();
}

public void testEntrySetRemoveMissingKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveMissingKey();
}

public void testEntrySetRemoveNullKeyMissing() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveNullKeyMissing();
}

public void testEntrySetRemoveNullKeyPresent() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRemoveNullKeyPresent();
}

public void testEntrySetRetainAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRetainAll();
}

public void testEntrySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetRetainAllNullFromEmpty();
}

public void testEntrySetSetValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetSetValue();
}

public void testEntrySetSetValueSameValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEntrySetSetValueSameValue();
}

public void testEqualsForEmptyMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEqualsForEmptyMap();
}

public void testEqualsForEqualMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEqualsForEqualMap();
}

public void testEqualsForLargerMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEqualsForLargerMap();
}

public void testEqualsForSmallerMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testEqualsForSmallerMap();
}

public void testGet() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testGet();
}

public void testGetForEmptyMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testGetForEmptyMap();
}

public void testGetNull() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testGetNull();
}

public void testHashCode() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testHashCode();
}

public void testHashCodeForEmptyMap() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testHashCodeForEmptyMap();
}

public void testKeySetClear() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testKeySetClear();
}

public void testKeySetRemove() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testKeySetRemove();
}

public void testKeySetRemoveAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testKeySetRemoveAll();
}

public void testKeySetRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testKeySetRemoveAllNullFromEmpty();
}

public void testKeySetRetainAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testKeySetRetainAll();
}

public void testKeySetRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testKeySetRetainAllNullFromEmpty();
}

public void testPutAllExistingKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutAllExistingKey();
}

public void testPutAllNewKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutAllNewKey();
}

public void testPutExistingKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutExistingKey();
}

public void testPutNewKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutNewKey();
}

public void testPutNullKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutNullKey();
}

public void testPutNullValue() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutNullValue();
}

public void testPutNullValueForExistingKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testPutNullValueForExistingKey();
}

public void testRemove() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testRemove();
}

public void testRemoveMissingKey() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testRemoveMissingKey();
}

public void testSize() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testSize();
}

public void testValues() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValues();
}

public void testValuesClear() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesClear();
}

public void testValuesIteratorRemove() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesIteratorRemove();
}

public void testValuesRemove() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesRemove();
}

public void testValuesRemoveAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesRemoveAll();
}

public void testValuesRemoveAllNullFromEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesRemoveAllNullFromEmpty();
}

public void testValuesRemoveMissing() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesRemoveMissing();
}

public void testValuesRetainAll() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesRetainAll();
}

public void testValuesRetainAllNullFromEmpty() throws Exception {
  com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest testCase = new com.google.common.collect.ImmutableSetMultimapAsMapImplementsMapTest();
  testCase.testValuesRetainAllNullFromEmpty();
}
}
