package github

import "time"

// Repository is a github repository.
type Repository struct {
	ID               int           `json:"id"`
	NodeID           string        `json:"node_id"`
	Name             string        `json:"name"`
	FullName         string        `json:"full_name"`
	Private          bool          `json:"private"`
	Owner            *User         `json:"owner"`
	HTMLURL          string        `json:"html_url"`
	Description      string        `json:"description"`
	Fork             bool          `json:"fork"`
	URL              string        `json:"url"`
	ForksURL         string        `json:"forks_url"`
	KeysURL          string        `json:"keys_url"`
	CollaboratorsURL string        `json:"collaborators_url"`
	TeamsURL         string        `json:"teams_url"`
	HooksURL         string        `json:"hooks_url"`
	IssueEventsURL   string        `json:"issue_events_url"`
	EventsURL        string        `json:"events_url"`
	AssigneesURL     string        `json:"assignees_url"`
	BranchesURL      string        `json:"branches_url"`
	TagsURL          string        `json:"tags_url"`
	BlobsURL         string        `json:"blobs_url"`
	GitTagsURL       string        `json:"git_tags_url"`
	GitRefsURL       string        `json:"git_refs_url"`
	TreesURL         string        `json:"trees_url"`
	StatusesURL      string        `json:"statuses_url"`
	LanguagesURL     string        `json:"languages_url"`
	StargazersURL    string        `json:"stargazers_url"`
	ContributorsURL  string        `json:"contributors_url"`
	SubscribersURL   string        `json:"subscribers_url"`
	SubscriptionURL  string        `json:"subscription_url"`
	CommitsURL       string        `json:"commits_url"`
	GitCommitsURL    string        `json:"git_commits_url"`
	CommentsURL      string        `json:"comments_url"`
	IssueCommentURL  string        `json:"issue_comment_url"`
	ContentsURL      string        `json:"contents_url"`
	CompareURL       string        `json:"compare_url"`
	MergesURL        string        `json:"merges_url"`
	ArchiveURL       string        `json:"archive_url"`
	DownloadsURL     string        `json:"downloads_url"`
	IssuesURL        string        `json:"issues_url"`
	PullsURL         string        `json:"pulls_url"`
	MilestonesURL    string        `json:"milestones_url"`
	NotificationsURL string        `json:"notifications_url"`
	LabelsURL        string        `json:"labels_url"`
	ReleasesURL      string        `json:"releases_url"`
	DeploymentsURL   string        `json:"deployments_url"`
	CreatedAt        time.Time     `json:"created_at"`
	UpdatedAt        time.Time     `json:"updated_at"`
	PushedAt         time.Time     `json:"pushed_at"`
	GitURL           string        `json:"git_url"`
	SSHURL           string        `json:"ssh_url"`
	CloneURL         string        `json:"clone_url"`
	SvnURL           string        `json:"svn_url"`
	Homepage         string        `json:"homepage"`
	Size             int           `json:"size"`
	StargazersCount  int           `json:"stargazers_count"`
	WatchersCount    int           `json:"watchers_count"`
	Language         string        `json:"language"`
	HasIssues        bool          `json:"has_issues"`
	HasProjects      bool          `json:"has_projects"`
	HasDownloads     bool          `json:"has_downloads"`
	HasWiki          bool          `json:"has_wiki"`
	HasPages         bool          `json:"has_pages"`
	ForksCount       int           `json:"forks_count"`
	MirrorURL        string        `json:"mirror_url"`
	Archived         bool          `json:"archived"`
	Disabled         bool          `json:"disabled"`
	OpenIssuesCount  int           `json:"open_issues_count"`
	License          *License      `json:"license"`
	AllowForking     bool          `json:"allow_forking"`
	IsTemplate       bool          `json:"is_template"`
	Topics           []string      `json:"topics"`
	Visibility       string        `json:"visibility"`
	Forks            int           `json:"forks"`
	OpenIssues       int           `json:"open_issues"`
	Watchers         int           `json:"watchers"`
	DefaultBranch    string        `json:"default_branch"`
	Organization     *Organization `json:"organization"`
	NetworkCount     int           `json:"network_count"`
	SubscribersCount int           `json:"subscribers_count"`
}

// Issue is a Github issue.
type Issue struct {
	URL               string            `json:"url"`
	RepositoryURL     string            `json:"repository_url"`
	LabelsURL         string            `json:"labels_url"`
	CommentsURL       string            `json:"comments_url"`
	EventsURL         string            `json:"events_url"`
	HTMLURL           string            `json:"html_url"`
	ID                int               `json:"id"`
	NodeID            string            `json:"node_id"`
	Number            int               `json:"number"`
	Title             string            `json:"title"`
	User              *User             `json:"user"`
	Labels            []*Label          `json:"labels"`
	State             string            `json:"state"`
	Locked            bool              `json:"locked"`
	Assignee          *User             `json:"assignee"`
	Assignees         []*User           `json:"assignees"`
	Comments          int               `json:"comments"`
	CreatedAt         time.Time         `json:"created_at"`
	UpdatedAt         time.Time         `json:"updated_at"`
	ClosedAt          time.Time         `json:"closed_at"`
	AuthorAssociation string            `json:"author_association"`
	ActiveLockReason  string            `json:"active_lock_reason"`
	PullRequestLinks  *PullRequestLinks `json:"pull_request"`
	Body              string            `json:"body"`
	ClosedBy          *User             `json:"closed_by"`
	Reactions         *Reactions        `json:"reactions"`
	TimelineURL       string            `json:"timeline_url"`
}

// Label is a Github label on an issue or PR.
type Label struct {
	ID          int    `json:"id"`
	NodeID      string `json:"node_id"`
	URL         string `json:"url"`
	Name        string `json:"name"`
	Color       string `json:"color"`
	Default     bool   `json:"default"`
	Description string `json:"description"`
}

// Reactions summarizes Github reactions.
type Reactions struct {
	URL        string `json:"url"`
	TotalCount int    `json:"total_count"`
	PlusOne    int    `json:"+1"`
	MinusOne   int    `json:"-1"`
	Laugh      int    `json:"laugh"`
	Hooray     int    `json:"hooray"`
	Confused   int    `json:"confused"`
	Heart      int    `json:"heart"`
	Rocket     int    `json:"rocket"`
	Eyes       int    `json:"eyes"`
}

// PullRequestLinks are attached to an Issue object when it represents a PR.
type PullRequestLinks struct {
	URL      string `json:"url"`
	HTMLURL  string `json:"html_url"`
	DiffURL  string `json:"diff_url"`
	PatchURL string `json:"patch_url"`
}

// User is a Github user.
type User struct {
	Login             string `json:"login"`
	ID                int    `json:"id"`
	NodeID            string `json:"node_id"`
	AvatarURL         string `json:"avatar_url"`
	GravatarID        string `json:"gravatar_id"`
	URL               string `json:"url"`
	HTMLURL           string `json:"html_url"`
	FollowersURL      string `json:"followers_url"`
	FollowingURL      string `json:"following_url"`
	GistsURL          string `json:"gists_url"`
	StarredURL        string `json:"starred_url"`
	SubscriptionsURL  string `json:"subscriptions_url"`
	OrganizationsURL  string `json:"organizations_url"`
	ReposURL          string `json:"repos_url"`
	EventsURL         string `json:"events_url"`
	ReceivedEventsURL string `json:"received_events_url"`
	Type              string `json:"type"`
	SiteAdmin         bool   `json:"site_admin"`
}

// Organization is a Github organization.
type Organization struct {
	Login             string `json:"login"`
	ID                int    `json:"id"`
	NodeID            string `json:"node_id"`
	AvatarURL         string `json:"avatar_url"`
	GravatarID        string `json:"gravatar_id"`
	URL               string `json:"url"`
	HTMLURL           string `json:"html_url"`
	FollowersURL      string `json:"followers_url"`
	FollowingURL      string `json:"following_url"`
	GistsURL          string `json:"gists_url"`
	StarredURL        string `json:"starred_url"`
	SubscriptionsURL  string `json:"subscriptions_url"`
	OrganizationsURL  string `json:"organizations_url"`
	ReposURL          string `json:"repos_url"`
	EventsURL         string `json:"events_url"`
	ReceivedEventsURL string `json:"received_events_url"`
	Type              string `json:"type"`
	SiteAdmin         bool   `json:"site_admin"`
}

// License is an open source license.
type License struct {
	Key    string `json:"key"`
	Name   string `json:"name"`
	SPDXID string `json:"spdx_id"`
	URL    string `json:"url"`
	NodeID string `json:"node_id"`
}
