<div>
  <p align="center">
    <a href="http://awesome-ruby.com"><img src="https://raw.githubusercontent.com/markets/awesome-ruby/gh-pages/images/logo_m.png"></a>
  </p>
  <h3 align="center"><a href="http://awesome-ruby.com">Awesome Ruby</a></h3>
  <p align="center">
    <a href="https://github.com/sindresorhus/awesome"><img src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg"></a>
  </p>
  <hr>
</div>

A categorized community-driven collection of awesome Ruby libraries, tools, frameworks and software. The essential Ruby to build modern Apps and Web Apps.

Sharing, suggestions and contributions are always welcome! Please take a look at the [contribution guidelines and quality standard](https://github.com/markets/awesome-ruby/blob/master/CONTRIBUTING.md) first.

Thanks to all [contributors](https://github.com/markets/awesome-ruby/graphs/contributors), you're awesome and this wouldn't be possible without you!

* [Awesome Ruby](#awesome-ruby)
  * [Abstraction](#abstraction)
  * [Admin Interface](#admin-interface)
  * [Analytics](#analytics)
  * [API Builder and Discovery](#api-builder-and-discovery)
  * [Assets](#assets)
  * [Authentication and OAuth](#authentication-and-oauth)
  * [Authorization](#authorization)
  * [Automation](#automation)
  * [Caching](#caching)
  * [Captchas and anti-spam](#captchas-and-anti-spam)
  * [CLI Builder](#cli-builder)
  * [CLI Utilities](#cli-utilities)
  * [Cloud](#cloud)
  * [CMS](#cms)
  * [Code Analysis and Metrics](#code-analysis-and-metrics)
  * [Code Highlighting](#code-highlighting)
  * [Coding Style Guides](#coding-style-guides)
  * [Concurrency and Parallelism](#concurrency-and-parallelism)
  * [Configuration](#configuration)
  * [Core Extensions](#core-extensions)
  * [Country Data](#country-data)
  * [CRM](#crm)
  * [Cryptocurrencies and Blockchains](#cryptocurrencies-and-blockchains)
  * [Dashboards](#dashboards)
  * [Data Processing and ETL](#data-processing-and-etl)
  * [Data Visualization](#data-visualization)
  * [Database Drivers](#database-drivers)
  * [Database Tools](#database-tools)
  * [Date and Time Processing](#date-and-time-processing)
  * [Debugging Tools](#debugging-tools)
  * [Decorators](#decorators)
  * [DevOps Tools](#devops-tools)
  * [Diff](#diff)
  * [Documentation](#documentation)
  * [E-Commerce and Payments](#e-commerce-and-payments)
  * [Ebook](#ebook)
  * [Email](#email)
  * [Encryption](#encryption)
  * [Environment Management](#environment-management)
  * [Error Handling](#error-handling)
  * [Feature Flippers and A/B Testing](#feature-flippers-and-ab-testing)
  * [File Upload](#file-upload)
  * [File System](#file-system)
  * [Form Builder](#form-builder)
  * [Game Development](#game-development)
  * [Geolocation](#geolocation)
  * [Git Tools](#git-tools)
  * [GraphQL](#graphql)
  * [GUI](#gui)
  * [HTML/XML Parsing](#htmlxml-parsing)
  * [HTTP Clients and tools](#http-clients-and-tools)
  * [Image Processing](#image-processing)
  * [Implementations/Compilers](#implementationscompilers)
  * [Internationalization](#internationalization)
  * [IRB](#irb)
  * [Logging](#logging)
  * [Machine Learning](#machine-learning)
  * [Markdown Processors](#markdown-processors)
  * [Mobile Development](#mobile-development)
  * [Money](#money)
  * [Music and Sound](#music-and-sound)
  * [Natural Language Processing](#natural-language-processing)
  * [Navigation](#navigation)
  * [Networking](#networking)
  * [ORM/ODM](#ormodm)
  * [ORM/ODM Extensions](#ormodm-extensions)
  * [Package Management](#package-management)
  * [Pagination](#pagination)
  * [PDF](#pdf)
  * [Performance Monitoring](#performance-monitoring)
  * [Presentation Programs](#presentation-programs)
  * [Process Monitoring](#process-monitoring)
  * [Processes](#processes)
  * [Profiler and Optimization](#profiler-and-optimization)
  * [QR](#qr)
  * [Queues and Messaging](#queues-and-messaging)
  * [Rails Application Generators](#rails-application-generators)
  * [Robotics](#robotics)
  * [RSS](#rss)
  * [Scheduling](#scheduling)
  * [Scientific](#scientific)
  * [Search](#search)
  * [Security](#security)
  * [SEO](#seo)
  * [Social Networking](#social-networking)
  * [Spreadsheets and Documents](#spreadsheets-and-documents)
  * [State Machines](#state-machines)
  * [Static Site Generation](#static-site-generation)
  * [Template Engine](#template-engine)
  * [Testing](#testing)
  * [Third-party APIs](#third-party-apis)
  * [Video](#video)
  * [View helpers](#view-helpers)
  * [Web Crawling](#web-crawling)
  * [Web Frameworks](#web-frameworks)
  * [Web Servers](#web-servers)
  * [WebSocket](#websocket)
* [Services and Apps](#services-and-apps)
* [Resources](#resources)

## Abstraction

* [ActiveInteraction](https://github.com/orgsync/active_interaction) - Manage application specific business logic.
* [Apotomo](https://github.com/apotonick/apotomo) - Based on Cells, Apotomo gives you widgets and encapsulation, bubbling events, AJAX page updates, rock-solid testing and more.
* [Cells](https://github.com/apotonick/cells) - View Components for Rails.
* [Decent Exposure](https://github.com/hashrocket/decent_exposure) - A helper for creating declarative interfaces in controllers.
* [Docile](https://github.com/ms-ati/docile) - A tiny library that lets you map a DSL (domain specific language) to your Ruby objects in a snap.
* [dry-rb](https://github.com/dry-rb) -  dry-rb is a collection of next-generation Ruby libraries, each intended to encapsulate a common task.
* [Interactor](https://github.com/collectiveidea/interactor) - Interactor provides a common interface for performing complex interactions in a single request.
* [Light Service](https://github.com/adomokos/light-service) - Series of Actions with an emphasis on simplicity.
* [Mutations](https://github.com/cypriss/mutations) - Compose your business logic into commands that sanitize and validate input.
* [Responders](https://github.com/plataformatec/responders) -  A set of Rails responders to dry up your application.
* [Surrounded](https://github.com/saturnflyer/surrounded) - Encapsulated related objects in a single system to add behavior during runtime. Extensible implementation of DCI.
* [Trailblazer](https://github.com/apotonick/trailblazer) - Trailblazer is a thin layer on top of Rails. It gently enforces encapsulation, an intuitive code structure and gives you an object-oriented architecture.
* [Waterfall](https://github.com/apneadiving/waterfall) - A slice of functional programming to chain ruby services and blocks, thus providing a new approach to flow control.
* [wisper](https://github.com/krisleech/wisper) - A micro library providing Ruby objects with Publish-Subscribe capabilities.

## Admin Interface

* [ActiveAdmin](http://activeadmin.info) - A Ruby on Rails framework for creating elegant backends for website administration.
* [ActiveScaffold](https://github.com/activescaffold/active_scaffold) - ActiveScaffold provides quick and powerful user interfaces for CRUD (create, read, update, delete) operations for Rails applications. It's excellent for generating admin interfaces, managing Data-Heavy Applications, creating Widgets or for quick prototyping. ActiveScaffold is completly customizable and offers a bunch of additonal features including searching, pagination, layout control and overrides of fields, forms and templates.
* [Administrate](https://github.com/thoughtbot/administrate) - A Rails engine that helps you put together a super-flexible admin dashboard, by Thoughtbot.
* [bhf](http://antpaw.github.io/bhf/) - A simple to use Rails-Engine-Gem that offers an admin interface for trusted user.
* [Faalis](http://faalis.io) - A Rails engine which provides a robust platform to develop web applications. It contains a very simple yet powerful admin/dashboard interface too.
* [RailsAdmin](https://github.com/sferik/rails_admin) - A Rails engine that provides an easy-to-use interface for managing your data.
* [Typus](https://github.com/typus/typus) - Ruby on Rails control panel to allow trusted users edit structured content.

## Analytics

* [Ahoy](https://github.com/ankane/ahoy) - A solid foundation to track visits and events in Ruby, JavaScript, and native apps.
* [Analytical](https://github.com/jkrall/analytical) - Gem for managing multiple analytics services in your rails app.
* [Gabba](https://github.com/hybridgroup/gabba) - Simple way to send server-side notifications to Google Analytics.
* [Impressionist](https://github.com/charlotte-ruby/impressionist) - Rails Plugin that tracks impressions and page views.
* [Legato](https://github.com/tpitale/legato) - Model analytics reports and queries against the official Google Analytics Reporting API.
* [Rack::Tracker](https://github.com/railslove/rack-tracker) - Rack middleware that can be hooked up to multiple services and exposing them in a unified fashion.
* [Staccato](https://github.com/tpitale/staccato) - Track analytics into the official Google Analytics Collection API.

## API Builder and Discovery

* [ActiveModel::Serializers](https://github.com/rails-api/active_model_serializers) - JSON serialization of objects.
* [Blanket](https://github.com/inf0rmer/blanket) - A dead simple API wrapper.
* [Crepe](https://github.com/crepe/crepe) - The thin API stack.
* [Grape](http://www.ruby-grape.org) - An opinionated micro-framework for creating REST-like APIs in Ruby.
* [Her](https://github.com/remiprev/her) - an ORM that maps REST resources to Ruby objects. Designed to build applications that are powered by a RESTful API instead of a database.
* [jbuilder](https://github.com/rails/jbuilder) - Create JSON structures via a Builder-style DSL.
* [jsonapi-rb](http://jsonapi-rb.org) – Efficient and convenient JSON API (de)serialization library.
* [JSONAPI::Resources](https://github.com/cerebris/jsonapi-resources) - JSONAPI::Resources, or "JR", provides a framework for developing a server that complies with the JSON API specification.
* [JSONAPI::Utils](https://github.com/tiagopog/jsonapi-utils) - JSONAPI::Utils is built on top of JSONAPI::Resources taking advantage of its resource-driven style and bringing an easy way to build modern JSON APIs with no or less learning curve.
* [Jsonite](https://github.com/crepe/jsonite) - A tiny, HAL-compliant JSON presenter for your APIs.
* [Pliny](https://github.com/interagent/pliny) - Opinionated template Sinatra app for writing excellent APIs in Ruby.
* [rabl](https://github.com/nesquena/rabl) - General ruby templating with json, bson, xml, plist and msgpack support.
* [Rails::API](https://github.com/rails-api/rails-api) - Rails for API only applications.
* [Roar](https://github.com/apotonick/roar) - Resource-Oriented Architectures in Ruby.
* [Spyke](https://github.com/balvig/spyke) - Interact with REST services in an ActiveRecord-like manner.
* [Version Cake](https://github.com/bwillis/versioncake) - An unobtrusive way to version APIs in your Rails app.
* [versionist](https://github.com/bploetz/versionist) - A plugin for versioning Rails based RESTful APIs.

## Assets

* [Asset Sync](https://github.com/AssetSync/asset_sync) - Synchronises Assets between Rails and S3.
* [Autoprefixer](https://github.com/ai/autoprefixer-rails) - Parse CSS and add vendor prefixes to rules by Can I Use.
* [Bourbon](https://github.com/thoughtbot/bourbon) - A Lightweight Sass Tool Set.
* [bower-rails](https://github.com/rharriso/bower-rails) - Bower support for Rails projects.
* [Emoji](https://github.com/wpeterson/emoji) - Exposes the Phantom Open Emoji library unicode/image assets and APIs for working with them.
* [Less Rails](https://github.com/metaskills/less-rails) - The dynamic stylesheet language for the Rails asset pipeline.
* [Less](https://github.com/cowboyd/less.rb) - Leaner CSS, in your browser or Ruby.
* [Rails Assets](https://rails-assets.org) - Bundler to Bower proxy.
* [Sass](http://sass-lang.com) - Sass makes CSS fun again.
* [Sprockets](https://github.com/sstephenson/sprockets) - Rack-based asset packaging system.
* [Torba](https://github.com/torba-rb/torba) - Bower-less bundler for Sprockets.
* [Webpacker](https://github.com/rails/webpacker) - Use Webpack to manage app-like JavaScript modules in Rails.

## Authentication and OAuth

* [Authlogic](https://github.com/binarylogic/authlogic) - Authlogic is a clean, simple, and unobtrusive ruby authentication solution.
* [Clearance](https://github.com/thoughtbot/clearance) - Small and simple email & password based authenticaton for Rails.
* [Devise](https://github.com/plataformatec/devise) - A flexible authentication solution for Rails based on Warden.
* [JWT](https://github.com/jwt/ruby-jwt) - JSON Web Token implementation in Ruby.
* [Knock](https://github.com/nsarno/knock) - Seamless JWT authentication for Rails API.
* [Monban](https://github.com/halogenandtoast/monban) - A very simple and extensible user authentication library for rails.
* [OmniAuth](https://github.com/intridea/omniauth) - A library that standardizes multi-provider authentication utilizing Rack middleware.
* [Rodauth](https://github.com/jeremyevans/rodauth) - Authentication and account management framework for Rack applications.
* [Shield](https://github.com/cyx/shield) - Authentication protocol for use in your routing and model context.
* [Sorcery](https://github.com/Sorcery/sorcery) - Magical Authentication for Rails 4, and Rails 5.
* [warden](https://github.com/hassox/warden) - General Rack Authentication Framework.
* OAuth:
  * [Doorkeeper](https://github.com/doorkeeper-gem/doorkeeper) - An OAuth2 provider for Rails.
  * [OAuth2](https://github.com/intridea/oauth2) - A Ruby wrapper for the OAuth 2.0 protocol.

## Authorization

* [acl9](https://github.com/be9/acl9) - Acl9 is a role-based authorization system that provides a concise DSL for securing your Rails application.
* [AccessGranted](https://github.com/chaps-io/access-granted) - Multi-role and whitelist based authorization gem for Rails.
* [Authority](https://github.com/nathanl/authority) - ORM-neutral way to authorize actions in your Rails app.
* [CanCanCan](https://github.com/CanCanCommunity/cancancan) - Continuation of CanCan, an authorization Gem for Ruby on Rails.
* [Declarative Authorization](https://github.com/stffn/declarative_authorization) - An authorization Rails plugin using a declarative DSL for specifying authorization rules in one place.
* [Petergate](https://github.com/elorest/petergate) - Easy to use and read action and content based authorizations.
* [Pundit](https://github.com/elabs/pundit) - Minimal authorization through OO design and pure Ruby classes.

## Automation

* [Danger](https://github.com/danger/danger) - Automate your team's conventions surrounding code review.
* [Huginn](https://github.com/cantino/huginn) - Huginn is a system for building agents that perform automated tasks for you online.

## Caching

* [Action caching for Action Pack](https://github.com/rails/actionpack-action_caching) - Action caching for Action Pack.
* [Dalli](https://github.com/mperham/dalli) - A high performance pure Ruby client for accessing memcached servers.
* [Garner](https://github.com/artsy/garner) - A set of Rack middleware and cache helpers that implement various caching strategies.
* [IdentityCache](https://github.com/Shopify/identity_cache) - A blob level caching solution to plug into ActiveRecord.
* [Kashmir](https://github.com/IFTTT/kashmir) - Kashmir is a Ruby DSL that makes serializing and caching objects a snap.
* [Readthis](https://github.com/sorentwo/readthis) - High performance, pooled, ActiveSupport compliant caching with Redis.
* [Record Cache](https://github.com/orslumen/record-cache) - Cache Active Model Records in Rails 3.
* [redis-store](http://redis-store.org/) - Redis Store provides a full set of stores (Cache, I18n, Session, HTTP Cache) for modern Ruby frameworks like: Ruby on Rails, Sinatra, Rack, Rack::Cache and I18n. It supports object marshalling, timeouts, single or multiple nodes, and namespaces.
* [Second Level Cache](https://github.com/hooopo/second_level_cache) - Write-Through and Read-Through caching library for ActiveRecord 4.

## Captchas and anti-spam

* [Invisible Captcha](https://github.com/markets/invisible_captcha) - Unobtrusive and flexible spam protection based on the honeypot strategy. It also provides a time-sensitive form submission.
* [Rakismet](https://github.com/joshfrench/rakismet) - Easy Akismet and TypePad AntiSpam integration for Rails.
* [reCAPTCHA](https://github.com/ambethia/recaptcha) - reCaptcha API helpers for ruby apps.
* [Voight-Kampff](https://github.com/biola/Voight-Kampff) - A Ruby gem that detects bots, spiders, crawlers and replicants.

## CLI Builder

* [Clamp](https://github.com/mdub/clamp) - A command-line application framework.
* [Cocaine](https://github.com/thoughtbot/cocaine) - A small library for doing (command) lines.
* [Commander](https://github.com/commander-rb/commander) - The complete solution for Ruby command-line executables.
* [GLI](https://github.com/davetron5000/gli) - Git-Like Interface Command Line Parser.
* [Main](https://github.com/ahoward/main) - A class factory and DSL for generating command line programs real quick.
* [Rake](https://github.com/ruby/rake) - A make-like build utility for Ruby.
* [Slop](https://github.com/leejarvis/slop) - Simple Lightweight Option Parsing.
* [Thor](http://whatisthor.com) - A toolkit for building powerful command-line interfaces.
* [Trollop](https://github.com/manageiq/trollop) - A commandline option parser for Ruby that just gets out of your way.
* [TTY](https://github.com/peter-murach/tty) - Toolbox for developing CLI clients.

## CLI Utilities

* [Awesome Print](https://github.com/awesome-print/awesome_print) - Pretty print your Ruby objects with style -- in full color and with proper indentation
* [Betty](https://github.com/pickhardt/betty) - Friendly English-like interface for your command line. Don't remember a command? Ask Betty.
* [colorls](https://github.com/athityakumar/colorls) - Beautifies the `ls` command, with color and font-awesome icons.
* [formatador](https://github.com/geemus/formatador) - STDOUT text formatting.
* [Paint](https://github.com/janlelis/paint) - Simple and fast way to set ANSI terminal colors.
* [Pastel](https://github.com/peter-murach/pastel) - Terminal output styling with intuitive and clean API.
* [Ru](https://github.com/tombenner/ru) - Ruby in your shell.
* [Ruby/Progressbar](https://github.com/jfelchner/ruby-progressbar) - The most flexible text progress bar library for Ruby.
* [TablePrint](https://github.com/arches/table_print) - Slice your data from multiple DB tables into a single CLI view.
* [Terminal Table](https://github.com/tj/terminal-table) - Ruby ASCII Table Generator, simple and feature rich.
* [Tmuxinator](https://github.com/tmuxinator/tmuxinator) - Create and manage complex tmux sessions easily.

## Cloud

* [AWS SDK for Ruby](https://github.com/aws/aws-sdk-ruby) - The official AWS SDK for Ruby.
* [browse-everything](https://github.com/projecthydra/browse-everything) - Multi-provider Rails engine providing access to files in cloud storage.
* [Fog](https://github.com/fog/fog) - The Ruby cloud services library.

## CMS
* [Alchemy CMS](http://alchemy-cms.com) - A powerful, userfriendly and flexible Open Source Rails CMS.
* [Camaleon CMS](http://camaleon.tuzitio.com/) - A dynamic and advanced content management system based on Ruby on Rails 4.
* [ComfortableMexicanSofa](https://github.com/comfy/comfortable-mexican-sofa) - Powerful Rails 5.2+ CMS Engine.
* [LocomotiveCMS](http://www.locomotivecms.com) - A simple but powerful CMS based on Liquid templates and Mongodb database.
* [Publify](https://github.com/publify/publify) - A self hosted Web publishing platform on Rails.
* [PushType](http://www.pushtype.org/) - A next generation, open source content management system for Ruby on Rails.
* [Radiant](http://radiantcms.org) - A no-fluff, open source content management system designed for small teams.
* [Refinery CMS](http://refinerycms.com) - An open source Ruby on Rails content management system for Rails 3 and 4.
* [Spina CMS](http://www.spinacms.com) - A beautiful CMS for Rails developers.
* [Storytime](https://github.com/CultivateLabs/storytime) - Rails 4+ CMS and bloging engine, with a core focus on content.

## Code Analysis and Metrics

* [Barkeep](https://github.com/ooyala/barkeep) - Barkeep is a fast, fun way to review code. Engineering organizations can use it to keep the bar high.
* [Brakeman](https://github.com/presidentbeef/brakeman) - A static analysis security vulnerability scanner for Ruby on Rails applications.
* [Cane](https://github.com/square/cane) - Code quality threshold checking as part of your build.
* [Coverband](https://github.com/danmayer/coverband) - Rack middleware to help measure production code coverage.
* [Fasterer](https://github.com/DamirSvrtan/fasterer) - Make your Rubies go faster with this command line tool highly inspired by fast-ruby and Sferik's talk at Baruco Conf.
* [Flay](https://github.com/seattlerb/flay) - Flay analyzes code for structural similarities. Differences in literal values, variable, class, method names, whitespace, programming style, braces vs do/end, etc are all ignored. Making this totally rad.
* [Flog](https://github.com/seattlerb/flog) - Flog reports the most tortured code in an easy to read pain report. The higher the score, the more pain the code is in.
* [fukuzatsu](https://gitlab.com/coraline/fukuzatsu/tree/master) - Complexity analysis tool with a rich web front-end.
* [MetricFu](https://github.com/metricfu/metric_fu) - A fist full of code metrics.
* [Pippi](https://github.com/tcopeland/pippi) - A utility for finding suboptimal Ruby class API usage, focused on runtime analysis.
* [Pronto](https://github.com/mmozuras/pronto) - Quick automated code review of your changes.
* [rails_best_practices](https://github.com/railsbp/rails_best_practices) - A code metric tool for rails projects.
* [Reek](https://github.com/troessner/reek) - Code smell detector for Ruby.
* [RuboCop](https://github.com/bbatsov/rubocop) - A static code analyzer, based on the community Ruby style guide.
* [Rubycritic](https://github.com/whitesmith/rubycritic) - A Ruby code quality reporter.
* [Scientist](https://github.com/github/scientist) - A Ruby library for carefully refactoring critical paths.
* [SimpleCov](https://github.com/colszowka/simplecov) - Code coverage for Ruby 1.9+ with a powerful configuration library and automatic merging of coverage across test suites.
* [Traceroute](https://github.com/amatsuda/traceroute) - A Rake task gem that helps you find the dead routes and actions for your Rails 3+ app

## Code Highlighting

* [CodeRay](https://github.com/rubychan/coderay) - Fast and easy syntax highlighting for selected languages.
* [pygments.rb](https://github.com/tmm1/pygments.rb) - A Ruby wrapper for the Python pygments syntax highlighter.
* [Rouge](https://github.com/jneen/rouge) - A pure Ruby code highlighter that is compatible with Pygments.

## Coding Style Guides

* [Best-Ruby](https://github.com/franzejr/best-ruby) - Ruby Tricks, Idiomatic Ruby, Refactoring & Best Practices.
* [fast-ruby](https://github.com/JuanitoFatas/fast-ruby) - Writing Fast Ruby. Collect Common Ruby idioms.
* [Fundamental Ruby](https://github.com/khusnetdinov/ruby.fundamental) - Fundamental programming ruby with examples. Threads, design patterns, data structures, OOP SOLID principle, algorithms.
* [Rails style guide](https://github.com/bbatsov/rails-style-guide) - Community-driven Rails best practices and style for Rails 3 and 4.
* [RSpec style guide](https://github.com/andreareginato/betterspecs) - Better Specs { rspec guidelines with ruby }.
* [Ruby Operators](http://ruby-operators.herokuapp.com/) - A webpage showing awesome names for different Ruby operators.
* [Ruby style guide](https://github.com/bbatsov/ruby-style-guide) - Community-driven Ruby coding style.

## Concurrency and Parallelism

* [Celluloid](http://celluloid.io) - Actor-based concurrent object framework for Ruby.
* [Concurrent Ruby](https://github.com/ruby-concurrency/concurrent-ruby) - Modern concurrency tools including agents, futures, promises, thread pools, supervisors, and more. Inspired by Erlang, Clojure, Scala, Go, Java, JavaScript, and classic concurrency patterns.
* [EventMachine](https://github.com/eventmachine/eventmachine) - An event-driven I/O and lightweight concurrency library for Ruby.
* [forkoff](https://github.com/ahoward/forkoff) - brain-dead simple parallel processing for ruby.
* [Parallel](https://github.com/grosser/parallel) - Run any code in parallel Processes (> use all CPUs) or Threads (> speedup blocking operations).
Best suited for map-reduce or e.g. parallel downloads/uploads.

## Configuration

* [Chamber](https://github.com/thekompanee/chamber) - Surprisingly customizable convention-based approach to managing your app's configuration.
* [Configatron](https://github.com/markbates/configatron) - Simple and feature rich configuration system for Ruby apps.
* [Configus](https://github.com/kaize/configus) - Helps you easily manage environment specific settings.
* [dotenv](https://github.com/bkeepers/dotenv) - Loads environment variables from `.env`.
* [Econfig](https://github.com/elabs/econfig) - Flexible configuration for Rails applications.
* [ENVied](https://github.com/eval/envied) - ensure presence and type of your app's ENV-variables
* [Figaro](https://github.com/laserlemon/figaro) - Simple, Heroku-friendly Rails app configuration using `ENV` and a single YAML file.
* [Global](https://github.com/railsware/global) - Provides accessor methods for your configuration data.
* [RailsConfig](https://github.com/railsconfig/config) - Multi-environment yaml settings for Rails3.

## Core Extensions

* [ActiveSupport](https://github.com/rails/rails/tree/master/activesupport) - A collection of utility classes and standard library extensions.
* [Addressable](https://github.com/sporkmonger/addressable) - Addressable is a replacement for the URI implementation that is part of Ruby's standard library. It more closely conforms to RFC 3986, RFC 3987, and RFC 6570 (level 4), providing support for IRIs and URI templates.
* [Finishing Moves](https://github.com/forgecrafted/finishing_moves) - Small, focused, incredibly useful methods added to core Ruby classes. Includes the endlessly useful `nil_chain`.
* [Hamster](https://github.com/hamstergem/hamster) - Efficient, immutable, and thread-safe collection classes for Ruby.
* [Hanami::Utils](https://github.com/hanami/utils) - Lightweight, non-monkey-patch class utilities for Hanami and Ruby app.
* [Ruby Facets](https://github.com/rubyworks/facets) - The premiere collection of general purpose method extensions and standard additions for Ruby.
* Attributes
  * [ActiveAttr](https://github.com/cgriego/active_attr) - What ActiveModel left out.
  * [FastAttributes](https://github.com/applift/fast_attributes) - FastAttributes adds attributes with their types to the class.
  * [Virtus](https://github.com/solnic/virtus) - Attributes on Steroids for Plain Old Ruby Objects.
* Hash
  * [Hashie](https://github.com/intridea/hashie) - A collection of tools that extend Hashes and make them more useful.

## Country Data

* [Carmen](https://github.com/jim/carmen) - A repository of geographic regions.
* [Countries](https://github.com/hexorx/countries) - All sorts of useful information about every country packaged as pretty little country objects.
* [GlobalPhone](https://github.com/sstephenson/global_phone) - Parse, validate, and format phone numbers in Ruby using Google's libphonenumber database.
* [i18n_data](https://github.com/grosser/i18n_data) - country/language names and 2-letter-code pairs, in 85 languages, for country/language i18n.
* [normalize_country](https://github.com/sshaw/normalize_country) - Convert country names and codes to a standard, includes a conversion program for XMLs, CSVs and DBs.

## CRM

* [Fat Free CRM](https://github.com/fatfreecrm/fat_free_crm) - An open source Ruby on Rails based customer relationship management platform.

## Cryptocurrencies and Blockchains

* [Blockchain Lite](https://github.com/openblockchains/blockchain.lite.rb) - Build your own blockchains with crypto hashes; revolutionize the world with blockchains, blockchains, blockchains one block at a time.

## Dashboards

* [Dashing](http://shopify.github.io/dashing/) - A Sinatra based framework that lets you build beautiful dashboards.
* [Dashing-Rails](https://github.com/gottfrois/dashing-rails) - The exceptionally handsome dashboard framework for Rails.

## Data Processing and ETL

* [Kiba](http://www.kiba-etl.org) - A lightweight data processing / ETL framework for Ruby.

## Data Visualization

* [Chartkick](http://ankane.github.io/chartkick/) - Create beautiful Javascript charts with one line of Ruby. Works with Rails, Sinatra and most browsers (including IE 6).
* [GeoPattern](https://github.com/jasonlong/geo_pattern) - Create beautiful generative geometric background images from a string.
* [LazyHighCharts](https://github.com/michelson/lazy_high_charts) - A simple and extremely flexible way to use HighCharts from ruby code. Tested on Ruby on Rails, Sinatra and Nanoc, but it should work with others too.
* [RailRoady](https://github.com/preston/railroady) - Ruby on Rails 3/4 model and controller UML class diagram generator.
* [Rails Erd](https://github.com/voormedia/rails-erd) - Generate Entity-Relationship Diagrams for Rails applications.
* [Ruby/GraphViz](https://github.com/glejeune/Ruby-Graphviz) - Ruby interface to the GraphViz graphing tool.

## Database Drivers

* [Cassandra Driver](https://github.com/datastax/ruby-driver) - A pure ruby driver for Apache Cassandra with asynchronous io and configurable load balancing, reconnection and retry policies.
* [DataObjects](https://github.com/datamapper/do) - An attempt to rewrite existing Ruby database drivers to conform to one, standard interface.
* [mongo-ruby-driver](https://github.com/mongodb/mongo-ruby-driver) - MongoDB Ruby driver.
* [mysql2](https://github.com/brianmario/mysql2) - A modern, simple and very fast Mysql library for Ruby (binding to libmysql).
* [Neography](https://github.com/maxdemarzi/neography) - A thin Ruby wrapper to the Neo4j Rest API.
* [Redic](https://github.com/amakawa/redic) - Lightweight Redis Client.
* [redis-rb](https://github.com/redis/redis-rb) - A Ruby client that tries to match Redis' API one-to-one, while still providing an idiomatic interface.
* [ruby-pg](https://bitbucket.org/ged/ruby-pg) - Ruby interface to PostgreSQL 8.3 and later.
* [SQLite3](https://github.com/sparklemotion/sqlite3-ruby) - Ruby bindings for the SQLite3 embedded database.
* [SQL Server](https://github.com/rails-sqlserver/activerecord-sqlserver-adapter) - The SQL Server adapter for ActiveRecord.
* [TinyTDS](https://github.com/rails-sqlserver/tiny_tds) - FreeTDS bindings for Ruby using DB-Library.

## Database Tools

* [connection_pool](https://github.com/mperham/connection_pool) - Generic connection pooling for Ruby, that can be used with anything, e.g. Redis, Dalli, etc.
* [Database Cleaner](https://github.com/DatabaseCleaner/database_cleaner) - Database Cleaner is a set of strategies for cleaning your database in Ruby.
* [Foreigner](https://github.com/matthuhiggins/foreigner) - Adds foreign key helpers to migrations and correctly dumps foreign keys to schema.rb.
* [Large Hadron Migrator](https://github.com/soundcloud/lhm) - Online MySQL schema migrations without locking the table.
* [Lol DBA](https://github.com/plentz/lol_dba) - Scan your models and displays a list of columns that probably should be indexed.
* [Polo](https://github.com/IFTTT/polo) - Creates sample database snapshots to work with real world data in development.
* [PgHero](https://github.com/ankane/pghero) - Postgres insights made easy.
* [Rails DB](https://github.com/igorkasyanchuk/rails_db) - Database Viewer and SQL Query Runner.
* [Scenic](https://github.com/thoughtbot/scenic) - Versioned database views for Rails.
* [SchemaPlus](https://github.com/SchemaPlus/schema_plus) - SchemaPlus provides a collection of enhancements and extensions to ActiveRecord
* [Seedbank](https://github.com/james2m/seedbank) - Seedbank allows you to structure your Rails seed data instead of having it all dumped into one large file.
* [Seed dump](https://github.com/rroblak/seed_dump) - Rails 4 task to dump (parts) of your database to db/seeds.rb.
* [Seed Fu](https://github.com/mbleigh/seed-fu) - Advanced seed data handling for Rails.
* [Upsert](https://github.com/seamusabshere/upsert) - Upsert on MySQL, PostgreSQL, and SQLite3. Transparently creates functions (UDF) for MySQL and PostgreSQL; on SQLite3, uses INSERT OR IGNORE.
* [SecondBase](https://github.com/customink/secondbase) - Seamless second database integration for Rails. SecondBase provides support for Rails to manage dual databases by extending ActiveRecord tasks that create, migrate, and test your application.

## Date and Time Processing

* [biz](https://github.com/zendesk/biz) - Time calculations using business hours.
* [business_time](https://github.com/bokmann/business_time) - Support for doing time math in business hours and days.
* [ByStar](https://github.com/radar/by_star) - Find ActiveRecord objects by year, month, fortnight, week and more!
* [Chronic](https://github.com/mojombo/chronic) - A natural language date/time parser written in pure Ruby.
* [groupdate](https://github.com/ankane/groupdate) - The simplest way to group temporal data in ActiveRecord, arrays and hashes.
* [ice_cube](https://github.com/seejohnrun/ice_cube) - A date recurrence library which allows easy creation of recurrence rules and fast querying.
* [local_time](https://github.com/basecamp/local_time) - Rails Engine for cache-friendly, client-side local time.
* [montrose](https://github.com/rossta/montrose) - a simple library for expressing, serializing, and enumerating recurring events in Ruby
* [time-lord](https://github.com/krainboltgreene/time-lord) - Adds extra functionality to the time class.
* [time_diff](https://github.com/abhidsm/time_diff) - Calculates the difference between two time.
* [TZinfo](https://github.com/tzinfo/tzinfo) - Provides daylight savings aware transformations between times in different timezones.
* [validates_timeliness](https://github.com/adzap/validates_timeliness) - Date and time validation plugin for ActiveModel and Rails.
* [yymmdd](https://github.com/sshaw/yymmdd) - Tiny DSL for idiomatic date parsing and formatting.

## Debugging Tools

* [Byebug](https://github.com/deivid-rodriguez/byebug) - A simple to use, feature rich debugger for Ruby 2.
* [did_you_mean](https://github.com/yuki24/did_you_mean) - Adds class, method & attributute suggestions to error messages.
* [Pry Byebug](https://github.com/deivid-rodriguez/pry-byebug) - Pry navigation commands via byebug.
* [Rails Footnotes](https://github.com/josevalim/rails-footnotes) - Rails footnotes displays footnotes in your application for easy debugging, such as sessions, request parameters, cookies, filter chain, routes, queries, etc.
* [Seeing Is Believing](https://github.com/JoshCheek/seeing_is_believing) - Displays the results of every line of code in your file.
* [Xray](https://github.com/brentd/xray-rails) - A development tool that reveals your UI's bones.

## Decorators

* [Draper](https://github.com/drapergem/draper) - Draper adds an object-oriented layer of presentation logic to your Rails application.
* [ShowFor](https://github.com/plataformatec/show_for) - Quickly show a model information with I18n features. Like form_for for displaying model data.

## DevOps Tools

* [Backup](https://github.com/backup/backup) - Provides an elegant DSL in Ruby for performing backups on UNIX-like systems.
* [Blender](https://github.com/PagerDuty/blender) - A modular system orchestration framework with pluggable driver and host discovery.
* [BOSH](https://github.com/cloudfoundry/bosh) - Cloud Foundry BOSH is an open source tool chain for release engineering, deployment and lifecycle management of large scale distributed services.
* [Capistrano](http://capistranorb.com) - A remote server automation and deployment tool written in Ruby.
* [Centurion](https://github.com/newrelic/centurion) - A mass deployment tool for Docker fleets.
* [Chef](https://github.com/chef/chef) - A systems integration framework, built to bring the benefits of configuration management to your entire infrastructure.
* [Deployinator](https://github.com/etsy/deployinator) - Deployinator is a deployment framework extracted from Etsy.
* [Einhorn](https://github.com/stripe/einhorn) - Einhorn will open one or more shared sockets and run multiple copies of your process. You can seamlessly reload your code, dynamically reconfigure Einhorn, and more.
* [Kochiku](https://github.com/square/kochiku) - Kochiku is a distributed platform for test automation.
* [Lita](https://www.lita.io/) - ChatOps for Ruby: A pluggable chat bot framework usable with any chat service.
* [Logstash](https://github.com/elastic/logstash) - Logs/event transport, processing, management, search.
* [Mina](https://github.com/mina-deploy/mina) - Really fast deployer and server automation tool.
* [Puppet](https://github.com/puppetlabs/puppet) - An automated administrative engine for your Linux, Unix, and Windows systems, performs administrative tasks (such as adding users, installing packages, and updating server configurations) based on a centralized specification.
* [Request-log-analyzer](https://github.com/wvanbergen/request-log-analyzer) - Create reports based on your log files. Supports Rails, Apache, MySQL, Delayed::Job, and other formats.
* [Rubber](https://github.com/rubber/rubber) - The rubber plugin enables relatively complex multi-instance deployments of RubyOnRails applications to Amazon's Elastic Compute Cloud (EC2).
* [SSHKey](https://github.com/bensie/sshkey) - SSH private and public key generator in pure Ruby (RSA & DSA).
* [Ruby-LXC](https://github.com/lxc/ruby-lxc) - Native ruby binding for Linux containers.
* [Vagrant](http://www.vagrantup.com) - Create and configure lightweight, reproducible, and portable development environments.

## Diff

* [Diffy](https://github.com/samg/diffy) - Easy Diffing With Ruby.
* [gemdiff](https://github.com/teeparham/gemdiff) - Find source repositories for gems. Open, compare, and update outdated gem versions.
* [JsonCompare](https://github.com/a2design-inc/json-compare) - Returns the difference between two JSON files.

## Documentation

* [Annotate](https://github.com/ctran/annotate_models) - Add a comment documenting the current schema to the top or bottom of each of your ActiveRecord models.
* [Apipie](https://github.com/Apipie/apipie-rails) - Rails API documentation and display tool using Ruby syntax.
* [Asciidoctor](http://asciidoctor.org) - A fast, Ruby-based text processor & publishing toolchain for converting AsciiDoc to HTML5, DocBook, EPUB3, PDF & more.
* [Doctor](https://github.com/minio/doctor) - Doctor is a Documentation Server for all your docs in github.
* [Documentation](https://github.com/adamcooke/documentation) - A Rails engine to provider the ability to add documentation to a Rails application.
* [GitHub Changelog Generator](https://github.com/skywinder/github-changelog-generator) - Automatically generate change log from your tags, issues, labels and pull requests on GitHub.
* [Gollum](https://github.com/gollum/gollum) - A simple, Git-powered wiki with a sweet API and local frontend.
* [grape-swagger](https://github.com/ruby-grape/grape-swagger) - Add swagger compliant documentation to your Grape API.
* [Hanna](https://github.com/rdoc/hanna-nouveau) - An RDoc formatter built with simplicity, beauty and ease of browsing in mind.
* [Hologram](https://github.com/trulia/hologram) - A markdown based documentation system for style guides. It parses comments in your CSS and helps you turn them into a beautiful style guide.
* [Inch](https://github.com/rrrene/inch) - Inch is a documentation measurement and evalutation tool for Ruby code, based on YARD.
* [RDoc](https://github.com/ruby/rdoc) - RDoc produces HTML and command-line documentation for Ruby projects.
* [rspec_api_documentation](https://github.com/zipmark/rspec_api_documentation) - Automatically generate API documentation from RSpec.
* [YARD](http://yardoc.org) - YARD enables the user to generate consistent, usable documentation that can be exported to a number of formats very easily.

## E-Commerce and Payments

* [Active Merchant](https://github.com/activemerchant/active_merchant) - A simple payment abstraction library extracted from Shopify.
* [Braintree](https://github.com/braintree/braintree_ruby) - Braintree Ruby bindings.
* [Conekta](https://github.com/conekta/conekta-ruby) - Conekta Ruby bindings.
* [credit_card_validations](https://github.com/Fivell/credit_card_validations) - A ruby gem for validating credit card numbers, generating valid numbers, Luhn checks.
* [Koudoku](https://github.com/andrewculver/koudoku) - Robust subscription support for Ruby on Rails apps using Stripe, including out-of-the-box pricing pages, payment pages, and subscription management.
* [Payola](https://github.com/peterkeen/payola) - Drop-in Rails engine for accepting payments with Stripe.
* [Paypal Merchant SDK](https://github.com/paypal/merchant-sdk-ruby) - Official Paypal Merchant SDK for Ruby.
* [Piggybak](https://github.com/piggybak/piggybak) - Modular, Extensible open-source ecommerce solution for Ruby on Rails.
* [ROR Ecommerce](https://github.com/drhenner/ror_ecommerce) - A Rails e-commerce platform.
* [Solidus](https://github.com/solidusio/solidus) - An open source, eCommerce application for high volume retailers.
* [Spree](https://github.com/spree/spree) - Spree is a complete open source e-commerce solution for Ruby on Rails.
* [stripe-ruby](https://github.com/stripe/stripe-ruby) - Stripe Ruby bindings.

## Ebook

* [Bookshop](https://github.com/worlduniting/bookshop) - Bookshop is a an open-source agile book development and publishing framework for authors, editors.
* [Eeepub](https://github.com/jugyo/eeepub) - EeePub is a Ruby ePub generator.
* [Gepub](https://github.com/skoji/gepub) - A generic EPUB library for Ruby : supports EPUB 3.
* [Git Scribe](https://github.com/schacon/git-scribe) - Basically the best way to write an ebook.
* [Mobi](https://github.com/jkongie/mobi) - A Ruby way to read MOBI format metadata.
* [Review](https://github.com/kmuto/review) - Re:VIEW is flexible document format/conversion system.

## Email

* [Gibbon](https://github.com/amro/gibbon) - API wrapper for the Mailchimp e-mail marketing platform.
* [Griddler](https://github.com/thoughtbot/griddler) - Simplify receiving email in Rails.
* [Incoming](https://github.com/honeybadger-io/incoming) - Incoming! helps you receive email in your Rack apps.
* [LetterOpener](https://github.com/ryanb/letter_opener) - Preview mail in the browser instead of sending.
* [Mail](https://github.com/mikel/mail) - A Really Ruby Mail Library.
* [MailCatcher](http://mailcatcher.me) - Catches mail and serves it through a dream.
* [MailForm](https://github.com/plataformatec/mail_form) - Send e-mail straight from forms in Rails with I18n, validations, attachments and request information.
* [Mailman](https://github.com/mailman/mailman) - An incoming mail processing microframework in Ruby.
* [Maily](https://github.com/markets/maily) - A Rails Engine to manage, test and navigate through all your email templates of your app, being able to preview them directly in your browser.
* [Markerb](https://github.com/plataformatec/markerb) - Allows you to render multipart e-mails from a single template written in Markdown.
* [Pony](https://github.com/benprew/pony) - The express way to send mail from Ruby.
* [premailer-rails](https://github.com/fphilipe/premailer-rails) - CSS styled emails without the hassle.
* [Roadie](https://github.com/Mange/roadie) - Roadie tries to make sending HTML emails a little less painful by inlining stylesheets and rewriting relative URLs for you inside your emails.
* [Sup](https://github.com/sup-heliotrope/sup) - A curses threads-with-tags style email client.

## Encryption

* [RbNaCl](https://github.com/cryptosphere/rbnacl) - Ruby binding to the Networking and Cryptography (NaCl) library.
* [Symmetric Encryption](http://rocketjob.github.io/symmetric-encryption/) - Transparently encrypt ActiveRecord, Mongoid, and MongoMapper attributes. Encrypt passwords in configuration files. Encrypt entire files at rest.
* [Themis](https://github.com/cossacklabs/themis) - crypto library for painless data security, providing symmetric and asymmetric encryption, secure sockets with forward secrecy, for mobile and server platforms.

## Environment Management

* [chruby](https://github.com/postmodern/chruby) - Change your current Ruby. No shims, no crazy options or features, ~90 LOC.
* [fry](https://github.com/terlar/fry) - Simple ruby version manager for fish.
* [gem_home](https://github.com/postmodern/gem_home) - A tool for changing your $GEM_HOME.
* [rbenv](https://github.com/sstephenson/rbenv) - Use rbenv to pick a Ruby version for your application and guarantee that your development environment matches production.
* [ruby-build](https://github.com/sstephenson/ruby-build) - Compile and install Ruby.
* [ruby-install](https://github.com/postmodern/ruby-install) - Installs Ruby, JRuby, Rubinius, MagLev or MRuby.
* [RVM](https://rvm.io) - RVM is a command-line tool which allows you to easily install, manage, and work with multiple ruby environments from interpreters to sets of gems.
* [Tokaido](https://github.com/tokaido/tokaidoapp/releases) - Ruby, Rails, SQLite and Redis encapsulated in a single drag-and-drop OS X app, designed to make installing a working RoR environment easy for beginners.

## Error Handling

* [Airbrake](https://github.com/airbrake/airbrake) - The official Airbrake library for Ruby on Rails (and other Rack based frameworks).
* [Better Errors](https://github.com/charliesome/better_errors) - Better error page for Rack apps.
* [Bugsnag](https://github.com/bugsnag/bugsnag-ruby) - Error monitoring for Rails, Sinatra, Rack, and plain Ruby apps.
* [Errbit](http://errbit.github.io/errbit) - The open source, self-hosted error catcher.
* [Exception Handler](https://github.com/richpeck/exception_handler) - Custom error pages.
* [Exception Notification](https://github.com/smartinez87/exception_notification) - A set of notifiers for sending notifications when errors occur in a Rack/Rails application.
* [Honeybadger](https://www.honeybadger.io/) - Exception, uptime, and performance monitoring for Ruby.
* [Nesty](https://github.com/skorks/nesty) - Nested exceptions for Ruby.
* [Raven Ruby](https://github.com/getsentry/raven-ruby) - Raven is a Ruby client for Sentry.

## Feature Flippers and A/B Testing

* [Motorhead](https://github.com/amatsuda/motorhead) - A Rails Engine framework that helps safe and rapid feature prototyping.
* [flipper](https://github.com/jnunemaker/flipper) - Feature flipping for ANYTHING. Make turning features on/off so easy that everyone does it. Whatever your data store, throughput, or experience.
* [Rollout](https://github.com/FetLife/rollout) - Feature flippers.
* [Split](https://github.com/splitrb/split) - Rack Based AB testing framework.
* [Vanity](https://github.com/assaf/vanity) - an A/B testing framework for Rails that is datastore agnostic.

## File Upload

* [attache](https://github.com/choonkeat/attache) - Standalone image and file server to decouple your app from file management concerns.
* [CarrierWave](https://github.com/carrierwaveuploader/carrierwave) - Classier solution for file uploads for Rails, Sinatra and other Ruby web frameworks.
* [DragonFly](https://github.com/markevans/dragonfly) - A Ruby gem for on-the-fly processing - suitable for image uploading in Rails, Sinatra and much more!.
* [PaperClip](https://github.com/thoughtbot/paperclip) - Easy file attachment management for ActiveRecord.
* [rack-secure-upload](https://github.com/dtaniwaki/rack-secure-upload) - Upload files securely.
* [Refile](https://github.com/refile/refile) - A modern file upload library for Ruby applications, Refile is an attempt by CarrierWave's original author to fix the design mistakes and overengineering in CarrierWave.
* [Shrine](https://github.com/janko-m/shrine) - Toolkit for handling file uploads in Ruby.

## File System

* [Guard](https://github.com/guard/guard) - A command line tool to easily handle events on file system modifications.

## Form Builder

* [Abracadabra](https://github.com/TrevorHinesley/abracadabra) - The gem that swaps out text with a fully-compliant Rails form in one click.
* [Cocoon](https://github.com/nathanvda/cocoon) - Dynamic nested forms using jQuery made easy; works with formtastic, simple_form or default forms.
* [Formtastic](https://github.com/justinfrench/formtastic) - A Rails form builder plugin with semantically rich and accessible markup.
* [Rails Bootstrap Forms](https://github.com/bootstrap-ruby/rails-bootstrap-forms) - Rails form builder that makes it super easy to create beautiful-looking forms with Twitter Bootstrap 3+.
* [Reform](https://github.com/apotonick/reform) - Gives you a form object with validations and nested setup of models. It is completely framework-agnostic and doesn't care about your database.
* [Simple Form](https://github.com/plataformatec/simple_form) - Rails forms made easy.

## Game Development

* [Gosu](http://www.libgosu.org) - A 2D game development library for the Ruby and C++ programming languages.
* [Yeah](https://github.com/yeahrb/yeah) - Practical Ruby video game framework.

## Geolocation

* [Geocoder](https://github.com/alexreisner/geocoder) - A complete geocoding solution for Ruby. With Rails it adds geocoding (by street or IP address), reverse geocoding (find street address based on given coordinates), and distance queries.
* [geoip](https://github.com/cjheath/geoip) - Searches a GeoIP database for a given host or IP address, and returns information about the country where the IP address is allocated, and the city, ISP and other information.
* [Geokit](https://github.com/geokit/geokit) - Geokit gem provides geocoding and distance/heading calculations.
* [Google Maps for Rails](https://github.com/apneadiving/Google-Maps-for-Rails) - Enables easy Google map + overlays creation in Ruby apps.
* [rgeo](https://github.com/rgeo/rgeo) - Geospatial data library. Spatial data types, geometric and spherical calculations, and WKT/WKB serialization.

## Git Tools

* [ginatra](https://github.com/NARKOZ/ginatra) - A web frontend for Git repositories.
* [git-auto-bisect](https://github.com/grosser/git-autobisect) - Find the commit that broke master.
* [git_reflow](https://github.com/reenhanced/gitreflow) - An automated quality control workflow for Agile teams.
* [git-spelunk](https://github.com/osheroff/git-spelunk) - Dig through git blame history.
* [git-up](https://github.com/aanand/git-up) - Fetch and rebase all locally-tracked remote branches.
* [git-whence](https://github.com/grosser/git-whence) - Find which merge a commit came from.
* [Git Cop](https://github.com/bkuhlmann/git-cop) - Enforces consistent Git commits.
* [Overcommit](https://github.com/brigade/overcommit) - A fully configurable and extendable Git hook manager.
* [Rugged](https://github.com/libgit2/rugged) - Ruby bindings to libgit2.

## GraphQL

* [graphql-batch](https://github.com/Shopify/graphql-batch) – A query batching executor.
* [graphql-client](https://github.com/github/graphql-client) - A library for declaring, composing and executing GraphQL queries.
* [graphql-guard](https://github.com/exAspArk/graphql-guard) - A simple field-level authorization.
* [graphql-ruby](https://github.com/rmosolgo/graphql-ruby) - Ruby implementation of GraphQL.

## GUI

* [qtbindings](https://github.com/ryanmelt/qtbindings) - Allows the QT Gui toolkit to be used from Ruby.
* [RubyGnome2](http://ruby-gnome2.sourceforge.jp/) - Ruby language bindings for the GNOME 2.0 development environment.
* [Shoes](http://shoesrb.com) - Shoes makes building little graphical programs for Mac, Windows, and Linux super simple.

## HTML/XML Parsing

* [HappyMapper](https://github.com/dam5s/happymapper) - Object to XML mapping library, using Nokogiri.
* [HTML::Pipeline](https://github.com/jch/html-pipeline) - HTML processing filters and utilities.
* [Nokogiri](http://nokogiri.org) - An HTML, XML, SAX, and Reader parser with XPath and CSS selector support.
* [Oga](https://github.com/YorickPeterse/oga) - An XML/HTML parser written in Ruby. Oga does not require system libraries such as libxml, making it easier and faster to install on various platforms.
* [Ox](https://github.com/ohler55/ox) - A fast XML parser and Object marshaller.
* [ROXML](https://github.com/Empact/roxml) - Custom mapping and bidirectional marshalling between Ruby and XML using annotation-style class methods, via Nokogiri or LibXML.

## HTTP Clients and tools

* [excon](https://github.com/excon/excon) - Usable, fast, simple Ruby HTTP 1.1. It works great as a general HTTP(s) client and is particularly well suited to usage in API clients.
* [Faraday](https://github.com/lostisland/faraday) - an HTTP client lib that provides a common interface over many adapters (such as Net::HTTP) and embraces the concept of Rack middleware when processing the request/response cycle.
* [Device Detector](https://github.com/podigee/device_detector) - A precise and fast user agent parser and device detector, backed by the largest and most up-to-date user agent database.
* [Http Client](https://github.com/nahi/httpclient) - Gives something like the functionality of libwww-perl (LWP) in Ruby.
* [HTTP](https://github.com/httprb/http) - The HTTP Gem: a simple Ruby DSL for making HTTP requests.
* [httparty](https://github.com/jnunemaker/httparty) - Makes http fun again!
* [Http-2](https://github.com/igrigorik/http-2) - Pure Ruby implementation of HTTP/2 protocol
* [Patron](https://github.com/toland/patron) - Patron is a Ruby HTTP client library based on libcurl.
* [RESTClient](https://github.com/rest-client/rest-client) - Simple HTTP and REST client for Ruby, inspired by microframework syntax for specifying actions.
* [Savon](https://github.com/savonrb/savon) - Savon is a SOAP client for the Ruby programming language.
* [Sawyer](https://github.com/lostisland/sawyer) - Secret user agent of HTTP, built on top of Faraday.
* [Typhoeus](https://github.com/typhoeus/typhoeus) - Typhoeus wraps libcurl in order to make fast and reliable requests.

## Image Processing

* [MiniMagick](https://github.com/minimagick/minimagick) - A ruby wrapper for ImageMagick or GraphicsMagick command line.
* [Phasion](https://github.com/westonplatter/phashion) - Ruby wrapper around pHash, the perceptual hash library for detecting duplicate multimedia files.
* [PSD.rb](https://github.com/layervault/psd.rb) - Parse Photoshop files in Ruby with ease.
* [RMagick](https://github.com/rmagick/rmagick) - RMagick is an interface between Ruby and ImageMagick.
* [ruby-vips](https://github.com/jcupitt/ruby-vips) - A binding for the libvips image processing library.
* [Skeptick](https://github.com/maxim/skeptick) - Skeptick is an all-purpose DSL for building and running ImageMagick commands.

## Implementations/Compilers

* [JRuby](https://github.com/jruby/jruby) - A Java implementation of the Ruby language.
* [MRuby](https://github.com/mruby/mruby) - Lightweight Ruby. Can be linked and embedded in your application.
* [Opal](https://github.com/opal/opal) - Ruby to Javascript compiler.
* [Rubinius](https://github.com/rubinius/rubinius) - An implementation of the Ruby programming language. Rubinius includes a bytecode virtual machine, Ruby syntax parser, bytecode compiler, generational garbage collector, just-in-time (JIT) native machine code compiler, and Ruby Core and Standard libraries.

## Internationalization

* [FastGettext](https://github.com/grosser/fast_gettext) - Ruby internationalization tool with less memory, simple, clean namespace and threadsafe.
* [Globalize](https://github.com/globalize/globalize) - Globalize builds on the I18n API in Ruby on Rails to add model translations to ActiveRecord models.
* [i18n-tasks](https://github.com/glebm/i18n-tasks) - Manage missing and unused translations with the awesome power of static analysis.
* [i18n](https://github.com/svenfuchs/i18n) - Ruby Internationalization and localization solution.
* [r18n](https://github.com/ai/r18n) - Advanced i18n library for Rails, Sinatra, desktop apps, models, works well with complex languages like Russian.
* [Termit](https://github.com/pawurb/termit) - Translations with speech synthesis in your terminal.
* [Tolk](https://github.com/tolk/tolk) - A web interface for doing i18n translations packaged as a Rails engine.
* [twitter-cldr-rb](https://github.com/twitter/twitter-cldr-rb) - Ruby implementation of the ICU (International Components for Unicode) that uses the Common Locale Data Repository to format dates, plurals, and more.

## IRB

* [Clipboard](https://github.com/janlelis/clipboard) - Access to the system clipboard on Linux, MacOS and Windows.
* [Hirb](https://github.com/cldwalker/hirb) - A mini view framework for console/irb that's easy to use, even while under its influence. Console goodies include a no-wrap table, auto-pager, tree and menu.
* [irbtools](https://github.com/janlelis/irbtools) - Improvements for Ruby's IRB.
* [Looksee](https://github.com/oggy/looksee) - A tool for illustrating the ancestry and method lookup path of objects. Handy for exploring unfamiliar codebases.
* [Pry](https://github.com/pry/pry) - A powerful alternative to the standard IRB shell for Ruby.
* [rib](http://rib.godfat.org) - A lightweight and extensible IRB replacement.

## Logging

* [Cabin](https://github.com/jordansissel/ruby-cabin) - Structured+contextual logging experiments in Ruby.
* [Fluentd](https://github.com/fluent/fluentd) - Fluentd collects events from various data sources and writes them to files, database or other types of storages.
* [HttpLog](https://github.com/trusche/httplog) - Log outgoing HTTP requests.
* [Log4r](https://github.com/colbygk/log4r) - Log4r is a comprehensive and flexible logging library for use in Ruby programs.
* [Logging](https://github.com/TwP/logging) - A flexible logging library for use in Ruby programs based on the design of Java's log4j library.
* [Lograge](https://github.com/roidrage/lograge) - An attempt to tame Rails' default policy to log everything.
* [MongoDB Logger](https://github.com/le0pard/mongodb_logger) - MongoDB logger for Rails.
* [Scrolls](https://github.com/asenchi/scrolls) - Simple logging.
* [Semantic Logger](https://rocketjob.github.io/semantic_logger/) - Scalable, next generation enterprise logging for Ruby.
* [Yell](https://github.com/rudionrails/yell) - Your Extensible Logging Library.

## Machine Learning

* [Awesome Machine Learning with Ruby](https://github.com/arbox/machine-learning-with-ruby) - A Curated List of Ruby Machine Learning Links and Resources.
* [PredictionIO Ruby SDK](https://github.com/PredictionIO/PredictionIO-Ruby-SDK) - The PredictionIO Ruby SDK provides a convenient API to quickly record your users' behavior and retrieve personalized predictions for them.
* [rb-libsvm](https://github.com/febeling/rb-libsvm) - Ruby language bindings for LIBSVM. SVM is a machine learning and classification algorithm.
* [Ruby Datumbox Wrapper](https://github.com/marloncarvalho/ruby-datumbox) - It's a simple Ruby Datumbox Wrapper. At the moment the API currently allows you to build applications that make use of machine learning algorithms.
* [weka](https://github.com/paulgoetze/weka-jruby) - Machine learning and data mining algorithms for JRuby.

## Markdown Processors

* [kramdown](https://github.com/gettalong/kramdown) - Kramdown is yet-another-markdown-parser but fast, pure Ruby, using a strict syntax definition and supporting several common extensions.
* [Maruku](https://github.com/bhollis/maruku) - A pure-Ruby Markdown-superset interpreter.
* [Redcarpet](https://github.com/vmg/redcarpet) - A fast, safe and extensible Markdown to (X)HTML parser.
* [word-to-markdown](https://github.com/benbalter/word-to-markdown) - Gem to convert Microsoft Word documents to Markdown.

## Mobile Development

* [dryrun](https://github.com/cesarferreira/dryrun) - Try any Android library on your smartphone directly from the command line.
* [fastlane](https://github.com/fastlane/fastlane) - Connect all iOS deployment tools into one streamlined workflow.
* [Ruboto](https://github.com/ruboto/ruboto) - A platform for developing full stand-alone apps for Android using the Ruby language and libraries.
* [RubyMotion](http://www.rubymotion.com) - A revolutionary toolchain that lets you quickly develop and test full-fledged native iOS and OS X applications for iPhone, iPad, Mac and Android.
* [Ruby Push Notifications](https://github.com/calonso/ruby-push-notifications) - iOS, Android and Windows Phone Push notifications made easy.
* [Rpush](https://github.com/rpush/rpush) - The push notification service for Ruby which supports Apple Push Notification Service, Google Cloud Messaging, Amazon Device Messaging and Windows Phone Push Notification Service.

## Money

* [eu_central_bank](https://github.com/RubyMoney/eu_central_bank) - A gem that calculates the exchange rate using published rates from European Central Bank.
* [Monetize](https://github.com/RubyMoney/monetize) - A library for converting various objects into Money objects.
* [Money](https://github.com/RubyMoney/money) - A Ruby Library for dealing with money and currency conversion.

## Music and Sound

* [Sonic Pi](https://github.com/samaaron/sonic-pi) - A live coding synth for everyone originally designed to support computing and music lessons.
* [play ►](https://github.com/play/play) - Your company's dj.

## Natural Language Processing

* [Awesome NLP with Ruby](https://github.com/arbox/nlp-with-ruby) - Awesome List for Practical Natural Language Processing done in Ruby.
* [Parslet](http://kschiess.github.io/parslet/) - A small Ruby library for constructing parsers in the PEG (Parsing Expression Grammar) fashion.
* [pocketsphinx-ruby](https://github.com/watsonbox/pocketsphinx-ruby) - Ruby speech recognition with Pocketsphinx.
* [Pragmatic Segmenter](https://github.com/diasks2/pragmatic_segmenter) - Pragmatic Segmenter is a rule-based sentence boundary detection gem that works out-of-the-box across many languages.
* [Ruby Natural Language Processing Resources](https://github.com/diasks2/ruby-nlp) - Collection of links to Ruby Natural Language Processing (NLP) libraries, tools and software.
* [Text](https://github.com/threedaymonk/text) - A collection of text algorithms including Levenshtein distance, Metaphone, Soundex 2, Porter stemming & White similarity.
* [Treat](https://github.com/louismullie/treat) - Treat is a toolkit for natural language processing and computational linguistics in Ruby.
* [Treetop](https://github.com/cjheath/treetop) - PEG (Parsing Expression Grammar) parser.
* [Words Counted](https://github.com/abitdodgy/words_counted) - A highly customisable Ruby text analyser and word counter.

## Navigation

* [active_link_to](https://github.com/comfy/active_link_to) - View helper to manage "active" state of a link.
* [Breadcrumbs on Rails](https://github.com/weppos/breadcrumbs_on_rails) - A simple Ruby on Rails plugin for creating and managing a breadcrumb navigation for a Rails project.
* [Gretel](https://github.com/lassebunk/gretel) - A Ruby on Rails plugin that makes it easy yet flexible to create breadcrumbs.
* [loaf](https://github.com/peter-murach/loaf) - Manages and displays breadcrumb trails in Rails app - lean & mean.
* [Simple Navigation](https://github.com/codeplant/simple-navigation) - A ruby gem for creating navigation (html list, link list or breadcrumbs with multiple levels) for your Rails 2, 3 & 4, Sinatra or Padrino.

## Networking

* [RubyDNS](https://github.com/ioquatix/rubydns) - A high-performance DNS server which can be easily integrated into other projects or used as a stand-alone daemon.

## ORM/ODM

* [ActiveRecord](https://github.com/rails/rails/tree/master/activerecord) - Object-relational mapping in Rails.
* [DataMapper](https://github.com/datamapper/dm-core) - ORM which works well with legacy databases. Last release (1.2.0) was on 13 October 2011.
* [Guacamole](https://github.com/triAGENS/guacamole) -  An ODM for ArangoDB.
* [Hanami::Model](https://github.com/hanami/model) - A lean Repository-pattern based ORM framework for Hanami and modern Ruby applications.
* [Mongoid](https://github.com/mongodb/mongoid) - An ODM (Object-Document-Mapper) framework for MongoDB in Ruby.
* [MongoMapper](https://github.com/mongomapper/mongomapper) - A Ruby Object Mapper for Mongo.
* [MongoModel](https://github.com/spohlenz/mongomodel) -  Ruby ODM for interfacing with MongoDB databases.
* [Neo4j.rb](http://neo4jrb.io) - A Neo4j OGM (Object-Graph-Mapper) for use in Ruby on Rails and Rack frameworks heavily inspired by ActiveRecord.
* [NoBrainer](https://github.com/nviennot/nobrainer/) - A RethinkDB ORM for Ruby
* [Ohm](https://github.com/soveran/ohm) - Object-hash mapping library for Redis.
* [Perpetuity](https://github.com/jgaskins/perpetuity) - Persistence gem for Ruby objects using the Data Mapper pattern.
* [Redis-Objects](https://github.com/nateware/redis-objects) - Redis Objects provides a Rubyish interface to Redis, by mapping Redis data types to Ruby objects, via a thin layer over the redis gem.
* [ROM](https://github.com/rom-rb/rom) - Ruby Object Mapper (ROM) is an experimental Ruby library with the goal to provide powerful object mapping capabilities without limiting the full power of your datastore.
* [Sequel](https://github.com/jeremyevans/sequel) - Sequel is a simple, flexible, and powerful SQL database access toolkit for Ruby.

## ORM/ODM Extensions

* Auditing and Versioning
  * [ActsAsParanoid](https://github.com/ActsAsParanoid/acts_as_paranoid) - ActiveRecord plugin allowing you to hide and restore records without actually deleting them.
  * [Audited](https://github.com/collectiveidea/audited) - Audited is an ORM extension for ActiveRecord & MongoMapper that logs all changes to your models.
  * [Destroyed At](https://github.com/dockyard/ruby-destroyed_at) - Allows you to "destroy" an object without deleting the record or associated records.
  * [Espinita](https://github.com/continuum/espinita) - Audit activerecord models like a boss.
  * [marginalia](https://github.com/basecamp/marginalia) - Attach comments to your ActiveRecord queries. By default, it adds the application, controller, and action names as a comment at the end of each query.
  * [mongoid-history](https://github.com/aq1018/mongoid-history) - Multi-user non-linear history tracking, auditing, undo, redo for mongoid.
  * [PaperTrail](https://github.com/airblade/paper_trail) - Track changes to your ActiveRecord models' data for auditing or versioning.
  * [Paranoia](https://github.com/radar/paranoia) - A re-implementation of acts_as_paranoid for Rails 3 and 4, using much, much, much less code.
  * [PermenantRecords](https://github.com/JackDanger/permanent_records) - Soft-delete your ActiveRecord records, like an explicit version of ActsAsParanoid.
* Import
  * [ActiveImporter](https://github.com/continuum/active_importer) - Define importers that load tabular data from spreadsheets or CSV files into any ActiveRecord-like ORM.
  * [ActiveRecord Import](https://github.com/zdennis/activerecord-import) - a library for bulk inserting data using ActiveRecord.
  * [bulk_insert](https://github.com/jamis/bulk_insert) - A little ActiveRecord extension for helping to insert lots of rows in a single insert statement.
  * [data_miner](https://github.com/seamusabshere/data_miner) - Download, pull out of a ZIP/TAR/GZ/BZ2 archive, parse, correct, and import XLS, ODS, XML, CSV, HTML, etc. into your ActiveRecord models.
  * [ferry](https://github.com/cmu-is-projects/ferry) - A ruby gem for easy data transfer.
* Misc
  * [ActiveRecord::Turntable](https://github.com/drecom/activerecord-turntable) - A database sharding extension for ActiveRecord.
  * [ActiveValidators](https://github.com/franckverrot/activevalidators) - An exhaustive collection of off-the-shelf and tested ActiveModel/ActiveRecord validations.
  * [Enumerize](https://github.com/brainspec/enumerize) - Enumerated attributes with I18n and ActiveRecord/Mongoid/MongoMapper support.
  * [Goldiloader](https://github.com/salsify/goldiloader) - Automatic ActiveRecord eager loading.
  * [mini_record](https://github.com/DAddYE/mini_record) - ActiveRecord meets DataMapper, with MiniRecord you are be able to write schema inside your models.
* Multi-tenancy
  * [Acts As Tennant](https://github.com/ErwinM/acts_as_tenant) - Add multi-tenancy to a Rails app through a shared database strategy.
  * [Apartment](https://github.com/influitive/apartment) - Multi-tenancy for Rails and ActiveRecord.
  * [Milia](https://github.com/jekuno/milia) - Non-invasive multi-tenancy for Rails which supports Devise authentication out of the box.
* Social
  * [Acts As Commentable](https://github.com/jackdempsey/acts_as_commentable) - Provides a single Comment model that can be attached to any model(s) within your app.
  * [Acts As Commentable with Threading](https://github.com/elight/acts_as_commentable_with_threading) - Similar to acts_as_commentable; however, utilizes awesome_nested_set to provide threaded comments.
  * [acts_as_follower](https://github.com/tcocca/acts_as_follower) - Allow any ActiveRecord model to follow any other model.
  * [ActiveRecord Reputation System](https://github.com/twitter/activerecord-reputation-system) - An Active Record Reputation System for Rails.
  * [ActsAsTaggableOn](https://github.com/mbleigh/acts-as-taggable-on) - A tagging plugin for ActiveRecord that allows for custom tagging along dynamic contexts.
  * [Acts As Votable](https://github.com/ryanto/acts_as_votable) - Allow any ActiveRecord model to be voted on, like/dislike, upvote/downvote, etc.
  * [Merit](https://github.com/merit-gem/merit) - Adds reputation behavior to Rails apps in the form of Badges, Points, and Rankings for ActiveRecord or Mongoid.
  * [PublicActivity](https://github.com/chaps-io/public_activity) - Provides easy activity tracking for your ActiveRecord, Mongoid 3 and MongoMapper models in Rails 3 and 4. Similar to Github's Public Activity.
  * [Simple Feed](https://github.com/kigster/simple-feed) - Fast and highly scalable read-optimized social activity feed library in pure Ruby, backed by Redis.
  * [Unread](https://github.com/ledermann/unread) - Manage read/unread status of ActiveRecord objects - and it's fast.
* Sorting
  * [ActsAsList](https://github.com/swanandp/acts_as_list) - Provides the capabilities for sorting and reordering a number of objects in a list.
  * [ranked-model](https://github.com/mixonic/ranked-model) - A modern row sorting library for ActiveRecord. It uses ARel aggressively and is better optimized than most other libraries.
* Tree
  * [ActsAsTree](https://github.com/amerine/acts_as_tree) - Extends ActiveRecord to add simple support for organizing items into parent–children relationships.
  * [Ancestry](https://github.com/stefankroes/ancestry) - Organise ActiveRecord model into a tree structure using a variation on the materialised path pattern.
  * [Awesome Nested Set](https://github.com/collectiveidea/awesome_nested_set) - Awesome Nested Set is an implementation of the nested set pattern for ActiveRecord models.
  * [Closure Tree](https://github.com/mceachen/closure_tree) - Easily and efficiently make your ActiveRecord models support hierarchies using a Closure Table.
  * [Mongoid Tree](https://github.com/benedikt/mongoid-tree) - A tree structure for Mongoid documents using the materialized path pattern.

## Package Management

* Gems
  * [Bundler](http://bundler.io) - Manage your application's gem dependencies with less pain.
  * [RubyGems](https://rubygems.org) - Community's gem hosting service.
* Packages and Applications
  * [Berkshelf](https://github.com/berkshelf/berkshelf) - A Chef Cookbook manager.
  * [CocoaPods](https://github.com/CocoaPods/CocoaPods) - The Objective-C dependency manager.
  * [Foreman](https://github.com/ddollar/foreman) - Manage Procfile-based applications.
  * [fpm](https://github.com/jordansissel/fpm) - Effing package management! Build packages for multiple platforms (deb, rpm, etc) with great ease and sanity.
  * [Linuxbrew](https://github.com/Homebrew/linuxbrew) - A fork of Homebrew for Linux.
  * [Homebrew-cask](https://github.com/caskroom/homebrew-cask) - A CLI workflow for the administration of Mac applications distributed as binaries.
  * [Homebrew](https://github.com/Homebrew/brew) - The missing package manager for OS X.
  * [Traveling Ruby](http://phusion.github.io/traveling-ruby/) - Traveling Ruby lets you create self-contained Ruby app packages for Linux and OS X.

## Pagination

* [Kaminari](https://github.com/amatsuda/kaminari) - A Scope & Engine based, clean, powerful, customizable and sophisticated paginator for modern web app frameworks and ORMs.
* [order_query](https://github.com/glebm/order_query) - A keyset pagination library to find the next or previous record(s) relative to the current one efficiently, e.g. for infinite scroll.
* [will_paginate](https://github.com/mislav/will_paginate) - A pagination library that integrates with Ruby on Rails, Sinatra, Merb, DataMapper and Sequel.

## PDF

* [CombinePDF](https://github.com/boazsegev/combine_pdf) - A Pure ruby library to merge or stump PDF files, number pages and more.
* [Gimli](https://github.com/walle/gimli) - Utility for converting markup files to pdf files.
* [HexaPDF](https://github.com/gettalong/hexapdf) - A Versatile PDF Creation and Manipulation Library For Ruby.
* [Kitabu](https://github.com/fnando/kitabu) - A framework for creating e-books from Markdown/Textile text markup using Ruby.
* [Pdfkit](https://github.com/pdfkit/pdfkit) - HTML+CSS to PDF using wkhtmltopdf.
* [Prawn](https://github.com/prawnpdf/prawn) - Fast, Nimble PDF Writer for Ruby.
* [RGhost](https://github.com/shairontoledo/rghost) - RGhost is a document creation and conversion API.
* [Shrimp](https://github.com/adjust/shrimp) - A phantomjs based pdf renderer.
* [Squid](https://github.com/fullscreen/squid) - Squid · A Ruby library to plot charts in PDF files
* [Wicked Pdf](https://github.com/mileszs/wicked_pdf) - PDF generator (from HTML) plugin for Ruby on Rails.
* [Wisepdf](https://github.com/igor-alexandrov/wisepdf) - Wkhtmltopdf wrapper done right.

## Performance Monitoring

* [Instrumental](https://github.com/expectedbehavior/instrumental_agent) - Measure your application in real time with [Instrumental](http://instrumentalapp.com).
* [New Relic](https://github.com/newrelic/rpm) - Find and fix Ruby errors with New Relic application monitoring and troubleshooting.
* [Skylight](https://github.com/skylightio/skylight-ruby) - A smart profiler for your Rails apps that visualizes request performance.
* [TraceView](https://github.com/appneta/ruby-traceview) -  Full-stack application tracing and brilliant data visualization to build faster, more reliable web apps.

## Presentation Programs

* [Slide Show (S9)](https://github.com/slideshow-s9/slideshow) - Write your slides / talks / presentations in plain text with markdown formatting conventions and generate (static) web pages; template packs incl. deck.js, impress.js, reveal.js, shower, s6, s5 and more.

## Process Monitoring

* [Bluepill](https://github.com/bluepill-rb/bluepill) - Simple process monitoring tool.
* [Eye](https://github.com/kostya/eye) - Process monitoring tool. Inspired from Bluepill and God.
* [God](https://github.com/mojombo/god) - An easy to configure, easy to extend monitoring framework written in Ruby.

## Processes

* [childprocess](https://github.com/jarib/childprocess) - Cross-platform ruby library for managing child processes.
* [posix-spawn](https://github.com/rtomayko/posix-spawn) - Fast Process::spawn for Rubys >= 1.8.7 based on the posix_spawn() system interfaces.

## Profiler and Optimization

* [batch-loader](https://github.com/exaspark/batch-loader) – A generic lazy batching mechanism to avoid N+1 DB queries, HTTP queries, etc.
* [benchmark-ips](https://github.com/evanphx/benchmark-ips) - Provides iteration per second benchmarking for Ruby.
* [bullet](https://github.com/flyerhzm/bullet) - Help to kill N+1 queries and unused eager loading.
* [Derailed Benchmarks](https://github.com/schneems/derailed_benchmarks) - A series of things you can use to benchmark any Rack based app.
* [Peek](https://github.com/peek/peek) - Visual status bar showing Rails performance.
* [perftools.rb](https://github.com/tmm1/perftools.rb) - gperftools (formerly known as google-perftools) for Ruby code.
* [rack-mini-profiler](https://github.com/MiniProfiler/rack-mini-profiler) - Profiler for your development and production Ruby rack apps.
* [Rbkit](https://github.com/code-mancers/rbkit) - profiler for Ruby. With a GUI.
* [ruby-prof](https://github.com/ruby-prof/ruby-prof) - A code profiler for MRI rubies.

## QR

* [QR-code](https://github.com/whomwah/rqrcode) - A Ruby library that encodes QR Codes.

## Queues and Messaging

* [Backburner](https://github.com/nesquena/backburner) - Backburner is a beanstalkd-powered job queue that can handle a very high volume of jobs.
* [Bunny](https://github.com/ruby-amqp/bunny) - Bunny is a popular, easy to use, well-maintained Ruby client for RabbitMQ (3.3+).
* [Delayed::Job](https://github.com/collectiveidea/delayed_job) - Database backed asynchronous priority queue.
* [Gush](https://github.com/chaps-io/gush) - A parallel runner for complex workflows using only Redis and Sidekiq.
* [Karafka](https://github.com/karafka/karafka) - Framework used to simplify Apache Kafka (a distributed streaming platform) based Ruby applications development.
* [March Hare](https://github.com/ruby-amqp/march_hare) - Idiomatic, fast and well-maintained JRuby client for RabbitMQ.
* [Resque](https://github.com/resque/resque) - A Redis-backed Ruby library for creating background jobs.
* [Que](https://github.com/chanks/que) - A Ruby job queue that uses PostgreSQL's advisory locks for speed and reliability.
* [RocketJob](http://rocketjob.io) - Enterprise Batch Processing System focused on performance, scalability, reliability, and visibility of every job in the system. Outgrown existing solutions? Or, start small and scale up later.
* [Shoryuken](https://github.com/phstc/shoryuken) - A super efficient AWS SQS thread based message processor for Ruby.
* [Sidekiq](http://sidekiq.org) - A full-featured background processing framework for Ruby. It aims to be simple to integrate with any modern Rails application and much higher performance than other existing solutions.
* [Sneakers](https://github.com/jondot/sneakers) - A fast background processing framework for Ruby and RabbitMQ.
* [Sucker Punch](https://github.com/brandonhilkert/sucker_punch) - A single process background processing library using Celluloid. Aimed to be Sidekiq's little brother.

## Rails Application Generators

* [Bootstrappers](https://github.com/xdite/bootstrappers) - Bootstrappers generates a base Rails app using Bootstrap template and other goodies.
* [Hobo](https://github.com/Hobo/hobo) - The web app builder for Rails.
* [orats](https://github.com/nickjj/orats) - Opinionated rails application templates.
* [Rails Composer](https://github.com/RailsApps/rails-composer) - The Rails generator on steroids for starter apps.
* [Raygun](https://github.com/carbonfive/raygun) - Builds applications with the common customization stuff already done.
* [Suspenders](https://github.com/thoughtbot/suspenders) - Suspenders is the base Rails application used at thoughtbot.

## Robotics

* [Artoo](http://artoo.io) - Next generation robotics framework with support for different platforms: Arduino, Leap Motion, Pebble, Raspberry Pi, etc.

## RSS

* [Feed normalizer](https://github.com/aasmith/feed-normalizer) - Extensible Ruby wrapper for Atom and RSS parsers.
* [Feedjira](https://github.com/feedjira/feedjira) - A feed fetching and parsing library.
* [feedparser](https://github.com/feedparser/feedparser) - A feed parser and normalizer (Atom, RSS, JSON, etc) library.
* [Ratom](https://github.com/seangeo/ratom) - A fast, libxml based, Ruby Atom library.
* [Simple rss](https://github.com/cardmagic/simple-rss) - A simple, flexible, extensible, and liberal RSS and Atom reader.
* [Stringer](https://github.com/swanson/stringer) - A self-hosted, anti-social RSS reader.

## Scheduling

* [minicron](https://github.com/jamesrwhite/minicron) - A system to manage and monitor cron jobs.
* [resque-scheduler](https://github.com/resque/resque-scheduler) - A light-weight job scheduling system built on top of Resque.
* [rufus-scheduler](https://github.com/jmettraux/rufus-scheduler) - Job scheduler for Ruby (at, cron, in and every jobs).
* [Whenever](https://github.com/javan/whenever) - A Ruby gem that provides a clear syntax for writing and deploying cron jobs.

## Scientific

* Artificial intelligence
  * [AI4R](https://github.com/sergiofierens/ai4r) - Algorithms covering several Artificial intelligence fields.
  * [ruby-fann](https://github.com/tangledpath/ruby-fann) - Ruby library for interfacing with FANN (Fast Artificial Neural Network).
* Bindings
  * [ruby-opencv](https://github.com/ruby-opencv/ruby-opencv) - An OpenCV wrapper for Ruby.
* Classifiers
  * [classifier-reborn](https://github.com/jekyll/classifier-reborn) - An active fork of Classifier, and general module to allow Bayesian and other types of classifications.
  * [stuff-classifier](https://github.com/alexandru/stuff-classifier) - A library for classifying text into multiple categories.
* Data analysis/structures
  * [daru](https://github.com/v0dro/daru) - A library for storage, analysis, manipulation and visualization of data in pure Ruby.
  * [Rgl](https://github.com/monora/rgl) - A framework for graph data structures and algorithms.
* Numerical arrays
  * [NMatrix](https://github.com/sciruby/nmatrix) - Fast numerical linear algebra library for Ruby.
  * [NArray](https://github.com/masa16/narray) - N-dimensional Numerical Array for Ruby.
  * [mdarray](https://github.com/rbotafogo/mdarray) - Multi dimensional array implemented for JRuby inspired by NumPy.
* [SciRuby](https://github.com/sciruby/sciruby) - Tools for scientific computation in Ruby/Rails.
  * [statsample](https://github.com/sciruby/statsample) - A suite for basic and advanced statistics on Ruby.
  * [statsample-timeseries](https://github.com/sciruby/statsample-timeseries) - Bioruby Statsample TimeSeries.
  * [statsample-glm](https://github.com/sciruby/statsample-glm) - Generalized Linear Models extension for Statsample.
  * [distribution](https://github.com/sciruby/distribution) - Statistical Distributions multi library wrapper.
  * [integration](https://github.com/sciruby/integration) - Numerical integration methods, based on original work by Beng.
  * [minimization](https://github.com/sciruby/minimization) - Minimization algorithms on pure Ruby.
  * [publisci](https://github.com/sciruby/publisci) - A toolkit for publishing scientific results to the semantic web.
  * [plotrb](https://github.com/sciruby/plotrb) - A plotting library in Ruby built on top of Vega and D3.
  * [rb-gsl](https://github.com/SciRuby/rb-gsl) - A ruby interface to GNU Scientific library, with NMatrix support.
* Specific
  * [BioRuby](https://github.com/bioruby/bioruby) - Library for developing bioinformatics software.
  * [bloomfilter-rb](https://github.com/igrigorik/bloomfilter-rb) - BloomFilter(s) in Ruby: Native counting filter + Redis counting/non-counting filters.
  * [decisiontree](https://github.com/igrigorik/decisiontree) - A ruby library which implements ID3 (information gain) algorithm for decision tree learning.
* Utilities
  * [smarter_csv](https://github.com/tilo/smarter_csv) - Ruby Gem for smarter importing of CSV Files as Array(s) of Hashes.
  * [algorithms](https://github.com/kanwei/algorithms) - Library with documentation on when to use a particular structure/algorithm.
  * [jaro_winkler](https://github.com/tonytonyjan/jaro_winkler) - Ruby & C implementation of Jaro-Winkler distance algorithm which supports UTF-8 string.

## Search

* [chewy](https://github.com/toptal/chewy) - High-level Elasticsearch Ruby framework based on the official elasticsearch-ruby client.
* [elasticsearch-ruby](https://github.com/elastic/elasticsearch-ruby) - Ruby integrations for Elasticsearch.
* [elastics](https://github.com/printercu/elastics-rb) - Simple ElasticSearch client with support for migrations and ActiveRecord integration.
* [has_scope](https://github.com/plataformatec/has_scope) - Has scope allows you to easily create controller filters based on your resources named scopes.
* [Mongoid Search](https://github.com/mauriciozaffari/mongoid_search) - Simple full text search implementation for Mongoid.
* [pg_search](https://github.com/Casecommons/pg_search) - Builds ActiveRecord named scopes that take advantage of PostgreSQL's full text search.
* [ransack](https://github.com/activerecord-hackery/ransack/) - Object-based searching.
* [Rroonga](https://github.com/ranguba/rroonga) - The Ruby bindings of Groonga.
* [scoped_search](https://github.com/wvanbergen/scoped_search) - Adds a scope supporting search queries and autocompletion against existing fields on ActiveRecord models and associations.
* [SearchCop](https://github.com/mrkamel/search_cop) - Extends your ActiveRecord models to support fulltext search engine like queries via simple query strings and hash-based queries.
* [Searchkick](https://github.com/ankane/searchkick) - Searchkick learns what your users are looking for. As more people search, it gets smarter and the results get better. It’s friendly for developers - and magical for your users.
* [Searchlogic](https://github.com/binarylogic/searchlogic) - Object based searching, common named scopes, and other useful named scope tools for ActiveRecord.
* [Sunspot](https://github.com/sunspot/sunspot) - A Ruby library for expressive, powerful interaction with the Solr search engine.
* [textacular](https://github.com/textacular/textacular) - Exposes full text search capabilities from PostgreSQL, and allows you to declare full text indexes. Textacular extends ActiveRecord with named_scope methods making searching easy and fun!
* [Thinking Sphinx](https://github.com/pat/thinking-sphinx) - A library for connecting ActiveRecord to the Sphinx full-text search tool.

## Security

* [BeEF](http://beefproject.com) - BeEF is short for The Browser Exploitation Framework. It is a penetration testing tool that focuses on the web browser.
* [bundler-audit](https://github.com/rubysec/bundler-audit) - Patch-level security verification for Bundler.
* [Gitrob](https://github.com/michenriksen/gitrob) - Reconnaissance tool for GitHub organizations.
* [Metasploit](https://github.com/rapid7/metasploit-framework) - World's most used penetration testing software.
* [Rack::Attack](https://github.com/kickstarter/rack-attack) - Rack middleware for blocking & throttling abusive requests.
* [Rack::Protection](https://github.com/sinatra/rack-protection) - Rack middleware for protecting against typical Web attacks.
* [SecureHeaders](https://github.com/twitter/secureheaders) - Automatically apply several headers that are related to security, including: Content Security Policy (CSP), HTTP Strict Transport Security (HSTS), X-Frame-Options (XFO), X-XSS-Protection, X-Content-Type-Options, X-Download-Options & X-Permitted-Cross-Domain-Policies.

## SEO

* [FriendlyId](https://github.com/norman/friendly_id) - The "Swiss Army bulldozer" of slugging and permalink plugins for Active Record.
* [MetaTags](https://github.com/kpumuk/meta-tags) - A gem to make your Rails application SEO-friendly.
* [prerender_rails](https://github.com/prerender/prerender_rails) - Rails middleware gem for prerendering javascript-rendered pages on the fly for SEO.
* [SitemapGenerator](https://github.com/kjvarga/sitemap_generator) - A framework-agnostic XML Sitemap generator written in Ruby.

## Social Networking

* [diaspora*](https://github.com/diaspora/diaspora) - A privacy aware, distributed, open source social network.
* [Discourse](https://github.com/discourse/discourse) - A platform for community discussion. Free, open, simple.
* [Mailboxer](https://github.com/mailboxer/mailboxer) - A private message system for Rails applications.
* [Mastodon](https://github.com/Gargron/mastodon) - A GNU Social-compatible microblogging server
* [Social Shares](https://github.com/Timrael/social_shares) - A gem to check how many times url was shared in social networks.
* [Thredded](https://thredded.org) - Rails 4.2+ forums/messageboards engine. Its goal is to be as simple and feature rich as possible.

## Spreadsheets and Documents

* [AXLSX](https://github.com/randym/axlsx) - An excel xlsx generation library.
* [Docsplit](http://documentcloud.github.io/docsplit) - Gem to convert Microsoft Word (and other) documents into images, pdf, pages or text.
* [Roo](https://github.com/roo-rb/roo) - Implements read access for all spreadsheet types and read/write access for Google spreadsheets.
* [Spreadsheet Architect](https://github.com/westonganger/spreadsheet_architect) - Turn any activerecord relation or ruby object collection into a XLSX, ODS, or CSV spreadsheet.
* [Yomu](https://github.com/Erol/yomu) - Read text and metadata from files and documents (.doc, .docx, .pages, .odt, .rtf, .pdf).

## State Machines

* [AASM](https://github.com/aasm/aasm) - State machines for Ruby classes (plain Ruby, Rails Active Record, Mongoid).
* [FiniteMachine](https://github.com/peter-murach/finite_machine) - A plain Ruby state machine with a straightforward and expressive syntax.
* [MicroMachine](https://github.com/soveran/micromachine) - A minimal finite state machine implementation in less than 50 lines of code.
* [simple_states](https://github.com/svenfuchs/simple_states) - A super-slim statemachine-like support library.
* [Statesman](https://github.com/gocardless/statesman) - A statesmanlike state machine library.
* [state_machines](https://github.com/state-machines/state_machines) - Adds support for creating state machines for attributes on any Ruby class.
* [transitions](https://github.com/troessner/transitions) - A ruby state machine implementation.
* [Workflow](https://github.com/geekq/workflow) - A finite-state-machine-inspired API for modeling and interacting with what we tend to refer to as 'workflow'.

## Static Site Generation

* [High Voltage](https://github.com/thoughtbot/high_voltage) - Easily include static pages in your Rails app.
* [Jekyll](http://jekyllrb.com) - Transform your plain text into static websites and blogs.
  * [Awesome Jekyll](https://github.com/planetjekyll/awesome-jekyll) - A collection of awesome Jekyll tools, plugins, themes, guides and much more.
* [Middleman](http://middlemanapp.com) - A static site generator using all the shortcuts and tools in modern web development.
* [Nanoc](http://nanoc.ws/) - A static site generator, fit for building anything from a small personal blog to a large corporate web site.
* [Octopress](https://github.com/octopress/octopress) - Octopress is an obsessively designed toolkit for writing and deploying Jekyll blogs.
* [Photish](https://github.com/henrylawson/photish) - Generate a highly configurable static website from a photo collection.
* [webgen](http://webgen.gettalong.org) - webgen is a fast, powerful and extensible static website generator.

## Template Engine

* [Curly](https://github.com/zendesk/curly) - A template language that completely separates structure and logic.
* [Haml](https://github.com/haml/haml) - HTML Abstraction Markup Language.
* [Liquid](https://github.com/Shopify/liquid) - Safe, customer facing template language for flexible web apps.
* [Mustache](https://github.com/mustache/mustache) - Logic-less Ruby templates.
* [Slim](https://github.com/slim-template/slim) - A template language whose goal is reduce the syntax to the essential parts without becoming cryptic.
* [Tilt](https://github.com/rtomayko/tilt) - Generic interface to multiple Ruby template engines.

## Testing

* Frameworks
  * [RSpec](https://github.com/rspec/rspec) - Behaviour Driven Development for Ruby.
    * Formatters
      * [Emoji-RSpec](https://github.com/cupakromer/emoji-rspec) - Custom Emoji Formatters for RSpec.
      * [Fuubar](https://github.com/thekompanee/fuubar) - The instafailing RSpec progress bar formatter.
      * [Nyan Cat](https://github.com/mattsears/nyan-cat-formatter) - Nyan Cat inspired RSpec formatter!
  * [Aruba](https://github.com/cucumber/aruba) - Testing command line applications with cucumber and rspec.
  * [Bacon](https://github.com/chneukirchen/bacon) - A small RSpec clone.
  * [Capybara](https://github.com/teamcapybara/capybara) - Acceptance test framework for web applications.
  * [Cucumber](https://github.com/cucumber/cucumber) - BDD that talks to domain experts first and code second.
  * [Cutest](https://github.com/djanowski/cutest) - Isolated tests in Ruby.
  * [Howitzer](https://github.com/strongqa/howitzer) - Ruby based framework for acceptance testing
  * [Konacha](https://github.com/jfirebaugh/konacha) - Test your Rails application's JavaScript with the mocha test framework and chai assertion library.
  * [minitest](https://github.com/seattlerb/minitest) - minitest provides a complete suite of testing facilities supporting TDD, BDD, mocking, and benchmarking.
  * [RR](https://github.com/rr/rr) - A test double framework that features a rich selection of double techniques and a terse syntax.
  * [shoulda-matchers](https://github.com/thoughtbot/shoulda-matchers) - Provides Test::Unit- and RSpec-compatible one-liners that test common Rails functionality. These tests would otherwise be much longer, more complex, and error-prone.
  * [Spinach](https://github.com/codegram/spinach) - Spinach is a high-level BDD framework that leverages the expressive Gherkin language (used by Cucumber) to help you define executable specifications of your application or library's acceptance criteria.
  * [Spork](https://github.com/sporkrb/spork) - A DRb server for testing frameworks (RSpec / Cucumber currently).
  * [Test::Unit](http://test-unit.github.io) - Test::Unit is a xUnit family unit testing framework for Ruby.
* Fake Data
  * [Fabrication](http://fabricationgem.org/) - A simple and powerful object generation library.
  * [factory_bot](https://github.com/thoughtbot/factory_bot) - A library for setting up Ruby objects as test data.
  * [Fake Person](https://github.com/adamcooke/fake-person) - Uses some of the most popular given & surnames in the US & UK.
  * [faker](https://github.com/stympy/faker) - A library for generating fake data such as names, addresses, and phone numbers.
  * [ffaker](https://github.com/ffaker/ffaker) - A faster Faker, generates dummy data, rewrite of faker.
  * [Forgery](https://github.com/sevenwire/forgery) - Easy and customizable generation of forged data.
  * [Machinist](https://github.com/notahat/machinist) - Fixtures aren't fun. Machinist is.
* Mock
  * [ActiveMocker](https://github.com/zeisler/active_mocker) - Generate mocks from ActiveRecord models for unit tests that run fast because they don’t need to load Rails or a database.
  * [DuckRails](https://github.com/iridakos/duckrails) - Tool for mocking API endpoints quickly & dynamically.
  * [TestXml](https://github.com/alovak/test_xml) - TestXml is a small extension for testing XML/HTML.
  * [WebMock](https://github.com/bblimke/webmock) - Library for stubbing and setting expectations on HTTP requests.
* WebDrivers
  * [Selenium WebDriver](https://github.com/SeleniumHQ/selenium/tree/master/rb) - Ruby bindings for WebDriver.
  * [API Taster](https://github.com/fredwu/api_taster) - A quick and easy way to visually test your Rails application's API.
  * [Poltergeist](https://github.com/teampoltergeist/poltergeist) - A PhantomJS driver for Capybara.
  * [Watir](https://github.com/watir/watir/) - Web application testing in Ruby.
* Extra
  * [Appraisal](https://github.com/thoughtbot/appraisal) - Appraisal integrates with bundler and rake to test your library against different versions of dependencies.
  * [Knapsack](https://github.com/ArturT/knapsack) - Optimal test suite parallelisation across CI nodes for RSpec, Cucumber, Minitest, Spinach and Turnip.
  * [mutant](https://github.com/mbj/mutant) - Mutant is a mutation testing tool for Ruby.
  * [Parallel Tests](https://github.com/grosser/parallel_tests) - Speedup Test::Unit + RSpec + Cucumber by running parallel on multiple CPUs (or cores).
  * [power_assert](https://github.com/k-tsj/power_assert) - Power Assert for Ruby.
  * [Ruby-JMeter](https://github.com/flood-io/ruby-jmeter) - A Ruby based DSL for building JMeter test plans.
  * [Spring](https://github.com/rails/spring) - Preloads your rails environment in the background for faster testing and Rake tasks.
  * [timecop](https://github.com/travisjeffery/timecop) - Provides "time travel" and "time freezing" capabilities, making it dead simple to test time-dependent code.
  * [vcr](https://github.com/vcr/vcr) - Record your test suite's HTTP interactions and replay them during future test runs for fast, deterministic, accurate tests.
  * [Zapata](https://github.com/Nedomas/zapata) - Who has time to write tests? This is a revolutionary tool to make them write themselves.

## Third-party APIs

* [Dropbox](https://github.com/futuresimple/dropbox-api) - Dropbox API Ruby Client.
* [facy](https://github.com/huydx/facy) - Command line power tool for facebook.
* [fb_graph2](https://github.com/nov/fb_graph2) - A full-stack Facebook Graph API wrapper.
* [flickr](https://github.com/RaVbaker/flickr) - A Ruby interface to the Flickr API.
* [gitlab](https://github.com/NARKOZ/gitlab) - Ruby wrapper and CLI for the GitLab API.
* [google-api-ads-ruby](https://github.com/googleads/google-api-ads-ruby) - Google Adwords Ruby client
* [gmail](https://github.com/gmailgem/gmail) - A Rubyesque interface to Gmail, with all the tools you'll need.
* [hipchat-rb](https://github.com/hipchat/hipchat-rb) - HipChat HTTP API Wrapper in Ruby with Capistrano hooks.
* [instagram-ruby-gem](https://github.com/Instagram/instagram-ruby-gem) - The official gem for the Instagram REST and Search APIs.
* [itunes_store_transporter](https://github.com/sshaw/itunes_store_transporter) - Ruby wrapper around Apple's iTMSTransporter program.
* [linkedin](https://github.com/hexgnu/linkedin) - Provides an easy-to-use wrapper for LinkedIn's REST APIs.
* [Octokit](http://octokit.github.io/octokit.rb) - Ruby toolkit for the GitHub API.
* [Pusher](https://github.com/pusher/pusher-http-ruby) - Ruby server library for the Pusher API.
* [Restforce](https://github.com/ejholmes/restforce) - A Ruby client for the Salesforce REST api.
* [ruby-gmail](https://github.com/dcparker/ruby-gmail) - A Rubyesque interface to Gmail.
* [ruby-trello](https://github.com/jeremytregunna/ruby-trello) - Implementation of the Trello API for Ruby.
* [simple-slack-bot](https://github.com/kciter/simple-slack-bot) - You can easily make Slack Bot.
* [Slack Notifier](https://github.com/stevenosloan/slack-notifier) - A simple wrapper for posting to Slack channels.
* [Slack ruby gem](https://github.com/aki017/slack-ruby-gem) - A Ruby wrapper for the Slack API.
* [soundcloud-ruby](https://github.com/soundcloud/soundcloud-ruby) - Official SoundCloud API Wrapper for Ruby.
* [t](https://github.com/sferik/t) - A command-line power tool for Twitter.
* [terjira](https://github.com/keepcosmos/terjira) - A command-line power tool for Jira.
* [tweetstream](https://github.com/tweetstream/tweetstream) - A simple library for consuming Twitter's Streaming API.
* [twilio-ruby](https://github.com/twilio/twilio-ruby) - A module for using the Twilio REST API and generating valid TwiML.
* [twitter](https://github.com/sferik/twitter) - A Ruby interface to the Twitter API.
* [wikipedia](https://github.com/kenpratt/wikipedia-client) - Ruby client for the Wikipedia API.
* [Yt](https://github.com/Fullscreen/yt) - An object-oriented Ruby client for YouTube API V3.

## Video

* [Streamio FFMPEG](https://github.com/streamio/streamio-ffmpeg) - Simple yet powerful wrapper around the ffmpeg command for reading metadata and transcoding movies.
* [Video Transcoding](https://github.com/donmelton/video_transcoding) - Tools to transcode, inspect and convert videos.

## View helpers

* [auto_html](https://github.com/dejan/auto_html) - Rails extension for transforming URLs to appropriate resource (image, link, YouTube, Vimeo video...).
* [Bh](https://github.com/fullscreen/bh) - Bootstrap Helpers for Ruby.
* [gon](https://github.com/gazay/gon) - If you need to send some data to your js files and you don't want to do this with long way through views and parsing - use gon.
* [PluggableJs](https://github.com/peresleguine/pluggable_js) - Page-specific javascript for Rails applications with the ability of passing data from a controller.

## Web Crawling

* [anemone](https://github.com/chriskite/anemone) - Ruby library and CLI for crawling websites.
* [LinkThumbnailer](https://github.com/gottfrois/link_thumbnailer) - Ruby gem that generates thumbnail images and videos from a given URL. Much like popular social website with link preview.
* [Mechanize](https://github.com/sparklemotion/mechanize) - Mechanize is a ruby library that makes automated web interaction easy.
* [MetaInspector](https://github.com/jaimeiniesta/metainspector) - Ruby gem for web scraping purposes.
* [Upton](https://github.com/propublica/upton) - A batteries-included framework for easy web-scraping.
* [Wombat](https://github.com/felipecsl/wombat) - Web scraper with an elegant DSL that parses structured data from web pages.

## Web Frameworks

* [Camping](https://github.com/camping/camping) - A web microframework which consistently stays at less than 4kB of code.
* [Cuba](http://cuba.is) - A microframework for web development.
* [Hobbit](https://github.com/patriciomacadden/hobbit) - A minimalistic microframework built on top of Rack.
* [Hanami](http://hanamirb.org) - It aims to bring back Object Oriented Programming to web development, leveraging on a stable API, a minimal DSL, and plain objects.
* [Hyperloop](http://ruby-hyperloop.org/) - A Complete Isomorphic Ruby Framework using React, Rails and Opal
* [Padrino](http://www.padrinorb.com) - A full-stack ruby framework built upon Sinatra.
* [Pakyow](https://www.pakyow.org/) - A framework for building modern web-apps in Ruby. It helps you build working software faster with a development process that remains friendly to both designers and developers.
* [Rack::App](https://github.com/rack-app/rack-app) - Bare bone minimalistic framework for building rack apps.
* [Ramaze](http://ramaze.net/) - A simple, light and modular open-source web application framework written in Ruby.
* [Roda](http://roda.jeremyevans.net/) - A routing tree web framework.
* [Ruby on Rails](http://rubyonrails.org) - A web-application framework that includes everything needed to create database-backed web applications according to the Model-View-Controller (MVC) pattern.
* [Scorched](http://scorchedrb.com) - Light-weight, inheritable and composable web framework, inspired by Sinatra.
* [Sinatra](http://www.sinatrarb.com) - Classy web-development dressed in a DSL.
* [Syro](https://github.com/soveran/syro/) - Simple router for web applications.
* [Volt](https://github.com/voltrb/volt) - A Ruby web framework where your ruby code runs on both the server and the client.

## Web Servers

* [Goliath](https://github.com/postrank-labs/goliath) - A non-blocking Ruby web server framework.
* [Iodine](https://github.com/boazsegev/iodine) - An non-blocking HTTP and Websocket web server optimized for Linux/BDS/macOS and Ruby MRI.
* [Phusion Passenger](https://www.phusionpassenger.com) - Fast and robust web server and application server.
* [Puma](https://github.com/puma/puma) - A modern, concurrent web server for Ruby.
* [Rack](http://rack.github.io) - A common Ruby web server interface. By itself, it's just a specification and utility library, but all Ruby web servers implement this interface.
* [Reel](https://github.com/celluloid/reel) - Celluloid::IO-powered web server.
* [Thin](http://code.macournoyer.com/thin) - Tiny, fast & funny HTTP server.
* [TorqueBox](https://github.com/torquebox/torquebox) - A Ruby application server built on JBoss AS7 and JRuby.
* [Unicorn](http://unicorn.bogomips.org) - Rack HTTP server for fast clients and Unix.

## WebSocket

* [AnyCable](http://anycable.io) – Polyglot replacement for Ruby WebSocket servers with Action Cable protocol.
* [Faye](http://faye.jcoglan.com/ruby.html) - A set of tools for simple publish-subscribe messaging between web clients.
* [Firehose](https://github.com/firehoseio/firehose) - Build realtime Ruby web applications.
* [Slanger](https://github.com/stevegraham/slanger) - Open Pusher implementation compatible with Pusher libraries.
* [RenderSync](https://github.com/chrismccord/render_sync) - Real-time Rails Partials.
* [Websocket-Rails](https://github.com/websocket-rails/websocket-rails) - Creates a built in WebSocket server inside a Rails application with ease, and also support streaming HTTP.

# Services and Apps

Online tools, services and APIs to simplify development.

* [AppSignal](https://appsignal.com) - Better monitoring for your Rails applications.
* [Codacy](https://www.codacy.com) - Automated Code Review for Ruby, Rails, JS, PHP, Python etc. Security, Coverage & Quality.
* [CodeClimate](https://codeclimate.com) - Quality & security analysis for Ruby on Rails and Javascript.
* [deppbot](https://www.deppbot.com) - Automated Security and Dependency Updates.
* [Gemnasium](https://gemnasium.com) - Monitor your project dependencies and alert you about updates and security vulnerabilities.
* [GitHub](https://github.com) - Powerful collaboration, code review, and code management for open source and private projects.
* [Gitlab CI](https://about.gitlab.com/gitlab-ci/) - Integrate with your GitLab to run tests for your projects.
* [GitLab](https://about.gitlab.com) -  Open source software to collaborate on code.
* [Hakiri](https://hakiri.io) - Ship Secure Ruby Apps.
* [HoundCI](https://houndci.com) - Review your Ruby code for style guide violations.
* [HuBoard](https://huboard.com) - Kanban board for GitHub issues.
* [Inch CI](http://inch-ci.org/) - Documentation badges for Ruby projects.
* [Nanobox](https://github.com/nanobox-io/nanobox) - A micro-PaaS (μPaaS) for creating consistent, isolated, Ruby environments deployable anywhere https://nanobox.io.
* [OctoLinker](https://github.com/OctoLinker/browser-extension) - Navigate through projects on GitHub.com efficiently with the OctoLinker browser extension.
* [PullReview](https://www.pullreview.com/) - Automated code review for Ruby and Rails - from style to security.
* [SemaphoreCI](https://semaphoreapp.com/) - Hosted continuous integration and deployment service for open source and private projects.
* [SideCI](https://www.sideci.com) - Automated Code Review with GitHub PR. - Monitoring Style Violations, Quality, Security, Dependencies.
* [Travis CI.com](https://travis-ci.com) - Take care of running your tests and deploying your private apps.
* [Travis CI.org](https://travis-ci.org) - A distributed build system for the open source community.
* [Vexor CI](https://vexor.io) - A distributed cloud web-service for building and testing software, a continuous integration tool for private apps with pay-per-minute billing model.

# Resources

Where to discover new Ruby libraries, projects and trends.

* [Awesome Ruby @LibHunt](https://ruby.libhunt.com) - Your go-to Ruby Toolbox. The Awesome Ruby collection + ordering by popularity, additional metadata and comparisons.
* [GitHub Trending](https://github.com/trending?l=ruby) - Find what repositories the GitHub community is most excited about today.
* [Green Ruby News](http://greenruby.org) - A feed of fresh links of the week about ruby, javascript, webdev and devops.
* [Open Source Rails](http://www.opensourcerails.com/) - A gallery of the best open source rack and Ruby on Rails web applications.
* [Ruby Bookmarks](https://github.com/dreikanter/ruby-bookmarks) - Ruby and Ruby on Rails bookmarks collection.
* [RubyDaily](http://rubydaily.org) - Community driven news.
* [RubyFlow](http://www.rubyflow.com) - Ruby Programming Community Link Blog.
* [Ruby Land](http://rubyland.news/) - A well maintained Ruby/Rails aggregator that contains news, opinions, tutorials, and more.
* [Ruby Rogues](http://devchat.tv/ruby-rogues) - Weekly panel discussion about programming, primarily in Ruby.
* [Ruby Weekly](http://rubyweekly.com) - A free, once–weekly e-mail round-up of Ruby news and articles.
* [The Ruby Toolbox](https://www.ruby-toolbox.com) - A comprehensive catalog of Ruby and Rails plug-ins, gems, tools and resources for Ruby developers with popularity ratings based on GitHub watchers and Gem downloads.
