#!/usr/bin/env bash

set -e

source test/setup

use Test::More

git clone "$UPSTREAM/init" "$OWNER/init" &>/dev/null

# shellcheck disable=2034
gitrepo=$OWNER/init/doc/.gitrepo

(
  cd "$OWNER/init"
  git subrepo init doc
) > /dev/null

# Test init/doc/.gitrepo file contents:
{
  test-gitrepo-field "remote" "none"
  test-gitrepo-field "branch" "master"
  test-gitrepo-field "commit" ""
  test-gitrepo-field "parent" ""
  test-gitrepo-field "method" "merge"
  test-gitrepo-field "cmdver" "$(git subrepo --version)"
}

is "$(
  cd "$OWNER/init"
  git subrepo config doc method rebase
)" \
  "Subrepo 'doc' option 'method' set to 'rebase'."

{
  test-gitrepo-field "remote" "none"
  test-gitrepo-field "branch" "master"
  test-gitrepo-field "commit" ""
  test-gitrepo-field "parent" ""
  test-gitrepo-field "method" "rebase"
  test-gitrepo-field "cmdver" "$(git subrepo --version)"
}

is "$(
  cd "$OWNER/init"
  git subrepo config doc method
)" \
  "Subrepo 'doc' option 'method' has value 'rebase'."

is "$(
  cd "$OWNER/init"
  catch git subrepo config doc branch new
)" \
  "git-subrepo: This option is autogenerated, use '--force' to override."


done_testing

teardown
