/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public abstract class AtomicValue
extends Value
implements Item {
    public boolean hasBuiltInType() {
        return true;
    }

    public int getImplementationMethod() {
        return 1;
    }

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Item item = this.evaluateItem(xPathContext);
        if (item != null) {
            xPathContext.getReceiver().append(item, 0, 2);
        }
    }

    public final int getCardinality() {
        return 16384;
    }

    public final AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(n);
        if (schemaType instanceof BuiltInAtomicType) {
            AtomicValue atomicValue = this.convertPrimitive((BuiltInAtomicType)schemaType, true, xPathContext);
            if (atomicValue instanceof ValidationErrorValue) {
                throw ((ValidationErrorValue)atomicValue).getException();
            }
            return atomicValue;
        }
        throw new IllegalArgumentException("This method can only be used for conversion to a built-in atomic type");
    }

    public abstract AtomicValue convertPrimitive(BuiltInAtomicType var1, boolean var2, XPathContext var3);

    public AtomicValue convert(AtomicType atomicType, XPathContext xPathContext, boolean bl) {
        if (atomicType instanceof BuiltInAtomicType) {
            return this.convertPrimitive((BuiltInAtomicType)atomicType, bl, xPathContext);
        }
        CharSequence charSequence = this.getStringValueCS();
        AtomicValue atomicValue = this.convertPrimitive((BuiltInAtomicType)atomicType.getPrimitiveItemType(), bl, xPathContext);
        if (atomicValue instanceof ValidationErrorValue) {
            return atomicValue;
        }
        return atomicType.makeDerivedValue(atomicValue, charSequence, bl);
    }

    public final int getLength() {
        return 1;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this;
    }

    public final SequenceIterator iterate(XPathContext xPathContext) {
        return SingletonIterator.makeIterator(this);
    }

    public final String evaluateAsString(XPathContext xPathContext) {
        return this.getStringValue();
    }

    public abstract String getStringValue();

    public final SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(this);
    }

    public AtomicValue getPrimitiveValue() {
        return this;
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NamePool namePool = xPathContext.getNamePool();
        TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
        DynamicError dynamicError = new DynamicError("Effective boolean value is not defined for an atomic value of type " + (xPathContext == null ? "other than boolean, number, string, or URI" : this.getItemType(typeHierarchy).toString(namePool)));
        dynamicError.setIsTypeError(true);
        dynamicError.setErrorCode("FORG0006");
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    public AtomicValue getComponent(int n) throws XPathException {
        throw new UnsupportedOperationException("Data type does not support component extraction");
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        Serializable serializable;
        if (bl) {
            serializable = null;
            if (schemaType instanceof SimpleType) {
                serializable = (SimpleType)schemaType;
            } else if (schemaType instanceof ComplexType && ((ComplexType)schemaType).isSimpleContent()) {
                serializable = ((ComplexType)schemaType).getSimpleContentType();
            }
            if (serializable != null && !serializable.isNamespaceSensitive()) {
                ValidationException validationException = serializable.validateContent(this.getStringValueCS(), null, staticContext.getConfiguration().getNameChecker());
                if (validationException != null) {
                    throw validationException;
                }
                return;
            }
        }
        if (schemaType instanceof ComplexType && !((ComplexType)schemaType).isSimpleContent() && !((ComplexType)schemaType).isMixedContent() && !Whitespace.isWhite(this.getStringValueCS())) {
            serializable = new StaticError("Complex type " + schemaType.getDescription() + " does not allow text content " + Err.wrap(this.getStringValueCS()));
            ((XPathException)serializable).setIsTypeError(true);
            throw serializable;
        }
    }

    public String toString() {
        return this.getItemType(null).toString() + " (\"" + this.getStringValueCS() + "\")";
    }

    public final void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + this.toString());
    }
}

