# widgets/sidebar.py
#
# Copyright 2020-2023 Fabio Comuni, et al.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


from gi.repository import GObject
from gi.repository import Gtk
from gi.repository import Adw


class SideBarRow(Adw.ActionRow):
    __gtype_name__ = "ConfySideBarRow"

    _name = None
    @GObject.property(type=str, default="")
    def name(self):
        return self._name

    @name.setter
    def name(self, value):
        self._name = value

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.props.activatable = True;


@Gtk.Template(resource_path="/net/kirgroup/confy/widgets/sidebar.ui")
class SideBar(Gtk.Box):
    __gtype_name__ = "ConfySideBar"

    listbox = Gtk.Template.Child()

    @GObject.Signal
    def page_changed(self):
        ...

    _stack = None
    @GObject.property(type=Gtk.Stack)
    def stack(self):
        return self._stack

    @stack.setter
    def stack(self, obj):
        if obj != self._stack:
            # rebuild
            w = self.listbox.get_last_child()
            while w:
                self.listbox.remove(w)
                w = self.listbox.get_last_child()

            for p in obj.get_pages():
                row = SideBarRow()
                p.bind_property("name", row, "name", GObject.BindingFlags.SYNC_CREATE)
                p.bind_property("title", row, "title", GObject.BindingFlags.SYNC_CREATE)
                p.bind_property("icon-name", row, "icon-name", GObject.BindingFlags.SYNC_CREATE)
                p.bind_property("visible", row, "visible", GObject.BindingFlags.SYNC_CREATE)
                self.listbox.append(row)

            self.listbox.select_row(self.listbox.get_first_child())

        self._stack = obj
        self._stack.connect('notify::visible-child', self._on_stack_page_changed)


    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.listbox.set_header_func(self._set_separators)

    def get_row_by_name(self, name):
        for i in range(0, 5):
            row = self.listbox.get_row_at_index(i)
            if row is None:
                break
            if row.props.name == name:
                break
        return row

    def _on_stack_page_changed(self, *_):
        name = self._stack.get_visible_child_name()
        row = self.get_row_by_name(name)
        print(name, row)
        if row is None:
            return
        self.listbox.select_row(row)

    @Gtk.Template.Callback()
    def _on_row_activated(self, listbox, row):
        if self._stack:
            self._stack.set_visible_child_name(row.props.name)
            self.emit('page-changed')

    def _set_separators(self, row, before):
        if row.props.name == "starred":
            h = Gtk.Separator()
            row.set_header(h)

