// Copyright 2012-2018 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// NOTE: The following code was generated by "scripts/unicode.py", do not edit directly

#![allow(missing_docs)]
use quick_check::IsNormalized;
use quick_check::IsNormalized::*;

#[allow(unused)]
pub const UNICODE_VERSION: (u64, u64, u64) = (9, 0, 0);

#[inline]
pub fn canonical_combining_class(c: char) -> u8 {
    match c {
        '\u{0300}' => 230,
        '\u{0301}' => 230,
        '\u{0302}' => 230,
        '\u{0303}' => 230,
        '\u{0304}' => 230,
        '\u{0305}' => 230,
        '\u{0306}' => 230,
        '\u{0307}' => 230,
        '\u{0308}' => 230,
        '\u{0309}' => 230,
        '\u{030A}' => 230,
        '\u{030B}' => 230,
        '\u{030C}' => 230,
        '\u{030D}' => 230,
        '\u{030E}' => 230,
        '\u{030F}' => 230,
        '\u{0310}' => 230,
        '\u{0311}' => 230,
        '\u{0312}' => 230,
        '\u{0313}' => 230,
        '\u{0314}' => 230,
        '\u{0315}' => 232,
        '\u{0316}' => 220,
        '\u{0317}' => 220,
        '\u{0318}' => 220,
        '\u{0319}' => 220,
        '\u{031A}' => 232,
        '\u{031B}' => 216,
        '\u{031C}' => 220,
        '\u{031D}' => 220,
        '\u{031E}' => 220,
        '\u{031F}' => 220,
        '\u{0320}' => 220,
        '\u{0321}' => 202,
        '\u{0322}' => 202,
        '\u{0323}' => 220,
        '\u{0324}' => 220,
        '\u{0325}' => 220,
        '\u{0326}' => 220,
        '\u{0327}' => 202,
        '\u{0328}' => 202,
        '\u{0329}' => 220,
        '\u{032A}' => 220,
        '\u{032B}' => 220,
        '\u{032C}' => 220,
        '\u{032D}' => 220,
        '\u{032E}' => 220,
        '\u{032F}' => 220,
        '\u{0330}' => 220,
        '\u{0331}' => 220,
        '\u{0332}' => 220,
        '\u{0333}' => 220,
        '\u{0334}' => 1,
        '\u{0335}' => 1,
        '\u{0336}' => 1,
        '\u{0337}' => 1,
        '\u{0338}' => 1,
        '\u{0339}' => 220,
        '\u{033A}' => 220,
        '\u{033B}' => 220,
        '\u{033C}' => 220,
        '\u{033D}' => 230,
        '\u{033E}' => 230,
        '\u{033F}' => 230,
        '\u{0340}' => 230,
        '\u{0341}' => 230,
        '\u{0342}' => 230,
        '\u{0343}' => 230,
        '\u{0344}' => 230,
        '\u{0345}' => 240,
        '\u{0346}' => 230,
        '\u{0347}' => 220,
        '\u{0348}' => 220,
        '\u{0349}' => 220,
        '\u{034A}' => 230,
        '\u{034B}' => 230,
        '\u{034C}' => 230,
        '\u{034D}' => 220,
        '\u{034E}' => 220,
        '\u{0350}' => 230,
        '\u{0351}' => 230,
        '\u{0352}' => 230,
        '\u{0353}' => 220,
        '\u{0354}' => 220,
        '\u{0355}' => 220,
        '\u{0356}' => 220,
        '\u{0357}' => 230,
        '\u{0358}' => 232,
        '\u{0359}' => 220,
        '\u{035A}' => 220,
        '\u{035B}' => 230,
        '\u{035C}' => 233,
        '\u{035D}' => 234,
        '\u{035E}' => 234,
        '\u{035F}' => 233,
        '\u{0360}' => 234,
        '\u{0361}' => 234,
        '\u{0362}' => 233,
        '\u{0363}' => 230,
        '\u{0364}' => 230,
        '\u{0365}' => 230,
        '\u{0366}' => 230,
        '\u{0367}' => 230,
        '\u{0368}' => 230,
        '\u{0369}' => 230,
        '\u{036A}' => 230,
        '\u{036B}' => 230,
        '\u{036C}' => 230,
        '\u{036D}' => 230,
        '\u{036E}' => 230,
        '\u{036F}' => 230,
        '\u{0483}' => 230,
        '\u{0484}' => 230,
        '\u{0485}' => 230,
        '\u{0486}' => 230,
        '\u{0487}' => 230,
        '\u{0591}' => 220,
        '\u{0592}' => 230,
        '\u{0593}' => 230,
        '\u{0594}' => 230,
        '\u{0595}' => 230,
        '\u{0596}' => 220,
        '\u{0597}' => 230,
        '\u{0598}' => 230,
        '\u{0599}' => 230,
        '\u{059A}' => 222,
        '\u{059B}' => 220,
        '\u{059C}' => 230,
        '\u{059D}' => 230,
        '\u{059E}' => 230,
        '\u{059F}' => 230,
        '\u{05A0}' => 230,
        '\u{05A1}' => 230,
        '\u{05A2}' => 220,
        '\u{05A3}' => 220,
        '\u{05A4}' => 220,
        '\u{05A5}' => 220,
        '\u{05A6}' => 220,
        '\u{05A7}' => 220,
        '\u{05A8}' => 230,
        '\u{05A9}' => 230,
        '\u{05AA}' => 220,
        '\u{05AB}' => 230,
        '\u{05AC}' => 230,
        '\u{05AD}' => 222,
        '\u{05AE}' => 228,
        '\u{05AF}' => 230,
        '\u{05B0}' => 10,
        '\u{05B1}' => 11,
        '\u{05B2}' => 12,
        '\u{05B3}' => 13,
        '\u{05B4}' => 14,
        '\u{05B5}' => 15,
        '\u{05B6}' => 16,
        '\u{05B7}' => 17,
        '\u{05B8}' => 18,
        '\u{05B9}' => 19,
        '\u{05BA}' => 19,
        '\u{05BB}' => 20,
        '\u{05BC}' => 21,
        '\u{05BD}' => 22,
        '\u{05BF}' => 23,
        '\u{05C1}' => 24,
        '\u{05C2}' => 25,
        '\u{05C4}' => 230,
        '\u{05C5}' => 220,
        '\u{05C7}' => 18,
        '\u{0610}' => 230,
        '\u{0611}' => 230,
        '\u{0612}' => 230,
        '\u{0613}' => 230,
        '\u{0614}' => 230,
        '\u{0615}' => 230,
        '\u{0616}' => 230,
        '\u{0617}' => 230,
        '\u{0618}' => 30,
        '\u{0619}' => 31,
        '\u{061A}' => 32,
        '\u{064B}' => 27,
        '\u{064C}' => 28,
        '\u{064D}' => 29,
        '\u{064E}' => 30,
        '\u{064F}' => 31,
        '\u{0650}' => 32,
        '\u{0651}' => 33,
        '\u{0652}' => 34,
        '\u{0653}' => 230,
        '\u{0654}' => 230,
        '\u{0655}' => 220,
        '\u{0656}' => 220,
        '\u{0657}' => 230,
        '\u{0658}' => 230,
        '\u{0659}' => 230,
        '\u{065A}' => 230,
        '\u{065B}' => 230,
        '\u{065C}' => 220,
        '\u{065D}' => 230,
        '\u{065E}' => 230,
        '\u{065F}' => 220,
        '\u{0670}' => 35,
        '\u{06D6}' => 230,
        '\u{06D7}' => 230,
        '\u{06D8}' => 230,
        '\u{06D9}' => 230,
        '\u{06DA}' => 230,
        '\u{06DB}' => 230,
        '\u{06DC}' => 230,
        '\u{06DF}' => 230,
        '\u{06E0}' => 230,
        '\u{06E1}' => 230,
        '\u{06E2}' => 230,
        '\u{06E3}' => 220,
        '\u{06E4}' => 230,
        '\u{06E7}' => 230,
        '\u{06E8}' => 230,
        '\u{06EA}' => 220,
        '\u{06EB}' => 230,
        '\u{06EC}' => 230,
        '\u{06ED}' => 220,
        '\u{0711}' => 36,
        '\u{0730}' => 230,
        '\u{0731}' => 220,
        '\u{0732}' => 230,
        '\u{0733}' => 230,
        '\u{0734}' => 220,
        '\u{0735}' => 230,
        '\u{0736}' => 230,
        '\u{0737}' => 220,
        '\u{0738}' => 220,
        '\u{0739}' => 220,
        '\u{073A}' => 230,
        '\u{073B}' => 220,
        '\u{073C}' => 220,
        '\u{073D}' => 230,
        '\u{073E}' => 220,
        '\u{073F}' => 230,
        '\u{0740}' => 230,
        '\u{0741}' => 230,
        '\u{0742}' => 220,
        '\u{0743}' => 230,
        '\u{0744}' => 220,
        '\u{0745}' => 230,
        '\u{0746}' => 220,
        '\u{0747}' => 230,
        '\u{0748}' => 220,
        '\u{0749}' => 230,
        '\u{074A}' => 230,
        '\u{07EB}' => 230,
        '\u{07EC}' => 230,
        '\u{07ED}' => 230,
        '\u{07EE}' => 230,
        '\u{07EF}' => 230,
        '\u{07F0}' => 230,
        '\u{07F1}' => 230,
        '\u{07F2}' => 220,
        '\u{07F3}' => 230,
        '\u{0816}' => 230,
        '\u{0817}' => 230,
        '\u{0818}' => 230,
        '\u{0819}' => 230,
        '\u{081B}' => 230,
        '\u{081C}' => 230,
        '\u{081D}' => 230,
        '\u{081E}' => 230,
        '\u{081F}' => 230,
        '\u{0820}' => 230,
        '\u{0821}' => 230,
        '\u{0822}' => 230,
        '\u{0823}' => 230,
        '\u{0825}' => 230,
        '\u{0826}' => 230,
        '\u{0827}' => 230,
        '\u{0829}' => 230,
        '\u{082A}' => 230,
        '\u{082B}' => 230,
        '\u{082C}' => 230,
        '\u{082D}' => 230,
        '\u{0859}' => 220,
        '\u{085A}' => 220,
        '\u{085B}' => 220,
        '\u{08D4}' => 230,
        '\u{08D5}' => 230,
        '\u{08D6}' => 230,
        '\u{08D7}' => 230,
        '\u{08D8}' => 230,
        '\u{08D9}' => 230,
        '\u{08DA}' => 230,
        '\u{08DB}' => 230,
        '\u{08DC}' => 230,
        '\u{08DD}' => 230,
        '\u{08DE}' => 230,
        '\u{08DF}' => 230,
        '\u{08E0}' => 230,
        '\u{08E1}' => 230,
        '\u{08E3}' => 220,
        '\u{08E4}' => 230,
        '\u{08E5}' => 230,
        '\u{08E6}' => 220,
        '\u{08E7}' => 230,
        '\u{08E8}' => 230,
        '\u{08E9}' => 220,
        '\u{08EA}' => 230,
        '\u{08EB}' => 230,
        '\u{08EC}' => 230,
        '\u{08ED}' => 220,
        '\u{08EE}' => 220,
        '\u{08EF}' => 220,
        '\u{08F0}' => 27,
        '\u{08F1}' => 28,
        '\u{08F2}' => 29,
        '\u{08F3}' => 230,
        '\u{08F4}' => 230,
        '\u{08F5}' => 230,
        '\u{08F6}' => 220,
        '\u{08F7}' => 230,
        '\u{08F8}' => 230,
        '\u{08F9}' => 220,
        '\u{08FA}' => 220,
        '\u{08FB}' => 230,
        '\u{08FC}' => 230,
        '\u{08FD}' => 230,
        '\u{08FE}' => 230,
        '\u{08FF}' => 230,
        '\u{093C}' => 7,
        '\u{094D}' => 9,
        '\u{0951}' => 230,
        '\u{0952}' => 220,
        '\u{0953}' => 230,
        '\u{0954}' => 230,
        '\u{09BC}' => 7,
        '\u{09CD}' => 9,
        '\u{0A3C}' => 7,
        '\u{0A4D}' => 9,
        '\u{0ABC}' => 7,
        '\u{0ACD}' => 9,
        '\u{0B3C}' => 7,
        '\u{0B4D}' => 9,
        '\u{0BCD}' => 9,
        '\u{0C4D}' => 9,
        '\u{0C55}' => 84,
        '\u{0C56}' => 91,
        '\u{0CBC}' => 7,
        '\u{0CCD}' => 9,
        '\u{0D4D}' => 9,
        '\u{0DCA}' => 9,
        '\u{0E38}' => 103,
        '\u{0E39}' => 103,
        '\u{0E3A}' => 9,
        '\u{0E48}' => 107,
        '\u{0E49}' => 107,
        '\u{0E4A}' => 107,
        '\u{0E4B}' => 107,
        '\u{0EB8}' => 118,
        '\u{0EB9}' => 118,
        '\u{0EC8}' => 122,
        '\u{0EC9}' => 122,
        '\u{0ECA}' => 122,
        '\u{0ECB}' => 122,
        '\u{0F18}' => 220,
        '\u{0F19}' => 220,
        '\u{0F35}' => 220,
        '\u{0F37}' => 220,
        '\u{0F39}' => 216,
        '\u{0F71}' => 129,
        '\u{0F72}' => 130,
        '\u{0F74}' => 132,
        '\u{0F7A}' => 130,
        '\u{0F7B}' => 130,
        '\u{0F7C}' => 130,
        '\u{0F7D}' => 130,
        '\u{0F80}' => 130,
        '\u{0F82}' => 230,
        '\u{0F83}' => 230,
        '\u{0F84}' => 9,
        '\u{0F86}' => 230,
        '\u{0F87}' => 230,
        '\u{0FC6}' => 220,
        '\u{1037}' => 7,
        '\u{1039}' => 9,
        '\u{103A}' => 9,
        '\u{108D}' => 220,
        '\u{135D}' => 230,
        '\u{135E}' => 230,
        '\u{135F}' => 230,
        '\u{1714}' => 9,
        '\u{1734}' => 9,
        '\u{17D2}' => 9,
        '\u{17DD}' => 230,
        '\u{18A9}' => 228,
        '\u{1939}' => 222,
        '\u{193A}' => 230,
        '\u{193B}' => 220,
        '\u{1A17}' => 230,
        '\u{1A18}' => 220,
        '\u{1A60}' => 9,
        '\u{1A75}' => 230,
        '\u{1A76}' => 230,
        '\u{1A77}' => 230,
        '\u{1A78}' => 230,
        '\u{1A79}' => 230,
        '\u{1A7A}' => 230,
        '\u{1A7B}' => 230,
        '\u{1A7C}' => 230,
        '\u{1A7F}' => 220,
        '\u{1AB0}' => 230,
        '\u{1AB1}' => 230,
        '\u{1AB2}' => 230,
        '\u{1AB3}' => 230,
        '\u{1AB4}' => 230,
        '\u{1AB5}' => 220,
        '\u{1AB6}' => 220,
        '\u{1AB7}' => 220,
        '\u{1AB8}' => 220,
        '\u{1AB9}' => 220,
        '\u{1ABA}' => 220,
        '\u{1ABB}' => 230,
        '\u{1ABC}' => 230,
        '\u{1ABD}' => 220,
        '\u{1B34}' => 7,
        '\u{1B44}' => 9,
        '\u{1B6B}' => 230,
        '\u{1B6C}' => 220,
        '\u{1B6D}' => 230,
        '\u{1B6E}' => 230,
        '\u{1B6F}' => 230,
        '\u{1B70}' => 230,
        '\u{1B71}' => 230,
        '\u{1B72}' => 230,
        '\u{1B73}' => 230,
        '\u{1BAA}' => 9,
        '\u{1BAB}' => 9,
        '\u{1BE6}' => 7,
        '\u{1BF2}' => 9,
        '\u{1BF3}' => 9,
        '\u{1C37}' => 7,
        '\u{1CD0}' => 230,
        '\u{1CD1}' => 230,
        '\u{1CD2}' => 230,
        '\u{1CD4}' => 1,
        '\u{1CD5}' => 220,
        '\u{1CD6}' => 220,
        '\u{1CD7}' => 220,
        '\u{1CD8}' => 220,
        '\u{1CD9}' => 220,
        '\u{1CDA}' => 230,
        '\u{1CDB}' => 230,
        '\u{1CDC}' => 220,
        '\u{1CDD}' => 220,
        '\u{1CDE}' => 220,
        '\u{1CDF}' => 220,
        '\u{1CE0}' => 230,
        '\u{1CE2}' => 1,
        '\u{1CE3}' => 1,
        '\u{1CE4}' => 1,
        '\u{1CE5}' => 1,
        '\u{1CE6}' => 1,
        '\u{1CE7}' => 1,
        '\u{1CE8}' => 1,
        '\u{1CED}' => 220,
        '\u{1CF4}' => 230,
        '\u{1CF8}' => 230,
        '\u{1CF9}' => 230,
        '\u{1DC0}' => 230,
        '\u{1DC1}' => 230,
        '\u{1DC2}' => 220,
        '\u{1DC3}' => 230,
        '\u{1DC4}' => 230,
        '\u{1DC5}' => 230,
        '\u{1DC6}' => 230,
        '\u{1DC7}' => 230,
        '\u{1DC8}' => 230,
        '\u{1DC9}' => 230,
        '\u{1DCA}' => 220,
        '\u{1DCB}' => 230,
        '\u{1DCC}' => 230,
        '\u{1DCD}' => 234,
        '\u{1DCE}' => 214,
        '\u{1DCF}' => 220,
        '\u{1DD0}' => 202,
        '\u{1DD1}' => 230,
        '\u{1DD2}' => 230,
        '\u{1DD3}' => 230,
        '\u{1DD4}' => 230,
        '\u{1DD5}' => 230,
        '\u{1DD6}' => 230,
        '\u{1DD7}' => 230,
        '\u{1DD8}' => 230,
        '\u{1DD9}' => 230,
        '\u{1DDA}' => 230,
        '\u{1DDB}' => 230,
        '\u{1DDC}' => 230,
        '\u{1DDD}' => 230,
        '\u{1DDE}' => 230,
        '\u{1DDF}' => 230,
        '\u{1DE0}' => 230,
        '\u{1DE1}' => 230,
        '\u{1DE2}' => 230,
        '\u{1DE3}' => 230,
        '\u{1DE4}' => 230,
        '\u{1DE5}' => 230,
        '\u{1DE6}' => 230,
        '\u{1DE7}' => 230,
        '\u{1DE8}' => 230,
        '\u{1DE9}' => 230,
        '\u{1DEA}' => 230,
        '\u{1DEB}' => 230,
        '\u{1DEC}' => 230,
        '\u{1DED}' => 230,
        '\u{1DEE}' => 230,
        '\u{1DEF}' => 230,
        '\u{1DF0}' => 230,
        '\u{1DF1}' => 230,
        '\u{1DF2}' => 230,
        '\u{1DF3}' => 230,
        '\u{1DF4}' => 230,
        '\u{1DF5}' => 230,
        '\u{1DFB}' => 230,
        '\u{1DFC}' => 233,
        '\u{1DFD}' => 220,
        '\u{1DFE}' => 230,
        '\u{1DFF}' => 220,
        '\u{20D0}' => 230,
        '\u{20D1}' => 230,
        '\u{20D2}' => 1,
        '\u{20D3}' => 1,
        '\u{20D4}' => 230,
        '\u{20D5}' => 230,
        '\u{20D6}' => 230,
        '\u{20D7}' => 230,
        '\u{20D8}' => 1,
        '\u{20D9}' => 1,
        '\u{20DA}' => 1,
        '\u{20DB}' => 230,
        '\u{20DC}' => 230,
        '\u{20E1}' => 230,
        '\u{20E5}' => 1,
        '\u{20E6}' => 1,
        '\u{20E7}' => 230,
        '\u{20E8}' => 220,
        '\u{20E9}' => 230,
        '\u{20EA}' => 1,
        '\u{20EB}' => 1,
        '\u{20EC}' => 220,
        '\u{20ED}' => 220,
        '\u{20EE}' => 220,
        '\u{20EF}' => 220,
        '\u{20F0}' => 230,
        '\u{2CEF}' => 230,
        '\u{2CF0}' => 230,
        '\u{2CF1}' => 230,
        '\u{2D7F}' => 9,
        '\u{2DE0}' => 230,
        '\u{2DE1}' => 230,
        '\u{2DE2}' => 230,
        '\u{2DE3}' => 230,
        '\u{2DE4}' => 230,
        '\u{2DE5}' => 230,
        '\u{2DE6}' => 230,
        '\u{2DE7}' => 230,
        '\u{2DE8}' => 230,
        '\u{2DE9}' => 230,
        '\u{2DEA}' => 230,
        '\u{2DEB}' => 230,
        '\u{2DEC}' => 230,
        '\u{2DED}' => 230,
        '\u{2DEE}' => 230,
        '\u{2DEF}' => 230,
        '\u{2DF0}' => 230,
        '\u{2DF1}' => 230,
        '\u{2DF2}' => 230,
        '\u{2DF3}' => 230,
        '\u{2DF4}' => 230,
        '\u{2DF5}' => 230,
        '\u{2DF6}' => 230,
        '\u{2DF7}' => 230,
        '\u{2DF8}' => 230,
        '\u{2DF9}' => 230,
        '\u{2DFA}' => 230,
        '\u{2DFB}' => 230,
        '\u{2DFC}' => 230,
        '\u{2DFD}' => 230,
        '\u{2DFE}' => 230,
        '\u{2DFF}' => 230,
        '\u{302A}' => 218,
        '\u{302B}' => 228,
        '\u{302C}' => 232,
        '\u{302D}' => 222,
        '\u{302E}' => 224,
        '\u{302F}' => 224,
        '\u{3099}' => 8,
        '\u{309A}' => 8,
        '\u{A66F}' => 230,
        '\u{A674}' => 230,
        '\u{A675}' => 230,
        '\u{A676}' => 230,
        '\u{A677}' => 230,
        '\u{A678}' => 230,
        '\u{A679}' => 230,
        '\u{A67A}' => 230,
        '\u{A67B}' => 230,
        '\u{A67C}' => 230,
        '\u{A67D}' => 230,
        '\u{A69E}' => 230,
        '\u{A69F}' => 230,
        '\u{A6F0}' => 230,
        '\u{A6F1}' => 230,
        '\u{A806}' => 9,
        '\u{A8C4}' => 9,
        '\u{A8E0}' => 230,
        '\u{A8E1}' => 230,
        '\u{A8E2}' => 230,
        '\u{A8E3}' => 230,
        '\u{A8E4}' => 230,
        '\u{A8E5}' => 230,
        '\u{A8E6}' => 230,
        '\u{A8E7}' => 230,
        '\u{A8E8}' => 230,
        '\u{A8E9}' => 230,
        '\u{A8EA}' => 230,
        '\u{A8EB}' => 230,
        '\u{A8EC}' => 230,
        '\u{A8ED}' => 230,
        '\u{A8EE}' => 230,
        '\u{A8EF}' => 230,
        '\u{A8F0}' => 230,
        '\u{A8F1}' => 230,
        '\u{A92B}' => 220,
        '\u{A92C}' => 220,
        '\u{A92D}' => 220,
        '\u{A953}' => 9,
        '\u{A9B3}' => 7,
        '\u{A9C0}' => 9,
        '\u{AAB0}' => 230,
        '\u{AAB2}' => 230,
        '\u{AAB3}' => 230,
        '\u{AAB4}' => 220,
        '\u{AAB7}' => 230,
        '\u{AAB8}' => 230,
        '\u{AABE}' => 230,
        '\u{AABF}' => 230,
        '\u{AAC1}' => 230,
        '\u{AAF6}' => 9,
        '\u{ABED}' => 9,
        '\u{FB1E}' => 26,
        '\u{FE20}' => 230,
        '\u{FE21}' => 230,
        '\u{FE22}' => 230,
        '\u{FE23}' => 230,
        '\u{FE24}' => 230,
        '\u{FE25}' => 230,
        '\u{FE26}' => 230,
        '\u{FE27}' => 220,
        '\u{FE28}' => 220,
        '\u{FE29}' => 220,
        '\u{FE2A}' => 220,
        '\u{FE2B}' => 220,
        '\u{FE2C}' => 220,
        '\u{FE2D}' => 220,
        '\u{FE2E}' => 230,
        '\u{FE2F}' => 230,
        '\u{101FD}' => 220,
        '\u{102E0}' => 220,
        '\u{10376}' => 230,
        '\u{10377}' => 230,
        '\u{10378}' => 230,
        '\u{10379}' => 230,
        '\u{1037A}' => 230,
        '\u{10A0D}' => 220,
        '\u{10A0F}' => 230,
        '\u{10A38}' => 230,
        '\u{10A39}' => 1,
        '\u{10A3A}' => 220,
        '\u{10A3F}' => 9,
        '\u{10AE5}' => 230,
        '\u{10AE6}' => 220,
        '\u{11046}' => 9,
        '\u{1107F}' => 9,
        '\u{110B9}' => 9,
        '\u{110BA}' => 7,
        '\u{11100}' => 230,
        '\u{11101}' => 230,
        '\u{11102}' => 230,
        '\u{11133}' => 9,
        '\u{11134}' => 9,
        '\u{11173}' => 7,
        '\u{111C0}' => 9,
        '\u{111CA}' => 7,
        '\u{11235}' => 9,
        '\u{11236}' => 7,
        '\u{112E9}' => 7,
        '\u{112EA}' => 9,
        '\u{1133C}' => 7,
        '\u{1134D}' => 9,
        '\u{11366}' => 230,
        '\u{11367}' => 230,
        '\u{11368}' => 230,
        '\u{11369}' => 230,
        '\u{1136A}' => 230,
        '\u{1136B}' => 230,
        '\u{1136C}' => 230,
        '\u{11370}' => 230,
        '\u{11371}' => 230,
        '\u{11372}' => 230,
        '\u{11373}' => 230,
        '\u{11374}' => 230,
        '\u{11442}' => 9,
        '\u{11446}' => 7,
        '\u{114C2}' => 9,
        '\u{114C3}' => 7,
        '\u{115BF}' => 9,
        '\u{115C0}' => 7,
        '\u{1163F}' => 9,
        '\u{116B6}' => 9,
        '\u{116B7}' => 7,
        '\u{1172B}' => 9,
        '\u{11C3F}' => 9,
        '\u{16AF0}' => 1,
        '\u{16AF1}' => 1,
        '\u{16AF2}' => 1,
        '\u{16AF3}' => 1,
        '\u{16AF4}' => 1,
        '\u{16B30}' => 230,
        '\u{16B31}' => 230,
        '\u{16B32}' => 230,
        '\u{16B33}' => 230,
        '\u{16B34}' => 230,
        '\u{16B35}' => 230,
        '\u{16B36}' => 230,
        '\u{1BC9E}' => 1,
        '\u{1D165}' => 216,
        '\u{1D166}' => 216,
        '\u{1D167}' => 1,
        '\u{1D168}' => 1,
        '\u{1D169}' => 1,
        '\u{1D16D}' => 226,
        '\u{1D16E}' => 216,
        '\u{1D16F}' => 216,
        '\u{1D170}' => 216,
        '\u{1D171}' => 216,
        '\u{1D172}' => 216,
        '\u{1D17B}' => 220,
        '\u{1D17C}' => 220,
        '\u{1D17D}' => 220,
        '\u{1D17E}' => 220,
        '\u{1D17F}' => 220,
        '\u{1D180}' => 220,
        '\u{1D181}' => 220,
        '\u{1D182}' => 220,
        '\u{1D185}' => 230,
        '\u{1D186}' => 230,
        '\u{1D187}' => 230,
        '\u{1D188}' => 230,
        '\u{1D189}' => 230,
        '\u{1D18A}' => 220,
        '\u{1D18B}' => 220,
        '\u{1D1AA}' => 230,
        '\u{1D1AB}' => 230,
        '\u{1D1AC}' => 230,
        '\u{1D1AD}' => 230,
        '\u{1D242}' => 230,
        '\u{1D243}' => 230,
        '\u{1D244}' => 230,
        '\u{1E000}' => 230,
        '\u{1E001}' => 230,
        '\u{1E002}' => 230,
        '\u{1E003}' => 230,
        '\u{1E004}' => 230,
        '\u{1E005}' => 230,
        '\u{1E006}' => 230,
        '\u{1E008}' => 230,
        '\u{1E009}' => 230,
        '\u{1E00A}' => 230,
        '\u{1E00B}' => 230,
        '\u{1E00C}' => 230,
        '\u{1E00D}' => 230,
        '\u{1E00E}' => 230,
        '\u{1E00F}' => 230,
        '\u{1E010}' => 230,
        '\u{1E011}' => 230,
        '\u{1E012}' => 230,
        '\u{1E013}' => 230,
        '\u{1E014}' => 230,
        '\u{1E015}' => 230,
        '\u{1E016}' => 230,
        '\u{1E017}' => 230,
        '\u{1E018}' => 230,
        '\u{1E01B}' => 230,
        '\u{1E01C}' => 230,
        '\u{1E01D}' => 230,
        '\u{1E01E}' => 230,
        '\u{1E01F}' => 230,
        '\u{1E020}' => 230,
        '\u{1E021}' => 230,
        '\u{1E023}' => 230,
        '\u{1E024}' => 230,
        '\u{1E026}' => 230,
        '\u{1E027}' => 230,
        '\u{1E028}' => 230,
        '\u{1E029}' => 230,
        '\u{1E02A}' => 230,
        '\u{1E8D0}' => 220,
        '\u{1E8D1}' => 220,
        '\u{1E8D2}' => 220,
        '\u{1E8D3}' => 220,
        '\u{1E8D4}' => 220,
        '\u{1E8D5}' => 220,
        '\u{1E8D6}' => 220,
        '\u{1E944}' => 230,
        '\u{1E945}' => 230,
        '\u{1E946}' => 230,
        '\u{1E947}' => 230,
        '\u{1E948}' => 230,
        '\u{1E949}' => 230,
        '\u{1E94A}' => 7,
        _ => 0,
    }
}

#[inline]
pub fn composition_table(c1: char, c2: char) -> Option<char> {
    match (c1, c2) {
        ('\u{003C}', '\u{0338}') => Some('\u{226E}'),
        ('\u{003D}', '\u{0338}') => Some('\u{2260}'),
        ('\u{003E}', '\u{0338}') => Some('\u{226F}'),
        ('\u{0041}', '\u{0300}') => Some('\u{00C0}'),
        ('\u{0041}', '\u{0301}') => Some('\u{00C1}'),
        ('\u{0041}', '\u{0302}') => Some('\u{00C2}'),
        ('\u{0041}', '\u{0303}') => Some('\u{00C3}'),
        ('\u{0041}', '\u{0304}') => Some('\u{0100}'),
        ('\u{0041}', '\u{0306}') => Some('\u{0102}'),
        ('\u{0041}', '\u{0307}') => Some('\u{0226}'),
        ('\u{0041}', '\u{0308}') => Some('\u{00C4}'),
        ('\u{0041}', '\u{0309}') => Some('\u{1EA2}'),
        ('\u{0041}', '\u{030A}') => Some('\u{00C5}'),
        ('\u{0041}', '\u{030C}') => Some('\u{01CD}'),
        ('\u{0041}', '\u{030F}') => Some('\u{0200}'),
        ('\u{0041}', '\u{0311}') => Some('\u{0202}'),
        ('\u{0041}', '\u{0323}') => Some('\u{1EA0}'),
        ('\u{0041}', '\u{0325}') => Some('\u{1E00}'),
        ('\u{0041}', '\u{0328}') => Some('\u{0104}'),
        ('\u{0042}', '\u{0307}') => Some('\u{1E02}'),
        ('\u{0042}', '\u{0323}') => Some('\u{1E04}'),
        ('\u{0042}', '\u{0331}') => Some('\u{1E06}'),
        ('\u{0043}', '\u{0301}') => Some('\u{0106}'),
        ('\u{0043}', '\u{0302}') => Some('\u{0108}'),
        ('\u{0043}', '\u{0307}') => Some('\u{010A}'),
        ('\u{0043}', '\u{030C}') => Some('\u{010C}'),
        ('\u{0043}', '\u{0327}') => Some('\u{00C7}'),
        ('\u{0044}', '\u{0307}') => Some('\u{1E0A}'),
        ('\u{0044}', '\u{030C}') => Some('\u{010E}'),
        ('\u{0044}', '\u{0323}') => Some('\u{1E0C}'),
        ('\u{0044}', '\u{0327}') => Some('\u{1E10}'),
        ('\u{0044}', '\u{032D}') => Some('\u{1E12}'),
        ('\u{0044}', '\u{0331}') => Some('\u{1E0E}'),
        ('\u{0045}', '\u{0300}') => Some('\u{00C8}'),
        ('\u{0045}', '\u{0301}') => Some('\u{00C9}'),
        ('\u{0045}', '\u{0302}') => Some('\u{00CA}'),
        ('\u{0045}', '\u{0303}') => Some('\u{1EBC}'),
        ('\u{0045}', '\u{0304}') => Some('\u{0112}'),
        ('\u{0045}', '\u{0306}') => Some('\u{0114}'),
        ('\u{0045}', '\u{0307}') => Some('\u{0116}'),
        ('\u{0045}', '\u{0308}') => Some('\u{00CB}'),
        ('\u{0045}', '\u{0309}') => Some('\u{1EBA}'),
        ('\u{0045}', '\u{030C}') => Some('\u{011A}'),
        ('\u{0045}', '\u{030F}') => Some('\u{0204}'),
        ('\u{0045}', '\u{0311}') => Some('\u{0206}'),
        ('\u{0045}', '\u{0323}') => Some('\u{1EB8}'),
        ('\u{0045}', '\u{0327}') => Some('\u{0228}'),
        ('\u{0045}', '\u{0328}') => Some('\u{0118}'),
        ('\u{0045}', '\u{032D}') => Some('\u{1E18}'),
        ('\u{0045}', '\u{0330}') => Some('\u{1E1A}'),
        ('\u{0046}', '\u{0307}') => Some('\u{1E1E}'),
        ('\u{0047}', '\u{0301}') => Some('\u{01F4}'),
        ('\u{0047}', '\u{0302}') => Some('\u{011C}'),
        ('\u{0047}', '\u{0304}') => Some('\u{1E20}'),
        ('\u{0047}', '\u{0306}') => Some('\u{011E}'),
        ('\u{0047}', '\u{0307}') => Some('\u{0120}'),
        ('\u{0047}', '\u{030C}') => Some('\u{01E6}'),
        ('\u{0047}', '\u{0327}') => Some('\u{0122}'),
        ('\u{0048}', '\u{0302}') => Some('\u{0124}'),
        ('\u{0048}', '\u{0307}') => Some('\u{1E22}'),
        ('\u{0048}', '\u{0308}') => Some('\u{1E26}'),
        ('\u{0048}', '\u{030C}') => Some('\u{021E}'),
        ('\u{0048}', '\u{0323}') => Some('\u{1E24}'),
        ('\u{0048}', '\u{0327}') => Some('\u{1E28}'),
        ('\u{0048}', '\u{032E}') => Some('\u{1E2A}'),
        ('\u{0049}', '\u{0300}') => Some('\u{00CC}'),
        ('\u{0049}', '\u{0301}') => Some('\u{00CD}'),
        ('\u{0049}', '\u{0302}') => Some('\u{00CE}'),
        ('\u{0049}', '\u{0303}') => Some('\u{0128}'),
        ('\u{0049}', '\u{0304}') => Some('\u{012A}'),
        ('\u{0049}', '\u{0306}') => Some('\u{012C}'),
        ('\u{0049}', '\u{0307}') => Some('\u{0130}'),
        ('\u{0049}', '\u{0308}') => Some('\u{00CF}'),
        ('\u{0049}', '\u{0309}') => Some('\u{1EC8}'),
        ('\u{0049}', '\u{030C}') => Some('\u{01CF}'),
        ('\u{0049}', '\u{030F}') => Some('\u{0208}'),
        ('\u{0049}', '\u{0311}') => Some('\u{020A}'),
        ('\u{0049}', '\u{0323}') => Some('\u{1ECA}'),
        ('\u{0049}', '\u{0328}') => Some('\u{012E}'),
        ('\u{0049}', '\u{0330}') => Some('\u{1E2C}'),
        ('\u{004A}', '\u{0302}') => Some('\u{0134}'),
        ('\u{004B}', '\u{0301}') => Some('\u{1E30}'),
        ('\u{004B}', '\u{030C}') => Some('\u{01E8}'),
        ('\u{004B}', '\u{0323}') => Some('\u{1E32}'),
        ('\u{004B}', '\u{0327}') => Some('\u{0136}'),
        ('\u{004B}', '\u{0331}') => Some('\u{1E34}'),
        ('\u{004C}', '\u{0301}') => Some('\u{0139}'),
        ('\u{004C}', '\u{030C}') => Some('\u{013D}'),
        ('\u{004C}', '\u{0323}') => Some('\u{1E36}'),
        ('\u{004C}', '\u{0327}') => Some('\u{013B}'),
        ('\u{004C}', '\u{032D}') => Some('\u{1E3C}'),
        ('\u{004C}', '\u{0331}') => Some('\u{1E3A}'),
        ('\u{004D}', '\u{0301}') => Some('\u{1E3E}'),
        ('\u{004D}', '\u{0307}') => Some('\u{1E40}'),
        ('\u{004D}', '\u{0323}') => Some('\u{1E42}'),
        ('\u{004E}', '\u{0300}') => Some('\u{01F8}'),
        ('\u{004E}', '\u{0301}') => Some('\u{0143}'),
        ('\u{004E}', '\u{0303}') => Some('\u{00D1}'),
        ('\u{004E}', '\u{0307}') => Some('\u{1E44}'),
        ('\u{004E}', '\u{030C}') => Some('\u{0147}'),
        ('\u{004E}', '\u{0323}') => Some('\u{1E46}'),
        ('\u{004E}', '\u{0327}') => Some('\u{0145}'),
        ('\u{004E}', '\u{032D}') => Some('\u{1E4A}'),
        ('\u{004E}', '\u{0331}') => Some('\u{1E48}'),
        ('\u{004F}', '\u{0300}') => Some('\u{00D2}'),
        ('\u{004F}', '\u{0301}') => Some('\u{00D3}'),
        ('\u{004F}', '\u{0302}') => Some('\u{00D4}'),
        ('\u{004F}', '\u{0303}') => Some('\u{00D5}'),
        ('\u{004F}', '\u{0304}') => Some('\u{014C}'),
        ('\u{004F}', '\u{0306}') => Some('\u{014E}'),
        ('\u{004F}', '\u{0307}') => Some('\u{022E}'),
        ('\u{004F}', '\u{0308}') => Some('\u{00D6}'),
        ('\u{004F}', '\u{0309}') => Some('\u{1ECE}'),
        ('\u{004F}', '\u{030B}') => Some('\u{0150}'),
        ('\u{004F}', '\u{030C}') => Some('\u{01D1}'),
        ('\u{004F}', '\u{030F}') => Some('\u{020C}'),
        ('\u{004F}', '\u{0311}') => Some('\u{020E}'),
        ('\u{004F}', '\u{031B}') => Some('\u{01A0}'),
        ('\u{004F}', '\u{0323}') => Some('\u{1ECC}'),
        ('\u{004F}', '\u{0328}') => Some('\u{01EA}'),
        ('\u{0050}', '\u{0301}') => Some('\u{1E54}'),
        ('\u{0050}', '\u{0307}') => Some('\u{1E56}'),
        ('\u{0052}', '\u{0301}') => Some('\u{0154}'),
        ('\u{0052}', '\u{0307}') => Some('\u{1E58}'),
        ('\u{0052}', '\u{030C}') => Some('\u{0158}'),
        ('\u{0052}', '\u{030F}') => Some('\u{0210}'),
        ('\u{0052}', '\u{0311}') => Some('\u{0212}'),
        ('\u{0052}', '\u{0323}') => Some('\u{1E5A}'),
        ('\u{0052}', '\u{0327}') => Some('\u{0156}'),
        ('\u{0052}', '\u{0331}') => Some('\u{1E5E}'),
        ('\u{0053}', '\u{0301}') => Some('\u{015A}'),
        ('\u{0053}', '\u{0302}') => Some('\u{015C}'),
        ('\u{0053}', '\u{0307}') => Some('\u{1E60}'),
        ('\u{0053}', '\u{030C}') => Some('\u{0160}'),
        ('\u{0053}', '\u{0323}') => Some('\u{1E62}'),
        ('\u{0053}', '\u{0326}') => Some('\u{0218}'),
        ('\u{0053}', '\u{0327}') => Some('\u{015E}'),
        ('\u{0054}', '\u{0307}') => Some('\u{1E6A}'),
        ('\u{0054}', '\u{030C}') => Some('\u{0164}'),
        ('\u{0054}', '\u{0323}') => Some('\u{1E6C}'),
        ('\u{0054}', '\u{0326}') => Some('\u{021A}'),
        ('\u{0054}', '\u{0327}') => Some('\u{0162}'),
        ('\u{0054}', '\u{032D}') => Some('\u{1E70}'),
        ('\u{0054}', '\u{0331}') => Some('\u{1E6E}'),
        ('\u{0055}', '\u{0300}') => Some('\u{00D9}'),
        ('\u{0055}', '\u{0301}') => Some('\u{00DA}'),
        ('\u{0055}', '\u{0302}') => Some('\u{00DB}'),
        ('\u{0055}', '\u{0303}') => Some('\u{0168}'),
        ('\u{0055}', '\u{0304}') => Some('\u{016A}'),
        ('\u{0055}', '\u{0306}') => Some('\u{016C}'),
        ('\u{0055}', '\u{0308}') => Some('\u{00DC}'),
        ('\u{0055}', '\u{0309}') => Some('\u{1EE6}'),
        ('\u{0055}', '\u{030A}') => Some('\u{016E}'),
        ('\u{0055}', '\u{030B}') => Some('\u{0170}'),
        ('\u{0055}', '\u{030C}') => Some('\u{01D3}'),
        ('\u{0055}', '\u{030F}') => Some('\u{0214}'),
        ('\u{0055}', '\u{0311}') => Some('\u{0216}'),
        ('\u{0055}', '\u{031B}') => Some('\u{01AF}'),
        ('\u{0055}', '\u{0323}') => Some('\u{1EE4}'),
        ('\u{0055}', '\u{0324}') => Some('\u{1E72}'),
        ('\u{0055}', '\u{0328}') => Some('\u{0172}'),
        ('\u{0055}', '\u{032D}') => Some('\u{1E76}'),
        ('\u{0055}', '\u{0330}') => Some('\u{1E74}'),
        ('\u{0056}', '\u{0303}') => Some('\u{1E7C}'),
        ('\u{0056}', '\u{0323}') => Some('\u{1E7E}'),
        ('\u{0057}', '\u{0300}') => Some('\u{1E80}'),
        ('\u{0057}', '\u{0301}') => Some('\u{1E82}'),
        ('\u{0057}', '\u{0302}') => Some('\u{0174}'),
        ('\u{0057}', '\u{0307}') => Some('\u{1E86}'),
        ('\u{0057}', '\u{0308}') => Some('\u{1E84}'),
        ('\u{0057}', '\u{0323}') => Some('\u{1E88}'),
        ('\u{0058}', '\u{0307}') => Some('\u{1E8A}'),
        ('\u{0058}', '\u{0308}') => Some('\u{1E8C}'),
        ('\u{0059}', '\u{0300}') => Some('\u{1EF2}'),
        ('\u{0059}', '\u{0301}') => Some('\u{00DD}'),
        ('\u{0059}', '\u{0302}') => Some('\u{0176}'),
        ('\u{0059}', '\u{0303}') => Some('\u{1EF8}'),
        ('\u{0059}', '\u{0304}') => Some('\u{0232}'),
        ('\u{0059}', '\u{0307}') => Some('\u{1E8E}'),
        ('\u{0059}', '\u{0308}') => Some('\u{0178}'),
        ('\u{0059}', '\u{0309}') => Some('\u{1EF6}'),
        ('\u{0059}', '\u{0323}') => Some('\u{1EF4}'),
        ('\u{005A}', '\u{0301}') => Some('\u{0179}'),
        ('\u{005A}', '\u{0302}') => Some('\u{1E90}'),
        ('\u{005A}', '\u{0307}') => Some('\u{017B}'),
        ('\u{005A}', '\u{030C}') => Some('\u{017D}'),
        ('\u{005A}', '\u{0323}') => Some('\u{1E92}'),
        ('\u{005A}', '\u{0331}') => Some('\u{1E94}'),
        ('\u{0061}', '\u{0300}') => Some('\u{00E0}'),
        ('\u{0061}', '\u{0301}') => Some('\u{00E1}'),
        ('\u{0061}', '\u{0302}') => Some('\u{00E2}'),
        ('\u{0061}', '\u{0303}') => Some('\u{00E3}'),
        ('\u{0061}', '\u{0304}') => Some('\u{0101}'),
        ('\u{0061}', '\u{0306}') => Some('\u{0103}'),
        ('\u{0061}', '\u{0307}') => Some('\u{0227}'),
        ('\u{0061}', '\u{0308}') => Some('\u{00E4}'),
        ('\u{0061}', '\u{0309}') => Some('\u{1EA3}'),
        ('\u{0061}', '\u{030A}') => Some('\u{00E5}'),
        ('\u{0061}', '\u{030C}') => Some('\u{01CE}'),
        ('\u{0061}', '\u{030F}') => Some('\u{0201}'),
        ('\u{0061}', '\u{0311}') => Some('\u{0203}'),
        ('\u{0061}', '\u{0323}') => Some('\u{1EA1}'),
        ('\u{0061}', '\u{0325}') => Some('\u{1E01}'),
        ('\u{0061}', '\u{0328}') => Some('\u{0105}'),
        ('\u{0062}', '\u{0307}') => Some('\u{1E03}'),
        ('\u{0062}', '\u{0323}') => Some('\u{1E05}'),
        ('\u{0062}', '\u{0331}') => Some('\u{1E07}'),
        ('\u{0063}', '\u{0301}') => Some('\u{0107}'),
        ('\u{0063}', '\u{0302}') => Some('\u{0109}'),
        ('\u{0063}', '\u{0307}') => Some('\u{010B}'),
        ('\u{0063}', '\u{030C}') => Some('\u{010D}'),
        ('\u{0063}', '\u{0327}') => Some('\u{00E7}'),
        ('\u{0064}', '\u{0307}') => Some('\u{1E0B}'),
        ('\u{0064}', '\u{030C}') => Some('\u{010F}'),
        ('\u{0064}', '\u{0323}') => Some('\u{1E0D}'),
        ('\u{0064}', '\u{0327}') => Some('\u{1E11}'),
        ('\u{0064}', '\u{032D}') => Some('\u{1E13}'),
        ('\u{0064}', '\u{0331}') => Some('\u{1E0F}'),
        ('\u{0065}', '\u{0300}') => Some('\u{00E8}'),
        ('\u{0065}', '\u{0301}') => Some('\u{00E9}'),
        ('\u{0065}', '\u{0302}') => Some('\u{00EA}'),
        ('\u{0065}', '\u{0303}') => Some('\u{1EBD}'),
        ('\u{0065}', '\u{0304}') => Some('\u{0113}'),
        ('\u{0065}', '\u{0306}') => Some('\u{0115}'),
        ('\u{0065}', '\u{0307}') => Some('\u{0117}'),
        ('\u{0065}', '\u{0308}') => Some('\u{00EB}'),
        ('\u{0065}', '\u{0309}') => Some('\u{1EBB}'),
        ('\u{0065}', '\u{030C}') => Some('\u{011B}'),
        ('\u{0065}', '\u{030F}') => Some('\u{0205}'),
        ('\u{0065}', '\u{0311}') => Some('\u{0207}'),
        ('\u{0065}', '\u{0323}') => Some('\u{1EB9}'),
        ('\u{0065}', '\u{0327}') => Some('\u{0229}'),
        ('\u{0065}', '\u{0328}') => Some('\u{0119}'),
        ('\u{0065}', '\u{032D}') => Some('\u{1E19}'),
        ('\u{0065}', '\u{0330}') => Some('\u{1E1B}'),
        ('\u{0066}', '\u{0307}') => Some('\u{1E1F}'),
        ('\u{0067}', '\u{0301}') => Some('\u{01F5}'),
        ('\u{0067}', '\u{0302}') => Some('\u{011D}'),
        ('\u{0067}', '\u{0304}') => Some('\u{1E21}'),
        ('\u{0067}', '\u{0306}') => Some('\u{011F}'),
        ('\u{0067}', '\u{0307}') => Some('\u{0121}'),
        ('\u{0067}', '\u{030C}') => Some('\u{01E7}'),
        ('\u{0067}', '\u{0327}') => Some('\u{0123}'),
        ('\u{0068}', '\u{0302}') => Some('\u{0125}'),
        ('\u{0068}', '\u{0307}') => Some('\u{1E23}'),
        ('\u{0068}', '\u{0308}') => Some('\u{1E27}'),
        ('\u{0068}', '\u{030C}') => Some('\u{021F}'),
        ('\u{0068}', '\u{0323}') => Some('\u{1E25}'),
        ('\u{0068}', '\u{0327}') => Some('\u{1E29}'),
        ('\u{0068}', '\u{032E}') => Some('\u{1E2B}'),
        ('\u{0068}', '\u{0331}') => Some('\u{1E96}'),
        ('\u{0069}', '\u{0300}') => Some('\u{00EC}'),
        ('\u{0069}', '\u{0301}') => Some('\u{00ED}'),
        ('\u{0069}', '\u{0302}') => Some('\u{00EE}'),
        ('\u{0069}', '\u{0303}') => Some('\u{0129}'),
        ('\u{0069}', '\u{0304}') => Some('\u{012B}'),
        ('\u{0069}', '\u{0306}') => Some('\u{012D}'),
        ('\u{0069}', '\u{0308}') => Some('\u{00EF}'),
        ('\u{0069}', '\u{0309}') => Some('\u{1EC9}'),
        ('\u{0069}', '\u{030C}') => Some('\u{01D0}'),
        ('\u{0069}', '\u{030F}') => Some('\u{0209}'),
        ('\u{0069}', '\u{0311}') => Some('\u{020B}'),
        ('\u{0069}', '\u{0323}') => Some('\u{1ECB}'),
        ('\u{0069}', '\u{0328}') => Some('\u{012F}'),
        ('\u{0069}', '\u{0330}') => Some('\u{1E2D}'),
        ('\u{006A}', '\u{0302}') => Some('\u{0135}'),
        ('\u{006A}', '\u{030C}') => Some('\u{01F0}'),
        ('\u{006B}', '\u{0301}') => Some('\u{1E31}'),
        ('\u{006B}', '\u{030C}') => Some('\u{01E9}'),
        ('\u{006B}', '\u{0323}') => Some('\u{1E33}'),
        ('\u{006B}', '\u{0327}') => Some('\u{0137}'),
        ('\u{006B}', '\u{0331}') => Some('\u{1E35}'),
        ('\u{006C}', '\u{0301}') => Some('\u{013A}'),
        ('\u{006C}', '\u{030C}') => Some('\u{013E}'),
        ('\u{006C}', '\u{0323}') => Some('\u{1E37}'),
        ('\u{006C}', '\u{0327}') => Some('\u{013C}'),
        ('\u{006C}', '\u{032D}') => Some('\u{1E3D}'),
        ('\u{006C}', '\u{0331}') => Some('\u{1E3B}'),
        ('\u{006D}', '\u{0301}') => Some('\u{1E3F}'),
        ('\u{006D}', '\u{0307}') => Some('\u{1E41}'),
        ('\u{006D}', '\u{0323}') => Some('\u{1E43}'),
        ('\u{006E}', '\u{0300}') => Some('\u{01F9}'),
        ('\u{006E}', '\u{0301}') => Some('\u{0144}'),
        ('\u{006E}', '\u{0303}') => Some('\u{00F1}'),
        ('\u{006E}', '\u{0307}') => Some('\u{1E45}'),
        ('\u{006E}', '\u{030C}') => Some('\u{0148}'),
        ('\u{006E}', '\u{0323}') => Some('\u{1E47}'),
        ('\u{006E}', '\u{0327}') => Some('\u{0146}'),
        ('\u{006E}', '\u{032D}') => Some('\u{1E4B}'),
        ('\u{006E}', '\u{0331}') => Some('\u{1E49}'),
        ('\u{006F}', '\u{0300}') => Some('\u{00F2}'),
        ('\u{006F}', '\u{0301}') => Some('\u{00F3}'),
        ('\u{006F}', '\u{0302}') => Some('\u{00F4}'),
        ('\u{006F}', '\u{0303}') => Some('\u{00F5}'),
        ('\u{006F}', '\u{0304}') => Some('\u{014D}'),
        ('\u{006F}', '\u{0306}') => Some('\u{014F}'),
        ('\u{006F}', '\u{0307}') => Some('\u{022F}'),
        ('\u{006F}', '\u{0308}') => Some('\u{00F6}'),
        ('\u{006F}', '\u{0309}') => Some('\u{1ECF}'),
        ('\u{006F}', '\u{030B}') => Some('\u{0151}'),
        ('\u{006F}', '\u{030C}') => Some('\u{01D2}'),
        ('\u{006F}', '\u{030F}') => Some('\u{020D}'),
        ('\u{006F}', '\u{0311}') => Some('\u{020F}'),
        ('\u{006F}', '\u{031B}') => Some('\u{01A1}'),
        ('\u{006F}', '\u{0323}') => Some('\u{1ECD}'),
        ('\u{006F}', '\u{0328}') => Some('\u{01EB}'),
        ('\u{0070}', '\u{0301}') => Some('\u{1E55}'),
        ('\u{0070}', '\u{0307}') => Some('\u{1E57}'),
        ('\u{0072}', '\u{0301}') => Some('\u{0155}'),
        ('\u{0072}', '\u{0307}') => Some('\u{1E59}'),
        ('\u{0072}', '\u{030C}') => Some('\u{0159}'),
        ('\u{0072}', '\u{030F}') => Some('\u{0211}'),
        ('\u{0072}', '\u{0311}') => Some('\u{0213}'),
        ('\u{0072}', '\u{0323}') => Some('\u{1E5B}'),
        ('\u{0072}', '\u{0327}') => Some('\u{0157}'),
        ('\u{0072}', '\u{0331}') => Some('\u{1E5F}'),
        ('\u{0073}', '\u{0301}') => Some('\u{015B}'),
        ('\u{0073}', '\u{0302}') => Some('\u{015D}'),
        ('\u{0073}', '\u{0307}') => Some('\u{1E61}'),
        ('\u{0073}', '\u{030C}') => Some('\u{0161}'),
        ('\u{0073}', '\u{0323}') => Some('\u{1E63}'),
        ('\u{0073}', '\u{0326}') => Some('\u{0219}'),
        ('\u{0073}', '\u{0327}') => Some('\u{015F}'),
        ('\u{0074}', '\u{0307}') => Some('\u{1E6B}'),
        ('\u{0074}', '\u{0308}') => Some('\u{1E97}'),
        ('\u{0074}', '\u{030C}') => Some('\u{0165}'),
        ('\u{0074}', '\u{0323}') => Some('\u{1E6D}'),
        ('\u{0074}', '\u{0326}') => Some('\u{021B}'),
        ('\u{0074}', '\u{0327}') => Some('\u{0163}'),
        ('\u{0074}', '\u{032D}') => Some('\u{1E71}'),
        ('\u{0074}', '\u{0331}') => Some('\u{1E6F}'),
        ('\u{0075}', '\u{0300}') => Some('\u{00F9}'),
        ('\u{0075}', '\u{0301}') => Some('\u{00FA}'),
        ('\u{0075}', '\u{0302}') => Some('\u{00FB}'),
        ('\u{0075}', '\u{0303}') => Some('\u{0169}'),
        ('\u{0075}', '\u{0304}') => Some('\u{016B}'),
        ('\u{0075}', '\u{0306}') => Some('\u{016D}'),
        ('\u{0075}', '\u{0308}') => Some('\u{00FC}'),
        ('\u{0075}', '\u{0309}') => Some('\u{1EE7}'),
        ('\u{0075}', '\u{030A}') => Some('\u{016F}'),
        ('\u{0075}', '\u{030B}') => Some('\u{0171}'),
        ('\u{0075}', '\u{030C}') => Some('\u{01D4}'),
        ('\u{0075}', '\u{030F}') => Some('\u{0215}'),
        ('\u{0075}', '\u{0311}') => Some('\u{0217}'),
        ('\u{0075}', '\u{031B}') => Some('\u{01B0}'),
        ('\u{0075}', '\u{0323}') => Some('\u{1EE5}'),
        ('\u{0075}', '\u{0324}') => Some('\u{1E73}'),
        ('\u{0075}', '\u{0328}') => Some('\u{0173}'),
        ('\u{0075}', '\u{032D}') => Some('\u{1E77}'),
        ('\u{0075}', '\u{0330}') => Some('\u{1E75}'),
        ('\u{0076}', '\u{0303}') => Some('\u{1E7D}'),
        ('\u{0076}', '\u{0323}') => Some('\u{1E7F}'),
        ('\u{0077}', '\u{0300}') => Some('\u{1E81}'),
        ('\u{0077}', '\u{0301}') => Some('\u{1E83}'),
        ('\u{0077}', '\u{0302}') => Some('\u{0175}'),
        ('\u{0077}', '\u{0307}') => Some('\u{1E87}'),
        ('\u{0077}', '\u{0308}') => Some('\u{1E85}'),
        ('\u{0077}', '\u{030A}') => Some('\u{1E98}'),
        ('\u{0077}', '\u{0323}') => Some('\u{1E89}'),
        ('\u{0078}', '\u{0307}') => Some('\u{1E8B}'),
        ('\u{0078}', '\u{0308}') => Some('\u{1E8D}'),
        ('\u{0079}', '\u{0300}') => Some('\u{1EF3}'),
        ('\u{0079}', '\u{0301}') => Some('\u{00FD}'),
        ('\u{0079}', '\u{0302}') => Some('\u{0177}'),
        ('\u{0079}', '\u{0303}') => Some('\u{1EF9}'),
        ('\u{0079}', '\u{0304}') => Some('\u{0233}'),
        ('\u{0079}', '\u{0307}') => Some('\u{1E8F}'),
        ('\u{0079}', '\u{0308}') => Some('\u{00FF}'),
        ('\u{0079}', '\u{0309}') => Some('\u{1EF7}'),
        ('\u{0079}', '\u{030A}') => Some('\u{1E99}'),
        ('\u{0079}', '\u{0323}') => Some('\u{1EF5}'),
        ('\u{007A}', '\u{0301}') => Some('\u{017A}'),
        ('\u{007A}', '\u{0302}') => Some('\u{1E91}'),
        ('\u{007A}', '\u{0307}') => Some('\u{017C}'),
        ('\u{007A}', '\u{030C}') => Some('\u{017E}'),
        ('\u{007A}', '\u{0323}') => Some('\u{1E93}'),
        ('\u{007A}', '\u{0331}') => Some('\u{1E95}'),
        ('\u{00A8}', '\u{0300}') => Some('\u{1FED}'),
        ('\u{00A8}', '\u{0301}') => Some('\u{0385}'),
        ('\u{00A8}', '\u{0342}') => Some('\u{1FC1}'),
        ('\u{00C2}', '\u{0300}') => Some('\u{1EA6}'),
        ('\u{00C2}', '\u{0301}') => Some('\u{1EA4}'),
        ('\u{00C2}', '\u{0303}') => Some('\u{1EAA}'),
        ('\u{00C2}', '\u{0309}') => Some('\u{1EA8}'),
        ('\u{00C4}', '\u{0304}') => Some('\u{01DE}'),
        ('\u{00C5}', '\u{0301}') => Some('\u{01FA}'),
        ('\u{00C6}', '\u{0301}') => Some('\u{01FC}'),
        ('\u{00C6}', '\u{0304}') => Some('\u{01E2}'),
        ('\u{00C7}', '\u{0301}') => Some('\u{1E08}'),
        ('\u{00CA}', '\u{0300}') => Some('\u{1EC0}'),
        ('\u{00CA}', '\u{0301}') => Some('\u{1EBE}'),
        ('\u{00CA}', '\u{0303}') => Some('\u{1EC4}'),
        ('\u{00CA}', '\u{0309}') => Some('\u{1EC2}'),
        ('\u{00CF}', '\u{0301}') => Some('\u{1E2E}'),
        ('\u{00D4}', '\u{0300}') => Some('\u{1ED2}'),
        ('\u{00D4}', '\u{0301}') => Some('\u{1ED0}'),
        ('\u{00D4}', '\u{0303}') => Some('\u{1ED6}'),
        ('\u{00D4}', '\u{0309}') => Some('\u{1ED4}'),
        ('\u{00D5}', '\u{0301}') => Some('\u{1E4C}'),
        ('\u{00D5}', '\u{0304}') => Some('\u{022C}'),
        ('\u{00D5}', '\u{0308}') => Some('\u{1E4E}'),
        ('\u{00D6}', '\u{0304}') => Some('\u{022A}'),
        ('\u{00D8}', '\u{0301}') => Some('\u{01FE}'),
        ('\u{00DC}', '\u{0300}') => Some('\u{01DB}'),
        ('\u{00DC}', '\u{0301}') => Some('\u{01D7}'),
        ('\u{00DC}', '\u{0304}') => Some('\u{01D5}'),
        ('\u{00DC}', '\u{030C}') => Some('\u{01D9}'),
        ('\u{00E2}', '\u{0300}') => Some('\u{1EA7}'),
        ('\u{00E2}', '\u{0301}') => Some('\u{1EA5}'),
        ('\u{00E2}', '\u{0303}') => Some('\u{1EAB}'),
        ('\u{00E2}', '\u{0309}') => Some('\u{1EA9}'),
        ('\u{00E4}', '\u{0304}') => Some('\u{01DF}'),
        ('\u{00E5}', '\u{0301}') => Some('\u{01FB}'),
        ('\u{00E6}', '\u{0301}') => Some('\u{01FD}'),
        ('\u{00E6}', '\u{0304}') => Some('\u{01E3}'),
        ('\u{00E7}', '\u{0301}') => Some('\u{1E09}'),
        ('\u{00EA}', '\u{0300}') => Some('\u{1EC1}'),
        ('\u{00EA}', '\u{0301}') => Some('\u{1EBF}'),
        ('\u{00EA}', '\u{0303}') => Some('\u{1EC5}'),
        ('\u{00EA}', '\u{0309}') => Some('\u{1EC3}'),
        ('\u{00EF}', '\u{0301}') => Some('\u{1E2F}'),
        ('\u{00F4}', '\u{0300}') => Some('\u{1ED3}'),
        ('\u{00F4}', '\u{0301}') => Some('\u{1ED1}'),
        ('\u{00F4}', '\u{0303}') => Some('\u{1ED7}'),
        ('\u{00F4}', '\u{0309}') => Some('\u{1ED5}'),
        ('\u{00F5}', '\u{0301}') => Some('\u{1E4D}'),
        ('\u{00F5}', '\u{0304}') => Some('\u{022D}'),
        ('\u{00F5}', '\u{0308}') => Some('\u{1E4F}'),
        ('\u{00F6}', '\u{0304}') => Some('\u{022B}'),
        ('\u{00F8}', '\u{0301}') => Some('\u{01FF}'),
        ('\u{00FC}', '\u{0300}') => Some('\u{01DC}'),
        ('\u{00FC}', '\u{0301}') => Some('\u{01D8}'),
        ('\u{00FC}', '\u{0304}') => Some('\u{01D6}'),
        ('\u{00FC}', '\u{030C}') => Some('\u{01DA}'),
        ('\u{0102}', '\u{0300}') => Some('\u{1EB0}'),
        ('\u{0102}', '\u{0301}') => Some('\u{1EAE}'),
        ('\u{0102}', '\u{0303}') => Some('\u{1EB4}'),
        ('\u{0102}', '\u{0309}') => Some('\u{1EB2}'),
        ('\u{0103}', '\u{0300}') => Some('\u{1EB1}'),
        ('\u{0103}', '\u{0301}') => Some('\u{1EAF}'),
        ('\u{0103}', '\u{0303}') => Some('\u{1EB5}'),
        ('\u{0103}', '\u{0309}') => Some('\u{1EB3}'),
        ('\u{0112}', '\u{0300}') => Some('\u{1E14}'),
        ('\u{0112}', '\u{0301}') => Some('\u{1E16}'),
        ('\u{0113}', '\u{0300}') => Some('\u{1E15}'),
        ('\u{0113}', '\u{0301}') => Some('\u{1E17}'),
        ('\u{014C}', '\u{0300}') => Some('\u{1E50}'),
        ('\u{014C}', '\u{0301}') => Some('\u{1E52}'),
        ('\u{014D}', '\u{0300}') => Some('\u{1E51}'),
        ('\u{014D}', '\u{0301}') => Some('\u{1E53}'),
        ('\u{015A}', '\u{0307}') => Some('\u{1E64}'),
        ('\u{015B}', '\u{0307}') => Some('\u{1E65}'),
        ('\u{0160}', '\u{0307}') => Some('\u{1E66}'),
        ('\u{0161}', '\u{0307}') => Some('\u{1E67}'),
        ('\u{0168}', '\u{0301}') => Some('\u{1E78}'),
        ('\u{0169}', '\u{0301}') => Some('\u{1E79}'),
        ('\u{016A}', '\u{0308}') => Some('\u{1E7A}'),
        ('\u{016B}', '\u{0308}') => Some('\u{1E7B}'),
        ('\u{017F}', '\u{0307}') => Some('\u{1E9B}'),
        ('\u{01A0}', '\u{0300}') => Some('\u{1EDC}'),
        ('\u{01A0}', '\u{0301}') => Some('\u{1EDA}'),
        ('\u{01A0}', '\u{0303}') => Some('\u{1EE0}'),
        ('\u{01A0}', '\u{0309}') => Some('\u{1EDE}'),
        ('\u{01A0}', '\u{0323}') => Some('\u{1EE2}'),
        ('\u{01A1}', '\u{0300}') => Some('\u{1EDD}'),
        ('\u{01A1}', '\u{0301}') => Some('\u{1EDB}'),
        ('\u{01A1}', '\u{0303}') => Some('\u{1EE1}'),
        ('\u{01A1}', '\u{0309}') => Some('\u{1EDF}'),
        ('\u{01A1}', '\u{0323}') => Some('\u{1EE3}'),
        ('\u{01AF}', '\u{0300}') => Some('\u{1EEA}'),
        ('\u{01AF}', '\u{0301}') => Some('\u{1EE8}'),
        ('\u{01AF}', '\u{0303}') => Some('\u{1EEE}'),
        ('\u{01AF}', '\u{0309}') => Some('\u{1EEC}'),
        ('\u{01AF}', '\u{0323}') => Some('\u{1EF0}'),
        ('\u{01B0}', '\u{0300}') => Some('\u{1EEB}'),
        ('\u{01B0}', '\u{0301}') => Some('\u{1EE9}'),
        ('\u{01B0}', '\u{0303}') => Some('\u{1EEF}'),
        ('\u{01B0}', '\u{0309}') => Some('\u{1EED}'),
        ('\u{01B0}', '\u{0323}') => Some('\u{1EF1}'),
        ('\u{01B7}', '\u{030C}') => Some('\u{01EE}'),
        ('\u{01EA}', '\u{0304}') => Some('\u{01EC}'),
        ('\u{01EB}', '\u{0304}') => Some('\u{01ED}'),
        ('\u{0226}', '\u{0304}') => Some('\u{01E0}'),
        ('\u{0227}', '\u{0304}') => Some('\u{01E1}'),
        ('\u{0228}', '\u{0306}') => Some('\u{1E1C}'),
        ('\u{0229}', '\u{0306}') => Some('\u{1E1D}'),
        ('\u{022E}', '\u{0304}') => Some('\u{0230}'),
        ('\u{022F}', '\u{0304}') => Some('\u{0231}'),
        ('\u{0292}', '\u{030C}') => Some('\u{01EF}'),
        ('\u{0391}', '\u{0300}') => Some('\u{1FBA}'),
        ('\u{0391}', '\u{0301}') => Some('\u{0386}'),
        ('\u{0391}', '\u{0304}') => Some('\u{1FB9}'),
        ('\u{0391}', '\u{0306}') => Some('\u{1FB8}'),
        ('\u{0391}', '\u{0313}') => Some('\u{1F08}'),
        ('\u{0391}', '\u{0314}') => Some('\u{1F09}'),
        ('\u{0391}', '\u{0345}') => Some('\u{1FBC}'),
        ('\u{0395}', '\u{0300}') => Some('\u{1FC8}'),
        ('\u{0395}', '\u{0301}') => Some('\u{0388}'),
        ('\u{0395}', '\u{0313}') => Some('\u{1F18}'),
        ('\u{0395}', '\u{0314}') => Some('\u{1F19}'),
        ('\u{0397}', '\u{0300}') => Some('\u{1FCA}'),
        ('\u{0397}', '\u{0301}') => Some('\u{0389}'),
        ('\u{0397}', '\u{0313}') => Some('\u{1F28}'),
        ('\u{0397}', '\u{0314}') => Some('\u{1F29}'),
        ('\u{0397}', '\u{0345}') => Some('\u{1FCC}'),
        ('\u{0399}', '\u{0300}') => Some('\u{1FDA}'),
        ('\u{0399}', '\u{0301}') => Some('\u{038A}'),
        ('\u{0399}', '\u{0304}') => Some('\u{1FD9}'),
        ('\u{0399}', '\u{0306}') => Some('\u{1FD8}'),
        ('\u{0399}', '\u{0308}') => Some('\u{03AA}'),
        ('\u{0399}', '\u{0313}') => Some('\u{1F38}'),
        ('\u{0399}', '\u{0314}') => Some('\u{1F39}'),
        ('\u{039F}', '\u{0300}') => Some('\u{1FF8}'),
        ('\u{039F}', '\u{0301}') => Some('\u{038C}'),
        ('\u{039F}', '\u{0313}') => Some('\u{1F48}'),
        ('\u{039F}', '\u{0314}') => Some('\u{1F49}'),
        ('\u{03A1}', '\u{0314}') => Some('\u{1FEC}'),
        ('\u{03A5}', '\u{0300}') => Some('\u{1FEA}'),
        ('\u{03A5}', '\u{0301}') => Some('\u{038E}'),
        ('\u{03A5}', '\u{0304}') => Some('\u{1FE9}'),
        ('\u{03A5}', '\u{0306}') => Some('\u{1FE8}'),
        ('\u{03A5}', '\u{0308}') => Some('\u{03AB}'),
        ('\u{03A5}', '\u{0314}') => Some('\u{1F59}'),
        ('\u{03A9}', '\u{0300}') => Some('\u{1FFA}'),
        ('\u{03A9}', '\u{0301}') => Some('\u{038F}'),
        ('\u{03A9}', '\u{0313}') => Some('\u{1F68}'),
        ('\u{03A9}', '\u{0314}') => Some('\u{1F69}'),
        ('\u{03A9}', '\u{0345}') => Some('\u{1FFC}'),
        ('\u{03AC}', '\u{0345}') => Some('\u{1FB4}'),
        ('\u{03AE}', '\u{0345}') => Some('\u{1FC4}'),
        ('\u{03B1}', '\u{0300}') => Some('\u{1F70}'),
        ('\u{03B1}', '\u{0301}') => Some('\u{03AC}'),
        ('\u{03B1}', '\u{0304}') => Some('\u{1FB1}'),
        ('\u{03B1}', '\u{0306}') => Some('\u{1FB0}'),
        ('\u{03B1}', '\u{0313}') => Some('\u{1F00}'),
        ('\u{03B1}', '\u{0314}') => Some('\u{1F01}'),
        ('\u{03B1}', '\u{0342}') => Some('\u{1FB6}'),
        ('\u{03B1}', '\u{0345}') => Some('\u{1FB3}'),
        ('\u{03B5}', '\u{0300}') => Some('\u{1F72}'),
        ('\u{03B5}', '\u{0301}') => Some('\u{03AD}'),
        ('\u{03B5}', '\u{0313}') => Some('\u{1F10}'),
        ('\u{03B5}', '\u{0314}') => Some('\u{1F11}'),
        ('\u{03B7}', '\u{0300}') => Some('\u{1F74}'),
        ('\u{03B7}', '\u{0301}') => Some('\u{03AE}'),
        ('\u{03B7}', '\u{0313}') => Some('\u{1F20}'),
        ('\u{03B7}', '\u{0314}') => Some('\u{1F21}'),
        ('\u{03B7}', '\u{0342}') => Some('\u{1FC6}'),
        ('\u{03B7}', '\u{0345}') => Some('\u{1FC3}'),
        ('\u{03B9}', '\u{0300}') => Some('\u{1F76}'),
        ('\u{03B9}', '\u{0301}') => Some('\u{03AF}'),
        ('\u{03B9}', '\u{0304}') => Some('\u{1FD1}'),
        ('\u{03B9}', '\u{0306}') => Some('\u{1FD0}'),
        ('\u{03B9}', '\u{0308}') => Some('\u{03CA}'),
        ('\u{03B9}', '\u{0313}') => Some('\u{1F30}'),
        ('\u{03B9}', '\u{0314}') => Some('\u{1F31}'),
        ('\u{03B9}', '\u{0342}') => Some('\u{1FD6}'),
        ('\u{03BF}', '\u{0300}') => Some('\u{1F78}'),
        ('\u{03BF}', '\u{0301}') => Some('\u{03CC}'),
        ('\u{03BF}', '\u{0313}') => Some('\u{1F40}'),
        ('\u{03BF}', '\u{0314}') => Some('\u{1F41}'),
        ('\u{03C1}', '\u{0313}') => Some('\u{1FE4}'),
        ('\u{03C1}', '\u{0314}') => Some('\u{1FE5}'),
        ('\u{03C5}', '\u{0300}') => Some('\u{1F7A}'),
        ('\u{03C5}', '\u{0301}') => Some('\u{03CD}'),
        ('\u{03C5}', '\u{0304}') => Some('\u{1FE1}'),
        ('\u{03C5}', '\u{0306}') => Some('\u{1FE0}'),
        ('\u{03C5}', '\u{0308}') => Some('\u{03CB}'),
        ('\u{03C5}', '\u{0313}') => Some('\u{1F50}'),
        ('\u{03C5}', '\u{0314}') => Some('\u{1F51}'),
        ('\u{03C5}', '\u{0342}') => Some('\u{1FE6}'),
        ('\u{03C9}', '\u{0300}') => Some('\u{1F7C}'),
        ('\u{03C9}', '\u{0301}') => Some('\u{03CE}'),
        ('\u{03C9}', '\u{0313}') => Some('\u{1F60}'),
        ('\u{03C9}', '\u{0314}') => Some('\u{1F61}'),
        ('\u{03C9}', '\u{0342}') => Some('\u{1FF6}'),
        ('\u{03C9}', '\u{0345}') => Some('\u{1FF3}'),
        ('\u{03CA}', '\u{0300}') => Some('\u{1FD2}'),
        ('\u{03CA}', '\u{0301}') => Some('\u{0390}'),
        ('\u{03CA}', '\u{0342}') => Some('\u{1FD7}'),
        ('\u{03CB}', '\u{0300}') => Some('\u{1FE2}'),
        ('\u{03CB}', '\u{0301}') => Some('\u{03B0}'),
        ('\u{03CB}', '\u{0342}') => Some('\u{1FE7}'),
        ('\u{03CE}', '\u{0345}') => Some('\u{1FF4}'),
        ('\u{03D2}', '\u{0301}') => Some('\u{03D3}'),
        ('\u{03D2}', '\u{0308}') => Some('\u{03D4}'),
        ('\u{0406}', '\u{0308}') => Some('\u{0407}'),
        ('\u{0410}', '\u{0306}') => Some('\u{04D0}'),
        ('\u{0410}', '\u{0308}') => Some('\u{04D2}'),
        ('\u{0413}', '\u{0301}') => Some('\u{0403}'),
        ('\u{0415}', '\u{0300}') => Some('\u{0400}'),
        ('\u{0415}', '\u{0306}') => Some('\u{04D6}'),
        ('\u{0415}', '\u{0308}') => Some('\u{0401}'),
        ('\u{0416}', '\u{0306}') => Some('\u{04C1}'),
        ('\u{0416}', '\u{0308}') => Some('\u{04DC}'),
        ('\u{0417}', '\u{0308}') => Some('\u{04DE}'),
        ('\u{0418}', '\u{0300}') => Some('\u{040D}'),
        ('\u{0418}', '\u{0304}') => Some('\u{04E2}'),
        ('\u{0418}', '\u{0306}') => Some('\u{0419}'),
        ('\u{0418}', '\u{0308}') => Some('\u{04E4}'),
        ('\u{041A}', '\u{0301}') => Some('\u{040C}'),
        ('\u{041E}', '\u{0308}') => Some('\u{04E6}'),
        ('\u{0423}', '\u{0304}') => Some('\u{04EE}'),
        ('\u{0423}', '\u{0306}') => Some('\u{040E}'),
        ('\u{0423}', '\u{0308}') => Some('\u{04F0}'),
        ('\u{0423}', '\u{030B}') => Some('\u{04F2}'),
        ('\u{0427}', '\u{0308}') => Some('\u{04F4}'),
        ('\u{042B}', '\u{0308}') => Some('\u{04F8}'),
        ('\u{042D}', '\u{0308}') => Some('\u{04EC}'),
        ('\u{0430}', '\u{0306}') => Some('\u{04D1}'),
        ('\u{0430}', '\u{0308}') => Some('\u{04D3}'),
        ('\u{0433}', '\u{0301}') => Some('\u{0453}'),
        ('\u{0435}', '\u{0300}') => Some('\u{0450}'),
        ('\u{0435}', '\u{0306}') => Some('\u{04D7}'),
        ('\u{0435}', '\u{0308}') => Some('\u{0451}'),
        ('\u{0436}', '\u{0306}') => Some('\u{04C2}'),
        ('\u{0436}', '\u{0308}') => Some('\u{04DD}'),
        ('\u{0437}', '\u{0308}') => Some('\u{04DF}'),
        ('\u{0438}', '\u{0300}') => Some('\u{045D}'),
        ('\u{0438}', '\u{0304}') => Some('\u{04E3}'),
        ('\u{0438}', '\u{0306}') => Some('\u{0439}'),
        ('\u{0438}', '\u{0308}') => Some('\u{04E5}'),
        ('\u{043A}', '\u{0301}') => Some('\u{045C}'),
        ('\u{043E}', '\u{0308}') => Some('\u{04E7}'),
        ('\u{0443}', '\u{0304}') => Some('\u{04EF}'),
        ('\u{0443}', '\u{0306}') => Some('\u{045E}'),
        ('\u{0443}', '\u{0308}') => Some('\u{04F1}'),
        ('\u{0443}', '\u{030B}') => Some('\u{04F3}'),
        ('\u{0447}', '\u{0308}') => Some('\u{04F5}'),
        ('\u{044B}', '\u{0308}') => Some('\u{04F9}'),
        ('\u{044D}', '\u{0308}') => Some('\u{04ED}'),
        ('\u{0456}', '\u{0308}') => Some('\u{0457}'),
        ('\u{0474}', '\u{030F}') => Some('\u{0476}'),
        ('\u{0475}', '\u{030F}') => Some('\u{0477}'),
        ('\u{04D8}', '\u{0308}') => Some('\u{04DA}'),
        ('\u{04D9}', '\u{0308}') => Some('\u{04DB}'),
        ('\u{04E8}', '\u{0308}') => Some('\u{04EA}'),
        ('\u{04E9}', '\u{0308}') => Some('\u{04EB}'),
        ('\u{0627}', '\u{0653}') => Some('\u{0622}'),
        ('\u{0627}', '\u{0654}') => Some('\u{0623}'),
        ('\u{0627}', '\u{0655}') => Some('\u{0625}'),
        ('\u{0648}', '\u{0654}') => Some('\u{0624}'),
        ('\u{064A}', '\u{0654}') => Some('\u{0626}'),
        ('\u{06C1}', '\u{0654}') => Some('\u{06C2}'),
        ('\u{06D2}', '\u{0654}') => Some('\u{06D3}'),
        ('\u{06D5}', '\u{0654}') => Some('\u{06C0}'),
        ('\u{0928}', '\u{093C}') => Some('\u{0929}'),
        ('\u{0930}', '\u{093C}') => Some('\u{0931}'),
        ('\u{0933}', '\u{093C}') => Some('\u{0934}'),
        ('\u{09C7}', '\u{09BE}') => Some('\u{09CB}'),
        ('\u{09C7}', '\u{09D7}') => Some('\u{09CC}'),
        ('\u{0B47}', '\u{0B3E}') => Some('\u{0B4B}'),
        ('\u{0B47}', '\u{0B56}') => Some('\u{0B48}'),
        ('\u{0B47}', '\u{0B57}') => Some('\u{0B4C}'),
        ('\u{0B92}', '\u{0BD7}') => Some('\u{0B94}'),
        ('\u{0BC6}', '\u{0BBE}') => Some('\u{0BCA}'),
        ('\u{0BC6}', '\u{0BD7}') => Some('\u{0BCC}'),
        ('\u{0BC7}', '\u{0BBE}') => Some('\u{0BCB}'),
        ('\u{0C46}', '\u{0C56}') => Some('\u{0C48}'),
        ('\u{0CBF}', '\u{0CD5}') => Some('\u{0CC0}'),
        ('\u{0CC6}', '\u{0CC2}') => Some('\u{0CCA}'),
        ('\u{0CC6}', '\u{0CD5}') => Some('\u{0CC7}'),
        ('\u{0CC6}', '\u{0CD6}') => Some('\u{0CC8}'),
        ('\u{0CCA}', '\u{0CD5}') => Some('\u{0CCB}'),
        ('\u{0D46}', '\u{0D3E}') => Some('\u{0D4A}'),
        ('\u{0D46}', '\u{0D57}') => Some('\u{0D4C}'),
        ('\u{0D47}', '\u{0D3E}') => Some('\u{0D4B}'),
        ('\u{0DD9}', '\u{0DCA}') => Some('\u{0DDA}'),
        ('\u{0DD9}', '\u{0DCF}') => Some('\u{0DDC}'),
        ('\u{0DD9}', '\u{0DDF}') => Some('\u{0DDE}'),
        ('\u{0DDC}', '\u{0DCA}') => Some('\u{0DDD}'),
        ('\u{1025}', '\u{102E}') => Some('\u{1026}'),
        ('\u{1B05}', '\u{1B35}') => Some('\u{1B06}'),
        ('\u{1B07}', '\u{1B35}') => Some('\u{1B08}'),
        ('\u{1B09}', '\u{1B35}') => Some('\u{1B0A}'),
        ('\u{1B0B}', '\u{1B35}') => Some('\u{1B0C}'),
        ('\u{1B0D}', '\u{1B35}') => Some('\u{1B0E}'),
        ('\u{1B11}', '\u{1B35}') => Some('\u{1B12}'),
        ('\u{1B3A}', '\u{1B35}') => Some('\u{1B3B}'),
        ('\u{1B3C}', '\u{1B35}') => Some('\u{1B3D}'),
        ('\u{1B3E}', '\u{1B35}') => Some('\u{1B40}'),
        ('\u{1B3F}', '\u{1B35}') => Some('\u{1B41}'),
        ('\u{1B42}', '\u{1B35}') => Some('\u{1B43}'),
        ('\u{1E36}', '\u{0304}') => Some('\u{1E38}'),
        ('\u{1E37}', '\u{0304}') => Some('\u{1E39}'),
        ('\u{1E5A}', '\u{0304}') => Some('\u{1E5C}'),
        ('\u{1E5B}', '\u{0304}') => Some('\u{1E5D}'),
        ('\u{1E62}', '\u{0307}') => Some('\u{1E68}'),
        ('\u{1E63}', '\u{0307}') => Some('\u{1E69}'),
        ('\u{1EA0}', '\u{0302}') => Some('\u{1EAC}'),
        ('\u{1EA0}', '\u{0306}') => Some('\u{1EB6}'),
        ('\u{1EA1}', '\u{0302}') => Some('\u{1EAD}'),
        ('\u{1EA1}', '\u{0306}') => Some('\u{1EB7}'),
        ('\u{1EB8}', '\u{0302}') => Some('\u{1EC6}'),
        ('\u{1EB9}', '\u{0302}') => Some('\u{1EC7}'),
        ('\u{1ECC}', '\u{0302}') => Some('\u{1ED8}'),
        ('\u{1ECD}', '\u{0302}') => Some('\u{1ED9}'),
        ('\u{1F00}', '\u{0300}') => Some('\u{1F02}'),
        ('\u{1F00}', '\u{0301}') => Some('\u{1F04}'),
        ('\u{1F00}', '\u{0342}') => Some('\u{1F06}'),
        ('\u{1F00}', '\u{0345}') => Some('\u{1F80}'),
        ('\u{1F01}', '\u{0300}') => Some('\u{1F03}'),
        ('\u{1F01}', '\u{0301}') => Some('\u{1F05}'),
        ('\u{1F01}', '\u{0342}') => Some('\u{1F07}'),
        ('\u{1F01}', '\u{0345}') => Some('\u{1F81}'),
        ('\u{1F02}', '\u{0345}') => Some('\u{1F82}'),
        ('\u{1F03}', '\u{0345}') => Some('\u{1F83}'),
        ('\u{1F04}', '\u{0345}') => Some('\u{1F84}'),
        ('\u{1F05}', '\u{0345}') => Some('\u{1F85}'),
        ('\u{1F06}', '\u{0345}') => Some('\u{1F86}'),
        ('\u{1F07}', '\u{0345}') => Some('\u{1F87}'),
        ('\u{1F08}', '\u{0300}') => Some('\u{1F0A}'),
        ('\u{1F08}', '\u{0301}') => Some('\u{1F0C}'),
        ('\u{1F08}', '\u{0342}') => Some('\u{1F0E}'),
        ('\u{1F08}', '\u{0345}') => Some('\u{1F88}'),
        ('\u{1F09}', '\u{0300}') => Some('\u{1F0B}'),
        ('\u{1F09}', '\u{0301}') => Some('\u{1F0D}'),
        ('\u{1F09}', '\u{0342}') => Some('\u{1F0F}'),
        ('\u{1F09}', '\u{0345}') => Some('\u{1F89}'),
        ('\u{1F0A}', '\u{0345}') => Some('\u{1F8A}'),
        ('\u{1F0B}', '\u{0345}') => Some('\u{1F8B}'),
        ('\u{1F0C}', '\u{0345}') => Some('\u{1F8C}'),
        ('\u{1F0D}', '\u{0345}') => Some('\u{1F8D}'),
        ('\u{1F0E}', '\u{0345}') => Some('\u{1F8E}'),
        ('\u{1F0F}', '\u{0345}') => Some('\u{1F8F}'),
        ('\u{1F10}', '\u{0300}') => Some('\u{1F12}'),
        ('\u{1F10}', '\u{0301}') => Some('\u{1F14}'),
        ('\u{1F11}', '\u{0300}') => Some('\u{1F13}'),
        ('\u{1F11}', '\u{0301}') => Some('\u{1F15}'),
        ('\u{1F18}', '\u{0300}') => Some('\u{1F1A}'),
        ('\u{1F18}', '\u{0301}') => Some('\u{1F1C}'),
        ('\u{1F19}', '\u{0300}') => Some('\u{1F1B}'),
        ('\u{1F19}', '\u{0301}') => Some('\u{1F1D}'),
        ('\u{1F20}', '\u{0300}') => Some('\u{1F22}'),
        ('\u{1F20}', '\u{0301}') => Some('\u{1F24}'),
        ('\u{1F20}', '\u{0342}') => Some('\u{1F26}'),
        ('\u{1F20}', '\u{0345}') => Some('\u{1F90}'),
        ('\u{1F21}', '\u{0300}') => Some('\u{1F23}'),
        ('\u{1F21}', '\u{0301}') => Some('\u{1F25}'),
        ('\u{1F21}', '\u{0342}') => Some('\u{1F27}'),
        ('\u{1F21}', '\u{0345}') => Some('\u{1F91}'),
        ('\u{1F22}', '\u{0345}') => Some('\u{1F92}'),
        ('\u{1F23}', '\u{0345}') => Some('\u{1F93}'),
        ('\u{1F24}', '\u{0345}') => Some('\u{1F94}'),
        ('\u{1F25}', '\u{0345}') => Some('\u{1F95}'),
        ('\u{1F26}', '\u{0345}') => Some('\u{1F96}'),
        ('\u{1F27}', '\u{0345}') => Some('\u{1F97}'),
        ('\u{1F28}', '\u{0300}') => Some('\u{1F2A}'),
        ('\u{1F28}', '\u{0301}') => Some('\u{1F2C}'),
        ('\u{1F28}', '\u{0342}') => Some('\u{1F2E}'),
        ('\u{1F28}', '\u{0345}') => Some('\u{1F98}'),
        ('\u{1F29}', '\u{0300}') => Some('\u{1F2B}'),
        ('\u{1F29}', '\u{0301}') => Some('\u{1F2D}'),
        ('\u{1F29}', '\u{0342}') => Some('\u{1F2F}'),
        ('\u{1F29}', '\u{0345}') => Some('\u{1F99}'),
        ('\u{1F2A}', '\u{0345}') => Some('\u{1F9A}'),
        ('\u{1F2B}', '\u{0345}') => Some('\u{1F9B}'),
        ('\u{1F2C}', '\u{0345}') => Some('\u{1F9C}'),
        ('\u{1F2D}', '\u{0345}') => Some('\u{1F9D}'),
        ('\u{1F2E}', '\u{0345}') => Some('\u{1F9E}'),
        ('\u{1F2F}', '\u{0345}') => Some('\u{1F9F}'),
        ('\u{1F30}', '\u{0300}') => Some('\u{1F32}'),
        ('\u{1F30}', '\u{0301}') => Some('\u{1F34}'),
        ('\u{1F30}', '\u{0342}') => Some('\u{1F36}'),
        ('\u{1F31}', '\u{0300}') => Some('\u{1F33}'),
        ('\u{1F31}', '\u{0301}') => Some('\u{1F35}'),
        ('\u{1F31}', '\u{0342}') => Some('\u{1F37}'),
        ('\u{1F38}', '\u{0300}') => Some('\u{1F3A}'),
        ('\u{1F38}', '\u{0301}') => Some('\u{1F3C}'),
        ('\u{1F38}', '\u{0342}') => Some('\u{1F3E}'),
        ('\u{1F39}', '\u{0300}') => Some('\u{1F3B}'),
        ('\u{1F39}', '\u{0301}') => Some('\u{1F3D}'),
        ('\u{1F39}', '\u{0342}') => Some('\u{1F3F}'),
        ('\u{1F40}', '\u{0300}') => Some('\u{1F42}'),
        ('\u{1F40}', '\u{0301}') => Some('\u{1F44}'),
        ('\u{1F41}', '\u{0300}') => Some('\u{1F43}'),
        ('\u{1F41}', '\u{0301}') => Some('\u{1F45}'),
        ('\u{1F48}', '\u{0300}') => Some('\u{1F4A}'),
        ('\u{1F48}', '\u{0301}') => Some('\u{1F4C}'),
        ('\u{1F49}', '\u{0300}') => Some('\u{1F4B}'),
        ('\u{1F49}', '\u{0301}') => Some('\u{1F4D}'),
        ('\u{1F50}', '\u{0300}') => Some('\u{1F52}'),
        ('\u{1F50}', '\u{0301}') => Some('\u{1F54}'),
        ('\u{1F50}', '\u{0342}') => Some('\u{1F56}'),
        ('\u{1F51}', '\u{0300}') => Some('\u{1F53}'),
        ('\u{1F51}', '\u{0301}') => Some('\u{1F55}'),
        ('\u{1F51}', '\u{0342}') => Some('\u{1F57}'),
        ('\u{1F59}', '\u{0300}') => Some('\u{1F5B}'),
        ('\u{1F59}', '\u{0301}') => Some('\u{1F5D}'),
        ('\u{1F59}', '\u{0342}') => Some('\u{1F5F}'),
        ('\u{1F60}', '\u{0300}') => Some('\u{1F62}'),
        ('\u{1F60}', '\u{0301}') => Some('\u{1F64}'),
        ('\u{1F60}', '\u{0342}') => Some('\u{1F66}'),
        ('\u{1F60}', '\u{0345}') => Some('\u{1FA0}'),
        ('\u{1F61}', '\u{0300}') => Some('\u{1F63}'),
        ('\u{1F61}', '\u{0301}') => Some('\u{1F65}'),
        ('\u{1F61}', '\u{0342}') => Some('\u{1F67}'),
        ('\u{1F61}', '\u{0345}') => Some('\u{1FA1}'),
        ('\u{1F62}', '\u{0345}') => Some('\u{1FA2}'),
        ('\u{1F63}', '\u{0345}') => Some('\u{1FA3}'),
        ('\u{1F64}', '\u{0345}') => Some('\u{1FA4}'),
        ('\u{1F65}', '\u{0345}') => Some('\u{1FA5}'),
        ('\u{1F66}', '\u{0345}') => Some('\u{1FA6}'),
        ('\u{1F67}', '\u{0345}') => Some('\u{1FA7}'),
        ('\u{1F68}', '\u{0300}') => Some('\u{1F6A}'),
        ('\u{1F68}', '\u{0301}') => Some('\u{1F6C}'),
        ('\u{1F68}', '\u{0342}') => Some('\u{1F6E}'),
        ('\u{1F68}', '\u{0345}') => Some('\u{1FA8}'),
        ('\u{1F69}', '\u{0300}') => Some('\u{1F6B}'),
        ('\u{1F69}', '\u{0301}') => Some('\u{1F6D}'),
        ('\u{1F69}', '\u{0342}') => Some('\u{1F6F}'),
        ('\u{1F69}', '\u{0345}') => Some('\u{1FA9}'),
        ('\u{1F6A}', '\u{0345}') => Some('\u{1FAA}'),
        ('\u{1F6B}', '\u{0345}') => Some('\u{1FAB}'),
        ('\u{1F6C}', '\u{0345}') => Some('\u{1FAC}'),
        ('\u{1F6D}', '\u{0345}') => Some('\u{1FAD}'),
        ('\u{1F6E}', '\u{0345}') => Some('\u{1FAE}'),
        ('\u{1F6F}', '\u{0345}') => Some('\u{1FAF}'),
        ('\u{1F70}', '\u{0345}') => Some('\u{1FB2}'),
        ('\u{1F74}', '\u{0345}') => Some('\u{1FC2}'),
        ('\u{1F7C}', '\u{0345}') => Some('\u{1FF2}'),
        ('\u{1FB6}', '\u{0345}') => Some('\u{1FB7}'),
        ('\u{1FBF}', '\u{0300}') => Some('\u{1FCD}'),
        ('\u{1FBF}', '\u{0301}') => Some('\u{1FCE}'),
        ('\u{1FBF}', '\u{0342}') => Some('\u{1FCF}'),
        ('\u{1FC6}', '\u{0345}') => Some('\u{1FC7}'),
        ('\u{1FF6}', '\u{0345}') => Some('\u{1FF7}'),
        ('\u{1FFE}', '\u{0300}') => Some('\u{1FDD}'),
        ('\u{1FFE}', '\u{0301}') => Some('\u{1FDE}'),
        ('\u{1FFE}', '\u{0342}') => Some('\u{1FDF}'),
        ('\u{2190}', '\u{0338}') => Some('\u{219A}'),
        ('\u{2192}', '\u{0338}') => Some('\u{219B}'),
        ('\u{2194}', '\u{0338}') => Some('\u{21AE}'),
        ('\u{21D0}', '\u{0338}') => Some('\u{21CD}'),
        ('\u{21D2}', '\u{0338}') => Some('\u{21CF}'),
        ('\u{21D4}', '\u{0338}') => Some('\u{21CE}'),
        ('\u{2203}', '\u{0338}') => Some('\u{2204}'),
        ('\u{2208}', '\u{0338}') => Some('\u{2209}'),
        ('\u{220B}', '\u{0338}') => Some('\u{220C}'),
        ('\u{2223}', '\u{0338}') => Some('\u{2224}'),
        ('\u{2225}', '\u{0338}') => Some('\u{2226}'),
        ('\u{223C}', '\u{0338}') => Some('\u{2241}'),
        ('\u{2243}', '\u{0338}') => Some('\u{2244}'),
        ('\u{2245}', '\u{0338}') => Some('\u{2247}'),
        ('\u{2248}', '\u{0338}') => Some('\u{2249}'),
        ('\u{224D}', '\u{0338}') => Some('\u{226D}'),
        ('\u{2261}', '\u{0338}') => Some('\u{2262}'),
        ('\u{2264}', '\u{0338}') => Some('\u{2270}'),
        ('\u{2265}', '\u{0338}') => Some('\u{2271}'),
        ('\u{2272}', '\u{0338}') => Some('\u{2274}'),
        ('\u{2273}', '\u{0338}') => Some('\u{2275}'),
        ('\u{2276}', '\u{0338}') => Some('\u{2278}'),
        ('\u{2277}', '\u{0338}') => Some('\u{2279}'),
        ('\u{227A}', '\u{0338}') => Some('\u{2280}'),
        ('\u{227B}', '\u{0338}') => Some('\u{2281}'),
        ('\u{227C}', '\u{0338}') => Some('\u{22E0}'),
        ('\u{227D}', '\u{0338}') => Some('\u{22E1}'),
        ('\u{2282}', '\u{0338}') => Some('\u{2284}'),
        ('\u{2283}', '\u{0338}') => Some('\u{2285}'),
        ('\u{2286}', '\u{0338}') => Some('\u{2288}'),
        ('\u{2287}', '\u{0338}') => Some('\u{2289}'),
        ('\u{2291}', '\u{0338}') => Some('\u{22E2}'),
        ('\u{2292}', '\u{0338}') => Some('\u{22E3}'),
        ('\u{22A2}', '\u{0338}') => Some('\u{22AC}'),
        ('\u{22A8}', '\u{0338}') => Some('\u{22AD}'),
        ('\u{22A9}', '\u{0338}') => Some('\u{22AE}'),
        ('\u{22AB}', '\u{0338}') => Some('\u{22AF}'),
        ('\u{22B2}', '\u{0338}') => Some('\u{22EA}'),
        ('\u{22B3}', '\u{0338}') => Some('\u{22EB}'),
        ('\u{22B4}', '\u{0338}') => Some('\u{22EC}'),
        ('\u{22B5}', '\u{0338}') => Some('\u{22ED}'),
        ('\u{3046}', '\u{3099}') => Some('\u{3094}'),
        ('\u{304B}', '\u{3099}') => Some('\u{304C}'),
        ('\u{304D}', '\u{3099}') => Some('\u{304E}'),
        ('\u{304F}', '\u{3099}') => Some('\u{3050}'),
        ('\u{3051}', '\u{3099}') => Some('\u{3052}'),
        ('\u{3053}', '\u{3099}') => Some('\u{3054}'),
        ('\u{3055}', '\u{3099}') => Some('\u{3056}'),
        ('\u{3057}', '\u{3099}') => Some('\u{3058}'),
        ('\u{3059}', '\u{3099}') => Some('\u{305A}'),
        ('\u{305B}', '\u{3099}') => Some('\u{305C}'),
        ('\u{305D}', '\u{3099}') => Some('\u{305E}'),
        ('\u{305F}', '\u{3099}') => Some('\u{3060}'),
        ('\u{3061}', '\u{3099}') => Some('\u{3062}'),
        ('\u{3064}', '\u{3099}') => Some('\u{3065}'),
        ('\u{3066}', '\u{3099}') => Some('\u{3067}'),
        ('\u{3068}', '\u{3099}') => Some('\u{3069}'),
        ('\u{306F}', '\u{3099}') => Some('\u{3070}'),
        ('\u{306F}', '\u{309A}') => Some('\u{3071}'),
        ('\u{3072}', '\u{3099}') => Some('\u{3073}'),
        ('\u{3072}', '\u{309A}') => Some('\u{3074}'),
        ('\u{3075}', '\u{3099}') => Some('\u{3076}'),
        ('\u{3075}', '\u{309A}') => Some('\u{3077}'),
        ('\u{3078}', '\u{3099}') => Some('\u{3079}'),
        ('\u{3078}', '\u{309A}') => Some('\u{307A}'),
        ('\u{307B}', '\u{3099}') => Some('\u{307C}'),
        ('\u{307B}', '\u{309A}') => Some('\u{307D}'),
        ('\u{309D}', '\u{3099}') => Some('\u{309E}'),
        ('\u{30A6}', '\u{3099}') => Some('\u{30F4}'),
        ('\u{30AB}', '\u{3099}') => Some('\u{30AC}'),
        ('\u{30AD}', '\u{3099}') => Some('\u{30AE}'),
        ('\u{30AF}', '\u{3099}') => Some('\u{30B0}'),
        ('\u{30B1}', '\u{3099}') => Some('\u{30B2}'),
        ('\u{30B3}', '\u{3099}') => Some('\u{30B4}'),
        ('\u{30B5}', '\u{3099}') => Some('\u{30B6}'),
        ('\u{30B7}', '\u{3099}') => Some('\u{30B8}'),
        ('\u{30B9}', '\u{3099}') => Some('\u{30BA}'),
        ('\u{30BB}', '\u{3099}') => Some('\u{30BC}'),
        ('\u{30BD}', '\u{3099}') => Some('\u{30BE}'),
        ('\u{30BF}', '\u{3099}') => Some('\u{30C0}'),
        ('\u{30C1}', '\u{3099}') => Some('\u{30C2}'),
        ('\u{30C4}', '\u{3099}') => Some('\u{30C5}'),
        ('\u{30C6}', '\u{3099}') => Some('\u{30C7}'),
        ('\u{30C8}', '\u{3099}') => Some('\u{30C9}'),
        ('\u{30CF}', '\u{3099}') => Some('\u{30D0}'),
        ('\u{30CF}', '\u{309A}') => Some('\u{30D1}'),
        ('\u{30D2}', '\u{3099}') => Some('\u{30D3}'),
        ('\u{30D2}', '\u{309A}') => Some('\u{30D4}'),
        ('\u{30D5}', '\u{3099}') => Some('\u{30D6}'),
        ('\u{30D5}', '\u{309A}') => Some('\u{30D7}'),
        ('\u{30D8}', '\u{3099}') => Some('\u{30D9}'),
        ('\u{30D8}', '\u{309A}') => Some('\u{30DA}'),
        ('\u{30DB}', '\u{3099}') => Some('\u{30DC}'),
        ('\u{30DB}', '\u{309A}') => Some('\u{30DD}'),
        ('\u{30EF}', '\u{3099}') => Some('\u{30F7}'),
        ('\u{30F0}', '\u{3099}') => Some('\u{30F8}'),
        ('\u{30F1}', '\u{3099}') => Some('\u{30F9}'),
        ('\u{30F2}', '\u{3099}') => Some('\u{30FA}'),
        ('\u{30FD}', '\u{3099}') => Some('\u{30FE}'),
        ('\u{11099}', '\u{110BA}') => Some('\u{1109A}'),
        ('\u{1109B}', '\u{110BA}') => Some('\u{1109C}'),
        ('\u{110A5}', '\u{110BA}') => Some('\u{110AB}'),
        ('\u{11131}', '\u{11127}') => Some('\u{1112E}'),
        ('\u{11132}', '\u{11127}') => Some('\u{1112F}'),
        ('\u{11347}', '\u{1133E}') => Some('\u{1134B}'),
        ('\u{11347}', '\u{11357}') => Some('\u{1134C}'),
        ('\u{114B9}', '\u{114B0}') => Some('\u{114BC}'),
        ('\u{114B9}', '\u{114BA}') => Some('\u{114BB}'),
        ('\u{114B9}', '\u{114BD}') => Some('\u{114BE}'),
        ('\u{115B8}', '\u{115AF}') => Some('\u{115BA}'),
        ('\u{115B9}', '\u{115AF}') => Some('\u{115BB}'),
        _ => None,
    }
}

#[inline]
pub fn canonical_fully_decomposed(c: char) -> Option<&'static [char]> {
    match c {
        '\u{00C0}' => Some(&['\u{0041}', '\u{0300}']),
        '\u{00C1}' => Some(&['\u{0041}', '\u{0301}']),
        '\u{00C2}' => Some(&['\u{0041}', '\u{0302}']),
        '\u{00C3}' => Some(&['\u{0041}', '\u{0303}']),
        '\u{00C4}' => Some(&['\u{0041}', '\u{0308}']),
        '\u{00C5}' => Some(&['\u{0041}', '\u{030A}']),
        '\u{00C7}' => Some(&['\u{0043}', '\u{0327}']),
        '\u{00C8}' => Some(&['\u{0045}', '\u{0300}']),
        '\u{00C9}' => Some(&['\u{0045}', '\u{0301}']),
        '\u{00CA}' => Some(&['\u{0045}', '\u{0302}']),
        '\u{00CB}' => Some(&['\u{0045}', '\u{0308}']),
        '\u{00CC}' => Some(&['\u{0049}', '\u{0300}']),
        '\u{00CD}' => Some(&['\u{0049}', '\u{0301}']),
        '\u{00CE}' => Some(&['\u{0049}', '\u{0302}']),
        '\u{00CF}' => Some(&['\u{0049}', '\u{0308}']),
        '\u{00D1}' => Some(&['\u{004E}', '\u{0303}']),
        '\u{00D2}' => Some(&['\u{004F}', '\u{0300}']),
        '\u{00D3}' => Some(&['\u{004F}', '\u{0301}']),
        '\u{00D4}' => Some(&['\u{004F}', '\u{0302}']),
        '\u{00D5}' => Some(&['\u{004F}', '\u{0303}']),
        '\u{00D6}' => Some(&['\u{004F}', '\u{0308}']),
        '\u{00D9}' => Some(&['\u{0055}', '\u{0300}']),
        '\u{00DA}' => Some(&['\u{0055}', '\u{0301}']),
        '\u{00DB}' => Some(&['\u{0055}', '\u{0302}']),
        '\u{00DC}' => Some(&['\u{0055}', '\u{0308}']),
        '\u{00DD}' => Some(&['\u{0059}', '\u{0301}']),
        '\u{00E0}' => Some(&['\u{0061}', '\u{0300}']),
        '\u{00E1}' => Some(&['\u{0061}', '\u{0301}']),
        '\u{00E2}' => Some(&['\u{0061}', '\u{0302}']),
        '\u{00E3}' => Some(&['\u{0061}', '\u{0303}']),
        '\u{00E4}' => Some(&['\u{0061}', '\u{0308}']),
        '\u{00E5}' => Some(&['\u{0061}', '\u{030A}']),
        '\u{00E7}' => Some(&['\u{0063}', '\u{0327}']),
        '\u{00E8}' => Some(&['\u{0065}', '\u{0300}']),
        '\u{00E9}' => Some(&['\u{0065}', '\u{0301}']),
        '\u{00EA}' => Some(&['\u{0065}', '\u{0302}']),
        '\u{00EB}' => Some(&['\u{0065}', '\u{0308}']),
        '\u{00EC}' => Some(&['\u{0069}', '\u{0300}']),
        '\u{00ED}' => Some(&['\u{0069}', '\u{0301}']),
        '\u{00EE}' => Some(&['\u{0069}', '\u{0302}']),
        '\u{00EF}' => Some(&['\u{0069}', '\u{0308}']),
        '\u{00F1}' => Some(&['\u{006E}', '\u{0303}']),
        '\u{00F2}' => Some(&['\u{006F}', '\u{0300}']),
        '\u{00F3}' => Some(&['\u{006F}', '\u{0301}']),
        '\u{00F4}' => Some(&['\u{006F}', '\u{0302}']),
        '\u{00F5}' => Some(&['\u{006F}', '\u{0303}']),
        '\u{00F6}' => Some(&['\u{006F}', '\u{0308}']),
        '\u{00F9}' => Some(&['\u{0075}', '\u{0300}']),
        '\u{00FA}' => Some(&['\u{0075}', '\u{0301}']),
        '\u{00FB}' => Some(&['\u{0075}', '\u{0302}']),
        '\u{00FC}' => Some(&['\u{0075}', '\u{0308}']),
        '\u{00FD}' => Some(&['\u{0079}', '\u{0301}']),
        '\u{00FF}' => Some(&['\u{0079}', '\u{0308}']),
        '\u{0100}' => Some(&['\u{0041}', '\u{0304}']),
        '\u{0101}' => Some(&['\u{0061}', '\u{0304}']),
        '\u{0102}' => Some(&['\u{0041}', '\u{0306}']),
        '\u{0103}' => Some(&['\u{0061}', '\u{0306}']),
        '\u{0104}' => Some(&['\u{0041}', '\u{0328}']),
        '\u{0105}' => Some(&['\u{0061}', '\u{0328}']),
        '\u{0106}' => Some(&['\u{0043}', '\u{0301}']),
        '\u{0107}' => Some(&['\u{0063}', '\u{0301}']),
        '\u{0108}' => Some(&['\u{0043}', '\u{0302}']),
        '\u{0109}' => Some(&['\u{0063}', '\u{0302}']),
        '\u{010A}' => Some(&['\u{0043}', '\u{0307}']),
        '\u{010B}' => Some(&['\u{0063}', '\u{0307}']),
        '\u{010C}' => Some(&['\u{0043}', '\u{030C}']),
        '\u{010D}' => Some(&['\u{0063}', '\u{030C}']),
        '\u{010E}' => Some(&['\u{0044}', '\u{030C}']),
        '\u{010F}' => Some(&['\u{0064}', '\u{030C}']),
        '\u{0112}' => Some(&['\u{0045}', '\u{0304}']),
        '\u{0113}' => Some(&['\u{0065}', '\u{0304}']),
        '\u{0114}' => Some(&['\u{0045}', '\u{0306}']),
        '\u{0115}' => Some(&['\u{0065}', '\u{0306}']),
        '\u{0116}' => Some(&['\u{0045}', '\u{0307}']),
        '\u{0117}' => Some(&['\u{0065}', '\u{0307}']),
        '\u{0118}' => Some(&['\u{0045}', '\u{0328}']),
        '\u{0119}' => Some(&['\u{0065}', '\u{0328}']),
        '\u{011A}' => Some(&['\u{0045}', '\u{030C}']),
        '\u{011B}' => Some(&['\u{0065}', '\u{030C}']),
        '\u{011C}' => Some(&['\u{0047}', '\u{0302}']),
        '\u{011D}' => Some(&['\u{0067}', '\u{0302}']),
        '\u{011E}' => Some(&['\u{0047}', '\u{0306}']),
        '\u{011F}' => Some(&['\u{0067}', '\u{0306}']),
        '\u{0120}' => Some(&['\u{0047}', '\u{0307}']),
        '\u{0121}' => Some(&['\u{0067}', '\u{0307}']),
        '\u{0122}' => Some(&['\u{0047}', '\u{0327}']),
        '\u{0123}' => Some(&['\u{0067}', '\u{0327}']),
        '\u{0124}' => Some(&['\u{0048}', '\u{0302}']),
        '\u{0125}' => Some(&['\u{0068}', '\u{0302}']),
        '\u{0128}' => Some(&['\u{0049}', '\u{0303}']),
        '\u{0129}' => Some(&['\u{0069}', '\u{0303}']),
        '\u{012A}' => Some(&['\u{0049}', '\u{0304}']),
        '\u{012B}' => Some(&['\u{0069}', '\u{0304}']),
        '\u{012C}' => Some(&['\u{0049}', '\u{0306}']),
        '\u{012D}' => Some(&['\u{0069}', '\u{0306}']),
        '\u{012E}' => Some(&['\u{0049}', '\u{0328}']),
        '\u{012F}' => Some(&['\u{0069}', '\u{0328}']),
        '\u{0130}' => Some(&['\u{0049}', '\u{0307}']),
        '\u{0134}' => Some(&['\u{004A}', '\u{0302}']),
        '\u{0135}' => Some(&['\u{006A}', '\u{0302}']),
        '\u{0136}' => Some(&['\u{004B}', '\u{0327}']),
        '\u{0137}' => Some(&['\u{006B}', '\u{0327}']),
        '\u{0139}' => Some(&['\u{004C}', '\u{0301}']),
        '\u{013A}' => Some(&['\u{006C}', '\u{0301}']),
        '\u{013B}' => Some(&['\u{004C}', '\u{0327}']),
        '\u{013C}' => Some(&['\u{006C}', '\u{0327}']),
        '\u{013D}' => Some(&['\u{004C}', '\u{030C}']),
        '\u{013E}' => Some(&['\u{006C}', '\u{030C}']),
        '\u{0143}' => Some(&['\u{004E}', '\u{0301}']),
        '\u{0144}' => Some(&['\u{006E}', '\u{0301}']),
        '\u{0145}' => Some(&['\u{004E}', '\u{0327}']),
        '\u{0146}' => Some(&['\u{006E}', '\u{0327}']),
        '\u{0147}' => Some(&['\u{004E}', '\u{030C}']),
        '\u{0148}' => Some(&['\u{006E}', '\u{030C}']),
        '\u{014C}' => Some(&['\u{004F}', '\u{0304}']),
        '\u{014D}' => Some(&['\u{006F}', '\u{0304}']),
        '\u{014E}' => Some(&['\u{004F}', '\u{0306}']),
        '\u{014F}' => Some(&['\u{006F}', '\u{0306}']),
        '\u{0150}' => Some(&['\u{004F}', '\u{030B}']),
        '\u{0151}' => Some(&['\u{006F}', '\u{030B}']),
        '\u{0154}' => Some(&['\u{0052}', '\u{0301}']),
        '\u{0155}' => Some(&['\u{0072}', '\u{0301}']),
        '\u{0156}' => Some(&['\u{0052}', '\u{0327}']),
        '\u{0157}' => Some(&['\u{0072}', '\u{0327}']),
        '\u{0158}' => Some(&['\u{0052}', '\u{030C}']),
        '\u{0159}' => Some(&['\u{0072}', '\u{030C}']),
        '\u{015A}' => Some(&['\u{0053}', '\u{0301}']),
        '\u{015B}' => Some(&['\u{0073}', '\u{0301}']),
        '\u{015C}' => Some(&['\u{0053}', '\u{0302}']),
        '\u{015D}' => Some(&['\u{0073}', '\u{0302}']),
        '\u{015E}' => Some(&['\u{0053}', '\u{0327}']),
        '\u{015F}' => Some(&['\u{0073}', '\u{0327}']),
        '\u{0160}' => Some(&['\u{0053}', '\u{030C}']),
        '\u{0161}' => Some(&['\u{0073}', '\u{030C}']),
        '\u{0162}' => Some(&['\u{0054}', '\u{0327}']),
        '\u{0163}' => Some(&['\u{0074}', '\u{0327}']),
        '\u{0164}' => Some(&['\u{0054}', '\u{030C}']),
        '\u{0165}' => Some(&['\u{0074}', '\u{030C}']),
        '\u{0168}' => Some(&['\u{0055}', '\u{0303}']),
        '\u{0169}' => Some(&['\u{0075}', '\u{0303}']),
        '\u{016A}' => Some(&['\u{0055}', '\u{0304}']),
        '\u{016B}' => Some(&['\u{0075}', '\u{0304}']),
        '\u{016C}' => Some(&['\u{0055}', '\u{0306}']),
        '\u{016D}' => Some(&['\u{0075}', '\u{0306}']),
        '\u{016E}' => Some(&['\u{0055}', '\u{030A}']),
        '\u{016F}' => Some(&['\u{0075}', '\u{030A}']),
        '\u{0170}' => Some(&['\u{0055}', '\u{030B}']),
        '\u{0171}' => Some(&['\u{0075}', '\u{030B}']),
        '\u{0172}' => Some(&['\u{0055}', '\u{0328}']),
        '\u{0173}' => Some(&['\u{0075}', '\u{0328}']),
        '\u{0174}' => Some(&['\u{0057}', '\u{0302}']),
        '\u{0175}' => Some(&['\u{0077}', '\u{0302}']),
        '\u{0176}' => Some(&['\u{0059}', '\u{0302}']),
        '\u{0177}' => Some(&['\u{0079}', '\u{0302}']),
        '\u{0178}' => Some(&['\u{0059}', '\u{0308}']),
        '\u{0179}' => Some(&['\u{005A}', '\u{0301}']),
        '\u{017A}' => Some(&['\u{007A}', '\u{0301}']),
        '\u{017B}' => Some(&['\u{005A}', '\u{0307}']),
        '\u{017C}' => Some(&['\u{007A}', '\u{0307}']),
        '\u{017D}' => Some(&['\u{005A}', '\u{030C}']),
        '\u{017E}' => Some(&['\u{007A}', '\u{030C}']),
        '\u{01A0}' => Some(&['\u{004F}', '\u{031B}']),
        '\u{01A1}' => Some(&['\u{006F}', '\u{031B}']),
        '\u{01AF}' => Some(&['\u{0055}', '\u{031B}']),
        '\u{01B0}' => Some(&['\u{0075}', '\u{031B}']),
        '\u{01CD}' => Some(&['\u{0041}', '\u{030C}']),
        '\u{01CE}' => Some(&['\u{0061}', '\u{030C}']),
        '\u{01CF}' => Some(&['\u{0049}', '\u{030C}']),
        '\u{01D0}' => Some(&['\u{0069}', '\u{030C}']),
        '\u{01D1}' => Some(&['\u{004F}', '\u{030C}']),
        '\u{01D2}' => Some(&['\u{006F}', '\u{030C}']),
        '\u{01D3}' => Some(&['\u{0055}', '\u{030C}']),
        '\u{01D4}' => Some(&['\u{0075}', '\u{030C}']),
        '\u{01D5}' => Some(&['\u{0055}', '\u{0308}', '\u{0304}']),
        '\u{01D6}' => Some(&['\u{0075}', '\u{0308}', '\u{0304}']),
        '\u{01D7}' => Some(&['\u{0055}', '\u{0308}', '\u{0301}']),
        '\u{01D8}' => Some(&['\u{0075}', '\u{0308}', '\u{0301}']),
        '\u{01D9}' => Some(&['\u{0055}', '\u{0308}', '\u{030C}']),
        '\u{01DA}' => Some(&['\u{0075}', '\u{0308}', '\u{030C}']),
        '\u{01DB}' => Some(&['\u{0055}', '\u{0308}', '\u{0300}']),
        '\u{01DC}' => Some(&['\u{0075}', '\u{0308}', '\u{0300}']),
        '\u{01DE}' => Some(&['\u{0041}', '\u{0308}', '\u{0304}']),
        '\u{01DF}' => Some(&['\u{0061}', '\u{0308}', '\u{0304}']),
        '\u{01E0}' => Some(&['\u{0041}', '\u{0307}', '\u{0304}']),
        '\u{01E1}' => Some(&['\u{0061}', '\u{0307}', '\u{0304}']),
        '\u{01E2}' => Some(&['\u{00C6}', '\u{0304}']),
        '\u{01E3}' => Some(&['\u{00E6}', '\u{0304}']),
        '\u{01E6}' => Some(&['\u{0047}', '\u{030C}']),
        '\u{01E7}' => Some(&['\u{0067}', '\u{030C}']),
        '\u{01E8}' => Some(&['\u{004B}', '\u{030C}']),
        '\u{01E9}' => Some(&['\u{006B}', '\u{030C}']),
        '\u{01EA}' => Some(&['\u{004F}', '\u{0328}']),
        '\u{01EB}' => Some(&['\u{006F}', '\u{0328}']),
        '\u{01EC}' => Some(&['\u{004F}', '\u{0328}', '\u{0304}']),
        '\u{01ED}' => Some(&['\u{006F}', '\u{0328}', '\u{0304}']),
        '\u{01EE}' => Some(&['\u{01B7}', '\u{030C}']),
        '\u{01EF}' => Some(&['\u{0292}', '\u{030C}']),
        '\u{01F0}' => Some(&['\u{006A}', '\u{030C}']),
        '\u{01F4}' => Some(&['\u{0047}', '\u{0301}']),
        '\u{01F5}' => Some(&['\u{0067}', '\u{0301}']),
        '\u{01F8}' => Some(&['\u{004E}', '\u{0300}']),
        '\u{01F9}' => Some(&['\u{006E}', '\u{0300}']),
        '\u{01FA}' => Some(&['\u{0041}', '\u{030A}', '\u{0301}']),
        '\u{01FB}' => Some(&['\u{0061}', '\u{030A}', '\u{0301}']),
        '\u{01FC}' => Some(&['\u{00C6}', '\u{0301}']),
        '\u{01FD}' => Some(&['\u{00E6}', '\u{0301}']),
        '\u{01FE}' => Some(&['\u{00D8}', '\u{0301}']),
        '\u{01FF}' => Some(&['\u{00F8}', '\u{0301}']),
        '\u{0200}' => Some(&['\u{0041}', '\u{030F}']),
        '\u{0201}' => Some(&['\u{0061}', '\u{030F}']),
        '\u{0202}' => Some(&['\u{0041}', '\u{0311}']),
        '\u{0203}' => Some(&['\u{0061}', '\u{0311}']),
        '\u{0204}' => Some(&['\u{0045}', '\u{030F}']),
        '\u{0205}' => Some(&['\u{0065}', '\u{030F}']),
        '\u{0206}' => Some(&['\u{0045}', '\u{0311}']),
        '\u{0207}' => Some(&['\u{0065}', '\u{0311}']),
        '\u{0208}' => Some(&['\u{0049}', '\u{030F}']),
        '\u{0209}' => Some(&['\u{0069}', '\u{030F}']),
        '\u{020A}' => Some(&['\u{0049}', '\u{0311}']),
        '\u{020B}' => Some(&['\u{0069}', '\u{0311}']),
        '\u{020C}' => Some(&['\u{004F}', '\u{030F}']),
        '\u{020D}' => Some(&['\u{006F}', '\u{030F}']),
        '\u{020E}' => Some(&['\u{004F}', '\u{0311}']),
        '\u{020F}' => Some(&['\u{006F}', '\u{0311}']),
        '\u{0210}' => Some(&['\u{0052}', '\u{030F}']),
        '\u{0211}' => Some(&['\u{0072}', '\u{030F}']),
        '\u{0212}' => Some(&['\u{0052}', '\u{0311}']),
        '\u{0213}' => Some(&['\u{0072}', '\u{0311}']),
        '\u{0214}' => Some(&['\u{0055}', '\u{030F}']),
        '\u{0215}' => Some(&['\u{0075}', '\u{030F}']),
        '\u{0216}' => Some(&['\u{0055}', '\u{0311}']),
        '\u{0217}' => Some(&['\u{0075}', '\u{0311}']),
        '\u{0218}' => Some(&['\u{0053}', '\u{0326}']),
        '\u{0219}' => Some(&['\u{0073}', '\u{0326}']),
        '\u{021A}' => Some(&['\u{0054}', '\u{0326}']),
        '\u{021B}' => Some(&['\u{0074}', '\u{0326}']),
        '\u{021E}' => Some(&['\u{0048}', '\u{030C}']),
        '\u{021F}' => Some(&['\u{0068}', '\u{030C}']),
        '\u{0226}' => Some(&['\u{0041}', '\u{0307}']),
        '\u{0227}' => Some(&['\u{0061}', '\u{0307}']),
        '\u{0228}' => Some(&['\u{0045}', '\u{0327}']),
        '\u{0229}' => Some(&['\u{0065}', '\u{0327}']),
        '\u{022A}' => Some(&['\u{004F}', '\u{0308}', '\u{0304}']),
        '\u{022B}' => Some(&['\u{006F}', '\u{0308}', '\u{0304}']),
        '\u{022C}' => Some(&['\u{004F}', '\u{0303}', '\u{0304}']),
        '\u{022D}' => Some(&['\u{006F}', '\u{0303}', '\u{0304}']),
        '\u{022E}' => Some(&['\u{004F}', '\u{0307}']),
        '\u{022F}' => Some(&['\u{006F}', '\u{0307}']),
        '\u{0230}' => Some(&['\u{004F}', '\u{0307}', '\u{0304}']),
        '\u{0231}' => Some(&['\u{006F}', '\u{0307}', '\u{0304}']),
        '\u{0232}' => Some(&['\u{0059}', '\u{0304}']),
        '\u{0233}' => Some(&['\u{0079}', '\u{0304}']),
        '\u{0340}' => Some(&['\u{0300}']),
        '\u{0341}' => Some(&['\u{0301}']),
        '\u{0343}' => Some(&['\u{0313}']),
        '\u{0344}' => Some(&['\u{0308}', '\u{0301}']),
        '\u{0374}' => Some(&['\u{02B9}']),
        '\u{037E}' => Some(&['\u{003B}']),
        '\u{0385}' => Some(&['\u{00A8}', '\u{0301}']),
        '\u{0386}' => Some(&['\u{0391}', '\u{0301}']),
        '\u{0387}' => Some(&['\u{00B7}']),
        '\u{0388}' => Some(&['\u{0395}', '\u{0301}']),
        '\u{0389}' => Some(&['\u{0397}', '\u{0301}']),
        '\u{038A}' => Some(&['\u{0399}', '\u{0301}']),
        '\u{038C}' => Some(&['\u{039F}', '\u{0301}']),
        '\u{038E}' => Some(&['\u{03A5}', '\u{0301}']),
        '\u{038F}' => Some(&['\u{03A9}', '\u{0301}']),
        '\u{0390}' => Some(&['\u{03B9}', '\u{0308}', '\u{0301}']),
        '\u{03AA}' => Some(&['\u{0399}', '\u{0308}']),
        '\u{03AB}' => Some(&['\u{03A5}', '\u{0308}']),
        '\u{03AC}' => Some(&['\u{03B1}', '\u{0301}']),
        '\u{03AD}' => Some(&['\u{03B5}', '\u{0301}']),
        '\u{03AE}' => Some(&['\u{03B7}', '\u{0301}']),
        '\u{03AF}' => Some(&['\u{03B9}', '\u{0301}']),
        '\u{03B0}' => Some(&['\u{03C5}', '\u{0308}', '\u{0301}']),
        '\u{03CA}' => Some(&['\u{03B9}', '\u{0308}']),
        '\u{03CB}' => Some(&['\u{03C5}', '\u{0308}']),
        '\u{03CC}' => Some(&['\u{03BF}', '\u{0301}']),
        '\u{03CD}' => Some(&['\u{03C5}', '\u{0301}']),
        '\u{03CE}' => Some(&['\u{03C9}', '\u{0301}']),
        '\u{03D3}' => Some(&['\u{03D2}', '\u{0301}']),
        '\u{03D4}' => Some(&['\u{03D2}', '\u{0308}']),
        '\u{0400}' => Some(&['\u{0415}', '\u{0300}']),
        '\u{0401}' => Some(&['\u{0415}', '\u{0308}']),
        '\u{0403}' => Some(&['\u{0413}', '\u{0301}']),
        '\u{0407}' => Some(&['\u{0406}', '\u{0308}']),
        '\u{040C}' => Some(&['\u{041A}', '\u{0301}']),
        '\u{040D}' => Some(&['\u{0418}', '\u{0300}']),
        '\u{040E}' => Some(&['\u{0423}', '\u{0306}']),
        '\u{0419}' => Some(&['\u{0418}', '\u{0306}']),
        '\u{0439}' => Some(&['\u{0438}', '\u{0306}']),
        '\u{0450}' => Some(&['\u{0435}', '\u{0300}']),
        '\u{0451}' => Some(&['\u{0435}', '\u{0308}']),
        '\u{0453}' => Some(&['\u{0433}', '\u{0301}']),
        '\u{0457}' => Some(&['\u{0456}', '\u{0308}']),
        '\u{045C}' => Some(&['\u{043A}', '\u{0301}']),
        '\u{045D}' => Some(&['\u{0438}', '\u{0300}']),
        '\u{045E}' => Some(&['\u{0443}', '\u{0306}']),
        '\u{0476}' => Some(&['\u{0474}', '\u{030F}']),
        '\u{0477}' => Some(&['\u{0475}', '\u{030F}']),
        '\u{04C1}' => Some(&['\u{0416}', '\u{0306}']),
        '\u{04C2}' => Some(&['\u{0436}', '\u{0306}']),
        '\u{04D0}' => Some(&['\u{0410}', '\u{0306}']),
        '\u{04D1}' => Some(&['\u{0430}', '\u{0306}']),
        '\u{04D2}' => Some(&['\u{0410}', '\u{0308}']),
        '\u{04D3}' => Some(&['\u{0430}', '\u{0308}']),
        '\u{04D6}' => Some(&['\u{0415}', '\u{0306}']),
        '\u{04D7}' => Some(&['\u{0435}', '\u{0306}']),
        '\u{04DA}' => Some(&['\u{04D8}', '\u{0308}']),
        '\u{04DB}' => Some(&['\u{04D9}', '\u{0308}']),
        '\u{04DC}' => Some(&['\u{0416}', '\u{0308}']),
        '\u{04DD}' => Some(&['\u{0436}', '\u{0308}']),
        '\u{04DE}' => Some(&['\u{0417}', '\u{0308}']),
        '\u{04DF}' => Some(&['\u{0437}', '\u{0308}']),
        '\u{04E2}' => Some(&['\u{0418}', '\u{0304}']),
        '\u{04E3}' => Some(&['\u{0438}', '\u{0304}']),
        '\u{04E4}' => Some(&['\u{0418}', '\u{0308}']),
        '\u{04E5}' => Some(&['\u{0438}', '\u{0308}']),
        '\u{04E6}' => Some(&['\u{041E}', '\u{0308}']),
        '\u{04E7}' => Some(&['\u{043E}', '\u{0308}']),
        '\u{04EA}' => Some(&['\u{04E8}', '\u{0308}']),
        '\u{04EB}' => Some(&['\u{04E9}', '\u{0308}']),
        '\u{04EC}' => Some(&['\u{042D}', '\u{0308}']),
        '\u{04ED}' => Some(&['\u{044D}', '\u{0308}']),
        '\u{04EE}' => Some(&['\u{0423}', '\u{0304}']),
        '\u{04EF}' => Some(&['\u{0443}', '\u{0304}']),
        '\u{04F0}' => Some(&['\u{0423}', '\u{0308}']),
        '\u{04F1}' => Some(&['\u{0443}', '\u{0308}']),
        '\u{04F2}' => Some(&['\u{0423}', '\u{030B}']),
        '\u{04F3}' => Some(&['\u{0443}', '\u{030B}']),
        '\u{04F4}' => Some(&['\u{0427}', '\u{0308}']),
        '\u{04F5}' => Some(&['\u{0447}', '\u{0308}']),
        '\u{04F8}' => Some(&['\u{042B}', '\u{0308}']),
        '\u{04F9}' => Some(&['\u{044B}', '\u{0308}']),
        '\u{0622}' => Some(&['\u{0627}', '\u{0653}']),
        '\u{0623}' => Some(&['\u{0627}', '\u{0654}']),
        '\u{0624}' => Some(&['\u{0648}', '\u{0654}']),
        '\u{0625}' => Some(&['\u{0627}', '\u{0655}']),
        '\u{0626}' => Some(&['\u{064A}', '\u{0654}']),
        '\u{06C0}' => Some(&['\u{06D5}', '\u{0654}']),
        '\u{06C2}' => Some(&['\u{06C1}', '\u{0654}']),
        '\u{06D3}' => Some(&['\u{06D2}', '\u{0654}']),
        '\u{0929}' => Some(&['\u{0928}', '\u{093C}']),
        '\u{0931}' => Some(&['\u{0930}', '\u{093C}']),
        '\u{0934}' => Some(&['\u{0933}', '\u{093C}']),
        '\u{0958}' => Some(&['\u{0915}', '\u{093C}']),
        '\u{0959}' => Some(&['\u{0916}', '\u{093C}']),
        '\u{095A}' => Some(&['\u{0917}', '\u{093C}']),
        '\u{095B}' => Some(&['\u{091C}', '\u{093C}']),
        '\u{095C}' => Some(&['\u{0921}', '\u{093C}']),
        '\u{095D}' => Some(&['\u{0922}', '\u{093C}']),
        '\u{095E}' => Some(&['\u{092B}', '\u{093C}']),
        '\u{095F}' => Some(&['\u{092F}', '\u{093C}']),
        '\u{09CB}' => Some(&['\u{09C7}', '\u{09BE}']),
        '\u{09CC}' => Some(&['\u{09C7}', '\u{09D7}']),
        '\u{09DC}' => Some(&['\u{09A1}', '\u{09BC}']),
        '\u{09DD}' => Some(&['\u{09A2}', '\u{09BC}']),
        '\u{09DF}' => Some(&['\u{09AF}', '\u{09BC}']),
        '\u{0A33}' => Some(&['\u{0A32}', '\u{0A3C}']),
        '\u{0A36}' => Some(&['\u{0A38}', '\u{0A3C}']),
        '\u{0A59}' => Some(&['\u{0A16}', '\u{0A3C}']),
        '\u{0A5A}' => Some(&['\u{0A17}', '\u{0A3C}']),
        '\u{0A5B}' => Some(&['\u{0A1C}', '\u{0A3C}']),
        '\u{0A5E}' => Some(&['\u{0A2B}', '\u{0A3C}']),
        '\u{0B48}' => Some(&['\u{0B47}', '\u{0B56}']),
        '\u{0B4B}' => Some(&['\u{0B47}', '\u{0B3E}']),
        '\u{0B4C}' => Some(&['\u{0B47}', '\u{0B57}']),
        '\u{0B5C}' => Some(&['\u{0B21}', '\u{0B3C}']),
        '\u{0B5D}' => Some(&['\u{0B22}', '\u{0B3C}']),
        '\u{0B94}' => Some(&['\u{0B92}', '\u{0BD7}']),
        '\u{0BCA}' => Some(&['\u{0BC6}', '\u{0BBE}']),
        '\u{0BCB}' => Some(&['\u{0BC7}', '\u{0BBE}']),
        '\u{0BCC}' => Some(&['\u{0BC6}', '\u{0BD7}']),
        '\u{0C48}' => Some(&['\u{0C46}', '\u{0C56}']),
        '\u{0CC0}' => Some(&['\u{0CBF}', '\u{0CD5}']),
        '\u{0CC7}' => Some(&['\u{0CC6}', '\u{0CD5}']),
        '\u{0CC8}' => Some(&['\u{0CC6}', '\u{0CD6}']),
        '\u{0CCA}' => Some(&['\u{0CC6}', '\u{0CC2}']),
        '\u{0CCB}' => Some(&['\u{0CC6}', '\u{0CC2}', '\u{0CD5}']),
        '\u{0D4A}' => Some(&['\u{0D46}', '\u{0D3E}']),
        '\u{0D4B}' => Some(&['\u{0D47}', '\u{0D3E}']),
        '\u{0D4C}' => Some(&['\u{0D46}', '\u{0D57}']),
        '\u{0DDA}' => Some(&['\u{0DD9}', '\u{0DCA}']),
        '\u{0DDC}' => Some(&['\u{0DD9}', '\u{0DCF}']),
        '\u{0DDD}' => Some(&['\u{0DD9}', '\u{0DCF}', '\u{0DCA}']),
        '\u{0DDE}' => Some(&['\u{0DD9}', '\u{0DDF}']),
        '\u{0F43}' => Some(&['\u{0F42}', '\u{0FB7}']),
        '\u{0F4D}' => Some(&['\u{0F4C}', '\u{0FB7}']),
        '\u{0F52}' => Some(&['\u{0F51}', '\u{0FB7}']),
        '\u{0F57}' => Some(&['\u{0F56}', '\u{0FB7}']),
        '\u{0F5C}' => Some(&['\u{0F5B}', '\u{0FB7}']),
        '\u{0F69}' => Some(&['\u{0F40}', '\u{0FB5}']),
        '\u{0F73}' => Some(&['\u{0F71}', '\u{0F72}']),
        '\u{0F75}' => Some(&['\u{0F71}', '\u{0F74}']),
        '\u{0F76}' => Some(&['\u{0FB2}', '\u{0F80}']),
        '\u{0F78}' => Some(&['\u{0FB3}', '\u{0F80}']),
        '\u{0F81}' => Some(&['\u{0F71}', '\u{0F80}']),
        '\u{0F93}' => Some(&['\u{0F92}', '\u{0FB7}']),
        '\u{0F9D}' => Some(&['\u{0F9C}', '\u{0FB7}']),
        '\u{0FA2}' => Some(&['\u{0FA1}', '\u{0FB7}']),
        '\u{0FA7}' => Some(&['\u{0FA6}', '\u{0FB7}']),
        '\u{0FAC}' => Some(&['\u{0FAB}', '\u{0FB7}']),
        '\u{0FB9}' => Some(&['\u{0F90}', '\u{0FB5}']),
        '\u{1026}' => Some(&['\u{1025}', '\u{102E}']),
        '\u{1B06}' => Some(&['\u{1B05}', '\u{1B35}']),
        '\u{1B08}' => Some(&['\u{1B07}', '\u{1B35}']),
        '\u{1B0A}' => Some(&['\u{1B09}', '\u{1B35}']),
        '\u{1B0C}' => Some(&['\u{1B0B}', '\u{1B35}']),
        '\u{1B0E}' => Some(&['\u{1B0D}', '\u{1B35}']),
        '\u{1B12}' => Some(&['\u{1B11}', '\u{1B35}']),
        '\u{1B3B}' => Some(&['\u{1B3A}', '\u{1B35}']),
        '\u{1B3D}' => Some(&['\u{1B3C}', '\u{1B35}']),
        '\u{1B40}' => Some(&['\u{1B3E}', '\u{1B35}']),
        '\u{1B41}' => Some(&['\u{1B3F}', '\u{1B35}']),
        '\u{1B43}' => Some(&['\u{1B42}', '\u{1B35}']),
        '\u{1E00}' => Some(&['\u{0041}', '\u{0325}']),
        '\u{1E01}' => Some(&['\u{0061}', '\u{0325}']),
        '\u{1E02}' => Some(&['\u{0042}', '\u{0307}']),
        '\u{1E03}' => Some(&['\u{0062}', '\u{0307}']),
        '\u{1E04}' => Some(&['\u{0042}', '\u{0323}']),
        '\u{1E05}' => Some(&['\u{0062}', '\u{0323}']),
        '\u{1E06}' => Some(&['\u{0042}', '\u{0331}']),
        '\u{1E07}' => Some(&['\u{0062}', '\u{0331}']),
        '\u{1E08}' => Some(&['\u{0043}', '\u{0327}', '\u{0301}']),
        '\u{1E09}' => Some(&['\u{0063}', '\u{0327}', '\u{0301}']),
        '\u{1E0A}' => Some(&['\u{0044}', '\u{0307}']),
        '\u{1E0B}' => Some(&['\u{0064}', '\u{0307}']),
        '\u{1E0C}' => Some(&['\u{0044}', '\u{0323}']),
        '\u{1E0D}' => Some(&['\u{0064}', '\u{0323}']),
        '\u{1E0E}' => Some(&['\u{0044}', '\u{0331}']),
        '\u{1E0F}' => Some(&['\u{0064}', '\u{0331}']),
        '\u{1E10}' => Some(&['\u{0044}', '\u{0327}']),
        '\u{1E11}' => Some(&['\u{0064}', '\u{0327}']),
        '\u{1E12}' => Some(&['\u{0044}', '\u{032D}']),
        '\u{1E13}' => Some(&['\u{0064}', '\u{032D}']),
        '\u{1E14}' => Some(&['\u{0045}', '\u{0304}', '\u{0300}']),
        '\u{1E15}' => Some(&['\u{0065}', '\u{0304}', '\u{0300}']),
        '\u{1E16}' => Some(&['\u{0045}', '\u{0304}', '\u{0301}']),
        '\u{1E17}' => Some(&['\u{0065}', '\u{0304}', '\u{0301}']),
        '\u{1E18}' => Some(&['\u{0045}', '\u{032D}']),
        '\u{1E19}' => Some(&['\u{0065}', '\u{032D}']),
        '\u{1E1A}' => Some(&['\u{0045}', '\u{0330}']),
        '\u{1E1B}' => Some(&['\u{0065}', '\u{0330}']),
        '\u{1E1C}' => Some(&['\u{0045}', '\u{0327}', '\u{0306}']),
        '\u{1E1D}' => Some(&['\u{0065}', '\u{0327}', '\u{0306}']),
        '\u{1E1E}' => Some(&['\u{0046}', '\u{0307}']),
        '\u{1E1F}' => Some(&['\u{0066}', '\u{0307}']),
        '\u{1E20}' => Some(&['\u{0047}', '\u{0304}']),
        '\u{1E21}' => Some(&['\u{0067}', '\u{0304}']),
        '\u{1E22}' => Some(&['\u{0048}', '\u{0307}']),
        '\u{1E23}' => Some(&['\u{0068}', '\u{0307}']),
        '\u{1E24}' => Some(&['\u{0048}', '\u{0323}']),
        '\u{1E25}' => Some(&['\u{0068}', '\u{0323}']),
        '\u{1E26}' => Some(&['\u{0048}', '\u{0308}']),
        '\u{1E27}' => Some(&['\u{0068}', '\u{0308}']),
        '\u{1E28}' => Some(&['\u{0048}', '\u{0327}']),
        '\u{1E29}' => Some(&['\u{0068}', '\u{0327}']),
        '\u{1E2A}' => Some(&['\u{0048}', '\u{032E}']),
        '\u{1E2B}' => Some(&['\u{0068}', '\u{032E}']),
        '\u{1E2C}' => Some(&['\u{0049}', '\u{0330}']),
        '\u{1E2D}' => Some(&['\u{0069}', '\u{0330}']),
        '\u{1E2E}' => Some(&['\u{0049}', '\u{0308}', '\u{0301}']),
        '\u{1E2F}' => Some(&['\u{0069}', '\u{0308}', '\u{0301}']),
        '\u{1E30}' => Some(&['\u{004B}', '\u{0301}']),
        '\u{1E31}' => Some(&['\u{006B}', '\u{0301}']),
        '\u{1E32}' => Some(&['\u{004B}', '\u{0323}']),
        '\u{1E33}' => Some(&['\u{006B}', '\u{0323}']),
        '\u{1E34}' => Some(&['\u{004B}', '\u{0331}']),
        '\u{1E35}' => Some(&['\u{006B}', '\u{0331}']),
        '\u{1E36}' => Some(&['\u{004C}', '\u{0323}']),
        '\u{1E37}' => Some(&['\u{006C}', '\u{0323}']),
        '\u{1E38}' => Some(&['\u{004C}', '\u{0323}', '\u{0304}']),
        '\u{1E39}' => Some(&['\u{006C}', '\u{0323}', '\u{0304}']),
        '\u{1E3A}' => Some(&['\u{004C}', '\u{0331}']),
        '\u{1E3B}' => Some(&['\u{006C}', '\u{0331}']),
        '\u{1E3C}' => Some(&['\u{004C}', '\u{032D}']),
        '\u{1E3D}' => Some(&['\u{006C}', '\u{032D}']),
        '\u{1E3E}' => Some(&['\u{004D}', '\u{0301}']),
        '\u{1E3F}' => Some(&['\u{006D}', '\u{0301}']),
        '\u{1E40}' => Some(&['\u{004D}', '\u{0307}']),
        '\u{1E41}' => Some(&['\u{006D}', '\u{0307}']),
        '\u{1E42}' => Some(&['\u{004D}', '\u{0323}']),
        '\u{1E43}' => Some(&['\u{006D}', '\u{0323}']),
        '\u{1E44}' => Some(&['\u{004E}', '\u{0307}']),
        '\u{1E45}' => Some(&['\u{006E}', '\u{0307}']),
        '\u{1E46}' => Some(&['\u{004E}', '\u{0323}']),
        '\u{1E47}' => Some(&['\u{006E}', '\u{0323}']),
        '\u{1E48}' => Some(&['\u{004E}', '\u{0331}']),
        '\u{1E49}' => Some(&['\u{006E}', '\u{0331}']),
        '\u{1E4A}' => Some(&['\u{004E}', '\u{032D}']),
        '\u{1E4B}' => Some(&['\u{006E}', '\u{032D}']),
        '\u{1E4C}' => Some(&['\u{004F}', '\u{0303}', '\u{0301}']),
        '\u{1E4D}' => Some(&['\u{006F}', '\u{0303}', '\u{0301}']),
        '\u{1E4E}' => Some(&['\u{004F}', '\u{0303}', '\u{0308}']),
        '\u{1E4F}' => Some(&['\u{006F}', '\u{0303}', '\u{0308}']),
        '\u{1E50}' => Some(&['\u{004F}', '\u{0304}', '\u{0300}']),
        '\u{1E51}' => Some(&['\u{006F}', '\u{0304}', '\u{0300}']),
        '\u{1E52}' => Some(&['\u{004F}', '\u{0304}', '\u{0301}']),
        '\u{1E53}' => Some(&['\u{006F}', '\u{0304}', '\u{0301}']),
        '\u{1E54}' => Some(&['\u{0050}', '\u{0301}']),
        '\u{1E55}' => Some(&['\u{0070}', '\u{0301}']),
        '\u{1E56}' => Some(&['\u{0050}', '\u{0307}']),
        '\u{1E57}' => Some(&['\u{0070}', '\u{0307}']),
        '\u{1E58}' => Some(&['\u{0052}', '\u{0307}']),
        '\u{1E59}' => Some(&['\u{0072}', '\u{0307}']),
        '\u{1E5A}' => Some(&['\u{0052}', '\u{0323}']),
        '\u{1E5B}' => Some(&['\u{0072}', '\u{0323}']),
        '\u{1E5C}' => Some(&['\u{0052}', '\u{0323}', '\u{0304}']),
        '\u{1E5D}' => Some(&['\u{0072}', '\u{0323}', '\u{0304}']),
        '\u{1E5E}' => Some(&['\u{0052}', '\u{0331}']),
        '\u{1E5F}' => Some(&['\u{0072}', '\u{0331}']),
        '\u{1E60}' => Some(&['\u{0053}', '\u{0307}']),
        '\u{1E61}' => Some(&['\u{0073}', '\u{0307}']),
        '\u{1E62}' => Some(&['\u{0053}', '\u{0323}']),
        '\u{1E63}' => Some(&['\u{0073}', '\u{0323}']),
        '\u{1E64}' => Some(&['\u{0053}', '\u{0301}', '\u{0307}']),
        '\u{1E65}' => Some(&['\u{0073}', '\u{0301}', '\u{0307}']),
        '\u{1E66}' => Some(&['\u{0053}', '\u{030C}', '\u{0307}']),
        '\u{1E67}' => Some(&['\u{0073}', '\u{030C}', '\u{0307}']),
        '\u{1E68}' => Some(&['\u{0053}', '\u{0323}', '\u{0307}']),
        '\u{1E69}' => Some(&['\u{0073}', '\u{0323}', '\u{0307}']),
        '\u{1E6A}' => Some(&['\u{0054}', '\u{0307}']),
        '\u{1E6B}' => Some(&['\u{0074}', '\u{0307}']),
        '\u{1E6C}' => Some(&['\u{0054}', '\u{0323}']),
        '\u{1E6D}' => Some(&['\u{0074}', '\u{0323}']),
        '\u{1E6E}' => Some(&['\u{0054}', '\u{0331}']),
        '\u{1E6F}' => Some(&['\u{0074}', '\u{0331}']),
        '\u{1E70}' => Some(&['\u{0054}', '\u{032D}']),
        '\u{1E71}' => Some(&['\u{0074}', '\u{032D}']),
        '\u{1E72}' => Some(&['\u{0055}', '\u{0324}']),
        '\u{1E73}' => Some(&['\u{0075}', '\u{0324}']),
        '\u{1E74}' => Some(&['\u{0055}', '\u{0330}']),
        '\u{1E75}' => Some(&['\u{0075}', '\u{0330}']),
        '\u{1E76}' => Some(&['\u{0055}', '\u{032D}']),
        '\u{1E77}' => Some(&['\u{0075}', '\u{032D}']),
        '\u{1E78}' => Some(&['\u{0055}', '\u{0303}', '\u{0301}']),
        '\u{1E79}' => Some(&['\u{0075}', '\u{0303}', '\u{0301}']),
        '\u{1E7A}' => Some(&['\u{0055}', '\u{0304}', '\u{0308}']),
        '\u{1E7B}' => Some(&['\u{0075}', '\u{0304}', '\u{0308}']),
        '\u{1E7C}' => Some(&['\u{0056}', '\u{0303}']),
        '\u{1E7D}' => Some(&['\u{0076}', '\u{0303}']),
        '\u{1E7E}' => Some(&['\u{0056}', '\u{0323}']),
        '\u{1E7F}' => Some(&['\u{0076}', '\u{0323}']),
        '\u{1E80}' => Some(&['\u{0057}', '\u{0300}']),
        '\u{1E81}' => Some(&['\u{0077}', '\u{0300}']),
        '\u{1E82}' => Some(&['\u{0057}', '\u{0301}']),
        '\u{1E83}' => Some(&['\u{0077}', '\u{0301}']),
        '\u{1E84}' => Some(&['\u{0057}', '\u{0308}']),
        '\u{1E85}' => Some(&['\u{0077}', '\u{0308}']),
        '\u{1E86}' => Some(&['\u{0057}', '\u{0307}']),
        '\u{1E87}' => Some(&['\u{0077}', '\u{0307}']),
        '\u{1E88}' => Some(&['\u{0057}', '\u{0323}']),
        '\u{1E89}' => Some(&['\u{0077}', '\u{0323}']),
        '\u{1E8A}' => Some(&['\u{0058}', '\u{0307}']),
        '\u{1E8B}' => Some(&['\u{0078}', '\u{0307}']),
        '\u{1E8C}' => Some(&['\u{0058}', '\u{0308}']),
        '\u{1E8D}' => Some(&['\u{0078}', '\u{0308}']),
        '\u{1E8E}' => Some(&['\u{0059}', '\u{0307}']),
        '\u{1E8F}' => Some(&['\u{0079}', '\u{0307}']),
        '\u{1E90}' => Some(&['\u{005A}', '\u{0302}']),
        '\u{1E91}' => Some(&['\u{007A}', '\u{0302}']),
        '\u{1E92}' => Some(&['\u{005A}', '\u{0323}']),
        '\u{1E93}' => Some(&['\u{007A}', '\u{0323}']),
        '\u{1E94}' => Some(&['\u{005A}', '\u{0331}']),
        '\u{1E95}' => Some(&['\u{007A}', '\u{0331}']),
        '\u{1E96}' => Some(&['\u{0068}', '\u{0331}']),
        '\u{1E97}' => Some(&['\u{0074}', '\u{0308}']),
        '\u{1E98}' => Some(&['\u{0077}', '\u{030A}']),
        '\u{1E99}' => Some(&['\u{0079}', '\u{030A}']),
        '\u{1E9B}' => Some(&['\u{017F}', '\u{0307}']),
        '\u{1EA0}' => Some(&['\u{0041}', '\u{0323}']),
        '\u{1EA1}' => Some(&['\u{0061}', '\u{0323}']),
        '\u{1EA2}' => Some(&['\u{0041}', '\u{0309}']),
        '\u{1EA3}' => Some(&['\u{0061}', '\u{0309}']),
        '\u{1EA4}' => Some(&['\u{0041}', '\u{0302}', '\u{0301}']),
        '\u{1EA5}' => Some(&['\u{0061}', '\u{0302}', '\u{0301}']),
        '\u{1EA6}' => Some(&['\u{0041}', '\u{0302}', '\u{0300}']),
        '\u{1EA7}' => Some(&['\u{0061}', '\u{0302}', '\u{0300}']),
        '\u{1EA8}' => Some(&['\u{0041}', '\u{0302}', '\u{0309}']),
        '\u{1EA9}' => Some(&['\u{0061}', '\u{0302}', '\u{0309}']),
        '\u{1EAA}' => Some(&['\u{0041}', '\u{0302}', '\u{0303}']),
        '\u{1EAB}' => Some(&['\u{0061}', '\u{0302}', '\u{0303}']),
        '\u{1EAC}' => Some(&['\u{0041}', '\u{0323}', '\u{0302}']),
        '\u{1EAD}' => Some(&['\u{0061}', '\u{0323}', '\u{0302}']),
        '\u{1EAE}' => Some(&['\u{0041}', '\u{0306}', '\u{0301}']),
        '\u{1EAF}' => Some(&['\u{0061}', '\u{0306}', '\u{0301}']),
        '\u{1EB0}' => Some(&['\u{0041}', '\u{0306}', '\u{0300}']),
        '\u{1EB1}' => Some(&['\u{0061}', '\u{0306}', '\u{0300}']),
        '\u{1EB2}' => Some(&['\u{0041}', '\u{0306}', '\u{0309}']),
        '\u{1EB3}' => Some(&['\u{0061}', '\u{0306}', '\u{0309}']),
        '\u{1EB4}' => Some(&['\u{0041}', '\u{0306}', '\u{0303}']),
        '\u{1EB5}' => Some(&['\u{0061}', '\u{0306}', '\u{0303}']),
        '\u{1EB6}' => Some(&['\u{0041}', '\u{0323}', '\u{0306}']),
        '\u{1EB7}' => Some(&['\u{0061}', '\u{0323}', '\u{0306}']),
        '\u{1EB8}' => Some(&['\u{0045}', '\u{0323}']),
        '\u{1EB9}' => Some(&['\u{0065}', '\u{0323}']),
        '\u{1EBA}' => Some(&['\u{0045}', '\u{0309}']),
        '\u{1EBB}' => Some(&['\u{0065}', '\u{0309}']),
        '\u{1EBC}' => Some(&['\u{0045}', '\u{0303}']),
        '\u{1EBD}' => Some(&['\u{0065}', '\u{0303}']),
        '\u{1EBE}' => Some(&['\u{0045}', '\u{0302}', '\u{0301}']),
        '\u{1EBF}' => Some(&['\u{0065}', '\u{0302}', '\u{0301}']),
        '\u{1EC0}' => Some(&['\u{0045}', '\u{0302}', '\u{0300}']),
        '\u{1EC1}' => Some(&['\u{0065}', '\u{0302}', '\u{0300}']),
        '\u{1EC2}' => Some(&['\u{0045}', '\u{0302}', '\u{0309}']),
        '\u{1EC3}' => Some(&['\u{0065}', '\u{0302}', '\u{0309}']),
        '\u{1EC4}' => Some(&['\u{0045}', '\u{0302}', '\u{0303}']),
        '\u{1EC5}' => Some(&['\u{0065}', '\u{0302}', '\u{0303}']),
        '\u{1EC6}' => Some(&['\u{0045}', '\u{0323}', '\u{0302}']),
        '\u{1EC7}' => Some(&['\u{0065}', '\u{0323}', '\u{0302}']),
        '\u{1EC8}' => Some(&['\u{0049}', '\u{0309}']),
        '\u{1EC9}' => Some(&['\u{0069}', '\u{0309}']),
        '\u{1ECA}' => Some(&['\u{0049}', '\u{0323}']),
        '\u{1ECB}' => Some(&['\u{0069}', '\u{0323}']),
        '\u{1ECC}' => Some(&['\u{004F}', '\u{0323}']),
        '\u{1ECD}' => Some(&['\u{006F}', '\u{0323}']),
        '\u{1ECE}' => Some(&['\u{004F}', '\u{0309}']),
        '\u{1ECF}' => Some(&['\u{006F}', '\u{0309}']),
        '\u{1ED0}' => Some(&['\u{004F}', '\u{0302}', '\u{0301}']),
        '\u{1ED1}' => Some(&['\u{006F}', '\u{0302}', '\u{0301}']),
        '\u{1ED2}' => Some(&['\u{004F}', '\u{0302}', '\u{0300}']),
        '\u{1ED3}' => Some(&['\u{006F}', '\u{0302}', '\u{0300}']),
        '\u{1ED4}' => Some(&['\u{004F}', '\u{0302}', '\u{0309}']),
        '\u{1ED5}' => Some(&['\u{006F}', '\u{0302}', '\u{0309}']),
        '\u{1ED6}' => Some(&['\u{004F}', '\u{0302}', '\u{0303}']),
        '\u{1ED7}' => Some(&['\u{006F}', '\u{0302}', '\u{0303}']),
        '\u{1ED8}' => Some(&['\u{004F}', '\u{0323}', '\u{0302}']),
        '\u{1ED9}' => Some(&['\u{006F}', '\u{0323}', '\u{0302}']),
        '\u{1EDA}' => Some(&['\u{004F}', '\u{031B}', '\u{0301}']),
        '\u{1EDB}' => Some(&['\u{006F}', '\u{031B}', '\u{0301}']),
        '\u{1EDC}' => Some(&['\u{004F}', '\u{031B}', '\u{0300}']),
        '\u{1EDD}' => Some(&['\u{006F}', '\u{031B}', '\u{0300}']),
        '\u{1EDE}' => Some(&['\u{004F}', '\u{031B}', '\u{0309}']),
        '\u{1EDF}' => Some(&['\u{006F}', '\u{031B}', '\u{0309}']),
        '\u{1EE0}' => Some(&['\u{004F}', '\u{031B}', '\u{0303}']),
        '\u{1EE1}' => Some(&['\u{006F}', '\u{031B}', '\u{0303}']),
        '\u{1EE2}' => Some(&['\u{004F}', '\u{031B}', '\u{0323}']),
        '\u{1EE3}' => Some(&['\u{006F}', '\u{031B}', '\u{0323}']),
        '\u{1EE4}' => Some(&['\u{0055}', '\u{0323}']),
        '\u{1EE5}' => Some(&['\u{0075}', '\u{0323}']),
        '\u{1EE6}' => Some(&['\u{0055}', '\u{0309}']),
        '\u{1EE7}' => Some(&['\u{0075}', '\u{0309}']),
        '\u{1EE8}' => Some(&['\u{0055}', '\u{031B}', '\u{0301}']),
        '\u{1EE9}' => Some(&['\u{0075}', '\u{031B}', '\u{0301}']),
        '\u{1EEA}' => Some(&['\u{0055}', '\u{031B}', '\u{0300}']),
        '\u{1EEB}' => Some(&['\u{0075}', '\u{031B}', '\u{0300}']),
        '\u{1EEC}' => Some(&['\u{0055}', '\u{031B}', '\u{0309}']),
        '\u{1EED}' => Some(&['\u{0075}', '\u{031B}', '\u{0309}']),
        '\u{1EEE}' => Some(&['\u{0055}', '\u{031B}', '\u{0303}']),
        '\u{1EEF}' => Some(&['\u{0075}', '\u{031B}', '\u{0303}']),
        '\u{1EF0}' => Some(&['\u{0055}', '\u{031B}', '\u{0323}']),
        '\u{1EF1}' => Some(&['\u{0075}', '\u{031B}', '\u{0323}']),
        '\u{1EF2}' => Some(&['\u{0059}', '\u{0300}']),
        '\u{1EF3}' => Some(&['\u{0079}', '\u{0300}']),
        '\u{1EF4}' => Some(&['\u{0059}', '\u{0323}']),
        '\u{1EF5}' => Some(&['\u{0079}', '\u{0323}']),
        '\u{1EF6}' => Some(&['\u{0059}', '\u{0309}']),
        '\u{1EF7}' => Some(&['\u{0079}', '\u{0309}']),
        '\u{1EF8}' => Some(&['\u{0059}', '\u{0303}']),
        '\u{1EF9}' => Some(&['\u{0079}', '\u{0303}']),
        '\u{1F00}' => Some(&['\u{03B1}', '\u{0313}']),
        '\u{1F01}' => Some(&['\u{03B1}', '\u{0314}']),
        '\u{1F02}' => Some(&['\u{03B1}', '\u{0313}', '\u{0300}']),
        '\u{1F03}' => Some(&['\u{03B1}', '\u{0314}', '\u{0300}']),
        '\u{1F04}' => Some(&['\u{03B1}', '\u{0313}', '\u{0301}']),
        '\u{1F05}' => Some(&['\u{03B1}', '\u{0314}', '\u{0301}']),
        '\u{1F06}' => Some(&['\u{03B1}', '\u{0313}', '\u{0342}']),
        '\u{1F07}' => Some(&['\u{03B1}', '\u{0314}', '\u{0342}']),
        '\u{1F08}' => Some(&['\u{0391}', '\u{0313}']),
        '\u{1F09}' => Some(&['\u{0391}', '\u{0314}']),
        '\u{1F0A}' => Some(&['\u{0391}', '\u{0313}', '\u{0300}']),
        '\u{1F0B}' => Some(&['\u{0391}', '\u{0314}', '\u{0300}']),
        '\u{1F0C}' => Some(&['\u{0391}', '\u{0313}', '\u{0301}']),
        '\u{1F0D}' => Some(&['\u{0391}', '\u{0314}', '\u{0301}']),
        '\u{1F0E}' => Some(&['\u{0391}', '\u{0313}', '\u{0342}']),
        '\u{1F0F}' => Some(&['\u{0391}', '\u{0314}', '\u{0342}']),
        '\u{1F10}' => Some(&['\u{03B5}', '\u{0313}']),
        '\u{1F11}' => Some(&['\u{03B5}', '\u{0314}']),
        '\u{1F12}' => Some(&['\u{03B5}', '\u{0313}', '\u{0300}']),
        '\u{1F13}' => Some(&['\u{03B5}', '\u{0314}', '\u{0300}']),
        '\u{1F14}' => Some(&['\u{03B5}', '\u{0313}', '\u{0301}']),
        '\u{1F15}' => Some(&['\u{03B5}', '\u{0314}', '\u{0301}']),
        '\u{1F18}' => Some(&['\u{0395}', '\u{0313}']),
        '\u{1F19}' => Some(&['\u{0395}', '\u{0314}']),
        '\u{1F1A}' => Some(&['\u{0395}', '\u{0313}', '\u{0300}']),
        '\u{1F1B}' => Some(&['\u{0395}', '\u{0314}', '\u{0300}']),
        '\u{1F1C}' => Some(&['\u{0395}', '\u{0313}', '\u{0301}']),
        '\u{1F1D}' => Some(&['\u{0395}', '\u{0314}', '\u{0301}']),
        '\u{1F20}' => Some(&['\u{03B7}', '\u{0313}']),
        '\u{1F21}' => Some(&['\u{03B7}', '\u{0314}']),
        '\u{1F22}' => Some(&['\u{03B7}', '\u{0313}', '\u{0300}']),
        '\u{1F23}' => Some(&['\u{03B7}', '\u{0314}', '\u{0300}']),
        '\u{1F24}' => Some(&['\u{03B7}', '\u{0313}', '\u{0301}']),
        '\u{1F25}' => Some(&['\u{03B7}', '\u{0314}', '\u{0301}']),
        '\u{1F26}' => Some(&['\u{03B7}', '\u{0313}', '\u{0342}']),
        '\u{1F27}' => Some(&['\u{03B7}', '\u{0314}', '\u{0342}']),
        '\u{1F28}' => Some(&['\u{0397}', '\u{0313}']),
        '\u{1F29}' => Some(&['\u{0397}', '\u{0314}']),
        '\u{1F2A}' => Some(&['\u{0397}', '\u{0313}', '\u{0300}']),
        '\u{1F2B}' => Some(&['\u{0397}', '\u{0314}', '\u{0300}']),
        '\u{1F2C}' => Some(&['\u{0397}', '\u{0313}', '\u{0301}']),
        '\u{1F2D}' => Some(&['\u{0397}', '\u{0314}', '\u{0301}']),
        '\u{1F2E}' => Some(&['\u{0397}', '\u{0313}', '\u{0342}']),
        '\u{1F2F}' => Some(&['\u{0397}', '\u{0314}', '\u{0342}']),
        '\u{1F30}' => Some(&['\u{03B9}', '\u{0313}']),
        '\u{1F31}' => Some(&['\u{03B9}', '\u{0314}']),
        '\u{1F32}' => Some(&['\u{03B9}', '\u{0313}', '\u{0300}']),
        '\u{1F33}' => Some(&['\u{03B9}', '\u{0314}', '\u{0300}']),
        '\u{1F34}' => Some(&['\u{03B9}', '\u{0313}', '\u{0301}']),
        '\u{1F35}' => Some(&['\u{03B9}', '\u{0314}', '\u{0301}']),
        '\u{1F36}' => Some(&['\u{03B9}', '\u{0313}', '\u{0342}']),
        '\u{1F37}' => Some(&['\u{03B9}', '\u{0314}', '\u{0342}']),
        '\u{1F38}' => Some(&['\u{0399}', '\u{0313}']),
        '\u{1F39}' => Some(&['\u{0399}', '\u{0314}']),
        '\u{1F3A}' => Some(&['\u{0399}', '\u{0313}', '\u{0300}']),
        '\u{1F3B}' => Some(&['\u{0399}', '\u{0314}', '\u{0300}']),
        '\u{1F3C}' => Some(&['\u{0399}', '\u{0313}', '\u{0301}']),
        '\u{1F3D}' => Some(&['\u{0399}', '\u{0314}', '\u{0301}']),
        '\u{1F3E}' => Some(&['\u{0399}', '\u{0313}', '\u{0342}']),
        '\u{1F3F}' => Some(&['\u{0399}', '\u{0314}', '\u{0342}']),
        '\u{1F40}' => Some(&['\u{03BF}', '\u{0313}']),
        '\u{1F41}' => Some(&['\u{03BF}', '\u{0314}']),
        '\u{1F42}' => Some(&['\u{03BF}', '\u{0313}', '\u{0300}']),
        '\u{1F43}' => Some(&['\u{03BF}', '\u{0314}', '\u{0300}']),
        '\u{1F44}' => Some(&['\u{03BF}', '\u{0313}', '\u{0301}']),
        '\u{1F45}' => Some(&['\u{03BF}', '\u{0314}', '\u{0301}']),
        '\u{1F48}' => Some(&['\u{039F}', '\u{0313}']),
        '\u{1F49}' => Some(&['\u{039F}', '\u{0314}']),
        '\u{1F4A}' => Some(&['\u{039F}', '\u{0313}', '\u{0300}']),
        '\u{1F4B}' => Some(&['\u{039F}', '\u{0314}', '\u{0300}']),
        '\u{1F4C}' => Some(&['\u{039F}', '\u{0313}', '\u{0301}']),
        '\u{1F4D}' => Some(&['\u{039F}', '\u{0314}', '\u{0301}']),
        '\u{1F50}' => Some(&['\u{03C5}', '\u{0313}']),
        '\u{1F51}' => Some(&['\u{03C5}', '\u{0314}']),
        '\u{1F52}' => Some(&['\u{03C5}', '\u{0313}', '\u{0300}']),
        '\u{1F53}' => Some(&['\u{03C5}', '\u{0314}', '\u{0300}']),
        '\u{1F54}' => Some(&['\u{03C5}', '\u{0313}', '\u{0301}']),
        '\u{1F55}' => Some(&['\u{03C5}', '\u{0314}', '\u{0301}']),
        '\u{1F56}' => Some(&['\u{03C5}', '\u{0313}', '\u{0342}']),
        '\u{1F57}' => Some(&['\u{03C5}', '\u{0314}', '\u{0342}']),
        '\u{1F59}' => Some(&['\u{03A5}', '\u{0314}']),
        '\u{1F5B}' => Some(&['\u{03A5}', '\u{0314}', '\u{0300}']),
        '\u{1F5D}' => Some(&['\u{03A5}', '\u{0314}', '\u{0301}']),
        '\u{1F5F}' => Some(&['\u{03A5}', '\u{0314}', '\u{0342}']),
        '\u{1F60}' => Some(&['\u{03C9}', '\u{0313}']),
        '\u{1F61}' => Some(&['\u{03C9}', '\u{0314}']),
        '\u{1F62}' => Some(&['\u{03C9}', '\u{0313}', '\u{0300}']),
        '\u{1F63}' => Some(&['\u{03C9}', '\u{0314}', '\u{0300}']),
        '\u{1F64}' => Some(&['\u{03C9}', '\u{0313}', '\u{0301}']),
        '\u{1F65}' => Some(&['\u{03C9}', '\u{0314}', '\u{0301}']),
        '\u{1F66}' => Some(&['\u{03C9}', '\u{0313}', '\u{0342}']),
        '\u{1F67}' => Some(&['\u{03C9}', '\u{0314}', '\u{0342}']),
        '\u{1F68}' => Some(&['\u{03A9}', '\u{0313}']),
        '\u{1F69}' => Some(&['\u{03A9}', '\u{0314}']),
        '\u{1F6A}' => Some(&['\u{03A9}', '\u{0313}', '\u{0300}']),
        '\u{1F6B}' => Some(&['\u{03A9}', '\u{0314}', '\u{0300}']),
        '\u{1F6C}' => Some(&['\u{03A9}', '\u{0313}', '\u{0301}']),
        '\u{1F6D}' => Some(&['\u{03A9}', '\u{0314}', '\u{0301}']),
        '\u{1F6E}' => Some(&['\u{03A9}', '\u{0313}', '\u{0342}']),
        '\u{1F6F}' => Some(&['\u{03A9}', '\u{0314}', '\u{0342}']),
        '\u{1F70}' => Some(&['\u{03B1}', '\u{0300}']),
        '\u{1F71}' => Some(&['\u{03B1}', '\u{0301}']),
        '\u{1F72}' => Some(&['\u{03B5}', '\u{0300}']),
        '\u{1F73}' => Some(&['\u{03B5}', '\u{0301}']),
        '\u{1F74}' => Some(&['\u{03B7}', '\u{0300}']),
        '\u{1F75}' => Some(&['\u{03B7}', '\u{0301}']),
        '\u{1F76}' => Some(&['\u{03B9}', '\u{0300}']),
        '\u{1F77}' => Some(&['\u{03B9}', '\u{0301}']),
        '\u{1F78}' => Some(&['\u{03BF}', '\u{0300}']),
        '\u{1F79}' => Some(&['\u{03BF}', '\u{0301}']),
        '\u{1F7A}' => Some(&['\u{03C5}', '\u{0300}']),
        '\u{1F7B}' => Some(&['\u{03C5}', '\u{0301}']),
        '\u{1F7C}' => Some(&['\u{03C9}', '\u{0300}']),
        '\u{1F7D}' => Some(&['\u{03C9}', '\u{0301}']),
        '\u{1F80}' => Some(&['\u{03B1}', '\u{0313}', '\u{0345}']),
        '\u{1F81}' => Some(&['\u{03B1}', '\u{0314}', '\u{0345}']),
        '\u{1F82}' => Some(&['\u{03B1}', '\u{0313}', '\u{0300}', '\u{0345}']),
        '\u{1F83}' => Some(&['\u{03B1}', '\u{0314}', '\u{0300}', '\u{0345}']),
        '\u{1F84}' => Some(&['\u{03B1}', '\u{0313}', '\u{0301}', '\u{0345}']),
        '\u{1F85}' => Some(&['\u{03B1}', '\u{0314}', '\u{0301}', '\u{0345}']),
        '\u{1F86}' => Some(&['\u{03B1}', '\u{0313}', '\u{0342}', '\u{0345}']),
        '\u{1F87}' => Some(&['\u{03B1}', '\u{0314}', '\u{0342}', '\u{0345}']),
        '\u{1F88}' => Some(&['\u{0391}', '\u{0313}', '\u{0345}']),
        '\u{1F89}' => Some(&['\u{0391}', '\u{0314}', '\u{0345}']),
        '\u{1F8A}' => Some(&['\u{0391}', '\u{0313}', '\u{0300}', '\u{0345}']),
        '\u{1F8B}' => Some(&['\u{0391}', '\u{0314}', '\u{0300}', '\u{0345}']),
        '\u{1F8C}' => Some(&['\u{0391}', '\u{0313}', '\u{0301}', '\u{0345}']),
        '\u{1F8D}' => Some(&['\u{0391}', '\u{0314}', '\u{0301}', '\u{0345}']),
        '\u{1F8E}' => Some(&['\u{0391}', '\u{0313}', '\u{0342}', '\u{0345}']),
        '\u{1F8F}' => Some(&['\u{0391}', '\u{0314}', '\u{0342}', '\u{0345}']),
        '\u{1F90}' => Some(&['\u{03B7}', '\u{0313}', '\u{0345}']),
        '\u{1F91}' => Some(&['\u{03B7}', '\u{0314}', '\u{0345}']),
        '\u{1F92}' => Some(&['\u{03B7}', '\u{0313}', '\u{0300}', '\u{0345}']),
        '\u{1F93}' => Some(&['\u{03B7}', '\u{0314}', '\u{0300}', '\u{0345}']),
        '\u{1F94}' => Some(&['\u{03B7}', '\u{0313}', '\u{0301}', '\u{0345}']),
        '\u{1F95}' => Some(&['\u{03B7}', '\u{0314}', '\u{0301}', '\u{0345}']),
        '\u{1F96}' => Some(&['\u{03B7}', '\u{0313}', '\u{0342}', '\u{0345}']),
        '\u{1F97}' => Some(&['\u{03B7}', '\u{0314}', '\u{0342}', '\u{0345}']),
        '\u{1F98}' => Some(&['\u{0397}', '\u{0313}', '\u{0345}']),
        '\u{1F99}' => Some(&['\u{0397}', '\u{0314}', '\u{0345}']),
        '\u{1F9A}' => Some(&['\u{0397}', '\u{0313}', '\u{0300}', '\u{0345}']),
        '\u{1F9B}' => Some(&['\u{0397}', '\u{0314}', '\u{0300}', '\u{0345}']),
        '\u{1F9C}' => Some(&['\u{0397}', '\u{0313}', '\u{0301}', '\u{0345}']),
        '\u{1F9D}' => Some(&['\u{0397}', '\u{0314}', '\u{0301}', '\u{0345}']),
        '\u{1F9E}' => Some(&['\u{0397}', '\u{0313}', '\u{0342}', '\u{0345}']),
        '\u{1F9F}' => Some(&['\u{0397}', '\u{0314}', '\u{0342}', '\u{0345}']),
        '\u{1FA0}' => Some(&['\u{03C9}', '\u{0313}', '\u{0345}']),
        '\u{1FA1}' => Some(&['\u{03C9}', '\u{0314}', '\u{0345}']),
        '\u{1FA2}' => Some(&['\u{03C9}', '\u{0313}', '\u{0300}', '\u{0345}']),
        '\u{1FA3}' => Some(&['\u{03C9}', '\u{0314}', '\u{0300}', '\u{0345}']),
        '\u{1FA4}' => Some(&['\u{03C9}', '\u{0313}', '\u{0301}', '\u{0345}']),
        '\u{1FA5}' => Some(&['\u{03C9}', '\u{0314}', '\u{0301}', '\u{0345}']),
        '\u{1FA6}' => Some(&['\u{03C9}', '\u{0313}', '\u{0342}', '\u{0345}']),
        '\u{1FA7}' => Some(&['\u{03C9}', '\u{0314}', '\u{0342}', '\u{0345}']),
        '\u{1FA8}' => Some(&['\u{03A9}', '\u{0313}', '\u{0345}']),
        '\u{1FA9}' => Some(&['\u{03A9}', '\u{0314}', '\u{0345}']),
        '\u{1FAA}' => Some(&['\u{03A9}', '\u{0313}', '\u{0300}', '\u{0345}']),
        '\u{1FAB}' => Some(&['\u{03A9}', '\u{0314}', '\u{0300}', '\u{0345}']),
        '\u{1FAC}' => Some(&['\u{03A9}', '\u{0313}', '\u{0301}', '\u{0345}']),
        '\u{1FAD}' => Some(&['\u{03A9}', '\u{0314}', '\u{0301}', '\u{0345}']),
        '\u{1FAE}' => Some(&['\u{03A9}', '\u{0313}', '\u{0342}', '\u{0345}']),
        '\u{1FAF}' => Some(&['\u{03A9}', '\u{0314}', '\u{0342}', '\u{0345}']),
        '\u{1FB0}' => Some(&['\u{03B1}', '\u{0306}']),
        '\u{1FB1}' => Some(&['\u{03B1}', '\u{0304}']),
        '\u{1FB2}' => Some(&['\u{03B1}', '\u{0300}', '\u{0345}']),
        '\u{1FB3}' => Some(&['\u{03B1}', '\u{0345}']),
        '\u{1FB4}' => Some(&['\u{03B1}', '\u{0301}', '\u{0345}']),
        '\u{1FB6}' => Some(&['\u{03B1}', '\u{0342}']),
        '\u{1FB7}' => Some(&['\u{03B1}', '\u{0342}', '\u{0345}']),
        '\u{1FB8}' => Some(&['\u{0391}', '\u{0306}']),
        '\u{1FB9}' => Some(&['\u{0391}', '\u{0304}']),
        '\u{1FBA}' => Some(&['\u{0391}', '\u{0300}']),
        '\u{1FBB}' => Some(&['\u{0391}', '\u{0301}']),
        '\u{1FBC}' => Some(&['\u{0391}', '\u{0345}']),
        '\u{1FBE}' => Some(&['\u{03B9}']),
        '\u{1FC1}' => Some(&['\u{00A8}', '\u{0342}']),
        '\u{1FC2}' => Some(&['\u{03B7}', '\u{0300}', '\u{0345}']),
        '\u{1FC3}' => Some(&['\u{03B7}', '\u{0345}']),
        '\u{1FC4}' => Some(&['\u{03B7}', '\u{0301}', '\u{0345}']),
        '\u{1FC6}' => Some(&['\u{03B7}', '\u{0342}']),
        '\u{1FC7}' => Some(&['\u{03B7}', '\u{0342}', '\u{0345}']),
        '\u{1FC8}' => Some(&['\u{0395}', '\u{0300}']),
        '\u{1FC9}' => Some(&['\u{0395}', '\u{0301}']),
        '\u{1FCA}' => Some(&['\u{0397}', '\u{0300}']),
        '\u{1FCB}' => Some(&['\u{0397}', '\u{0301}']),
        '\u{1FCC}' => Some(&['\u{0397}', '\u{0345}']),
        '\u{1FCD}' => Some(&['\u{1FBF}', '\u{0300}']),
        '\u{1FCE}' => Some(&['\u{1FBF}', '\u{0301}']),
        '\u{1FCF}' => Some(&['\u{1FBF}', '\u{0342}']),
        '\u{1FD0}' => Some(&['\u{03B9}', '\u{0306}']),
        '\u{1FD1}' => Some(&['\u{03B9}', '\u{0304}']),
        '\u{1FD2}' => Some(&['\u{03B9}', '\u{0308}', '\u{0300}']),
        '\u{1FD3}' => Some(&['\u{03B9}', '\u{0308}', '\u{0301}']),
        '\u{1FD6}' => Some(&['\u{03B9}', '\u{0342}']),
        '\u{1FD7}' => Some(&['\u{03B9}', '\u{0308}', '\u{0342}']),
        '\u{1FD8}' => Some(&['\u{0399}', '\u{0306}']),
        '\u{1FD9}' => Some(&['\u{0399}', '\u{0304}']),
        '\u{1FDA}' => Some(&['\u{0399}', '\u{0300}']),
        '\u{1FDB}' => Some(&['\u{0399}', '\u{0301}']),
        '\u{1FDD}' => Some(&['\u{1FFE}', '\u{0300}']),
        '\u{1FDE}' => Some(&['\u{1FFE}', '\u{0301}']),
        '\u{1FDF}' => Some(&['\u{1FFE}', '\u{0342}']),
        '\u{1FE0}' => Some(&['\u{03C5}', '\u{0306}']),
        '\u{1FE1}' => Some(&['\u{03C5}', '\u{0304}']),
        '\u{1FE2}' => Some(&['\u{03C5}', '\u{0308}', '\u{0300}']),
        '\u{1FE3}' => Some(&['\u{03C5}', '\u{0308}', '\u{0301}']),
        '\u{1FE4}' => Some(&['\u{03C1}', '\u{0313}']),
        '\u{1FE5}' => Some(&['\u{03C1}', '\u{0314}']),
        '\u{1FE6}' => Some(&['\u{03C5}', '\u{0342}']),
        '\u{1FE7}' => Some(&['\u{03C5}', '\u{0308}', '\u{0342}']),
        '\u{1FE8}' => Some(&['\u{03A5}', '\u{0306}']),
        '\u{1FE9}' => Some(&['\u{03A5}', '\u{0304}']),
        '\u{1FEA}' => Some(&['\u{03A5}', '\u{0300}']),
        '\u{1FEB}' => Some(&['\u{03A5}', '\u{0301}']),
        '\u{1FEC}' => Some(&['\u{03A1}', '\u{0314}']),
        '\u{1FED}' => Some(&['\u{00A8}', '\u{0300}']),
        '\u{1FEE}' => Some(&['\u{00A8}', '\u{0301}']),
        '\u{1FEF}' => Some(&['\u{0060}']),
        '\u{1FF2}' => Some(&['\u{03C9}', '\u{0300}', '\u{0345}']),
        '\u{1FF3}' => Some(&['\u{03C9}', '\u{0345}']),
        '\u{1FF4}' => Some(&['\u{03C9}', '\u{0301}', '\u{0345}']),
        '\u{1FF6}' => Some(&['\u{03C9}', '\u{0342}']),
        '\u{1FF7}' => Some(&['\u{03C9}', '\u{0342}', '\u{0345}']),
        '\u{1FF8}' => Some(&['\u{039F}', '\u{0300}']),
        '\u{1FF9}' => Some(&['\u{039F}', '\u{0301}']),
        '\u{1FFA}' => Some(&['\u{03A9}', '\u{0300}']),
        '\u{1FFB}' => Some(&['\u{03A9}', '\u{0301}']),
        '\u{1FFC}' => Some(&['\u{03A9}', '\u{0345}']),
        '\u{1FFD}' => Some(&['\u{00B4}']),
        '\u{2000}' => Some(&['\u{2002}']),
        '\u{2001}' => Some(&['\u{2003}']),
        '\u{2126}' => Some(&['\u{03A9}']),
        '\u{212A}' => Some(&['\u{004B}']),
        '\u{212B}' => Some(&['\u{0041}', '\u{030A}']),
        '\u{219A}' => Some(&['\u{2190}', '\u{0338}']),
        '\u{219B}' => Some(&['\u{2192}', '\u{0338}']),
        '\u{21AE}' => Some(&['\u{2194}', '\u{0338}']),
        '\u{21CD}' => Some(&['\u{21D0}', '\u{0338}']),
        '\u{21CE}' => Some(&['\u{21D4}', '\u{0338}']),
        '\u{21CF}' => Some(&['\u{21D2}', '\u{0338}']),
        '\u{2204}' => Some(&['\u{2203}', '\u{0338}']),
        '\u{2209}' => Some(&['\u{2208}', '\u{0338}']),
        '\u{220C}' => Some(&['\u{220B}', '\u{0338}']),
        '\u{2224}' => Some(&['\u{2223}', '\u{0338}']),
        '\u{2226}' => Some(&['\u{2225}', '\u{0338}']),
        '\u{2241}' => Some(&['\u{223C}', '\u{0338}']),
        '\u{2244}' => Some(&['\u{2243}', '\u{0338}']),
        '\u{2247}' => Some(&['\u{2245}', '\u{0338}']),
        '\u{2249}' => Some(&['\u{2248}', '\u{0338}']),
        '\u{2260}' => Some(&['\u{003D}', '\u{0338}']),
        '\u{2262}' => Some(&['\u{2261}', '\u{0338}']),
        '\u{226D}' => Some(&['\u{224D}', '\u{0338}']),
        '\u{226E}' => Some(&['\u{003C}', '\u{0338}']),
        '\u{226F}' => Some(&['\u{003E}', '\u{0338}']),
        '\u{2270}' => Some(&['\u{2264}', '\u{0338}']),
        '\u{2271}' => Some(&['\u{2265}', '\u{0338}']),
        '\u{2274}' => Some(&['\u{2272}', '\u{0338}']),
        '\u{2275}' => Some(&['\u{2273}', '\u{0338}']),
        '\u{2278}' => Some(&['\u{2276}', '\u{0338}']),
        '\u{2279}' => Some(&['\u{2277}', '\u{0338}']),
        '\u{2280}' => Some(&['\u{227A}', '\u{0338}']),
        '\u{2281}' => Some(&['\u{227B}', '\u{0338}']),
        '\u{2284}' => Some(&['\u{2282}', '\u{0338}']),
        '\u{2285}' => Some(&['\u{2283}', '\u{0338}']),
        '\u{2288}' => Some(&['\u{2286}', '\u{0338}']),
        '\u{2289}' => Some(&['\u{2287}', '\u{0338}']),
        '\u{22AC}' => Some(&['\u{22A2}', '\u{0338}']),
        '\u{22AD}' => Some(&['\u{22A8}', '\u{0338}']),
        '\u{22AE}' => Some(&['\u{22A9}', '\u{0338}']),
        '\u{22AF}' => Some(&['\u{22AB}', '\u{0338}']),
        '\u{22E0}' => Some(&['\u{227C}', '\u{0338}']),
        '\u{22E1}' => Some(&['\u{227D}', '\u{0338}']),
        '\u{22E2}' => Some(&['\u{2291}', '\u{0338}']),
        '\u{22E3}' => Some(&['\u{2292}', '\u{0338}']),
        '\u{22EA}' => Some(&['\u{22B2}', '\u{0338}']),
        '\u{22EB}' => Some(&['\u{22B3}', '\u{0338}']),
        '\u{22EC}' => Some(&['\u{22B4}', '\u{0338}']),
        '\u{22ED}' => Some(&['\u{22B5}', '\u{0338}']),
        '\u{2329}' => Some(&['\u{3008}']),
        '\u{232A}' => Some(&['\u{3009}']),
        '\u{2ADC}' => Some(&['\u{2ADD}', '\u{0338}']),
        '\u{304C}' => Some(&['\u{304B}', '\u{3099}']),
        '\u{304E}' => Some(&['\u{304D}', '\u{3099}']),
        '\u{3050}' => Some(&['\u{304F}', '\u{3099}']),
        '\u{3052}' => Some(&['\u{3051}', '\u{3099}']),
        '\u{3054}' => Some(&['\u{3053}', '\u{3099}']),
        '\u{3056}' => Some(&['\u{3055}', '\u{3099}']),
        '\u{3058}' => Some(&['\u{3057}', '\u{3099}']),
        '\u{305A}' => Some(&['\u{3059}', '\u{3099}']),
        '\u{305C}' => Some(&['\u{305B}', '\u{3099}']),
        '\u{305E}' => Some(&['\u{305D}', '\u{3099}']),
        '\u{3060}' => Some(&['\u{305F}', '\u{3099}']),
        '\u{3062}' => Some(&['\u{3061}', '\u{3099}']),
        '\u{3065}' => Some(&['\u{3064}', '\u{3099}']),
        '\u{3067}' => Some(&['\u{3066}', '\u{3099}']),
        '\u{3069}' => Some(&['\u{3068}', '\u{3099}']),
        '\u{3070}' => Some(&['\u{306F}', '\u{3099}']),
        '\u{3071}' => Some(&['\u{306F}', '\u{309A}']),
        '\u{3073}' => Some(&['\u{3072}', '\u{3099}']),
        '\u{3074}' => Some(&['\u{3072}', '\u{309A}']),
        '\u{3076}' => Some(&['\u{3075}', '\u{3099}']),
        '\u{3077}' => Some(&['\u{3075}', '\u{309A}']),
        '\u{3079}' => Some(&['\u{3078}', '\u{3099}']),
        '\u{307A}' => Some(&['\u{3078}', '\u{309A}']),
        '\u{307C}' => Some(&['\u{307B}', '\u{3099}']),
        '\u{307D}' => Some(&['\u{307B}', '\u{309A}']),
        '\u{3094}' => Some(&['\u{3046}', '\u{3099}']),
        '\u{309E}' => Some(&['\u{309D}', '\u{3099}']),
        '\u{30AC}' => Some(&['\u{30AB}', '\u{3099}']),
        '\u{30AE}' => Some(&['\u{30AD}', '\u{3099}']),
        '\u{30B0}' => Some(&['\u{30AF}', '\u{3099}']),
        '\u{30B2}' => Some(&['\u{30B1}', '\u{3099}']),
        '\u{30B4}' => Some(&['\u{30B3}', '\u{3099}']),
        '\u{30B6}' => Some(&['\u{30B5}', '\u{3099}']),
        '\u{30B8}' => Some(&['\u{30B7}', '\u{3099}']),
        '\u{30BA}' => Some(&['\u{30B9}', '\u{3099}']),
        '\u{30BC}' => Some(&['\u{30BB}', '\u{3099}']),
        '\u{30BE}' => Some(&['\u{30BD}', '\u{3099}']),
        '\u{30C0}' => Some(&['\u{30BF}', '\u{3099}']),
        '\u{30C2}' => Some(&['\u{30C1}', '\u{3099}']),
        '\u{30C5}' => Some(&['\u{30C4}', '\u{3099}']),
        '\u{30C7}' => Some(&['\u{30C6}', '\u{3099}']),
        '\u{30C9}' => Some(&['\u{30C8}', '\u{3099}']),
        '\u{30D0}' => Some(&['\u{30CF}', '\u{3099}']),
        '\u{30D1}' => Some(&['\u{30CF}', '\u{309A}']),
        '\u{30D3}' => Some(&['\u{30D2}', '\u{3099}']),
        '\u{30D4}' => Some(&['\u{30D2}', '\u{309A}']),
        '\u{30D6}' => Some(&['\u{30D5}', '\u{3099}']),
        '\u{30D7}' => Some(&['\u{30D5}', '\u{309A}']),
        '\u{30D9}' => Some(&['\u{30D8}', '\u{3099}']),
        '\u{30DA}' => Some(&['\u{30D8}', '\u{309A}']),
        '\u{30DC}' => Some(&['\u{30DB}', '\u{3099}']),
        '\u{30DD}' => Some(&['\u{30DB}', '\u{309A}']),
        '\u{30F4}' => Some(&['\u{30A6}', '\u{3099}']),
        '\u{30F7}' => Some(&['\u{30EF}', '\u{3099}']),
        '\u{30F8}' => Some(&['\u{30F0}', '\u{3099}']),
        '\u{30F9}' => Some(&['\u{30F1}', '\u{3099}']),
        '\u{30FA}' => Some(&['\u{30F2}', '\u{3099}']),
        '\u{30FE}' => Some(&['\u{30FD}', '\u{3099}']),
        '\u{F900}' => Some(&['\u{8C48}']),
        '\u{F901}' => Some(&['\u{66F4}']),
        '\u{F902}' => Some(&['\u{8ECA}']),
        '\u{F903}' => Some(&['\u{8CC8}']),
        '\u{F904}' => Some(&['\u{6ED1}']),
        '\u{F905}' => Some(&['\u{4E32}']),
        '\u{F906}' => Some(&['\u{53E5}']),
        '\u{F907}' => Some(&['\u{9F9C}']),
        '\u{F908}' => Some(&['\u{9F9C}']),
        '\u{F909}' => Some(&['\u{5951}']),
        '\u{F90A}' => Some(&['\u{91D1}']),
        '\u{F90B}' => Some(&['\u{5587}']),
        '\u{F90C}' => Some(&['\u{5948}']),
        '\u{F90D}' => Some(&['\u{61F6}']),
        '\u{F90E}' => Some(&['\u{7669}']),
        '\u{F90F}' => Some(&['\u{7F85}']),
        '\u{F910}' => Some(&['\u{863F}']),
        '\u{F911}' => Some(&['\u{87BA}']),
        '\u{F912}' => Some(&['\u{88F8}']),
        '\u{F913}' => Some(&['\u{908F}']),
        '\u{F914}' => Some(&['\u{6A02}']),
        '\u{F915}' => Some(&['\u{6D1B}']),
        '\u{F916}' => Some(&['\u{70D9}']),
        '\u{F917}' => Some(&['\u{73DE}']),
        '\u{F918}' => Some(&['\u{843D}']),
        '\u{F919}' => Some(&['\u{916A}']),
        '\u{F91A}' => Some(&['\u{99F1}']),
        '\u{F91B}' => Some(&['\u{4E82}']),
        '\u{F91C}' => Some(&['\u{5375}']),
        '\u{F91D}' => Some(&['\u{6B04}']),
        '\u{F91E}' => Some(&['\u{721B}']),
        '\u{F91F}' => Some(&['\u{862D}']),
        '\u{F920}' => Some(&['\u{9E1E}']),
        '\u{F921}' => Some(&['\u{5D50}']),
        '\u{F922}' => Some(&['\u{6FEB}']),
        '\u{F923}' => Some(&['\u{85CD}']),
        '\u{F924}' => Some(&['\u{8964}']),
        '\u{F925}' => Some(&['\u{62C9}']),
        '\u{F926}' => Some(&['\u{81D8}']),
        '\u{F927}' => Some(&['\u{881F}']),
        '\u{F928}' => Some(&['\u{5ECA}']),
        '\u{F929}' => Some(&['\u{6717}']),
        '\u{F92A}' => Some(&['\u{6D6A}']),
        '\u{F92B}' => Some(&['\u{72FC}']),
        '\u{F92C}' => Some(&['\u{90CE}']),
        '\u{F92D}' => Some(&['\u{4F86}']),
        '\u{F92E}' => Some(&['\u{51B7}']),
        '\u{F92F}' => Some(&['\u{52DE}']),
        '\u{F930}' => Some(&['\u{64C4}']),
        '\u{F931}' => Some(&['\u{6AD3}']),
        '\u{F932}' => Some(&['\u{7210}']),
        '\u{F933}' => Some(&['\u{76E7}']),
        '\u{F934}' => Some(&['\u{8001}']),
        '\u{F935}' => Some(&['\u{8606}']),
        '\u{F936}' => Some(&['\u{865C}']),
        '\u{F937}' => Some(&['\u{8DEF}']),
        '\u{F938}' => Some(&['\u{9732}']),
        '\u{F939}' => Some(&['\u{9B6F}']),
        '\u{F93A}' => Some(&['\u{9DFA}']),
        '\u{F93B}' => Some(&['\u{788C}']),
        '\u{F93C}' => Some(&['\u{797F}']),
        '\u{F93D}' => Some(&['\u{7DA0}']),
        '\u{F93E}' => Some(&['\u{83C9}']),
        '\u{F93F}' => Some(&['\u{9304}']),
        '\u{F940}' => Some(&['\u{9E7F}']),
        '\u{F941}' => Some(&['\u{8AD6}']),
        '\u{F942}' => Some(&['\u{58DF}']),
        '\u{F943}' => Some(&['\u{5F04}']),
        '\u{F944}' => Some(&['\u{7C60}']),
        '\u{F945}' => Some(&['\u{807E}']),
        '\u{F946}' => Some(&['\u{7262}']),
        '\u{F947}' => Some(&['\u{78CA}']),
        '\u{F948}' => Some(&['\u{8CC2}']),
        '\u{F949}' => Some(&['\u{96F7}']),
        '\u{F94A}' => Some(&['\u{58D8}']),
        '\u{F94B}' => Some(&['\u{5C62}']),
        '\u{F94C}' => Some(&['\u{6A13}']),
        '\u{F94D}' => Some(&['\u{6DDA}']),
        '\u{F94E}' => Some(&['\u{6F0F}']),
        '\u{F94F}' => Some(&['\u{7D2F}']),
        '\u{F950}' => Some(&['\u{7E37}']),
        '\u{F951}' => Some(&['\u{964B}']),
        '\u{F952}' => Some(&['\u{52D2}']),
        '\u{F953}' => Some(&['\u{808B}']),
        '\u{F954}' => Some(&['\u{51DC}']),
        '\u{F955}' => Some(&['\u{51CC}']),
        '\u{F956}' => Some(&['\u{7A1C}']),
        '\u{F957}' => Some(&['\u{7DBE}']),
        '\u{F958}' => Some(&['\u{83F1}']),
        '\u{F959}' => Some(&['\u{9675}']),
        '\u{F95A}' => Some(&['\u{8B80}']),
        '\u{F95B}' => Some(&['\u{62CF}']),
        '\u{F95C}' => Some(&['\u{6A02}']),
        '\u{F95D}' => Some(&['\u{8AFE}']),
        '\u{F95E}' => Some(&['\u{4E39}']),
        '\u{F95F}' => Some(&['\u{5BE7}']),
        '\u{F960}' => Some(&['\u{6012}']),
        '\u{F961}' => Some(&['\u{7387}']),
        '\u{F962}' => Some(&['\u{7570}']),
        '\u{F963}' => Some(&['\u{5317}']),
        '\u{F964}' => Some(&['\u{78FB}']),
        '\u{F965}' => Some(&['\u{4FBF}']),
        '\u{F966}' => Some(&['\u{5FA9}']),
        '\u{F967}' => Some(&['\u{4E0D}']),
        '\u{F968}' => Some(&['\u{6CCC}']),
        '\u{F969}' => Some(&['\u{6578}']),
        '\u{F96A}' => Some(&['\u{7D22}']),
        '\u{F96B}' => Some(&['\u{53C3}']),
        '\u{F96C}' => Some(&['\u{585E}']),
        '\u{F96D}' => Some(&['\u{7701}']),
        '\u{F96E}' => Some(&['\u{8449}']),
        '\u{F96F}' => Some(&['\u{8AAA}']),
        '\u{F970}' => Some(&['\u{6BBA}']),
        '\u{F971}' => Some(&['\u{8FB0}']),
        '\u{F972}' => Some(&['\u{6C88}']),
        '\u{F973}' => Some(&['\u{62FE}']),
        '\u{F974}' => Some(&['\u{82E5}']),
        '\u{F975}' => Some(&['\u{63A0}']),
        '\u{F976}' => Some(&['\u{7565}']),
        '\u{F977}' => Some(&['\u{4EAE}']),
        '\u{F978}' => Some(&['\u{5169}']),
        '\u{F979}' => Some(&['\u{51C9}']),
        '\u{F97A}' => Some(&['\u{6881}']),
        '\u{F97B}' => Some(&['\u{7CE7}']),
        '\u{F97C}' => Some(&['\u{826F}']),
        '\u{F97D}' => Some(&['\u{8AD2}']),
        '\u{F97E}' => Some(&['\u{91CF}']),
        '\u{F97F}' => Some(&['\u{52F5}']),
        '\u{F980}' => Some(&['\u{5442}']),
        '\u{F981}' => Some(&['\u{5973}']),
        '\u{F982}' => Some(&['\u{5EEC}']),
        '\u{F983}' => Some(&['\u{65C5}']),
        '\u{F984}' => Some(&['\u{6FFE}']),
        '\u{F985}' => Some(&['\u{792A}']),
        '\u{F986}' => Some(&['\u{95AD}']),
        '\u{F987}' => Some(&['\u{9A6A}']),
        '\u{F988}' => Some(&['\u{9E97}']),
        '\u{F989}' => Some(&['\u{9ECE}']),
        '\u{F98A}' => Some(&['\u{529B}']),
        '\u{F98B}' => Some(&['\u{66C6}']),
        '\u{F98C}' => Some(&['\u{6B77}']),
        '\u{F98D}' => Some(&['\u{8F62}']),
        '\u{F98E}' => Some(&['\u{5E74}']),
        '\u{F98F}' => Some(&['\u{6190}']),
        '\u{F990}' => Some(&['\u{6200}']),
        '\u{F991}' => Some(&['\u{649A}']),
        '\u{F992}' => Some(&['\u{6F23}']),
        '\u{F993}' => Some(&['\u{7149}']),
        '\u{F994}' => Some(&['\u{7489}']),
        '\u{F995}' => Some(&['\u{79CA}']),
        '\u{F996}' => Some(&['\u{7DF4}']),
        '\u{F997}' => Some(&['\u{806F}']),
        '\u{F998}' => Some(&['\u{8F26}']),
        '\u{F999}' => Some(&['\u{84EE}']),
        '\u{F99A}' => Some(&['\u{9023}']),
        '\u{F99B}' => Some(&['\u{934A}']),
        '\u{F99C}' => Some(&['\u{5217}']),
        '\u{F99D}' => Some(&['\u{52A3}']),
        '\u{F99E}' => Some(&['\u{54BD}']),
        '\u{F99F}' => Some(&['\u{70C8}']),
        '\u{F9A0}' => Some(&['\u{88C2}']),
        '\u{F9A1}' => Some(&['\u{8AAA}']),
        '\u{F9A2}' => Some(&['\u{5EC9}']),
        '\u{F9A3}' => Some(&['\u{5FF5}']),
        '\u{F9A4}' => Some(&['\u{637B}']),
        '\u{F9A5}' => Some(&['\u{6BAE}']),
        '\u{F9A6}' => Some(&['\u{7C3E}']),
        '\u{F9A7}' => Some(&['\u{7375}']),
        '\u{F9A8}' => Some(&['\u{4EE4}']),
        '\u{F9A9}' => Some(&['\u{56F9}']),
        '\u{F9AA}' => Some(&['\u{5BE7}']),
        '\u{F9AB}' => Some(&['\u{5DBA}']),
        '\u{F9AC}' => Some(&['\u{601C}']),
        '\u{F9AD}' => Some(&['\u{73B2}']),
        '\u{F9AE}' => Some(&['\u{7469}']),
        '\u{F9AF}' => Some(&['\u{7F9A}']),
        '\u{F9B0}' => Some(&['\u{8046}']),
        '\u{F9B1}' => Some(&['\u{9234}']),
        '\u{F9B2}' => Some(&['\u{96F6}']),
        '\u{F9B3}' => Some(&['\u{9748}']),
        '\u{F9B4}' => Some(&['\u{9818}']),
        '\u{F9B5}' => Some(&['\u{4F8B}']),
        '\u{F9B6}' => Some(&['\u{79AE}']),
        '\u{F9B7}' => Some(&['\u{91B4}']),
        '\u{F9B8}' => Some(&['\u{96B8}']),
        '\u{F9B9}' => Some(&['\u{60E1}']),
        '\u{F9BA}' => Some(&['\u{4E86}']),
        '\u{F9BB}' => Some(&['\u{50DA}']),
        '\u{F9BC}' => Some(&['\u{5BEE}']),
        '\u{F9BD}' => Some(&['\u{5C3F}']),
        '\u{F9BE}' => Some(&['\u{6599}']),
        '\u{F9BF}' => Some(&['\u{6A02}']),
        '\u{F9C0}' => Some(&['\u{71CE}']),
        '\u{F9C1}' => Some(&['\u{7642}']),
        '\u{F9C2}' => Some(&['\u{84FC}']),
        '\u{F9C3}' => Some(&['\u{907C}']),
        '\u{F9C4}' => Some(&['\u{9F8D}']),
        '\u{F9C5}' => Some(&['\u{6688}']),
        '\u{F9C6}' => Some(&['\u{962E}']),
        '\u{F9C7}' => Some(&['\u{5289}']),
        '\u{F9C8}' => Some(&['\u{677B}']),
        '\u{F9C9}' => Some(&['\u{67F3}']),
        '\u{F9CA}' => Some(&['\u{6D41}']),
        '\u{F9CB}' => Some(&['\u{6E9C}']),
        '\u{F9CC}' => Some(&['\u{7409}']),
        '\u{F9CD}' => Some(&['\u{7559}']),
        '\u{F9CE}' => Some(&['\u{786B}']),
        '\u{F9CF}' => Some(&['\u{7D10}']),
        '\u{F9D0}' => Some(&['\u{985E}']),
        '\u{F9D1}' => Some(&['\u{516D}']),
        '\u{F9D2}' => Some(&['\u{622E}']),
        '\u{F9D3}' => Some(&['\u{9678}']),
        '\u{F9D4}' => Some(&['\u{502B}']),
        '\u{F9D5}' => Some(&['\u{5D19}']),
        '\u{F9D6}' => Some(&['\u{6DEA}']),
        '\u{F9D7}' => Some(&['\u{8F2A}']),
        '\u{F9D8}' => Some(&['\u{5F8B}']),
        '\u{F9D9}' => Some(&['\u{6144}']),
        '\u{F9DA}' => Some(&['\u{6817}']),
        '\u{F9DB}' => Some(&['\u{7387}']),
        '\u{F9DC}' => Some(&['\u{9686}']),
        '\u{F9DD}' => Some(&['\u{5229}']),
        '\u{F9DE}' => Some(&['\u{540F}']),
        '\u{F9DF}' => Some(&['\u{5C65}']),
        '\u{F9E0}' => Some(&['\u{6613}']),
        '\u{F9E1}' => Some(&['\u{674E}']),
        '\u{F9E2}' => Some(&['\u{68A8}']),
        '\u{F9E3}' => Some(&['\u{6CE5}']),
        '\u{F9E4}' => Some(&['\u{7406}']),
        '\u{F9E5}' => Some(&['\u{75E2}']),
        '\u{F9E6}' => Some(&['\u{7F79}']),
        '\u{F9E7}' => Some(&['\u{88CF}']),
        '\u{F9E8}' => Some(&['\u{88E1}']),
        '\u{F9E9}' => Some(&['\u{91CC}']),
        '\u{F9EA}' => Some(&['\u{96E2}']),
        '\u{F9EB}' => Some(&['\u{533F}']),
        '\u{F9EC}' => Some(&['\u{6EBA}']),
        '\u{F9ED}' => Some(&['\u{541D}']),
        '\u{F9EE}' => Some(&['\u{71D0}']),
        '\u{F9EF}' => Some(&['\u{7498}']),
        '\u{F9F0}' => Some(&['\u{85FA}']),
        '\u{F9F1}' => Some(&['\u{96A3}']),
        '\u{F9F2}' => Some(&['\u{9C57}']),
        '\u{F9F3}' => Some(&['\u{9E9F}']),
        '\u{F9F4}' => Some(&['\u{6797}']),
        '\u{F9F5}' => Some(&['\u{6DCB}']),
        '\u{F9F6}' => Some(&['\u{81E8}']),
        '\u{F9F7}' => Some(&['\u{7ACB}']),
        '\u{F9F8}' => Some(&['\u{7B20}']),
        '\u{F9F9}' => Some(&['\u{7C92}']),
        '\u{F9FA}' => Some(&['\u{72C0}']),
        '\u{F9FB}' => Some(&['\u{7099}']),
        '\u{F9FC}' => Some(&['\u{8B58}']),
        '\u{F9FD}' => Some(&['\u{4EC0}']),
        '\u{F9FE}' => Some(&['\u{8336}']),
        '\u{F9FF}' => Some(&['\u{523A}']),
        '\u{FA00}' => Some(&['\u{5207}']),
        '\u{FA01}' => Some(&['\u{5EA6}']),
        '\u{FA02}' => Some(&['\u{62D3}']),
        '\u{FA03}' => Some(&['\u{7CD6}']),
        '\u{FA04}' => Some(&['\u{5B85}']),
        '\u{FA05}' => Some(&['\u{6D1E}']),
        '\u{FA06}' => Some(&['\u{66B4}']),
        '\u{FA07}' => Some(&['\u{8F3B}']),
        '\u{FA08}' => Some(&['\u{884C}']),
        '\u{FA09}' => Some(&['\u{964D}']),
        '\u{FA0A}' => Some(&['\u{898B}']),
        '\u{FA0B}' => Some(&['\u{5ED3}']),
        '\u{FA0C}' => Some(&['\u{5140}']),
        '\u{FA0D}' => Some(&['\u{55C0}']),
        '\u{FA10}' => Some(&['\u{585A}']),
        '\u{FA12}' => Some(&['\u{6674}']),
        '\u{FA15}' => Some(&['\u{51DE}']),
        '\u{FA16}' => Some(&['\u{732A}']),
        '\u{FA17}' => Some(&['\u{76CA}']),
        '\u{FA18}' => Some(&['\u{793C}']),
        '\u{FA19}' => Some(&['\u{795E}']),
        '\u{FA1A}' => Some(&['\u{7965}']),
        '\u{FA1B}' => Some(&['\u{798F}']),
        '\u{FA1C}' => Some(&['\u{9756}']),
        '\u{FA1D}' => Some(&['\u{7CBE}']),
        '\u{FA1E}' => Some(&['\u{7FBD}']),
        '\u{FA20}' => Some(&['\u{8612}']),
        '\u{FA22}' => Some(&['\u{8AF8}']),
        '\u{FA25}' => Some(&['\u{9038}']),
        '\u{FA26}' => Some(&['\u{90FD}']),
        '\u{FA2A}' => Some(&['\u{98EF}']),
        '\u{FA2B}' => Some(&['\u{98FC}']),
        '\u{FA2C}' => Some(&['\u{9928}']),
        '\u{FA2D}' => Some(&['\u{9DB4}']),
        '\u{FA2E}' => Some(&['\u{90DE}']),
        '\u{FA2F}' => Some(&['\u{96B7}']),
        '\u{FA30}' => Some(&['\u{4FAE}']),
        '\u{FA31}' => Some(&['\u{50E7}']),
        '\u{FA32}' => Some(&['\u{514D}']),
        '\u{FA33}' => Some(&['\u{52C9}']),
        '\u{FA34}' => Some(&['\u{52E4}']),
        '\u{FA35}' => Some(&['\u{5351}']),
        '\u{FA36}' => Some(&['\u{559D}']),
        '\u{FA37}' => Some(&['\u{5606}']),
        '\u{FA38}' => Some(&['\u{5668}']),
        '\u{FA39}' => Some(&['\u{5840}']),
        '\u{FA3A}' => Some(&['\u{58A8}']),
        '\u{FA3B}' => Some(&['\u{5C64}']),
        '\u{FA3C}' => Some(&['\u{5C6E}']),
        '\u{FA3D}' => Some(&['\u{6094}']),
        '\u{FA3E}' => Some(&['\u{6168}']),
        '\u{FA3F}' => Some(&['\u{618E}']),
        '\u{FA40}' => Some(&['\u{61F2}']),
        '\u{FA41}' => Some(&['\u{654F}']),
        '\u{FA42}' => Some(&['\u{65E2}']),
        '\u{FA43}' => Some(&['\u{6691}']),
        '\u{FA44}' => Some(&['\u{6885}']),
        '\u{FA45}' => Some(&['\u{6D77}']),
        '\u{FA46}' => Some(&['\u{6E1A}']),
        '\u{FA47}' => Some(&['\u{6F22}']),
        '\u{FA48}' => Some(&['\u{716E}']),
        '\u{FA49}' => Some(&['\u{722B}']),
        '\u{FA4A}' => Some(&['\u{7422}']),
        '\u{FA4B}' => Some(&['\u{7891}']),
        '\u{FA4C}' => Some(&['\u{793E}']),
        '\u{FA4D}' => Some(&['\u{7949}']),
        '\u{FA4E}' => Some(&['\u{7948}']),
        '\u{FA4F}' => Some(&['\u{7950}']),
        '\u{FA50}' => Some(&['\u{7956}']),
        '\u{FA51}' => Some(&['\u{795D}']),
        '\u{FA52}' => Some(&['\u{798D}']),
        '\u{FA53}' => Some(&['\u{798E}']),
        '\u{FA54}' => Some(&['\u{7A40}']),
        '\u{FA55}' => Some(&['\u{7A81}']),
        '\u{FA56}' => Some(&['\u{7BC0}']),
        '\u{FA57}' => Some(&['\u{7DF4}']),
        '\u{FA58}' => Some(&['\u{7E09}']),
        '\u{FA59}' => Some(&['\u{7E41}']),
        '\u{FA5A}' => Some(&['\u{7F72}']),
        '\u{FA5B}' => Some(&['\u{8005}']),
        '\u{FA5C}' => Some(&['\u{81ED}']),
        '\u{FA5D}' => Some(&['\u{8279}']),
        '\u{FA5E}' => Some(&['\u{8279}']),
        '\u{FA5F}' => Some(&['\u{8457}']),
        '\u{FA60}' => Some(&['\u{8910}']),
        '\u{FA61}' => Some(&['\u{8996}']),
        '\u{FA62}' => Some(&['\u{8B01}']),
        '\u{FA63}' => Some(&['\u{8B39}']),
        '\u{FA64}' => Some(&['\u{8CD3}']),
        '\u{FA65}' => Some(&['\u{8D08}']),
        '\u{FA66}' => Some(&['\u{8FB6}']),
        '\u{FA67}' => Some(&['\u{9038}']),
        '\u{FA68}' => Some(&['\u{96E3}']),
        '\u{FA69}' => Some(&['\u{97FF}']),
        '\u{FA6A}' => Some(&['\u{983B}']),
        '\u{FA6B}' => Some(&['\u{6075}']),
        '\u{FA6C}' => Some(&['\u{242EE}']),
        '\u{FA6D}' => Some(&['\u{8218}']),
        '\u{FA70}' => Some(&['\u{4E26}']),
        '\u{FA71}' => Some(&['\u{51B5}']),
        '\u{FA72}' => Some(&['\u{5168}']),
        '\u{FA73}' => Some(&['\u{4F80}']),
        '\u{FA74}' => Some(&['\u{5145}']),
        '\u{FA75}' => Some(&['\u{5180}']),
        '\u{FA76}' => Some(&['\u{52C7}']),
        '\u{FA77}' => Some(&['\u{52FA}']),
        '\u{FA78}' => Some(&['\u{559D}']),
        '\u{FA79}' => Some(&['\u{5555}']),
        '\u{FA7A}' => Some(&['\u{5599}']),
        '\u{FA7B}' => Some(&['\u{55E2}']),
        '\u{FA7C}' => Some(&['\u{585A}']),
        '\u{FA7D}' => Some(&['\u{58B3}']),
        '\u{FA7E}' => Some(&['\u{5944}']),
        '\u{FA7F}' => Some(&['\u{5954}']),
        '\u{FA80}' => Some(&['\u{5A62}']),
        '\u{FA81}' => Some(&['\u{5B28}']),
        '\u{FA82}' => Some(&['\u{5ED2}']),
        '\u{FA83}' => Some(&['\u{5ED9}']),
        '\u{FA84}' => Some(&['\u{5F69}']),
        '\u{FA85}' => Some(&['\u{5FAD}']),
        '\u{FA86}' => Some(&['\u{60D8}']),
        '\u{FA87}' => Some(&['\u{614E}']),
        '\u{FA88}' => Some(&['\u{6108}']),
        '\u{FA89}' => Some(&['\u{618E}']),
        '\u{FA8A}' => Some(&['\u{6160}']),
        '\u{FA8B}' => Some(&['\u{61F2}']),
        '\u{FA8C}' => Some(&['\u{6234}']),
        '\u{FA8D}' => Some(&['\u{63C4}']),
        '\u{FA8E}' => Some(&['\u{641C}']),
        '\u{FA8F}' => Some(&['\u{6452}']),
        '\u{FA90}' => Some(&['\u{6556}']),
        '\u{FA91}' => Some(&['\u{6674}']),
        '\u{FA92}' => Some(&['\u{6717}']),
        '\u{FA93}' => Some(&['\u{671B}']),
        '\u{FA94}' => Some(&['\u{6756}']),
        '\u{FA95}' => Some(&['\u{6B79}']),
        '\u{FA96}' => Some(&['\u{6BBA}']),
        '\u{FA97}' => Some(&['\u{6D41}']),
        '\u{FA98}' => Some(&['\u{6EDB}']),
        '\u{FA99}' => Some(&['\u{6ECB}']),
        '\u{FA9A}' => Some(&['\u{6F22}']),
        '\u{FA9B}' => Some(&['\u{701E}']),
        '\u{FA9C}' => Some(&['\u{716E}']),
        '\u{FA9D}' => Some(&['\u{77A7}']),
        '\u{FA9E}' => Some(&['\u{7235}']),
        '\u{FA9F}' => Some(&['\u{72AF}']),
        '\u{FAA0}' => Some(&['\u{732A}']),
        '\u{FAA1}' => Some(&['\u{7471}']),
        '\u{FAA2}' => Some(&['\u{7506}']),
        '\u{FAA3}' => Some(&['\u{753B}']),
        '\u{FAA4}' => Some(&['\u{761D}']),
        '\u{FAA5}' => Some(&['\u{761F}']),
        '\u{FAA6}' => Some(&['\u{76CA}']),
        '\u{FAA7}' => Some(&['\u{76DB}']),
        '\u{FAA8}' => Some(&['\u{76F4}']),
        '\u{FAA9}' => Some(&['\u{774A}']),
        '\u{FAAA}' => Some(&['\u{7740}']),
        '\u{FAAB}' => Some(&['\u{78CC}']),
        '\u{FAAC}' => Some(&['\u{7AB1}']),
        '\u{FAAD}' => Some(&['\u{7BC0}']),
        '\u{FAAE}' => Some(&['\u{7C7B}']),
        '\u{FAAF}' => Some(&['\u{7D5B}']),
        '\u{FAB0}' => Some(&['\u{7DF4}']),
        '\u{FAB1}' => Some(&['\u{7F3E}']),
        '\u{FAB2}' => Some(&['\u{8005}']),
        '\u{FAB3}' => Some(&['\u{8352}']),
        '\u{FAB4}' => Some(&['\u{83EF}']),
        '\u{FAB5}' => Some(&['\u{8779}']),
        '\u{FAB6}' => Some(&['\u{8941}']),
        '\u{FAB7}' => Some(&['\u{8986}']),
        '\u{FAB8}' => Some(&['\u{8996}']),
        '\u{FAB9}' => Some(&['\u{8ABF}']),
        '\u{FABA}' => Some(&['\u{8AF8}']),
        '\u{FABB}' => Some(&['\u{8ACB}']),
        '\u{FABC}' => Some(&['\u{8B01}']),
        '\u{FABD}' => Some(&['\u{8AFE}']),
        '\u{FABE}' => Some(&['\u{8AED}']),
        '\u{FABF}' => Some(&['\u{8B39}']),
        '\u{FAC0}' => Some(&['\u{8B8A}']),
        '\u{FAC1}' => Some(&['\u{8D08}']),
        '\u{FAC2}' => Some(&['\u{8F38}']),
        '\u{FAC3}' => Some(&['\u{9072}']),
        '\u{FAC4}' => Some(&['\u{9199}']),
        '\u{FAC5}' => Some(&['\u{9276}']),
        '\u{FAC6}' => Some(&['\u{967C}']),
        '\u{FAC7}' => Some(&['\u{96E3}']),
        '\u{FAC8}' => Some(&['\u{9756}']),
        '\u{FAC9}' => Some(&['\u{97DB}']),
        '\u{FACA}' => Some(&['\u{97FF}']),
        '\u{FACB}' => Some(&['\u{980B}']),
        '\u{FACC}' => Some(&['\u{983B}']),
        '\u{FACD}' => Some(&['\u{9B12}']),
        '\u{FACE}' => Some(&['\u{9F9C}']),
        '\u{FACF}' => Some(&['\u{2284A}']),
        '\u{FAD0}' => Some(&['\u{22844}']),
        '\u{FAD1}' => Some(&['\u{233D5}']),
        '\u{FAD2}' => Some(&['\u{3B9D}']),
        '\u{FAD3}' => Some(&['\u{4018}']),
        '\u{FAD4}' => Some(&['\u{4039}']),
        '\u{FAD5}' => Some(&['\u{25249}']),
        '\u{FAD6}' => Some(&['\u{25CD0}']),
        '\u{FAD7}' => Some(&['\u{27ED3}']),
        '\u{FAD8}' => Some(&['\u{9F43}']),
        '\u{FAD9}' => Some(&['\u{9F8E}']),
        '\u{FB1D}' => Some(&['\u{05D9}', '\u{05B4}']),
        '\u{FB1F}' => Some(&['\u{05F2}', '\u{05B7}']),
        '\u{FB2A}' => Some(&['\u{05E9}', '\u{05C1}']),
        '\u{FB2B}' => Some(&['\u{05E9}', '\u{05C2}']),
        '\u{FB2C}' => Some(&['\u{05E9}', '\u{05BC}', '\u{05C1}']),
        '\u{FB2D}' => Some(&['\u{05E9}', '\u{05BC}', '\u{05C2}']),
        '\u{FB2E}' => Some(&['\u{05D0}', '\u{05B7}']),
        '\u{FB2F}' => Some(&['\u{05D0}', '\u{05B8}']),
        '\u{FB30}' => Some(&['\u{05D0}', '\u{05BC}']),
        '\u{FB31}' => Some(&['\u{05D1}', '\u{05BC}']),
        '\u{FB32}' => Some(&['\u{05D2}', '\u{05BC}']),
        '\u{FB33}' => Some(&['\u{05D3}', '\u{05BC}']),
        '\u{FB34}' => Some(&['\u{05D4}', '\u{05BC}']),
        '\u{FB35}' => Some(&['\u{05D5}', '\u{05BC}']),
        '\u{FB36}' => Some(&['\u{05D6}', '\u{05BC}']),
        '\u{FB38}' => Some(&['\u{05D8}', '\u{05BC}']),
        '\u{FB39}' => Some(&['\u{05D9}', '\u{05BC}']),
        '\u{FB3A}' => Some(&['\u{05DA}', '\u{05BC}']),
        '\u{FB3B}' => Some(&['\u{05DB}', '\u{05BC}']),
        '\u{FB3C}' => Some(&['\u{05DC}', '\u{05BC}']),
        '\u{FB3E}' => Some(&['\u{05DE}', '\u{05BC}']),
        '\u{FB40}' => Some(&['\u{05E0}', '\u{05BC}']),
        '\u{FB41}' => Some(&['\u{05E1}', '\u{05BC}']),
        '\u{FB43}' => Some(&['\u{05E3}', '\u{05BC}']),
        '\u{FB44}' => Some(&['\u{05E4}', '\u{05BC}']),
        '\u{FB46}' => Some(&['\u{05E6}', '\u{05BC}']),
        '\u{FB47}' => Some(&['\u{05E7}', '\u{05BC}']),
        '\u{FB48}' => Some(&['\u{05E8}', '\u{05BC}']),
        '\u{FB49}' => Some(&['\u{05E9}', '\u{05BC}']),
        '\u{FB4A}' => Some(&['\u{05EA}', '\u{05BC}']),
        '\u{FB4B}' => Some(&['\u{05D5}', '\u{05B9}']),
        '\u{FB4C}' => Some(&['\u{05D1}', '\u{05BF}']),
        '\u{FB4D}' => Some(&['\u{05DB}', '\u{05BF}']),
        '\u{FB4E}' => Some(&['\u{05E4}', '\u{05BF}']),
        '\u{1109A}' => Some(&['\u{11099}', '\u{110BA}']),
        '\u{1109C}' => Some(&['\u{1109B}', '\u{110BA}']),
        '\u{110AB}' => Some(&['\u{110A5}', '\u{110BA}']),
        '\u{1112E}' => Some(&['\u{11131}', '\u{11127}']),
        '\u{1112F}' => Some(&['\u{11132}', '\u{11127}']),
        '\u{1134B}' => Some(&['\u{11347}', '\u{1133E}']),
        '\u{1134C}' => Some(&['\u{11347}', '\u{11357}']),
        '\u{114BB}' => Some(&['\u{114B9}', '\u{114BA}']),
        '\u{114BC}' => Some(&['\u{114B9}', '\u{114B0}']),
        '\u{114BE}' => Some(&['\u{114B9}', '\u{114BD}']),
        '\u{115BA}' => Some(&['\u{115B8}', '\u{115AF}']),
        '\u{115BB}' => Some(&['\u{115B9}', '\u{115AF}']),
        '\u{1D15E}' => Some(&['\u{1D157}', '\u{1D165}']),
        '\u{1D15F}' => Some(&['\u{1D158}', '\u{1D165}']),
        '\u{1D160}' => Some(&['\u{1D158}', '\u{1D165}', '\u{1D16E}']),
        '\u{1D161}' => Some(&['\u{1D158}', '\u{1D165}', '\u{1D16F}']),
        '\u{1D162}' => Some(&['\u{1D158}', '\u{1D165}', '\u{1D170}']),
        '\u{1D163}' => Some(&['\u{1D158}', '\u{1D165}', '\u{1D171}']),
        '\u{1D164}' => Some(&['\u{1D158}', '\u{1D165}', '\u{1D172}']),
        '\u{1D1BB}' => Some(&['\u{1D1B9}', '\u{1D165}']),
        '\u{1D1BC}' => Some(&['\u{1D1BA}', '\u{1D165}']),
        '\u{1D1BD}' => Some(&['\u{1D1B9}', '\u{1D165}', '\u{1D16E}']),
        '\u{1D1BE}' => Some(&['\u{1D1BA}', '\u{1D165}', '\u{1D16E}']),
        '\u{1D1BF}' => Some(&['\u{1D1B9}', '\u{1D165}', '\u{1D16F}']),
        '\u{1D1C0}' => Some(&['\u{1D1BA}', '\u{1D165}', '\u{1D16F}']),
        '\u{2F800}' => Some(&['\u{4E3D}']),
        '\u{2F801}' => Some(&['\u{4E38}']),
        '\u{2F802}' => Some(&['\u{4E41}']),
        '\u{2F803}' => Some(&['\u{20122}']),
        '\u{2F804}' => Some(&['\u{4F60}']),
        '\u{2F805}' => Some(&['\u{4FAE}']),
        '\u{2F806}' => Some(&['\u{4FBB}']),
        '\u{2F807}' => Some(&['\u{5002}']),
        '\u{2F808}' => Some(&['\u{507A}']),
        '\u{2F809}' => Some(&['\u{5099}']),
        '\u{2F80A}' => Some(&['\u{50E7}']),
        '\u{2F80B}' => Some(&['\u{50CF}']),
        '\u{2F80C}' => Some(&['\u{349E}']),
        '\u{2F80D}' => Some(&['\u{2063A}']),
        '\u{2F80E}' => Some(&['\u{514D}']),
        '\u{2F80F}' => Some(&['\u{5154}']),
        '\u{2F810}' => Some(&['\u{5164}']),
        '\u{2F811}' => Some(&['\u{5177}']),
        '\u{2F812}' => Some(&['\u{2051C}']),
        '\u{2F813}' => Some(&['\u{34B9}']),
        '\u{2F814}' => Some(&['\u{5167}']),
        '\u{2F815}' => Some(&['\u{518D}']),
        '\u{2F816}' => Some(&['\u{2054B}']),
        '\u{2F817}' => Some(&['\u{5197}']),
        '\u{2F818}' => Some(&['\u{51A4}']),
        '\u{2F819}' => Some(&['\u{4ECC}']),
        '\u{2F81A}' => Some(&['\u{51AC}']),
        '\u{2F81B}' => Some(&['\u{51B5}']),
        '\u{2F81C}' => Some(&['\u{291DF}']),
        '\u{2F81D}' => Some(&['\u{51F5}']),
        '\u{2F81E}' => Some(&['\u{5203}']),
        '\u{2F81F}' => Some(&['\u{34DF}']),
        '\u{2F820}' => Some(&['\u{523B}']),
        '\u{2F821}' => Some(&['\u{5246}']),
        '\u{2F822}' => Some(&['\u{5272}']),
        '\u{2F823}' => Some(&['\u{5277}']),
        '\u{2F824}' => Some(&['\u{3515}']),
        '\u{2F825}' => Some(&['\u{52C7}']),
        '\u{2F826}' => Some(&['\u{52C9}']),
        '\u{2F827}' => Some(&['\u{52E4}']),
        '\u{2F828}' => Some(&['\u{52FA}']),
        '\u{2F829}' => Some(&['\u{5305}']),
        '\u{2F82A}' => Some(&['\u{5306}']),
        '\u{2F82B}' => Some(&['\u{5317}']),
        '\u{2F82C}' => Some(&['\u{5349}']),
        '\u{2F82D}' => Some(&['\u{5351}']),
        '\u{2F82E}' => Some(&['\u{535A}']),
        '\u{2F82F}' => Some(&['\u{5373}']),
        '\u{2F830}' => Some(&['\u{537D}']),
        '\u{2F831}' => Some(&['\u{537F}']),
        '\u{2F832}' => Some(&['\u{537F}']),
        '\u{2F833}' => Some(&['\u{537F}']),
        '\u{2F834}' => Some(&['\u{20A2C}']),
        '\u{2F835}' => Some(&['\u{7070}']),
        '\u{2F836}' => Some(&['\u{53CA}']),
        '\u{2F837}' => Some(&['\u{53DF}']),
        '\u{2F838}' => Some(&['\u{20B63}']),
        '\u{2F839}' => Some(&['\u{53EB}']),
        '\u{2F83A}' => Some(&['\u{53F1}']),
        '\u{2F83B}' => Some(&['\u{5406}']),
        '\u{2F83C}' => Some(&['\u{549E}']),
        '\u{2F83D}' => Some(&['\u{5438}']),
        '\u{2F83E}' => Some(&['\u{5448}']),
        '\u{2F83F}' => Some(&['\u{5468}']),
        '\u{2F840}' => Some(&['\u{54A2}']),
        '\u{2F841}' => Some(&['\u{54F6}']),
        '\u{2F842}' => Some(&['\u{5510}']),
        '\u{2F843}' => Some(&['\u{5553}']),
        '\u{2F844}' => Some(&['\u{5563}']),
        '\u{2F845}' => Some(&['\u{5584}']),
        '\u{2F846}' => Some(&['\u{5584}']),
        '\u{2F847}' => Some(&['\u{5599}']),
        '\u{2F848}' => Some(&['\u{55AB}']),
        '\u{2F849}' => Some(&['\u{55B3}']),
        '\u{2F84A}' => Some(&['\u{55C2}']),
        '\u{2F84B}' => Some(&['\u{5716}']),
        '\u{2F84C}' => Some(&['\u{5606}']),
        '\u{2F84D}' => Some(&['\u{5717}']),
        '\u{2F84E}' => Some(&['\u{5651}']),
        '\u{2F84F}' => Some(&['\u{5674}']),
        '\u{2F850}' => Some(&['\u{5207}']),
        '\u{2F851}' => Some(&['\u{58EE}']),
        '\u{2F852}' => Some(&['\u{57CE}']),
        '\u{2F853}' => Some(&['\u{57F4}']),
        '\u{2F854}' => Some(&['\u{580D}']),
        '\u{2F855}' => Some(&['\u{578B}']),
        '\u{2F856}' => Some(&['\u{5832}']),
        '\u{2F857}' => Some(&['\u{5831}']),
        '\u{2F858}' => Some(&['\u{58AC}']),
        '\u{2F859}' => Some(&['\u{214E4}']),
        '\u{2F85A}' => Some(&['\u{58F2}']),
        '\u{2F85B}' => Some(&['\u{58F7}']),
        '\u{2F85C}' => Some(&['\u{5906}']),
        '\u{2F85D}' => Some(&['\u{591A}']),
        '\u{2F85E}' => Some(&['\u{5922}']),
        '\u{2F85F}' => Some(&['\u{5962}']),
        '\u{2F860}' => Some(&['\u{216A8}']),
        '\u{2F861}' => Some(&['\u{216EA}']),
        '\u{2F862}' => Some(&['\u{59EC}']),
        '\u{2F863}' => Some(&['\u{5A1B}']),
        '\u{2F864}' => Some(&['\u{5A27}']),
        '\u{2F865}' => Some(&['\u{59D8}']),
        '\u{2F866}' => Some(&['\u{5A66}']),
        '\u{2F867}' => Some(&['\u{36EE}']),
        '\u{2F868}' => Some(&['\u{36FC}']),
        '\u{2F869}' => Some(&['\u{5B08}']),
        '\u{2F86A}' => Some(&['\u{5B3E}']),
        '\u{2F86B}' => Some(&['\u{5B3E}']),
        '\u{2F86C}' => Some(&['\u{219C8}']),
        '\u{2F86D}' => Some(&['\u{5BC3}']),
        '\u{2F86E}' => Some(&['\u{5BD8}']),
        '\u{2F86F}' => Some(&['\u{5BE7}']),
        '\u{2F870}' => Some(&['\u{5BF3}']),
        '\u{2F871}' => Some(&['\u{21B18}']),
        '\u{2F872}' => Some(&['\u{5BFF}']),
        '\u{2F873}' => Some(&['\u{5C06}']),
        '\u{2F874}' => Some(&['\u{5F53}']),
        '\u{2F875}' => Some(&['\u{5C22}']),
        '\u{2F876}' => Some(&['\u{3781}']),
        '\u{2F877}' => Some(&['\u{5C60}']),
        '\u{2F878}' => Some(&['\u{5C6E}']),
        '\u{2F879}' => Some(&['\u{5CC0}']),
        '\u{2F87A}' => Some(&['\u{5C8D}']),
        '\u{2F87B}' => Some(&['\u{21DE4}']),
        '\u{2F87C}' => Some(&['\u{5D43}']),
        '\u{2F87D}' => Some(&['\u{21DE6}']),
        '\u{2F87E}' => Some(&['\u{5D6E}']),
        '\u{2F87F}' => Some(&['\u{5D6B}']),
        '\u{2F880}' => Some(&['\u{5D7C}']),
        '\u{2F881}' => Some(&['\u{5DE1}']),
        '\u{2F882}' => Some(&['\u{5DE2}']),
        '\u{2F883}' => Some(&['\u{382F}']),
        '\u{2F884}' => Some(&['\u{5DFD}']),
        '\u{2F885}' => Some(&['\u{5E28}']),
        '\u{2F886}' => Some(&['\u{5E3D}']),
        '\u{2F887}' => Some(&['\u{5E69}']),
        '\u{2F888}' => Some(&['\u{3862}']),
        '\u{2F889}' => Some(&['\u{22183}']),
        '\u{2F88A}' => Some(&['\u{387C}']),
        '\u{2F88B}' => Some(&['\u{5EB0}']),
        '\u{2F88C}' => Some(&['\u{5EB3}']),
        '\u{2F88D}' => Some(&['\u{5EB6}']),
        '\u{2F88E}' => Some(&['\u{5ECA}']),
        '\u{2F88F}' => Some(&['\u{2A392}']),
        '\u{2F890}' => Some(&['\u{5EFE}']),
        '\u{2F891}' => Some(&['\u{22331}']),
        '\u{2F892}' => Some(&['\u{22331}']),
        '\u{2F893}' => Some(&['\u{8201}']),
        '\u{2F894}' => Some(&['\u{5F22}']),
        '\u{2F895}' => Some(&['\u{5F22}']),
        '\u{2F896}' => Some(&['\u{38C7}']),
        '\u{2F897}' => Some(&['\u{232B8}']),
        '\u{2F898}' => Some(&['\u{261DA}']),
        '\u{2F899}' => Some(&['\u{5F62}']),
        '\u{2F89A}' => Some(&['\u{5F6B}']),
        '\u{2F89B}' => Some(&['\u{38E3}']),
        '\u{2F89C}' => Some(&['\u{5F9A}']),
        '\u{2F89D}' => Some(&['\u{5FCD}']),
        '\u{2F89E}' => Some(&['\u{5FD7}']),
        '\u{2F89F}' => Some(&['\u{5FF9}']),
        '\u{2F8A0}' => Some(&['\u{6081}']),
        '\u{2F8A1}' => Some(&['\u{393A}']),
        '\u{2F8A2}' => Some(&['\u{391C}']),
        '\u{2F8A3}' => Some(&['\u{6094}']),
        '\u{2F8A4}' => Some(&['\u{226D4}']),
        '\u{2F8A5}' => Some(&['\u{60C7}']),
        '\u{2F8A6}' => Some(&['\u{6148}']),
        '\u{2F8A7}' => Some(&['\u{614C}']),
        '\u{2F8A8}' => Some(&['\u{614E}']),
        '\u{2F8A9}' => Some(&['\u{614C}']),
        '\u{2F8AA}' => Some(&['\u{617A}']),
        '\u{2F8AB}' => Some(&['\u{618E}']),
        '\u{2F8AC}' => Some(&['\u{61B2}']),
        '\u{2F8AD}' => Some(&['\u{61A4}']),
        '\u{2F8AE}' => Some(&['\u{61AF}']),
        '\u{2F8AF}' => Some(&['\u{61DE}']),
        '\u{2F8B0}' => Some(&['\u{61F2}']),
        '\u{2F8B1}' => Some(&['\u{61F6}']),
        '\u{2F8B2}' => Some(&['\u{6210}']),
        '\u{2F8B3}' => Some(&['\u{621B}']),
        '\u{2F8B4}' => Some(&['\u{625D}']),
        '\u{2F8B5}' => Some(&['\u{62B1}']),
        '\u{2F8B6}' => Some(&['\u{62D4}']),
        '\u{2F8B7}' => Some(&['\u{6350}']),
        '\u{2F8B8}' => Some(&['\u{22B0C}']),
        '\u{2F8B9}' => Some(&['\u{633D}']),
        '\u{2F8BA}' => Some(&['\u{62FC}']),
        '\u{2F8BB}' => Some(&['\u{6368}']),
        '\u{2F8BC}' => Some(&['\u{6383}']),
        '\u{2F8BD}' => Some(&['\u{63E4}']),
        '\u{2F8BE}' => Some(&['\u{22BF1}']),
        '\u{2F8BF}' => Some(&['\u{6422}']),
        '\u{2F8C0}' => Some(&['\u{63C5}']),
        '\u{2F8C1}' => Some(&['\u{63A9}']),
        '\u{2F8C2}' => Some(&['\u{3A2E}']),
        '\u{2F8C3}' => Some(&['\u{6469}']),
        '\u{2F8C4}' => Some(&['\u{647E}']),
        '\u{2F8C5}' => Some(&['\u{649D}']),
        '\u{2F8C6}' => Some(&['\u{6477}']),
        '\u{2F8C7}' => Some(&['\u{3A6C}']),
        '\u{2F8C8}' => Some(&['\u{654F}']),
        '\u{2F8C9}' => Some(&['\u{656C}']),
        '\u{2F8CA}' => Some(&['\u{2300A}']),
        '\u{2F8CB}' => Some(&['\u{65E3}']),
        '\u{2F8CC}' => Some(&['\u{66F8}']),
        '\u{2F8CD}' => Some(&['\u{6649}']),
        '\u{2F8CE}' => Some(&['\u{3B19}']),
        '\u{2F8CF}' => Some(&['\u{6691}']),
        '\u{2F8D0}' => Some(&['\u{3B08}']),
        '\u{2F8D1}' => Some(&['\u{3AE4}']),
        '\u{2F8D2}' => Some(&['\u{5192}']),
        '\u{2F8D3}' => Some(&['\u{5195}']),
        '\u{2F8D4}' => Some(&['\u{6700}']),
        '\u{2F8D5}' => Some(&['\u{669C}']),
        '\u{2F8D6}' => Some(&['\u{80AD}']),
        '\u{2F8D7}' => Some(&['\u{43D9}']),
        '\u{2F8D8}' => Some(&['\u{6717}']),
        '\u{2F8D9}' => Some(&['\u{671B}']),
        '\u{2F8DA}' => Some(&['\u{6721}']),
        '\u{2F8DB}' => Some(&['\u{675E}']),
        '\u{2F8DC}' => Some(&['\u{6753}']),
        '\u{2F8DD}' => Some(&['\u{233C3}']),
        '\u{2F8DE}' => Some(&['\u{3B49}']),
        '\u{2F8DF}' => Some(&['\u{67FA}']),
        '\u{2F8E0}' => Some(&['\u{6785}']),
        '\u{2F8E1}' => Some(&['\u{6852}']),
        '\u{2F8E2}' => Some(&['\u{6885}']),
        '\u{2F8E3}' => Some(&['\u{2346D}']),
        '\u{2F8E4}' => Some(&['\u{688E}']),
        '\u{2F8E5}' => Some(&['\u{681F}']),
        '\u{2F8E6}' => Some(&['\u{6914}']),
        '\u{2F8E7}' => Some(&['\u{3B9D}']),
        '\u{2F8E8}' => Some(&['\u{6942}']),
        '\u{2F8E9}' => Some(&['\u{69A3}']),
        '\u{2F8EA}' => Some(&['\u{69EA}']),
        '\u{2F8EB}' => Some(&['\u{6AA8}']),
        '\u{2F8EC}' => Some(&['\u{236A3}']),
        '\u{2F8ED}' => Some(&['\u{6ADB}']),
        '\u{2F8EE}' => Some(&['\u{3C18}']),
        '\u{2F8EF}' => Some(&['\u{6B21}']),
        '\u{2F8F0}' => Some(&['\u{238A7}']),
        '\u{2F8F1}' => Some(&['\u{6B54}']),
        '\u{2F8F2}' => Some(&['\u{3C4E}']),
        '\u{2F8F3}' => Some(&['\u{6B72}']),
        '\u{2F8F4}' => Some(&['\u{6B9F}']),
        '\u{2F8F5}' => Some(&['\u{6BBA}']),
        '\u{2F8F6}' => Some(&['\u{6BBB}']),
        '\u{2F8F7}' => Some(&['\u{23A8D}']),
        '\u{2F8F8}' => Some(&['\u{21D0B}']),
        '\u{2F8F9}' => Some(&['\u{23AFA}']),
        '\u{2F8FA}' => Some(&['\u{6C4E}']),
        '\u{2F8FB}' => Some(&['\u{23CBC}']),
        '\u{2F8FC}' => Some(&['\u{6CBF}']),
        '\u{2F8FD}' => Some(&['\u{6CCD}']),
        '\u{2F8FE}' => Some(&['\u{6C67}']),
        '\u{2F8FF}' => Some(&['\u{6D16}']),
        '\u{2F900}' => Some(&['\u{6D3E}']),
        '\u{2F901}' => Some(&['\u{6D77}']),
        '\u{2F902}' => Some(&['\u{6D41}']),
        '\u{2F903}' => Some(&['\u{6D69}']),
        '\u{2F904}' => Some(&['\u{6D78}']),
        '\u{2F905}' => Some(&['\u{6D85}']),
        '\u{2F906}' => Some(&['\u{23D1E}']),
        '\u{2F907}' => Some(&['\u{6D34}']),
        '\u{2F908}' => Some(&['\u{6E2F}']),
        '\u{2F909}' => Some(&['\u{6E6E}']),
        '\u{2F90A}' => Some(&['\u{3D33}']),
        '\u{2F90B}' => Some(&['\u{6ECB}']),
        '\u{2F90C}' => Some(&['\u{6EC7}']),
        '\u{2F90D}' => Some(&['\u{23ED1}']),
        '\u{2F90E}' => Some(&['\u{6DF9}']),
        '\u{2F90F}' => Some(&['\u{6F6E}']),
        '\u{2F910}' => Some(&['\u{23F5E}']),
        '\u{2F911}' => Some(&['\u{23F8E}']),
        '\u{2F912}' => Some(&['\u{6FC6}']),
        '\u{2F913}' => Some(&['\u{7039}']),
        '\u{2F914}' => Some(&['\u{701E}']),
        '\u{2F915}' => Some(&['\u{701B}']),
        '\u{2F916}' => Some(&['\u{3D96}']),
        '\u{2F917}' => Some(&['\u{704A}']),
        '\u{2F918}' => Some(&['\u{707D}']),
        '\u{2F919}' => Some(&['\u{7077}']),
        '\u{2F91A}' => Some(&['\u{70AD}']),
        '\u{2F91B}' => Some(&['\u{20525}']),
        '\u{2F91C}' => Some(&['\u{7145}']),
        '\u{2F91D}' => Some(&['\u{24263}']),
        '\u{2F91E}' => Some(&['\u{719C}']),
        '\u{2F91F}' => Some(&['\u{243AB}']),
        '\u{2F920}' => Some(&['\u{7228}']),
        '\u{2F921}' => Some(&['\u{7235}']),
        '\u{2F922}' => Some(&['\u{7250}']),
        '\u{2F923}' => Some(&['\u{24608}']),
        '\u{2F924}' => Some(&['\u{7280}']),
        '\u{2F925}' => Some(&['\u{7295}']),
        '\u{2F926}' => Some(&['\u{24735}']),
        '\u{2F927}' => Some(&['\u{24814}']),
        '\u{2F928}' => Some(&['\u{737A}']),
        '\u{2F929}' => Some(&['\u{738B}']),
        '\u{2F92A}' => Some(&['\u{3EAC}']),
        '\u{2F92B}' => Some(&['\u{73A5}']),
        '\u{2F92C}' => Some(&['\u{3EB8}']),
        '\u{2F92D}' => Some(&['\u{3EB8}']),
        '\u{2F92E}' => Some(&['\u{7447}']),
        '\u{2F92F}' => Some(&['\u{745C}']),
        '\u{2F930}' => Some(&['\u{7471}']),
        '\u{2F931}' => Some(&['\u{7485}']),
        '\u{2F932}' => Some(&['\u{74CA}']),
        '\u{2F933}' => Some(&['\u{3F1B}']),
        '\u{2F934}' => Some(&['\u{7524}']),
        '\u{2F935}' => Some(&['\u{24C36}']),
        '\u{2F936}' => Some(&['\u{753E}']),
        '\u{2F937}' => Some(&['\u{24C92}']),
        '\u{2F938}' => Some(&['\u{7570}']),
        '\u{2F939}' => Some(&['\u{2219F}']),
        '\u{2F93A}' => Some(&['\u{7610}']),
        '\u{2F93B}' => Some(&['\u{24FA1}']),
        '\u{2F93C}' => Some(&['\u{24FB8}']),
        '\u{2F93D}' => Some(&['\u{25044}']),
        '\u{2F93E}' => Some(&['\u{3FFC}']),
        '\u{2F93F}' => Some(&['\u{4008}']),
        '\u{2F940}' => Some(&['\u{76F4}']),
        '\u{2F941}' => Some(&['\u{250F3}']),
        '\u{2F942}' => Some(&['\u{250F2}']),
        '\u{2F943}' => Some(&['\u{25119}']),
        '\u{2F944}' => Some(&['\u{25133}']),
        '\u{2F945}' => Some(&['\u{771E}']),
        '\u{2F946}' => Some(&['\u{771F}']),
        '\u{2F947}' => Some(&['\u{771F}']),
        '\u{2F948}' => Some(&['\u{774A}']),
        '\u{2F949}' => Some(&['\u{4039}']),
        '\u{2F94A}' => Some(&['\u{778B}']),
        '\u{2F94B}' => Some(&['\u{4046}']),
        '\u{2F94C}' => Some(&['\u{4096}']),
        '\u{2F94D}' => Some(&['\u{2541D}']),
        '\u{2F94E}' => Some(&['\u{784E}']),
        '\u{2F94F}' => Some(&['\u{788C}']),
        '\u{2F950}' => Some(&['\u{78CC}']),
        '\u{2F951}' => Some(&['\u{40E3}']),
        '\u{2F952}' => Some(&['\u{25626}']),
        '\u{2F953}' => Some(&['\u{7956}']),
        '\u{2F954}' => Some(&['\u{2569A}']),
        '\u{2F955}' => Some(&['\u{256C5}']),
        '\u{2F956}' => Some(&['\u{798F}']),
        '\u{2F957}' => Some(&['\u{79EB}']),
        '\u{2F958}' => Some(&['\u{412F}']),
        '\u{2F959}' => Some(&['\u{7A40}']),
        '\u{2F95A}' => Some(&['\u{7A4A}']),
        '\u{2F95B}' => Some(&['\u{7A4F}']),
        '\u{2F95C}' => Some(&['\u{2597C}']),
        '\u{2F95D}' => Some(&['\u{25AA7}']),
        '\u{2F95E}' => Some(&['\u{25AA7}']),
        '\u{2F95F}' => Some(&['\u{7AEE}']),
        '\u{2F960}' => Some(&['\u{4202}']),
        '\u{2F961}' => Some(&['\u{25BAB}']),
        '\u{2F962}' => Some(&['\u{7BC6}']),
        '\u{2F963}' => Some(&['\u{7BC9}']),
        '\u{2F964}' => Some(&['\u{4227}']),
        '\u{2F965}' => Some(&['\u{25C80}']),
        '\u{2F966}' => Some(&['\u{7CD2}']),
        '\u{2F967}' => Some(&['\u{42A0}']),
        '\u{2F968}' => Some(&['\u{7CE8}']),
        '\u{2F969}' => Some(&['\u{7CE3}']),
        '\u{2F96A}' => Some(&['\u{7D00}']),
        '\u{2F96B}' => Some(&['\u{25F86}']),
        '\u{2F96C}' => Some(&['\u{7D63}']),
        '\u{2F96D}' => Some(&['\u{4301}']),
        '\u{2F96E}' => Some(&['\u{7DC7}']),
        '\u{2F96F}' => Some(&['\u{7E02}']),
        '\u{2F970}' => Some(&['\u{7E45}']),
        '\u{2F971}' => Some(&['\u{4334}']),
        '\u{2F972}' => Some(&['\u{26228}']),
        '\u{2F973}' => Some(&['\u{26247}']),
        '\u{2F974}' => Some(&['\u{4359}']),
        '\u{2F975}' => Some(&['\u{262D9}']),
        '\u{2F976}' => Some(&['\u{7F7A}']),
        '\u{2F977}' => Some(&['\u{2633E}']),
        '\u{2F978}' => Some(&['\u{7F95}']),
        '\u{2F979}' => Some(&['\u{7FFA}']),
        '\u{2F97A}' => Some(&['\u{8005}']),
        '\u{2F97B}' => Some(&['\u{264DA}']),
        '\u{2F97C}' => Some(&['\u{26523}']),
        '\u{2F97D}' => Some(&['\u{8060}']),
        '\u{2F97E}' => Some(&['\u{265A8}']),
        '\u{2F97F}' => Some(&['\u{8070}']),
        '\u{2F980}' => Some(&['\u{2335F}']),
        '\u{2F981}' => Some(&['\u{43D5}']),
        '\u{2F982}' => Some(&['\u{80B2}']),
        '\u{2F983}' => Some(&['\u{8103}']),
        '\u{2F984}' => Some(&['\u{440B}']),
        '\u{2F985}' => Some(&['\u{813E}']),
        '\u{2F986}' => Some(&['\u{5AB5}']),
        '\u{2F987}' => Some(&['\u{267A7}']),
        '\u{2F988}' => Some(&['\u{267B5}']),
        '\u{2F989}' => Some(&['\u{23393}']),
        '\u{2F98A}' => Some(&['\u{2339C}']),
        '\u{2F98B}' => Some(&['\u{8201}']),
        '\u{2F98C}' => Some(&['\u{8204}']),
        '\u{2F98D}' => Some(&['\u{8F9E}']),
        '\u{2F98E}' => Some(&['\u{446B}']),
        '\u{2F98F}' => Some(&['\u{8291}']),
        '\u{2F990}' => Some(&['\u{828B}']),
        '\u{2F991}' => Some(&['\u{829D}']),
        '\u{2F992}' => Some(&['\u{52B3}']),
        '\u{2F993}' => Some(&['\u{82B1}']),
        '\u{2F994}' => Some(&['\u{82B3}']),
        '\u{2F995}' => Some(&['\u{82BD}']),
        '\u{2F996}' => Some(&['\u{82E6}']),
        '\u{2F997}' => Some(&['\u{26B3C}']),
        '\u{2F998}' => Some(&['\u{82E5}']),
        '\u{2F999}' => Some(&['\u{831D}']),
        '\u{2F99A}' => Some(&['\u{8363}']),
        '\u{2F99B}' => Some(&['\u{83AD}']),
        '\u{2F99C}' => Some(&['\u{8323}']),
        '\u{2F99D}' => Some(&['\u{83BD}']),
        '\u{2F99E}' => Some(&['\u{83E7}']),
        '\u{2F99F}' => Some(&['\u{8457}']),
        '\u{2F9A0}' => Some(&['\u{8353}']),
        '\u{2F9A1}' => Some(&['\u{83CA}']),
        '\u{2F9A2}' => Some(&['\u{83CC}']),
        '\u{2F9A3}' => Some(&['\u{83DC}']),
        '\u{2F9A4}' => Some(&['\u{26C36}']),
        '\u{2F9A5}' => Some(&['\u{26D6B}']),
        '\u{2F9A6}' => Some(&['\u{26CD5}']),
        '\u{2F9A7}' => Some(&['\u{452B}']),
        '\u{2F9A8}' => Some(&['\u{84F1}']),
        '\u{2F9A9}' => Some(&['\u{84F3}']),
        '\u{2F9AA}' => Some(&['\u{8516}']),
        '\u{2F9AB}' => Some(&['\u{273CA}']),
        '\u{2F9AC}' => Some(&['\u{8564}']),
        '\u{2F9AD}' => Some(&['\u{26F2C}']),
        '\u{2F9AE}' => Some(&['\u{455D}']),
        '\u{2F9AF}' => Some(&['\u{4561}']),
        '\u{2F9B0}' => Some(&['\u{26FB1}']),
        '\u{2F9B1}' => Some(&['\u{270D2}']),
        '\u{2F9B2}' => Some(&['\u{456B}']),
        '\u{2F9B3}' => Some(&['\u{8650}']),
        '\u{2F9B4}' => Some(&['\u{865C}']),
        '\u{2F9B5}' => Some(&['\u{8667}']),
        '\u{2F9B6}' => Some(&['\u{8669}']),
        '\u{2F9B7}' => Some(&['\u{86A9}']),
        '\u{2F9B8}' => Some(&['\u{8688}']),
        '\u{2F9B9}' => Some(&['\u{870E}']),
        '\u{2F9BA}' => Some(&['\u{86E2}']),
        '\u{2F9BB}' => Some(&['\u{8779}']),
        '\u{2F9BC}' => Some(&['\u{8728}']),
        '\u{2F9BD}' => Some(&['\u{876B}']),
        '\u{2F9BE}' => Some(&['\u{8786}']),
        '\u{2F9BF}' => Some(&['\u{45D7}']),
        '\u{2F9C0}' => Some(&['\u{87E1}']),
        '\u{2F9C1}' => Some(&['\u{8801}']),
        '\u{2F9C2}' => Some(&['\u{45F9}']),
        '\u{2F9C3}' => Some(&['\u{8860}']),
        '\u{2F9C4}' => Some(&['\u{8863}']),
        '\u{2F9C5}' => Some(&['\u{27667}']),
        '\u{2F9C6}' => Some(&['\u{88D7}']),
        '\u{2F9C7}' => Some(&['\u{88DE}']),
        '\u{2F9C8}' => Some(&['\u{4635}']),
        '\u{2F9C9}' => Some(&['\u{88FA}']),
        '\u{2F9CA}' => Some(&['\u{34BB}']),
        '\u{2F9CB}' => Some(&['\u{278AE}']),
        '\u{2F9CC}' => Some(&['\u{27966}']),
        '\u{2F9CD}' => Some(&['\u{46BE}']),
        '\u{2F9CE}' => Some(&['\u{46C7}']),
        '\u{2F9CF}' => Some(&['\u{8AA0}']),
        '\u{2F9D0}' => Some(&['\u{8AED}']),
        '\u{2F9D1}' => Some(&['\u{8B8A}']),
        '\u{2F9D2}' => Some(&['\u{8C55}']),
        '\u{2F9D3}' => Some(&['\u{27CA8}']),
        '\u{2F9D4}' => Some(&['\u{8CAB}']),
        '\u{2F9D5}' => Some(&['\u{8CC1}']),
        '\u{2F9D6}' => Some(&['\u{8D1B}']),
        '\u{2F9D7}' => Some(&['\u{8D77}']),
        '\u{2F9D8}' => Some(&['\u{27F2F}']),
        '\u{2F9D9}' => Some(&['\u{20804}']),
        '\u{2F9DA}' => Some(&['\u{8DCB}']),
        '\u{2F9DB}' => Some(&['\u{8DBC}']),
        '\u{2F9DC}' => Some(&['\u{8DF0}']),
        '\u{2F9DD}' => Some(&['\u{208DE}']),
        '\u{2F9DE}' => Some(&['\u{8ED4}']),
        '\u{2F9DF}' => Some(&['\u{8F38}']),
        '\u{2F9E0}' => Some(&['\u{285D2}']),
        '\u{2F9E1}' => Some(&['\u{285ED}']),
        '\u{2F9E2}' => Some(&['\u{9094}']),
        '\u{2F9E3}' => Some(&['\u{90F1}']),
        '\u{2F9E4}' => Some(&['\u{9111}']),
        '\u{2F9E5}' => Some(&['\u{2872E}']),
        '\u{2F9E6}' => Some(&['\u{911B}']),
        '\u{2F9E7}' => Some(&['\u{9238}']),
        '\u{2F9E8}' => Some(&['\u{92D7}']),
        '\u{2F9E9}' => Some(&['\u{92D8}']),
        '\u{2F9EA}' => Some(&['\u{927C}']),
        '\u{2F9EB}' => Some(&['\u{93F9}']),
        '\u{2F9EC}' => Some(&['\u{9415}']),
        '\u{2F9ED}' => Some(&['\u{28BFA}']),
        '\u{2F9EE}' => Some(&['\u{958B}']),
        '\u{2F9EF}' => Some(&['\u{4995}']),
        '\u{2F9F0}' => Some(&['\u{95B7}']),
        '\u{2F9F1}' => Some(&['\u{28D77}']),
        '\u{2F9F2}' => Some(&['\u{49E6}']),
        '\u{2F9F3}' => Some(&['\u{96C3}']),
        '\u{2F9F4}' => Some(&['\u{5DB2}']),
        '\u{2F9F5}' => Some(&['\u{9723}']),
        '\u{2F9F6}' => Some(&['\u{29145}']),
        '\u{2F9F7}' => Some(&['\u{2921A}']),
        '\u{2F9F8}' => Some(&['\u{4A6E}']),
        '\u{2F9F9}' => Some(&['\u{4A76}']),
        '\u{2F9FA}' => Some(&['\u{97E0}']),
        '\u{2F9FB}' => Some(&['\u{2940A}']),
        '\u{2F9FC}' => Some(&['\u{4AB2}']),
        '\u{2F9FD}' => Some(&['\u{29496}']),
        '\u{2F9FE}' => Some(&['\u{980B}']),
        '\u{2F9FF}' => Some(&['\u{980B}']),
        '\u{2FA00}' => Some(&['\u{9829}']),
        '\u{2FA01}' => Some(&['\u{295B6}']),
        '\u{2FA02}' => Some(&['\u{98E2}']),
        '\u{2FA03}' => Some(&['\u{4B33}']),
        '\u{2FA04}' => Some(&['\u{9929}']),
        '\u{2FA05}' => Some(&['\u{99A7}']),
        '\u{2FA06}' => Some(&['\u{99C2}']),
        '\u{2FA07}' => Some(&['\u{99FE}']),
        '\u{2FA08}' => Some(&['\u{4BCE}']),
        '\u{2FA09}' => Some(&['\u{29B30}']),
        '\u{2FA0A}' => Some(&['\u{9B12}']),
        '\u{2FA0B}' => Some(&['\u{9C40}']),
        '\u{2FA0C}' => Some(&['\u{9CFD}']),
        '\u{2FA0D}' => Some(&['\u{4CCE}']),
        '\u{2FA0E}' => Some(&['\u{4CED}']),
        '\u{2FA0F}' => Some(&['\u{9D67}']),
        '\u{2FA10}' => Some(&['\u{2A0CE}']),
        '\u{2FA11}' => Some(&['\u{4CF8}']),
        '\u{2FA12}' => Some(&['\u{2A105}']),
        '\u{2FA13}' => Some(&['\u{2A20E}']),
        '\u{2FA14}' => Some(&['\u{2A291}']),
        '\u{2FA15}' => Some(&['\u{9EBB}']),
        '\u{2FA16}' => Some(&['\u{4D56}']),
        '\u{2FA17}' => Some(&['\u{9EF9}']),
        '\u{2FA18}' => Some(&['\u{9EFE}']),
        '\u{2FA19}' => Some(&['\u{9F05}']),
        '\u{2FA1A}' => Some(&['\u{9F0F}']),
        '\u{2FA1B}' => Some(&['\u{9F16}']),
        '\u{2FA1C}' => Some(&['\u{9F3B}']),
        '\u{2FA1D}' => Some(&['\u{2A600}']),
        _ => None,
    }
}

#[inline]
pub fn compatibility_fully_decomposed(c: char) -> Option<&'static [char]> {
    match c {
        '\u{00A0}' => Some(&['\u{0020}']),
        '\u{00A8}' => Some(&['\u{0020}', '\u{0308}']),
        '\u{00AA}' => Some(&['\u{0061}']),
        '\u{00AF}' => Some(&['\u{0020}', '\u{0304}']),
        '\u{00B2}' => Some(&['\u{0032}']),
        '\u{00B3}' => Some(&['\u{0033}']),
        '\u{00B4}' => Some(&['\u{0020}', '\u{0301}']),
        '\u{00B5}' => Some(&['\u{03BC}']),
        '\u{00B8}' => Some(&['\u{0020}', '\u{0327}']),
        '\u{00B9}' => Some(&['\u{0031}']),
        '\u{00BA}' => Some(&['\u{006F}']),
        '\u{00BC}' => Some(&['\u{0031}', '\u{2044}', '\u{0034}']),
        '\u{00BD}' => Some(&['\u{0031}', '\u{2044}', '\u{0032}']),
        '\u{00BE}' => Some(&['\u{0033}', '\u{2044}', '\u{0034}']),
        '\u{0132}' => Some(&['\u{0049}', '\u{004A}']),
        '\u{0133}' => Some(&['\u{0069}', '\u{006A}']),
        '\u{013F}' => Some(&['\u{004C}', '\u{00B7}']),
        '\u{0140}' => Some(&['\u{006C}', '\u{00B7}']),
        '\u{0149}' => Some(&['\u{02BC}', '\u{006E}']),
        '\u{017F}' => Some(&['\u{0073}']),
        '\u{01C4}' => Some(&['\u{0044}', '\u{005A}', '\u{030C}']),
        '\u{01C5}' => Some(&['\u{0044}', '\u{007A}', '\u{030C}']),
        '\u{01C6}' => Some(&['\u{0064}', '\u{007A}', '\u{030C}']),
        '\u{01C7}' => Some(&['\u{004C}', '\u{004A}']),
        '\u{01C8}' => Some(&['\u{004C}', '\u{006A}']),
        '\u{01C9}' => Some(&['\u{006C}', '\u{006A}']),
        '\u{01CA}' => Some(&['\u{004E}', '\u{004A}']),
        '\u{01CB}' => Some(&['\u{004E}', '\u{006A}']),
        '\u{01CC}' => Some(&['\u{006E}', '\u{006A}']),
        '\u{01F1}' => Some(&['\u{0044}', '\u{005A}']),
        '\u{01F2}' => Some(&['\u{0044}', '\u{007A}']),
        '\u{01F3}' => Some(&['\u{0064}', '\u{007A}']),
        '\u{02B0}' => Some(&['\u{0068}']),
        '\u{02B1}' => Some(&['\u{0266}']),
        '\u{02B2}' => Some(&['\u{006A}']),
        '\u{02B3}' => Some(&['\u{0072}']),
        '\u{02B4}' => Some(&['\u{0279}']),
        '\u{02B5}' => Some(&['\u{027B}']),
        '\u{02B6}' => Some(&['\u{0281}']),
        '\u{02B7}' => Some(&['\u{0077}']),
        '\u{02B8}' => Some(&['\u{0079}']),
        '\u{02D8}' => Some(&['\u{0020}', '\u{0306}']),
        '\u{02D9}' => Some(&['\u{0020}', '\u{0307}']),
        '\u{02DA}' => Some(&['\u{0020}', '\u{030A}']),
        '\u{02DB}' => Some(&['\u{0020}', '\u{0328}']),
        '\u{02DC}' => Some(&['\u{0020}', '\u{0303}']),
        '\u{02DD}' => Some(&['\u{0020}', '\u{030B}']),
        '\u{02E0}' => Some(&['\u{0263}']),
        '\u{02E1}' => Some(&['\u{006C}']),
        '\u{02E2}' => Some(&['\u{0073}']),
        '\u{02E3}' => Some(&['\u{0078}']),
        '\u{02E4}' => Some(&['\u{0295}']),
        '\u{037A}' => Some(&['\u{0020}', '\u{0345}']),
        '\u{0384}' => Some(&['\u{0020}', '\u{0301}']),
        '\u{0385}' => Some(&['\u{0020}', '\u{0308}', '\u{0301}']),
        '\u{03D0}' => Some(&['\u{03B2}']),
        '\u{03D1}' => Some(&['\u{03B8}']),
        '\u{03D2}' => Some(&['\u{03A5}']),
        '\u{03D3}' => Some(&['\u{03A5}', '\u{0301}']),
        '\u{03D4}' => Some(&['\u{03A5}', '\u{0308}']),
        '\u{03D5}' => Some(&['\u{03C6}']),
        '\u{03D6}' => Some(&['\u{03C0}']),
        '\u{03F0}' => Some(&['\u{03BA}']),
        '\u{03F1}' => Some(&['\u{03C1}']),
        '\u{03F2}' => Some(&['\u{03C2}']),
        '\u{03F4}' => Some(&['\u{0398}']),
        '\u{03F5}' => Some(&['\u{03B5}']),
        '\u{03F9}' => Some(&['\u{03A3}']),
        '\u{0587}' => Some(&['\u{0565}', '\u{0582}']),
        '\u{0675}' => Some(&['\u{0627}', '\u{0674}']),
        '\u{0676}' => Some(&['\u{0648}', '\u{0674}']),
        '\u{0677}' => Some(&['\u{06C7}', '\u{0674}']),
        '\u{0678}' => Some(&['\u{064A}', '\u{0674}']),
        '\u{0E33}' => Some(&['\u{0E4D}', '\u{0E32}']),
        '\u{0EB3}' => Some(&['\u{0ECD}', '\u{0EB2}']),
        '\u{0EDC}' => Some(&['\u{0EAB}', '\u{0E99}']),
        '\u{0EDD}' => Some(&['\u{0EAB}', '\u{0EA1}']),
        '\u{0F0C}' => Some(&['\u{0F0B}']),
        '\u{0F77}' => Some(&['\u{0FB2}', '\u{0F71}', '\u{0F80}']),
        '\u{0F79}' => Some(&['\u{0FB3}', '\u{0F71}', '\u{0F80}']),
        '\u{10FC}' => Some(&['\u{10DC}']),
        '\u{1D2C}' => Some(&['\u{0041}']),
        '\u{1D2D}' => Some(&['\u{00C6}']),
        '\u{1D2E}' => Some(&['\u{0042}']),
        '\u{1D30}' => Some(&['\u{0044}']),
        '\u{1D31}' => Some(&['\u{0045}']),
        '\u{1D32}' => Some(&['\u{018E}']),
        '\u{1D33}' => Some(&['\u{0047}']),
        '\u{1D34}' => Some(&['\u{0048}']),
        '\u{1D35}' => Some(&['\u{0049}']),
        '\u{1D36}' => Some(&['\u{004A}']),
        '\u{1D37}' => Some(&['\u{004B}']),
        '\u{1D38}' => Some(&['\u{004C}']),
        '\u{1D39}' => Some(&['\u{004D}']),
        '\u{1D3A}' => Some(&['\u{004E}']),
        '\u{1D3C}' => Some(&['\u{004F}']),
        '\u{1D3D}' => Some(&['\u{0222}']),
        '\u{1D3E}' => Some(&['\u{0050}']),
        '\u{1D3F}' => Some(&['\u{0052}']),
        '\u{1D40}' => Some(&['\u{0054}']),
        '\u{1D41}' => Some(&['\u{0055}']),
        '\u{1D42}' => Some(&['\u{0057}']),
        '\u{1D43}' => Some(&['\u{0061}']),
        '\u{1D44}' => Some(&['\u{0250}']),
        '\u{1D45}' => Some(&['\u{0251}']),
        '\u{1D46}' => Some(&['\u{1D02}']),
        '\u{1D47}' => Some(&['\u{0062}']),
        '\u{1D48}' => Some(&['\u{0064}']),
        '\u{1D49}' => Some(&['\u{0065}']),
        '\u{1D4A}' => Some(&['\u{0259}']),
        '\u{1D4B}' => Some(&['\u{025B}']),
        '\u{1D4C}' => Some(&['\u{025C}']),
        '\u{1D4D}' => Some(&['\u{0067}']),
        '\u{1D4F}' => Some(&['\u{006B}']),
        '\u{1D50}' => Some(&['\u{006D}']),
        '\u{1D51}' => Some(&['\u{014B}']),
        '\u{1D52}' => Some(&['\u{006F}']),
        '\u{1D53}' => Some(&['\u{0254}']),
        '\u{1D54}' => Some(&['\u{1D16}']),
        '\u{1D55}' => Some(&['\u{1D17}']),
        '\u{1D56}' => Some(&['\u{0070}']),
        '\u{1D57}' => Some(&['\u{0074}']),
        '\u{1D58}' => Some(&['\u{0075}']),
        '\u{1D59}' => Some(&['\u{1D1D}']),
        '\u{1D5A}' => Some(&['\u{026F}']),
        '\u{1D5B}' => Some(&['\u{0076}']),
        '\u{1D5C}' => Some(&['\u{1D25}']),
        '\u{1D5D}' => Some(&['\u{03B2}']),
        '\u{1D5E}' => Some(&['\u{03B3}']),
        '\u{1D5F}' => Some(&['\u{03B4}']),
        '\u{1D60}' => Some(&['\u{03C6}']),
        '\u{1D61}' => Some(&['\u{03C7}']),
        '\u{1D62}' => Some(&['\u{0069}']),
        '\u{1D63}' => Some(&['\u{0072}']),
        '\u{1D64}' => Some(&['\u{0075}']),
        '\u{1D65}' => Some(&['\u{0076}']),
        '\u{1D66}' => Some(&['\u{03B2}']),
        '\u{1D67}' => Some(&['\u{03B3}']),
        '\u{1D68}' => Some(&['\u{03C1}']),
        '\u{1D69}' => Some(&['\u{03C6}']),
        '\u{1D6A}' => Some(&['\u{03C7}']),
        '\u{1D78}' => Some(&['\u{043D}']),
        '\u{1D9B}' => Some(&['\u{0252}']),
        '\u{1D9C}' => Some(&['\u{0063}']),
        '\u{1D9D}' => Some(&['\u{0255}']),
        '\u{1D9E}' => Some(&['\u{00F0}']),
        '\u{1D9F}' => Some(&['\u{025C}']),
        '\u{1DA0}' => Some(&['\u{0066}']),
        '\u{1DA1}' => Some(&['\u{025F}']),
        '\u{1DA2}' => Some(&['\u{0261}']),
        '\u{1DA3}' => Some(&['\u{0265}']),
        '\u{1DA4}' => Some(&['\u{0268}']),
        '\u{1DA5}' => Some(&['\u{0269}']),
        '\u{1DA6}' => Some(&['\u{026A}']),
        '\u{1DA7}' => Some(&['\u{1D7B}']),
        '\u{1DA8}' => Some(&['\u{029D}']),
        '\u{1DA9}' => Some(&['\u{026D}']),
        '\u{1DAA}' => Some(&['\u{1D85}']),
        '\u{1DAB}' => Some(&['\u{029F}']),
        '\u{1DAC}' => Some(&['\u{0271}']),
        '\u{1DAD}' => Some(&['\u{0270}']),
        '\u{1DAE}' => Some(&['\u{0272}']),
        '\u{1DAF}' => Some(&['\u{0273}']),
        '\u{1DB0}' => Some(&['\u{0274}']),
        '\u{1DB1}' => Some(&['\u{0275}']),
        '\u{1DB2}' => Some(&['\u{0278}']),
        '\u{1DB3}' => Some(&['\u{0282}']),
        '\u{1DB4}' => Some(&['\u{0283}']),
        '\u{1DB5}' => Some(&['\u{01AB}']),
        '\u{1DB6}' => Some(&['\u{0289}']),
        '\u{1DB7}' => Some(&['\u{028A}']),
        '\u{1DB8}' => Some(&['\u{1D1C}']),
        '\u{1DB9}' => Some(&['\u{028B}']),
        '\u{1DBA}' => Some(&['\u{028C}']),
        '\u{1DBB}' => Some(&['\u{007A}']),
        '\u{1DBC}' => Some(&['\u{0290}']),
        '\u{1DBD}' => Some(&['\u{0291}']),
        '\u{1DBE}' => Some(&['\u{0292}']),
        '\u{1DBF}' => Some(&['\u{03B8}']),
        '\u{1E9A}' => Some(&['\u{0061}', '\u{02BE}']),
        '\u{1E9B}' => Some(&['\u{0073}', '\u{0307}']),
        '\u{1FBD}' => Some(&['\u{0020}', '\u{0313}']),
        '\u{1FBF}' => Some(&['\u{0020}', '\u{0313}']),
        '\u{1FC0}' => Some(&['\u{0020}', '\u{0342}']),
        '\u{1FC1}' => Some(&['\u{0020}', '\u{0308}', '\u{0342}']),
        '\u{1FCD}' => Some(&['\u{0020}', '\u{0313}', '\u{0300}']),
        '\u{1FCE}' => Some(&['\u{0020}', '\u{0313}', '\u{0301}']),
        '\u{1FCF}' => Some(&['\u{0020}', '\u{0313}', '\u{0342}']),
        '\u{1FDD}' => Some(&['\u{0020}', '\u{0314}', '\u{0300}']),
        '\u{1FDE}' => Some(&['\u{0020}', '\u{0314}', '\u{0301}']),
        '\u{1FDF}' => Some(&['\u{0020}', '\u{0314}', '\u{0342}']),
        '\u{1FED}' => Some(&['\u{0020}', '\u{0308}', '\u{0300}']),
        '\u{1FEE}' => Some(&['\u{0020}', '\u{0308}', '\u{0301}']),
        '\u{1FFD}' => Some(&['\u{0020}', '\u{0301}']),
        '\u{1FFE}' => Some(&['\u{0020}', '\u{0314}']),
        '\u{2000}' => Some(&['\u{0020}']),
        '\u{2001}' => Some(&['\u{0020}']),
        '\u{2002}' => Some(&['\u{0020}']),
        '\u{2003}' => Some(&['\u{0020}']),
        '\u{2004}' => Some(&['\u{0020}']),
        '\u{2005}' => Some(&['\u{0020}']),
        '\u{2006}' => Some(&['\u{0020}']),
        '\u{2007}' => Some(&['\u{0020}']),
        '\u{2008}' => Some(&['\u{0020}']),
        '\u{2009}' => Some(&['\u{0020}']),
        '\u{200A}' => Some(&['\u{0020}']),
        '\u{2011}' => Some(&['\u{2010}']),
        '\u{2017}' => Some(&['\u{0020}', '\u{0333}']),
        '\u{2024}' => Some(&['\u{002E}']),
        '\u{2025}' => Some(&['\u{002E}', '\u{002E}']),
        '\u{2026}' => Some(&['\u{002E}', '\u{002E}', '\u{002E}']),
        '\u{202F}' => Some(&['\u{0020}']),
        '\u{2033}' => Some(&['\u{2032}', '\u{2032}']),
        '\u{2034}' => Some(&['\u{2032}', '\u{2032}', '\u{2032}']),
        '\u{2036}' => Some(&['\u{2035}', '\u{2035}']),
        '\u{2037}' => Some(&['\u{2035}', '\u{2035}', '\u{2035}']),
        '\u{203C}' => Some(&['\u{0021}', '\u{0021}']),
        '\u{203E}' => Some(&['\u{0020}', '\u{0305}']),
        '\u{2047}' => Some(&['\u{003F}', '\u{003F}']),
        '\u{2048}' => Some(&['\u{003F}', '\u{0021}']),
        '\u{2049}' => Some(&['\u{0021}', '\u{003F}']),
        '\u{2057}' => Some(&['\u{2032}', '\u{2032}', '\u{2032}', '\u{2032}']),
        '\u{205F}' => Some(&['\u{0020}']),
        '\u{2070}' => Some(&['\u{0030}']),
        '\u{2071}' => Some(&['\u{0069}']),
        '\u{2074}' => Some(&['\u{0034}']),
        '\u{2075}' => Some(&['\u{0035}']),
        '\u{2076}' => Some(&['\u{0036}']),
        '\u{2077}' => Some(&['\u{0037}']),
        '\u{2078}' => Some(&['\u{0038}']),
        '\u{2079}' => Some(&['\u{0039}']),
        '\u{207A}' => Some(&['\u{002B}']),
        '\u{207B}' => Some(&['\u{2212}']),
        '\u{207C}' => Some(&['\u{003D}']),
        '\u{207D}' => Some(&['\u{0028}']),
        '\u{207E}' => Some(&['\u{0029}']),
        '\u{207F}' => Some(&['\u{006E}']),
        '\u{2080}' => Some(&['\u{0030}']),
        '\u{2081}' => Some(&['\u{0031}']),
        '\u{2082}' => Some(&['\u{0032}']),
        '\u{2083}' => Some(&['\u{0033}']),
        '\u{2084}' => Some(&['\u{0034}']),
        '\u{2085}' => Some(&['\u{0035}']),
        '\u{2086}' => Some(&['\u{0036}']),
        '\u{2087}' => Some(&['\u{0037}']),
        '\u{2088}' => Some(&['\u{0038}']),
        '\u{2089}' => Some(&['\u{0039}']),
        '\u{208A}' => Some(&['\u{002B}']),
        '\u{208B}' => Some(&['\u{2212}']),
        '\u{208C}' => Some(&['\u{003D}']),
        '\u{208D}' => Some(&['\u{0028}']),
        '\u{208E}' => Some(&['\u{0029}']),
        '\u{2090}' => Some(&['\u{0061}']),
        '\u{2091}' => Some(&['\u{0065}']),
        '\u{2092}' => Some(&['\u{006F}']),
        '\u{2093}' => Some(&['\u{0078}']),
        '\u{2094}' => Some(&['\u{0259}']),
        '\u{2095}' => Some(&['\u{0068}']),
        '\u{2096}' => Some(&['\u{006B}']),
        '\u{2097}' => Some(&['\u{006C}']),
        '\u{2098}' => Some(&['\u{006D}']),
        '\u{2099}' => Some(&['\u{006E}']),
        '\u{209A}' => Some(&['\u{0070}']),
        '\u{209B}' => Some(&['\u{0073}']),
        '\u{209C}' => Some(&['\u{0074}']),
        '\u{20A8}' => Some(&['\u{0052}', '\u{0073}']),
        '\u{2100}' => Some(&['\u{0061}', '\u{002F}', '\u{0063}']),
        '\u{2101}' => Some(&['\u{0061}', '\u{002F}', '\u{0073}']),
        '\u{2102}' => Some(&['\u{0043}']),
        '\u{2103}' => Some(&['\u{00B0}', '\u{0043}']),
        '\u{2105}' => Some(&['\u{0063}', '\u{002F}', '\u{006F}']),
        '\u{2106}' => Some(&['\u{0063}', '\u{002F}', '\u{0075}']),
        '\u{2107}' => Some(&['\u{0190}']),
        '\u{2109}' => Some(&['\u{00B0}', '\u{0046}']),
        '\u{210A}' => Some(&['\u{0067}']),
        '\u{210B}' => Some(&['\u{0048}']),
        '\u{210C}' => Some(&['\u{0048}']),
        '\u{210D}' => Some(&['\u{0048}']),
        '\u{210E}' => Some(&['\u{0068}']),
        '\u{210F}' => Some(&['\u{0127}']),
        '\u{2110}' => Some(&['\u{0049}']),
        '\u{2111}' => Some(&['\u{0049}']),
        '\u{2112}' => Some(&['\u{004C}']),
        '\u{2113}' => Some(&['\u{006C}']),
        '\u{2115}' => Some(&['\u{004E}']),
        '\u{2116}' => Some(&['\u{004E}', '\u{006F}']),
        '\u{2119}' => Some(&['\u{0050}']),
        '\u{211A}' => Some(&['\u{0051}']),
        '\u{211B}' => Some(&['\u{0052}']),
        '\u{211C}' => Some(&['\u{0052}']),
        '\u{211D}' => Some(&['\u{0052}']),
        '\u{2120}' => Some(&['\u{0053}', '\u{004D}']),
        '\u{2121}' => Some(&['\u{0054}', '\u{0045}', '\u{004C}']),
        '\u{2122}' => Some(&['\u{0054}', '\u{004D}']),
        '\u{2124}' => Some(&['\u{005A}']),
        '\u{2128}' => Some(&['\u{005A}']),
        '\u{212C}' => Some(&['\u{0042}']),
        '\u{212D}' => Some(&['\u{0043}']),
        '\u{212F}' => Some(&['\u{0065}']),
        '\u{2130}' => Some(&['\u{0045}']),
        '\u{2131}' => Some(&['\u{0046}']),
        '\u{2133}' => Some(&['\u{004D}']),
        '\u{2134}' => Some(&['\u{006F}']),
        '\u{2135}' => Some(&['\u{05D0}']),
        '\u{2136}' => Some(&['\u{05D1}']),
        '\u{2137}' => Some(&['\u{05D2}']),
        '\u{2138}' => Some(&['\u{05D3}']),
        '\u{2139}' => Some(&['\u{0069}']),
        '\u{213B}' => Some(&['\u{0046}', '\u{0041}', '\u{0058}']),
        '\u{213C}' => Some(&['\u{03C0}']),
        '\u{213D}' => Some(&['\u{03B3}']),
        '\u{213E}' => Some(&['\u{0393}']),
        '\u{213F}' => Some(&['\u{03A0}']),
        '\u{2140}' => Some(&['\u{2211}']),
        '\u{2145}' => Some(&['\u{0044}']),
        '\u{2146}' => Some(&['\u{0064}']),
        '\u{2147}' => Some(&['\u{0065}']),
        '\u{2148}' => Some(&['\u{0069}']),
        '\u{2149}' => Some(&['\u{006A}']),
        '\u{2150}' => Some(&['\u{0031}', '\u{2044}', '\u{0037}']),
        '\u{2151}' => Some(&['\u{0031}', '\u{2044}', '\u{0039}']),
        '\u{2152}' => Some(&['\u{0031}', '\u{2044}', '\u{0031}', '\u{0030}']),
        '\u{2153}' => Some(&['\u{0031}', '\u{2044}', '\u{0033}']),
        '\u{2154}' => Some(&['\u{0032}', '\u{2044}', '\u{0033}']),
        '\u{2155}' => Some(&['\u{0031}', '\u{2044}', '\u{0035}']),
        '\u{2156}' => Some(&['\u{0032}', '\u{2044}', '\u{0035}']),
        '\u{2157}' => Some(&['\u{0033}', '\u{2044}', '\u{0035}']),
        '\u{2158}' => Some(&['\u{0034}', '\u{2044}', '\u{0035}']),
        '\u{2159}' => Some(&['\u{0031}', '\u{2044}', '\u{0036}']),
        '\u{215A}' => Some(&['\u{0035}', '\u{2044}', '\u{0036}']),
        '\u{215B}' => Some(&['\u{0031}', '\u{2044}', '\u{0038}']),
        '\u{215C}' => Some(&['\u{0033}', '\u{2044}', '\u{0038}']),
        '\u{215D}' => Some(&['\u{0035}', '\u{2044}', '\u{0038}']),
        '\u{215E}' => Some(&['\u{0037}', '\u{2044}', '\u{0038}']),
        '\u{215F}' => Some(&['\u{0031}', '\u{2044}']),
        '\u{2160}' => Some(&['\u{0049}']),
        '\u{2161}' => Some(&['\u{0049}', '\u{0049}']),
        '\u{2162}' => Some(&['\u{0049}', '\u{0049}', '\u{0049}']),
        '\u{2163}' => Some(&['\u{0049}', '\u{0056}']),
        '\u{2164}' => Some(&['\u{0056}']),
        '\u{2165}' => Some(&['\u{0056}', '\u{0049}']),
        '\u{2166}' => Some(&['\u{0056}', '\u{0049}', '\u{0049}']),
        '\u{2167}' => Some(&['\u{0056}', '\u{0049}', '\u{0049}', '\u{0049}']),
        '\u{2168}' => Some(&['\u{0049}', '\u{0058}']),
        '\u{2169}' => Some(&['\u{0058}']),
        '\u{216A}' => Some(&['\u{0058}', '\u{0049}']),
        '\u{216B}' => Some(&['\u{0058}', '\u{0049}', '\u{0049}']),
        '\u{216C}' => Some(&['\u{004C}']),
        '\u{216D}' => Some(&['\u{0043}']),
        '\u{216E}' => Some(&['\u{0044}']),
        '\u{216F}' => Some(&['\u{004D}']),
        '\u{2170}' => Some(&['\u{0069}']),
        '\u{2171}' => Some(&['\u{0069}', '\u{0069}']),
        '\u{2172}' => Some(&['\u{0069}', '\u{0069}', '\u{0069}']),
        '\u{2173}' => Some(&['\u{0069}', '\u{0076}']),
        '\u{2174}' => Some(&['\u{0076}']),
        '\u{2175}' => Some(&['\u{0076}', '\u{0069}']),
        '\u{2176}' => Some(&['\u{0076}', '\u{0069}', '\u{0069}']),
        '\u{2177}' => Some(&['\u{0076}', '\u{0069}', '\u{0069}', '\u{0069}']),
        '\u{2178}' => Some(&['\u{0069}', '\u{0078}']),
        '\u{2179}' => Some(&['\u{0078}']),
        '\u{217A}' => Some(&['\u{0078}', '\u{0069}']),
        '\u{217B}' => Some(&['\u{0078}', '\u{0069}', '\u{0069}']),
        '\u{217C}' => Some(&['\u{006C}']),
        '\u{217D}' => Some(&['\u{0063}']),
        '\u{217E}' => Some(&['\u{0064}']),
        '\u{217F}' => Some(&['\u{006D}']),
        '\u{2189}' => Some(&['\u{0030}', '\u{2044}', '\u{0033}']),
        '\u{222C}' => Some(&['\u{222B}', '\u{222B}']),
        '\u{222D}' => Some(&['\u{222B}', '\u{222B}', '\u{222B}']),
        '\u{222F}' => Some(&['\u{222E}', '\u{222E}']),
        '\u{2230}' => Some(&['\u{222E}', '\u{222E}', '\u{222E}']),
        '\u{2460}' => Some(&['\u{0031}']),
        '\u{2461}' => Some(&['\u{0032}']),
        '\u{2462}' => Some(&['\u{0033}']),
        '\u{2463}' => Some(&['\u{0034}']),
        '\u{2464}' => Some(&['\u{0035}']),
        '\u{2465}' => Some(&['\u{0036}']),
        '\u{2466}' => Some(&['\u{0037}']),
        '\u{2467}' => Some(&['\u{0038}']),
        '\u{2468}' => Some(&['\u{0039}']),
        '\u{2469}' => Some(&['\u{0031}', '\u{0030}']),
        '\u{246A}' => Some(&['\u{0031}', '\u{0031}']),
        '\u{246B}' => Some(&['\u{0031}', '\u{0032}']),
        '\u{246C}' => Some(&['\u{0031}', '\u{0033}']),
        '\u{246D}' => Some(&['\u{0031}', '\u{0034}']),
        '\u{246E}' => Some(&['\u{0031}', '\u{0035}']),
        '\u{246F}' => Some(&['\u{0031}', '\u{0036}']),
        '\u{2470}' => Some(&['\u{0031}', '\u{0037}']),
        '\u{2471}' => Some(&['\u{0031}', '\u{0038}']),
        '\u{2472}' => Some(&['\u{0031}', '\u{0039}']),
        '\u{2473}' => Some(&['\u{0032}', '\u{0030}']),
        '\u{2474}' => Some(&['\u{0028}', '\u{0031}', '\u{0029}']),
        '\u{2475}' => Some(&['\u{0028}', '\u{0032}', '\u{0029}']),
        '\u{2476}' => Some(&['\u{0028}', '\u{0033}', '\u{0029}']),
        '\u{2477}' => Some(&['\u{0028}', '\u{0034}', '\u{0029}']),
        '\u{2478}' => Some(&['\u{0028}', '\u{0035}', '\u{0029}']),
        '\u{2479}' => Some(&['\u{0028}', '\u{0036}', '\u{0029}']),
        '\u{247A}' => Some(&['\u{0028}', '\u{0037}', '\u{0029}']),
        '\u{247B}' => Some(&['\u{0028}', '\u{0038}', '\u{0029}']),
        '\u{247C}' => Some(&['\u{0028}', '\u{0039}', '\u{0029}']),
        '\u{247D}' => Some(&['\u{0028}', '\u{0031}', '\u{0030}', '\u{0029}']),
        '\u{247E}' => Some(&['\u{0028}', '\u{0031}', '\u{0031}', '\u{0029}']),
        '\u{247F}' => Some(&['\u{0028}', '\u{0031}', '\u{0032}', '\u{0029}']),
        '\u{2480}' => Some(&['\u{0028}', '\u{0031}', '\u{0033}', '\u{0029}']),
        '\u{2481}' => Some(&['\u{0028}', '\u{0031}', '\u{0034}', '\u{0029}']),
        '\u{2482}' => Some(&['\u{0028}', '\u{0031}', '\u{0035}', '\u{0029}']),
        '\u{2483}' => Some(&['\u{0028}', '\u{0031}', '\u{0036}', '\u{0029}']),
        '\u{2484}' => Some(&['\u{0028}', '\u{0031}', '\u{0037}', '\u{0029}']),
        '\u{2485}' => Some(&['\u{0028}', '\u{0031}', '\u{0038}', '\u{0029}']),
        '\u{2486}' => Some(&['\u{0028}', '\u{0031}', '\u{0039}', '\u{0029}']),
        '\u{2487}' => Some(&['\u{0028}', '\u{0032}', '\u{0030}', '\u{0029}']),
        '\u{2488}' => Some(&['\u{0031}', '\u{002E}']),
        '\u{2489}' => Some(&['\u{0032}', '\u{002E}']),
        '\u{248A}' => Some(&['\u{0033}', '\u{002E}']),
        '\u{248B}' => Some(&['\u{0034}', '\u{002E}']),
        '\u{248C}' => Some(&['\u{0035}', '\u{002E}']),
        '\u{248D}' => Some(&['\u{0036}', '\u{002E}']),
        '\u{248E}' => Some(&['\u{0037}', '\u{002E}']),
        '\u{248F}' => Some(&['\u{0038}', '\u{002E}']),
        '\u{2490}' => Some(&['\u{0039}', '\u{002E}']),
        '\u{2491}' => Some(&['\u{0031}', '\u{0030}', '\u{002E}']),
        '\u{2492}' => Some(&['\u{0031}', '\u{0031}', '\u{002E}']),
        '\u{2493}' => Some(&['\u{0031}', '\u{0032}', '\u{002E}']),
        '\u{2494}' => Some(&['\u{0031}', '\u{0033}', '\u{002E}']),
        '\u{2495}' => Some(&['\u{0031}', '\u{0034}', '\u{002E}']),
        '\u{2496}' => Some(&['\u{0031}', '\u{0035}', '\u{002E}']),
        '\u{2497}' => Some(&['\u{0031}', '\u{0036}', '\u{002E}']),
        '\u{2498}' => Some(&['\u{0031}', '\u{0037}', '\u{002E}']),
        '\u{2499}' => Some(&['\u{0031}', '\u{0038}', '\u{002E}']),
        '\u{249A}' => Some(&['\u{0031}', '\u{0039}', '\u{002E}']),
        '\u{249B}' => Some(&['\u{0032}', '\u{0030}', '\u{002E}']),
        '\u{249C}' => Some(&['\u{0028}', '\u{0061}', '\u{0029}']),
        '\u{249D}' => Some(&['\u{0028}', '\u{0062}', '\u{0029}']),
        '\u{249E}' => Some(&['\u{0028}', '\u{0063}', '\u{0029}']),
        '\u{249F}' => Some(&['\u{0028}', '\u{0064}', '\u{0029}']),
        '\u{24A0}' => Some(&['\u{0028}', '\u{0065}', '\u{0029}']),
        '\u{24A1}' => Some(&['\u{0028}', '\u{0066}', '\u{0029}']),
        '\u{24A2}' => Some(&['\u{0028}', '\u{0067}', '\u{0029}']),
        '\u{24A3}' => Some(&['\u{0028}', '\u{0068}', '\u{0029}']),
        '\u{24A4}' => Some(&['\u{0028}', '\u{0069}', '\u{0029}']),
        '\u{24A5}' => Some(&['\u{0028}', '\u{006A}', '\u{0029}']),
        '\u{24A6}' => Some(&['\u{0028}', '\u{006B}', '\u{0029}']),
        '\u{24A7}' => Some(&['\u{0028}', '\u{006C}', '\u{0029}']),
        '\u{24A8}' => Some(&['\u{0028}', '\u{006D}', '\u{0029}']),
        '\u{24A9}' => Some(&['\u{0028}', '\u{006E}', '\u{0029}']),
        '\u{24AA}' => Some(&['\u{0028}', '\u{006F}', '\u{0029}']),
        '\u{24AB}' => Some(&['\u{0028}', '\u{0070}', '\u{0029}']),
        '\u{24AC}' => Some(&['\u{0028}', '\u{0071}', '\u{0029}']),
        '\u{24AD}' => Some(&['\u{0028}', '\u{0072}', '\u{0029}']),
        '\u{24AE}' => Some(&['\u{0028}', '\u{0073}', '\u{0029}']),
        '\u{24AF}' => Some(&['\u{0028}', '\u{0074}', '\u{0029}']),
        '\u{24B0}' => Some(&['\u{0028}', '\u{0075}', '\u{0029}']),
        '\u{24B1}' => Some(&['\u{0028}', '\u{0076}', '\u{0029}']),
        '\u{24B2}' => Some(&['\u{0028}', '\u{0077}', '\u{0029}']),
        '\u{24B3}' => Some(&['\u{0028}', '\u{0078}', '\u{0029}']),
        '\u{24B4}' => Some(&['\u{0028}', '\u{0079}', '\u{0029}']),
        '\u{24B5}' => Some(&['\u{0028}', '\u{007A}', '\u{0029}']),
        '\u{24B6}' => Some(&['\u{0041}']),
        '\u{24B7}' => Some(&['\u{0042}']),
        '\u{24B8}' => Some(&['\u{0043}']),
        '\u{24B9}' => Some(&['\u{0044}']),
        '\u{24BA}' => Some(&['\u{0045}']),
        '\u{24BB}' => Some(&['\u{0046}']),
        '\u{24BC}' => Some(&['\u{0047}']),
        '\u{24BD}' => Some(&['\u{0048}']),
        '\u{24BE}' => Some(&['\u{0049}']),
        '\u{24BF}' => Some(&['\u{004A}']),
        '\u{24C0}' => Some(&['\u{004B}']),
        '\u{24C1}' => Some(&['\u{004C}']),
        '\u{24C2}' => Some(&['\u{004D}']),
        '\u{24C3}' => Some(&['\u{004E}']),
        '\u{24C4}' => Some(&['\u{004F}']),
        '\u{24C5}' => Some(&['\u{0050}']),
        '\u{24C6}' => Some(&['\u{0051}']),
        '\u{24C7}' => Some(&['\u{0052}']),
        '\u{24C8}' => Some(&['\u{0053}']),
        '\u{24C9}' => Some(&['\u{0054}']),
        '\u{24CA}' => Some(&['\u{0055}']),
        '\u{24CB}' => Some(&['\u{0056}']),
        '\u{24CC}' => Some(&['\u{0057}']),
        '\u{24CD}' => Some(&['\u{0058}']),
        '\u{24CE}' => Some(&['\u{0059}']),
        '\u{24CF}' => Some(&['\u{005A}']),
        '\u{24D0}' => Some(&['\u{0061}']),
        '\u{24D1}' => Some(&['\u{0062}']),
        '\u{24D2}' => Some(&['\u{0063}']),
        '\u{24D3}' => Some(&['\u{0064}']),
        '\u{24D4}' => Some(&['\u{0065}']),
        '\u{24D5}' => Some(&['\u{0066}']),
        '\u{24D6}' => Some(&['\u{0067}']),
        '\u{24D7}' => Some(&['\u{0068}']),
        '\u{24D8}' => Some(&['\u{0069}']),
        '\u{24D9}' => Some(&['\u{006A}']),
        '\u{24DA}' => Some(&['\u{006B}']),
        '\u{24DB}' => Some(&['\u{006C}']),
        '\u{24DC}' => Some(&['\u{006D}']),
        '\u{24DD}' => Some(&['\u{006E}']),
        '\u{24DE}' => Some(&['\u{006F}']),
        '\u{24DF}' => Some(&['\u{0070}']),
        '\u{24E0}' => Some(&['\u{0071}']),
        '\u{24E1}' => Some(&['\u{0072}']),
        '\u{24E2}' => Some(&['\u{0073}']),
        '\u{24E3}' => Some(&['\u{0074}']),
        '\u{24E4}' => Some(&['\u{0075}']),
        '\u{24E5}' => Some(&['\u{0076}']),
        '\u{24E6}' => Some(&['\u{0077}']),
        '\u{24E7}' => Some(&['\u{0078}']),
        '\u{24E8}' => Some(&['\u{0079}']),
        '\u{24E9}' => Some(&['\u{007A}']),
        '\u{24EA}' => Some(&['\u{0030}']),
        '\u{2A0C}' => Some(&['\u{222B}', '\u{222B}', '\u{222B}', '\u{222B}']),
        '\u{2A74}' => Some(&['\u{003A}', '\u{003A}', '\u{003D}']),
        '\u{2A75}' => Some(&['\u{003D}', '\u{003D}']),
        '\u{2A76}' => Some(&['\u{003D}', '\u{003D}', '\u{003D}']),
        '\u{2C7C}' => Some(&['\u{006A}']),
        '\u{2C7D}' => Some(&['\u{0056}']),
        '\u{2D6F}' => Some(&['\u{2D61}']),
        '\u{2E9F}' => Some(&['\u{6BCD}']),
        '\u{2EF3}' => Some(&['\u{9F9F}']),
        '\u{2F00}' => Some(&['\u{4E00}']),
        '\u{2F01}' => Some(&['\u{4E28}']),
        '\u{2F02}' => Some(&['\u{4E36}']),
        '\u{2F03}' => Some(&['\u{4E3F}']),
        '\u{2F04}' => Some(&['\u{4E59}']),
        '\u{2F05}' => Some(&['\u{4E85}']),
        '\u{2F06}' => Some(&['\u{4E8C}']),
        '\u{2F07}' => Some(&['\u{4EA0}']),
        '\u{2F08}' => Some(&['\u{4EBA}']),
        '\u{2F09}' => Some(&['\u{513F}']),
        '\u{2F0A}' => Some(&['\u{5165}']),
        '\u{2F0B}' => Some(&['\u{516B}']),
        '\u{2F0C}' => Some(&['\u{5182}']),
        '\u{2F0D}' => Some(&['\u{5196}']),
        '\u{2F0E}' => Some(&['\u{51AB}']),
        '\u{2F0F}' => Some(&['\u{51E0}']),
        '\u{2F10}' => Some(&['\u{51F5}']),
        '\u{2F11}' => Some(&['\u{5200}']),
        '\u{2F12}' => Some(&['\u{529B}']),
        '\u{2F13}' => Some(&['\u{52F9}']),
        '\u{2F14}' => Some(&['\u{5315}']),
        '\u{2F15}' => Some(&['\u{531A}']),
        '\u{2F16}' => Some(&['\u{5338}']),
        '\u{2F17}' => Some(&['\u{5341}']),
        '\u{2F18}' => Some(&['\u{535C}']),
        '\u{2F19}' => Some(&['\u{5369}']),
        '\u{2F1A}' => Some(&['\u{5382}']),
        '\u{2F1B}' => Some(&['\u{53B6}']),
        '\u{2F1C}' => Some(&['\u{53C8}']),
        '\u{2F1D}' => Some(&['\u{53E3}']),
        '\u{2F1E}' => Some(&['\u{56D7}']),
        '\u{2F1F}' => Some(&['\u{571F}']),
        '\u{2F20}' => Some(&['\u{58EB}']),
        '\u{2F21}' => Some(&['\u{5902}']),
        '\u{2F22}' => Some(&['\u{590A}']),
        '\u{2F23}' => Some(&['\u{5915}']),
        '\u{2F24}' => Some(&['\u{5927}']),
        '\u{2F25}' => Some(&['\u{5973}']),
        '\u{2F26}' => Some(&['\u{5B50}']),
        '\u{2F27}' => Some(&['\u{5B80}']),
        '\u{2F28}' => Some(&['\u{5BF8}']),
        '\u{2F29}' => Some(&['\u{5C0F}']),
        '\u{2F2A}' => Some(&['\u{5C22}']),
        '\u{2F2B}' => Some(&['\u{5C38}']),
        '\u{2F2C}' => Some(&['\u{5C6E}']),
        '\u{2F2D}' => Some(&['\u{5C71}']),
        '\u{2F2E}' => Some(&['\u{5DDB}']),
        '\u{2F2F}' => Some(&['\u{5DE5}']),
        '\u{2F30}' => Some(&['\u{5DF1}']),
        '\u{2F31}' => Some(&['\u{5DFE}']),
        '\u{2F32}' => Some(&['\u{5E72}']),
        '\u{2F33}' => Some(&['\u{5E7A}']),
        '\u{2F34}' => Some(&['\u{5E7F}']),
        '\u{2F35}' => Some(&['\u{5EF4}']),
        '\u{2F36}' => Some(&['\u{5EFE}']),
        '\u{2F37}' => Some(&['\u{5F0B}']),
        '\u{2F38}' => Some(&['\u{5F13}']),
        '\u{2F39}' => Some(&['\u{5F50}']),
        '\u{2F3A}' => Some(&['\u{5F61}']),
        '\u{2F3B}' => Some(&['\u{5F73}']),
        '\u{2F3C}' => Some(&['\u{5FC3}']),
        '\u{2F3D}' => Some(&['\u{6208}']),
        '\u{2F3E}' => Some(&['\u{6236}']),
        '\u{2F3F}' => Some(&['\u{624B}']),
        '\u{2F40}' => Some(&['\u{652F}']),
        '\u{2F41}' => Some(&['\u{6534}']),
        '\u{2F42}' => Some(&['\u{6587}']),
        '\u{2F43}' => Some(&['\u{6597}']),
        '\u{2F44}' => Some(&['\u{65A4}']),
        '\u{2F45}' => Some(&['\u{65B9}']),
        '\u{2F46}' => Some(&['\u{65E0}']),
        '\u{2F47}' => Some(&['\u{65E5}']),
        '\u{2F48}' => Some(&['\u{66F0}']),
        '\u{2F49}' => Some(&['\u{6708}']),
        '\u{2F4A}' => Some(&['\u{6728}']),
        '\u{2F4B}' => Some(&['\u{6B20}']),
        '\u{2F4C}' => Some(&['\u{6B62}']),
        '\u{2F4D}' => Some(&['\u{6B79}']),
        '\u{2F4E}' => Some(&['\u{6BB3}']),
        '\u{2F4F}' => Some(&['\u{6BCB}']),
        '\u{2F50}' => Some(&['\u{6BD4}']),
        '\u{2F51}' => Some(&['\u{6BDB}']),
        '\u{2F52}' => Some(&['\u{6C0F}']),
        '\u{2F53}' => Some(&['\u{6C14}']),
        '\u{2F54}' => Some(&['\u{6C34}']),
        '\u{2F55}' => Some(&['\u{706B}']),
        '\u{2F56}' => Some(&['\u{722A}']),
        '\u{2F57}' => Some(&['\u{7236}']),
        '\u{2F58}' => Some(&['\u{723B}']),
        '\u{2F59}' => Some(&['\u{723F}']),
        '\u{2F5A}' => Some(&['\u{7247}']),
        '\u{2F5B}' => Some(&['\u{7259}']),
        '\u{2F5C}' => Some(&['\u{725B}']),
        '\u{2F5D}' => Some(&['\u{72AC}']),
        '\u{2F5E}' => Some(&['\u{7384}']),
        '\u{2F5F}' => Some(&['\u{7389}']),
        '\u{2F60}' => Some(&['\u{74DC}']),
        '\u{2F61}' => Some(&['\u{74E6}']),
        '\u{2F62}' => Some(&['\u{7518}']),
        '\u{2F63}' => Some(&['\u{751F}']),
        '\u{2F64}' => Some(&['\u{7528}']),
        '\u{2F65}' => Some(&['\u{7530}']),
        '\u{2F66}' => Some(&['\u{758B}']),
        '\u{2F67}' => Some(&['\u{7592}']),
        '\u{2F68}' => Some(&['\u{7676}']),
        '\u{2F69}' => Some(&['\u{767D}']),
        '\u{2F6A}' => Some(&['\u{76AE}']),
        '\u{2F6B}' => Some(&['\u{76BF}']),
        '\u{2F6C}' => Some(&['\u{76EE}']),
        '\u{2F6D}' => Some(&['\u{77DB}']),
        '\u{2F6E}' => Some(&['\u{77E2}']),
        '\u{2F6F}' => Some(&['\u{77F3}']),
        '\u{2F70}' => Some(&['\u{793A}']),
        '\u{2F71}' => Some(&['\u{79B8}']),
        '\u{2F72}' => Some(&['\u{79BE}']),
        '\u{2F73}' => Some(&['\u{7A74}']),
        '\u{2F74}' => Some(&['\u{7ACB}']),
        '\u{2F75}' => Some(&['\u{7AF9}']),
        '\u{2F76}' => Some(&['\u{7C73}']),
        '\u{2F77}' => Some(&['\u{7CF8}']),
        '\u{2F78}' => Some(&['\u{7F36}']),
        '\u{2F79}' => Some(&['\u{7F51}']),
        '\u{2F7A}' => Some(&['\u{7F8A}']),
        '\u{2F7B}' => Some(&['\u{7FBD}']),
        '\u{2F7C}' => Some(&['\u{8001}']),
        '\u{2F7D}' => Some(&['\u{800C}']),
        '\u{2F7E}' => Some(&['\u{8012}']),
        '\u{2F7F}' => Some(&['\u{8033}']),
        '\u{2F80}' => Some(&['\u{807F}']),
        '\u{2F81}' => Some(&['\u{8089}']),
        '\u{2F82}' => Some(&['\u{81E3}']),
        '\u{2F83}' => Some(&['\u{81EA}']),
        '\u{2F84}' => Some(&['\u{81F3}']),
        '\u{2F85}' => Some(&['\u{81FC}']),
        '\u{2F86}' => Some(&['\u{820C}']),
        '\u{2F87}' => Some(&['\u{821B}']),
        '\u{2F88}' => Some(&['\u{821F}']),
        '\u{2F89}' => Some(&['\u{826E}']),
        '\u{2F8A}' => Some(&['\u{8272}']),
        '\u{2F8B}' => Some(&['\u{8278}']),
        '\u{2F8C}' => Some(&['\u{864D}']),
        '\u{2F8D}' => Some(&['\u{866B}']),
        '\u{2F8E}' => Some(&['\u{8840}']),
        '\u{2F8F}' => Some(&['\u{884C}']),
        '\u{2F90}' => Some(&['\u{8863}']),
        '\u{2F91}' => Some(&['\u{897E}']),
        '\u{2F92}' => Some(&['\u{898B}']),
        '\u{2F93}' => Some(&['\u{89D2}']),
        '\u{2F94}' => Some(&['\u{8A00}']),
        '\u{2F95}' => Some(&['\u{8C37}']),
        '\u{2F96}' => Some(&['\u{8C46}']),
        '\u{2F97}' => Some(&['\u{8C55}']),
        '\u{2F98}' => Some(&['\u{8C78}']),
        '\u{2F99}' => Some(&['\u{8C9D}']),
        '\u{2F9A}' => Some(&['\u{8D64}']),
        '\u{2F9B}' => Some(&['\u{8D70}']),
        '\u{2F9C}' => Some(&['\u{8DB3}']),
        '\u{2F9D}' => Some(&['\u{8EAB}']),
        '\u{2F9E}' => Some(&['\u{8ECA}']),
        '\u{2F9F}' => Some(&['\u{8F9B}']),
        '\u{2FA0}' => Some(&['\u{8FB0}']),
        '\u{2FA1}' => Some(&['\u{8FB5}']),
        '\u{2FA2}' => Some(&['\u{9091}']),
        '\u{2FA3}' => Some(&['\u{9149}']),
        '\u{2FA4}' => Some(&['\u{91C6}']),
        '\u{2FA5}' => Some(&['\u{91CC}']),
        '\u{2FA6}' => Some(&['\u{91D1}']),
        '\u{2FA7}' => Some(&['\u{9577}']),
        '\u{2FA8}' => Some(&['\u{9580}']),
        '\u{2FA9}' => Some(&['\u{961C}']),
        '\u{2FAA}' => Some(&['\u{96B6}']),
        '\u{2FAB}' => Some(&['\u{96B9}']),
        '\u{2FAC}' => Some(&['\u{96E8}']),
        '\u{2FAD}' => Some(&['\u{9751}']),
        '\u{2FAE}' => Some(&['\u{975E}']),
        '\u{2FAF}' => Some(&['\u{9762}']),
        '\u{2FB0}' => Some(&['\u{9769}']),
        '\u{2FB1}' => Some(&['\u{97CB}']),
        '\u{2FB2}' => Some(&['\u{97ED}']),
        '\u{2FB3}' => Some(&['\u{97F3}']),
        '\u{2FB4}' => Some(&['\u{9801}']),
        '\u{2FB5}' => Some(&['\u{98A8}']),
        '\u{2FB6}' => Some(&['\u{98DB}']),
        '\u{2FB7}' => Some(&['\u{98DF}']),
        '\u{2FB8}' => Some(&['\u{9996}']),
        '\u{2FB9}' => Some(&['\u{9999}']),
        '\u{2FBA}' => Some(&['\u{99AC}']),
        '\u{2FBB}' => Some(&['\u{9AA8}']),
        '\u{2FBC}' => Some(&['\u{9AD8}']),
        '\u{2FBD}' => Some(&['\u{9ADF}']),
        '\u{2FBE}' => Some(&['\u{9B25}']),
        '\u{2FBF}' => Some(&['\u{9B2F}']),
        '\u{2FC0}' => Some(&['\u{9B32}']),
        '\u{2FC1}' => Some(&['\u{9B3C}']),
        '\u{2FC2}' => Some(&['\u{9B5A}']),
        '\u{2FC3}' => Some(&['\u{9CE5}']),
        '\u{2FC4}' => Some(&['\u{9E75}']),
        '\u{2FC5}' => Some(&['\u{9E7F}']),
        '\u{2FC6}' => Some(&['\u{9EA5}']),
        '\u{2FC7}' => Some(&['\u{9EBB}']),
        '\u{2FC8}' => Some(&['\u{9EC3}']),
        '\u{2FC9}' => Some(&['\u{9ECD}']),
        '\u{2FCA}' => Some(&['\u{9ED1}']),
        '\u{2FCB}' => Some(&['\u{9EF9}']),
        '\u{2FCC}' => Some(&['\u{9EFD}']),
        '\u{2FCD}' => Some(&['\u{9F0E}']),
        '\u{2FCE}' => Some(&['\u{9F13}']),
        '\u{2FCF}' => Some(&['\u{9F20}']),
        '\u{2FD0}' => Some(&['\u{9F3B}']),
        '\u{2FD1}' => Some(&['\u{9F4A}']),
        '\u{2FD2}' => Some(&['\u{9F52}']),
        '\u{2FD3}' => Some(&['\u{9F8D}']),
        '\u{2FD4}' => Some(&['\u{9F9C}']),
        '\u{2FD5}' => Some(&['\u{9FA0}']),
        '\u{3000}' => Some(&['\u{0020}']),
        '\u{3036}' => Some(&['\u{3012}']),
        '\u{3038}' => Some(&['\u{5341}']),
        '\u{3039}' => Some(&['\u{5344}']),
        '\u{303A}' => Some(&['\u{5345}']),
        '\u{309B}' => Some(&['\u{0020}', '\u{3099}']),
        '\u{309C}' => Some(&['\u{0020}', '\u{309A}']),
        '\u{309F}' => Some(&['\u{3088}', '\u{308A}']),
        '\u{30FF}' => Some(&['\u{30B3}', '\u{30C8}']),
        '\u{3131}' => Some(&['\u{1100}']),
        '\u{3132}' => Some(&['\u{1101}']),
        '\u{3133}' => Some(&['\u{11AA}']),
        '\u{3134}' => Some(&['\u{1102}']),
        '\u{3135}' => Some(&['\u{11AC}']),
        '\u{3136}' => Some(&['\u{11AD}']),
        '\u{3137}' => Some(&['\u{1103}']),
        '\u{3138}' => Some(&['\u{1104}']),
        '\u{3139}' => Some(&['\u{1105}']),
        '\u{313A}' => Some(&['\u{11B0}']),
        '\u{313B}' => Some(&['\u{11B1}']),
        '\u{313C}' => Some(&['\u{11B2}']),
        '\u{313D}' => Some(&['\u{11B3}']),
        '\u{313E}' => Some(&['\u{11B4}']),
        '\u{313F}' => Some(&['\u{11B5}']),
        '\u{3140}' => Some(&['\u{111A}']),
        '\u{3141}' => Some(&['\u{1106}']),
        '\u{3142}' => Some(&['\u{1107}']),
        '\u{3143}' => Some(&['\u{1108}']),
        '\u{3144}' => Some(&['\u{1121}']),
        '\u{3145}' => Some(&['\u{1109}']),
        '\u{3146}' => Some(&['\u{110A}']),
        '\u{3147}' => Some(&['\u{110B}']),
        '\u{3148}' => Some(&['\u{110C}']),
        '\u{3149}' => Some(&['\u{110D}']),
        '\u{314A}' => Some(&['\u{110E}']),
        '\u{314B}' => Some(&['\u{110F}']),
        '\u{314C}' => Some(&['\u{1110}']),
        '\u{314D}' => Some(&['\u{1111}']),
        '\u{314E}' => Some(&['\u{1112}']),
        '\u{314F}' => Some(&['\u{1161}']),
        '\u{3150}' => Some(&['\u{1162}']),
        '\u{3151}' => Some(&['\u{1163}']),
        '\u{3152}' => Some(&['\u{1164}']),
        '\u{3153}' => Some(&['\u{1165}']),
        '\u{3154}' => Some(&['\u{1166}']),
        '\u{3155}' => Some(&['\u{1167}']),
        '\u{3156}' => Some(&['\u{1168}']),
        '\u{3157}' => Some(&['\u{1169}']),
        '\u{3158}' => Some(&['\u{116A}']),
        '\u{3159}' => Some(&['\u{116B}']),
        '\u{315A}' => Some(&['\u{116C}']),
        '\u{315B}' => Some(&['\u{116D}']),
        '\u{315C}' => Some(&['\u{116E}']),
        '\u{315D}' => Some(&['\u{116F}']),
        '\u{315E}' => Some(&['\u{1170}']),
        '\u{315F}' => Some(&['\u{1171}']),
        '\u{3160}' => Some(&['\u{1172}']),
        '\u{3161}' => Some(&['\u{1173}']),
        '\u{3162}' => Some(&['\u{1174}']),
        '\u{3163}' => Some(&['\u{1175}']),
        '\u{3164}' => Some(&['\u{1160}']),
        '\u{3165}' => Some(&['\u{1114}']),
        '\u{3166}' => Some(&['\u{1115}']),
        '\u{3167}' => Some(&['\u{11C7}']),
        '\u{3168}' => Some(&['\u{11C8}']),
        '\u{3169}' => Some(&['\u{11CC}']),
        '\u{316A}' => Some(&['\u{11CE}']),
        '\u{316B}' => Some(&['\u{11D3}']),
        '\u{316C}' => Some(&['\u{11D7}']),
        '\u{316D}' => Some(&['\u{11D9}']),
        '\u{316E}' => Some(&['\u{111C}']),
        '\u{316F}' => Some(&['\u{11DD}']),
        '\u{3170}' => Some(&['\u{11DF}']),
        '\u{3171}' => Some(&['\u{111D}']),
        '\u{3172}' => Some(&['\u{111E}']),
        '\u{3173}' => Some(&['\u{1120}']),
        '\u{3174}' => Some(&['\u{1122}']),
        '\u{3175}' => Some(&['\u{1123}']),
        '\u{3176}' => Some(&['\u{1127}']),
        '\u{3177}' => Some(&['\u{1129}']),
        '\u{3178}' => Some(&['\u{112B}']),
        '\u{3179}' => Some(&['\u{112C}']),
        '\u{317A}' => Some(&['\u{112D}']),
        '\u{317B}' => Some(&['\u{112E}']),
        '\u{317C}' => Some(&['\u{112F}']),
        '\u{317D}' => Some(&['\u{1132}']),
        '\u{317E}' => Some(&['\u{1136}']),
        '\u{317F}' => Some(&['\u{1140}']),
        '\u{3180}' => Some(&['\u{1147}']),
        '\u{3181}' => Some(&['\u{114C}']),
        '\u{3182}' => Some(&['\u{11F1}']),
        '\u{3183}' => Some(&['\u{11F2}']),
        '\u{3184}' => Some(&['\u{1157}']),
        '\u{3185}' => Some(&['\u{1158}']),
        '\u{3186}' => Some(&['\u{1159}']),
        '\u{3187}' => Some(&['\u{1184}']),
        '\u{3188}' => Some(&['\u{1185}']),
        '\u{3189}' => Some(&['\u{1188}']),
        '\u{318A}' => Some(&['\u{1191}']),
        '\u{318B}' => Some(&['\u{1192}']),
        '\u{318C}' => Some(&['\u{1194}']),
        '\u{318D}' => Some(&['\u{119E}']),
        '\u{318E}' => Some(&['\u{11A1}']),
        '\u{3192}' => Some(&['\u{4E00}']),
        '\u{3193}' => Some(&['\u{4E8C}']),
        '\u{3194}' => Some(&['\u{4E09}']),
        '\u{3195}' => Some(&['\u{56DB}']),
        '\u{3196}' => Some(&['\u{4E0A}']),
        '\u{3197}' => Some(&['\u{4E2D}']),
        '\u{3198}' => Some(&['\u{4E0B}']),
        '\u{3199}' => Some(&['\u{7532}']),
        '\u{319A}' => Some(&['\u{4E59}']),
        '\u{319B}' => Some(&['\u{4E19}']),
        '\u{319C}' => Some(&['\u{4E01}']),
        '\u{319D}' => Some(&['\u{5929}']),
        '\u{319E}' => Some(&['\u{5730}']),
        '\u{319F}' => Some(&['\u{4EBA}']),
        '\u{3200}' => Some(&['\u{0028}', '\u{1100}', '\u{0029}']),
        '\u{3201}' => Some(&['\u{0028}', '\u{1102}', '\u{0029}']),
        '\u{3202}' => Some(&['\u{0028}', '\u{1103}', '\u{0029}']),
        '\u{3203}' => Some(&['\u{0028}', '\u{1105}', '\u{0029}']),
        '\u{3204}' => Some(&['\u{0028}', '\u{1106}', '\u{0029}']),
        '\u{3205}' => Some(&['\u{0028}', '\u{1107}', '\u{0029}']),
        '\u{3206}' => Some(&['\u{0028}', '\u{1109}', '\u{0029}']),
        '\u{3207}' => Some(&['\u{0028}', '\u{110B}', '\u{0029}']),
        '\u{3208}' => Some(&['\u{0028}', '\u{110C}', '\u{0029}']),
        '\u{3209}' => Some(&['\u{0028}', '\u{110E}', '\u{0029}']),
        '\u{320A}' => Some(&['\u{0028}', '\u{110F}', '\u{0029}']),
        '\u{320B}' => Some(&['\u{0028}', '\u{1110}', '\u{0029}']),
        '\u{320C}' => Some(&['\u{0028}', '\u{1111}', '\u{0029}']),
        '\u{320D}' => Some(&['\u{0028}', '\u{1112}', '\u{0029}']),
        '\u{320E}' => Some(&['\u{0028}', '\u{1100}', '\u{1161}', '\u{0029}']),
        '\u{320F}' => Some(&['\u{0028}', '\u{1102}', '\u{1161}', '\u{0029}']),
        '\u{3210}' => Some(&['\u{0028}', '\u{1103}', '\u{1161}', '\u{0029}']),
        '\u{3211}' => Some(&['\u{0028}', '\u{1105}', '\u{1161}', '\u{0029}']),
        '\u{3212}' => Some(&['\u{0028}', '\u{1106}', '\u{1161}', '\u{0029}']),
        '\u{3213}' => Some(&['\u{0028}', '\u{1107}', '\u{1161}', '\u{0029}']),
        '\u{3214}' => Some(&['\u{0028}', '\u{1109}', '\u{1161}', '\u{0029}']),
        '\u{3215}' => Some(&['\u{0028}', '\u{110B}', '\u{1161}', '\u{0029}']),
        '\u{3216}' => Some(&['\u{0028}', '\u{110C}', '\u{1161}', '\u{0029}']),
        '\u{3217}' => Some(&['\u{0028}', '\u{110E}', '\u{1161}', '\u{0029}']),
        '\u{3218}' => Some(&['\u{0028}', '\u{110F}', '\u{1161}', '\u{0029}']),
        '\u{3219}' => Some(&['\u{0028}', '\u{1110}', '\u{1161}', '\u{0029}']),
        '\u{321A}' => Some(&['\u{0028}', '\u{1111}', '\u{1161}', '\u{0029}']),
        '\u{321B}' => Some(&['\u{0028}', '\u{1112}', '\u{1161}', '\u{0029}']),
        '\u{321C}' => Some(&['\u{0028}', '\u{110C}', '\u{116E}', '\u{0029}']),
        '\u{321D}' => Some(&['\u{0028}', '\u{110B}', '\u{1169}', '\u{110C}', '\u{1165}', '\u{11AB}', '\u{0029}']),
        '\u{321E}' => Some(&['\u{0028}', '\u{110B}', '\u{1169}', '\u{1112}', '\u{116E}', '\u{0029}']),
        '\u{3220}' => Some(&['\u{0028}', '\u{4E00}', '\u{0029}']),
        '\u{3221}' => Some(&['\u{0028}', '\u{4E8C}', '\u{0029}']),
        '\u{3222}' => Some(&['\u{0028}', '\u{4E09}', '\u{0029}']),
        '\u{3223}' => Some(&['\u{0028}', '\u{56DB}', '\u{0029}']),
        '\u{3224}' => Some(&['\u{0028}', '\u{4E94}', '\u{0029}']),
        '\u{3225}' => Some(&['\u{0028}', '\u{516D}', '\u{0029}']),
        '\u{3226}' => Some(&['\u{0028}', '\u{4E03}', '\u{0029}']),
        '\u{3227}' => Some(&['\u{0028}', '\u{516B}', '\u{0029}']),
        '\u{3228}' => Some(&['\u{0028}', '\u{4E5D}', '\u{0029}']),
        '\u{3229}' => Some(&['\u{0028}', '\u{5341}', '\u{0029}']),
        '\u{322A}' => Some(&['\u{0028}', '\u{6708}', '\u{0029}']),
        '\u{322B}' => Some(&['\u{0028}', '\u{706B}', '\u{0029}']),
        '\u{322C}' => Some(&['\u{0028}', '\u{6C34}', '\u{0029}']),
        '\u{322D}' => Some(&['\u{0028}', '\u{6728}', '\u{0029}']),
        '\u{322E}' => Some(&['\u{0028}', '\u{91D1}', '\u{0029}']),
        '\u{322F}' => Some(&['\u{0028}', '\u{571F}', '\u{0029}']),
        '\u{3230}' => Some(&['\u{0028}', '\u{65E5}', '\u{0029}']),
        '\u{3231}' => Some(&['\u{0028}', '\u{682A}', '\u{0029}']),
        '\u{3232}' => Some(&['\u{0028}', '\u{6709}', '\u{0029}']),
        '\u{3233}' => Some(&['\u{0028}', '\u{793E}', '\u{0029}']),
        '\u{3234}' => Some(&['\u{0028}', '\u{540D}', '\u{0029}']),
        '\u{3235}' => Some(&['\u{0028}', '\u{7279}', '\u{0029}']),
        '\u{3236}' => Some(&['\u{0028}', '\u{8CA1}', '\u{0029}']),
        '\u{3237}' => Some(&['\u{0028}', '\u{795D}', '\u{0029}']),
        '\u{3238}' => Some(&['\u{0028}', '\u{52B4}', '\u{0029}']),
        '\u{3239}' => Some(&['\u{0028}', '\u{4EE3}', '\u{0029}']),
        '\u{323A}' => Some(&['\u{0028}', '\u{547C}', '\u{0029}']),
        '\u{323B}' => Some(&['\u{0028}', '\u{5B66}', '\u{0029}']),
        '\u{323C}' => Some(&['\u{0028}', '\u{76E3}', '\u{0029}']),
        '\u{323D}' => Some(&['\u{0028}', '\u{4F01}', '\u{0029}']),
        '\u{323E}' => Some(&['\u{0028}', '\u{8CC7}', '\u{0029}']),
        '\u{323F}' => Some(&['\u{0028}', '\u{5354}', '\u{0029}']),
        '\u{3240}' => Some(&['\u{0028}', '\u{796D}', '\u{0029}']),
        '\u{3241}' => Some(&['\u{0028}', '\u{4F11}', '\u{0029}']),
        '\u{3242}' => Some(&['\u{0028}', '\u{81EA}', '\u{0029}']),
        '\u{3243}' => Some(&['\u{0028}', '\u{81F3}', '\u{0029}']),
        '\u{3244}' => Some(&['\u{554F}']),
        '\u{3245}' => Some(&['\u{5E7C}']),
        '\u{3246}' => Some(&['\u{6587}']),
        '\u{3247}' => Some(&['\u{7B8F}']),
        '\u{3250}' => Some(&['\u{0050}', '\u{0054}', '\u{0045}']),
        '\u{3251}' => Some(&['\u{0032}', '\u{0031}']),
        '\u{3252}' => Some(&['\u{0032}', '\u{0032}']),
        '\u{3253}' => Some(&['\u{0032}', '\u{0033}']),
        '\u{3254}' => Some(&['\u{0032}', '\u{0034}']),
        '\u{3255}' => Some(&['\u{0032}', '\u{0035}']),
        '\u{3256}' => Some(&['\u{0032}', '\u{0036}']),
        '\u{3257}' => Some(&['\u{0032}', '\u{0037}']),
        '\u{3258}' => Some(&['\u{0032}', '\u{0038}']),
        '\u{3259}' => Some(&['\u{0032}', '\u{0039}']),
        '\u{325A}' => Some(&['\u{0033}', '\u{0030}']),
        '\u{325B}' => Some(&['\u{0033}', '\u{0031}']),
        '\u{325C}' => Some(&['\u{0033}', '\u{0032}']),
        '\u{325D}' => Some(&['\u{0033}', '\u{0033}']),
        '\u{325E}' => Some(&['\u{0033}', '\u{0034}']),
        '\u{325F}' => Some(&['\u{0033}', '\u{0035}']),
        '\u{3260}' => Some(&['\u{1100}']),
        '\u{3261}' => Some(&['\u{1102}']),
        '\u{3262}' => Some(&['\u{1103}']),
        '\u{3263}' => Some(&['\u{1105}']),
        '\u{3264}' => Some(&['\u{1106}']),
        '\u{3265}' => Some(&['\u{1107}']),
        '\u{3266}' => Some(&['\u{1109}']),
        '\u{3267}' => Some(&['\u{110B}']),
        '\u{3268}' => Some(&['\u{110C}']),
        '\u{3269}' => Some(&['\u{110E}']),
        '\u{326A}' => Some(&['\u{110F}']),
        '\u{326B}' => Some(&['\u{1110}']),
        '\u{326C}' => Some(&['\u{1111}']),
        '\u{326D}' => Some(&['\u{1112}']),
        '\u{326E}' => Some(&['\u{1100}', '\u{1161}']),
        '\u{326F}' => Some(&['\u{1102}', '\u{1161}']),
        '\u{3270}' => Some(&['\u{1103}', '\u{1161}']),
        '\u{3271}' => Some(&['\u{1105}', '\u{1161}']),
        '\u{3272}' => Some(&['\u{1106}', '\u{1161}']),
        '\u{3273}' => Some(&['\u{1107}', '\u{1161}']),
        '\u{3274}' => Some(&['\u{1109}', '\u{1161}']),
        '\u{3275}' => Some(&['\u{110B}', '\u{1161}']),
        '\u{3276}' => Some(&['\u{110C}', '\u{1161}']),
        '\u{3277}' => Some(&['\u{110E}', '\u{1161}']),
        '\u{3278}' => Some(&['\u{110F}', '\u{1161}']),
        '\u{3279}' => Some(&['\u{1110}', '\u{1161}']),
        '\u{327A}' => Some(&['\u{1111}', '\u{1161}']),
        '\u{327B}' => Some(&['\u{1112}', '\u{1161}']),
        '\u{327C}' => Some(&['\u{110E}', '\u{1161}', '\u{11B7}', '\u{1100}', '\u{1169}']),
        '\u{327D}' => Some(&['\u{110C}', '\u{116E}', '\u{110B}', '\u{1174}']),
        '\u{327E}' => Some(&['\u{110B}', '\u{116E}']),
        '\u{3280}' => Some(&['\u{4E00}']),
        '\u{3281}' => Some(&['\u{4E8C}']),
        '\u{3282}' => Some(&['\u{4E09}']),
        '\u{3283}' => Some(&['\u{56DB}']),
        '\u{3284}' => Some(&['\u{4E94}']),
        '\u{3285}' => Some(&['\u{516D}']),
        '\u{3286}' => Some(&['\u{4E03}']),
        '\u{3287}' => Some(&['\u{516B}']),
        '\u{3288}' => Some(&['\u{4E5D}']),
        '\u{3289}' => Some(&['\u{5341}']),
        '\u{328A}' => Some(&['\u{6708}']),
        '\u{328B}' => Some(&['\u{706B}']),
        '\u{328C}' => Some(&['\u{6C34}']),
        '\u{328D}' => Some(&['\u{6728}']),
        '\u{328E}' => Some(&['\u{91D1}']),
        '\u{328F}' => Some(&['\u{571F}']),
        '\u{3290}' => Some(&['\u{65E5}']),
        '\u{3291}' => Some(&['\u{682A}']),
        '\u{3292}' => Some(&['\u{6709}']),
        '\u{3293}' => Some(&['\u{793E}']),
        '\u{3294}' => Some(&['\u{540D}']),
        '\u{3295}' => Some(&['\u{7279}']),
        '\u{3296}' => Some(&['\u{8CA1}']),
        '\u{3297}' => Some(&['\u{795D}']),
        '\u{3298}' => Some(&['\u{52B4}']),
        '\u{3299}' => Some(&['\u{79D8}']),
        '\u{329A}' => Some(&['\u{7537}']),
        '\u{329B}' => Some(&['\u{5973}']),
        '\u{329C}' => Some(&['\u{9069}']),
        '\u{329D}' => Some(&['\u{512A}']),
        '\u{329E}' => Some(&['\u{5370}']),
        '\u{329F}' => Some(&['\u{6CE8}']),
        '\u{32A0}' => Some(&['\u{9805}']),
        '\u{32A1}' => Some(&['\u{4F11}']),
        '\u{32A2}' => Some(&['\u{5199}']),
        '\u{32A3}' => Some(&['\u{6B63}']),
        '\u{32A4}' => Some(&['\u{4E0A}']),
        '\u{32A5}' => Some(&['\u{4E2D}']),
        '\u{32A6}' => Some(&['\u{4E0B}']),
        '\u{32A7}' => Some(&['\u{5DE6}']),
        '\u{32A8}' => Some(&['\u{53F3}']),
        '\u{32A9}' => Some(&['\u{533B}']),
        '\u{32AA}' => Some(&['\u{5B97}']),
        '\u{32AB}' => Some(&['\u{5B66}']),
        '\u{32AC}' => Some(&['\u{76E3}']),
        '\u{32AD}' => Some(&['\u{4F01}']),
        '\u{32AE}' => Some(&['\u{8CC7}']),
        '\u{32AF}' => Some(&['\u{5354}']),
        '\u{32B0}' => Some(&['\u{591C}']),
        '\u{32B1}' => Some(&['\u{0033}', '\u{0036}']),
        '\u{32B2}' => Some(&['\u{0033}', '\u{0037}']),
        '\u{32B3}' => Some(&['\u{0033}', '\u{0038}']),
        '\u{32B4}' => Some(&['\u{0033}', '\u{0039}']),
        '\u{32B5}' => Some(&['\u{0034}', '\u{0030}']),
        '\u{32B6}' => Some(&['\u{0034}', '\u{0031}']),
        '\u{32B7}' => Some(&['\u{0034}', '\u{0032}']),
        '\u{32B8}' => Some(&['\u{0034}', '\u{0033}']),
        '\u{32B9}' => Some(&['\u{0034}', '\u{0034}']),
        '\u{32BA}' => Some(&['\u{0034}', '\u{0035}']),
        '\u{32BB}' => Some(&['\u{0034}', '\u{0036}']),
        '\u{32BC}' => Some(&['\u{0034}', '\u{0037}']),
        '\u{32BD}' => Some(&['\u{0034}', '\u{0038}']),
        '\u{32BE}' => Some(&['\u{0034}', '\u{0039}']),
        '\u{32BF}' => Some(&['\u{0035}', '\u{0030}']),
        '\u{32C0}' => Some(&['\u{0031}', '\u{6708}']),
        '\u{32C1}' => Some(&['\u{0032}', '\u{6708}']),
        '\u{32C2}' => Some(&['\u{0033}', '\u{6708}']),
        '\u{32C3}' => Some(&['\u{0034}', '\u{6708}']),
        '\u{32C4}' => Some(&['\u{0035}', '\u{6708}']),
        '\u{32C5}' => Some(&['\u{0036}', '\u{6708}']),
        '\u{32C6}' => Some(&['\u{0037}', '\u{6708}']),
        '\u{32C7}' => Some(&['\u{0038}', '\u{6708}']),
        '\u{32C8}' => Some(&['\u{0039}', '\u{6708}']),
        '\u{32C9}' => Some(&['\u{0031}', '\u{0030}', '\u{6708}']),
        '\u{32CA}' => Some(&['\u{0031}', '\u{0031}', '\u{6708}']),
        '\u{32CB}' => Some(&['\u{0031}', '\u{0032}', '\u{6708}']),
        '\u{32CC}' => Some(&['\u{0048}', '\u{0067}']),
        '\u{32CD}' => Some(&['\u{0065}', '\u{0072}', '\u{0067}']),
        '\u{32CE}' => Some(&['\u{0065}', '\u{0056}']),
        '\u{32CF}' => Some(&['\u{004C}', '\u{0054}', '\u{0044}']),
        '\u{32D0}' => Some(&['\u{30A2}']),
        '\u{32D1}' => Some(&['\u{30A4}']),
        '\u{32D2}' => Some(&['\u{30A6}']),
        '\u{32D3}' => Some(&['\u{30A8}']),
        '\u{32D4}' => Some(&['\u{30AA}']),
        '\u{32D5}' => Some(&['\u{30AB}']),
        '\u{32D6}' => Some(&['\u{30AD}']),
        '\u{32D7}' => Some(&['\u{30AF}']),
        '\u{32D8}' => Some(&['\u{30B1}']),
        '\u{32D9}' => Some(&['\u{30B3}']),
        '\u{32DA}' => Some(&['\u{30B5}']),
        '\u{32DB}' => Some(&['\u{30B7}']),
        '\u{32DC}' => Some(&['\u{30B9}']),
        '\u{32DD}' => Some(&['\u{30BB}']),
        '\u{32DE}' => Some(&['\u{30BD}']),
        '\u{32DF}' => Some(&['\u{30BF}']),
        '\u{32E0}' => Some(&['\u{30C1}']),
        '\u{32E1}' => Some(&['\u{30C4}']),
        '\u{32E2}' => Some(&['\u{30C6}']),
        '\u{32E3}' => Some(&['\u{30C8}']),
        '\u{32E4}' => Some(&['\u{30CA}']),
        '\u{32E5}' => Some(&['\u{30CB}']),
        '\u{32E6}' => Some(&['\u{30CC}']),
        '\u{32E7}' => Some(&['\u{30CD}']),
        '\u{32E8}' => Some(&['\u{30CE}']),
        '\u{32E9}' => Some(&['\u{30CF}']),
        '\u{32EA}' => Some(&['\u{30D2}']),
        '\u{32EB}' => Some(&['\u{30D5}']),
        '\u{32EC}' => Some(&['\u{30D8}']),
        '\u{32ED}' => Some(&['\u{30DB}']),
        '\u{32EE}' => Some(&['\u{30DE}']),
        '\u{32EF}' => Some(&['\u{30DF}']),
        '\u{32F0}' => Some(&['\u{30E0}']),
        '\u{32F1}' => Some(&['\u{30E1}']),
        '\u{32F2}' => Some(&['\u{30E2}']),
        '\u{32F3}' => Some(&['\u{30E4}']),
        '\u{32F4}' => Some(&['\u{30E6}']),
        '\u{32F5}' => Some(&['\u{30E8}']),
        '\u{32F6}' => Some(&['\u{30E9}']),
        '\u{32F7}' => Some(&['\u{30EA}']),
        '\u{32F8}' => Some(&['\u{30EB}']),
        '\u{32F9}' => Some(&['\u{30EC}']),
        '\u{32FA}' => Some(&['\u{30ED}']),
        '\u{32FB}' => Some(&['\u{30EF}']),
        '\u{32FC}' => Some(&['\u{30F0}']),
        '\u{32FD}' => Some(&['\u{30F1}']),
        '\u{32FE}' => Some(&['\u{30F2}']),
        '\u{3300}' => Some(&['\u{30A2}', '\u{30CF}', '\u{309A}', '\u{30FC}', '\u{30C8}']),
        '\u{3301}' => Some(&['\u{30A2}', '\u{30EB}', '\u{30D5}', '\u{30A1}']),
        '\u{3302}' => Some(&['\u{30A2}', '\u{30F3}', '\u{30D8}', '\u{309A}', '\u{30A2}']),
        '\u{3303}' => Some(&['\u{30A2}', '\u{30FC}', '\u{30EB}']),
        '\u{3304}' => Some(&['\u{30A4}', '\u{30CB}', '\u{30F3}', '\u{30AF}', '\u{3099}']),
        '\u{3305}' => Some(&['\u{30A4}', '\u{30F3}', '\u{30C1}']),
        '\u{3306}' => Some(&['\u{30A6}', '\u{30A9}', '\u{30F3}']),
        '\u{3307}' => Some(&['\u{30A8}', '\u{30B9}', '\u{30AF}', '\u{30FC}', '\u{30C8}', '\u{3099}']),
        '\u{3308}' => Some(&['\u{30A8}', '\u{30FC}', '\u{30AB}', '\u{30FC}']),
        '\u{3309}' => Some(&['\u{30AA}', '\u{30F3}', '\u{30B9}']),
        '\u{330A}' => Some(&['\u{30AA}', '\u{30FC}', '\u{30E0}']),
        '\u{330B}' => Some(&['\u{30AB}', '\u{30A4}', '\u{30EA}']),
        '\u{330C}' => Some(&['\u{30AB}', '\u{30E9}', '\u{30C3}', '\u{30C8}']),
        '\u{330D}' => Some(&['\u{30AB}', '\u{30ED}', '\u{30EA}', '\u{30FC}']),
        '\u{330E}' => Some(&['\u{30AB}', '\u{3099}', '\u{30ED}', '\u{30F3}']),
        '\u{330F}' => Some(&['\u{30AB}', '\u{3099}', '\u{30F3}', '\u{30DE}']),
        '\u{3310}' => Some(&['\u{30AD}', '\u{3099}', '\u{30AB}', '\u{3099}']),
        '\u{3311}' => Some(&['\u{30AD}', '\u{3099}', '\u{30CB}', '\u{30FC}']),
        '\u{3312}' => Some(&['\u{30AD}', '\u{30E5}', '\u{30EA}', '\u{30FC}']),
        '\u{3313}' => Some(&['\u{30AD}', '\u{3099}', '\u{30EB}', '\u{30BF}', '\u{3099}', '\u{30FC}']),
        '\u{3314}' => Some(&['\u{30AD}', '\u{30ED}']),
        '\u{3315}' => Some(&['\u{30AD}', '\u{30ED}', '\u{30AF}', '\u{3099}', '\u{30E9}', '\u{30E0}']),
        '\u{3316}' => Some(&['\u{30AD}', '\u{30ED}', '\u{30E1}', '\u{30FC}', '\u{30C8}', '\u{30EB}']),
        '\u{3317}' => Some(&['\u{30AD}', '\u{30ED}', '\u{30EF}', '\u{30C3}', '\u{30C8}']),
        '\u{3318}' => Some(&['\u{30AF}', '\u{3099}', '\u{30E9}', '\u{30E0}']),
        '\u{3319}' => Some(&['\u{30AF}', '\u{3099}', '\u{30E9}', '\u{30E0}', '\u{30C8}', '\u{30F3}']),
        '\u{331A}' => Some(&['\u{30AF}', '\u{30EB}', '\u{30BB}', '\u{3099}', '\u{30A4}', '\u{30ED}']),
        '\u{331B}' => Some(&['\u{30AF}', '\u{30ED}', '\u{30FC}', '\u{30CD}']),
        '\u{331C}' => Some(&['\u{30B1}', '\u{30FC}', '\u{30B9}']),
        '\u{331D}' => Some(&['\u{30B3}', '\u{30EB}', '\u{30CA}']),
        '\u{331E}' => Some(&['\u{30B3}', '\u{30FC}', '\u{30DB}', '\u{309A}']),
        '\u{331F}' => Some(&['\u{30B5}', '\u{30A4}', '\u{30AF}', '\u{30EB}']),
        '\u{3320}' => Some(&['\u{30B5}', '\u{30F3}', '\u{30C1}', '\u{30FC}', '\u{30E0}']),
        '\u{3321}' => Some(&['\u{30B7}', '\u{30EA}', '\u{30F3}', '\u{30AF}', '\u{3099}']),
        '\u{3322}' => Some(&['\u{30BB}', '\u{30F3}', '\u{30C1}']),
        '\u{3323}' => Some(&['\u{30BB}', '\u{30F3}', '\u{30C8}']),
        '\u{3324}' => Some(&['\u{30BF}', '\u{3099}', '\u{30FC}', '\u{30B9}']),
        '\u{3325}' => Some(&['\u{30C6}', '\u{3099}', '\u{30B7}']),
        '\u{3326}' => Some(&['\u{30C8}', '\u{3099}', '\u{30EB}']),
        '\u{3327}' => Some(&['\u{30C8}', '\u{30F3}']),
        '\u{3328}' => Some(&['\u{30CA}', '\u{30CE}']),
        '\u{3329}' => Some(&['\u{30CE}', '\u{30C3}', '\u{30C8}']),
        '\u{332A}' => Some(&['\u{30CF}', '\u{30A4}', '\u{30C4}']),
        '\u{332B}' => Some(&['\u{30CF}', '\u{309A}', '\u{30FC}', '\u{30BB}', '\u{30F3}', '\u{30C8}']),
        '\u{332C}' => Some(&['\u{30CF}', '\u{309A}', '\u{30FC}', '\u{30C4}']),
        '\u{332D}' => Some(&['\u{30CF}', '\u{3099}', '\u{30FC}', '\u{30EC}', '\u{30EB}']),
        '\u{332E}' => Some(&['\u{30D2}', '\u{309A}', '\u{30A2}', '\u{30B9}', '\u{30C8}', '\u{30EB}']),
        '\u{332F}' => Some(&['\u{30D2}', '\u{309A}', '\u{30AF}', '\u{30EB}']),
        '\u{3330}' => Some(&['\u{30D2}', '\u{309A}', '\u{30B3}']),
        '\u{3331}' => Some(&['\u{30D2}', '\u{3099}', '\u{30EB}']),
        '\u{3332}' => Some(&['\u{30D5}', '\u{30A1}', '\u{30E9}', '\u{30C3}', '\u{30C8}', '\u{3099}']),
        '\u{3333}' => Some(&['\u{30D5}', '\u{30A3}', '\u{30FC}', '\u{30C8}']),
        '\u{3334}' => Some(&['\u{30D5}', '\u{3099}', '\u{30C3}', '\u{30B7}', '\u{30A7}', '\u{30EB}']),
        '\u{3335}' => Some(&['\u{30D5}', '\u{30E9}', '\u{30F3}']),
        '\u{3336}' => Some(&['\u{30D8}', '\u{30AF}', '\u{30BF}', '\u{30FC}', '\u{30EB}']),
        '\u{3337}' => Some(&['\u{30D8}', '\u{309A}', '\u{30BD}']),
        '\u{3338}' => Some(&['\u{30D8}', '\u{309A}', '\u{30CB}', '\u{30D2}']),
        '\u{3339}' => Some(&['\u{30D8}', '\u{30EB}', '\u{30C4}']),
        '\u{333A}' => Some(&['\u{30D8}', '\u{309A}', '\u{30F3}', '\u{30B9}']),
        '\u{333B}' => Some(&['\u{30D8}', '\u{309A}', '\u{30FC}', '\u{30B7}', '\u{3099}']),
        '\u{333C}' => Some(&['\u{30D8}', '\u{3099}', '\u{30FC}', '\u{30BF}']),
        '\u{333D}' => Some(&['\u{30DB}', '\u{309A}', '\u{30A4}', '\u{30F3}', '\u{30C8}']),
        '\u{333E}' => Some(&['\u{30DB}', '\u{3099}', '\u{30EB}', '\u{30C8}']),
        '\u{333F}' => Some(&['\u{30DB}', '\u{30F3}']),
        '\u{3340}' => Some(&['\u{30DB}', '\u{309A}', '\u{30F3}', '\u{30C8}', '\u{3099}']),
        '\u{3341}' => Some(&['\u{30DB}', '\u{30FC}', '\u{30EB}']),
        '\u{3342}' => Some(&['\u{30DB}', '\u{30FC}', '\u{30F3}']),
        '\u{3343}' => Some(&['\u{30DE}', '\u{30A4}', '\u{30AF}', '\u{30ED}']),
        '\u{3344}' => Some(&['\u{30DE}', '\u{30A4}', '\u{30EB}']),
        '\u{3345}' => Some(&['\u{30DE}', '\u{30C3}', '\u{30CF}']),
        '\u{3346}' => Some(&['\u{30DE}', '\u{30EB}', '\u{30AF}']),
        '\u{3347}' => Some(&['\u{30DE}', '\u{30F3}', '\u{30B7}', '\u{30E7}', '\u{30F3}']),
        '\u{3348}' => Some(&['\u{30DF}', '\u{30AF}', '\u{30ED}', '\u{30F3}']),
        '\u{3349}' => Some(&['\u{30DF}', '\u{30EA}']),
        '\u{334A}' => Some(&['\u{30DF}', '\u{30EA}', '\u{30CF}', '\u{3099}', '\u{30FC}', '\u{30EB}']),
        '\u{334B}' => Some(&['\u{30E1}', '\u{30AB}', '\u{3099}']),
        '\u{334C}' => Some(&['\u{30E1}', '\u{30AB}', '\u{3099}', '\u{30C8}', '\u{30F3}']),
        '\u{334D}' => Some(&['\u{30E1}', '\u{30FC}', '\u{30C8}', '\u{30EB}']),
        '\u{334E}' => Some(&['\u{30E4}', '\u{30FC}', '\u{30C8}', '\u{3099}']),
        '\u{334F}' => Some(&['\u{30E4}', '\u{30FC}', '\u{30EB}']),
        '\u{3350}' => Some(&['\u{30E6}', '\u{30A2}', '\u{30F3}']),
        '\u{3351}' => Some(&['\u{30EA}', '\u{30C3}', '\u{30C8}', '\u{30EB}']),
        '\u{3352}' => Some(&['\u{30EA}', '\u{30E9}']),
        '\u{3353}' => Some(&['\u{30EB}', '\u{30D2}', '\u{309A}', '\u{30FC}']),
        '\u{3354}' => Some(&['\u{30EB}', '\u{30FC}', '\u{30D5}', '\u{3099}', '\u{30EB}']),
        '\u{3355}' => Some(&['\u{30EC}', '\u{30E0}']),
        '\u{3356}' => Some(&['\u{30EC}', '\u{30F3}', '\u{30C8}', '\u{30B1}', '\u{3099}', '\u{30F3}']),
        '\u{3357}' => Some(&['\u{30EF}', '\u{30C3}', '\u{30C8}']),
        '\u{3358}' => Some(&['\u{0030}', '\u{70B9}']),
        '\u{3359}' => Some(&['\u{0031}', '\u{70B9}']),
        '\u{335A}' => Some(&['\u{0032}', '\u{70B9}']),
        '\u{335B}' => Some(&['\u{0033}', '\u{70B9}']),
        '\u{335C}' => Some(&['\u{0034}', '\u{70B9}']),
        '\u{335D}' => Some(&['\u{0035}', '\u{70B9}']),
        '\u{335E}' => Some(&['\u{0036}', '\u{70B9}']),
        '\u{335F}' => Some(&['\u{0037}', '\u{70B9}']),
        '\u{3360}' => Some(&['\u{0038}', '\u{70B9}']),
        '\u{3361}' => Some(&['\u{0039}', '\u{70B9}']),
        '\u{3362}' => Some(&['\u{0031}', '\u{0030}', '\u{70B9}']),
        '\u{3363}' => Some(&['\u{0031}', '\u{0031}', '\u{70B9}']),
        '\u{3364}' => Some(&['\u{0031}', '\u{0032}', '\u{70B9}']),
        '\u{3365}' => Some(&['\u{0031}', '\u{0033}', '\u{70B9}']),
        '\u{3366}' => Some(&['\u{0031}', '\u{0034}', '\u{70B9}']),
        '\u{3367}' => Some(&['\u{0031}', '\u{0035}', '\u{70B9}']),
        '\u{3368}' => Some(&['\u{0031}', '\u{0036}', '\u{70B9}']),
        '\u{3369}' => Some(&['\u{0031}', '\u{0037}', '\u{70B9}']),
        '\u{336A}' => Some(&['\u{0031}', '\u{0038}', '\u{70B9}']),
        '\u{336B}' => Some(&['\u{0031}', '\u{0039}', '\u{70B9}']),
        '\u{336C}' => Some(&['\u{0032}', '\u{0030}', '\u{70B9}']),
        '\u{336D}' => Some(&['\u{0032}', '\u{0031}', '\u{70B9}']),
        '\u{336E}' => Some(&['\u{0032}', '\u{0032}', '\u{70B9}']),
        '\u{336F}' => Some(&['\u{0032}', '\u{0033}', '\u{70B9}']),
        '\u{3370}' => Some(&['\u{0032}', '\u{0034}', '\u{70B9}']),
        '\u{3371}' => Some(&['\u{0068}', '\u{0050}', '\u{0061}']),
        '\u{3372}' => Some(&['\u{0064}', '\u{0061}']),
        '\u{3373}' => Some(&['\u{0041}', '\u{0055}']),
        '\u{3374}' => Some(&['\u{0062}', '\u{0061}', '\u{0072}']),
        '\u{3375}' => Some(&['\u{006F}', '\u{0056}']),
        '\u{3376}' => Some(&['\u{0070}', '\u{0063}']),
        '\u{3377}' => Some(&['\u{0064}', '\u{006D}']),
        '\u{3378}' => Some(&['\u{0064}', '\u{006D}', '\u{0032}']),
        '\u{3379}' => Some(&['\u{0064}', '\u{006D}', '\u{0033}']),
        '\u{337A}' => Some(&['\u{0049}', '\u{0055}']),
        '\u{337B}' => Some(&['\u{5E73}', '\u{6210}']),
        '\u{337C}' => Some(&['\u{662D}', '\u{548C}']),
        '\u{337D}' => Some(&['\u{5927}', '\u{6B63}']),
        '\u{337E}' => Some(&['\u{660E}', '\u{6CBB}']),
        '\u{337F}' => Some(&['\u{682A}', '\u{5F0F}', '\u{4F1A}', '\u{793E}']),
        '\u{3380}' => Some(&['\u{0070}', '\u{0041}']),
        '\u{3381}' => Some(&['\u{006E}', '\u{0041}']),
        '\u{3382}' => Some(&['\u{03BC}', '\u{0041}']),
        '\u{3383}' => Some(&['\u{006D}', '\u{0041}']),
        '\u{3384}' => Some(&['\u{006B}', '\u{0041}']),
        '\u{3385}' => Some(&['\u{004B}', '\u{0042}']),
        '\u{3386}' => Some(&['\u{004D}', '\u{0042}']),
        '\u{3387}' => Some(&['\u{0047}', '\u{0042}']),
        '\u{3388}' => Some(&['\u{0063}', '\u{0061}', '\u{006C}']),
        '\u{3389}' => Some(&['\u{006B}', '\u{0063}', '\u{0061}', '\u{006C}']),
        '\u{338A}' => Some(&['\u{0070}', '\u{0046}']),
        '\u{338B}' => Some(&['\u{006E}', '\u{0046}']),
        '\u{338C}' => Some(&['\u{03BC}', '\u{0046}']),
        '\u{338D}' => Some(&['\u{03BC}', '\u{0067}']),
        '\u{338E}' => Some(&['\u{006D}', '\u{0067}']),
        '\u{338F}' => Some(&['\u{006B}', '\u{0067}']),
        '\u{3390}' => Some(&['\u{0048}', '\u{007A}']),
        '\u{3391}' => Some(&['\u{006B}', '\u{0048}', '\u{007A}']),
        '\u{3392}' => Some(&['\u{004D}', '\u{0048}', '\u{007A}']),
        '\u{3393}' => Some(&['\u{0047}', '\u{0048}', '\u{007A}']),
        '\u{3394}' => Some(&['\u{0054}', '\u{0048}', '\u{007A}']),
        '\u{3395}' => Some(&['\u{03BC}', '\u{006C}']),
        '\u{3396}' => Some(&['\u{006D}', '\u{006C}']),
        '\u{3397}' => Some(&['\u{0064}', '\u{006C}']),
        '\u{3398}' => Some(&['\u{006B}', '\u{006C}']),
        '\u{3399}' => Some(&['\u{0066}', '\u{006D}']),
        '\u{339A}' => Some(&['\u{006E}', '\u{006D}']),
        '\u{339B}' => Some(&['\u{03BC}', '\u{006D}']),
        '\u{339C}' => Some(&['\u{006D}', '\u{006D}']),
        '\u{339D}' => Some(&['\u{0063}', '\u{006D}']),
        '\u{339E}' => Some(&['\u{006B}', '\u{006D}']),
        '\u{339F}' => Some(&['\u{006D}', '\u{006D}', '\u{0032}']),
        '\u{33A0}' => Some(&['\u{0063}', '\u{006D}', '\u{0032}']),
        '\u{33A1}' => Some(&['\u{006D}', '\u{0032}']),
        '\u{33A2}' => Some(&['\u{006B}', '\u{006D}', '\u{0032}']),
        '\u{33A3}' => Some(&['\u{006D}', '\u{006D}', '\u{0033}']),
        '\u{33A4}' => Some(&['\u{0063}', '\u{006D}', '\u{0033}']),
        '\u{33A5}' => Some(&['\u{006D}', '\u{0033}']),
        '\u{33A6}' => Some(&['\u{006B}', '\u{006D}', '\u{0033}']),
        '\u{33A7}' => Some(&['\u{006D}', '\u{2215}', '\u{0073}']),
        '\u{33A8}' => Some(&['\u{006D}', '\u{2215}', '\u{0073}', '\u{0032}']),
        '\u{33A9}' => Some(&['\u{0050}', '\u{0061}']),
        '\u{33AA}' => Some(&['\u{006B}', '\u{0050}', '\u{0061}']),
        '\u{33AB}' => Some(&['\u{004D}', '\u{0050}', '\u{0061}']),
        '\u{33AC}' => Some(&['\u{0047}', '\u{0050}', '\u{0061}']),
        '\u{33AD}' => Some(&['\u{0072}', '\u{0061}', '\u{0064}']),
        '\u{33AE}' => Some(&['\u{0072}', '\u{0061}', '\u{0064}', '\u{2215}', '\u{0073}']),
        '\u{33AF}' => Some(&['\u{0072}', '\u{0061}', '\u{0064}', '\u{2215}', '\u{0073}', '\u{0032}']),
        '\u{33B0}' => Some(&['\u{0070}', '\u{0073}']),
        '\u{33B1}' => Some(&['\u{006E}', '\u{0073}']),
        '\u{33B2}' => Some(&['\u{03BC}', '\u{0073}']),
        '\u{33B3}' => Some(&['\u{006D}', '\u{0073}']),
        '\u{33B4}' => Some(&['\u{0070}', '\u{0056}']),
        '\u{33B5}' => Some(&['\u{006E}', '\u{0056}']),
        '\u{33B6}' => Some(&['\u{03BC}', '\u{0056}']),
        '\u{33B7}' => Some(&['\u{006D}', '\u{0056}']),
        '\u{33B8}' => Some(&['\u{006B}', '\u{0056}']),
        '\u{33B9}' => Some(&['\u{004D}', '\u{0056}']),
        '\u{33BA}' => Some(&['\u{0070}', '\u{0057}']),
        '\u{33BB}' => Some(&['\u{006E}', '\u{0057}']),
        '\u{33BC}' => Some(&['\u{03BC}', '\u{0057}']),
        '\u{33BD}' => Some(&['\u{006D}', '\u{0057}']),
        '\u{33BE}' => Some(&['\u{006B}', '\u{0057}']),
        '\u{33BF}' => Some(&['\u{004D}', '\u{0057}']),
        '\u{33C0}' => Some(&['\u{006B}', '\u{03A9}']),
        '\u{33C1}' => Some(&['\u{004D}', '\u{03A9}']),
        '\u{33C2}' => Some(&['\u{0061}', '\u{002E}', '\u{006D}', '\u{002E}']),
        '\u{33C3}' => Some(&['\u{0042}', '\u{0071}']),
        '\u{33C4}' => Some(&['\u{0063}', '\u{0063}']),
        '\u{33C5}' => Some(&['\u{0063}', '\u{0064}']),
        '\u{33C6}' => Some(&['\u{0043}', '\u{2215}', '\u{006B}', '\u{0067}']),
        '\u{33C7}' => Some(&['\u{0043}', '\u{006F}', '\u{002E}']),
        '\u{33C8}' => Some(&['\u{0064}', '\u{0042}']),
        '\u{33C9}' => Some(&['\u{0047}', '\u{0079}']),
        '\u{33CA}' => Some(&['\u{0068}', '\u{0061}']),
        '\u{33CB}' => Some(&['\u{0048}', '\u{0050}']),
        '\u{33CC}' => Some(&['\u{0069}', '\u{006E}']),
        '\u{33CD}' => Some(&['\u{004B}', '\u{004B}']),
        '\u{33CE}' => Some(&['\u{004B}', '\u{004D}']),
        '\u{33CF}' => Some(&['\u{006B}', '\u{0074}']),
        '\u{33D0}' => Some(&['\u{006C}', '\u{006D}']),
        '\u{33D1}' => Some(&['\u{006C}', '\u{006E}']),
        '\u{33D2}' => Some(&['\u{006C}', '\u{006F}', '\u{0067}']),
        '\u{33D3}' => Some(&['\u{006C}', '\u{0078}']),
        '\u{33D4}' => Some(&['\u{006D}', '\u{0062}']),
        '\u{33D5}' => Some(&['\u{006D}', '\u{0069}', '\u{006C}']),
        '\u{33D6}' => Some(&['\u{006D}', '\u{006F}', '\u{006C}']),
        '\u{33D7}' => Some(&['\u{0050}', '\u{0048}']),
        '\u{33D8}' => Some(&['\u{0070}', '\u{002E}', '\u{006D}', '\u{002E}']),
        '\u{33D9}' => Some(&['\u{0050}', '\u{0050}', '\u{004D}']),
        '\u{33DA}' => Some(&['\u{0050}', '\u{0052}']),
        '\u{33DB}' => Some(&['\u{0073}', '\u{0072}']),
        '\u{33DC}' => Some(&['\u{0053}', '\u{0076}']),
        '\u{33DD}' => Some(&['\u{0057}', '\u{0062}']),
        '\u{33DE}' => Some(&['\u{0056}', '\u{2215}', '\u{006D}']),
        '\u{33DF}' => Some(&['\u{0041}', '\u{2215}', '\u{006D}']),
        '\u{33E0}' => Some(&['\u{0031}', '\u{65E5}']),
        '\u{33E1}' => Some(&['\u{0032}', '\u{65E5}']),
        '\u{33E2}' => Some(&['\u{0033}', '\u{65E5}']),
        '\u{33E3}' => Some(&['\u{0034}', '\u{65E5}']),
        '\u{33E4}' => Some(&['\u{0035}', '\u{65E5}']),
        '\u{33E5}' => Some(&['\u{0036}', '\u{65E5}']),
        '\u{33E6}' => Some(&['\u{0037}', '\u{65E5}']),
        '\u{33E7}' => Some(&['\u{0038}', '\u{65E5}']),
        '\u{33E8}' => Some(&['\u{0039}', '\u{65E5}']),
        '\u{33E9}' => Some(&['\u{0031}', '\u{0030}', '\u{65E5}']),
        '\u{33EA}' => Some(&['\u{0031}', '\u{0031}', '\u{65E5}']),
        '\u{33EB}' => Some(&['\u{0031}', '\u{0032}', '\u{65E5}']),
        '\u{33EC}' => Some(&['\u{0031}', '\u{0033}', '\u{65E5}']),
        '\u{33ED}' => Some(&['\u{0031}', '\u{0034}', '\u{65E5}']),
        '\u{33EE}' => Some(&['\u{0031}', '\u{0035}', '\u{65E5}']),
        '\u{33EF}' => Some(&['\u{0031}', '\u{0036}', '\u{65E5}']),
        '\u{33F0}' => Some(&['\u{0031}', '\u{0037}', '\u{65E5}']),
        '\u{33F1}' => Some(&['\u{0031}', '\u{0038}', '\u{65E5}']),
        '\u{33F2}' => Some(&['\u{0031}', '\u{0039}', '\u{65E5}']),
        '\u{33F3}' => Some(&['\u{0032}', '\u{0030}', '\u{65E5}']),
        '\u{33F4}' => Some(&['\u{0032}', '\u{0031}', '\u{65E5}']),
        '\u{33F5}' => Some(&['\u{0032}', '\u{0032}', '\u{65E5}']),
        '\u{33F6}' => Some(&['\u{0032}', '\u{0033}', '\u{65E5}']),
        '\u{33F7}' => Some(&['\u{0032}', '\u{0034}', '\u{65E5}']),
        '\u{33F8}' => Some(&['\u{0032}', '\u{0035}', '\u{65E5}']),
        '\u{33F9}' => Some(&['\u{0032}', '\u{0036}', '\u{65E5}']),
        '\u{33FA}' => Some(&['\u{0032}', '\u{0037}', '\u{65E5}']),
        '\u{33FB}' => Some(&['\u{0032}', '\u{0038}', '\u{65E5}']),
        '\u{33FC}' => Some(&['\u{0032}', '\u{0039}', '\u{65E5}']),
        '\u{33FD}' => Some(&['\u{0033}', '\u{0030}', '\u{65E5}']),
        '\u{33FE}' => Some(&['\u{0033}', '\u{0031}', '\u{65E5}']),
        '\u{33FF}' => Some(&['\u{0067}', '\u{0061}', '\u{006C}']),
        '\u{A69C}' => Some(&['\u{044A}']),
        '\u{A69D}' => Some(&['\u{044C}']),
        '\u{A770}' => Some(&['\u{A76F}']),
        '\u{A7F8}' => Some(&['\u{0126}']),
        '\u{A7F9}' => Some(&['\u{0153}']),
        '\u{AB5C}' => Some(&['\u{A727}']),
        '\u{AB5D}' => Some(&['\u{AB37}']),
        '\u{AB5E}' => Some(&['\u{026B}']),
        '\u{AB5F}' => Some(&['\u{AB52}']),
        '\u{FB00}' => Some(&['\u{0066}', '\u{0066}']),
        '\u{FB01}' => Some(&['\u{0066}', '\u{0069}']),
        '\u{FB02}' => Some(&['\u{0066}', '\u{006C}']),
        '\u{FB03}' => Some(&['\u{0066}', '\u{0066}', '\u{0069}']),
        '\u{FB04}' => Some(&['\u{0066}', '\u{0066}', '\u{006C}']),
        '\u{FB05}' => Some(&['\u{0073}', '\u{0074}']),
        '\u{FB06}' => Some(&['\u{0073}', '\u{0074}']),
        '\u{FB13}' => Some(&['\u{0574}', '\u{0576}']),
        '\u{FB14}' => Some(&['\u{0574}', '\u{0565}']),
        '\u{FB15}' => Some(&['\u{0574}', '\u{056B}']),
        '\u{FB16}' => Some(&['\u{057E}', '\u{0576}']),
        '\u{FB17}' => Some(&['\u{0574}', '\u{056D}']),
        '\u{FB20}' => Some(&['\u{05E2}']),
        '\u{FB21}' => Some(&['\u{05D0}']),
        '\u{FB22}' => Some(&['\u{05D3}']),
        '\u{FB23}' => Some(&['\u{05D4}']),
        '\u{FB24}' => Some(&['\u{05DB}']),
        '\u{FB25}' => Some(&['\u{05DC}']),
        '\u{FB26}' => Some(&['\u{05DD}']),
        '\u{FB27}' => Some(&['\u{05E8}']),
        '\u{FB28}' => Some(&['\u{05EA}']),
        '\u{FB29}' => Some(&['\u{002B}']),
        '\u{FB4F}' => Some(&['\u{05D0}', '\u{05DC}']),
        '\u{FB50}' => Some(&['\u{0671}']),
        '\u{FB51}' => Some(&['\u{0671}']),
        '\u{FB52}' => Some(&['\u{067B}']),
        '\u{FB53}' => Some(&['\u{067B}']),
        '\u{FB54}' => Some(&['\u{067B}']),
        '\u{FB55}' => Some(&['\u{067B}']),
        '\u{FB56}' => Some(&['\u{067E}']),
        '\u{FB57}' => Some(&['\u{067E}']),
        '\u{FB58}' => Some(&['\u{067E}']),
        '\u{FB59}' => Some(&['\u{067E}']),
        '\u{FB5A}' => Some(&['\u{0680}']),
        '\u{FB5B}' => Some(&['\u{0680}']),
        '\u{FB5C}' => Some(&['\u{0680}']),
        '\u{FB5D}' => Some(&['\u{0680}']),
        '\u{FB5E}' => Some(&['\u{067A}']),
        '\u{FB5F}' => Some(&['\u{067A}']),
        '\u{FB60}' => Some(&['\u{067A}']),
        '\u{FB61}' => Some(&['\u{067A}']),
        '\u{FB62}' => Some(&['\u{067F}']),
        '\u{FB63}' => Some(&['\u{067F}']),
        '\u{FB64}' => Some(&['\u{067F}']),
        '\u{FB65}' => Some(&['\u{067F}']),
        '\u{FB66}' => Some(&['\u{0679}']),
        '\u{FB67}' => Some(&['\u{0679}']),
        '\u{FB68}' => Some(&['\u{0679}']),
        '\u{FB69}' => Some(&['\u{0679}']),
        '\u{FB6A}' => Some(&['\u{06A4}']),
        '\u{FB6B}' => Some(&['\u{06A4}']),
        '\u{FB6C}' => Some(&['\u{06A4}']),
        '\u{FB6D}' => Some(&['\u{06A4}']),
        '\u{FB6E}' => Some(&['\u{06A6}']),
        '\u{FB6F}' => Some(&['\u{06A6}']),
        '\u{FB70}' => Some(&['\u{06A6}']),
        '\u{FB71}' => Some(&['\u{06A6}']),
        '\u{FB72}' => Some(&['\u{0684}']),
        '\u{FB73}' => Some(&['\u{0684}']),
        '\u{FB74}' => Some(&['\u{0684}']),
        '\u{FB75}' => Some(&['\u{0684}']),
        '\u{FB76}' => Some(&['\u{0683}']),
        '\u{FB77}' => Some(&['\u{0683}']),
        '\u{FB78}' => Some(&['\u{0683}']),
        '\u{FB79}' => Some(&['\u{0683}']),
        '\u{FB7A}' => Some(&['\u{0686}']),
        '\u{FB7B}' => Some(&['\u{0686}']),
        '\u{FB7C}' => Some(&['\u{0686}']),
        '\u{FB7D}' => Some(&['\u{0686}']),
        '\u{FB7E}' => Some(&['\u{0687}']),
        '\u{FB7F}' => Some(&['\u{0687}']),
        '\u{FB80}' => Some(&['\u{0687}']),
        '\u{FB81}' => Some(&['\u{0687}']),
        '\u{FB82}' => Some(&['\u{068D}']),
        '\u{FB83}' => Some(&['\u{068D}']),
        '\u{FB84}' => Some(&['\u{068C}']),
        '\u{FB85}' => Some(&['\u{068C}']),
        '\u{FB86}' => Some(&['\u{068E}']),
        '\u{FB87}' => Some(&['\u{068E}']),
        '\u{FB88}' => Some(&['\u{0688}']),
        '\u{FB89}' => Some(&['\u{0688}']),
        '\u{FB8A}' => Some(&['\u{0698}']),
        '\u{FB8B}' => Some(&['\u{0698}']),
        '\u{FB8C}' => Some(&['\u{0691}']),
        '\u{FB8D}' => Some(&['\u{0691}']),
        '\u{FB8E}' => Some(&['\u{06A9}']),
        '\u{FB8F}' => Some(&['\u{06A9}']),
        '\u{FB90}' => Some(&['\u{06A9}']),
        '\u{FB91}' => Some(&['\u{06A9}']),
        '\u{FB92}' => Some(&['\u{06AF}']),
        '\u{FB93}' => Some(&['\u{06AF}']),
        '\u{FB94}' => Some(&['\u{06AF}']),
        '\u{FB95}' => Some(&['\u{06AF}']),
        '\u{FB96}' => Some(&['\u{06B3}']),
        '\u{FB97}' => Some(&['\u{06B3}']),
        '\u{FB98}' => Some(&['\u{06B3}']),
        '\u{FB99}' => Some(&['\u{06B3}']),
        '\u{FB9A}' => Some(&['\u{06B1}']),
        '\u{FB9B}' => Some(&['\u{06B1}']),
        '\u{FB9C}' => Some(&['\u{06B1}']),
        '\u{FB9D}' => Some(&['\u{06B1}']),
        '\u{FB9E}' => Some(&['\u{06BA}']),
        '\u{FB9F}' => Some(&['\u{06BA}']),
        '\u{FBA0}' => Some(&['\u{06BB}']),
        '\u{FBA1}' => Some(&['\u{06BB}']),
        '\u{FBA2}' => Some(&['\u{06BB}']),
        '\u{FBA3}' => Some(&['\u{06BB}']),
        '\u{FBA4}' => Some(&['\u{06D5}', '\u{0654}']),
        '\u{FBA5}' => Some(&['\u{06D5}', '\u{0654}']),
        '\u{FBA6}' => Some(&['\u{06C1}']),
        '\u{FBA7}' => Some(&['\u{06C1}']),
        '\u{FBA8}' => Some(&['\u{06C1}']),
        '\u{FBA9}' => Some(&['\u{06C1}']),
        '\u{FBAA}' => Some(&['\u{06BE}']),
        '\u{FBAB}' => Some(&['\u{06BE}']),
        '\u{FBAC}' => Some(&['\u{06BE}']),
        '\u{FBAD}' => Some(&['\u{06BE}']),
        '\u{FBAE}' => Some(&['\u{06D2}']),
        '\u{FBAF}' => Some(&['\u{06D2}']),
        '\u{FBB0}' => Some(&['\u{06D2}', '\u{0654}']),
        '\u{FBB1}' => Some(&['\u{06D2}', '\u{0654}']),
        '\u{FBD3}' => Some(&['\u{06AD}']),
        '\u{FBD4}' => Some(&['\u{06AD}']),
        '\u{FBD5}' => Some(&['\u{06AD}']),
        '\u{FBD6}' => Some(&['\u{06AD}']),
        '\u{FBD7}' => Some(&['\u{06C7}']),
        '\u{FBD8}' => Some(&['\u{06C7}']),
        '\u{FBD9}' => Some(&['\u{06C6}']),
        '\u{FBDA}' => Some(&['\u{06C6}']),
        '\u{FBDB}' => Some(&['\u{06C8}']),
        '\u{FBDC}' => Some(&['\u{06C8}']),
        '\u{FBDD}' => Some(&['\u{06C7}', '\u{0674}']),
        '\u{FBDE}' => Some(&['\u{06CB}']),
        '\u{FBDF}' => Some(&['\u{06CB}']),
        '\u{FBE0}' => Some(&['\u{06C5}']),
        '\u{FBE1}' => Some(&['\u{06C5}']),
        '\u{FBE2}' => Some(&['\u{06C9}']),
        '\u{FBE3}' => Some(&['\u{06C9}']),
        '\u{FBE4}' => Some(&['\u{06D0}']),
        '\u{FBE5}' => Some(&['\u{06D0}']),
        '\u{FBE6}' => Some(&['\u{06D0}']),
        '\u{FBE7}' => Some(&['\u{06D0}']),
        '\u{FBE8}' => Some(&['\u{0649}']),
        '\u{FBE9}' => Some(&['\u{0649}']),
        '\u{FBEA}' => Some(&['\u{064A}', '\u{0654}', '\u{0627}']),
        '\u{FBEB}' => Some(&['\u{064A}', '\u{0654}', '\u{0627}']),
        '\u{FBEC}' => Some(&['\u{064A}', '\u{0654}', '\u{06D5}']),
        '\u{FBED}' => Some(&['\u{064A}', '\u{0654}', '\u{06D5}']),
        '\u{FBEE}' => Some(&['\u{064A}', '\u{0654}', '\u{0648}']),
        '\u{FBEF}' => Some(&['\u{064A}', '\u{0654}', '\u{0648}']),
        '\u{FBF0}' => Some(&['\u{064A}', '\u{0654}', '\u{06C7}']),
        '\u{FBF1}' => Some(&['\u{064A}', '\u{0654}', '\u{06C7}']),
        '\u{FBF2}' => Some(&['\u{064A}', '\u{0654}', '\u{06C6}']),
        '\u{FBF3}' => Some(&['\u{064A}', '\u{0654}', '\u{06C6}']),
        '\u{FBF4}' => Some(&['\u{064A}', '\u{0654}', '\u{06C8}']),
        '\u{FBF5}' => Some(&['\u{064A}', '\u{0654}', '\u{06C8}']),
        '\u{FBF6}' => Some(&['\u{064A}', '\u{0654}', '\u{06D0}']),
        '\u{FBF7}' => Some(&['\u{064A}', '\u{0654}', '\u{06D0}']),
        '\u{FBF8}' => Some(&['\u{064A}', '\u{0654}', '\u{06D0}']),
        '\u{FBF9}' => Some(&['\u{064A}', '\u{0654}', '\u{0649}']),
        '\u{FBFA}' => Some(&['\u{064A}', '\u{0654}', '\u{0649}']),
        '\u{FBFB}' => Some(&['\u{064A}', '\u{0654}', '\u{0649}']),
        '\u{FBFC}' => Some(&['\u{06CC}']),
        '\u{FBFD}' => Some(&['\u{06CC}']),
        '\u{FBFE}' => Some(&['\u{06CC}']),
        '\u{FBFF}' => Some(&['\u{06CC}']),
        '\u{FC00}' => Some(&['\u{064A}', '\u{0654}', '\u{062C}']),
        '\u{FC01}' => Some(&['\u{064A}', '\u{0654}', '\u{062D}']),
        '\u{FC02}' => Some(&['\u{064A}', '\u{0654}', '\u{0645}']),
        '\u{FC03}' => Some(&['\u{064A}', '\u{0654}', '\u{0649}']),
        '\u{FC04}' => Some(&['\u{064A}', '\u{0654}', '\u{064A}']),
        '\u{FC05}' => Some(&['\u{0628}', '\u{062C}']),
        '\u{FC06}' => Some(&['\u{0628}', '\u{062D}']),
        '\u{FC07}' => Some(&['\u{0628}', '\u{062E}']),
        '\u{FC08}' => Some(&['\u{0628}', '\u{0645}']),
        '\u{FC09}' => Some(&['\u{0628}', '\u{0649}']),
        '\u{FC0A}' => Some(&['\u{0628}', '\u{064A}']),
        '\u{FC0B}' => Some(&['\u{062A}', '\u{062C}']),
        '\u{FC0C}' => Some(&['\u{062A}', '\u{062D}']),
        '\u{FC0D}' => Some(&['\u{062A}', '\u{062E}']),
        '\u{FC0E}' => Some(&['\u{062A}', '\u{0645}']),
        '\u{FC0F}' => Some(&['\u{062A}', '\u{0649}']),
        '\u{FC10}' => Some(&['\u{062A}', '\u{064A}']),
        '\u{FC11}' => Some(&['\u{062B}', '\u{062C}']),
        '\u{FC12}' => Some(&['\u{062B}', '\u{0645}']),
        '\u{FC13}' => Some(&['\u{062B}', '\u{0649}']),
        '\u{FC14}' => Some(&['\u{062B}', '\u{064A}']),
        '\u{FC15}' => Some(&['\u{062C}', '\u{062D}']),
        '\u{FC16}' => Some(&['\u{062C}', '\u{0645}']),
        '\u{FC17}' => Some(&['\u{062D}', '\u{062C}']),
        '\u{FC18}' => Some(&['\u{062D}', '\u{0645}']),
        '\u{FC19}' => Some(&['\u{062E}', '\u{062C}']),
        '\u{FC1A}' => Some(&['\u{062E}', '\u{062D}']),
        '\u{FC1B}' => Some(&['\u{062E}', '\u{0645}']),
        '\u{FC1C}' => Some(&['\u{0633}', '\u{062C}']),
        '\u{FC1D}' => Some(&['\u{0633}', '\u{062D}']),
        '\u{FC1E}' => Some(&['\u{0633}', '\u{062E}']),
        '\u{FC1F}' => Some(&['\u{0633}', '\u{0645}']),
        '\u{FC20}' => Some(&['\u{0635}', '\u{062D}']),
        '\u{FC21}' => Some(&['\u{0635}', '\u{0645}']),
        '\u{FC22}' => Some(&['\u{0636}', '\u{062C}']),
        '\u{FC23}' => Some(&['\u{0636}', '\u{062D}']),
        '\u{FC24}' => Some(&['\u{0636}', '\u{062E}']),
        '\u{FC25}' => Some(&['\u{0636}', '\u{0645}']),
        '\u{FC26}' => Some(&['\u{0637}', '\u{062D}']),
        '\u{FC27}' => Some(&['\u{0637}', '\u{0645}']),
        '\u{FC28}' => Some(&['\u{0638}', '\u{0645}']),
        '\u{FC29}' => Some(&['\u{0639}', '\u{062C}']),
        '\u{FC2A}' => Some(&['\u{0639}', '\u{0645}']),
        '\u{FC2B}' => Some(&['\u{063A}', '\u{062C}']),
        '\u{FC2C}' => Some(&['\u{063A}', '\u{0645}']),
        '\u{FC2D}' => Some(&['\u{0641}', '\u{062C}']),
        '\u{FC2E}' => Some(&['\u{0641}', '\u{062D}']),
        '\u{FC2F}' => Some(&['\u{0641}', '\u{062E}']),
        '\u{FC30}' => Some(&['\u{0641}', '\u{0645}']),
        '\u{FC31}' => Some(&['\u{0641}', '\u{0649}']),
        '\u{FC32}' => Some(&['\u{0641}', '\u{064A}']),
        '\u{FC33}' => Some(&['\u{0642}', '\u{062D}']),
        '\u{FC34}' => Some(&['\u{0642}', '\u{0645}']),
        '\u{FC35}' => Some(&['\u{0642}', '\u{0649}']),
        '\u{FC36}' => Some(&['\u{0642}', '\u{064A}']),
        '\u{FC37}' => Some(&['\u{0643}', '\u{0627}']),
        '\u{FC38}' => Some(&['\u{0643}', '\u{062C}']),
        '\u{FC39}' => Some(&['\u{0643}', '\u{062D}']),
        '\u{FC3A}' => Some(&['\u{0643}', '\u{062E}']),
        '\u{FC3B}' => Some(&['\u{0643}', '\u{0644}']),
        '\u{FC3C}' => Some(&['\u{0643}', '\u{0645}']),
        '\u{FC3D}' => Some(&['\u{0643}', '\u{0649}']),
        '\u{FC3E}' => Some(&['\u{0643}', '\u{064A}']),
        '\u{FC3F}' => Some(&['\u{0644}', '\u{062C}']),
        '\u{FC40}' => Some(&['\u{0644}', '\u{062D}']),
        '\u{FC41}' => Some(&['\u{0644}', '\u{062E}']),
        '\u{FC42}' => Some(&['\u{0644}', '\u{0645}']),
        '\u{FC43}' => Some(&['\u{0644}', '\u{0649}']),
        '\u{FC44}' => Some(&['\u{0644}', '\u{064A}']),
        '\u{FC45}' => Some(&['\u{0645}', '\u{062C}']),
        '\u{FC46}' => Some(&['\u{0645}', '\u{062D}']),
        '\u{FC47}' => Some(&['\u{0645}', '\u{062E}']),
        '\u{FC48}' => Some(&['\u{0645}', '\u{0645}']),
        '\u{FC49}' => Some(&['\u{0645}', '\u{0649}']),
        '\u{FC4A}' => Some(&['\u{0645}', '\u{064A}']),
        '\u{FC4B}' => Some(&['\u{0646}', '\u{062C}']),
        '\u{FC4C}' => Some(&['\u{0646}', '\u{062D}']),
        '\u{FC4D}' => Some(&['\u{0646}', '\u{062E}']),
        '\u{FC4E}' => Some(&['\u{0646}', '\u{0645}']),
        '\u{FC4F}' => Some(&['\u{0646}', '\u{0649}']),
        '\u{FC50}' => Some(&['\u{0646}', '\u{064A}']),
        '\u{FC51}' => Some(&['\u{0647}', '\u{062C}']),
        '\u{FC52}' => Some(&['\u{0647}', '\u{0645}']),
        '\u{FC53}' => Some(&['\u{0647}', '\u{0649}']),
        '\u{FC54}' => Some(&['\u{0647}', '\u{064A}']),
        '\u{FC55}' => Some(&['\u{064A}', '\u{062C}']),
        '\u{FC56}' => Some(&['\u{064A}', '\u{062D}']),
        '\u{FC57}' => Some(&['\u{064A}', '\u{062E}']),
        '\u{FC58}' => Some(&['\u{064A}', '\u{0645}']),
        '\u{FC59}' => Some(&['\u{064A}', '\u{0649}']),
        '\u{FC5A}' => Some(&['\u{064A}', '\u{064A}']),
        '\u{FC5B}' => Some(&['\u{0630}', '\u{0670}']),
        '\u{FC5C}' => Some(&['\u{0631}', '\u{0670}']),
        '\u{FC5D}' => Some(&['\u{0649}', '\u{0670}']),
        '\u{FC5E}' => Some(&['\u{0020}', '\u{064C}', '\u{0651}']),
        '\u{FC5F}' => Some(&['\u{0020}', '\u{064D}', '\u{0651}']),
        '\u{FC60}' => Some(&['\u{0020}', '\u{064E}', '\u{0651}']),
        '\u{FC61}' => Some(&['\u{0020}', '\u{064F}', '\u{0651}']),
        '\u{FC62}' => Some(&['\u{0020}', '\u{0650}', '\u{0651}']),
        '\u{FC63}' => Some(&['\u{0020}', '\u{0651}', '\u{0670}']),
        '\u{FC64}' => Some(&['\u{064A}', '\u{0654}', '\u{0631}']),
        '\u{FC65}' => Some(&['\u{064A}', '\u{0654}', '\u{0632}']),
        '\u{FC66}' => Some(&['\u{064A}', '\u{0654}', '\u{0645}']),
        '\u{FC67}' => Some(&['\u{064A}', '\u{0654}', '\u{0646}']),
        '\u{FC68}' => Some(&['\u{064A}', '\u{0654}', '\u{0649}']),
        '\u{FC69}' => Some(&['\u{064A}', '\u{0654}', '\u{064A}']),
        '\u{FC6A}' => Some(&['\u{0628}', '\u{0631}']),
        '\u{FC6B}' => Some(&['\u{0628}', '\u{0632}']),
        '\u{FC6C}' => Some(&['\u{0628}', '\u{0645}']),
        '\u{FC6D}' => Some(&['\u{0628}', '\u{0646}']),
        '\u{FC6E}' => Some(&['\u{0628}', '\u{0649}']),
        '\u{FC6F}' => Some(&['\u{0628}', '\u{064A}']),
        '\u{FC70}' => Some(&['\u{062A}', '\u{0631}']),
        '\u{FC71}' => Some(&['\u{062A}', '\u{0632}']),
        '\u{FC72}' => Some(&['\u{062A}', '\u{0645}']),
        '\u{FC73}' => Some(&['\u{062A}', '\u{0646}']),
        '\u{FC74}' => Some(&['\u{062A}', '\u{0649}']),
        '\u{FC75}' => Some(&['\u{062A}', '\u{064A}']),
        '\u{FC76}' => Some(&['\u{062B}', '\u{0631}']),
        '\u{FC77}' => Some(&['\u{062B}', '\u{0632}']),
        '\u{FC78}' => Some(&['\u{062B}', '\u{0645}']),
        '\u{FC79}' => Some(&['\u{062B}', '\u{0646}']),
        '\u{FC7A}' => Some(&['\u{062B}', '\u{0649}']),
        '\u{FC7B}' => Some(&['\u{062B}', '\u{064A}']),
        '\u{FC7C}' => Some(&['\u{0641}', '\u{0649}']),
        '\u{FC7D}' => Some(&['\u{0641}', '\u{064A}']),
        '\u{FC7E}' => Some(&['\u{0642}', '\u{0649}']),
        '\u{FC7F}' => Some(&['\u{0642}', '\u{064A}']),
        '\u{FC80}' => Some(&['\u{0643}', '\u{0627}']),
        '\u{FC81}' => Some(&['\u{0643}', '\u{0644}']),
        '\u{FC82}' => Some(&['\u{0643}', '\u{0645}']),
        '\u{FC83}' => Some(&['\u{0643}', '\u{0649}']),
        '\u{FC84}' => Some(&['\u{0643}', '\u{064A}']),
        '\u{FC85}' => Some(&['\u{0644}', '\u{0645}']),
        '\u{FC86}' => Some(&['\u{0644}', '\u{0649}']),
        '\u{FC87}' => Some(&['\u{0644}', '\u{064A}']),
        '\u{FC88}' => Some(&['\u{0645}', '\u{0627}']),
        '\u{FC89}' => Some(&['\u{0645}', '\u{0645}']),
        '\u{FC8A}' => Some(&['\u{0646}', '\u{0631}']),
        '\u{FC8B}' => Some(&['\u{0646}', '\u{0632}']),
        '\u{FC8C}' => Some(&['\u{0646}', '\u{0645}']),
        '\u{FC8D}' => Some(&['\u{0646}', '\u{0646}']),
        '\u{FC8E}' => Some(&['\u{0646}', '\u{0649}']),
        '\u{FC8F}' => Some(&['\u{0646}', '\u{064A}']),
        '\u{FC90}' => Some(&['\u{0649}', '\u{0670}']),
        '\u{FC91}' => Some(&['\u{064A}', '\u{0631}']),
        '\u{FC92}' => Some(&['\u{064A}', '\u{0632}']),
        '\u{FC93}' => Some(&['\u{064A}', '\u{0645}']),
        '\u{FC94}' => Some(&['\u{064A}', '\u{0646}']),
        '\u{FC95}' => Some(&['\u{064A}', '\u{0649}']),
        '\u{FC96}' => Some(&['\u{064A}', '\u{064A}']),
        '\u{FC97}' => Some(&['\u{064A}', '\u{0654}', '\u{062C}']),
        '\u{FC98}' => Some(&['\u{064A}', '\u{0654}', '\u{062D}']),
        '\u{FC99}' => Some(&['\u{064A}', '\u{0654}', '\u{062E}']),
        '\u{FC9A}' => Some(&['\u{064A}', '\u{0654}', '\u{0645}']),
        '\u{FC9B}' => Some(&['\u{064A}', '\u{0654}', '\u{0647}']),
        '\u{FC9C}' => Some(&['\u{0628}', '\u{062C}']),
        '\u{FC9D}' => Some(&['\u{0628}', '\u{062D}']),
        '\u{FC9E}' => Some(&['\u{0628}', '\u{062E}']),
        '\u{FC9F}' => Some(&['\u{0628}', '\u{0645}']),
        '\u{FCA0}' => Some(&['\u{0628}', '\u{0647}']),
        '\u{FCA1}' => Some(&['\u{062A}', '\u{062C}']),
        '\u{FCA2}' => Some(&['\u{062A}', '\u{062D}']),
        '\u{FCA3}' => Some(&['\u{062A}', '\u{062E}']),
        '\u{FCA4}' => Some(&['\u{062A}', '\u{0645}']),
        '\u{FCA5}' => Some(&['\u{062A}', '\u{0647}']),
        '\u{FCA6}' => Some(&['\u{062B}', '\u{0645}']),
        '\u{FCA7}' => Some(&['\u{062C}', '\u{062D}']),
        '\u{FCA8}' => Some(&['\u{062C}', '\u{0645}']),
        '\u{FCA9}' => Some(&['\u{062D}', '\u{062C}']),
        '\u{FCAA}' => Some(&['\u{062D}', '\u{0645}']),
        '\u{FCAB}' => Some(&['\u{062E}', '\u{062C}']),
        '\u{FCAC}' => Some(&['\u{062E}', '\u{0645}']),
        '\u{FCAD}' => Some(&['\u{0633}', '\u{062C}']),
        '\u{FCAE}' => Some(&['\u{0633}', '\u{062D}']),
        '\u{FCAF}' => Some(&['\u{0633}', '\u{062E}']),
        '\u{FCB0}' => Some(&['\u{0633}', '\u{0645}']),
        '\u{FCB1}' => Some(&['\u{0635}', '\u{062D}']),
        '\u{FCB2}' => Some(&['\u{0635}', '\u{062E}']),
        '\u{FCB3}' => Some(&['\u{0635}', '\u{0645}']),
        '\u{FCB4}' => Some(&['\u{0636}', '\u{062C}']),
        '\u{FCB5}' => Some(&['\u{0636}', '\u{062D}']),
        '\u{FCB6}' => Some(&['\u{0636}', '\u{062E}']),
        '\u{FCB7}' => Some(&['\u{0636}', '\u{0645}']),
        '\u{FCB8}' => Some(&['\u{0637}', '\u{062D}']),
        '\u{FCB9}' => Some(&['\u{0638}', '\u{0645}']),
        '\u{FCBA}' => Some(&['\u{0639}', '\u{062C}']),
        '\u{FCBB}' => Some(&['\u{0639}', '\u{0645}']),
        '\u{FCBC}' => Some(&['\u{063A}', '\u{062C}']),
        '\u{FCBD}' => Some(&['\u{063A}', '\u{0645}']),
        '\u{FCBE}' => Some(&['\u{0641}', '\u{062C}']),
        '\u{FCBF}' => Some(&['\u{0641}', '\u{062D}']),
        '\u{FCC0}' => Some(&['\u{0641}', '\u{062E}']),
        '\u{FCC1}' => Some(&['\u{0641}', '\u{0645}']),
        '\u{FCC2}' => Some(&['\u{0642}', '\u{062D}']),
        '\u{FCC3}' => Some(&['\u{0642}', '\u{0645}']),
        '\u{FCC4}' => Some(&['\u{0643}', '\u{062C}']),
        '\u{FCC5}' => Some(&['\u{0643}', '\u{062D}']),
        '\u{FCC6}' => Some(&['\u{0643}', '\u{062E}']),
        '\u{FCC7}' => Some(&['\u{0643}', '\u{0644}']),
        '\u{FCC8}' => Some(&['\u{0643}', '\u{0645}']),
        '\u{FCC9}' => Some(&['\u{0644}', '\u{062C}']),
        '\u{FCCA}' => Some(&['\u{0644}', '\u{062D}']),
        '\u{FCCB}' => Some(&['\u{0644}', '\u{062E}']),
        '\u{FCCC}' => Some(&['\u{0644}', '\u{0645}']),
        '\u{FCCD}' => Some(&['\u{0644}', '\u{0647}']),
        '\u{FCCE}' => Some(&['\u{0645}', '\u{062C}']),
        '\u{FCCF}' => Some(&['\u{0645}', '\u{062D}']),
        '\u{FCD0}' => Some(&['\u{0645}', '\u{062E}']),
        '\u{FCD1}' => Some(&['\u{0645}', '\u{0645}']),
        '\u{FCD2}' => Some(&['\u{0646}', '\u{062C}']),
        '\u{FCD3}' => Some(&['\u{0646}', '\u{062D}']),
        '\u{FCD4}' => Some(&['\u{0646}', '\u{062E}']),
        '\u{FCD5}' => Some(&['\u{0646}', '\u{0645}']),
        '\u{FCD6}' => Some(&['\u{0646}', '\u{0647}']),
        '\u{FCD7}' => Some(&['\u{0647}', '\u{062C}']),
        '\u{FCD8}' => Some(&['\u{0647}', '\u{0645}']),
        '\u{FCD9}' => Some(&['\u{0647}', '\u{0670}']),
        '\u{FCDA}' => Some(&['\u{064A}', '\u{062C}']),
        '\u{FCDB}' => Some(&['\u{064A}', '\u{062D}']),
        '\u{FCDC}' => Some(&['\u{064A}', '\u{062E}']),
        '\u{FCDD}' => Some(&['\u{064A}', '\u{0645}']),
        '\u{FCDE}' => Some(&['\u{064A}', '\u{0647}']),
        '\u{FCDF}' => Some(&['\u{064A}', '\u{0654}', '\u{0645}']),
        '\u{FCE0}' => Some(&['\u{064A}', '\u{0654}', '\u{0647}']),
        '\u{FCE1}' => Some(&['\u{0628}', '\u{0645}']),
        '\u{FCE2}' => Some(&['\u{0628}', '\u{0647}']),
        '\u{FCE3}' => Some(&['\u{062A}', '\u{0645}']),
        '\u{FCE4}' => Some(&['\u{062A}', '\u{0647}']),
        '\u{FCE5}' => Some(&['\u{062B}', '\u{0645}']),
        '\u{FCE6}' => Some(&['\u{062B}', '\u{0647}']),
        '\u{FCE7}' => Some(&['\u{0633}', '\u{0645}']),
        '\u{FCE8}' => Some(&['\u{0633}', '\u{0647}']),
        '\u{FCE9}' => Some(&['\u{0634}', '\u{0645}']),
        '\u{FCEA}' => Some(&['\u{0634}', '\u{0647}']),
        '\u{FCEB}' => Some(&['\u{0643}', '\u{0644}']),
        '\u{FCEC}' => Some(&['\u{0643}', '\u{0645}']),
        '\u{FCED}' => Some(&['\u{0644}', '\u{0645}']),
        '\u{FCEE}' => Some(&['\u{0646}', '\u{0645}']),
        '\u{FCEF}' => Some(&['\u{0646}', '\u{0647}']),
        '\u{FCF0}' => Some(&['\u{064A}', '\u{0645}']),
        '\u{FCF1}' => Some(&['\u{064A}', '\u{0647}']),
        '\u{FCF2}' => Some(&['\u{0640}', '\u{064E}', '\u{0651}']),
        '\u{FCF3}' => Some(&['\u{0640}', '\u{064F}', '\u{0651}']),
        '\u{FCF4}' => Some(&['\u{0640}', '\u{0650}', '\u{0651}']),
        '\u{FCF5}' => Some(&['\u{0637}', '\u{0649}']),
        '\u{FCF6}' => Some(&['\u{0637}', '\u{064A}']),
        '\u{FCF7}' => Some(&['\u{0639}', '\u{0649}']),
        '\u{FCF8}' => Some(&['\u{0639}', '\u{064A}']),
        '\u{FCF9}' => Some(&['\u{063A}', '\u{0649}']),
        '\u{FCFA}' => Some(&['\u{063A}', '\u{064A}']),
        '\u{FCFB}' => Some(&['\u{0633}', '\u{0649}']),
        '\u{FCFC}' => Some(&['\u{0633}', '\u{064A}']),
        '\u{FCFD}' => Some(&['\u{0634}', '\u{0649}']),
        '\u{FCFE}' => Some(&['\u{0634}', '\u{064A}']),
        '\u{FCFF}' => Some(&['\u{062D}', '\u{0649}']),
        '\u{FD00}' => Some(&['\u{062D}', '\u{064A}']),
        '\u{FD01}' => Some(&['\u{062C}', '\u{0649}']),
        '\u{FD02}' => Some(&['\u{062C}', '\u{064A}']),
        '\u{FD03}' => Some(&['\u{062E}', '\u{0649}']),
        '\u{FD04}' => Some(&['\u{062E}', '\u{064A}']),
        '\u{FD05}' => Some(&['\u{0635}', '\u{0649}']),
        '\u{FD06}' => Some(&['\u{0635}', '\u{064A}']),
        '\u{FD07}' => Some(&['\u{0636}', '\u{0649}']),
        '\u{FD08}' => Some(&['\u{0636}', '\u{064A}']),
        '\u{FD09}' => Some(&['\u{0634}', '\u{062C}']),
        '\u{FD0A}' => Some(&['\u{0634}', '\u{062D}']),
        '\u{FD0B}' => Some(&['\u{0634}', '\u{062E}']),
        '\u{FD0C}' => Some(&['\u{0634}', '\u{0645}']),
        '\u{FD0D}' => Some(&['\u{0634}', '\u{0631}']),
        '\u{FD0E}' => Some(&['\u{0633}', '\u{0631}']),
        '\u{FD0F}' => Some(&['\u{0635}', '\u{0631}']),
        '\u{FD10}' => Some(&['\u{0636}', '\u{0631}']),
        '\u{FD11}' => Some(&['\u{0637}', '\u{0649}']),
        '\u{FD12}' => Some(&['\u{0637}', '\u{064A}']),
        '\u{FD13}' => Some(&['\u{0639}', '\u{0649}']),
        '\u{FD14}' => Some(&['\u{0639}', '\u{064A}']),
        '\u{FD15}' => Some(&['\u{063A}', '\u{0649}']),
        '\u{FD16}' => Some(&['\u{063A}', '\u{064A}']),
        '\u{FD17}' => Some(&['\u{0633}', '\u{0649}']),
        '\u{FD18}' => Some(&['\u{0633}', '\u{064A}']),
        '\u{FD19}' => Some(&['\u{0634}', '\u{0649}']),
        '\u{FD1A}' => Some(&['\u{0634}', '\u{064A}']),
        '\u{FD1B}' => Some(&['\u{062D}', '\u{0649}']),
        '\u{FD1C}' => Some(&['\u{062D}', '\u{064A}']),
        '\u{FD1D}' => Some(&['\u{062C}', '\u{0649}']),
        '\u{FD1E}' => Some(&['\u{062C}', '\u{064A}']),
        '\u{FD1F}' => Some(&['\u{062E}', '\u{0649}']),
        '\u{FD20}' => Some(&['\u{062E}', '\u{064A}']),
        '\u{FD21}' => Some(&['\u{0635}', '\u{0649}']),
        '\u{FD22}' => Some(&['\u{0635}', '\u{064A}']),
        '\u{FD23}' => Some(&['\u{0636}', '\u{0649}']),
        '\u{FD24}' => Some(&['\u{0636}', '\u{064A}']),
        '\u{FD25}' => Some(&['\u{0634}', '\u{062C}']),
        '\u{FD26}' => Some(&['\u{0634}', '\u{062D}']),
        '\u{FD27}' => Some(&['\u{0634}', '\u{062E}']),
        '\u{FD28}' => Some(&['\u{0634}', '\u{0645}']),
        '\u{FD29}' => Some(&['\u{0634}', '\u{0631}']),
        '\u{FD2A}' => Some(&['\u{0633}', '\u{0631}']),
        '\u{FD2B}' => Some(&['\u{0635}', '\u{0631}']),
        '\u{FD2C}' => Some(&['\u{0636}', '\u{0631}']),
        '\u{FD2D}' => Some(&['\u{0634}', '\u{062C}']),
        '\u{FD2E}' => Some(&['\u{0634}', '\u{062D}']),
        '\u{FD2F}' => Some(&['\u{0634}', '\u{062E}']),
        '\u{FD30}' => Some(&['\u{0634}', '\u{0645}']),
        '\u{FD31}' => Some(&['\u{0633}', '\u{0647}']),
        '\u{FD32}' => Some(&['\u{0634}', '\u{0647}']),
        '\u{FD33}' => Some(&['\u{0637}', '\u{0645}']),
        '\u{FD34}' => Some(&['\u{0633}', '\u{062C}']),
        '\u{FD35}' => Some(&['\u{0633}', '\u{062D}']),
        '\u{FD36}' => Some(&['\u{0633}', '\u{062E}']),
        '\u{FD37}' => Some(&['\u{0634}', '\u{062C}']),
        '\u{FD38}' => Some(&['\u{0634}', '\u{062D}']),
        '\u{FD39}' => Some(&['\u{0634}', '\u{062E}']),
        '\u{FD3A}' => Some(&['\u{0637}', '\u{0645}']),
        '\u{FD3B}' => Some(&['\u{0638}', '\u{0645}']),
        '\u{FD3C}' => Some(&['\u{0627}', '\u{064B}']),
        '\u{FD3D}' => Some(&['\u{0627}', '\u{064B}']),
        '\u{FD50}' => Some(&['\u{062A}', '\u{062C}', '\u{0645}']),
        '\u{FD51}' => Some(&['\u{062A}', '\u{062D}', '\u{062C}']),
        '\u{FD52}' => Some(&['\u{062A}', '\u{062D}', '\u{062C}']),
        '\u{FD53}' => Some(&['\u{062A}', '\u{062D}', '\u{0645}']),
        '\u{FD54}' => Some(&['\u{062A}', '\u{062E}', '\u{0645}']),
        '\u{FD55}' => Some(&['\u{062A}', '\u{0645}', '\u{062C}']),
        '\u{FD56}' => Some(&['\u{062A}', '\u{0645}', '\u{062D}']),
        '\u{FD57}' => Some(&['\u{062A}', '\u{0645}', '\u{062E}']),
        '\u{FD58}' => Some(&['\u{062C}', '\u{0645}', '\u{062D}']),
        '\u{FD59}' => Some(&['\u{062C}', '\u{0645}', '\u{062D}']),
        '\u{FD5A}' => Some(&['\u{062D}', '\u{0645}', '\u{064A}']),
        '\u{FD5B}' => Some(&['\u{062D}', '\u{0645}', '\u{0649}']),
        '\u{FD5C}' => Some(&['\u{0633}', '\u{062D}', '\u{062C}']),
        '\u{FD5D}' => Some(&['\u{0633}', '\u{062C}', '\u{062D}']),
        '\u{FD5E}' => Some(&['\u{0633}', '\u{062C}', '\u{0649}']),
        '\u{FD5F}' => Some(&['\u{0633}', '\u{0645}', '\u{062D}']),
        '\u{FD60}' => Some(&['\u{0633}', '\u{0645}', '\u{062D}']),
        '\u{FD61}' => Some(&['\u{0633}', '\u{0645}', '\u{062C}']),
        '\u{FD62}' => Some(&['\u{0633}', '\u{0645}', '\u{0645}']),
        '\u{FD63}' => Some(&['\u{0633}', '\u{0645}', '\u{0645}']),
        '\u{FD64}' => Some(&['\u{0635}', '\u{062D}', '\u{062D}']),
        '\u{FD65}' => Some(&['\u{0635}', '\u{062D}', '\u{062D}']),
        '\u{FD66}' => Some(&['\u{0635}', '\u{0645}', '\u{0645}']),
        '\u{FD67}' => Some(&['\u{0634}', '\u{062D}', '\u{0645}']),
        '\u{FD68}' => Some(&['\u{0634}', '\u{062D}', '\u{0645}']),
        '\u{FD69}' => Some(&['\u{0634}', '\u{062C}', '\u{064A}']),
        '\u{FD6A}' => Some(&['\u{0634}', '\u{0645}', '\u{062E}']),
        '\u{FD6B}' => Some(&['\u{0634}', '\u{0645}', '\u{062E}']),
        '\u{FD6C}' => Some(&['\u{0634}', '\u{0645}', '\u{0645}']),
        '\u{FD6D}' => Some(&['\u{0634}', '\u{0645}', '\u{0645}']),
        '\u{FD6E}' => Some(&['\u{0636}', '\u{062D}', '\u{0649}']),
        '\u{FD6F}' => Some(&['\u{0636}', '\u{062E}', '\u{0645}']),
        '\u{FD70}' => Some(&['\u{0636}', '\u{062E}', '\u{0645}']),
        '\u{FD71}' => Some(&['\u{0637}', '\u{0645}', '\u{062D}']),
        '\u{FD72}' => Some(&['\u{0637}', '\u{0645}', '\u{062D}']),
        '\u{FD73}' => Some(&['\u{0637}', '\u{0645}', '\u{0645}']),
        '\u{FD74}' => Some(&['\u{0637}', '\u{0645}', '\u{064A}']),
        '\u{FD75}' => Some(&['\u{0639}', '\u{062C}', '\u{0645}']),
        '\u{FD76}' => Some(&['\u{0639}', '\u{0645}', '\u{0645}']),
        '\u{FD77}' => Some(&['\u{0639}', '\u{0645}', '\u{0645}']),
        '\u{FD78}' => Some(&['\u{0639}', '\u{0645}', '\u{0649}']),
        '\u{FD79}' => Some(&['\u{063A}', '\u{0645}', '\u{0645}']),
        '\u{FD7A}' => Some(&['\u{063A}', '\u{0645}', '\u{064A}']),
        '\u{FD7B}' => Some(&['\u{063A}', '\u{0645}', '\u{0649}']),
        '\u{FD7C}' => Some(&['\u{0641}', '\u{062E}', '\u{0645}']),
        '\u{FD7D}' => Some(&['\u{0641}', '\u{062E}', '\u{0645}']),
        '\u{FD7E}' => Some(&['\u{0642}', '\u{0645}', '\u{062D}']),
        '\u{FD7F}' => Some(&['\u{0642}', '\u{0645}', '\u{0645}']),
        '\u{FD80}' => Some(&['\u{0644}', '\u{062D}', '\u{0645}']),
        '\u{FD81}' => Some(&['\u{0644}', '\u{062D}', '\u{064A}']),
        '\u{FD82}' => Some(&['\u{0644}', '\u{062D}', '\u{0649}']),
        '\u{FD83}' => Some(&['\u{0644}', '\u{062C}', '\u{062C}']),
        '\u{FD84}' => Some(&['\u{0644}', '\u{062C}', '\u{062C}']),
        '\u{FD85}' => Some(&['\u{0644}', '\u{062E}', '\u{0645}']),
        '\u{FD86}' => Some(&['\u{0644}', '\u{062E}', '\u{0645}']),
        '\u{FD87}' => Some(&['\u{0644}', '\u{0645}', '\u{062D}']),
        '\u{FD88}' => Some(&['\u{0644}', '\u{0645}', '\u{062D}']),
        '\u{FD89}' => Some(&['\u{0645}', '\u{062D}', '\u{062C}']),
        '\u{FD8A}' => Some(&['\u{0645}', '\u{062D}', '\u{0645}']),
        '\u{FD8B}' => Some(&['\u{0645}', '\u{062D}', '\u{064A}']),
        '\u{FD8C}' => Some(&['\u{0645}', '\u{062C}', '\u{062D}']),
        '\u{FD8D}' => Some(&['\u{0645}', '\u{062C}', '\u{0645}']),
        '\u{FD8E}' => Some(&['\u{0645}', '\u{062E}', '\u{062C}']),
        '\u{FD8F}' => Some(&['\u{0645}', '\u{062E}', '\u{0645}']),
        '\u{FD92}' => Some(&['\u{0645}', '\u{062C}', '\u{062E}']),
        '\u{FD93}' => Some(&['\u{0647}', '\u{0645}', '\u{062C}']),
        '\u{FD94}' => Some(&['\u{0647}', '\u{0645}', '\u{0645}']),
        '\u{FD95}' => Some(&['\u{0646}', '\u{062D}', '\u{0645}']),
        '\u{FD96}' => Some(&['\u{0646}', '\u{062D}', '\u{0649}']),
        '\u{FD97}' => Some(&['\u{0646}', '\u{062C}', '\u{0645}']),
        '\u{FD98}' => Some(&['\u{0646}', '\u{062C}', '\u{0645}']),
        '\u{FD99}' => Some(&['\u{0646}', '\u{062C}', '\u{0649}']),
        '\u{FD9A}' => Some(&['\u{0646}', '\u{0645}', '\u{064A}']),
        '\u{FD9B}' => Some(&['\u{0646}', '\u{0645}', '\u{0649}']),
        '\u{FD9C}' => Some(&['\u{064A}', '\u{0645}', '\u{0645}']),
        '\u{FD9D}' => Some(&['\u{064A}', '\u{0645}', '\u{0645}']),
        '\u{FD9E}' => Some(&['\u{0628}', '\u{062E}', '\u{064A}']),
        '\u{FD9F}' => Some(&['\u{062A}', '\u{062C}', '\u{064A}']),
        '\u{FDA0}' => Some(&['\u{062A}', '\u{062C}', '\u{0649}']),
        '\u{FDA1}' => Some(&['\u{062A}', '\u{062E}', '\u{064A}']),
        '\u{FDA2}' => Some(&['\u{062A}', '\u{062E}', '\u{0649}']),
        '\u{FDA3}' => Some(&['\u{062A}', '\u{0645}', '\u{064A}']),
        '\u{FDA4}' => Some(&['\u{062A}', '\u{0645}', '\u{0649}']),
        '\u{FDA5}' => Some(&['\u{062C}', '\u{0645}', '\u{064A}']),
        '\u{FDA6}' => Some(&['\u{062C}', '\u{062D}', '\u{0649}']),
        '\u{FDA7}' => Some(&['\u{062C}', '\u{0645}', '\u{0649}']),
        '\u{FDA8}' => Some(&['\u{0633}', '\u{062E}', '\u{0649}']),
        '\u{FDA9}' => Some(&['\u{0635}', '\u{062D}', '\u{064A}']),
        '\u{FDAA}' => Some(&['\u{0634}', '\u{062D}', '\u{064A}']),
        '\u{FDAB}' => Some(&['\u{0636}', '\u{062D}', '\u{064A}']),
        '\u{FDAC}' => Some(&['\u{0644}', '\u{062C}', '\u{064A}']),
        '\u{FDAD}' => Some(&['\u{0644}', '\u{0645}', '\u{064A}']),
        '\u{FDAE}' => Some(&['\u{064A}', '\u{062D}', '\u{064A}']),
        '\u{FDAF}' => Some(&['\u{064A}', '\u{062C}', '\u{064A}']),
        '\u{FDB0}' => Some(&['\u{064A}', '\u{0645}', '\u{064A}']),
        '\u{FDB1}' => Some(&['\u{0645}', '\u{0645}', '\u{064A}']),
        '\u{FDB2}' => Some(&['\u{0642}', '\u{0645}', '\u{064A}']),
        '\u{FDB3}' => Some(&['\u{0646}', '\u{062D}', '\u{064A}']),
        '\u{FDB4}' => Some(&['\u{0642}', '\u{0645}', '\u{062D}']),
        '\u{FDB5}' => Some(&['\u{0644}', '\u{062D}', '\u{0645}']),
        '\u{FDB6}' => Some(&['\u{0639}', '\u{0645}', '\u{064A}']),
        '\u{FDB7}' => Some(&['\u{0643}', '\u{0645}', '\u{064A}']),
        '\u{FDB8}' => Some(&['\u{0646}', '\u{062C}', '\u{062D}']),
        '\u{FDB9}' => Some(&['\u{0645}', '\u{062E}', '\u{064A}']),
        '\u{FDBA}' => Some(&['\u{0644}', '\u{062C}', '\u{0645}']),
        '\u{FDBB}' => Some(&['\u{0643}', '\u{0645}', '\u{0645}']),
        '\u{FDBC}' => Some(&['\u{0644}', '\u{062C}', '\u{0645}']),
        '\u{FDBD}' => Some(&['\u{0646}', '\u{062C}', '\u{062D}']),
        '\u{FDBE}' => Some(&['\u{062C}', '\u{062D}', '\u{064A}']),
        '\u{FDBF}' => Some(&['\u{062D}', '\u{062C}', '\u{064A}']),
        '\u{FDC0}' => Some(&['\u{0645}', '\u{062C}', '\u{064A}']),
        '\u{FDC1}' => Some(&['\u{0641}', '\u{0645}', '\u{064A}']),
        '\u{FDC2}' => Some(&['\u{0628}', '\u{062D}', '\u{064A}']),
        '\u{FDC3}' => Some(&['\u{0643}', '\u{0645}', '\u{0645}']),
        '\u{FDC4}' => Some(&['\u{0639}', '\u{062C}', '\u{0645}']),
        '\u{FDC5}' => Some(&['\u{0635}', '\u{0645}', '\u{0645}']),
        '\u{FDC6}' => Some(&['\u{0633}', '\u{062E}', '\u{064A}']),
        '\u{FDC7}' => Some(&['\u{0646}', '\u{062C}', '\u{064A}']),
        '\u{FDF0}' => Some(&['\u{0635}', '\u{0644}', '\u{06D2}']),
        '\u{FDF1}' => Some(&['\u{0642}', '\u{0644}', '\u{06D2}']),
        '\u{FDF2}' => Some(&['\u{0627}', '\u{0644}', '\u{0644}', '\u{0647}']),
        '\u{FDF3}' => Some(&['\u{0627}', '\u{0643}', '\u{0628}', '\u{0631}']),
        '\u{FDF4}' => Some(&['\u{0645}', '\u{062D}', '\u{0645}', '\u{062F}']),
        '\u{FDF5}' => Some(&['\u{0635}', '\u{0644}', '\u{0639}', '\u{0645}']),
        '\u{FDF6}' => Some(&['\u{0631}', '\u{0633}', '\u{0648}', '\u{0644}']),
        '\u{FDF7}' => Some(&['\u{0639}', '\u{0644}', '\u{064A}', '\u{0647}']),
        '\u{FDF8}' => Some(&['\u{0648}', '\u{0633}', '\u{0644}', '\u{0645}']),
        '\u{FDF9}' => Some(&['\u{0635}', '\u{0644}', '\u{0649}']),
        '\u{FDFA}' => Some(&['\u{0635}', '\u{0644}', '\u{0649}', '\u{0020}', '\u{0627}', '\u{0644}', '\u{0644}', '\u{0647}', '\u{0020}', '\u{0639}', '\u{0644}', '\u{064A}', '\u{0647}', '\u{0020}', '\u{0648}', '\u{0633}', '\u{0644}', '\u{0645}']),
        '\u{FDFB}' => Some(&['\u{062C}', '\u{0644}', '\u{0020}', '\u{062C}', '\u{0644}', '\u{0627}', '\u{0644}', '\u{0647}']),
        '\u{FDFC}' => Some(&['\u{0631}', '\u{06CC}', '\u{0627}', '\u{0644}']),
        '\u{FE10}' => Some(&['\u{002C}']),
        '\u{FE11}' => Some(&['\u{3001}']),
        '\u{FE12}' => Some(&['\u{3002}']),
        '\u{FE13}' => Some(&['\u{003A}']),
        '\u{FE14}' => Some(&['\u{003B}']),
        '\u{FE15}' => Some(&['\u{0021}']),
        '\u{FE16}' => Some(&['\u{003F}']),
        '\u{FE17}' => Some(&['\u{3016}']),
        '\u{FE18}' => Some(&['\u{3017}']),
        '\u{FE19}' => Some(&['\u{002E}', '\u{002E}', '\u{002E}']),
        '\u{FE30}' => Some(&['\u{002E}', '\u{002E}']),
        '\u{FE31}' => Some(&['\u{2014}']),
        '\u{FE32}' => Some(&['\u{2013}']),
        '\u{FE33}' => Some(&['\u{005F}']),
        '\u{FE34}' => Some(&['\u{005F}']),
        '\u{FE35}' => Some(&['\u{0028}']),
        '\u{FE36}' => Some(&['\u{0029}']),
        '\u{FE37}' => Some(&['\u{007B}']),
        '\u{FE38}' => Some(&['\u{007D}']),
        '\u{FE39}' => Some(&['\u{3014}']),
        '\u{FE3A}' => Some(&['\u{3015}']),
        '\u{FE3B}' => Some(&['\u{3010}']),
        '\u{FE3C}' => Some(&['\u{3011}']),
        '\u{FE3D}' => Some(&['\u{300A}']),
        '\u{FE3E}' => Some(&['\u{300B}']),
        '\u{FE3F}' => Some(&['\u{3008}']),
        '\u{FE40}' => Some(&['\u{3009}']),
        '\u{FE41}' => Some(&['\u{300C}']),
        '\u{FE42}' => Some(&['\u{300D}']),
        '\u{FE43}' => Some(&['\u{300E}']),
        '\u{FE44}' => Some(&['\u{300F}']),
        '\u{FE47}' => Some(&['\u{005B}']),
        '\u{FE48}' => Some(&['\u{005D}']),
        '\u{FE49}' => Some(&['\u{0020}', '\u{0305}']),
        '\u{FE4A}' => Some(&['\u{0020}', '\u{0305}']),
        '\u{FE4B}' => Some(&['\u{0020}', '\u{0305}']),
        '\u{FE4C}' => Some(&['\u{0020}', '\u{0305}']),
        '\u{FE4D}' => Some(&['\u{005F}']),
        '\u{FE4E}' => Some(&['\u{005F}']),
        '\u{FE4F}' => Some(&['\u{005F}']),
        '\u{FE50}' => Some(&['\u{002C}']),
        '\u{FE51}' => Some(&['\u{3001}']),
        '\u{FE52}' => Some(&['\u{002E}']),
        '\u{FE54}' => Some(&['\u{003B}']),
        '\u{FE55}' => Some(&['\u{003A}']),
        '\u{FE56}' => Some(&['\u{003F}']),
        '\u{FE57}' => Some(&['\u{0021}']),
        '\u{FE58}' => Some(&['\u{2014}']),
        '\u{FE59}' => Some(&['\u{0028}']),
        '\u{FE5A}' => Some(&['\u{0029}']),
        '\u{FE5B}' => Some(&['\u{007B}']),
        '\u{FE5C}' => Some(&['\u{007D}']),
        '\u{FE5D}' => Some(&['\u{3014}']),
        '\u{FE5E}' => Some(&['\u{3015}']),
        '\u{FE5F}' => Some(&['\u{0023}']),
        '\u{FE60}' => Some(&['\u{0026}']),
        '\u{FE61}' => Some(&['\u{002A}']),
        '\u{FE62}' => Some(&['\u{002B}']),
        '\u{FE63}' => Some(&['\u{002D}']),
        '\u{FE64}' => Some(&['\u{003C}']),
        '\u{FE65}' => Some(&['\u{003E}']),
        '\u{FE66}' => Some(&['\u{003D}']),
        '\u{FE68}' => Some(&['\u{005C}']),
        '\u{FE69}' => Some(&['\u{0024}']),
        '\u{FE6A}' => Some(&['\u{0025}']),
        '\u{FE6B}' => Some(&['\u{0040}']),
        '\u{FE70}' => Some(&['\u{0020}', '\u{064B}']),
        '\u{FE71}' => Some(&['\u{0640}', '\u{064B}']),
        '\u{FE72}' => Some(&['\u{0020}', '\u{064C}']),
        '\u{FE74}' => Some(&['\u{0020}', '\u{064D}']),
        '\u{FE76}' => Some(&['\u{0020}', '\u{064E}']),
        '\u{FE77}' => Some(&['\u{0640}', '\u{064E}']),
        '\u{FE78}' => Some(&['\u{0020}', '\u{064F}']),
        '\u{FE79}' => Some(&['\u{0640}', '\u{064F}']),
        '\u{FE7A}' => Some(&['\u{0020}', '\u{0650}']),
        '\u{FE7B}' => Some(&['\u{0640}', '\u{0650}']),
        '\u{FE7C}' => Some(&['\u{0020}', '\u{0651}']),
        '\u{FE7D}' => Some(&['\u{0640}', '\u{0651}']),
        '\u{FE7E}' => Some(&['\u{0020}', '\u{0652}']),
        '\u{FE7F}' => Some(&['\u{0640}', '\u{0652}']),
        '\u{FE80}' => Some(&['\u{0621}']),
        '\u{FE81}' => Some(&['\u{0627}', '\u{0653}']),
        '\u{FE82}' => Some(&['\u{0627}', '\u{0653}']),
        '\u{FE83}' => Some(&['\u{0627}', '\u{0654}']),
        '\u{FE84}' => Some(&['\u{0627}', '\u{0654}']),
        '\u{FE85}' => Some(&['\u{0648}', '\u{0654}']),
        '\u{FE86}' => Some(&['\u{0648}', '\u{0654}']),
        '\u{FE87}' => Some(&['\u{0627}', '\u{0655}']),
        '\u{FE88}' => Some(&['\u{0627}', '\u{0655}']),
        '\u{FE89}' => Some(&['\u{064A}', '\u{0654}']),
        '\u{FE8A}' => Some(&['\u{064A}', '\u{0654}']),
        '\u{FE8B}' => Some(&['\u{064A}', '\u{0654}']),
        '\u{FE8C}' => Some(&['\u{064A}', '\u{0654}']),
        '\u{FE8D}' => Some(&['\u{0627}']),
        '\u{FE8E}' => Some(&['\u{0627}']),
        '\u{FE8F}' => Some(&['\u{0628}']),
        '\u{FE90}' => Some(&['\u{0628}']),
        '\u{FE91}' => Some(&['\u{0628}']),
        '\u{FE92}' => Some(&['\u{0628}']),
        '\u{FE93}' => Some(&['\u{0629}']),
        '\u{FE94}' => Some(&['\u{0629}']),
        '\u{FE95}' => Some(&['\u{062A}']),
        '\u{FE96}' => Some(&['\u{062A}']),
        '\u{FE97}' => Some(&['\u{062A}']),
        '\u{FE98}' => Some(&['\u{062A}']),
        '\u{FE99}' => Some(&['\u{062B}']),
        '\u{FE9A}' => Some(&['\u{062B}']),
        '\u{FE9B}' => Some(&['\u{062B}']),
        '\u{FE9C}' => Some(&['\u{062B}']),
        '\u{FE9D}' => Some(&['\u{062C}']),
        '\u{FE9E}' => Some(&['\u{062C}']),
        '\u{FE9F}' => Some(&['\u{062C}']),
        '\u{FEA0}' => Some(&['\u{062C}']),
        '\u{FEA1}' => Some(&['\u{062D}']),
        '\u{FEA2}' => Some(&['\u{062D}']),
        '\u{FEA3}' => Some(&['\u{062D}']),
        '\u{FEA4}' => Some(&['\u{062D}']),
        '\u{FEA5}' => Some(&['\u{062E}']),
        '\u{FEA6}' => Some(&['\u{062E}']),
        '\u{FEA7}' => Some(&['\u{062E}']),
        '\u{FEA8}' => Some(&['\u{062E}']),
        '\u{FEA9}' => Some(&['\u{062F}']),
        '\u{FEAA}' => Some(&['\u{062F}']),
        '\u{FEAB}' => Some(&['\u{0630}']),
        '\u{FEAC}' => Some(&['\u{0630}']),
        '\u{FEAD}' => Some(&['\u{0631}']),
        '\u{FEAE}' => Some(&['\u{0631}']),
        '\u{FEAF}' => Some(&['\u{0632}']),
        '\u{FEB0}' => Some(&['\u{0632}']),
        '\u{FEB1}' => Some(&['\u{0633}']),
        '\u{FEB2}' => Some(&['\u{0633}']),
        '\u{FEB3}' => Some(&['\u{0633}']),
        '\u{FEB4}' => Some(&['\u{0633}']),
        '\u{FEB5}' => Some(&['\u{0634}']),
        '\u{FEB6}' => Some(&['\u{0634}']),
        '\u{FEB7}' => Some(&['\u{0634}']),
        '\u{FEB8}' => Some(&['\u{0634}']),
        '\u{FEB9}' => Some(&['\u{0635}']),
        '\u{FEBA}' => Some(&['\u{0635}']),
        '\u{FEBB}' => Some(&['\u{0635}']),
        '\u{FEBC}' => Some(&['\u{0635}']),
        '\u{FEBD}' => Some(&['\u{0636}']),
        '\u{FEBE}' => Some(&['\u{0636}']),
        '\u{FEBF}' => Some(&['\u{0636}']),
        '\u{FEC0}' => Some(&['\u{0636}']),
        '\u{FEC1}' => Some(&['\u{0637}']),
        '\u{FEC2}' => Some(&['\u{0637}']),
        '\u{FEC3}' => Some(&['\u{0637}']),
        '\u{FEC4}' => Some(&['\u{0637}']),
        '\u{FEC5}' => Some(&['\u{0638}']),
        '\u{FEC6}' => Some(&['\u{0638}']),
        '\u{FEC7}' => Some(&['\u{0638}']),
        '\u{FEC8}' => Some(&['\u{0638}']),
        '\u{FEC9}' => Some(&['\u{0639}']),
        '\u{FECA}' => Some(&['\u{0639}']),
        '\u{FECB}' => Some(&['\u{0639}']),
        '\u{FECC}' => Some(&['\u{0639}']),
        '\u{FECD}' => Some(&['\u{063A}']),
        '\u{FECE}' => Some(&['\u{063A}']),
        '\u{FECF}' => Some(&['\u{063A}']),
        '\u{FED0}' => Some(&['\u{063A}']),
        '\u{FED1}' => Some(&['\u{0641}']),
        '\u{FED2}' => Some(&['\u{0641}']),
        '\u{FED3}' => Some(&['\u{0641}']),
        '\u{FED4}' => Some(&['\u{0641}']),
        '\u{FED5}' => Some(&['\u{0642}']),
        '\u{FED6}' => Some(&['\u{0642}']),
        '\u{FED7}' => Some(&['\u{0642}']),
        '\u{FED8}' => Some(&['\u{0642}']),
        '\u{FED9}' => Some(&['\u{0643}']),
        '\u{FEDA}' => Some(&['\u{0643}']),
        '\u{FEDB}' => Some(&['\u{0643}']),
        '\u{FEDC}' => Some(&['\u{0643}']),
        '\u{FEDD}' => Some(&['\u{0644}']),
        '\u{FEDE}' => Some(&['\u{0644}']),
        '\u{FEDF}' => Some(&['\u{0644}']),
        '\u{FEE0}' => Some(&['\u{0644}']),
        '\u{FEE1}' => Some(&['\u{0645}']),
        '\u{FEE2}' => Some(&['\u{0645}']),
        '\u{FEE3}' => Some(&['\u{0645}']),
        '\u{FEE4}' => Some(&['\u{0645}']),
        '\u{FEE5}' => Some(&['\u{0646}']),
        '\u{FEE6}' => Some(&['\u{0646}']),
        '\u{FEE7}' => Some(&['\u{0646}']),
        '\u{FEE8}' => Some(&['\u{0646}']),
        '\u{FEE9}' => Some(&['\u{0647}']),
        '\u{FEEA}' => Some(&['\u{0647}']),
        '\u{FEEB}' => Some(&['\u{0647}']),
        '\u{FEEC}' => Some(&['\u{0647}']),
        '\u{FEED}' => Some(&['\u{0648}']),
        '\u{FEEE}' => Some(&['\u{0648}']),
        '\u{FEEF}' => Some(&['\u{0649}']),
        '\u{FEF0}' => Some(&['\u{0649}']),
        '\u{FEF1}' => Some(&['\u{064A}']),
        '\u{FEF2}' => Some(&['\u{064A}']),
        '\u{FEF3}' => Some(&['\u{064A}']),
        '\u{FEF4}' => Some(&['\u{064A}']),
        '\u{FEF5}' => Some(&['\u{0644}', '\u{0627}', '\u{0653}']),
        '\u{FEF6}' => Some(&['\u{0644}', '\u{0627}', '\u{0653}']),
        '\u{FEF7}' => Some(&['\u{0644}', '\u{0627}', '\u{0654}']),
        '\u{FEF8}' => Some(&['\u{0644}', '\u{0627}', '\u{0654}']),
        '\u{FEF9}' => Some(&['\u{0644}', '\u{0627}', '\u{0655}']),
        '\u{FEFA}' => Some(&['\u{0644}', '\u{0627}', '\u{0655}']),
        '\u{FEFB}' => Some(&['\u{0644}', '\u{0627}']),
        '\u{FEFC}' => Some(&['\u{0644}', '\u{0627}']),
        '\u{FF01}' => Some(&['\u{0021}']),
        '\u{FF02}' => Some(&['\u{0022}']),
        '\u{FF03}' => Some(&['\u{0023}']),
        '\u{FF04}' => Some(&['\u{0024}']),
        '\u{FF05}' => Some(&['\u{0025}']),
        '\u{FF06}' => Some(&['\u{0026}']),
        '\u{FF07}' => Some(&['\u{0027}']),
        '\u{FF08}' => Some(&['\u{0028}']),
        '\u{FF09}' => Some(&['\u{0029}']),
        '\u{FF0A}' => Some(&['\u{002A}']),
        '\u{FF0B}' => Some(&['\u{002B}']),
        '\u{FF0C}' => Some(&['\u{002C}']),
        '\u{FF0D}' => Some(&['\u{002D}']),
        '\u{FF0E}' => Some(&['\u{002E}']),
        '\u{FF0F}' => Some(&['\u{002F}']),
        '\u{FF10}' => Some(&['\u{0030}']),
        '\u{FF11}' => Some(&['\u{0031}']),
        '\u{FF12}' => Some(&['\u{0032}']),
        '\u{FF13}' => Some(&['\u{0033}']),
        '\u{FF14}' => Some(&['\u{0034}']),
        '\u{FF15}' => Some(&['\u{0035}']),
        '\u{FF16}' => Some(&['\u{0036}']),
        '\u{FF17}' => Some(&['\u{0037}']),
        '\u{FF18}' => Some(&['\u{0038}']),
        '\u{FF19}' => Some(&['\u{0039}']),
        '\u{FF1A}' => Some(&['\u{003A}']),
        '\u{FF1B}' => Some(&['\u{003B}']),
        '\u{FF1C}' => Some(&['\u{003C}']),
        '\u{FF1D}' => Some(&['\u{003D}']),
        '\u{FF1E}' => Some(&['\u{003E}']),
        '\u{FF1F}' => Some(&['\u{003F}']),
        '\u{FF20}' => Some(&['\u{0040}']),
        '\u{FF21}' => Some(&['\u{0041}']),
        '\u{FF22}' => Some(&['\u{0042}']),
        '\u{FF23}' => Some(&['\u{0043}']),
        '\u{FF24}' => Some(&['\u{0044}']),
        '\u{FF25}' => Some(&['\u{0045}']),
        '\u{FF26}' => Some(&['\u{0046}']),
        '\u{FF27}' => Some(&['\u{0047}']),
        '\u{FF28}' => Some(&['\u{0048}']),
        '\u{FF29}' => Some(&['\u{0049}']),
        '\u{FF2A}' => Some(&['\u{004A}']),
        '\u{FF2B}' => Some(&['\u{004B}']),
        '\u{FF2C}' => Some(&['\u{004C}']),
        '\u{FF2D}' => Some(&['\u{004D}']),
        '\u{FF2E}' => Some(&['\u{004E}']),
        '\u{FF2F}' => Some(&['\u{004F}']),
        '\u{FF30}' => Some(&['\u{0050}']),
        '\u{FF31}' => Some(&['\u{0051}']),
        '\u{FF32}' => Some(&['\u{0052}']),
        '\u{FF33}' => Some(&['\u{0053}']),
        '\u{FF34}' => Some(&['\u{0054}']),
        '\u{FF35}' => Some(&['\u{0055}']),
        '\u{FF36}' => Some(&['\u{0056}']),
        '\u{FF37}' => Some(&['\u{0057}']),
        '\u{FF38}' => Some(&['\u{0058}']),
        '\u{FF39}' => Some(&['\u{0059}']),
        '\u{FF3A}' => Some(&['\u{005A}']),
        '\u{FF3B}' => Some(&['\u{005B}']),
        '\u{FF3C}' => Some(&['\u{005C}']),
        '\u{FF3D}' => Some(&['\u{005D}']),
        '\u{FF3E}' => Some(&['\u{005E}']),
        '\u{FF3F}' => Some(&['\u{005F}']),
        '\u{FF40}' => Some(&['\u{0060}']),
        '\u{FF41}' => Some(&['\u{0061}']),
        '\u{FF42}' => Some(&['\u{0062}']),
        '\u{FF43}' => Some(&['\u{0063}']),
        '\u{FF44}' => Some(&['\u{0064}']),
        '\u{FF45}' => Some(&['\u{0065}']),
        '\u{FF46}' => Some(&['\u{0066}']),
        '\u{FF47}' => Some(&['\u{0067}']),
        '\u{FF48}' => Some(&['\u{0068}']),
        '\u{FF49}' => Some(&['\u{0069}']),
        '\u{FF4A}' => Some(&['\u{006A}']),
        '\u{FF4B}' => Some(&['\u{006B}']),
        '\u{FF4C}' => Some(&['\u{006C}']),
        '\u{FF4D}' => Some(&['\u{006D}']),
        '\u{FF4E}' => Some(&['\u{006E}']),
        '\u{FF4F}' => Some(&['\u{006F}']),
        '\u{FF50}' => Some(&['\u{0070}']),
        '\u{FF51}' => Some(&['\u{0071}']),
        '\u{FF52}' => Some(&['\u{0072}']),
        '\u{FF53}' => Some(&['\u{0073}']),
        '\u{FF54}' => Some(&['\u{0074}']),
        '\u{FF55}' => Some(&['\u{0075}']),
        '\u{FF56}' => Some(&['\u{0076}']),
        '\u{FF57}' => Some(&['\u{0077}']),
        '\u{FF58}' => Some(&['\u{0078}']),
        '\u{FF59}' => Some(&['\u{0079}']),
        '\u{FF5A}' => Some(&['\u{007A}']),
        '\u{FF5B}' => Some(&['\u{007B}']),
        '\u{FF5C}' => Some(&['\u{007C}']),
        '\u{FF5D}' => Some(&['\u{007D}']),
        '\u{FF5E}' => Some(&['\u{007E}']),
        '\u{FF5F}' => Some(&['\u{2985}']),
        '\u{FF60}' => Some(&['\u{2986}']),
        '\u{FF61}' => Some(&['\u{3002}']),
        '\u{FF62}' => Some(&['\u{300C}']),
        '\u{FF63}' => Some(&['\u{300D}']),
        '\u{FF64}' => Some(&['\u{3001}']),
        '\u{FF65}' => Some(&['\u{30FB}']),
        '\u{FF66}' => Some(&['\u{30F2}']),
        '\u{FF67}' => Some(&['\u{30A1}']),
        '\u{FF68}' => Some(&['\u{30A3}']),
        '\u{FF69}' => Some(&['\u{30A5}']),
        '\u{FF6A}' => Some(&['\u{30A7}']),
        '\u{FF6B}' => Some(&['\u{30A9}']),
        '\u{FF6C}' => Some(&['\u{30E3}']),
        '\u{FF6D}' => Some(&['\u{30E5}']),
        '\u{FF6E}' => Some(&['\u{30E7}']),
        '\u{FF6F}' => Some(&['\u{30C3}']),
        '\u{FF70}' => Some(&['\u{30FC}']),
        '\u{FF71}' => Some(&['\u{30A2}']),
        '\u{FF72}' => Some(&['\u{30A4}']),
        '\u{FF73}' => Some(&['\u{30A6}']),
        '\u{FF74}' => Some(&['\u{30A8}']),
        '\u{FF75}' => Some(&['\u{30AA}']),
        '\u{FF76}' => Some(&['\u{30AB}']),
        '\u{FF77}' => Some(&['\u{30AD}']),
        '\u{FF78}' => Some(&['\u{30AF}']),
        '\u{FF79}' => Some(&['\u{30B1}']),
        '\u{FF7A}' => Some(&['\u{30B3}']),
        '\u{FF7B}' => Some(&['\u{30B5}']),
        '\u{FF7C}' => Some(&['\u{30B7}']),
        '\u{FF7D}' => Some(&['\u{30B9}']),
        '\u{FF7E}' => Some(&['\u{30BB}']),
        '\u{FF7F}' => Some(&['\u{30BD}']),
        '\u{FF80}' => Some(&['\u{30BF}']),
        '\u{FF81}' => Some(&['\u{30C1}']),
        '\u{FF82}' => Some(&['\u{30C4}']),
        '\u{FF83}' => Some(&['\u{30C6}']),
        '\u{FF84}' => Some(&['\u{30C8}']),
        '\u{FF85}' => Some(&['\u{30CA}']),
        '\u{FF86}' => Some(&['\u{30CB}']),
        '\u{FF87}' => Some(&['\u{30CC}']),
        '\u{FF88}' => Some(&['\u{30CD}']),
        '\u{FF89}' => Some(&['\u{30CE}']),
        '\u{FF8A}' => Some(&['\u{30CF}']),
        '\u{FF8B}' => Some(&['\u{30D2}']),
        '\u{FF8C}' => Some(&['\u{30D5}']),
        '\u{FF8D}' => Some(&['\u{30D8}']),
        '\u{FF8E}' => Some(&['\u{30DB}']),
        '\u{FF8F}' => Some(&['\u{30DE}']),
        '\u{FF90}' => Some(&['\u{30DF}']),
        '\u{FF91}' => Some(&['\u{30E0}']),
        '\u{FF92}' => Some(&['\u{30E1}']),
        '\u{FF93}' => Some(&['\u{30E2}']),
        '\u{FF94}' => Some(&['\u{30E4}']),
        '\u{FF95}' => Some(&['\u{30E6}']),
        '\u{FF96}' => Some(&['\u{30E8}']),
        '\u{FF97}' => Some(&['\u{30E9}']),
        '\u{FF98}' => Some(&['\u{30EA}']),
        '\u{FF99}' => Some(&['\u{30EB}']),
        '\u{FF9A}' => Some(&['\u{30EC}']),
        '\u{FF9B}' => Some(&['\u{30ED}']),
        '\u{FF9C}' => Some(&['\u{30EF}']),
        '\u{FF9D}' => Some(&['\u{30F3}']),
        '\u{FF9E}' => Some(&['\u{3099}']),
        '\u{FF9F}' => Some(&['\u{309A}']),
        '\u{FFA0}' => Some(&['\u{1160}']),
        '\u{FFA1}' => Some(&['\u{1100}']),
        '\u{FFA2}' => Some(&['\u{1101}']),
        '\u{FFA3}' => Some(&['\u{11AA}']),
        '\u{FFA4}' => Some(&['\u{1102}']),
        '\u{FFA5}' => Some(&['\u{11AC}']),
        '\u{FFA6}' => Some(&['\u{11AD}']),
        '\u{FFA7}' => Some(&['\u{1103}']),
        '\u{FFA8}' => Some(&['\u{1104}']),
        '\u{FFA9}' => Some(&['\u{1105}']),
        '\u{FFAA}' => Some(&['\u{11B0}']),
        '\u{FFAB}' => Some(&['\u{11B1}']),
        '\u{FFAC}' => Some(&['\u{11B2}']),
        '\u{FFAD}' => Some(&['\u{11B3}']),
        '\u{FFAE}' => Some(&['\u{11B4}']),
        '\u{FFAF}' => Some(&['\u{11B5}']),
        '\u{FFB0}' => Some(&['\u{111A}']),
        '\u{FFB1}' => Some(&['\u{1106}']),
        '\u{FFB2}' => Some(&['\u{1107}']),
        '\u{FFB3}' => Some(&['\u{1108}']),
        '\u{FFB4}' => Some(&['\u{1121}']),
        '\u{FFB5}' => Some(&['\u{1109}']),
        '\u{FFB6}' => Some(&['\u{110A}']),
        '\u{FFB7}' => Some(&['\u{110B}']),
        '\u{FFB8}' => Some(&['\u{110C}']),
        '\u{FFB9}' => Some(&['\u{110D}']),
        '\u{FFBA}' => Some(&['\u{110E}']),
        '\u{FFBB}' => Some(&['\u{110F}']),
        '\u{FFBC}' => Some(&['\u{1110}']),
        '\u{FFBD}' => Some(&['\u{1111}']),
        '\u{FFBE}' => Some(&['\u{1112}']),
        '\u{FFC2}' => Some(&['\u{1161}']),
        '\u{FFC3}' => Some(&['\u{1162}']),
        '\u{FFC4}' => Some(&['\u{1163}']),
        '\u{FFC5}' => Some(&['\u{1164}']),
        '\u{FFC6}' => Some(&['\u{1165}']),
        '\u{FFC7}' => Some(&['\u{1166}']),
        '\u{FFCA}' => Some(&['\u{1167}']),
        '\u{FFCB}' => Some(&['\u{1168}']),
        '\u{FFCC}' => Some(&['\u{1169}']),
        '\u{FFCD}' => Some(&['\u{116A}']),
        '\u{FFCE}' => Some(&['\u{116B}']),
        '\u{FFCF}' => Some(&['\u{116C}']),
        '\u{FFD2}' => Some(&['\u{116D}']),
        '\u{FFD3}' => Some(&['\u{116E}']),
        '\u{FFD4}' => Some(&['\u{116F}']),
        '\u{FFD5}' => Some(&['\u{1170}']),
        '\u{FFD6}' => Some(&['\u{1171}']),
        '\u{FFD7}' => Some(&['\u{1172}']),
        '\u{FFDA}' => Some(&['\u{1173}']),
        '\u{FFDB}' => Some(&['\u{1174}']),
        '\u{FFDC}' => Some(&['\u{1175}']),
        '\u{FFE0}' => Some(&['\u{00A2}']),
        '\u{FFE1}' => Some(&['\u{00A3}']),
        '\u{FFE2}' => Some(&['\u{00AC}']),
        '\u{FFE3}' => Some(&['\u{0020}', '\u{0304}']),
        '\u{FFE4}' => Some(&['\u{00A6}']),
        '\u{FFE5}' => Some(&['\u{00A5}']),
        '\u{FFE6}' => Some(&['\u{20A9}']),
        '\u{FFE8}' => Some(&['\u{2502}']),
        '\u{FFE9}' => Some(&['\u{2190}']),
        '\u{FFEA}' => Some(&['\u{2191}']),
        '\u{FFEB}' => Some(&['\u{2192}']),
        '\u{FFEC}' => Some(&['\u{2193}']),
        '\u{FFED}' => Some(&['\u{25A0}']),
        '\u{FFEE}' => Some(&['\u{25CB}']),
        '\u{1D400}' => Some(&['\u{0041}']),
        '\u{1D401}' => Some(&['\u{0042}']),
        '\u{1D402}' => Some(&['\u{0043}']),
        '\u{1D403}' => Some(&['\u{0044}']),
        '\u{1D404}' => Some(&['\u{0045}']),
        '\u{1D405}' => Some(&['\u{0046}']),
        '\u{1D406}' => Some(&['\u{0047}']),
        '\u{1D407}' => Some(&['\u{0048}']),
        '\u{1D408}' => Some(&['\u{0049}']),
        '\u{1D409}' => Some(&['\u{004A}']),
        '\u{1D40A}' => Some(&['\u{004B}']),
        '\u{1D40B}' => Some(&['\u{004C}']),
        '\u{1D40C}' => Some(&['\u{004D}']),
        '\u{1D40D}' => Some(&['\u{004E}']),
        '\u{1D40E}' => Some(&['\u{004F}']),
        '\u{1D40F}' => Some(&['\u{0050}']),
        '\u{1D410}' => Some(&['\u{0051}']),
        '\u{1D411}' => Some(&['\u{0052}']),
        '\u{1D412}' => Some(&['\u{0053}']),
        '\u{1D413}' => Some(&['\u{0054}']),
        '\u{1D414}' => Some(&['\u{0055}']),
        '\u{1D415}' => Some(&['\u{0056}']),
        '\u{1D416}' => Some(&['\u{0057}']),
        '\u{1D417}' => Some(&['\u{0058}']),
        '\u{1D418}' => Some(&['\u{0059}']),
        '\u{1D419}' => Some(&['\u{005A}']),
        '\u{1D41A}' => Some(&['\u{0061}']),
        '\u{1D41B}' => Some(&['\u{0062}']),
        '\u{1D41C}' => Some(&['\u{0063}']),
        '\u{1D41D}' => Some(&['\u{0064}']),
        '\u{1D41E}' => Some(&['\u{0065}']),
        '\u{1D41F}' => Some(&['\u{0066}']),
        '\u{1D420}' => Some(&['\u{0067}']),
        '\u{1D421}' => Some(&['\u{0068}']),
        '\u{1D422}' => Some(&['\u{0069}']),
        '\u{1D423}' => Some(&['\u{006A}']),
        '\u{1D424}' => Some(&['\u{006B}']),
        '\u{1D425}' => Some(&['\u{006C}']),
        '\u{1D426}' => Some(&['\u{006D}']),
        '\u{1D427}' => Some(&['\u{006E}']),
        '\u{1D428}' => Some(&['\u{006F}']),
        '\u{1D429}' => Some(&['\u{0070}']),
        '\u{1D42A}' => Some(&['\u{0071}']),
        '\u{1D42B}' => Some(&['\u{0072}']),
        '\u{1D42C}' => Some(&['\u{0073}']),
        '\u{1D42D}' => Some(&['\u{0074}']),
        '\u{1D42E}' => Some(&['\u{0075}']),
        '\u{1D42F}' => Some(&['\u{0076}']),
        '\u{1D430}' => Some(&['\u{0077}']),
        '\u{1D431}' => Some(&['\u{0078}']),
        '\u{1D432}' => Some(&['\u{0079}']),
        '\u{1D433}' => Some(&['\u{007A}']),
        '\u{1D434}' => Some(&['\u{0041}']),
        '\u{1D435}' => Some(&['\u{0042}']),
        '\u{1D436}' => Some(&['\u{0043}']),
        '\u{1D437}' => Some(&['\u{0044}']),
        '\u{1D438}' => Some(&['\u{0045}']),
        '\u{1D439}' => Some(&['\u{0046}']),
        '\u{1D43A}' => Some(&['\u{0047}']),
        '\u{1D43B}' => Some(&['\u{0048}']),
        '\u{1D43C}' => Some(&['\u{0049}']),
        '\u{1D43D}' => Some(&['\u{004A}']),
        '\u{1D43E}' => Some(&['\u{004B}']),
        '\u{1D43F}' => Some(&['\u{004C}']),
        '\u{1D440}' => Some(&['\u{004D}']),
        '\u{1D441}' => Some(&['\u{004E}']),
        '\u{1D442}' => Some(&['\u{004F}']),
        '\u{1D443}' => Some(&['\u{0050}']),
        '\u{1D444}' => Some(&['\u{0051}']),
        '\u{1D445}' => Some(&['\u{0052}']),
        '\u{1D446}' => Some(&['\u{0053}']),
        '\u{1D447}' => Some(&['\u{0054}']),
        '\u{1D448}' => Some(&['\u{0055}']),
        '\u{1D449}' => Some(&['\u{0056}']),
        '\u{1D44A}' => Some(&['\u{0057}']),
        '\u{1D44B}' => Some(&['\u{0058}']),
        '\u{1D44C}' => Some(&['\u{0059}']),
        '\u{1D44D}' => Some(&['\u{005A}']),
        '\u{1D44E}' => Some(&['\u{0061}']),
        '\u{1D44F}' => Some(&['\u{0062}']),
        '\u{1D450}' => Some(&['\u{0063}']),
        '\u{1D451}' => Some(&['\u{0064}']),
        '\u{1D452}' => Some(&['\u{0065}']),
        '\u{1D453}' => Some(&['\u{0066}']),
        '\u{1D454}' => Some(&['\u{0067}']),
        '\u{1D456}' => Some(&['\u{0069}']),
        '\u{1D457}' => Some(&['\u{006A}']),
        '\u{1D458}' => Some(&['\u{006B}']),
        '\u{1D459}' => Some(&['\u{006C}']),
        '\u{1D45A}' => Some(&['\u{006D}']),
        '\u{1D45B}' => Some(&['\u{006E}']),
        '\u{1D45C}' => Some(&['\u{006F}']),
        '\u{1D45D}' => Some(&['\u{0070}']),
        '\u{1D45E}' => Some(&['\u{0071}']),
        '\u{1D45F}' => Some(&['\u{0072}']),
        '\u{1D460}' => Some(&['\u{0073}']),
        '\u{1D461}' => Some(&['\u{0074}']),
        '\u{1D462}' => Some(&['\u{0075}']),
        '\u{1D463}' => Some(&['\u{0076}']),
        '\u{1D464}' => Some(&['\u{0077}']),
        '\u{1D465}' => Some(&['\u{0078}']),
        '\u{1D466}' => Some(&['\u{0079}']),
        '\u{1D467}' => Some(&['\u{007A}']),
        '\u{1D468}' => Some(&['\u{0041}']),
        '\u{1D469}' => Some(&['\u{0042}']),
        '\u{1D46A}' => Some(&['\u{0043}']),
        '\u{1D46B}' => Some(&['\u{0044}']),
        '\u{1D46C}' => Some(&['\u{0045}']),
        '\u{1D46D}' => Some(&['\u{0046}']),
        '\u{1D46E}' => Some(&['\u{0047}']),
        '\u{1D46F}' => Some(&['\u{0048}']),
        '\u{1D470}' => Some(&['\u{0049}']),
        '\u{1D471}' => Some(&['\u{004A}']),
        '\u{1D472}' => Some(&['\u{004B}']),
        '\u{1D473}' => Some(&['\u{004C}']),
        '\u{1D474}' => Some(&['\u{004D}']),
        '\u{1D475}' => Some(&['\u{004E}']),
        '\u{1D476}' => Some(&['\u{004F}']),
        '\u{1D477}' => Some(&['\u{0050}']),
        '\u{1D478}' => Some(&['\u{0051}']),
        '\u{1D479}' => Some(&['\u{0052}']),
        '\u{1D47A}' => Some(&['\u{0053}']),
        '\u{1D47B}' => Some(&['\u{0054}']),
        '\u{1D47C}' => Some(&['\u{0055}']),
        '\u{1D47D}' => Some(&['\u{0056}']),
        '\u{1D47E}' => Some(&['\u{0057}']),
        '\u{1D47F}' => Some(&['\u{0058}']),
        '\u{1D480}' => Some(&['\u{0059}']),
        '\u{1D481}' => Some(&['\u{005A}']),
        '\u{1D482}' => Some(&['\u{0061}']),
        '\u{1D483}' => Some(&['\u{0062}']),
        '\u{1D484}' => Some(&['\u{0063}']),
        '\u{1D485}' => Some(&['\u{0064}']),
        '\u{1D486}' => Some(&['\u{0065}']),
        '\u{1D487}' => Some(&['\u{0066}']),
        '\u{1D488}' => Some(&['\u{0067}']),
        '\u{1D489}' => Some(&['\u{0068}']),
        '\u{1D48A}' => Some(&['\u{0069}']),
        '\u{1D48B}' => Some(&['\u{006A}']),
        '\u{1D48C}' => Some(&['\u{006B}']),
        '\u{1D48D}' => Some(&['\u{006C}']),
        '\u{1D48E}' => Some(&['\u{006D}']),
        '\u{1D48F}' => Some(&['\u{006E}']),
        '\u{1D490}' => Some(&['\u{006F}']),
        '\u{1D491}' => Some(&['\u{0070}']),
        '\u{1D492}' => Some(&['\u{0071}']),
        '\u{1D493}' => Some(&['\u{0072}']),
        '\u{1D494}' => Some(&['\u{0073}']),
        '\u{1D495}' => Some(&['\u{0074}']),
        '\u{1D496}' => Some(&['\u{0075}']),
        '\u{1D497}' => Some(&['\u{0076}']),
        '\u{1D498}' => Some(&['\u{0077}']),
        '\u{1D499}' => Some(&['\u{0078}']),
        '\u{1D49A}' => Some(&['\u{0079}']),
        '\u{1D49B}' => Some(&['\u{007A}']),
        '\u{1D49C}' => Some(&['\u{0041}']),
        '\u{1D49E}' => Some(&['\u{0043}']),
        '\u{1D49F}' => Some(&['\u{0044}']),
        '\u{1D4A2}' => Some(&['\u{0047}']),
        '\u{1D4A5}' => Some(&['\u{004A}']),
        '\u{1D4A6}' => Some(&['\u{004B}']),
        '\u{1D4A9}' => Some(&['\u{004E}']),
        '\u{1D4AA}' => Some(&['\u{004F}']),
        '\u{1D4AB}' => Some(&['\u{0050}']),
        '\u{1D4AC}' => Some(&['\u{0051}']),
        '\u{1D4AE}' => Some(&['\u{0053}']),
        '\u{1D4AF}' => Some(&['\u{0054}']),
        '\u{1D4B0}' => Some(&['\u{0055}']),
        '\u{1D4B1}' => Some(&['\u{0056}']),
        '\u{1D4B2}' => Some(&['\u{0057}']),
        '\u{1D4B3}' => Some(&['\u{0058}']),
        '\u{1D4B4}' => Some(&['\u{0059}']),
        '\u{1D4B5}' => Some(&['\u{005A}']),
        '\u{1D4B6}' => Some(&['\u{0061}']),
        '\u{1D4B7}' => Some(&['\u{0062}']),
        '\u{1D4B8}' => Some(&['\u{0063}']),
        '\u{1D4B9}' => Some(&['\u{0064}']),
        '\u{1D4BB}' => Some(&['\u{0066}']),
        '\u{1D4BD}' => Some(&['\u{0068}']),
        '\u{1D4BE}' => Some(&['\u{0069}']),
        '\u{1D4BF}' => Some(&['\u{006A}']),
        '\u{1D4C0}' => Some(&['\u{006B}']),
        '\u{1D4C1}' => Some(&['\u{006C}']),
        '\u{1D4C2}' => Some(&['\u{006D}']),
        '\u{1D4C3}' => Some(&['\u{006E}']),
        '\u{1D4C5}' => Some(&['\u{0070}']),
        '\u{1D4C6}' => Some(&['\u{0071}']),
        '\u{1D4C7}' => Some(&['\u{0072}']),
        '\u{1D4C8}' => Some(&['\u{0073}']),
        '\u{1D4C9}' => Some(&['\u{0074}']),
        '\u{1D4CA}' => Some(&['\u{0075}']),
        '\u{1D4CB}' => Some(&['\u{0076}']),
        '\u{1D4CC}' => Some(&['\u{0077}']),
        '\u{1D4CD}' => Some(&['\u{0078}']),
        '\u{1D4CE}' => Some(&['\u{0079}']),
        '\u{1D4CF}' => Some(&['\u{007A}']),
        '\u{1D4D0}' => Some(&['\u{0041}']),
        '\u{1D4D1}' => Some(&['\u{0042}']),
        '\u{1D4D2}' => Some(&['\u{0043}']),
        '\u{1D4D3}' => Some(&['\u{0044}']),
        '\u{1D4D4}' => Some(&['\u{0045}']),
        '\u{1D4D5}' => Some(&['\u{0046}']),
        '\u{1D4D6}' => Some(&['\u{0047}']),
        '\u{1D4D7}' => Some(&['\u{0048}']),
        '\u{1D4D8}' => Some(&['\u{0049}']),
        '\u{1D4D9}' => Some(&['\u{004A}']),
        '\u{1D4DA}' => Some(&['\u{004B}']),
        '\u{1D4DB}' => Some(&['\u{004C}']),
        '\u{1D4DC}' => Some(&['\u{004D}']),
        '\u{1D4DD}' => Some(&['\u{004E}']),
        '\u{1D4DE}' => Some(&['\u{004F}']),
        '\u{1D4DF}' => Some(&['\u{0050}']),
        '\u{1D4E0}' => Some(&['\u{0051}']),
        '\u{1D4E1}' => Some(&['\u{0052}']),
        '\u{1D4E2}' => Some(&['\u{0053}']),
        '\u{1D4E3}' => Some(&['\u{0054}']),
        '\u{1D4E4}' => Some(&['\u{0055}']),
        '\u{1D4E5}' => Some(&['\u{0056}']),
        '\u{1D4E6}' => Some(&['\u{0057}']),
        '\u{1D4E7}' => Some(&['\u{0058}']),
        '\u{1D4E8}' => Some(&['\u{0059}']),
        '\u{1D4E9}' => Some(&['\u{005A}']),
        '\u{1D4EA}' => Some(&['\u{0061}']),
        '\u{1D4EB}' => Some(&['\u{0062}']),
        '\u{1D4EC}' => Some(&['\u{0063}']),
        '\u{1D4ED}' => Some(&['\u{0064}']),
        '\u{1D4EE}' => Some(&['\u{0065}']),
        '\u{1D4EF}' => Some(&['\u{0066}']),
        '\u{1D4F0}' => Some(&['\u{0067}']),
        '\u{1D4F1}' => Some(&['\u{0068}']),
        '\u{1D4F2}' => Some(&['\u{0069}']),
        '\u{1D4F3}' => Some(&['\u{006A}']),
        '\u{1D4F4}' => Some(&['\u{006B}']),
        '\u{1D4F5}' => Some(&['\u{006C}']),
        '\u{1D4F6}' => Some(&['\u{006D}']),
        '\u{1D4F7}' => Some(&['\u{006E}']),
        '\u{1D4F8}' => Some(&['\u{006F}']),
        '\u{1D4F9}' => Some(&['\u{0070}']),
        '\u{1D4FA}' => Some(&['\u{0071}']),
        '\u{1D4FB}' => Some(&['\u{0072}']),
        '\u{1D4FC}' => Some(&['\u{0073}']),
        '\u{1D4FD}' => Some(&['\u{0074}']),
        '\u{1D4FE}' => Some(&['\u{0075}']),
        '\u{1D4FF}' => Some(&['\u{0076}']),
        '\u{1D500}' => Some(&['\u{0077}']),
        '\u{1D501}' => Some(&['\u{0078}']),
        '\u{1D502}' => Some(&['\u{0079}']),
        '\u{1D503}' => Some(&['\u{007A}']),
        '\u{1D504}' => Some(&['\u{0041}']),
        '\u{1D505}' => Some(&['\u{0042}']),
        '\u{1D507}' => Some(&['\u{0044}']),
        '\u{1D508}' => Some(&['\u{0045}']),
        '\u{1D509}' => Some(&['\u{0046}']),
        '\u{1D50A}' => Some(&['\u{0047}']),
        '\u{1D50D}' => Some(&['\u{004A}']),
        '\u{1D50E}' => Some(&['\u{004B}']),
        '\u{1D50F}' => Some(&['\u{004C}']),
        '\u{1D510}' => Some(&['\u{004D}']),
        '\u{1D511}' => Some(&['\u{004E}']),
        '\u{1D512}' => Some(&['\u{004F}']),
        '\u{1D513}' => Some(&['\u{0050}']),
        '\u{1D514}' => Some(&['\u{0051}']),
        '\u{1D516}' => Some(&['\u{0053}']),
        '\u{1D517}' => Some(&['\u{0054}']),
        '\u{1D518}' => Some(&['\u{0055}']),
        '\u{1D519}' => Some(&['\u{0056}']),
        '\u{1D51A}' => Some(&['\u{0057}']),
        '\u{1D51B}' => Some(&['\u{0058}']),
        '\u{1D51C}' => Some(&['\u{0059}']),
        '\u{1D51E}' => Some(&['\u{0061}']),
        '\u{1D51F}' => Some(&['\u{0062}']),
        '\u{1D520}' => Some(&['\u{0063}']),
        '\u{1D521}' => Some(&['\u{0064}']),
        '\u{1D522}' => Some(&['\u{0065}']),
        '\u{1D523}' => Some(&['\u{0066}']),
        '\u{1D524}' => Some(&['\u{0067}']),
        '\u{1D525}' => Some(&['\u{0068}']),
        '\u{1D526}' => Some(&['\u{0069}']),
        '\u{1D527}' => Some(&['\u{006A}']),
        '\u{1D528}' => Some(&['\u{006B}']),
        '\u{1D529}' => Some(&['\u{006C}']),
        '\u{1D52A}' => Some(&['\u{006D}']),
        '\u{1D52B}' => Some(&['\u{006E}']),
        '\u{1D52C}' => Some(&['\u{006F}']),
        '\u{1D52D}' => Some(&['\u{0070}']),
        '\u{1D52E}' => Some(&['\u{0071}']),
        '\u{1D52F}' => Some(&['\u{0072}']),
        '\u{1D530}' => Some(&['\u{0073}']),
        '\u{1D531}' => Some(&['\u{0074}']),
        '\u{1D532}' => Some(&['\u{0075}']),
        '\u{1D533}' => Some(&['\u{0076}']),
        '\u{1D534}' => Some(&['\u{0077}']),
        '\u{1D535}' => Some(&['\u{0078}']),
        '\u{1D536}' => Some(&['\u{0079}']),
        '\u{1D537}' => Some(&['\u{007A}']),
        '\u{1D538}' => Some(&['\u{0041}']),
        '\u{1D539}' => Some(&['\u{0042}']),
        '\u{1D53B}' => Some(&['\u{0044}']),
        '\u{1D53C}' => Some(&['\u{0045}']),
        '\u{1D53D}' => Some(&['\u{0046}']),
        '\u{1D53E}' => Some(&['\u{0047}']),
        '\u{1D540}' => Some(&['\u{0049}']),
        '\u{1D541}' => Some(&['\u{004A}']),
        '\u{1D542}' => Some(&['\u{004B}']),
        '\u{1D543}' => Some(&['\u{004C}']),
        '\u{1D544}' => Some(&['\u{004D}']),
        '\u{1D546}' => Some(&['\u{004F}']),
        '\u{1D54A}' => Some(&['\u{0053}']),
        '\u{1D54B}' => Some(&['\u{0054}']),
        '\u{1D54C}' => Some(&['\u{0055}']),
        '\u{1D54D}' => Some(&['\u{0056}']),
        '\u{1D54E}' => Some(&['\u{0057}']),
        '\u{1D54F}' => Some(&['\u{0058}']),
        '\u{1D550}' => Some(&['\u{0059}']),
        '\u{1D552}' => Some(&['\u{0061}']),
        '\u{1D553}' => Some(&['\u{0062}']),
        '\u{1D554}' => Some(&['\u{0063}']),
        '\u{1D555}' => Some(&['\u{0064}']),
        '\u{1D556}' => Some(&['\u{0065}']),
        '\u{1D557}' => Some(&['\u{0066}']),
        '\u{1D558}' => Some(&['\u{0067}']),
        '\u{1D559}' => Some(&['\u{0068}']),
        '\u{1D55A}' => Some(&['\u{0069}']),
        '\u{1D55B}' => Some(&['\u{006A}']),
        '\u{1D55C}' => Some(&['\u{006B}']),
        '\u{1D55D}' => Some(&['\u{006C}']),
        '\u{1D55E}' => Some(&['\u{006D}']),
        '\u{1D55F}' => Some(&['\u{006E}']),
        '\u{1D560}' => Some(&['\u{006F}']),
        '\u{1D561}' => Some(&['\u{0070}']),
        '\u{1D562}' => Some(&['\u{0071}']),
        '\u{1D563}' => Some(&['\u{0072}']),
        '\u{1D564}' => Some(&['\u{0073}']),
        '\u{1D565}' => Some(&['\u{0074}']),
        '\u{1D566}' => Some(&['\u{0075}']),
        '\u{1D567}' => Some(&['\u{0076}']),
        '\u{1D568}' => Some(&['\u{0077}']),
        '\u{1D569}' => Some(&['\u{0078}']),
        '\u{1D56A}' => Some(&['\u{0079}']),
        '\u{1D56B}' => Some(&['\u{007A}']),
        '\u{1D56C}' => Some(&['\u{0041}']),
        '\u{1D56D}' => Some(&['\u{0042}']),
        '\u{1D56E}' => Some(&['\u{0043}']),
        '\u{1D56F}' => Some(&['\u{0044}']),
        '\u{1D570}' => Some(&['\u{0045}']),
        '\u{1D571}' => Some(&['\u{0046}']),
        '\u{1D572}' => Some(&['\u{0047}']),
        '\u{1D573}' => Some(&['\u{0048}']),
        '\u{1D574}' => Some(&['\u{0049}']),
        '\u{1D575}' => Some(&['\u{004A}']),
        '\u{1D576}' => Some(&['\u{004B}']),
        '\u{1D577}' => Some(&['\u{004C}']),
        '\u{1D578}' => Some(&['\u{004D}']),
        '\u{1D579}' => Some(&['\u{004E}']),
        '\u{1D57A}' => Some(&['\u{004F}']),
        '\u{1D57B}' => Some(&['\u{0050}']),
        '\u{1D57C}' => Some(&['\u{0051}']),
        '\u{1D57D}' => Some(&['\u{0052}']),
        '\u{1D57E}' => Some(&['\u{0053}']),
        '\u{1D57F}' => Some(&['\u{0054}']),
        '\u{1D580}' => Some(&['\u{0055}']),
        '\u{1D581}' => Some(&['\u{0056}']),
        '\u{1D582}' => Some(&['\u{0057}']),
        '\u{1D583}' => Some(&['\u{0058}']),
        '\u{1D584}' => Some(&['\u{0059}']),
        '\u{1D585}' => Some(&['\u{005A}']),
        '\u{1D586}' => Some(&['\u{0061}']),
        '\u{1D587}' => Some(&['\u{0062}']),
        '\u{1D588}' => Some(&['\u{0063}']),
        '\u{1D589}' => Some(&['\u{0064}']),
        '\u{1D58A}' => Some(&['\u{0065}']),
        '\u{1D58B}' => Some(&['\u{0066}']),
        '\u{1D58C}' => Some(&['\u{0067}']),
        '\u{1D58D}' => Some(&['\u{0068}']),
        '\u{1D58E}' => Some(&['\u{0069}']),
        '\u{1D58F}' => Some(&['\u{006A}']),
        '\u{1D590}' => Some(&['\u{006B}']),
        '\u{1D591}' => Some(&['\u{006C}']),
        '\u{1D592}' => Some(&['\u{006D}']),
        '\u{1D593}' => Some(&['\u{006E}']),
        '\u{1D594}' => Some(&['\u{006F}']),
        '\u{1D595}' => Some(&['\u{0070}']),
        '\u{1D596}' => Some(&['\u{0071}']),
        '\u{1D597}' => Some(&['\u{0072}']),
        '\u{1D598}' => Some(&['\u{0073}']),
        '\u{1D599}' => Some(&['\u{0074}']),
        '\u{1D59A}' => Some(&['\u{0075}']),
        '\u{1D59B}' => Some(&['\u{0076}']),
        '\u{1D59C}' => Some(&['\u{0077}']),
        '\u{1D59D}' => Some(&['\u{0078}']),
        '\u{1D59E}' => Some(&['\u{0079}']),
        '\u{1D59F}' => Some(&['\u{007A}']),
        '\u{1D5A0}' => Some(&['\u{0041}']),
        '\u{1D5A1}' => Some(&['\u{0042}']),
        '\u{1D5A2}' => Some(&['\u{0043}']),
        '\u{1D5A3}' => Some(&['\u{0044}']),
        '\u{1D5A4}' => Some(&['\u{0045}']),
        '\u{1D5A5}' => Some(&['\u{0046}']),
        '\u{1D5A6}' => Some(&['\u{0047}']),
        '\u{1D5A7}' => Some(&['\u{0048}']),
        '\u{1D5A8}' => Some(&['\u{0049}']),
        '\u{1D5A9}' => Some(&['\u{004A}']),
        '\u{1D5AA}' => Some(&['\u{004B}']),
        '\u{1D5AB}' => Some(&['\u{004C}']),
        '\u{1D5AC}' => Some(&['\u{004D}']),
        '\u{1D5AD}' => Some(&['\u{004E}']),
        '\u{1D5AE}' => Some(&['\u{004F}']),
        '\u{1D5AF}' => Some(&['\u{0050}']),
        '\u{1D5B0}' => Some(&['\u{0051}']),
        '\u{1D5B1}' => Some(&['\u{0052}']),
        '\u{1D5B2}' => Some(&['\u{0053}']),
        '\u{1D5B3}' => Some(&['\u{0054}']),
        '\u{1D5B4}' => Some(&['\u{0055}']),
        '\u{1D5B5}' => Some(&['\u{0056}']),
        '\u{1D5B6}' => Some(&['\u{0057}']),
        '\u{1D5B7}' => Some(&['\u{0058}']),
        '\u{1D5B8}' => Some(&['\u{0059}']),
        '\u{1D5B9}' => Some(&['\u{005A}']),
        '\u{1D5BA}' => Some(&['\u{0061}']),
        '\u{1D5BB}' => Some(&['\u{0062}']),
        '\u{1D5BC}' => Some(&['\u{0063}']),
        '\u{1D5BD}' => Some(&['\u{0064}']),
        '\u{1D5BE}' => Some(&['\u{0065}']),
        '\u{1D5BF}' => Some(&['\u{0066}']),
        '\u{1D5C0}' => Some(&['\u{0067}']),
        '\u{1D5C1}' => Some(&['\u{0068}']),
        '\u{1D5C2}' => Some(&['\u{0069}']),
        '\u{1D5C3}' => Some(&['\u{006A}']),
        '\u{1D5C4}' => Some(&['\u{006B}']),
        '\u{1D5C5}' => Some(&['\u{006C}']),
        '\u{1D5C6}' => Some(&['\u{006D}']),
        '\u{1D5C7}' => Some(&['\u{006E}']),
        '\u{1D5C8}' => Some(&['\u{006F}']),
        '\u{1D5C9}' => Some(&['\u{0070}']),
        '\u{1D5CA}' => Some(&['\u{0071}']),
        '\u{1D5CB}' => Some(&['\u{0072}']),
        '\u{1D5CC}' => Some(&['\u{0073}']),
        '\u{1D5CD}' => Some(&['\u{0074}']),
        '\u{1D5CE}' => Some(&['\u{0075}']),
        '\u{1D5CF}' => Some(&['\u{0076}']),
        '\u{1D5D0}' => Some(&['\u{0077}']),
        '\u{1D5D1}' => Some(&['\u{0078}']),
        '\u{1D5D2}' => Some(&['\u{0079}']),
        '\u{1D5D3}' => Some(&['\u{007A}']),
        '\u{1D5D4}' => Some(&['\u{0041}']),
        '\u{1D5D5}' => Some(&['\u{0042}']),
        '\u{1D5D6}' => Some(&['\u{0043}']),
        '\u{1D5D7}' => Some(&['\u{0044}']),
        '\u{1D5D8}' => Some(&['\u{0045}']),
        '\u{1D5D9}' => Some(&['\u{0046}']),
        '\u{1D5DA}' => Some(&['\u{0047}']),
        '\u{1D5DB}' => Some(&['\u{0048}']),
        '\u{1D5DC}' => Some(&['\u{0049}']),
        '\u{1D5DD}' => Some(&['\u{004A}']),
        '\u{1D5DE}' => Some(&['\u{004B}']),
        '\u{1D5DF}' => Some(&['\u{004C}']),
        '\u{1D5E0}' => Some(&['\u{004D}']),
        '\u{1D5E1}' => Some(&['\u{004E}']),
        '\u{1D5E2}' => Some(&['\u{004F}']),
        '\u{1D5E3}' => Some(&['\u{0050}']),
        '\u{1D5E4}' => Some(&['\u{0051}']),
        '\u{1D5E5}' => Some(&['\u{0052}']),
        '\u{1D5E6}' => Some(&['\u{0053}']),
        '\u{1D5E7}' => Some(&['\u{0054}']),
        '\u{1D5E8}' => Some(&['\u{0055}']),
        '\u{1D5E9}' => Some(&['\u{0056}']),
        '\u{1D5EA}' => Some(&['\u{0057}']),
        '\u{1D5EB}' => Some(&['\u{0058}']),
        '\u{1D5EC}' => Some(&['\u{0059}']),
        '\u{1D5ED}' => Some(&['\u{005A}']),
        '\u{1D5EE}' => Some(&['\u{0061}']),
        '\u{1D5EF}' => Some(&['\u{0062}']),
        '\u{1D5F0}' => Some(&['\u{0063}']),
        '\u{1D5F1}' => Some(&['\u{0064}']),
        '\u{1D5F2}' => Some(&['\u{0065}']),
        '\u{1D5F3}' => Some(&['\u{0066}']),
        '\u{1D5F4}' => Some(&['\u{0067}']),
        '\u{1D5F5}' => Some(&['\u{0068}']),
        '\u{1D5F6}' => Some(&['\u{0069}']),
        '\u{1D5F7}' => Some(&['\u{006A}']),
        '\u{1D5F8}' => Some(&['\u{006B}']),
        '\u{1D5F9}' => Some(&['\u{006C}']),
        '\u{1D5FA}' => Some(&['\u{006D}']),
        '\u{1D5FB}' => Some(&['\u{006E}']),
        '\u{1D5FC}' => Some(&['\u{006F}']),
        '\u{1D5FD}' => Some(&['\u{0070}']),
        '\u{1D5FE}' => Some(&['\u{0071}']),
        '\u{1D5FF}' => Some(&['\u{0072}']),
        '\u{1D600}' => Some(&['\u{0073}']),
        '\u{1D601}' => Some(&['\u{0074}']),
        '\u{1D602}' => Some(&['\u{0075}']),
        '\u{1D603}' => Some(&['\u{0076}']),
        '\u{1D604}' => Some(&['\u{0077}']),
        '\u{1D605}' => Some(&['\u{0078}']),
        '\u{1D606}' => Some(&['\u{0079}']),
        '\u{1D607}' => Some(&['\u{007A}']),
        '\u{1D608}' => Some(&['\u{0041}']),
        '\u{1D609}' => Some(&['\u{0042}']),
        '\u{1D60A}' => Some(&['\u{0043}']),
        '\u{1D60B}' => Some(&['\u{0044}']),
        '\u{1D60C}' => Some(&['\u{0045}']),
        '\u{1D60D}' => Some(&['\u{0046}']),
        '\u{1D60E}' => Some(&['\u{0047}']),
        '\u{1D60F}' => Some(&['\u{0048}']),
        '\u{1D610}' => Some(&['\u{0049}']),
        '\u{1D611}' => Some(&['\u{004A}']),
        '\u{1D612}' => Some(&['\u{004B}']),
        '\u{1D613}' => Some(&['\u{004C}']),
        '\u{1D614}' => Some(&['\u{004D}']),
        '\u{1D615}' => Some(&['\u{004E}']),
        '\u{1D616}' => Some(&['\u{004F}']),
        '\u{1D617}' => Some(&['\u{0050}']),
        '\u{1D618}' => Some(&['\u{0051}']),
        '\u{1D619}' => Some(&['\u{0052}']),
        '\u{1D61A}' => Some(&['\u{0053}']),
        '\u{1D61B}' => Some(&['\u{0054}']),
        '\u{1D61C}' => Some(&['\u{0055}']),
        '\u{1D61D}' => Some(&['\u{0056}']),
        '\u{1D61E}' => Some(&['\u{0057}']),
        '\u{1D61F}' => Some(&['\u{0058}']),
        '\u{1D620}' => Some(&['\u{0059}']),
        '\u{1D621}' => Some(&['\u{005A}']),
        '\u{1D622}' => Some(&['\u{0061}']),
        '\u{1D623}' => Some(&['\u{0062}']),
        '\u{1D624}' => Some(&['\u{0063}']),
        '\u{1D625}' => Some(&['\u{0064}']),
        '\u{1D626}' => Some(&['\u{0065}']),
        '\u{1D627}' => Some(&['\u{0066}']),
        '\u{1D628}' => Some(&['\u{0067}']),
        '\u{1D629}' => Some(&['\u{0068}']),
        '\u{1D62A}' => Some(&['\u{0069}']),
        '\u{1D62B}' => Some(&['\u{006A}']),
        '\u{1D62C}' => Some(&['\u{006B}']),
        '\u{1D62D}' => Some(&['\u{006C}']),
        '\u{1D62E}' => Some(&['\u{006D}']),
        '\u{1D62F}' => Some(&['\u{006E}']),
        '\u{1D630}' => Some(&['\u{006F}']),
        '\u{1D631}' => Some(&['\u{0070}']),
        '\u{1D632}' => Some(&['\u{0071}']),
        '\u{1D633}' => Some(&['\u{0072}']),
        '\u{1D634}' => Some(&['\u{0073}']),
        '\u{1D635}' => Some(&['\u{0074}']),
        '\u{1D636}' => Some(&['\u{0075}']),
        '\u{1D637}' => Some(&['\u{0076}']),
        '\u{1D638}' => Some(&['\u{0077}']),
        '\u{1D639}' => Some(&['\u{0078}']),
        '\u{1D63A}' => Some(&['\u{0079}']),
        '\u{1D63B}' => Some(&['\u{007A}']),
        '\u{1D63C}' => Some(&['\u{0041}']),
        '\u{1D63D}' => Some(&['\u{0042}']),
        '\u{1D63E}' => Some(&['\u{0043}']),
        '\u{1D63F}' => Some(&['\u{0044}']),
        '\u{1D640}' => Some(&['\u{0045}']),
        '\u{1D641}' => Some(&['\u{0046}']),
        '\u{1D642}' => Some(&['\u{0047}']),
        '\u{1D643}' => Some(&['\u{0048}']),
        '\u{1D644}' => Some(&['\u{0049}']),
        '\u{1D645}' => Some(&['\u{004A}']),
        '\u{1D646}' => Some(&['\u{004B}']),
        '\u{1D647}' => Some(&['\u{004C}']),
        '\u{1D648}' => Some(&['\u{004D}']),
        '\u{1D649}' => Some(&['\u{004E}']),
        '\u{1D64A}' => Some(&['\u{004F}']),
        '\u{1D64B}' => Some(&['\u{0050}']),
        '\u{1D64C}' => Some(&['\u{0051}']),
        '\u{1D64D}' => Some(&['\u{0052}']),
        '\u{1D64E}' => Some(&['\u{0053}']),
        '\u{1D64F}' => Some(&['\u{0054}']),
        '\u{1D650}' => Some(&['\u{0055}']),
        '\u{1D651}' => Some(&['\u{0056}']),
        '\u{1D652}' => Some(&['\u{0057}']),
        '\u{1D653}' => Some(&['\u{0058}']),
        '\u{1D654}' => Some(&['\u{0059}']),
        '\u{1D655}' => Some(&['\u{005A}']),
        '\u{1D656}' => Some(&['\u{0061}']),
        '\u{1D657}' => Some(&['\u{0062}']),
        '\u{1D658}' => Some(&['\u{0063}']),
        '\u{1D659}' => Some(&['\u{0064}']),
        '\u{1D65A}' => Some(&['\u{0065}']),
        '\u{1D65B}' => Some(&['\u{0066}']),
        '\u{1D65C}' => Some(&['\u{0067}']),
        '\u{1D65D}' => Some(&['\u{0068}']),
        '\u{1D65E}' => Some(&['\u{0069}']),
        '\u{1D65F}' => Some(&['\u{006A}']),
        '\u{1D660}' => Some(&['\u{006B}']),
        '\u{1D661}' => Some(&['\u{006C}']),
        '\u{1D662}' => Some(&['\u{006D}']),
        '\u{1D663}' => Some(&['\u{006E}']),
        '\u{1D664}' => Some(&['\u{006F}']),
        '\u{1D665}' => Some(&['\u{0070}']),
        '\u{1D666}' => Some(&['\u{0071}']),
        '\u{1D667}' => Some(&['\u{0072}']),
        '\u{1D668}' => Some(&['\u{0073}']),
        '\u{1D669}' => Some(&['\u{0074}']),
        '\u{1D66A}' => Some(&['\u{0075}']),
        '\u{1D66B}' => Some(&['\u{0076}']),
        '\u{1D66C}' => Some(&['\u{0077}']),
        '\u{1D66D}' => Some(&['\u{0078}']),
        '\u{1D66E}' => Some(&['\u{0079}']),
        '\u{1D66F}' => Some(&['\u{007A}']),
        '\u{1D670}' => Some(&['\u{0041}']),
        '\u{1D671}' => Some(&['\u{0042}']),
        '\u{1D672}' => Some(&['\u{0043}']),
        '\u{1D673}' => Some(&['\u{0044}']),
        '\u{1D674}' => Some(&['\u{0045}']),
        '\u{1D675}' => Some(&['\u{0046}']),
        '\u{1D676}' => Some(&['\u{0047}']),
        '\u{1D677}' => Some(&['\u{0048}']),
        '\u{1D678}' => Some(&['\u{0049}']),
        '\u{1D679}' => Some(&['\u{004A}']),
        '\u{1D67A}' => Some(&['\u{004B}']),
        '\u{1D67B}' => Some(&['\u{004C}']),
        '\u{1D67C}' => Some(&['\u{004D}']),
        '\u{1D67D}' => Some(&['\u{004E}']),
        '\u{1D67E}' => Some(&['\u{004F}']),
        '\u{1D67F}' => Some(&['\u{0050}']),
        '\u{1D680}' => Some(&['\u{0051}']),
        '\u{1D681}' => Some(&['\u{0052}']),
        '\u{1D682}' => Some(&['\u{0053}']),
        '\u{1D683}' => Some(&['\u{0054}']),
        '\u{1D684}' => Some(&['\u{0055}']),
        '\u{1D685}' => Some(&['\u{0056}']),
        '\u{1D686}' => Some(&['\u{0057}']),
        '\u{1D687}' => Some(&['\u{0058}']),
        '\u{1D688}' => Some(&['\u{0059}']),
        '\u{1D689}' => Some(&['\u{005A}']),
        '\u{1D68A}' => Some(&['\u{0061}']),
        '\u{1D68B}' => Some(&['\u{0062}']),
        '\u{1D68C}' => Some(&['\u{0063}']),
        '\u{1D68D}' => Some(&['\u{0064}']),
        '\u{1D68E}' => Some(&['\u{0065}']),
        '\u{1D68F}' => Some(&['\u{0066}']),
        '\u{1D690}' => Some(&['\u{0067}']),
        '\u{1D691}' => Some(&['\u{0068}']),
        '\u{1D692}' => Some(&['\u{0069}']),
        '\u{1D693}' => Some(&['\u{006A}']),
        '\u{1D694}' => Some(&['\u{006B}']),
        '\u{1D695}' => Some(&['\u{006C}']),
        '\u{1D696}' => Some(&['\u{006D}']),
        '\u{1D697}' => Some(&['\u{006E}']),
        '\u{1D698}' => Some(&['\u{006F}']),
        '\u{1D699}' => Some(&['\u{0070}']),
        '\u{1D69A}' => Some(&['\u{0071}']),
        '\u{1D69B}' => Some(&['\u{0072}']),
        '\u{1D69C}' => Some(&['\u{0073}']),
        '\u{1D69D}' => Some(&['\u{0074}']),
        '\u{1D69E}' => Some(&['\u{0075}']),
        '\u{1D69F}' => Some(&['\u{0076}']),
        '\u{1D6A0}' => Some(&['\u{0077}']),
        '\u{1D6A1}' => Some(&['\u{0078}']),
        '\u{1D6A2}' => Some(&['\u{0079}']),
        '\u{1D6A3}' => Some(&['\u{007A}']),
        '\u{1D6A4}' => Some(&['\u{0131}']),
        '\u{1D6A5}' => Some(&['\u{0237}']),
        '\u{1D6A8}' => Some(&['\u{0391}']),
        '\u{1D6A9}' => Some(&['\u{0392}']),
        '\u{1D6AA}' => Some(&['\u{0393}']),
        '\u{1D6AB}' => Some(&['\u{0394}']),
        '\u{1D6AC}' => Some(&['\u{0395}']),
        '\u{1D6AD}' => Some(&['\u{0396}']),
        '\u{1D6AE}' => Some(&['\u{0397}']),
        '\u{1D6AF}' => Some(&['\u{0398}']),
        '\u{1D6B0}' => Some(&['\u{0399}']),
        '\u{1D6B1}' => Some(&['\u{039A}']),
        '\u{1D6B2}' => Some(&['\u{039B}']),
        '\u{1D6B3}' => Some(&['\u{039C}']),
        '\u{1D6B4}' => Some(&['\u{039D}']),
        '\u{1D6B5}' => Some(&['\u{039E}']),
        '\u{1D6B6}' => Some(&['\u{039F}']),
        '\u{1D6B7}' => Some(&['\u{03A0}']),
        '\u{1D6B8}' => Some(&['\u{03A1}']),
        '\u{1D6B9}' => Some(&['\u{0398}']),
        '\u{1D6BA}' => Some(&['\u{03A3}']),
        '\u{1D6BB}' => Some(&['\u{03A4}']),
        '\u{1D6BC}' => Some(&['\u{03A5}']),
        '\u{1D6BD}' => Some(&['\u{03A6}']),
        '\u{1D6BE}' => Some(&['\u{03A7}']),
        '\u{1D6BF}' => Some(&['\u{03A8}']),
        '\u{1D6C0}' => Some(&['\u{03A9}']),
        '\u{1D6C1}' => Some(&['\u{2207}']),
        '\u{1D6C2}' => Some(&['\u{03B1}']),
        '\u{1D6C3}' => Some(&['\u{03B2}']),
        '\u{1D6C4}' => Some(&['\u{03B3}']),
        '\u{1D6C5}' => Some(&['\u{03B4}']),
        '\u{1D6C6}' => Some(&['\u{03B5}']),
        '\u{1D6C7}' => Some(&['\u{03B6}']),
        '\u{1D6C8}' => Some(&['\u{03B7}']),
        '\u{1D6C9}' => Some(&['\u{03B8}']),
        '\u{1D6CA}' => Some(&['\u{03B9}']),
        '\u{1D6CB}' => Some(&['\u{03BA}']),
        '\u{1D6CC}' => Some(&['\u{03BB}']),
        '\u{1D6CD}' => Some(&['\u{03BC}']),
        '\u{1D6CE}' => Some(&['\u{03BD}']),
        '\u{1D6CF}' => Some(&['\u{03BE}']),
        '\u{1D6D0}' => Some(&['\u{03BF}']),
        '\u{1D6D1}' => Some(&['\u{03C0}']),
        '\u{1D6D2}' => Some(&['\u{03C1}']),
        '\u{1D6D3}' => Some(&['\u{03C2}']),
        '\u{1D6D4}' => Some(&['\u{03C3}']),
        '\u{1D6D5}' => Some(&['\u{03C4}']),
        '\u{1D6D6}' => Some(&['\u{03C5}']),
        '\u{1D6D7}' => Some(&['\u{03C6}']),
        '\u{1D6D8}' => Some(&['\u{03C7}']),
        '\u{1D6D9}' => Some(&['\u{03C8}']),
        '\u{1D6DA}' => Some(&['\u{03C9}']),
        '\u{1D6DB}' => Some(&['\u{2202}']),
        '\u{1D6DC}' => Some(&['\u{03B5}']),
        '\u{1D6DD}' => Some(&['\u{03B8}']),
        '\u{1D6DE}' => Some(&['\u{03BA}']),
        '\u{1D6DF}' => Some(&['\u{03C6}']),
        '\u{1D6E0}' => Some(&['\u{03C1}']),
        '\u{1D6E1}' => Some(&['\u{03C0}']),
        '\u{1D6E2}' => Some(&['\u{0391}']),
        '\u{1D6E3}' => Some(&['\u{0392}']),
        '\u{1D6E4}' => Some(&['\u{0393}']),
        '\u{1D6E5}' => Some(&['\u{0394}']),
        '\u{1D6E6}' => Some(&['\u{0395}']),
        '\u{1D6E7}' => Some(&['\u{0396}']),
        '\u{1D6E8}' => Some(&['\u{0397}']),
        '\u{1D6E9}' => Some(&['\u{0398}']),
        '\u{1D6EA}' => Some(&['\u{0399}']),
        '\u{1D6EB}' => Some(&['\u{039A}']),
        '\u{1D6EC}' => Some(&['\u{039B}']),
        '\u{1D6ED}' => Some(&['\u{039C}']),
        '\u{1D6EE}' => Some(&['\u{039D}']),
        '\u{1D6EF}' => Some(&['\u{039E}']),
        '\u{1D6F0}' => Some(&['\u{039F}']),
        '\u{1D6F1}' => Some(&['\u{03A0}']),
        '\u{1D6F2}' => Some(&['\u{03A1}']),
        '\u{1D6F3}' => Some(&['\u{0398}']),
        '\u{1D6F4}' => Some(&['\u{03A3}']),
        '\u{1D6F5}' => Some(&['\u{03A4}']),
        '\u{1D6F6}' => Some(&['\u{03A5}']),
        '\u{1D6F7}' => Some(&['\u{03A6}']),
        '\u{1D6F8}' => Some(&['\u{03A7}']),
        '\u{1D6F9}' => Some(&['\u{03A8}']),
        '\u{1D6FA}' => Some(&['\u{03A9}']),
        '\u{1D6FB}' => Some(&['\u{2207}']),
        '\u{1D6FC}' => Some(&['\u{03B1}']),
        '\u{1D6FD}' => Some(&['\u{03B2}']),
        '\u{1D6FE}' => Some(&['\u{03B3}']),
        '\u{1D6FF}' => Some(&['\u{03B4}']),
        '\u{1D700}' => Some(&['\u{03B5}']),
        '\u{1D701}' => Some(&['\u{03B6}']),
        '\u{1D702}' => Some(&['\u{03B7}']),
        '\u{1D703}' => Some(&['\u{03B8}']),
        '\u{1D704}' => Some(&['\u{03B9}']),
        '\u{1D705}' => Some(&['\u{03BA}']),
        '\u{1D706}' => Some(&['\u{03BB}']),
        '\u{1D707}' => Some(&['\u{03BC}']),
        '\u{1D708}' => Some(&['\u{03BD}']),
        '\u{1D709}' => Some(&['\u{03BE}']),
        '\u{1D70A}' => Some(&['\u{03BF}']),
        '\u{1D70B}' => Some(&['\u{03C0}']),
        '\u{1D70C}' => Some(&['\u{03C1}']),
        '\u{1D70D}' => Some(&['\u{03C2}']),
        '\u{1D70E}' => Some(&['\u{03C3}']),
        '\u{1D70F}' => Some(&['\u{03C4}']),
        '\u{1D710}' => Some(&['\u{03C5}']),
        '\u{1D711}' => Some(&['\u{03C6}']),
        '\u{1D712}' => Some(&['\u{03C7}']),
        '\u{1D713}' => Some(&['\u{03C8}']),
        '\u{1D714}' => Some(&['\u{03C9}']),
        '\u{1D715}' => Some(&['\u{2202}']),
        '\u{1D716}' => Some(&['\u{03B5}']),
        '\u{1D717}' => Some(&['\u{03B8}']),
        '\u{1D718}' => Some(&['\u{03BA}']),
        '\u{1D719}' => Some(&['\u{03C6}']),
        '\u{1D71A}' => Some(&['\u{03C1}']),
        '\u{1D71B}' => Some(&['\u{03C0}']),
        '\u{1D71C}' => Some(&['\u{0391}']),
        '\u{1D71D}' => Some(&['\u{0392}']),
        '\u{1D71E}' => Some(&['\u{0393}']),
        '\u{1D71F}' => Some(&['\u{0394}']),
        '\u{1D720}' => Some(&['\u{0395}']),
        '\u{1D721}' => Some(&['\u{0396}']),
        '\u{1D722}' => Some(&['\u{0397}']),
        '\u{1D723}' => Some(&['\u{0398}']),
        '\u{1D724}' => Some(&['\u{0399}']),
        '\u{1D725}' => Some(&['\u{039A}']),
        '\u{1D726}' => Some(&['\u{039B}']),
        '\u{1D727}' => Some(&['\u{039C}']),
        '\u{1D728}' => Some(&['\u{039D}']),
        '\u{1D729}' => Some(&['\u{039E}']),
        '\u{1D72A}' => Some(&['\u{039F}']),
        '\u{1D72B}' => Some(&['\u{03A0}']),
        '\u{1D72C}' => Some(&['\u{03A1}']),
        '\u{1D72D}' => Some(&['\u{0398}']),
        '\u{1D72E}' => Some(&['\u{03A3}']),
        '\u{1D72F}' => Some(&['\u{03A4}']),
        '\u{1D730}' => Some(&['\u{03A5}']),
        '\u{1D731}' => Some(&['\u{03A6}']),
        '\u{1D732}' => Some(&['\u{03A7}']),
        '\u{1D733}' => Some(&['\u{03A8}']),
        '\u{1D734}' => Some(&['\u{03A9}']),
        '\u{1D735}' => Some(&['\u{2207}']),
        '\u{1D736}' => Some(&['\u{03B1}']),
        '\u{1D737}' => Some(&['\u{03B2}']),
        '\u{1D738}' => Some(&['\u{03B3}']),
        '\u{1D739}' => Some(&['\u{03B4}']),
        '\u{1D73A}' => Some(&['\u{03B5}']),
        '\u{1D73B}' => Some(&['\u{03B6}']),
        '\u{1D73C}' => Some(&['\u{03B7}']),
        '\u{1D73D}' => Some(&['\u{03B8}']),
        '\u{1D73E}' => Some(&['\u{03B9}']),
        '\u{1D73F}' => Some(&['\u{03BA}']),
        '\u{1D740}' => Some(&['\u{03BB}']),
        '\u{1D741}' => Some(&['\u{03BC}']),
        '\u{1D742}' => Some(&['\u{03BD}']),
        '\u{1D743}' => Some(&['\u{03BE}']),
        '\u{1D744}' => Some(&['\u{03BF}']),
        '\u{1D745}' => Some(&['\u{03C0}']),
        '\u{1D746}' => Some(&['\u{03C1}']),
        '\u{1D747}' => Some(&['\u{03C2}']),
        '\u{1D748}' => Some(&['\u{03C3}']),
        '\u{1D749}' => Some(&['\u{03C4}']),
        '\u{1D74A}' => Some(&['\u{03C5}']),
        '\u{1D74B}' => Some(&['\u{03C6}']),
        '\u{1D74C}' => Some(&['\u{03C7}']),
        '\u{1D74D}' => Some(&['\u{03C8}']),
        '\u{1D74E}' => Some(&['\u{03C9}']),
        '\u{1D74F}' => Some(&['\u{2202}']),
        '\u{1D750}' => Some(&['\u{03B5}']),
        '\u{1D751}' => Some(&['\u{03B8}']),
        '\u{1D752}' => Some(&['\u{03BA}']),
        '\u{1D753}' => Some(&['\u{03C6}']),
        '\u{1D754}' => Some(&['\u{03C1}']),
        '\u{1D755}' => Some(&['\u{03C0}']),
        '\u{1D756}' => Some(&['\u{0391}']),
        '\u{1D757}' => Some(&['\u{0392}']),
        '\u{1D758}' => Some(&['\u{0393}']),
        '\u{1D759}' => Some(&['\u{0394}']),
        '\u{1D75A}' => Some(&['\u{0395}']),
        '\u{1D75B}' => Some(&['\u{0396}']),
        '\u{1D75C}' => Some(&['\u{0397}']),
        '\u{1D75D}' => Some(&['\u{0398}']),
        '\u{1D75E}' => Some(&['\u{0399}']),
        '\u{1D75F}' => Some(&['\u{039A}']),
        '\u{1D760}' => Some(&['\u{039B}']),
        '\u{1D761}' => Some(&['\u{039C}']),
        '\u{1D762}' => Some(&['\u{039D}']),
        '\u{1D763}' => Some(&['\u{039E}']),
        '\u{1D764}' => Some(&['\u{039F}']),
        '\u{1D765}' => Some(&['\u{03A0}']),
        '\u{1D766}' => Some(&['\u{03A1}']),
        '\u{1D767}' => Some(&['\u{0398}']),
        '\u{1D768}' => Some(&['\u{03A3}']),
        '\u{1D769}' => Some(&['\u{03A4}']),
        '\u{1D76A}' => Some(&['\u{03A5}']),
        '\u{1D76B}' => Some(&['\u{03A6}']),
        '\u{1D76C}' => Some(&['\u{03A7}']),
        '\u{1D76D}' => Some(&['\u{03A8}']),
        '\u{1D76E}' => Some(&['\u{03A9}']),
        '\u{1D76F}' => Some(&['\u{2207}']),
        '\u{1D770}' => Some(&['\u{03B1}']),
        '\u{1D771}' => Some(&['\u{03B2}']),
        '\u{1D772}' => Some(&['\u{03B3}']),
        '\u{1D773}' => Some(&['\u{03B4}']),
        '\u{1D774}' => Some(&['\u{03B5}']),
        '\u{1D775}' => Some(&['\u{03B6}']),
        '\u{1D776}' => Some(&['\u{03B7}']),
        '\u{1D777}' => Some(&['\u{03B8}']),
        '\u{1D778}' => Some(&['\u{03B9}']),
        '\u{1D779}' => Some(&['\u{03BA}']),
        '\u{1D77A}' => Some(&['\u{03BB}']),
        '\u{1D77B}' => Some(&['\u{03BC}']),
        '\u{1D77C}' => Some(&['\u{03BD}']),
        '\u{1D77D}' => Some(&['\u{03BE}']),
        '\u{1D77E}' => Some(&['\u{03BF}']),
        '\u{1D77F}' => Some(&['\u{03C0}']),
        '\u{1D780}' => Some(&['\u{03C1}']),
        '\u{1D781}' => Some(&['\u{03C2}']),
        '\u{1D782}' => Some(&['\u{03C3}']),
        '\u{1D783}' => Some(&['\u{03C4}']),
        '\u{1D784}' => Some(&['\u{03C5}']),
        '\u{1D785}' => Some(&['\u{03C6}']),
        '\u{1D786}' => Some(&['\u{03C7}']),
        '\u{1D787}' => Some(&['\u{03C8}']),
        '\u{1D788}' => Some(&['\u{03C9}']),
        '\u{1D789}' => Some(&['\u{2202}']),
        '\u{1D78A}' => Some(&['\u{03B5}']),
        '\u{1D78B}' => Some(&['\u{03B8}']),
        '\u{1D78C}' => Some(&['\u{03BA}']),
        '\u{1D78D}' => Some(&['\u{03C6}']),
        '\u{1D78E}' => Some(&['\u{03C1}']),
        '\u{1D78F}' => Some(&['\u{03C0}']),
        '\u{1D790}' => Some(&['\u{0391}']),
        '\u{1D791}' => Some(&['\u{0392}']),
        '\u{1D792}' => Some(&['\u{0393}']),
        '\u{1D793}' => Some(&['\u{0394}']),
        '\u{1D794}' => Some(&['\u{0395}']),
        '\u{1D795}' => Some(&['\u{0396}']),
        '\u{1D796}' => Some(&['\u{0397}']),
        '\u{1D797}' => Some(&['\u{0398}']),
        '\u{1D798}' => Some(&['\u{0399}']),
        '\u{1D799}' => Some(&['\u{039A}']),
        '\u{1D79A}' => Some(&['\u{039B}']),
        '\u{1D79B}' => Some(&['\u{039C}']),
        '\u{1D79C}' => Some(&['\u{039D}']),
        '\u{1D79D}' => Some(&['\u{039E}']),
        '\u{1D79E}' => Some(&['\u{039F}']),
        '\u{1D79F}' => Some(&['\u{03A0}']),
        '\u{1D7A0}' => Some(&['\u{03A1}']),
        '\u{1D7A1}' => Some(&['\u{0398}']),
        '\u{1D7A2}' => Some(&['\u{03A3}']),
        '\u{1D7A3}' => Some(&['\u{03A4}']),
        '\u{1D7A4}' => Some(&['\u{03A5}']),
        '\u{1D7A5}' => Some(&['\u{03A6}']),
        '\u{1D7A6}' => Some(&['\u{03A7}']),
        '\u{1D7A7}' => Some(&['\u{03A8}']),
        '\u{1D7A8}' => Some(&['\u{03A9}']),
        '\u{1D7A9}' => Some(&['\u{2207}']),
        '\u{1D7AA}' => Some(&['\u{03B1}']),
        '\u{1D7AB}' => Some(&['\u{03B2}']),
        '\u{1D7AC}' => Some(&['\u{03B3}']),
        '\u{1D7AD}' => Some(&['\u{03B4}']),
        '\u{1D7AE}' => Some(&['\u{03B5}']),
        '\u{1D7AF}' => Some(&['\u{03B6}']),
        '\u{1D7B0}' => Some(&['\u{03B7}']),
        '\u{1D7B1}' => Some(&['\u{03B8}']),
        '\u{1D7B2}' => Some(&['\u{03B9}']),
        '\u{1D7B3}' => Some(&['\u{03BA}']),
        '\u{1D7B4}' => Some(&['\u{03BB}']),
        '\u{1D7B5}' => Some(&['\u{03BC}']),
        '\u{1D7B6}' => Some(&['\u{03BD}']),
        '\u{1D7B7}' => Some(&['\u{03BE}']),
        '\u{1D7B8}' => Some(&['\u{03BF}']),
        '\u{1D7B9}' => Some(&['\u{03C0}']),
        '\u{1D7BA}' => Some(&['\u{03C1}']),
        '\u{1D7BB}' => Some(&['\u{03C2}']),
        '\u{1D7BC}' => Some(&['\u{03C3}']),
        '\u{1D7BD}' => Some(&['\u{03C4}']),
        '\u{1D7BE}' => Some(&['\u{03C5}']),
        '\u{1D7BF}' => Some(&['\u{03C6}']),
        '\u{1D7C0}' => Some(&['\u{03C7}']),
        '\u{1D7C1}' => Some(&['\u{03C8}']),
        '\u{1D7C2}' => Some(&['\u{03C9}']),
        '\u{1D7C3}' => Some(&['\u{2202}']),
        '\u{1D7C4}' => Some(&['\u{03B5}']),
        '\u{1D7C5}' => Some(&['\u{03B8}']),
        '\u{1D7C6}' => Some(&['\u{03BA}']),
        '\u{1D7C7}' => Some(&['\u{03C6}']),
        '\u{1D7C8}' => Some(&['\u{03C1}']),
        '\u{1D7C9}' => Some(&['\u{03C0}']),
        '\u{1D7CA}' => Some(&['\u{03DC}']),
        '\u{1D7CB}' => Some(&['\u{03DD}']),
        '\u{1D7CE}' => Some(&['\u{0030}']),
        '\u{1D7CF}' => Some(&['\u{0031}']),
        '\u{1D7D0}' => Some(&['\u{0032}']),
        '\u{1D7D1}' => Some(&['\u{0033}']),
        '\u{1D7D2}' => Some(&['\u{0034}']),
        '\u{1D7D3}' => Some(&['\u{0035}']),
        '\u{1D7D4}' => Some(&['\u{0036}']),
        '\u{1D7D5}' => Some(&['\u{0037}']),
        '\u{1D7D6}' => Some(&['\u{0038}']),
        '\u{1D7D7}' => Some(&['\u{0039}']),
        '\u{1D7D8}' => Some(&['\u{0030}']),
        '\u{1D7D9}' => Some(&['\u{0031}']),
        '\u{1D7DA}' => Some(&['\u{0032}']),
        '\u{1D7DB}' => Some(&['\u{0033}']),
        '\u{1D7DC}' => Some(&['\u{0034}']),
        '\u{1D7DD}' => Some(&['\u{0035}']),
        '\u{1D7DE}' => Some(&['\u{0036}']),
        '\u{1D7DF}' => Some(&['\u{0037}']),
        '\u{1D7E0}' => Some(&['\u{0038}']),
        '\u{1D7E1}' => Some(&['\u{0039}']),
        '\u{1D7E2}' => Some(&['\u{0030}']),
        '\u{1D7E3}' => Some(&['\u{0031}']),
        '\u{1D7E4}' => Some(&['\u{0032}']),
        '\u{1D7E5}' => Some(&['\u{0033}']),
        '\u{1D7E6}' => Some(&['\u{0034}']),
        '\u{1D7E7}' => Some(&['\u{0035}']),
        '\u{1D7E8}' => Some(&['\u{0036}']),
        '\u{1D7E9}' => Some(&['\u{0037}']),
        '\u{1D7EA}' => Some(&['\u{0038}']),
        '\u{1D7EB}' => Some(&['\u{0039}']),
        '\u{1D7EC}' => Some(&['\u{0030}']),
        '\u{1D7ED}' => Some(&['\u{0031}']),
        '\u{1D7EE}' => Some(&['\u{0032}']),
        '\u{1D7EF}' => Some(&['\u{0033}']),
        '\u{1D7F0}' => Some(&['\u{0034}']),
        '\u{1D7F1}' => Some(&['\u{0035}']),
        '\u{1D7F2}' => Some(&['\u{0036}']),
        '\u{1D7F3}' => Some(&['\u{0037}']),
        '\u{1D7F4}' => Some(&['\u{0038}']),
        '\u{1D7F5}' => Some(&['\u{0039}']),
        '\u{1D7F6}' => Some(&['\u{0030}']),
        '\u{1D7F7}' => Some(&['\u{0031}']),
        '\u{1D7F8}' => Some(&['\u{0032}']),
        '\u{1D7F9}' => Some(&['\u{0033}']),
        '\u{1D7FA}' => Some(&['\u{0034}']),
        '\u{1D7FB}' => Some(&['\u{0035}']),
        '\u{1D7FC}' => Some(&['\u{0036}']),
        '\u{1D7FD}' => Some(&['\u{0037}']),
        '\u{1D7FE}' => Some(&['\u{0038}']),
        '\u{1D7FF}' => Some(&['\u{0039}']),
        '\u{1EE00}' => Some(&['\u{0627}']),
        '\u{1EE01}' => Some(&['\u{0628}']),
        '\u{1EE02}' => Some(&['\u{062C}']),
        '\u{1EE03}' => Some(&['\u{062F}']),
        '\u{1EE05}' => Some(&['\u{0648}']),
        '\u{1EE06}' => Some(&['\u{0632}']),
        '\u{1EE07}' => Some(&['\u{062D}']),
        '\u{1EE08}' => Some(&['\u{0637}']),
        '\u{1EE09}' => Some(&['\u{064A}']),
        '\u{1EE0A}' => Some(&['\u{0643}']),
        '\u{1EE0B}' => Some(&['\u{0644}']),
        '\u{1EE0C}' => Some(&['\u{0645}']),
        '\u{1EE0D}' => Some(&['\u{0646}']),
        '\u{1EE0E}' => Some(&['\u{0633}']),
        '\u{1EE0F}' => Some(&['\u{0639}']),
        '\u{1EE10}' => Some(&['\u{0641}']),
        '\u{1EE11}' => Some(&['\u{0635}']),
        '\u{1EE12}' => Some(&['\u{0642}']),
        '\u{1EE13}' => Some(&['\u{0631}']),
        '\u{1EE14}' => Some(&['\u{0634}']),
        '\u{1EE15}' => Some(&['\u{062A}']),
        '\u{1EE16}' => Some(&['\u{062B}']),
        '\u{1EE17}' => Some(&['\u{062E}']),
        '\u{1EE18}' => Some(&['\u{0630}']),
        '\u{1EE19}' => Some(&['\u{0636}']),
        '\u{1EE1A}' => Some(&['\u{0638}']),
        '\u{1EE1B}' => Some(&['\u{063A}']),
        '\u{1EE1C}' => Some(&['\u{066E}']),
        '\u{1EE1D}' => Some(&['\u{06BA}']),
        '\u{1EE1E}' => Some(&['\u{06A1}']),
        '\u{1EE1F}' => Some(&['\u{066F}']),
        '\u{1EE21}' => Some(&['\u{0628}']),
        '\u{1EE22}' => Some(&['\u{062C}']),
        '\u{1EE24}' => Some(&['\u{0647}']),
        '\u{1EE27}' => Some(&['\u{062D}']),
        '\u{1EE29}' => Some(&['\u{064A}']),
        '\u{1EE2A}' => Some(&['\u{0643}']),
        '\u{1EE2B}' => Some(&['\u{0644}']),
        '\u{1EE2C}' => Some(&['\u{0645}']),
        '\u{1EE2D}' => Some(&['\u{0646}']),
        '\u{1EE2E}' => Some(&['\u{0633}']),
        '\u{1EE2F}' => Some(&['\u{0639}']),
        '\u{1EE30}' => Some(&['\u{0641}']),
        '\u{1EE31}' => Some(&['\u{0635}']),
        '\u{1EE32}' => Some(&['\u{0642}']),
        '\u{1EE34}' => Some(&['\u{0634}']),
        '\u{1EE35}' => Some(&['\u{062A}']),
        '\u{1EE36}' => Some(&['\u{062B}']),
        '\u{1EE37}' => Some(&['\u{062E}']),
        '\u{1EE39}' => Some(&['\u{0636}']),
        '\u{1EE3B}' => Some(&['\u{063A}']),
        '\u{1EE42}' => Some(&['\u{062C}']),
        '\u{1EE47}' => Some(&['\u{062D}']),
        '\u{1EE49}' => Some(&['\u{064A}']),
        '\u{1EE4B}' => Some(&['\u{0644}']),
        '\u{1EE4D}' => Some(&['\u{0646}']),
        '\u{1EE4E}' => Some(&['\u{0633}']),
        '\u{1EE4F}' => Some(&['\u{0639}']),
        '\u{1EE51}' => Some(&['\u{0635}']),
        '\u{1EE52}' => Some(&['\u{0642}']),
        '\u{1EE54}' => Some(&['\u{0634}']),
        '\u{1EE57}' => Some(&['\u{062E}']),
        '\u{1EE59}' => Some(&['\u{0636}']),
        '\u{1EE5B}' => Some(&['\u{063A}']),
        '\u{1EE5D}' => Some(&['\u{06BA}']),
        '\u{1EE5F}' => Some(&['\u{066F}']),
        '\u{1EE61}' => Some(&['\u{0628}']),
        '\u{1EE62}' => Some(&['\u{062C}']),
        '\u{1EE64}' => Some(&['\u{0647}']),
        '\u{1EE67}' => Some(&['\u{062D}']),
        '\u{1EE68}' => Some(&['\u{0637}']),
        '\u{1EE69}' => Some(&['\u{064A}']),
        '\u{1EE6A}' => Some(&['\u{0643}']),
        '\u{1EE6C}' => Some(&['\u{0645}']),
        '\u{1EE6D}' => Some(&['\u{0646}']),
        '\u{1EE6E}' => Some(&['\u{0633}']),
        '\u{1EE6F}' => Some(&['\u{0639}']),
        '\u{1EE70}' => Some(&['\u{0641}']),
        '\u{1EE71}' => Some(&['\u{0635}']),
        '\u{1EE72}' => Some(&['\u{0642}']),
        '\u{1EE74}' => Some(&['\u{0634}']),
        '\u{1EE75}' => Some(&['\u{062A}']),
        '\u{1EE76}' => Some(&['\u{062B}']),
        '\u{1EE77}' => Some(&['\u{062E}']),
        '\u{1EE79}' => Some(&['\u{0636}']),
        '\u{1EE7A}' => Some(&['\u{0638}']),
        '\u{1EE7B}' => Some(&['\u{063A}']),
        '\u{1EE7C}' => Some(&['\u{066E}']),
        '\u{1EE7E}' => Some(&['\u{06A1}']),
        '\u{1EE80}' => Some(&['\u{0627}']),
        '\u{1EE81}' => Some(&['\u{0628}']),
        '\u{1EE82}' => Some(&['\u{062C}']),
        '\u{1EE83}' => Some(&['\u{062F}']),
        '\u{1EE84}' => Some(&['\u{0647}']),
        '\u{1EE85}' => Some(&['\u{0648}']),
        '\u{1EE86}' => Some(&['\u{0632}']),
        '\u{1EE87}' => Some(&['\u{062D}']),
        '\u{1EE88}' => Some(&['\u{0637}']),
        '\u{1EE89}' => Some(&['\u{064A}']),
        '\u{1EE8B}' => Some(&['\u{0644}']),
        '\u{1EE8C}' => Some(&['\u{0645}']),
        '\u{1EE8D}' => Some(&['\u{0646}']),
        '\u{1EE8E}' => Some(&['\u{0633}']),
        '\u{1EE8F}' => Some(&['\u{0639}']),
        '\u{1EE90}' => Some(&['\u{0641}']),
        '\u{1EE91}' => Some(&['\u{0635}']),
        '\u{1EE92}' => Some(&['\u{0642}']),
        '\u{1EE93}' => Some(&['\u{0631}']),
        '\u{1EE94}' => Some(&['\u{0634}']),
        '\u{1EE95}' => Some(&['\u{062A}']),
        '\u{1EE96}' => Some(&['\u{062B}']),
        '\u{1EE97}' => Some(&['\u{062E}']),
        '\u{1EE98}' => Some(&['\u{0630}']),
        '\u{1EE99}' => Some(&['\u{0636}']),
        '\u{1EE9A}' => Some(&['\u{0638}']),
        '\u{1EE9B}' => Some(&['\u{063A}']),
        '\u{1EEA1}' => Some(&['\u{0628}']),
        '\u{1EEA2}' => Some(&['\u{062C}']),
        '\u{1EEA3}' => Some(&['\u{062F}']),
        '\u{1EEA5}' => Some(&['\u{0648}']),
        '\u{1EEA6}' => Some(&['\u{0632}']),
        '\u{1EEA7}' => Some(&['\u{062D}']),
        '\u{1EEA8}' => Some(&['\u{0637}']),
        '\u{1EEA9}' => Some(&['\u{064A}']),
        '\u{1EEAB}' => Some(&['\u{0644}']),
        '\u{1EEAC}' => Some(&['\u{0645}']),
        '\u{1EEAD}' => Some(&['\u{0646}']),
        '\u{1EEAE}' => Some(&['\u{0633}']),
        '\u{1EEAF}' => Some(&['\u{0639}']),
        '\u{1EEB0}' => Some(&['\u{0641}']),
        '\u{1EEB1}' => Some(&['\u{0635}']),
        '\u{1EEB2}' => Some(&['\u{0642}']),
        '\u{1EEB3}' => Some(&['\u{0631}']),
        '\u{1EEB4}' => Some(&['\u{0634}']),
        '\u{1EEB5}' => Some(&['\u{062A}']),
        '\u{1EEB6}' => Some(&['\u{062B}']),
        '\u{1EEB7}' => Some(&['\u{062E}']),
        '\u{1EEB8}' => Some(&['\u{0630}']),
        '\u{1EEB9}' => Some(&['\u{0636}']),
        '\u{1EEBA}' => Some(&['\u{0638}']),
        '\u{1EEBB}' => Some(&['\u{063A}']),
        '\u{1F100}' => Some(&['\u{0030}', '\u{002E}']),
        '\u{1F101}' => Some(&['\u{0030}', '\u{002C}']),
        '\u{1F102}' => Some(&['\u{0031}', '\u{002C}']),
        '\u{1F103}' => Some(&['\u{0032}', '\u{002C}']),
        '\u{1F104}' => Some(&['\u{0033}', '\u{002C}']),
        '\u{1F105}' => Some(&['\u{0034}', '\u{002C}']),
        '\u{1F106}' => Some(&['\u{0035}', '\u{002C}']),
        '\u{1F107}' => Some(&['\u{0036}', '\u{002C}']),
        '\u{1F108}' => Some(&['\u{0037}', '\u{002C}']),
        '\u{1F109}' => Some(&['\u{0038}', '\u{002C}']),
        '\u{1F10A}' => Some(&['\u{0039}', '\u{002C}']),
        '\u{1F110}' => Some(&['\u{0028}', '\u{0041}', '\u{0029}']),
        '\u{1F111}' => Some(&['\u{0028}', '\u{0042}', '\u{0029}']),
        '\u{1F112}' => Some(&['\u{0028}', '\u{0043}', '\u{0029}']),
        '\u{1F113}' => Some(&['\u{0028}', '\u{0044}', '\u{0029}']),
        '\u{1F114}' => Some(&['\u{0028}', '\u{0045}', '\u{0029}']),
        '\u{1F115}' => Some(&['\u{0028}', '\u{0046}', '\u{0029}']),
        '\u{1F116}' => Some(&['\u{0028}', '\u{0047}', '\u{0029}']),
        '\u{1F117}' => Some(&['\u{0028}', '\u{0048}', '\u{0029}']),
        '\u{1F118}' => Some(&['\u{0028}', '\u{0049}', '\u{0029}']),
        '\u{1F119}' => Some(&['\u{0028}', '\u{004A}', '\u{0029}']),
        '\u{1F11A}' => Some(&['\u{0028}', '\u{004B}', '\u{0029}']),
        '\u{1F11B}' => Some(&['\u{0028}', '\u{004C}', '\u{0029}']),
        '\u{1F11C}' => Some(&['\u{0028}', '\u{004D}', '\u{0029}']),
        '\u{1F11D}' => Some(&['\u{0028}', '\u{004E}', '\u{0029}']),
        '\u{1F11E}' => Some(&['\u{0028}', '\u{004F}', '\u{0029}']),
        '\u{1F11F}' => Some(&['\u{0028}', '\u{0050}', '\u{0029}']),
        '\u{1F120}' => Some(&['\u{0028}', '\u{0051}', '\u{0029}']),
        '\u{1F121}' => Some(&['\u{0028}', '\u{0052}', '\u{0029}']),
        '\u{1F122}' => Some(&['\u{0028}', '\u{0053}', '\u{0029}']),
        '\u{1F123}' => Some(&['\u{0028}', '\u{0054}', '\u{0029}']),
        '\u{1F124}' => Some(&['\u{0028}', '\u{0055}', '\u{0029}']),
        '\u{1F125}' => Some(&['\u{0028}', '\u{0056}', '\u{0029}']),
        '\u{1F126}' => Some(&['\u{0028}', '\u{0057}', '\u{0029}']),
        '\u{1F127}' => Some(&['\u{0028}', '\u{0058}', '\u{0029}']),
        '\u{1F128}' => Some(&['\u{0028}', '\u{0059}', '\u{0029}']),
        '\u{1F129}' => Some(&['\u{0028}', '\u{005A}', '\u{0029}']),
        '\u{1F12A}' => Some(&['\u{3014}', '\u{0053}', '\u{3015}']),
        '\u{1F12B}' => Some(&['\u{0043}']),
        '\u{1F12C}' => Some(&['\u{0052}']),
        '\u{1F12D}' => Some(&['\u{0043}', '\u{0044}']),
        '\u{1F12E}' => Some(&['\u{0057}', '\u{005A}']),
        '\u{1F130}' => Some(&['\u{0041}']),
        '\u{1F131}' => Some(&['\u{0042}']),
        '\u{1F132}' => Some(&['\u{0043}']),
        '\u{1F133}' => Some(&['\u{0044}']),
        '\u{1F134}' => Some(&['\u{0045}']),
        '\u{1F135}' => Some(&['\u{0046}']),
        '\u{1F136}' => Some(&['\u{0047}']),
        '\u{1F137}' => Some(&['\u{0048}']),
        '\u{1F138}' => Some(&['\u{0049}']),
        '\u{1F139}' => Some(&['\u{004A}']),
        '\u{1F13A}' => Some(&['\u{004B}']),
        '\u{1F13B}' => Some(&['\u{004C}']),
        '\u{1F13C}' => Some(&['\u{004D}']),
        '\u{1F13D}' => Some(&['\u{004E}']),
        '\u{1F13E}' => Some(&['\u{004F}']),
        '\u{1F13F}' => Some(&['\u{0050}']),
        '\u{1F140}' => Some(&['\u{0051}']),
        '\u{1F141}' => Some(&['\u{0052}']),
        '\u{1F142}' => Some(&['\u{0053}']),
        '\u{1F143}' => Some(&['\u{0054}']),
        '\u{1F144}' => Some(&['\u{0055}']),
        '\u{1F145}' => Some(&['\u{0056}']),
        '\u{1F146}' => Some(&['\u{0057}']),
        '\u{1F147}' => Some(&['\u{0058}']),
        '\u{1F148}' => Some(&['\u{0059}']),
        '\u{1F149}' => Some(&['\u{005A}']),
        '\u{1F14A}' => Some(&['\u{0048}', '\u{0056}']),
        '\u{1F14B}' => Some(&['\u{004D}', '\u{0056}']),
        '\u{1F14C}' => Some(&['\u{0053}', '\u{0044}']),
        '\u{1F14D}' => Some(&['\u{0053}', '\u{0053}']),
        '\u{1F14E}' => Some(&['\u{0050}', '\u{0050}', '\u{0056}']),
        '\u{1F14F}' => Some(&['\u{0057}', '\u{0043}']),
        '\u{1F16A}' => Some(&['\u{004D}', '\u{0043}']),
        '\u{1F16B}' => Some(&['\u{004D}', '\u{0044}']),
        '\u{1F190}' => Some(&['\u{0044}', '\u{004A}']),
        '\u{1F200}' => Some(&['\u{307B}', '\u{304B}']),
        '\u{1F201}' => Some(&['\u{30B3}', '\u{30B3}']),
        '\u{1F202}' => Some(&['\u{30B5}']),
        '\u{1F210}' => Some(&['\u{624B}']),
        '\u{1F211}' => Some(&['\u{5B57}']),
        '\u{1F212}' => Some(&['\u{53CC}']),
        '\u{1F213}' => Some(&['\u{30C6}', '\u{3099}']),
        '\u{1F214}' => Some(&['\u{4E8C}']),
        '\u{1F215}' => Some(&['\u{591A}']),
        '\u{1F216}' => Some(&['\u{89E3}']),
        '\u{1F217}' => Some(&['\u{5929}']),
        '\u{1F218}' => Some(&['\u{4EA4}']),
        '\u{1F219}' => Some(&['\u{6620}']),
        '\u{1F21A}' => Some(&['\u{7121}']),
        '\u{1F21B}' => Some(&['\u{6599}']),
        '\u{1F21C}' => Some(&['\u{524D}']),
        '\u{1F21D}' => Some(&['\u{5F8C}']),
        '\u{1F21E}' => Some(&['\u{518D}']),
        '\u{1F21F}' => Some(&['\u{65B0}']),
        '\u{1F220}' => Some(&['\u{521D}']),
        '\u{1F221}' => Some(&['\u{7D42}']),
        '\u{1F222}' => Some(&['\u{751F}']),
        '\u{1F223}' => Some(&['\u{8CA9}']),
        '\u{1F224}' => Some(&['\u{58F0}']),
        '\u{1F225}' => Some(&['\u{5439}']),
        '\u{1F226}' => Some(&['\u{6F14}']),
        '\u{1F227}' => Some(&['\u{6295}']),
        '\u{1F228}' => Some(&['\u{6355}']),
        '\u{1F229}' => Some(&['\u{4E00}']),
        '\u{1F22A}' => Some(&['\u{4E09}']),
        '\u{1F22B}' => Some(&['\u{904A}']),
        '\u{1F22C}' => Some(&['\u{5DE6}']),
        '\u{1F22D}' => Some(&['\u{4E2D}']),
        '\u{1F22E}' => Some(&['\u{53F3}']),
        '\u{1F22F}' => Some(&['\u{6307}']),
        '\u{1F230}' => Some(&['\u{8D70}']),
        '\u{1F231}' => Some(&['\u{6253}']),
        '\u{1F232}' => Some(&['\u{7981}']),
        '\u{1F233}' => Some(&['\u{7A7A}']),
        '\u{1F234}' => Some(&['\u{5408}']),
        '\u{1F235}' => Some(&['\u{6E80}']),
        '\u{1F236}' => Some(&['\u{6709}']),
        '\u{1F237}' => Some(&['\u{6708}']),
        '\u{1F238}' => Some(&['\u{7533}']),
        '\u{1F239}' => Some(&['\u{5272}']),
        '\u{1F23A}' => Some(&['\u{55B6}']),
        '\u{1F23B}' => Some(&['\u{914D}']),
        '\u{1F240}' => Some(&['\u{3014}', '\u{672C}', '\u{3015}']),
        '\u{1F241}' => Some(&['\u{3014}', '\u{4E09}', '\u{3015}']),
        '\u{1F242}' => Some(&['\u{3014}', '\u{4E8C}', '\u{3015}']),
        '\u{1F243}' => Some(&['\u{3014}', '\u{5B89}', '\u{3015}']),
        '\u{1F244}' => Some(&['\u{3014}', '\u{70B9}', '\u{3015}']),
        '\u{1F245}' => Some(&['\u{3014}', '\u{6253}', '\u{3015}']),
        '\u{1F246}' => Some(&['\u{3014}', '\u{76D7}', '\u{3015}']),
        '\u{1F247}' => Some(&['\u{3014}', '\u{52DD}', '\u{3015}']),
        '\u{1F248}' => Some(&['\u{3014}', '\u{6557}', '\u{3015}']),
        '\u{1F250}' => Some(&['\u{5F97}']),
        '\u{1F251}' => Some(&['\u{53EF}']),
        _ => None,
    }
}

#[inline]
pub fn is_combining_mark(c: char) -> bool {
    match c {
        '\u{0300}' => true,
        '\u{0301}' => true,
        '\u{0302}' => true,
        '\u{0303}' => true,
        '\u{0304}' => true,
        '\u{0305}' => true,
        '\u{0306}' => true,
        '\u{0307}' => true,
        '\u{0308}' => true,
        '\u{0309}' => true,
        '\u{030A}' => true,
        '\u{030B}' => true,
        '\u{030C}' => true,
        '\u{030D}' => true,
        '\u{030E}' => true,
        '\u{030F}' => true,
        '\u{0310}' => true,
        '\u{0311}' => true,
        '\u{0312}' => true,
        '\u{0313}' => true,
        '\u{0314}' => true,
        '\u{0315}' => true,
        '\u{0316}' => true,
        '\u{0317}' => true,
        '\u{0318}' => true,
        '\u{0319}' => true,
        '\u{031A}' => true,
        '\u{031B}' => true,
        '\u{031C}' => true,
        '\u{031D}' => true,
        '\u{031E}' => true,
        '\u{031F}' => true,
        '\u{0320}' => true,
        '\u{0321}' => true,
        '\u{0322}' => true,
        '\u{0323}' => true,
        '\u{0324}' => true,
        '\u{0325}' => true,
        '\u{0326}' => true,
        '\u{0327}' => true,
        '\u{0328}' => true,
        '\u{0329}' => true,
        '\u{032A}' => true,
        '\u{032B}' => true,
        '\u{032C}' => true,
        '\u{032D}' => true,
        '\u{032E}' => true,
        '\u{032F}' => true,
        '\u{0330}' => true,
        '\u{0331}' => true,
        '\u{0332}' => true,
        '\u{0333}' => true,
        '\u{0334}' => true,
        '\u{0335}' => true,
        '\u{0336}' => true,
        '\u{0337}' => true,
        '\u{0338}' => true,
        '\u{0339}' => true,
        '\u{033A}' => true,
        '\u{033B}' => true,
        '\u{033C}' => true,
        '\u{033D}' => true,
        '\u{033E}' => true,
        '\u{033F}' => true,
        '\u{0340}' => true,
        '\u{0341}' => true,
        '\u{0342}' => true,
        '\u{0343}' => true,
        '\u{0344}' => true,
        '\u{0345}' => true,
        '\u{0346}' => true,
        '\u{0347}' => true,
        '\u{0348}' => true,
        '\u{0349}' => true,
        '\u{034A}' => true,
        '\u{034B}' => true,
        '\u{034C}' => true,
        '\u{034D}' => true,
        '\u{034E}' => true,
        '\u{034F}' => true,
        '\u{0350}' => true,
        '\u{0351}' => true,
        '\u{0352}' => true,
        '\u{0353}' => true,
        '\u{0354}' => true,
        '\u{0355}' => true,
        '\u{0356}' => true,
        '\u{0357}' => true,
        '\u{0358}' => true,
        '\u{0359}' => true,
        '\u{035A}' => true,
        '\u{035B}' => true,
        '\u{035C}' => true,
        '\u{035D}' => true,
        '\u{035E}' => true,
        '\u{035F}' => true,
        '\u{0360}' => true,
        '\u{0361}' => true,
        '\u{0362}' => true,
        '\u{0363}' => true,
        '\u{0364}' => true,
        '\u{0365}' => true,
        '\u{0366}' => true,
        '\u{0367}' => true,
        '\u{0368}' => true,
        '\u{0369}' => true,
        '\u{036A}' => true,
        '\u{036B}' => true,
        '\u{036C}' => true,
        '\u{036D}' => true,
        '\u{036E}' => true,
        '\u{036F}' => true,
        '\u{0483}' => true,
        '\u{0484}' => true,
        '\u{0485}' => true,
        '\u{0486}' => true,
        '\u{0487}' => true,
        '\u{0488}' => true,
        '\u{0489}' => true,
        '\u{0591}' => true,
        '\u{0592}' => true,
        '\u{0593}' => true,
        '\u{0594}' => true,
        '\u{0595}' => true,
        '\u{0596}' => true,
        '\u{0597}' => true,
        '\u{0598}' => true,
        '\u{0599}' => true,
        '\u{059A}' => true,
        '\u{059B}' => true,
        '\u{059C}' => true,
        '\u{059D}' => true,
        '\u{059E}' => true,
        '\u{059F}' => true,
        '\u{05A0}' => true,
        '\u{05A1}' => true,
        '\u{05A2}' => true,
        '\u{05A3}' => true,
        '\u{05A4}' => true,
        '\u{05A5}' => true,
        '\u{05A6}' => true,
        '\u{05A7}' => true,
        '\u{05A8}' => true,
        '\u{05A9}' => true,
        '\u{05AA}' => true,
        '\u{05AB}' => true,
        '\u{05AC}' => true,
        '\u{05AD}' => true,
        '\u{05AE}' => true,
        '\u{05AF}' => true,
        '\u{05B0}' => true,
        '\u{05B1}' => true,
        '\u{05B2}' => true,
        '\u{05B3}' => true,
        '\u{05B4}' => true,
        '\u{05B5}' => true,
        '\u{05B6}' => true,
        '\u{05B7}' => true,
        '\u{05B8}' => true,
        '\u{05B9}' => true,
        '\u{05BA}' => true,
        '\u{05BB}' => true,
        '\u{05BC}' => true,
        '\u{05BD}' => true,
        '\u{05BF}' => true,
        '\u{05C1}' => true,
        '\u{05C2}' => true,
        '\u{05C4}' => true,
        '\u{05C5}' => true,
        '\u{05C7}' => true,
        '\u{0610}' => true,
        '\u{0611}' => true,
        '\u{0612}' => true,
        '\u{0613}' => true,
        '\u{0614}' => true,
        '\u{0615}' => true,
        '\u{0616}' => true,
        '\u{0617}' => true,
        '\u{0618}' => true,
        '\u{0619}' => true,
        '\u{061A}' => true,
        '\u{064B}' => true,
        '\u{064C}' => true,
        '\u{064D}' => true,
        '\u{064E}' => true,
        '\u{064F}' => true,
        '\u{0650}' => true,
        '\u{0651}' => true,
        '\u{0652}' => true,
        '\u{0653}' => true,
        '\u{0654}' => true,
        '\u{0655}' => true,
        '\u{0656}' => true,
        '\u{0657}' => true,
        '\u{0658}' => true,
        '\u{0659}' => true,
        '\u{065A}' => true,
        '\u{065B}' => true,
        '\u{065C}' => true,
        '\u{065D}' => true,
        '\u{065E}' => true,
        '\u{065F}' => true,
        '\u{0670}' => true,
        '\u{06D6}' => true,
        '\u{06D7}' => true,
        '\u{06D8}' => true,
        '\u{06D9}' => true,
        '\u{06DA}' => true,
        '\u{06DB}' => true,
        '\u{06DC}' => true,
        '\u{06DF}' => true,
        '\u{06E0}' => true,
        '\u{06E1}' => true,
        '\u{06E2}' => true,
        '\u{06E3}' => true,
        '\u{06E4}' => true,
        '\u{06E7}' => true,
        '\u{06E8}' => true,
        '\u{06EA}' => true,
        '\u{06EB}' => true,
        '\u{06EC}' => true,
        '\u{06ED}' => true,
        '\u{0711}' => true,
        '\u{0730}' => true,
        '\u{0731}' => true,
        '\u{0732}' => true,
        '\u{0733}' => true,
        '\u{0734}' => true,
        '\u{0735}' => true,
        '\u{0736}' => true,
        '\u{0737}' => true,
        '\u{0738}' => true,
        '\u{0739}' => true,
        '\u{073A}' => true,
        '\u{073B}' => true,
        '\u{073C}' => true,
        '\u{073D}' => true,
        '\u{073E}' => true,
        '\u{073F}' => true,
        '\u{0740}' => true,
        '\u{0741}' => true,
        '\u{0742}' => true,
        '\u{0743}' => true,
        '\u{0744}' => true,
        '\u{0745}' => true,
        '\u{0746}' => true,
        '\u{0747}' => true,
        '\u{0748}' => true,
        '\u{0749}' => true,
        '\u{074A}' => true,
        '\u{07A6}' => true,
        '\u{07A7}' => true,
        '\u{07A8}' => true,
        '\u{07A9}' => true,
        '\u{07AA}' => true,
        '\u{07AB}' => true,
        '\u{07AC}' => true,
        '\u{07AD}' => true,
        '\u{07AE}' => true,
        '\u{07AF}' => true,
        '\u{07B0}' => true,
        '\u{07EB}' => true,
        '\u{07EC}' => true,
        '\u{07ED}' => true,
        '\u{07EE}' => true,
        '\u{07EF}' => true,
        '\u{07F0}' => true,
        '\u{07F1}' => true,
        '\u{07F2}' => true,
        '\u{07F3}' => true,
        '\u{0816}' => true,
        '\u{0817}' => true,
        '\u{0818}' => true,
        '\u{0819}' => true,
        '\u{081B}' => true,
        '\u{081C}' => true,
        '\u{081D}' => true,
        '\u{081E}' => true,
        '\u{081F}' => true,
        '\u{0820}' => true,
        '\u{0821}' => true,
        '\u{0822}' => true,
        '\u{0823}' => true,
        '\u{0825}' => true,
        '\u{0826}' => true,
        '\u{0827}' => true,
        '\u{0829}' => true,
        '\u{082A}' => true,
        '\u{082B}' => true,
        '\u{082C}' => true,
        '\u{082D}' => true,
        '\u{0859}' => true,
        '\u{085A}' => true,
        '\u{085B}' => true,
        '\u{08D4}' => true,
        '\u{08D5}' => true,
        '\u{08D6}' => true,
        '\u{08D7}' => true,
        '\u{08D8}' => true,
        '\u{08D9}' => true,
        '\u{08DA}' => true,
        '\u{08DB}' => true,
        '\u{08DC}' => true,
        '\u{08DD}' => true,
        '\u{08DE}' => true,
        '\u{08DF}' => true,
        '\u{08E0}' => true,
        '\u{08E1}' => true,
        '\u{08E3}' => true,
        '\u{08E4}' => true,
        '\u{08E5}' => true,
        '\u{08E6}' => true,
        '\u{08E7}' => true,
        '\u{08E8}' => true,
        '\u{08E9}' => true,
        '\u{08EA}' => true,
        '\u{08EB}' => true,
        '\u{08EC}' => true,
        '\u{08ED}' => true,
        '\u{08EE}' => true,
        '\u{08EF}' => true,
        '\u{08F0}' => true,
        '\u{08F1}' => true,
        '\u{08F2}' => true,
        '\u{08F3}' => true,
        '\u{08F4}' => true,
        '\u{08F5}' => true,
        '\u{08F6}' => true,
        '\u{08F7}' => true,
        '\u{08F8}' => true,
        '\u{08F9}' => true,
        '\u{08FA}' => true,
        '\u{08FB}' => true,
        '\u{08FC}' => true,
        '\u{08FD}' => true,
        '\u{08FE}' => true,
        '\u{08FF}' => true,
        '\u{0900}' => true,
        '\u{0901}' => true,
        '\u{0902}' => true,
        '\u{0903}' => true,
        '\u{093A}' => true,
        '\u{093B}' => true,
        '\u{093C}' => true,
        '\u{093E}' => true,
        '\u{093F}' => true,
        '\u{0940}' => true,
        '\u{0941}' => true,
        '\u{0942}' => true,
        '\u{0943}' => true,
        '\u{0944}' => true,
        '\u{0945}' => true,
        '\u{0946}' => true,
        '\u{0947}' => true,
        '\u{0948}' => true,
        '\u{0949}' => true,
        '\u{094A}' => true,
        '\u{094B}' => true,
        '\u{094C}' => true,
        '\u{094D}' => true,
        '\u{094E}' => true,
        '\u{094F}' => true,
        '\u{0951}' => true,
        '\u{0952}' => true,
        '\u{0953}' => true,
        '\u{0954}' => true,
        '\u{0955}' => true,
        '\u{0956}' => true,
        '\u{0957}' => true,
        '\u{0962}' => true,
        '\u{0963}' => true,
        '\u{0981}' => true,
        '\u{0982}' => true,
        '\u{0983}' => true,
        '\u{09BC}' => true,
        '\u{09BE}' => true,
        '\u{09BF}' => true,
        '\u{09C0}' => true,
        '\u{09C1}' => true,
        '\u{09C2}' => true,
        '\u{09C3}' => true,
        '\u{09C4}' => true,
        '\u{09C7}' => true,
        '\u{09C8}' => true,
        '\u{09CB}' => true,
        '\u{09CC}' => true,
        '\u{09CD}' => true,
        '\u{09D7}' => true,
        '\u{09E2}' => true,
        '\u{09E3}' => true,
        '\u{0A01}' => true,
        '\u{0A02}' => true,
        '\u{0A03}' => true,
        '\u{0A3C}' => true,
        '\u{0A3E}' => true,
        '\u{0A3F}' => true,
        '\u{0A40}' => true,
        '\u{0A41}' => true,
        '\u{0A42}' => true,
        '\u{0A47}' => true,
        '\u{0A48}' => true,
        '\u{0A4B}' => true,
        '\u{0A4C}' => true,
        '\u{0A4D}' => true,
        '\u{0A51}' => true,
        '\u{0A70}' => true,
        '\u{0A71}' => true,
        '\u{0A75}' => true,
        '\u{0A81}' => true,
        '\u{0A82}' => true,
        '\u{0A83}' => true,
        '\u{0ABC}' => true,
        '\u{0ABE}' => true,
        '\u{0ABF}' => true,
        '\u{0AC0}' => true,
        '\u{0AC1}' => true,
        '\u{0AC2}' => true,
        '\u{0AC3}' => true,
        '\u{0AC4}' => true,
        '\u{0AC5}' => true,
        '\u{0AC7}' => true,
        '\u{0AC8}' => true,
        '\u{0AC9}' => true,
        '\u{0ACB}' => true,
        '\u{0ACC}' => true,
        '\u{0ACD}' => true,
        '\u{0AE2}' => true,
        '\u{0AE3}' => true,
        '\u{0B01}' => true,
        '\u{0B02}' => true,
        '\u{0B03}' => true,
        '\u{0B3C}' => true,
        '\u{0B3E}' => true,
        '\u{0B3F}' => true,
        '\u{0B40}' => true,
        '\u{0B41}' => true,
        '\u{0B42}' => true,
        '\u{0B43}' => true,
        '\u{0B44}' => true,
        '\u{0B47}' => true,
        '\u{0B48}' => true,
        '\u{0B4B}' => true,
        '\u{0B4C}' => true,
        '\u{0B4D}' => true,
        '\u{0B56}' => true,
        '\u{0B57}' => true,
        '\u{0B62}' => true,
        '\u{0B63}' => true,
        '\u{0B82}' => true,
        '\u{0BBE}' => true,
        '\u{0BBF}' => true,
        '\u{0BC0}' => true,
        '\u{0BC1}' => true,
        '\u{0BC2}' => true,
        '\u{0BC6}' => true,
        '\u{0BC7}' => true,
        '\u{0BC8}' => true,
        '\u{0BCA}' => true,
        '\u{0BCB}' => true,
        '\u{0BCC}' => true,
        '\u{0BCD}' => true,
        '\u{0BD7}' => true,
        '\u{0C00}' => true,
        '\u{0C01}' => true,
        '\u{0C02}' => true,
        '\u{0C03}' => true,
        '\u{0C3E}' => true,
        '\u{0C3F}' => true,
        '\u{0C40}' => true,
        '\u{0C41}' => true,
        '\u{0C42}' => true,
        '\u{0C43}' => true,
        '\u{0C44}' => true,
        '\u{0C46}' => true,
        '\u{0C47}' => true,
        '\u{0C48}' => true,
        '\u{0C4A}' => true,
        '\u{0C4B}' => true,
        '\u{0C4C}' => true,
        '\u{0C4D}' => true,
        '\u{0C55}' => true,
        '\u{0C56}' => true,
        '\u{0C62}' => true,
        '\u{0C63}' => true,
        '\u{0C81}' => true,
        '\u{0C82}' => true,
        '\u{0C83}' => true,
        '\u{0CBC}' => true,
        '\u{0CBE}' => true,
        '\u{0CBF}' => true,
        '\u{0CC0}' => true,
        '\u{0CC1}' => true,
        '\u{0CC2}' => true,
        '\u{0CC3}' => true,
        '\u{0CC4}' => true,
        '\u{0CC6}' => true,
        '\u{0CC7}' => true,
        '\u{0CC8}' => true,
        '\u{0CCA}' => true,
        '\u{0CCB}' => true,
        '\u{0CCC}' => true,
        '\u{0CCD}' => true,
        '\u{0CD5}' => true,
        '\u{0CD6}' => true,
        '\u{0CE2}' => true,
        '\u{0CE3}' => true,
        '\u{0D01}' => true,
        '\u{0D02}' => true,
        '\u{0D03}' => true,
        '\u{0D3E}' => true,
        '\u{0D3F}' => true,
        '\u{0D40}' => true,
        '\u{0D41}' => true,
        '\u{0D42}' => true,
        '\u{0D43}' => true,
        '\u{0D44}' => true,
        '\u{0D46}' => true,
        '\u{0D47}' => true,
        '\u{0D48}' => true,
        '\u{0D4A}' => true,
        '\u{0D4B}' => true,
        '\u{0D4C}' => true,
        '\u{0D4D}' => true,
        '\u{0D57}' => true,
        '\u{0D62}' => true,
        '\u{0D63}' => true,
        '\u{0D82}' => true,
        '\u{0D83}' => true,
        '\u{0DCA}' => true,
        '\u{0DCF}' => true,
        '\u{0DD0}' => true,
        '\u{0DD1}' => true,
        '\u{0DD2}' => true,
        '\u{0DD3}' => true,
        '\u{0DD4}' => true,
        '\u{0DD6}' => true,
        '\u{0DD8}' => true,
        '\u{0DD9}' => true,
        '\u{0DDA}' => true,
        '\u{0DDB}' => true,
        '\u{0DDC}' => true,
        '\u{0DDD}' => true,
        '\u{0DDE}' => true,
        '\u{0DDF}' => true,
        '\u{0DF2}' => true,
        '\u{0DF3}' => true,
        '\u{0E31}' => true,
        '\u{0E34}' => true,
        '\u{0E35}' => true,
        '\u{0E36}' => true,
        '\u{0E37}' => true,
        '\u{0E38}' => true,
        '\u{0E39}' => true,
        '\u{0E3A}' => true,
        '\u{0E47}' => true,
        '\u{0E48}' => true,
        '\u{0E49}' => true,
        '\u{0E4A}' => true,
        '\u{0E4B}' => true,
        '\u{0E4C}' => true,
        '\u{0E4D}' => true,
        '\u{0E4E}' => true,
        '\u{0EB1}' => true,
        '\u{0EB4}' => true,
        '\u{0EB5}' => true,
        '\u{0EB6}' => true,
        '\u{0EB7}' => true,
        '\u{0EB8}' => true,
        '\u{0EB9}' => true,
        '\u{0EBB}' => true,
        '\u{0EBC}' => true,
        '\u{0EC8}' => true,
        '\u{0EC9}' => true,
        '\u{0ECA}' => true,
        '\u{0ECB}' => true,
        '\u{0ECC}' => true,
        '\u{0ECD}' => true,
        '\u{0F18}' => true,
        '\u{0F19}' => true,
        '\u{0F35}' => true,
        '\u{0F37}' => true,
        '\u{0F39}' => true,
        '\u{0F3E}' => true,
        '\u{0F3F}' => true,
        '\u{0F71}' => true,
        '\u{0F72}' => true,
        '\u{0F73}' => true,
        '\u{0F74}' => true,
        '\u{0F75}' => true,
        '\u{0F76}' => true,
        '\u{0F77}' => true,
        '\u{0F78}' => true,
        '\u{0F79}' => true,
        '\u{0F7A}' => true,
        '\u{0F7B}' => true,
        '\u{0F7C}' => true,
        '\u{0F7D}' => true,
        '\u{0F7E}' => true,
        '\u{0F7F}' => true,
        '\u{0F80}' => true,
        '\u{0F81}' => true,
        '\u{0F82}' => true,
        '\u{0F83}' => true,
        '\u{0F84}' => true,
        '\u{0F86}' => true,
        '\u{0F87}' => true,
        '\u{0F8D}' => true,
        '\u{0F8E}' => true,
        '\u{0F8F}' => true,
        '\u{0F90}' => true,
        '\u{0F91}' => true,
        '\u{0F92}' => true,
        '\u{0F93}' => true,
        '\u{0F94}' => true,
        '\u{0F95}' => true,
        '\u{0F96}' => true,
        '\u{0F97}' => true,
        '\u{0F99}' => true,
        '\u{0F9A}' => true,
        '\u{0F9B}' => true,
        '\u{0F9C}' => true,
        '\u{0F9D}' => true,
        '\u{0F9E}' => true,
        '\u{0F9F}' => true,
        '\u{0FA0}' => true,
        '\u{0FA1}' => true,
        '\u{0FA2}' => true,
        '\u{0FA3}' => true,
        '\u{0FA4}' => true,
        '\u{0FA5}' => true,
        '\u{0FA6}' => true,
        '\u{0FA7}' => true,
        '\u{0FA8}' => true,
        '\u{0FA9}' => true,
        '\u{0FAA}' => true,
        '\u{0FAB}' => true,
        '\u{0FAC}' => true,
        '\u{0FAD}' => true,
        '\u{0FAE}' => true,
        '\u{0FAF}' => true,
        '\u{0FB0}' => true,
        '\u{0FB1}' => true,
        '\u{0FB2}' => true,
        '\u{0FB3}' => true,
        '\u{0FB4}' => true,
        '\u{0FB5}' => true,
        '\u{0FB6}' => true,
        '\u{0FB7}' => true,
        '\u{0FB8}' => true,
        '\u{0FB9}' => true,
        '\u{0FBA}' => true,
        '\u{0FBB}' => true,
        '\u{0FBC}' => true,
        '\u{0FC6}' => true,
        '\u{102B}' => true,
        '\u{102C}' => true,
        '\u{102D}' => true,
        '\u{102E}' => true,
        '\u{102F}' => true,
        '\u{1030}' => true,
        '\u{1031}' => true,
        '\u{1032}' => true,
        '\u{1033}' => true,
        '\u{1034}' => true,
        '\u{1035}' => true,
        '\u{1036}' => true,
        '\u{1037}' => true,
        '\u{1038}' => true,
        '\u{1039}' => true,
        '\u{103A}' => true,
        '\u{103B}' => true,
        '\u{103C}' => true,
        '\u{103D}' => true,
        '\u{103E}' => true,
        '\u{1056}' => true,
        '\u{1057}' => true,
        '\u{1058}' => true,
        '\u{1059}' => true,
        '\u{105E}' => true,
        '\u{105F}' => true,
        '\u{1060}' => true,
        '\u{1062}' => true,
        '\u{1063}' => true,
        '\u{1064}' => true,
        '\u{1067}' => true,
        '\u{1068}' => true,
        '\u{1069}' => true,
        '\u{106A}' => true,
        '\u{106B}' => true,
        '\u{106C}' => true,
        '\u{106D}' => true,
        '\u{1071}' => true,
        '\u{1072}' => true,
        '\u{1073}' => true,
        '\u{1074}' => true,
        '\u{1082}' => true,
        '\u{1083}' => true,
        '\u{1084}' => true,
        '\u{1085}' => true,
        '\u{1086}' => true,
        '\u{1087}' => true,
        '\u{1088}' => true,
        '\u{1089}' => true,
        '\u{108A}' => true,
        '\u{108B}' => true,
        '\u{108C}' => true,
        '\u{108D}' => true,
        '\u{108F}' => true,
        '\u{109A}' => true,
        '\u{109B}' => true,
        '\u{109C}' => true,
        '\u{109D}' => true,
        '\u{135D}' => true,
        '\u{135E}' => true,
        '\u{135F}' => true,
        '\u{1712}' => true,
        '\u{1713}' => true,
        '\u{1714}' => true,
        '\u{1732}' => true,
        '\u{1733}' => true,
        '\u{1734}' => true,
        '\u{1752}' => true,
        '\u{1753}' => true,
        '\u{1772}' => true,
        '\u{1773}' => true,
        '\u{17B4}' => true,
        '\u{17B5}' => true,
        '\u{17B6}' => true,
        '\u{17B7}' => true,
        '\u{17B8}' => true,
        '\u{17B9}' => true,
        '\u{17BA}' => true,
        '\u{17BB}' => true,
        '\u{17BC}' => true,
        '\u{17BD}' => true,
        '\u{17BE}' => true,
        '\u{17BF}' => true,
        '\u{17C0}' => true,
        '\u{17C1}' => true,
        '\u{17C2}' => true,
        '\u{17C3}' => true,
        '\u{17C4}' => true,
        '\u{17C5}' => true,
        '\u{17C6}' => true,
        '\u{17C7}' => true,
        '\u{17C8}' => true,
        '\u{17C9}' => true,
        '\u{17CA}' => true,
        '\u{17CB}' => true,
        '\u{17CC}' => true,
        '\u{17CD}' => true,
        '\u{17CE}' => true,
        '\u{17CF}' => true,
        '\u{17D0}' => true,
        '\u{17D1}' => true,
        '\u{17D2}' => true,
        '\u{17D3}' => true,
        '\u{17DD}' => true,
        '\u{180B}' => true,
        '\u{180C}' => true,
        '\u{180D}' => true,
        '\u{1885}' => true,
        '\u{1886}' => true,
        '\u{18A9}' => true,
        '\u{1920}' => true,
        '\u{1921}' => true,
        '\u{1922}' => true,
        '\u{1923}' => true,
        '\u{1924}' => true,
        '\u{1925}' => true,
        '\u{1926}' => true,
        '\u{1927}' => true,
        '\u{1928}' => true,
        '\u{1929}' => true,
        '\u{192A}' => true,
        '\u{192B}' => true,
        '\u{1930}' => true,
        '\u{1931}' => true,
        '\u{1932}' => true,
        '\u{1933}' => true,
        '\u{1934}' => true,
        '\u{1935}' => true,
        '\u{1936}' => true,
        '\u{1937}' => true,
        '\u{1938}' => true,
        '\u{1939}' => true,
        '\u{193A}' => true,
        '\u{193B}' => true,
        '\u{1A17}' => true,
        '\u{1A18}' => true,
        '\u{1A19}' => true,
        '\u{1A1A}' => true,
        '\u{1A1B}' => true,
        '\u{1A55}' => true,
        '\u{1A56}' => true,
        '\u{1A57}' => true,
        '\u{1A58}' => true,
        '\u{1A59}' => true,
        '\u{1A5A}' => true,
        '\u{1A5B}' => true,
        '\u{1A5C}' => true,
        '\u{1A5D}' => true,
        '\u{1A5E}' => true,
        '\u{1A60}' => true,
        '\u{1A61}' => true,
        '\u{1A62}' => true,
        '\u{1A63}' => true,
        '\u{1A64}' => true,
        '\u{1A65}' => true,
        '\u{1A66}' => true,
        '\u{1A67}' => true,
        '\u{1A68}' => true,
        '\u{1A69}' => true,
        '\u{1A6A}' => true,
        '\u{1A6B}' => true,
        '\u{1A6C}' => true,
        '\u{1A6D}' => true,
        '\u{1A6E}' => true,
        '\u{1A6F}' => true,
        '\u{1A70}' => true,
        '\u{1A71}' => true,
        '\u{1A72}' => true,
        '\u{1A73}' => true,
        '\u{1A74}' => true,
        '\u{1A75}' => true,
        '\u{1A76}' => true,
        '\u{1A77}' => true,
        '\u{1A78}' => true,
        '\u{1A79}' => true,
        '\u{1A7A}' => true,
        '\u{1A7B}' => true,
        '\u{1A7C}' => true,
        '\u{1A7F}' => true,
        '\u{1AB0}' => true,
        '\u{1AB1}' => true,
        '\u{1AB2}' => true,
        '\u{1AB3}' => true,
        '\u{1AB4}' => true,
        '\u{1AB5}' => true,
        '\u{1AB6}' => true,
        '\u{1AB7}' => true,
        '\u{1AB8}' => true,
        '\u{1AB9}' => true,
        '\u{1ABA}' => true,
        '\u{1ABB}' => true,
        '\u{1ABC}' => true,
        '\u{1ABD}' => true,
        '\u{1ABE}' => true,
        '\u{1B00}' => true,
        '\u{1B01}' => true,
        '\u{1B02}' => true,
        '\u{1B03}' => true,
        '\u{1B04}' => true,
        '\u{1B34}' => true,
        '\u{1B35}' => true,
        '\u{1B36}' => true,
        '\u{1B37}' => true,
        '\u{1B38}' => true,
        '\u{1B39}' => true,
        '\u{1B3A}' => true,
        '\u{1B3B}' => true,
        '\u{1B3C}' => true,
        '\u{1B3D}' => true,
        '\u{1B3E}' => true,
        '\u{1B3F}' => true,
        '\u{1B40}' => true,
        '\u{1B41}' => true,
        '\u{1B42}' => true,
        '\u{1B43}' => true,
        '\u{1B44}' => true,
        '\u{1B6B}' => true,
        '\u{1B6C}' => true,
        '\u{1B6D}' => true,
        '\u{1B6E}' => true,
        '\u{1B6F}' => true,
        '\u{1B70}' => true,
        '\u{1B71}' => true,
        '\u{1B72}' => true,
        '\u{1B73}' => true,
        '\u{1B80}' => true,
        '\u{1B81}' => true,
        '\u{1B82}' => true,
        '\u{1BA1}' => true,
        '\u{1BA2}' => true,
        '\u{1BA3}' => true,
        '\u{1BA4}' => true,
        '\u{1BA5}' => true,
        '\u{1BA6}' => true,
        '\u{1BA7}' => true,
        '\u{1BA8}' => true,
        '\u{1BA9}' => true,
        '\u{1BAA}' => true,
        '\u{1BAB}' => true,
        '\u{1BAC}' => true,
        '\u{1BAD}' => true,
        '\u{1BE6}' => true,
        '\u{1BE7}' => true,
        '\u{1BE8}' => true,
        '\u{1BE9}' => true,
        '\u{1BEA}' => true,
        '\u{1BEB}' => true,
        '\u{1BEC}' => true,
        '\u{1BED}' => true,
        '\u{1BEE}' => true,
        '\u{1BEF}' => true,
        '\u{1BF0}' => true,
        '\u{1BF1}' => true,
        '\u{1BF2}' => true,
        '\u{1BF3}' => true,
        '\u{1C24}' => true,
        '\u{1C25}' => true,
        '\u{1C26}' => true,
        '\u{1C27}' => true,
        '\u{1C28}' => true,
        '\u{1C29}' => true,
        '\u{1C2A}' => true,
        '\u{1C2B}' => true,
        '\u{1C2C}' => true,
        '\u{1C2D}' => true,
        '\u{1C2E}' => true,
        '\u{1C2F}' => true,
        '\u{1C30}' => true,
        '\u{1C31}' => true,
        '\u{1C32}' => true,
        '\u{1C33}' => true,
        '\u{1C34}' => true,
        '\u{1C35}' => true,
        '\u{1C36}' => true,
        '\u{1C37}' => true,
        '\u{1CD0}' => true,
        '\u{1CD1}' => true,
        '\u{1CD2}' => true,
        '\u{1CD4}' => true,
        '\u{1CD5}' => true,
        '\u{1CD6}' => true,
        '\u{1CD7}' => true,
        '\u{1CD8}' => true,
        '\u{1CD9}' => true,
        '\u{1CDA}' => true,
        '\u{1CDB}' => true,
        '\u{1CDC}' => true,
        '\u{1CDD}' => true,
        '\u{1CDE}' => true,
        '\u{1CDF}' => true,
        '\u{1CE0}' => true,
        '\u{1CE1}' => true,
        '\u{1CE2}' => true,
        '\u{1CE3}' => true,
        '\u{1CE4}' => true,
        '\u{1CE5}' => true,
        '\u{1CE6}' => true,
        '\u{1CE7}' => true,
        '\u{1CE8}' => true,
        '\u{1CED}' => true,
        '\u{1CF2}' => true,
        '\u{1CF3}' => true,
        '\u{1CF4}' => true,
        '\u{1CF8}' => true,
        '\u{1CF9}' => true,
        '\u{1DC0}' => true,
        '\u{1DC1}' => true,
        '\u{1DC2}' => true,
        '\u{1DC3}' => true,
        '\u{1DC4}' => true,
        '\u{1DC5}' => true,
        '\u{1DC6}' => true,
        '\u{1DC7}' => true,
        '\u{1DC8}' => true,
        '\u{1DC9}' => true,
        '\u{1DCA}' => true,
        '\u{1DCB}' => true,
        '\u{1DCC}' => true,
        '\u{1DCD}' => true,
        '\u{1DCE}' => true,
        '\u{1DCF}' => true,
        '\u{1DD0}' => true,
        '\u{1DD1}' => true,
        '\u{1DD2}' => true,
        '\u{1DD3}' => true,
        '\u{1DD4}' => true,
        '\u{1DD5}' => true,
        '\u{1DD6}' => true,
        '\u{1DD7}' => true,
        '\u{1DD8}' => true,
        '\u{1DD9}' => true,
        '\u{1DDA}' => true,
        '\u{1DDB}' => true,
        '\u{1DDC}' => true,
        '\u{1DDD}' => true,
        '\u{1DDE}' => true,
        '\u{1DDF}' => true,
        '\u{1DE0}' => true,
        '\u{1DE1}' => true,
        '\u{1DE2}' => true,
        '\u{1DE3}' => true,
        '\u{1DE4}' => true,
        '\u{1DE5}' => true,
        '\u{1DE6}' => true,
        '\u{1DE7}' => true,
        '\u{1DE8}' => true,
        '\u{1DE9}' => true,
        '\u{1DEA}' => true,
        '\u{1DEB}' => true,
        '\u{1DEC}' => true,
        '\u{1DED}' => true,
        '\u{1DEE}' => true,
        '\u{1DEF}' => true,
        '\u{1DF0}' => true,
        '\u{1DF1}' => true,
        '\u{1DF2}' => true,
        '\u{1DF3}' => true,
        '\u{1DF4}' => true,
        '\u{1DF5}' => true,
        '\u{1DFB}' => true,
        '\u{1DFC}' => true,
        '\u{1DFD}' => true,
        '\u{1DFE}' => true,
        '\u{1DFF}' => true,
        '\u{20D0}' => true,
        '\u{20D1}' => true,
        '\u{20D2}' => true,
        '\u{20D3}' => true,
        '\u{20D4}' => true,
        '\u{20D5}' => true,
        '\u{20D6}' => true,
        '\u{20D7}' => true,
        '\u{20D8}' => true,
        '\u{20D9}' => true,
        '\u{20DA}' => true,
        '\u{20DB}' => true,
        '\u{20DC}' => true,
        '\u{20DD}' => true,
        '\u{20DE}' => true,
        '\u{20DF}' => true,
        '\u{20E0}' => true,
        '\u{20E1}' => true,
        '\u{20E2}' => true,
        '\u{20E3}' => true,
        '\u{20E4}' => true,
        '\u{20E5}' => true,
        '\u{20E6}' => true,
        '\u{20E7}' => true,
        '\u{20E8}' => true,
        '\u{20E9}' => true,
        '\u{20EA}' => true,
        '\u{20EB}' => true,
        '\u{20EC}' => true,
        '\u{20ED}' => true,
        '\u{20EE}' => true,
        '\u{20EF}' => true,
        '\u{20F0}' => true,
        '\u{2CEF}' => true,
        '\u{2CF0}' => true,
        '\u{2CF1}' => true,
        '\u{2D7F}' => true,
        '\u{2DE0}' => true,
        '\u{2DE1}' => true,
        '\u{2DE2}' => true,
        '\u{2DE3}' => true,
        '\u{2DE4}' => true,
        '\u{2DE5}' => true,
        '\u{2DE6}' => true,
        '\u{2DE7}' => true,
        '\u{2DE8}' => true,
        '\u{2DE9}' => true,
        '\u{2DEA}' => true,
        '\u{2DEB}' => true,
        '\u{2DEC}' => true,
        '\u{2DED}' => true,
        '\u{2DEE}' => true,
        '\u{2DEF}' => true,
        '\u{2DF0}' => true,
        '\u{2DF1}' => true,
        '\u{2DF2}' => true,
        '\u{2DF3}' => true,
        '\u{2DF4}' => true,
        '\u{2DF5}' => true,
        '\u{2DF6}' => true,
        '\u{2DF7}' => true,
        '\u{2DF8}' => true,
        '\u{2DF9}' => true,
        '\u{2DFA}' => true,
        '\u{2DFB}' => true,
        '\u{2DFC}' => true,
        '\u{2DFD}' => true,
        '\u{2DFE}' => true,
        '\u{2DFF}' => true,
        '\u{302A}' => true,
        '\u{302B}' => true,
        '\u{302C}' => true,
        '\u{302D}' => true,
        '\u{302E}' => true,
        '\u{302F}' => true,
        '\u{3099}' => true,
        '\u{309A}' => true,
        '\u{A66F}' => true,
        '\u{A670}' => true,
        '\u{A671}' => true,
        '\u{A672}' => true,
        '\u{A674}' => true,
        '\u{A675}' => true,
        '\u{A676}' => true,
        '\u{A677}' => true,
        '\u{A678}' => true,
        '\u{A679}' => true,
        '\u{A67A}' => true,
        '\u{A67B}' => true,
        '\u{A67C}' => true,
        '\u{A67D}' => true,
        '\u{A69E}' => true,
        '\u{A69F}' => true,
        '\u{A6F0}' => true,
        '\u{A6F1}' => true,
        '\u{A802}' => true,
        '\u{A806}' => true,
        '\u{A80B}' => true,
        '\u{A823}' => true,
        '\u{A824}' => true,
        '\u{A825}' => true,
        '\u{A826}' => true,
        '\u{A827}' => true,
        '\u{A880}' => true,
        '\u{A881}' => true,
        '\u{A8B4}' => true,
        '\u{A8B5}' => true,
        '\u{A8B6}' => true,
        '\u{A8B7}' => true,
        '\u{A8B8}' => true,
        '\u{A8B9}' => true,
        '\u{A8BA}' => true,
        '\u{A8BB}' => true,
        '\u{A8BC}' => true,
        '\u{A8BD}' => true,
        '\u{A8BE}' => true,
        '\u{A8BF}' => true,
        '\u{A8C0}' => true,
        '\u{A8C1}' => true,
        '\u{A8C2}' => true,
        '\u{A8C3}' => true,
        '\u{A8C4}' => true,
        '\u{A8C5}' => true,
        '\u{A8E0}' => true,
        '\u{A8E1}' => true,
        '\u{A8E2}' => true,
        '\u{A8E3}' => true,
        '\u{A8E4}' => true,
        '\u{A8E5}' => true,
        '\u{A8E6}' => true,
        '\u{A8E7}' => true,
        '\u{A8E8}' => true,
        '\u{A8E9}' => true,
        '\u{A8EA}' => true,
        '\u{A8EB}' => true,
        '\u{A8EC}' => true,
        '\u{A8ED}' => true,
        '\u{A8EE}' => true,
        '\u{A8EF}' => true,
        '\u{A8F0}' => true,
        '\u{A8F1}' => true,
        '\u{A926}' => true,
        '\u{A927}' => true,
        '\u{A928}' => true,
        '\u{A929}' => true,
        '\u{A92A}' => true,
        '\u{A92B}' => true,
        '\u{A92C}' => true,
        '\u{A92D}' => true,
        '\u{A947}' => true,
        '\u{A948}' => true,
        '\u{A949}' => true,
        '\u{A94A}' => true,
        '\u{A94B}' => true,
        '\u{A94C}' => true,
        '\u{A94D}' => true,
        '\u{A94E}' => true,
        '\u{A94F}' => true,
        '\u{A950}' => true,
        '\u{A951}' => true,
        '\u{A952}' => true,
        '\u{A953}' => true,
        '\u{A980}' => true,
        '\u{A981}' => true,
        '\u{A982}' => true,
        '\u{A983}' => true,
        '\u{A9B3}' => true,
        '\u{A9B4}' => true,
        '\u{A9B5}' => true,
        '\u{A9B6}' => true,
        '\u{A9B7}' => true,
        '\u{A9B8}' => true,
        '\u{A9B9}' => true,
        '\u{A9BA}' => true,
        '\u{A9BB}' => true,
        '\u{A9BC}' => true,
        '\u{A9BD}' => true,
        '\u{A9BE}' => true,
        '\u{A9BF}' => true,
        '\u{A9C0}' => true,
        '\u{A9E5}' => true,
        '\u{AA29}' => true,
        '\u{AA2A}' => true,
        '\u{AA2B}' => true,
        '\u{AA2C}' => true,
        '\u{AA2D}' => true,
        '\u{AA2E}' => true,
        '\u{AA2F}' => true,
        '\u{AA30}' => true,
        '\u{AA31}' => true,
        '\u{AA32}' => true,
        '\u{AA33}' => true,
        '\u{AA34}' => true,
        '\u{AA35}' => true,
        '\u{AA36}' => true,
        '\u{AA43}' => true,
        '\u{AA4C}' => true,
        '\u{AA4D}' => true,
        '\u{AA7B}' => true,
        '\u{AA7C}' => true,
        '\u{AA7D}' => true,
        '\u{AAB0}' => true,
        '\u{AAB2}' => true,
        '\u{AAB3}' => true,
        '\u{AAB4}' => true,
        '\u{AAB7}' => true,
        '\u{AAB8}' => true,
        '\u{AABE}' => true,
        '\u{AABF}' => true,
        '\u{AAC1}' => true,
        '\u{AAEB}' => true,
        '\u{AAEC}' => true,
        '\u{AAED}' => true,
        '\u{AAEE}' => true,
        '\u{AAEF}' => true,
        '\u{AAF5}' => true,
        '\u{AAF6}' => true,
        '\u{ABE3}' => true,
        '\u{ABE4}' => true,
        '\u{ABE5}' => true,
        '\u{ABE6}' => true,
        '\u{ABE7}' => true,
        '\u{ABE8}' => true,
        '\u{ABE9}' => true,
        '\u{ABEA}' => true,
        '\u{ABEC}' => true,
        '\u{ABED}' => true,
        '\u{FB1E}' => true,
        '\u{FE00}' => true,
        '\u{FE01}' => true,
        '\u{FE02}' => true,
        '\u{FE03}' => true,
        '\u{FE04}' => true,
        '\u{FE05}' => true,
        '\u{FE06}' => true,
        '\u{FE07}' => true,
        '\u{FE08}' => true,
        '\u{FE09}' => true,
        '\u{FE0A}' => true,
        '\u{FE0B}' => true,
        '\u{FE0C}' => true,
        '\u{FE0D}' => true,
        '\u{FE0E}' => true,
        '\u{FE0F}' => true,
        '\u{FE20}' => true,
        '\u{FE21}' => true,
        '\u{FE22}' => true,
        '\u{FE23}' => true,
        '\u{FE24}' => true,
        '\u{FE25}' => true,
        '\u{FE26}' => true,
        '\u{FE27}' => true,
        '\u{FE28}' => true,
        '\u{FE29}' => true,
        '\u{FE2A}' => true,
        '\u{FE2B}' => true,
        '\u{FE2C}' => true,
        '\u{FE2D}' => true,
        '\u{FE2E}' => true,
        '\u{FE2F}' => true,
        '\u{101FD}' => true,
        '\u{102E0}' => true,
        '\u{10376}' => true,
        '\u{10377}' => true,
        '\u{10378}' => true,
        '\u{10379}' => true,
        '\u{1037A}' => true,
        '\u{10A01}' => true,
        '\u{10A02}' => true,
        '\u{10A03}' => true,
        '\u{10A05}' => true,
        '\u{10A06}' => true,
        '\u{10A0C}' => true,
        '\u{10A0D}' => true,
        '\u{10A0E}' => true,
        '\u{10A0F}' => true,
        '\u{10A38}' => true,
        '\u{10A39}' => true,
        '\u{10A3A}' => true,
        '\u{10A3F}' => true,
        '\u{10AE5}' => true,
        '\u{10AE6}' => true,
        '\u{11000}' => true,
        '\u{11001}' => true,
        '\u{11002}' => true,
        '\u{11038}' => true,
        '\u{11039}' => true,
        '\u{1103A}' => true,
        '\u{1103B}' => true,
        '\u{1103C}' => true,
        '\u{1103D}' => true,
        '\u{1103E}' => true,
        '\u{1103F}' => true,
        '\u{11040}' => true,
        '\u{11041}' => true,
        '\u{11042}' => true,
        '\u{11043}' => true,
        '\u{11044}' => true,
        '\u{11045}' => true,
        '\u{11046}' => true,
        '\u{1107F}' => true,
        '\u{11080}' => true,
        '\u{11081}' => true,
        '\u{11082}' => true,
        '\u{110B0}' => true,
        '\u{110B1}' => true,
        '\u{110B2}' => true,
        '\u{110B3}' => true,
        '\u{110B4}' => true,
        '\u{110B5}' => true,
        '\u{110B6}' => true,
        '\u{110B7}' => true,
        '\u{110B8}' => true,
        '\u{110B9}' => true,
        '\u{110BA}' => true,
        '\u{11100}' => true,
        '\u{11101}' => true,
        '\u{11102}' => true,
        '\u{11127}' => true,
        '\u{11128}' => true,
        '\u{11129}' => true,
        '\u{1112A}' => true,
        '\u{1112B}' => true,
        '\u{1112C}' => true,
        '\u{1112D}' => true,
        '\u{1112E}' => true,
        '\u{1112F}' => true,
        '\u{11130}' => true,
        '\u{11131}' => true,
        '\u{11132}' => true,
        '\u{11133}' => true,
        '\u{11134}' => true,
        '\u{11173}' => true,
        '\u{11180}' => true,
        '\u{11181}' => true,
        '\u{11182}' => true,
        '\u{111B3}' => true,
        '\u{111B4}' => true,
        '\u{111B5}' => true,
        '\u{111B6}' => true,
        '\u{111B7}' => true,
        '\u{111B8}' => true,
        '\u{111B9}' => true,
        '\u{111BA}' => true,
        '\u{111BB}' => true,
        '\u{111BC}' => true,
        '\u{111BD}' => true,
        '\u{111BE}' => true,
        '\u{111BF}' => true,
        '\u{111C0}' => true,
        '\u{111CA}' => true,
        '\u{111CB}' => true,
        '\u{111CC}' => true,
        '\u{1122C}' => true,
        '\u{1122D}' => true,
        '\u{1122E}' => true,
        '\u{1122F}' => true,
        '\u{11230}' => true,
        '\u{11231}' => true,
        '\u{11232}' => true,
        '\u{11233}' => true,
        '\u{11234}' => true,
        '\u{11235}' => true,
        '\u{11236}' => true,
        '\u{11237}' => true,
        '\u{1123E}' => true,
        '\u{112DF}' => true,
        '\u{112E0}' => true,
        '\u{112E1}' => true,
        '\u{112E2}' => true,
        '\u{112E3}' => true,
        '\u{112E4}' => true,
        '\u{112E5}' => true,
        '\u{112E6}' => true,
        '\u{112E7}' => true,
        '\u{112E8}' => true,
        '\u{112E9}' => true,
        '\u{112EA}' => true,
        '\u{11300}' => true,
        '\u{11301}' => true,
        '\u{11302}' => true,
        '\u{11303}' => true,
        '\u{1133C}' => true,
        '\u{1133E}' => true,
        '\u{1133F}' => true,
        '\u{11340}' => true,
        '\u{11341}' => true,
        '\u{11342}' => true,
        '\u{11343}' => true,
        '\u{11344}' => true,
        '\u{11347}' => true,
        '\u{11348}' => true,
        '\u{1134B}' => true,
        '\u{1134C}' => true,
        '\u{1134D}' => true,
        '\u{11357}' => true,
        '\u{11362}' => true,
        '\u{11363}' => true,
        '\u{11366}' => true,
        '\u{11367}' => true,
        '\u{11368}' => true,
        '\u{11369}' => true,
        '\u{1136A}' => true,
        '\u{1136B}' => true,
        '\u{1136C}' => true,
        '\u{11370}' => true,
        '\u{11371}' => true,
        '\u{11372}' => true,
        '\u{11373}' => true,
        '\u{11374}' => true,
        '\u{11435}' => true,
        '\u{11436}' => true,
        '\u{11437}' => true,
        '\u{11438}' => true,
        '\u{11439}' => true,
        '\u{1143A}' => true,
        '\u{1143B}' => true,
        '\u{1143C}' => true,
        '\u{1143D}' => true,
        '\u{1143E}' => true,
        '\u{1143F}' => true,
        '\u{11440}' => true,
        '\u{11441}' => true,
        '\u{11442}' => true,
        '\u{11443}' => true,
        '\u{11444}' => true,
        '\u{11445}' => true,
        '\u{11446}' => true,
        '\u{114B0}' => true,
        '\u{114B1}' => true,
        '\u{114B2}' => true,
        '\u{114B3}' => true,
        '\u{114B4}' => true,
        '\u{114B5}' => true,
        '\u{114B6}' => true,
        '\u{114B7}' => true,
        '\u{114B8}' => true,
        '\u{114B9}' => true,
        '\u{114BA}' => true,
        '\u{114BB}' => true,
        '\u{114BC}' => true,
        '\u{114BD}' => true,
        '\u{114BE}' => true,
        '\u{114BF}' => true,
        '\u{114C0}' => true,
        '\u{114C1}' => true,
        '\u{114C2}' => true,
        '\u{114C3}' => true,
        '\u{115AF}' => true,
        '\u{115B0}' => true,
        '\u{115B1}' => true,
        '\u{115B2}' => true,
        '\u{115B3}' => true,
        '\u{115B4}' => true,
        '\u{115B5}' => true,
        '\u{115B8}' => true,
        '\u{115B9}' => true,
        '\u{115BA}' => true,
        '\u{115BB}' => true,
        '\u{115BC}' => true,
        '\u{115BD}' => true,
        '\u{115BE}' => true,
        '\u{115BF}' => true,
        '\u{115C0}' => true,
        '\u{115DC}' => true,
        '\u{115DD}' => true,
        '\u{11630}' => true,
        '\u{11631}' => true,
        '\u{11632}' => true,
        '\u{11633}' => true,
        '\u{11634}' => true,
        '\u{11635}' => true,
        '\u{11636}' => true,
        '\u{11637}' => true,
        '\u{11638}' => true,
        '\u{11639}' => true,
        '\u{1163A}' => true,
        '\u{1163B}' => true,
        '\u{1163C}' => true,
        '\u{1163D}' => true,
        '\u{1163E}' => true,
        '\u{1163F}' => true,
        '\u{11640}' => true,
        '\u{116AB}' => true,
        '\u{116AC}' => true,
        '\u{116AD}' => true,
        '\u{116AE}' => true,
        '\u{116AF}' => true,
        '\u{116B0}' => true,
        '\u{116B1}' => true,
        '\u{116B2}' => true,
        '\u{116B3}' => true,
        '\u{116B4}' => true,
        '\u{116B5}' => true,
        '\u{116B6}' => true,
        '\u{116B7}' => true,
        '\u{1171D}' => true,
        '\u{1171E}' => true,
        '\u{1171F}' => true,
        '\u{11720}' => true,
        '\u{11721}' => true,
        '\u{11722}' => true,
        '\u{11723}' => true,
        '\u{11724}' => true,
        '\u{11725}' => true,
        '\u{11726}' => true,
        '\u{11727}' => true,
        '\u{11728}' => true,
        '\u{11729}' => true,
        '\u{1172A}' => true,
        '\u{1172B}' => true,
        '\u{11C2F}' => true,
        '\u{11C30}' => true,
        '\u{11C31}' => true,
        '\u{11C32}' => true,
        '\u{11C33}' => true,
        '\u{11C34}' => true,
        '\u{11C35}' => true,
        '\u{11C36}' => true,
        '\u{11C38}' => true,
        '\u{11C39}' => true,
        '\u{11C3A}' => true,
        '\u{11C3B}' => true,
        '\u{11C3C}' => true,
        '\u{11C3D}' => true,
        '\u{11C3E}' => true,
        '\u{11C3F}' => true,
        '\u{11C92}' => true,
        '\u{11C93}' => true,
        '\u{11C94}' => true,
        '\u{11C95}' => true,
        '\u{11C96}' => true,
        '\u{11C97}' => true,
        '\u{11C98}' => true,
        '\u{11C99}' => true,
        '\u{11C9A}' => true,
        '\u{11C9B}' => true,
        '\u{11C9C}' => true,
        '\u{11C9D}' => true,
        '\u{11C9E}' => true,
        '\u{11C9F}' => true,
        '\u{11CA0}' => true,
        '\u{11CA1}' => true,
        '\u{11CA2}' => true,
        '\u{11CA3}' => true,
        '\u{11CA4}' => true,
        '\u{11CA5}' => true,
        '\u{11CA6}' => true,
        '\u{11CA7}' => true,
        '\u{11CA9}' => true,
        '\u{11CAA}' => true,
        '\u{11CAB}' => true,
        '\u{11CAC}' => true,
        '\u{11CAD}' => true,
        '\u{11CAE}' => true,
        '\u{11CAF}' => true,
        '\u{11CB0}' => true,
        '\u{11CB1}' => true,
        '\u{11CB2}' => true,
        '\u{11CB3}' => true,
        '\u{11CB4}' => true,
        '\u{11CB5}' => true,
        '\u{11CB6}' => true,
        '\u{16AF0}' => true,
        '\u{16AF1}' => true,
        '\u{16AF2}' => true,
        '\u{16AF3}' => true,
        '\u{16AF4}' => true,
        '\u{16B30}' => true,
        '\u{16B31}' => true,
        '\u{16B32}' => true,
        '\u{16B33}' => true,
        '\u{16B34}' => true,
        '\u{16B35}' => true,
        '\u{16B36}' => true,
        '\u{16F51}' => true,
        '\u{16F52}' => true,
        '\u{16F53}' => true,
        '\u{16F54}' => true,
        '\u{16F55}' => true,
        '\u{16F56}' => true,
        '\u{16F57}' => true,
        '\u{16F58}' => true,
        '\u{16F59}' => true,
        '\u{16F5A}' => true,
        '\u{16F5B}' => true,
        '\u{16F5C}' => true,
        '\u{16F5D}' => true,
        '\u{16F5E}' => true,
        '\u{16F5F}' => true,
        '\u{16F60}' => true,
        '\u{16F61}' => true,
        '\u{16F62}' => true,
        '\u{16F63}' => true,
        '\u{16F64}' => true,
        '\u{16F65}' => true,
        '\u{16F66}' => true,
        '\u{16F67}' => true,
        '\u{16F68}' => true,
        '\u{16F69}' => true,
        '\u{16F6A}' => true,
        '\u{16F6B}' => true,
        '\u{16F6C}' => true,
        '\u{16F6D}' => true,
        '\u{16F6E}' => true,
        '\u{16F6F}' => true,
        '\u{16F70}' => true,
        '\u{16F71}' => true,
        '\u{16F72}' => true,
        '\u{16F73}' => true,
        '\u{16F74}' => true,
        '\u{16F75}' => true,
        '\u{16F76}' => true,
        '\u{16F77}' => true,
        '\u{16F78}' => true,
        '\u{16F79}' => true,
        '\u{16F7A}' => true,
        '\u{16F7B}' => true,
        '\u{16F7C}' => true,
        '\u{16F7D}' => true,
        '\u{16F7E}' => true,
        '\u{16F8F}' => true,
        '\u{16F90}' => true,
        '\u{16F91}' => true,
        '\u{16F92}' => true,
        '\u{1BC9D}' => true,
        '\u{1BC9E}' => true,
        '\u{1D165}' => true,
        '\u{1D166}' => true,
        '\u{1D167}' => true,
        '\u{1D168}' => true,
        '\u{1D169}' => true,
        '\u{1D16D}' => true,
        '\u{1D16E}' => true,
        '\u{1D16F}' => true,
        '\u{1D170}' => true,
        '\u{1D171}' => true,
        '\u{1D172}' => true,
        '\u{1D17B}' => true,
        '\u{1D17C}' => true,
        '\u{1D17D}' => true,
        '\u{1D17E}' => true,
        '\u{1D17F}' => true,
        '\u{1D180}' => true,
        '\u{1D181}' => true,
        '\u{1D182}' => true,
        '\u{1D185}' => true,
        '\u{1D186}' => true,
        '\u{1D187}' => true,
        '\u{1D188}' => true,
        '\u{1D189}' => true,
        '\u{1D18A}' => true,
        '\u{1D18B}' => true,
        '\u{1D1AA}' => true,
        '\u{1D1AB}' => true,
        '\u{1D1AC}' => true,
        '\u{1D1AD}' => true,
        '\u{1D242}' => true,
        '\u{1D243}' => true,
        '\u{1D244}' => true,
        '\u{1DA00}' => true,
        '\u{1DA01}' => true,
        '\u{1DA02}' => true,
        '\u{1DA03}' => true,
        '\u{1DA04}' => true,
        '\u{1DA05}' => true,
        '\u{1DA06}' => true,
        '\u{1DA07}' => true,
        '\u{1DA08}' => true,
        '\u{1DA09}' => true,
        '\u{1DA0A}' => true,
        '\u{1DA0B}' => true,
        '\u{1DA0C}' => true,
        '\u{1DA0D}' => true,
        '\u{1DA0E}' => true,
        '\u{1DA0F}' => true,
        '\u{1DA10}' => true,
        '\u{1DA11}' => true,
        '\u{1DA12}' => true,
        '\u{1DA13}' => true,
        '\u{1DA14}' => true,
        '\u{1DA15}' => true,
        '\u{1DA16}' => true,
        '\u{1DA17}' => true,
        '\u{1DA18}' => true,
        '\u{1DA19}' => true,
        '\u{1DA1A}' => true,
        '\u{1DA1B}' => true,
        '\u{1DA1C}' => true,
        '\u{1DA1D}' => true,
        '\u{1DA1E}' => true,
        '\u{1DA1F}' => true,
        '\u{1DA20}' => true,
        '\u{1DA21}' => true,
        '\u{1DA22}' => true,
        '\u{1DA23}' => true,
        '\u{1DA24}' => true,
        '\u{1DA25}' => true,
        '\u{1DA26}' => true,
        '\u{1DA27}' => true,
        '\u{1DA28}' => true,
        '\u{1DA29}' => true,
        '\u{1DA2A}' => true,
        '\u{1DA2B}' => true,
        '\u{1DA2C}' => true,
        '\u{1DA2D}' => true,
        '\u{1DA2E}' => true,
        '\u{1DA2F}' => true,
        '\u{1DA30}' => true,
        '\u{1DA31}' => true,
        '\u{1DA32}' => true,
        '\u{1DA33}' => true,
        '\u{1DA34}' => true,
        '\u{1DA35}' => true,
        '\u{1DA36}' => true,
        '\u{1DA3B}' => true,
        '\u{1DA3C}' => true,
        '\u{1DA3D}' => true,
        '\u{1DA3E}' => true,
        '\u{1DA3F}' => true,
        '\u{1DA40}' => true,
        '\u{1DA41}' => true,
        '\u{1DA42}' => true,
        '\u{1DA43}' => true,
        '\u{1DA44}' => true,
        '\u{1DA45}' => true,
        '\u{1DA46}' => true,
        '\u{1DA47}' => true,
        '\u{1DA48}' => true,
        '\u{1DA49}' => true,
        '\u{1DA4A}' => true,
        '\u{1DA4B}' => true,
        '\u{1DA4C}' => true,
        '\u{1DA4D}' => true,
        '\u{1DA4E}' => true,
        '\u{1DA4F}' => true,
        '\u{1DA50}' => true,
        '\u{1DA51}' => true,
        '\u{1DA52}' => true,
        '\u{1DA53}' => true,
        '\u{1DA54}' => true,
        '\u{1DA55}' => true,
        '\u{1DA56}' => true,
        '\u{1DA57}' => true,
        '\u{1DA58}' => true,
        '\u{1DA59}' => true,
        '\u{1DA5A}' => true,
        '\u{1DA5B}' => true,
        '\u{1DA5C}' => true,
        '\u{1DA5D}' => true,
        '\u{1DA5E}' => true,
        '\u{1DA5F}' => true,
        '\u{1DA60}' => true,
        '\u{1DA61}' => true,
        '\u{1DA62}' => true,
        '\u{1DA63}' => true,
        '\u{1DA64}' => true,
        '\u{1DA65}' => true,
        '\u{1DA66}' => true,
        '\u{1DA67}' => true,
        '\u{1DA68}' => true,
        '\u{1DA69}' => true,
        '\u{1DA6A}' => true,
        '\u{1DA6B}' => true,
        '\u{1DA6C}' => true,
        '\u{1DA75}' => true,
        '\u{1DA84}' => true,
        '\u{1DA9B}' => true,
        '\u{1DA9C}' => true,
        '\u{1DA9D}' => true,
        '\u{1DA9E}' => true,
        '\u{1DA9F}' => true,
        '\u{1DAA1}' => true,
        '\u{1DAA2}' => true,
        '\u{1DAA3}' => true,
        '\u{1DAA4}' => true,
        '\u{1DAA5}' => true,
        '\u{1DAA6}' => true,
        '\u{1DAA7}' => true,
        '\u{1DAA8}' => true,
        '\u{1DAA9}' => true,
        '\u{1DAAA}' => true,
        '\u{1DAAB}' => true,
        '\u{1DAAC}' => true,
        '\u{1DAAD}' => true,
        '\u{1DAAE}' => true,
        '\u{1DAAF}' => true,
        '\u{1E000}' => true,
        '\u{1E001}' => true,
        '\u{1E002}' => true,
        '\u{1E003}' => true,
        '\u{1E004}' => true,
        '\u{1E005}' => true,
        '\u{1E006}' => true,
        '\u{1E008}' => true,
        '\u{1E009}' => true,
        '\u{1E00A}' => true,
        '\u{1E00B}' => true,
        '\u{1E00C}' => true,
        '\u{1E00D}' => true,
        '\u{1E00E}' => true,
        '\u{1E00F}' => true,
        '\u{1E010}' => true,
        '\u{1E011}' => true,
        '\u{1E012}' => true,
        '\u{1E013}' => true,
        '\u{1E014}' => true,
        '\u{1E015}' => true,
        '\u{1E016}' => true,
        '\u{1E017}' => true,
        '\u{1E018}' => true,
        '\u{1E01B}' => true,
        '\u{1E01C}' => true,
        '\u{1E01D}' => true,
        '\u{1E01E}' => true,
        '\u{1E01F}' => true,
        '\u{1E020}' => true,
        '\u{1E021}' => true,
        '\u{1E023}' => true,
        '\u{1E024}' => true,
        '\u{1E026}' => true,
        '\u{1E027}' => true,
        '\u{1E028}' => true,
        '\u{1E029}' => true,
        '\u{1E02A}' => true,
        '\u{1E8D0}' => true,
        '\u{1E8D1}' => true,
        '\u{1E8D2}' => true,
        '\u{1E8D3}' => true,
        '\u{1E8D4}' => true,
        '\u{1E8D5}' => true,
        '\u{1E8D6}' => true,
        '\u{1E944}' => true,
        '\u{1E945}' => true,
        '\u{1E946}' => true,
        '\u{1E947}' => true,
        '\u{1E948}' => true,
        '\u{1E949}' => true,
        '\u{1E94A}' => true,
        '\u{E0100}' => true,
        '\u{E0101}' => true,
        '\u{E0102}' => true,
        '\u{E0103}' => true,
        '\u{E0104}' => true,
        '\u{E0105}' => true,
        '\u{E0106}' => true,
        '\u{E0107}' => true,
        '\u{E0108}' => true,
        '\u{E0109}' => true,
        '\u{E010A}' => true,
        '\u{E010B}' => true,
        '\u{E010C}' => true,
        '\u{E010D}' => true,
        '\u{E010E}' => true,
        '\u{E010F}' => true,
        '\u{E0110}' => true,
        '\u{E0111}' => true,
        '\u{E0112}' => true,
        '\u{E0113}' => true,
        '\u{E0114}' => true,
        '\u{E0115}' => true,
        '\u{E0116}' => true,
        '\u{E0117}' => true,
        '\u{E0118}' => true,
        '\u{E0119}' => true,
        '\u{E011A}' => true,
        '\u{E011B}' => true,
        '\u{E011C}' => true,
        '\u{E011D}' => true,
        '\u{E011E}' => true,
        '\u{E011F}' => true,
        '\u{E0120}' => true,
        '\u{E0121}' => true,
        '\u{E0122}' => true,
        '\u{E0123}' => true,
        '\u{E0124}' => true,
        '\u{E0125}' => true,
        '\u{E0126}' => true,
        '\u{E0127}' => true,
        '\u{E0128}' => true,
        '\u{E0129}' => true,
        '\u{E012A}' => true,
        '\u{E012B}' => true,
        '\u{E012C}' => true,
        '\u{E012D}' => true,
        '\u{E012E}' => true,
        '\u{E012F}' => true,
        '\u{E0130}' => true,
        '\u{E0131}' => true,
        '\u{E0132}' => true,
        '\u{E0133}' => true,
        '\u{E0134}' => true,
        '\u{E0135}' => true,
        '\u{E0136}' => true,
        '\u{E0137}' => true,
        '\u{E0138}' => true,
        '\u{E0139}' => true,
        '\u{E013A}' => true,
        '\u{E013B}' => true,
        '\u{E013C}' => true,
        '\u{E013D}' => true,
        '\u{E013E}' => true,
        '\u{E013F}' => true,
        '\u{E0140}' => true,
        '\u{E0141}' => true,
        '\u{E0142}' => true,
        '\u{E0143}' => true,
        '\u{E0144}' => true,
        '\u{E0145}' => true,
        '\u{E0146}' => true,
        '\u{E0147}' => true,
        '\u{E0148}' => true,
        '\u{E0149}' => true,
        '\u{E014A}' => true,
        '\u{E014B}' => true,
        '\u{E014C}' => true,
        '\u{E014D}' => true,
        '\u{E014E}' => true,
        '\u{E014F}' => true,
        '\u{E0150}' => true,
        '\u{E0151}' => true,
        '\u{E0152}' => true,
        '\u{E0153}' => true,
        '\u{E0154}' => true,
        '\u{E0155}' => true,
        '\u{E0156}' => true,
        '\u{E0157}' => true,
        '\u{E0158}' => true,
        '\u{E0159}' => true,
        '\u{E015A}' => true,
        '\u{E015B}' => true,
        '\u{E015C}' => true,
        '\u{E015D}' => true,
        '\u{E015E}' => true,
        '\u{E015F}' => true,
        '\u{E0160}' => true,
        '\u{E0161}' => true,
        '\u{E0162}' => true,
        '\u{E0163}' => true,
        '\u{E0164}' => true,
        '\u{E0165}' => true,
        '\u{E0166}' => true,
        '\u{E0167}' => true,
        '\u{E0168}' => true,
        '\u{E0169}' => true,
        '\u{E016A}' => true,
        '\u{E016B}' => true,
        '\u{E016C}' => true,
        '\u{E016D}' => true,
        '\u{E016E}' => true,
        '\u{E016F}' => true,
        '\u{E0170}' => true,
        '\u{E0171}' => true,
        '\u{E0172}' => true,
        '\u{E0173}' => true,
        '\u{E0174}' => true,
        '\u{E0175}' => true,
        '\u{E0176}' => true,
        '\u{E0177}' => true,
        '\u{E0178}' => true,
        '\u{E0179}' => true,
        '\u{E017A}' => true,
        '\u{E017B}' => true,
        '\u{E017C}' => true,
        '\u{E017D}' => true,
        '\u{E017E}' => true,
        '\u{E017F}' => true,
        '\u{E0180}' => true,
        '\u{E0181}' => true,
        '\u{E0182}' => true,
        '\u{E0183}' => true,
        '\u{E0184}' => true,
        '\u{E0185}' => true,
        '\u{E0186}' => true,
        '\u{E0187}' => true,
        '\u{E0188}' => true,
        '\u{E0189}' => true,
        '\u{E018A}' => true,
        '\u{E018B}' => true,
        '\u{E018C}' => true,
        '\u{E018D}' => true,
        '\u{E018E}' => true,
        '\u{E018F}' => true,
        '\u{E0190}' => true,
        '\u{E0191}' => true,
        '\u{E0192}' => true,
        '\u{E0193}' => true,
        '\u{E0194}' => true,
        '\u{E0195}' => true,
        '\u{E0196}' => true,
        '\u{E0197}' => true,
        '\u{E0198}' => true,
        '\u{E0199}' => true,
        '\u{E019A}' => true,
        '\u{E019B}' => true,
        '\u{E019C}' => true,
        '\u{E019D}' => true,
        '\u{E019E}' => true,
        '\u{E019F}' => true,
        '\u{E01A0}' => true,
        '\u{E01A1}' => true,
        '\u{E01A2}' => true,
        '\u{E01A3}' => true,
        '\u{E01A4}' => true,
        '\u{E01A5}' => true,
        '\u{E01A6}' => true,
        '\u{E01A7}' => true,
        '\u{E01A8}' => true,
        '\u{E01A9}' => true,
        '\u{E01AA}' => true,
        '\u{E01AB}' => true,
        '\u{E01AC}' => true,
        '\u{E01AD}' => true,
        '\u{E01AE}' => true,
        '\u{E01AF}' => true,
        '\u{E01B0}' => true,
        '\u{E01B1}' => true,
        '\u{E01B2}' => true,
        '\u{E01B3}' => true,
        '\u{E01B4}' => true,
        '\u{E01B5}' => true,
        '\u{E01B6}' => true,
        '\u{E01B7}' => true,
        '\u{E01B8}' => true,
        '\u{E01B9}' => true,
        '\u{E01BA}' => true,
        '\u{E01BB}' => true,
        '\u{E01BC}' => true,
        '\u{E01BD}' => true,
        '\u{E01BE}' => true,
        '\u{E01BF}' => true,
        '\u{E01C0}' => true,
        '\u{E01C1}' => true,
        '\u{E01C2}' => true,
        '\u{E01C3}' => true,
        '\u{E01C4}' => true,
        '\u{E01C5}' => true,
        '\u{E01C6}' => true,
        '\u{E01C7}' => true,
        '\u{E01C8}' => true,
        '\u{E01C9}' => true,
        '\u{E01CA}' => true,
        '\u{E01CB}' => true,
        '\u{E01CC}' => true,
        '\u{E01CD}' => true,
        '\u{E01CE}' => true,
        '\u{E01CF}' => true,
        '\u{E01D0}' => true,
        '\u{E01D1}' => true,
        '\u{E01D2}' => true,
        '\u{E01D3}' => true,
        '\u{E01D4}' => true,
        '\u{E01D5}' => true,
        '\u{E01D6}' => true,
        '\u{E01D7}' => true,
        '\u{E01D8}' => true,
        '\u{E01D9}' => true,
        '\u{E01DA}' => true,
        '\u{E01DB}' => true,
        '\u{E01DC}' => true,
        '\u{E01DD}' => true,
        '\u{E01DE}' => true,
        '\u{E01DF}' => true,
        '\u{E01E0}' => true,
        '\u{E01E1}' => true,
        '\u{E01E2}' => true,
        '\u{E01E3}' => true,
        '\u{E01E4}' => true,
        '\u{E01E5}' => true,
        '\u{E01E6}' => true,
        '\u{E01E7}' => true,
        '\u{E01E8}' => true,
        '\u{E01E9}' => true,
        '\u{E01EA}' => true,
        '\u{E01EB}' => true,
        '\u{E01EC}' => true,
        '\u{E01ED}' => true,
        '\u{E01EE}' => true,
        '\u{E01EF}' => true,
        _ => false,
    }
}

#[inline]
pub fn qc_nfc(c: char) -> IsNormalized {
    match c {
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0387}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1F71}' => No,
        '\u{1F73}' => No,
        '\u{1F75}' => No,
        '\u{1F77}' => No,
        '\u{1F79}' => No,
        '\u{1F7B}' => No,
        '\u{1F7D}' => No,
        '\u{1FBB}' => No,
        '\u{1FBE}' => No,
        '\u{1FC9}' => No,
        '\u{1FCB}' => No,
        '\u{1FD3}' => No,
        '\u{1FDB}' => No,
        '\u{1FE3}' => No,
        '\u{1FEB}' => No,
        '\u{1FEE}'...'\u{1FEF}' => No,
        '\u{1FF9}' => No,
        '\u{1FFB}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'...'\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'...'\u{212B}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FB4E}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        '\u{0300}'...'\u{0304}' => Maybe,
        '\u{0306}'...'\u{030C}' => Maybe,
        '\u{030F}' => Maybe,
        '\u{0311}' => Maybe,
        '\u{0313}'...'\u{0314}' => Maybe,
        '\u{031B}' => Maybe,
        '\u{0323}'...'\u{0328}' => Maybe,
        '\u{032D}'...'\u{032E}' => Maybe,
        '\u{0330}'...'\u{0331}' => Maybe,
        '\u{0338}' => Maybe,
        '\u{0342}' => Maybe,
        '\u{0345}' => Maybe,
        '\u{0653}'...'\u{0655}' => Maybe,
        '\u{093C}' => Maybe,
        '\u{09BE}' => Maybe,
        '\u{09D7}' => Maybe,
        '\u{0B3E}' => Maybe,
        '\u{0B56}' => Maybe,
        '\u{0B57}' => Maybe,
        '\u{0BBE}' => Maybe,
        '\u{0BD7}' => Maybe,
        '\u{0C56}' => Maybe,
        '\u{0CC2}' => Maybe,
        '\u{0CD5}'...'\u{0CD6}' => Maybe,
        '\u{0D3E}' => Maybe,
        '\u{0D57}' => Maybe,
        '\u{0DCA}' => Maybe,
        '\u{0DCF}' => Maybe,
        '\u{0DDF}' => Maybe,
        '\u{102E}' => Maybe,
        '\u{1161}'...'\u{1175}' => Maybe,
        '\u{11A8}'...'\u{11C2}' => Maybe,
        '\u{1B35}' => Maybe,
        '\u{3099}'...'\u{309A}' => Maybe,
        '\u{110BA}' => Maybe,
        '\u{11127}' => Maybe,
        '\u{1133E}' => Maybe,
        '\u{11357}' => Maybe,
        '\u{114B0}' => Maybe,
        '\u{114BA}' => Maybe,
        '\u{114BD}' => Maybe,
        '\u{115AF}' => Maybe,
        _ => Yes,
    }
}

#[inline]
pub fn qc_nfd(c: char) -> IsNormalized {
    match c {
        '\u{00C0}'...'\u{00C5}' => No,
        '\u{00C7}'...'\u{00CF}' => No,
        '\u{00D1}'...'\u{00D6}' => No,
        '\u{00D9}'...'\u{00DD}' => No,
        '\u{00E0}'...'\u{00E5}' => No,
        '\u{00E7}'...'\u{00EF}' => No,
        '\u{00F1}'...'\u{00F6}' => No,
        '\u{00F9}'...'\u{00FD}' => No,
        '\u{00FF}'...'\u{010F}' => No,
        '\u{0112}'...'\u{0125}' => No,
        '\u{0128}'...'\u{0130}' => No,
        '\u{0134}'...'\u{0137}' => No,
        '\u{0139}'...'\u{013E}' => No,
        '\u{0143}'...'\u{0148}' => No,
        '\u{014C}'...'\u{0151}' => No,
        '\u{0154}'...'\u{0165}' => No,
        '\u{0168}'...'\u{017E}' => No,
        '\u{01A0}'...'\u{01A1}' => No,
        '\u{01AF}'...'\u{01B0}' => No,
        '\u{01CD}'...'\u{01DC}' => No,
        '\u{01DE}'...'\u{01E3}' => No,
        '\u{01E6}'...'\u{01F0}' => No,
        '\u{01F4}'...'\u{01F5}' => No,
        '\u{01F8}'...'\u{021B}' => No,
        '\u{021E}'...'\u{021F}' => No,
        '\u{0226}'...'\u{0233}' => No,
        '\u{0340}'...'\u{0341}' => No,
        '\u{0343}'...'\u{0344}' => No,
        '\u{0374}' => No,
        '\u{037E}' => No,
        '\u{0385}' => No,
        '\u{0386}' => No,
        '\u{0387}' => No,
        '\u{0388}'...'\u{038A}' => No,
        '\u{038C}' => No,
        '\u{038E}'...'\u{0390}' => No,
        '\u{03AA}'...'\u{03B0}' => No,
        '\u{03CA}'...'\u{03CE}' => No,
        '\u{03D3}'...'\u{03D4}' => No,
        '\u{0400}'...'\u{0401}' => No,
        '\u{0403}' => No,
        '\u{0407}' => No,
        '\u{040C}'...'\u{040E}' => No,
        '\u{0419}' => No,
        '\u{0439}' => No,
        '\u{0450}'...'\u{0451}' => No,
        '\u{0453}' => No,
        '\u{0457}' => No,
        '\u{045C}'...'\u{045E}' => No,
        '\u{0476}'...'\u{0477}' => No,
        '\u{04C1}'...'\u{04C2}' => No,
        '\u{04D0}'...'\u{04D3}' => No,
        '\u{04D6}'...'\u{04D7}' => No,
        '\u{04DA}'...'\u{04DF}' => No,
        '\u{04E2}'...'\u{04E7}' => No,
        '\u{04EA}'...'\u{04F5}' => No,
        '\u{04F8}'...'\u{04F9}' => No,
        '\u{0622}'...'\u{0626}' => No,
        '\u{06C0}' => No,
        '\u{06C2}' => No,
        '\u{06D3}' => No,
        '\u{0929}' => No,
        '\u{0931}' => No,
        '\u{0934}' => No,
        '\u{0958}'...'\u{095F}' => No,
        '\u{09CB}'...'\u{09CC}' => No,
        '\u{09DC}'...'\u{09DD}' => No,
        '\u{09DF}' => No,
        '\u{0A33}' => No,
        '\u{0A36}' => No,
        '\u{0A59}'...'\u{0A5B}' => No,
        '\u{0A5E}' => No,
        '\u{0B48}' => No,
        '\u{0B4B}'...'\u{0B4C}' => No,
        '\u{0B5C}'...'\u{0B5D}' => No,
        '\u{0B94}' => No,
        '\u{0BCA}'...'\u{0BCC}' => No,
        '\u{0C48}' => No,
        '\u{0CC0}' => No,
        '\u{0CC7}'...'\u{0CC8}' => No,
        '\u{0CCA}'...'\u{0CCB}' => No,
        '\u{0D4A}'...'\u{0D4C}' => No,
        '\u{0DDA}' => No,
        '\u{0DDC}'...'\u{0DDE}' => No,
        '\u{0F43}' => No,
        '\u{0F4D}' => No,
        '\u{0F52}' => No,
        '\u{0F57}' => No,
        '\u{0F5C}' => No,
        '\u{0F69}' => No,
        '\u{0F73}' => No,
        '\u{0F75}'...'\u{0F76}' => No,
        '\u{0F78}' => No,
        '\u{0F81}' => No,
        '\u{0F93}' => No,
        '\u{0F9D}' => No,
        '\u{0FA2}' => No,
        '\u{0FA7}' => No,
        '\u{0FAC}' => No,
        '\u{0FB9}' => No,
        '\u{1026}' => No,
        '\u{1B06}' => No,
        '\u{1B08}' => No,
        '\u{1B0A}' => No,
        '\u{1B0C}' => No,
        '\u{1B0E}' => No,
        '\u{1B12}' => No,
        '\u{1B3B}' => No,
        '\u{1B3D}' => No,
        '\u{1B40}'...'\u{1B41}' => No,
        '\u{1B43}' => No,
        '\u{1E00}'...'\u{1E99}' => No,
        '\u{1E9B}' => No,
        '\u{1EA0}'...'\u{1EF9}' => No,
        '\u{1F00}'...'\u{1F15}' => No,
        '\u{1F18}'...'\u{1F1D}' => No,
        '\u{1F20}'...'\u{1F45}' => No,
        '\u{1F48}'...'\u{1F4D}' => No,
        '\u{1F50}'...'\u{1F57}' => No,
        '\u{1F59}' => No,
        '\u{1F5B}' => No,
        '\u{1F5D}' => No,
        '\u{1F5F}'...'\u{1F7D}' => No,
        '\u{1F80}'...'\u{1FB4}' => No,
        '\u{1FB6}'...'\u{1FBC}' => No,
        '\u{1FBE}' => No,
        '\u{1FC1}' => No,
        '\u{1FC2}'...'\u{1FC4}' => No,
        '\u{1FC6}'...'\u{1FCC}' => No,
        '\u{1FCD}'...'\u{1FCF}' => No,
        '\u{1FD0}'...'\u{1FD3}' => No,
        '\u{1FD6}'...'\u{1FDB}' => No,
        '\u{1FDD}'...'\u{1FDF}' => No,
        '\u{1FE0}'...'\u{1FEC}' => No,
        '\u{1FED}'...'\u{1FEF}' => No,
        '\u{1FF2}'...'\u{1FF4}' => No,
        '\u{1FF6}'...'\u{1FFC}' => No,
        '\u{1FFD}' => No,
        '\u{2000}'...'\u{2001}' => No,
        '\u{2126}' => No,
        '\u{212A}'...'\u{212B}' => No,
        '\u{219A}'...'\u{219B}' => No,
        '\u{21AE}' => No,
        '\u{21CD}' => No,
        '\u{21CE}'...'\u{21CF}' => No,
        '\u{2204}' => No,
        '\u{2209}' => No,
        '\u{220C}' => No,
        '\u{2224}' => No,
        '\u{2226}' => No,
        '\u{2241}' => No,
        '\u{2244}' => No,
        '\u{2247}' => No,
        '\u{2249}' => No,
        '\u{2260}' => No,
        '\u{2262}' => No,
        '\u{226D}'...'\u{2271}' => No,
        '\u{2274}'...'\u{2275}' => No,
        '\u{2278}'...'\u{2279}' => No,
        '\u{2280}'...'\u{2281}' => No,
        '\u{2284}'...'\u{2285}' => No,
        '\u{2288}'...'\u{2289}' => No,
        '\u{22AC}'...'\u{22AF}' => No,
        '\u{22E0}'...'\u{22E3}' => No,
        '\u{22EA}'...'\u{22ED}' => No,
        '\u{2329}' => No,
        '\u{232A}' => No,
        '\u{2ADC}' => No,
        '\u{304C}' => No,
        '\u{304E}' => No,
        '\u{3050}' => No,
        '\u{3052}' => No,
        '\u{3054}' => No,
        '\u{3056}' => No,
        '\u{3058}' => No,
        '\u{305A}' => No,
        '\u{305C}' => No,
        '\u{305E}' => No,
        '\u{3060}' => No,
        '\u{3062}' => No,
        '\u{3065}' => No,
        '\u{3067}' => No,
        '\u{3069}' => No,
        '\u{3070}'...'\u{3071}' => No,
        '\u{3073}'...'\u{3074}' => No,
        '\u{3076}'...'\u{3077}' => No,
        '\u{3079}'...'\u{307A}' => No,
        '\u{307C}'...'\u{307D}' => No,
        '\u{3094}' => No,
        '\u{309E}' => No,
        '\u{30AC}' => No,
        '\u{30AE}' => No,
        '\u{30B0}' => No,
        '\u{30B2}' => No,
        '\u{30B4}' => No,
        '\u{30B6}' => No,
        '\u{30B8}' => No,
        '\u{30BA}' => No,
        '\u{30BC}' => No,
        '\u{30BE}' => No,
        '\u{30C0}' => No,
        '\u{30C2}' => No,
        '\u{30C5}' => No,
        '\u{30C7}' => No,
        '\u{30C9}' => No,
        '\u{30D0}'...'\u{30D1}' => No,
        '\u{30D3}'...'\u{30D4}' => No,
        '\u{30D6}'...'\u{30D7}' => No,
        '\u{30D9}'...'\u{30DA}' => No,
        '\u{30DC}'...'\u{30DD}' => No,
        '\u{30F4}' => No,
        '\u{30F7}'...'\u{30FA}' => No,
        '\u{30FE}' => No,
        '\u{AC00}'...'\u{D7A3}' => No,
        '\u{F900}'...'\u{FA0D}' => No,
        '\u{FA10}' => No,
        '\u{FA12}' => No,
        '\u{FA15}'...'\u{FA1E}' => No,
        '\u{FA20}' => No,
        '\u{FA22}' => No,
        '\u{FA25}'...'\u{FA26}' => No,
        '\u{FA2A}'...'\u{FA6D}' => No,
        '\u{FA70}'...'\u{FAD9}' => No,
        '\u{FB1D}' => No,
        '\u{FB1F}' => No,
        '\u{FB2A}'...'\u{FB36}' => No,
        '\u{FB38}'...'\u{FB3C}' => No,
        '\u{FB3E}' => No,
        '\u{FB40}'...'\u{FB41}' => No,
        '\u{FB43}'...'\u{FB44}' => No,
        '\u{FB46}'...'\u{FB4E}' => No,
        '\u{1109A}' => No,
        '\u{1109C}' => No,
        '\u{110AB}' => No,
        '\u{1112E}'...'\u{1112F}' => No,
        '\u{1134B}'...'\u{1134C}' => No,
        '\u{114BB}'...'\u{114BC}' => No,
        '\u{114BE}' => No,
        '\u{115BA}'...'\u{115BB}' => No,
        '\u{1D15E}'...'\u{1D164}' => No,
        '\u{1D1BB}'...'\u{1D1C0}' => No,
        '\u{2F800}'...'\u{2FA1D}' => No,
        _ => Yes,
    }
}

#[inline]
pub fn stream_safe_leading_nonstarters(c: char) -> usize {
    match c {
        '\u{0340}' => 1,
        '\u{0341}' => 1,
        '\u{0343}' => 1,
        '\u{0344}' => 2,
        '\u{0F81}' => 2,
        '\u{0F73}' => 2,
        '\u{0F75}' => 2,
        '\u{FF9E}' => 1,
        '\u{FF9F}' => 1,
        _ => 0,
    }
}

#[inline]
pub fn stream_safe_trailing_nonstarters(c: char) -> usize {
    match c {
        '\u{0958}' => 1,
        '\u{0959}' => 1,
        '\u{095A}' => 1,
        '\u{095B}' => 1,
        '\u{095C}' => 1,
        '\u{FE87}' => 1,
        '\u{095D}' => 1,
        '\u{095E}' => 1,
        '\u{095F}' => 1,
        '\u{203E}' => 1,
        '\u{1D160}' => 2,
        '\u{1D161}' => 2,
        '\u{FEF9}' => 1,
        '\u{304C}' => 1,
        '\u{1D162}' => 2,
        '\u{304E}' => 1,
        '\u{3050}' => 1,
        '\u{3052}' => 1,
        '\u{1D163}' => 2,
        '\u{3054}' => 1,
        '\u{3056}' => 1,
        '\u{3058}' => 1,
        '\u{1D164}' => 2,
        '\u{305A}' => 1,
        '\u{305C}' => 1,
        '\u{305E}' => 1,
        '\u{3060}' => 1,
        '\u{3062}' => 1,
        '\u{3065}' => 1,
        '\u{3067}' => 1,
        '\u{3069}' => 1,
        '\u{3070}' => 1,
        '\u{3071}' => 1,
        '\u{3073}' => 1,
        '\u{3074}' => 1,
        '\u{3076}' => 1,
        '\u{3077}' => 1,
        '\u{3079}' => 1,
        '\u{307A}' => 1,
        '\u{307C}' => 1,
        '\u{307D}' => 1,
        '\u{1EC0}' => 2,
        '\u{2017}' => 1,
        '\u{1EC2}' => 2,
        '\u{3094}' => 1,
        '\u{FEF7}' => 1,
        '\u{1109A}' => 1,
        '\u{309B}' => 1,
        '\u{1109C}' => 1,
        '\u{309E}' => 1,
        '\u{FB32}' => 1,
        '\u{00A8}' => 1,
        '\u{110AB}' => 1,
        '\u{30AC}' => 1,
        '\u{FE71}' => 1,
        '\u{30AE}' => 1,
        '\u{00AF}' => 1,
        '\u{30B0}' => 1,
        '\u{30B2}' => 1,
        '\u{FEF5}' => 1,
        '\u{00B4}' => 1,
        '\u{30B6}' => 1,
        '\u{00B8}' => 1,
        '\u{30BA}' => 1,
        '\u{30BC}' => 1,
        '\u{30BE}' => 1,
        '\u{00C0}' => 1,
        '\u{00C1}' => 1,
        '\u{00C2}' => 1,
        '\u{00C3}' => 1,
        '\u{00C4}' => 1,
        '\u{00C5}' => 1,
        '\u{00C7}' => 1,
        '\u{00C8}' => 1,
        '\u{00C9}' => 1,
        '\u{00CA}' => 1,
        '\u{00CB}' => 1,
        '\u{00CC}' => 1,
        '\u{00CD}' => 1,
        '\u{00CE}' => 1,
        '\u{00CF}' => 1,
        '\u{30D0}' => 1,
        '\u{00D1}' => 1,
        '\u{00D2}' => 1,
        '\u{00D3}' => 1,
        '\u{00D4}' => 1,
        '\u{00D5}' => 1,
        '\u{00D6}' => 1,
        '\u{30D7}' => 1,
        '\u{00D9}' => 1,
        '\u{00DA}' => 1,
        '\u{00DB}' => 1,
        '\u{00DC}' => 1,
        '\u{00DD}' => 1,
        '\u{00E0}' => 1,
        '\u{00E1}' => 1,
        '\u{00E2}' => 1,
        '\u{00E3}' => 1,
        '\u{00E4}' => 1,
        '\u{00E5}' => 1,
        '\u{00E7}' => 1,
        '\u{00E8}' => 1,
        '\u{00E9}' => 1,
        '\u{00EA}' => 1,
        '\u{00EB}' => 1,
        '\u{00EC}' => 1,
        '\u{00ED}' => 1,
        '\u{00EE}' => 1,
        '\u{00EF}' => 1,
        '\u{00F1}' => 1,
        '\u{00F2}' => 1,
        '\u{00F3}' => 1,
        '\u{00F4}' => 1,
        '\u{00F5}' => 1,
        '\u{00F6}' => 1,
        '\u{30F7}' => 1,
        '\u{30F8}' => 1,
        '\u{00F9}' => 1,
        '\u{00FA}' => 1,
        '\u{00FB}' => 1,
        '\u{00FC}' => 1,
        '\u{00FD}' => 1,
        '\u{30FE}' => 1,
        '\u{00FF}' => 1,
        '\u{0100}' => 1,
        '\u{0101}' => 1,
        '\u{0102}' => 1,
        '\u{0103}' => 1,
        '\u{0104}' => 1,
        '\u{0105}' => 1,
        '\u{0106}' => 1,
        '\u{0107}' => 1,
        '\u{0108}' => 1,
        '\u{0109}' => 1,
        '\u{010A}' => 1,
        '\u{010B}' => 1,
        '\u{010C}' => 1,
        '\u{010D}' => 1,
        '\u{010E}' => 1,
        '\u{010F}' => 1,
        '\u{1E23}' => 1,
        '\u{0112}' => 1,
        '\u{0113}' => 1,
        '\u{0114}' => 1,
        '\u{0115}' => 1,
        '\u{0116}' => 1,
        '\u{0117}' => 1,
        '\u{0118}' => 1,
        '\u{0119}' => 1,
        '\u{011A}' => 1,
        '\u{011B}' => 1,
        '\u{011C}' => 1,
        '\u{011D}' => 1,
        '\u{011E}' => 1,
        '\u{011F}' => 1,
        '\u{0120}' => 1,
        '\u{0121}' => 1,
        '\u{0122}' => 1,
        '\u{0123}' => 1,
        '\u{0124}' => 1,
        '\u{0125}' => 1,
        '\u{0128}' => 1,
        '\u{0129}' => 1,
        '\u{012A}' => 1,
        '\u{012B}' => 1,
        '\u{012C}' => 1,
        '\u{012D}' => 1,
        '\u{012E}' => 1,
        '\u{012F}' => 1,
        '\u{0130}' => 1,
        '\u{0931}' => 1,
        '\u{0134}' => 1,
        '\u{0135}' => 1,
        '\u{0136}' => 1,
        '\u{0137}' => 1,
        '\u{0139}' => 1,
        '\u{013A}' => 1,
        '\u{013B}' => 1,
        '\u{013C}' => 1,
        '\u{013D}' => 1,
        '\u{013E}' => 1,
        '\u{FE76}' => 1,
        '\u{0143}' => 1,
        '\u{0144}' => 1,
        '\u{0145}' => 1,
        '\u{0146}' => 1,
        '\u{0147}' => 1,
        '\u{0148}' => 1,
        '\u{014C}' => 1,
        '\u{014D}' => 1,
        '\u{014E}' => 1,
        '\u{014F}' => 1,
        '\u{0150}' => 1,
        '\u{0151}' => 1,
        '\u{0154}' => 1,
        '\u{0155}' => 1,
        '\u{0156}' => 1,
        '\u{0157}' => 1,
        '\u{0158}' => 1,
        '\u{0159}' => 1,
        '\u{015A}' => 1,
        '\u{015B}' => 1,
        '\u{015C}' => 1,
        '\u{015D}' => 1,
        '\u{015E}' => 1,
        '\u{015F}' => 1,
        '\u{0160}' => 1,
        '\u{0161}' => 1,
        '\u{0162}' => 1,
        '\u{0163}' => 1,
        '\u{0164}' => 1,
        '\u{0165}' => 1,
        '\u{0168}' => 1,
        '\u{0169}' => 1,
        '\u{016A}' => 1,
        '\u{016B}' => 1,
        '\u{016C}' => 1,
        '\u{016D}' => 1,
        '\u{016E}' => 1,
        '\u{016F}' => 1,
        '\u{0170}' => 1,
        '\u{0171}' => 1,
        '\u{0172}' => 1,
        '\u{0173}' => 1,
        '\u{0174}' => 1,
        '\u{0175}' => 1,
        '\u{0176}' => 1,
        '\u{0177}' => 1,
        '\u{0178}' => 1,
        '\u{0179}' => 1,
        '\u{017A}' => 1,
        '\u{017B}' => 1,
        '\u{017C}' => 1,
        '\u{017D}' => 1,
        '\u{017E}' => 1,
        '\u{FE82}' => 1,
        '\u{2226}' => 1,
        '\u{FE74}' => 1,
        '\u{219A}' => 1,
        '\u{219B}' => 1,
        '\u{01A0}' => 1,
        '\u{01A1}' => 1,
        '\u{FEF8}' => 1,
        '\u{21AE}' => 1,
        '\u{01AF}' => 1,
        '\u{01B0}' => 1,
        '\u{1D1BB}' => 1,
        '\u{1D1BC}' => 1,
        '\u{1D1BD}' => 2,
        '\u{1D1BE}' => 2,
        '\u{1D1BF}' => 2,
        '\u{1D1C0}' => 2,
        '\u{01C4}' => 1,
        '\u{01C5}' => 1,
        '\u{01C6}' => 1,
        '\u{1EF7}' => 1,
        '\u{01CD}' => 1,
        '\u{01CE}' => 1,
        '\u{01CF}' => 1,
        '\u{01D0}' => 1,
        '\u{01D1}' => 1,
        '\u{01D2}' => 1,
        '\u{01D3}' => 1,
        '\u{01D4}' => 1,
        '\u{01D5}' => 2,
        '\u{01D6}' => 2,
        '\u{01D7}' => 2,
        '\u{01D8}' => 2,
        '\u{01D9}' => 2,
        '\u{01DA}' => 2,
        '\u{01DB}' => 2,
        '\u{01DC}' => 2,
        '\u{09DD}' => 1,
        '\u{01DE}' => 2,
        '\u{01DF}' => 2,
        '\u{01E0}' => 2,
        '\u{01E1}' => 2,
        '\u{01E2}' => 1,
        '\u{01E3}' => 1,
        '\u{01E6}' => 1,
        '\u{01E7}' => 1,
        '\u{01E8}' => 1,
        '\u{01E9}' => 1,
        '\u{01EA}' => 1,
        '\u{01EB}' => 1,
        '\u{01EC}' => 2,
        '\u{01ED}' => 2,
        '\u{01EE}' => 1,
        '\u{01EF}' => 1,
        '\u{01F0}' => 1,
        '\u{01F4}' => 1,
        '\u{01F5}' => 1,
        '\u{01F8}' => 1,
        '\u{01F9}' => 1,
        '\u{01FA}' => 2,
        '\u{01FB}' => 2,
        '\u{01FC}' => 1,
        '\u{01FD}' => 1,
        '\u{01FE}' => 1,
        '\u{01FF}' => 1,
        '\u{0200}' => 1,
        '\u{0201}' => 1,
        '\u{0202}' => 1,
        '\u{0203}' => 1,
        '\u{0204}' => 1,
        '\u{0205}' => 1,
        '\u{0206}' => 1,
        '\u{0207}' => 1,
        '\u{0208}' => 1,
        '\u{0209}' => 1,
        '\u{020A}' => 1,
        '\u{020B}' => 1,
        '\u{020C}' => 1,
        '\u{020D}' => 1,
        '\u{020E}' => 1,
        '\u{020F}' => 1,
        '\u{0210}' => 1,
        '\u{0211}' => 1,
        '\u{0212}' => 1,
        '\u{0213}' => 1,
        '\u{0214}' => 1,
        '\u{0215}' => 1,
        '\u{0216}' => 1,
        '\u{0217}' => 1,
        '\u{0218}' => 1,
        '\u{0219}' => 1,
        '\u{021A}' => 1,
        '\u{021B}' => 1,
        '\u{021E}' => 1,
        '\u{021F}' => 1,
        '\u{2224}' => 1,
        '\u{FE8C}' => 1,
        '\u{0226}' => 1,
        '\u{0227}' => 1,
        '\u{0228}' => 1,
        '\u{0229}' => 1,
        '\u{022A}' => 2,
        '\u{022B}' => 2,
        '\u{022C}' => 2,
        '\u{022D}' => 2,
        '\u{022E}' => 1,
        '\u{022F}' => 1,
        '\u{0230}' => 2,
        '\u{0231}' => 2,
        '\u{0232}' => 1,
        '\u{0233}' => 1,
        '\u{FC5E}' => 2,
        '\u{0A36}' => 1,
        '\u{30D1}' => 1,
        '\u{2241}' => 1,
        '\u{2244}' => 1,
        '\u{FE7A}' => 1,
        '\u{30D3}' => 1,
        '\u{2247}' => 1,
        '\u{2249}' => 1,
        '\u{30FA}' => 1,
        '\u{FE85}' => 1,
        '\u{0A59}' => 1,
        '\u{0A5A}' => 1,
        '\u{0A5B}' => 1,
        '\u{0A5E}' => 1,
        '\u{2260}' => 1,
        '\u{2262}' => 1,
        '\u{FE7B}' => 1,
        '\u{30D4}' => 1,
        '\u{30B4}' => 1,
        '\u{226D}' => 1,
        '\u{226E}' => 1,
        '\u{226F}' => 1,
        '\u{2270}' => 1,
        '\u{2271}' => 1,
        '\u{2274}' => 1,
        '\u{2275}' => 1,
        '\u{2278}' => 1,
        '\u{2279}' => 1,
        '\u{2280}' => 1,
        '\u{2281}' => 1,
        '\u{2284}' => 1,
        '\u{2285}' => 1,
        '\u{2288}' => 1,
        '\u{2289}' => 1,
        '\u{FE72}' => 1,
        '\u{FE7D}' => 1,
        '\u{FE86}' => 1,
        '\u{FB4B}' => 1,
        '\u{22AC}' => 1,
        '\u{22AD}' => 1,
        '\u{22AE}' => 1,
        '\u{22AF}' => 1,
        '\u{FC5C}' => 1,
        '\u{FE7E}' => 1,
        '\u{FC5D}' => 1,
        '\u{21CD}' => 1,
        '\u{21CE}' => 1,
        '\u{02D8}' => 1,
        '\u{02D9}' => 1,
        '\u{02DA}' => 1,
        '\u{02DB}' => 1,
        '\u{02DC}' => 1,
        '\u{02DD}' => 1,
        '\u{22E0}' => 1,
        '\u{22E1}' => 1,
        '\u{22E2}' => 1,
        '\u{22E3}' => 1,
        '\u{22EA}' => 1,
        '\u{22EB}' => 1,
        '\u{22EC}' => 1,
        '\u{22ED}' => 1,
        '\u{FE77}' => 1,
        '\u{FE79}' => 1,
        '\u{3304}' => 1,
        '\u{3307}' => 1,
        '\u{FCD9}' => 1,
        '\u{3310}' => 1,
        '\u{FE81}' => 1,
        '\u{FB1D}' => 1,
        '\u{331E}' => 1,
        '\u{FB1F}' => 1,
        '\u{3321}' => 1,
        '\u{09DC}' => 1,
        '\u{FB2A}' => 1,
        '\u{FB2B}' => 1,
        '\u{FB2C}' => 2,
        '\u{FB2D}' => 2,
        '\u{FB2E}' => 1,
        '\u{FB2F}' => 1,
        '\u{FB30}' => 1,
        '\u{FB31}' => 1,
        '\u{3332}' => 1,
        '\u{FB33}' => 1,
        '\u{FB34}' => 1,
        '\u{FB35}' => 1,
        '\u{FB36}' => 1,
        '\u{FB38}' => 1,
        '\u{FB39}' => 1,
        '\u{FB3A}' => 1,
        '\u{09DF}' => 1,
        '\u{FB3C}' => 1,
        '\u{FB3E}' => 1,
        '\u{0340}' => 1,
        '\u{0341}' => 1,
        '\u{0343}' => 1,
        '\u{0344}' => 2,
        '\u{FB46}' => 1,
        '\u{FB47}' => 1,
        '\u{FB48}' => 1,
        '\u{FB49}' => 1,
        '\u{FB4A}' => 1,
        '\u{1F37}' => 2,
        '\u{FB4C}' => 1,
        '\u{FB4D}' => 1,
        '\u{334E}' => 1,
        '\u{FE83}' => 1,
        '\u{1F39}' => 1,
        '\u{0B5C}' => 1,
        '\u{0B5D}' => 1,
        '\u{333B}' => 1,
        '\u{FE84}' => 1,
        '\u{037A}' => 1,
        '\u{3340}' => 1,
        '\u{0384}' => 1,
        '\u{0385}' => 2,
        '\u{0386}' => 1,
        '\u{FB41}' => 1,
        '\u{0388}' => 1,
        '\u{0389}' => 1,
        '\u{038A}' => 1,
        '\u{038C}' => 1,
        '\u{038E}' => 1,
        '\u{038F}' => 1,
        '\u{0390}' => 2,
        '\u{FB43}' => 1,
        '\u{30B8}' => 1,
        '\u{FB44}' => 1,
        '\u{FB40}' => 1,
        '\u{FBA4}' => 1,
        '\u{FBA5}' => 1,
        '\u{309C}' => 1,
        '\u{03AA}' => 1,
        '\u{03AB}' => 1,
        '\u{03AC}' => 1,
        '\u{03AD}' => 1,
        '\u{03AE}' => 1,
        '\u{03AF}' => 1,
        '\u{03B0}' => 2,
        '\u{FBB1}' => 1,
        '\u{2ADC}' => 1,
        '\u{334B}' => 1,
        '\u{03CA}' => 1,
        '\u{03CB}' => 1,
        '\u{03CC}' => 1,
        '\u{03CD}' => 1,
        '\u{03CE}' => 1,
        '\u{03D3}' => 1,
        '\u{03D4}' => 1,
        '\u{FB4E}' => 1,
        '\u{FE88}' => 1,
        '\u{0400}' => 1,
        '\u{0401}' => 1,
        '\u{0403}' => 1,
        '\u{0407}' => 1,
        '\u{FBB0}' => 1,
        '\u{040C}' => 1,
        '\u{040D}' => 1,
        '\u{040E}' => 1,
        '\u{0419}' => 1,
        '\u{FE78}' => 1,
        '\u{FE8A}' => 1,
        '\u{FB3B}' => 1,
        '\u{2209}' => 1,
        '\u{0439}' => 1,
        '\u{FE8B}' => 1,
        '\u{0C48}' => 1,
        '\u{220C}' => 1,
        '\u{0450}' => 1,
        '\u{0451}' => 1,
        '\u{0453}' => 1,
        '\u{FEF6}' => 1,
        '\u{0457}' => 1,
        '\u{FC5B}' => 1,
        '\u{045C}' => 1,
        '\u{045D}' => 1,
        '\u{045E}' => 1,
        '\u{FC5F}' => 2,
        '\u{FC60}' => 2,
        '\u{FC61}' => 2,
        '\u{FC62}' => 2,
        '\u{FC63}' => 2,
        '\u{FE89}' => 1,
        '\u{FE7C}' => 1,
        '\u{1F213}' => 1,
        '\u{0476}' => 1,
        '\u{0477}' => 1,
        '\u{30C0}' => 1,
        '\u{FCF4}' => 2,
        '\u{212B}' => 1,
        '\u{30C2}' => 1,
        '\u{FC90}' => 1,
        '\u{30C5}' => 1,
        '\u{30C7}' => 1,
        '\u{1F73}' => 1,
        '\u{21CF}' => 1,
        '\u{1F75}' => 1,
        '\u{04C1}' => 1,
        '\u{04C2}' => 1,
        '\u{1F76}' => 1,
        '\u{FFE3}' => 1,
        '\u{1F77}' => 1,
        '\u{1E22}' => 1,
        '\u{04D0}' => 1,
        '\u{04D1}' => 1,
        '\u{04D2}' => 1,
        '\u{04D3}' => 1,
        '\u{04D6}' => 1,
        '\u{04D7}' => 1,
        '\u{1E24}' => 1,
        '\u{04DA}' => 1,
        '\u{04DB}' => 1,
        '\u{04DC}' => 1,
        '\u{04DD}' => 1,
        '\u{04DE}' => 1,
        '\u{04DF}' => 1,
        '\u{04E2}' => 1,
        '\u{04E3}' => 1,
        '\u{04E4}' => 1,
        '\u{04E5}' => 1,
        '\u{04E6}' => 1,
        '\u{04E7}' => 1,
        '\u{04EA}' => 1,
        '\u{04EB}' => 1,
        '\u{04EC}' => 1,
        '\u{04ED}' => 1,
        '\u{04EE}' => 1,
        '\u{04EF}' => 1,
        '\u{04F0}' => 1,
        '\u{04F1}' => 1,
        '\u{04F2}' => 1,
        '\u{04F3}' => 1,
        '\u{04F4}' => 1,
        '\u{04F5}' => 1,
        '\u{04F8}' => 1,
        '\u{04F9}' => 1,
        '\u{30D6}' => 1,
        '\u{1F81}' => 2,
        '\u{30D9}' => 1,
        '\u{30DA}' => 1,
        '\u{1FDF}' => 2,
        '\u{30DC}' => 1,
        '\u{30DD}' => 1,
        '\u{0A33}' => 1,
        '\u{FD3C}' => 1,
        '\u{FD3D}' => 1,
        '\u{1F78}' => 1,
        '\u{1F94}' => 3,
        '\u{FE70}' => 1,
        '\u{2204}' => 1,
        '\u{30C9}' => 1,
        '\u{FCF2}' => 2,
        '\u{FCF3}' => 2,
        '\u{FF9E}' => 1,
        '\u{1ED3}' => 2,
        '\u{FE49}' => 1,
        '\u{30F4}' => 1,
        '\u{FF9F}' => 1,
        '\u{FE4A}' => 1,
        '\u{FE4B}' => 1,
        '\u{FE4C}' => 1,
        '\u{30F9}' => 1,
        '\u{0DDA}' => 1,
        '\u{0DDD}' => 1,
        '\u{1F79}' => 1,
        '\u{1E00}' => 1,
        '\u{1E01}' => 1,
        '\u{1E02}' => 1,
        '\u{1E03}' => 1,
        '\u{1E04}' => 1,
        '\u{1E05}' => 1,
        '\u{1E06}' => 1,
        '\u{1E07}' => 1,
        '\u{1E08}' => 2,
        '\u{1E09}' => 2,
        '\u{1E0A}' => 1,
        '\u{1E0B}' => 1,
        '\u{1E0C}' => 1,
        '\u{1E0D}' => 1,
        '\u{1E0E}' => 1,
        '\u{1E0F}' => 1,
        '\u{1E10}' => 1,
        '\u{1E11}' => 1,
        '\u{1E12}' => 1,
        '\u{1E13}' => 1,
        '\u{1E14}' => 2,
        '\u{1E15}' => 2,
        '\u{1E16}' => 2,
        '\u{1E17}' => 2,
        '\u{1E18}' => 1,
        '\u{1E19}' => 1,
        '\u{1E1A}' => 1,
        '\u{1E1B}' => 1,
        '\u{1E1C}' => 2,
        '\u{1E1D}' => 2,
        '\u{1E1E}' => 1,
        '\u{1E1F}' => 1,
        '\u{1E20}' => 1,
        '\u{1E21}' => 1,
        '\u{0622}' => 1,
        '\u{0623}' => 1,
        '\u{0624}' => 1,
        '\u{0625}' => 1,
        '\u{0626}' => 1,
        '\u{1E27}' => 1,
        '\u{1E28}' => 1,
        '\u{1E29}' => 1,
        '\u{1E2A}' => 1,
        '\u{1E2B}' => 1,
        '\u{1E2C}' => 1,
        '\u{1E2D}' => 1,
        '\u{1E2E}' => 2,
        '\u{1E2F}' => 2,
        '\u{1E30}' => 1,
        '\u{1E31}' => 1,
        '\u{1E32}' => 1,
        '\u{1E33}' => 1,
        '\u{1E34}' => 1,
        '\u{1E35}' => 1,
        '\u{1E36}' => 1,
        '\u{1E37}' => 1,
        '\u{1E38}' => 2,
        '\u{1E39}' => 2,
        '\u{1E3A}' => 1,
        '\u{1E3B}' => 1,
        '\u{1E3C}' => 1,
        '\u{1E3D}' => 1,
        '\u{1E3E}' => 1,
        '\u{1E3F}' => 1,
        '\u{1E40}' => 1,
        '\u{1E41}' => 1,
        '\u{1E42}' => 1,
        '\u{1E43}' => 1,
        '\u{1E44}' => 1,
        '\u{1E45}' => 1,
        '\u{1E46}' => 1,
        '\u{1E47}' => 1,
        '\u{1E48}' => 1,
        '\u{1E49}' => 1,
        '\u{1E4A}' => 1,
        '\u{1E4B}' => 1,
        '\u{1E4C}' => 2,
        '\u{1E4D}' => 2,
        '\u{1E4E}' => 2,
        '\u{1E4F}' => 2,
        '\u{1E50}' => 2,
        '\u{1E51}' => 2,
        '\u{1E52}' => 2,
        '\u{1E53}' => 2,
        '\u{1E54}' => 1,
        '\u{1E55}' => 1,
        '\u{1E56}' => 1,
        '\u{1E57}' => 1,
        '\u{1E58}' => 1,
        '\u{1E59}' => 1,
        '\u{1E5A}' => 1,
        '\u{1E5B}' => 1,
        '\u{1E5C}' => 2,
        '\u{1E5D}' => 2,
        '\u{1E5E}' => 1,
        '\u{1E5F}' => 1,
        '\u{1E60}' => 1,
        '\u{1E61}' => 1,
        '\u{1E62}' => 1,
        '\u{1E63}' => 1,
        '\u{1E64}' => 2,
        '\u{1E65}' => 2,
        '\u{1E66}' => 2,
        '\u{1E67}' => 2,
        '\u{1E68}' => 2,
        '\u{1E69}' => 2,
        '\u{1E6A}' => 1,
        '\u{1E6B}' => 1,
        '\u{1E6C}' => 1,
        '\u{1E6D}' => 1,
        '\u{1E6E}' => 1,
        '\u{1E6F}' => 1,
        '\u{1E70}' => 1,
        '\u{1E71}' => 1,
        '\u{1E72}' => 1,
        '\u{1E73}' => 1,
        '\u{1E74}' => 1,
        '\u{1E75}' => 1,
        '\u{1E76}' => 1,
        '\u{1E77}' => 1,
        '\u{1E78}' => 2,
        '\u{1E79}' => 2,
        '\u{1E7A}' => 2,
        '\u{1E7B}' => 2,
        '\u{1E7C}' => 1,
        '\u{1E7D}' => 1,
        '\u{1E7E}' => 1,
        '\u{1E7F}' => 1,
        '\u{1E80}' => 1,
        '\u{1E81}' => 1,
        '\u{1E82}' => 1,
        '\u{1E83}' => 1,
        '\u{1E84}' => 1,
        '\u{1E85}' => 1,
        '\u{1E86}' => 1,
        '\u{1E87}' => 1,
        '\u{1E88}' => 1,
        '\u{1E25}' => 1,
        '\u{1E8A}' => 1,
        '\u{1E8B}' => 1,
        '\u{1E8C}' => 1,
        '\u{1E8D}' => 1,
        '\u{1E8E}' => 1,
        '\u{1E8F}' => 1,
        '\u{1E90}' => 1,
        '\u{1E91}' => 1,
        '\u{1E92}' => 1,
        '\u{1E93}' => 1,
        '\u{1E94}' => 1,
        '\u{1E95}' => 1,
        '\u{1E96}' => 1,
        '\u{1E97}' => 1,
        '\u{1E98}' => 1,
        '\u{1E99}' => 1,
        '\u{1E9B}' => 1,
        '\u{1EA0}' => 1,
        '\u{1EA1}' => 1,
        '\u{1EA2}' => 1,
        '\u{1EA3}' => 1,
        '\u{1EA4}' => 2,
        '\u{1EA5}' => 2,
        '\u{1EA6}' => 2,
        '\u{1EA7}' => 2,
        '\u{1EA8}' => 2,
        '\u{1EA9}' => 2,
        '\u{1EAA}' => 2,
        '\u{1EAB}' => 2,
        '\u{1EAC}' => 2,
        '\u{1EAD}' => 2,
        '\u{1EAE}' => 2,
        '\u{1EAF}' => 2,
        '\u{1EB0}' => 2,
        '\u{1EB1}' => 2,
        '\u{1EB2}' => 2,
        '\u{1EB3}' => 2,
        '\u{1EB4}' => 2,
        '\u{1EB5}' => 2,
        '\u{1EB6}' => 2,
        '\u{1EB7}' => 2,
        '\u{1EB8}' => 1,
        '\u{1EB9}' => 1,
        '\u{1EBA}' => 1,
        '\u{1EBB}' => 1,
        '\u{1EBC}' => 1,
        '\u{1EBD}' => 1,
        '\u{1EBE}' => 2,
        '\u{1EBF}' => 2,
        '\u{06C0}' => 1,
        '\u{1EC1}' => 2,
        '\u{06C2}' => 1,
        '\u{1EC3}' => 2,
        '\u{1EC4}' => 2,
        '\u{1EC5}' => 2,
        '\u{1EC6}' => 2,
        '\u{1EC7}' => 2,
        '\u{1EC8}' => 1,
        '\u{1EC9}' => 1,
        '\u{1ECA}' => 1,
        '\u{1ECB}' => 1,
        '\u{1ECC}' => 1,
        '\u{1ECD}' => 1,
        '\u{1ECE}' => 1,
        '\u{1ECF}' => 1,
        '\u{1ED0}' => 2,
        '\u{1ED1}' => 2,
        '\u{1ED2}' => 2,
        '\u{06D3}' => 1,
        '\u{1ED4}' => 2,
        '\u{1ED5}' => 2,
        '\u{1ED6}' => 2,
        '\u{1ED7}' => 2,
        '\u{1ED8}' => 2,
        '\u{1ED9}' => 2,
        '\u{1EDA}' => 2,
        '\u{1EDB}' => 2,
        '\u{1EDC}' => 2,
        '\u{1EDD}' => 2,
        '\u{1EDE}' => 2,
        '\u{1EDF}' => 2,
        '\u{1EE0}' => 2,
        '\u{1EE1}' => 2,
        '\u{1EE2}' => 2,
        '\u{1EE3}' => 2,
        '\u{1EE4}' => 1,
        '\u{1EE5}' => 1,
        '\u{1EE6}' => 1,
        '\u{1EE7}' => 1,
        '\u{1EE8}' => 2,
        '\u{1EE9}' => 2,
        '\u{1EEA}' => 2,
        '\u{1EEB}' => 2,
        '\u{1EEC}' => 2,
        '\u{1EED}' => 2,
        '\u{1EEE}' => 2,
        '\u{1EEF}' => 2,
        '\u{1EF0}' => 2,
        '\u{1EF1}' => 2,
        '\u{1EF2}' => 1,
        '\u{1EF3}' => 1,
        '\u{1EF4}' => 1,
        '\u{1EF5}' => 1,
        '\u{1EF6}' => 1,
        '\u{0929}' => 1,
        '\u{1EF8}' => 1,
        '\u{1EF9}' => 1,
        '\u{FEFA}' => 1,
        '\u{FE7F}' => 1,
        '\u{1F00}' => 1,
        '\u{1F01}' => 1,
        '\u{1F02}' => 2,
        '\u{1F03}' => 2,
        '\u{1F04}' => 2,
        '\u{1F05}' => 2,
        '\u{1F06}' => 2,
        '\u{1F07}' => 2,
        '\u{1F08}' => 1,
        '\u{1F09}' => 1,
        '\u{1F0A}' => 2,
        '\u{1F0B}' => 2,
        '\u{1F0C}' => 2,
        '\u{1F0D}' => 2,
        '\u{1F0E}' => 2,
        '\u{1F0F}' => 2,
        '\u{1F10}' => 1,
        '\u{1F11}' => 1,
        '\u{1F12}' => 2,
        '\u{1F13}' => 2,
        '\u{1F14}' => 2,
        '\u{1F15}' => 2,
        '\u{1F18}' => 1,
        '\u{1F19}' => 1,
        '\u{1F1A}' => 2,
        '\u{1F1B}' => 2,
        '\u{1F1C}' => 2,
        '\u{1F1D}' => 2,
        '\u{1E26}' => 1,
        '\u{1F20}' => 1,
        '\u{1F21}' => 1,
        '\u{1F22}' => 2,
        '\u{1F23}' => 2,
        '\u{1F24}' => 2,
        '\u{1F25}' => 2,
        '\u{1F26}' => 2,
        '\u{1F27}' => 2,
        '\u{1F28}' => 1,
        '\u{1F29}' => 1,
        '\u{1F2A}' => 2,
        '\u{1F2B}' => 2,
        '\u{1F2C}' => 2,
        '\u{1F2D}' => 2,
        '\u{1F2E}' => 2,
        '\u{1F2F}' => 2,
        '\u{1F30}' => 1,
        '\u{1F31}' => 1,
        '\u{1F32}' => 2,
        '\u{1F33}' => 2,
        '\u{1F34}' => 2,
        '\u{1F35}' => 2,
        '\u{1F36}' => 2,
        '\u{1E89}' => 1,
        '\u{1F38}' => 1,
        '\u{0934}' => 1,
        '\u{1F3A}' => 2,
        '\u{1F3B}' => 2,
        '\u{1F3C}' => 2,
        '\u{1F3D}' => 2,
        '\u{1F3E}' => 2,
        '\u{1F3F}' => 2,
        '\u{1F40}' => 1,
        '\u{1F41}' => 1,
        '\u{1F42}' => 2,
        '\u{1F43}' => 2,
        '\u{1F44}' => 2,
        '\u{1F45}' => 2,
        '\u{1F48}' => 1,
        '\u{1F49}' => 1,
        '\u{1F4A}' => 2,
        '\u{1F4B}' => 2,
        '\u{1F4C}' => 2,
        '\u{1F4D}' => 2,
        '\u{1F50}' => 1,
        '\u{1F51}' => 1,
        '\u{1F52}' => 2,
        '\u{1F53}' => 2,
        '\u{1F54}' => 2,
        '\u{1F55}' => 2,
        '\u{1F56}' => 2,
        '\u{1F57}' => 2,
        '\u{1F59}' => 1,
        '\u{1F5B}' => 2,
        '\u{1F5D}' => 2,
        '\u{1F5F}' => 2,
        '\u{1F60}' => 1,
        '\u{1F61}' => 1,
        '\u{1F62}' => 2,
        '\u{1F63}' => 2,
        '\u{1F64}' => 2,
        '\u{1F65}' => 2,
        '\u{1F66}' => 2,
        '\u{1F67}' => 2,
        '\u{1F68}' => 1,
        '\u{1F69}' => 1,
        '\u{1F6A}' => 2,
        '\u{1F6B}' => 2,
        '\u{1F6C}' => 2,
        '\u{1F6D}' => 2,
        '\u{1F6E}' => 2,
        '\u{1F6F}' => 2,
        '\u{1F70}' => 1,
        '\u{1F71}' => 1,
        '\u{1F72}' => 1,
        '\u{0F73}' => 2,
        '\u{1F74}' => 1,
        '\u{0F75}' => 2,
        '\u{0F76}' => 1,
        '\u{0F77}' => 2,
        '\u{0F78}' => 1,
        '\u{0F79}' => 2,
        '\u{1F7A}' => 1,
        '\u{1F7B}' => 1,
        '\u{1F7C}' => 1,
        '\u{1F7D}' => 1,
        '\u{1F80}' => 2,
        '\u{0F81}' => 2,
        '\u{1F82}' => 3,
        '\u{1F83}' => 3,
        '\u{1F84}' => 3,
        '\u{1F85}' => 3,
        '\u{1F86}' => 3,
        '\u{1F87}' => 3,
        '\u{1F88}' => 2,
        '\u{1F89}' => 2,
        '\u{1F8A}' => 3,
        '\u{1F8B}' => 3,
        '\u{1F8C}' => 3,
        '\u{1F8D}' => 3,
        '\u{1F8E}' => 3,
        '\u{1F8F}' => 3,
        '\u{1F90}' => 2,
        '\u{1F91}' => 2,
        '\u{1F92}' => 3,
        '\u{1F93}' => 3,
        '\u{1D15E}' => 1,
        '\u{1F95}' => 3,
        '\u{1F96}' => 3,
        '\u{1F97}' => 3,
        '\u{1F98}' => 2,
        '\u{1F99}' => 2,
        '\u{1F9A}' => 3,
        '\u{1F9B}' => 3,
        '\u{1F9C}' => 3,
        '\u{1F9D}' => 3,
        '\u{1F9E}' => 3,
        '\u{1F9F}' => 3,
        '\u{1FA0}' => 2,
        '\u{1FA1}' => 2,
        '\u{1FA2}' => 3,
        '\u{1FA3}' => 3,
        '\u{1FA4}' => 3,
        '\u{1FA5}' => 3,
        '\u{1FA6}' => 3,
        '\u{1FA7}' => 3,
        '\u{1FA8}' => 2,
        '\u{1FA9}' => 2,
        '\u{1FAA}' => 3,
        '\u{1FAB}' => 3,
        '\u{1FAC}' => 3,
        '\u{1FAD}' => 3,
        '\u{1FAE}' => 3,
        '\u{1FAF}' => 3,
        '\u{1FB0}' => 1,
        '\u{1FB1}' => 1,
        '\u{1D15F}' => 1,
        '\u{1FB3}' => 1,
        '\u{1FB4}' => 2,
        '\u{1FB6}' => 1,
        '\u{1FB7}' => 2,
        '\u{1FB8}' => 1,
        '\u{1FB9}' => 1,
        '\u{1FBA}' => 1,
        '\u{1FBB}' => 1,
        '\u{1FBC}' => 1,
        '\u{1FBD}' => 1,
        '\u{1FBF}' => 1,
        '\u{1FC0}' => 1,
        '\u{1FC1}' => 2,
        '\u{1FC2}' => 2,
        '\u{1FC3}' => 1,
        '\u{1FC4}' => 2,
        '\u{1FC6}' => 1,
        '\u{1FC7}' => 2,
        '\u{1FC8}' => 1,
        '\u{1FC9}' => 1,
        '\u{1FCA}' => 1,
        '\u{1FCB}' => 1,
        '\u{1FCC}' => 1,
        '\u{1FCD}' => 2,
        '\u{1FCE}' => 2,
        '\u{1FCF}' => 2,
        '\u{1FD0}' => 1,
        '\u{1FD1}' => 1,
        '\u{1FD2}' => 2,
        '\u{1FD3}' => 2,
        '\u{1FD6}' => 1,
        '\u{1FD7}' => 2,
        '\u{1FD8}' => 1,
        '\u{1FD9}' => 1,
        '\u{1FDA}' => 1,
        '\u{1FDB}' => 1,
        '\u{1FDD}' => 2,
        '\u{1FDE}' => 2,
        '\u{1FB2}' => 2,
        '\u{1FE0}' => 1,
        '\u{1FE1}' => 1,
        '\u{1FE2}' => 2,
        '\u{1FE3}' => 2,
        '\u{1FE4}' => 1,
        '\u{1FE5}' => 1,
        '\u{1FE6}' => 1,
        '\u{1FE7}' => 2,
        '\u{1FE8}' => 1,
        '\u{1FE9}' => 1,
        '\u{1FEA}' => 1,
        '\u{1FEB}' => 1,
        '\u{1FEC}' => 1,
        '\u{1FED}' => 2,
        '\u{1FEE}' => 2,
        '\u{1FF2}' => 2,
        '\u{1FF3}' => 1,
        '\u{1FF4}' => 2,
        '\u{1FF6}' => 1,
        '\u{1FF7}' => 2,
        '\u{1FF8}' => 1,
        '\u{1FF9}' => 1,
        '\u{1FFA}' => 1,
        '\u{1FFB}' => 1,
        '\u{1FFC}' => 1,
        '\u{1FFD}' => 1,
        '\u{1FFE}' => 1,
        _ => 0,
    }
}

