/* calendar-year.c generated by valac 0.28.0, the Vala compiler
 * generated from calendar-year.vala, do not modify */

/* Copyright 2014-2015 Yorba Foundation
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define CALIFORNIA_TYPE_BASE_OBJECT (california_base_object_get_type ())
#define CALIFORNIA_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject))
#define CALIFORNIA_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))
#define CALIFORNIA_IS_BASE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_IS_BASE_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_TYPE_BASE_OBJECT))
#define CALIFORNIA_BASE_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObjectClass))

typedef struct _CaliforniaBaseObject CaliforniaBaseObject;
typedef struct _CaliforniaBaseObjectClass CaliforniaBaseObjectClass;
typedef struct _CaliforniaBaseObjectPrivate CaliforniaBaseObjectPrivate;

#define CALIFORNIA_CALENDAR_TYPE_SPAN (california_calendar_span_get_type ())
#define CALIFORNIA_CALENDAR_SPAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan))
#define CALIFORNIA_CALENDAR_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))
#define CALIFORNIA_CALENDAR_IS_SPAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_IS_SPAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_SPAN))
#define CALIFORNIA_CALENDAR_SPAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpanClass))

typedef struct _CaliforniaCalendarSpan CaliforniaCalendarSpan;
typedef struct _CaliforniaCalendarSpanClass CaliforniaCalendarSpanClass;
typedef struct _CaliforniaCalendarSpanPrivate CaliforniaCalendarSpanPrivate;

#define CALIFORNIA_CALENDAR_TYPE_UNIT (california_calendar_unit_get_type ())
#define CALIFORNIA_CALENDAR_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnit))
#define CALIFORNIA_CALENDAR_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))
#define CALIFORNIA_CALENDAR_IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_UNIT))
#define CALIFORNIA_CALENDAR_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_UNIT, CaliforniaCalendarUnitClass))

typedef struct _CaliforniaCalendarUnit CaliforniaCalendarUnit;
typedef struct _CaliforniaCalendarUnitClass CaliforniaCalendarUnitClass;

#define CALIFORNIA_CALENDAR_TYPE_DATE (california_calendar_date_get_type ())
#define CALIFORNIA_CALENDAR_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDate))
#define CALIFORNIA_CALENDAR_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))
#define CALIFORNIA_CALENDAR_IS_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_IS_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DATE))
#define CALIFORNIA_CALENDAR_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DATE, CaliforniaCalendarDateClass))

typedef struct _CaliforniaCalendarDate CaliforniaCalendarDate;
typedef struct _CaliforniaCalendarDateClass CaliforniaCalendarDateClass;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE (california_collection_simple_iterable_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterable))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERABLE, CaliforniaCollectionSimpleIterableIface))

typedef struct _CaliforniaCollectionSimpleIterable CaliforniaCollectionSimpleIterable;
typedef struct _CaliforniaCollectionSimpleIterableIface CaliforniaCollectionSimpleIterableIface;

#define CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR (california_collection_simple_iterator_get_type ())
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIterator))
#define CALIFORNIA_COLLECTION_IS_SIMPLE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR))
#define CALIFORNIA_COLLECTION_SIMPLE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CALIFORNIA_COLLECTION_TYPE_SIMPLE_ITERATOR, CaliforniaCollectionSimpleIteratorIface))

typedef struct _CaliforniaCollectionSimpleIterator CaliforniaCollectionSimpleIterator;
typedef struct _CaliforniaCollectionSimpleIteratorIface CaliforniaCollectionSimpleIteratorIface;
typedef struct _CaliforniaCalendarUnitPrivate CaliforniaCalendarUnitPrivate;

#define CALIFORNIA_CALENDAR_TYPE_YEAR (california_calendar_year_get_type ())
#define CALIFORNIA_CALENDAR_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear))
#define CALIFORNIA_CALENDAR_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))
#define CALIFORNIA_CALENDAR_IS_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_IS_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_YEAR))
#define CALIFORNIA_CALENDAR_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearClass))

typedef struct _CaliforniaCalendarYear CaliforniaCalendarYear;
typedef struct _CaliforniaCalendarYearClass CaliforniaCalendarYearClass;
typedef struct _CaliforniaCalendarYearPrivate CaliforniaCalendarYearPrivate;

#define CALIFORNIA_CALENDAR_TYPE_DATE_UNIT (california_calendar_date_unit_get_type ())

#define CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH (california_calendar_day_of_month_get_type ())
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonth))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_IS_DAY_OF_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH))
#define CALIFORNIA_CALENDAR_DAY_OF_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_DAY_OF_MONTH, CaliforniaCalendarDayOfMonthClass))

typedef struct _CaliforniaCalendarDayOfMonth CaliforniaCalendarDayOfMonth;
typedef struct _CaliforniaCalendarDayOfMonthClass CaliforniaCalendarDayOfMonthClass;

#define CALIFORNIA_CALENDAR_TYPE_MONTH (california_calendar_month_get_type ())
#define CALIFORNIA_CALENDAR_MONTH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonth))
#define CALIFORNIA_CALENDAR_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))
#define CALIFORNIA_CALENDAR_IS_MONTH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_IS_MONTH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH))
#define CALIFORNIA_CALENDAR_MONTH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH, CaliforniaCalendarMonthClass))

typedef struct _CaliforniaCalendarMonth CaliforniaCalendarMonth;
typedef struct _CaliforniaCalendarMonthClass CaliforniaCalendarMonthClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR (california_calendar_month_of_year_get_type ())
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYear))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_IS_MONTH_OF_YEAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR))
#define CALIFORNIA_CALENDAR_MONTH_OF_YEAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALIFORNIA_CALENDAR_TYPE_MONTH_OF_YEAR, CaliforniaCalendarMonthOfYearClass))

typedef struct _CaliforniaCalendarMonthOfYear CaliforniaCalendarMonthOfYear;
typedef struct _CaliforniaCalendarMonthOfYearClass CaliforniaCalendarMonthOfYearClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CaliforniaBaseObject {
	GObject parent_instance;
	CaliforniaBaseObjectPrivate * priv;
};

struct _CaliforniaBaseObjectClass {
	GObjectClass parent_class;
	gchar* (*to_string) (CaliforniaBaseObject* self);
};

struct _CaliforniaCalendarSpan {
	CaliforniaBaseObject parent_instance;
	CaliforniaCalendarSpanPrivate * priv;
};

struct _CaliforniaCalendarSpanClass {
	CaliforniaBaseObjectClass parent_class;
	CaliforniaCalendarDate* (*get_start_date) (CaliforniaCalendarSpan* self);
	CaliforniaCalendarDate* (*get_end_date) (CaliforniaCalendarSpan* self);
};

struct _CaliforniaCollectionSimpleIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (CaliforniaCollectionSimpleIterator* self);
	gpointer (*get) (CaliforniaCollectionSimpleIterator* self);
};

struct _CaliforniaCollectionSimpleIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (CaliforniaCollectionSimpleIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (CaliforniaCollectionSimpleIterable* self);
	GDestroyNotify (*get_g_destroy_func) (CaliforniaCollectionSimpleIterable* self);
	CaliforniaCollectionSimpleIterator* (*iterator) (CaliforniaCollectionSimpleIterable* self);
};

struct _CaliforniaCalendarUnit {
	CaliforniaCalendarSpan parent_instance;
	CaliforniaCalendarUnitPrivate * priv;
};

struct _CaliforniaCalendarUnitClass {
	CaliforniaCalendarSpanClass parent_class;
	gpointer (*adjust) (CaliforniaCalendarUnit* self, gint quantity);
	gint (*difference) (CaliforniaCalendarUnit* self, gconstpointer other);
};

struct _CaliforniaCalendarYear {
	CaliforniaCalendarUnit parent_instance;
	CaliforniaCalendarYearPrivate * priv;
};

struct _CaliforniaCalendarYearClass {
	CaliforniaCalendarUnitClass parent_class;
};

struct _CaliforniaCalendarYearPrivate {
	gint _value;
};

typedef enum  {
	CALIFORNIA_CALENDAR_DATE_UNIT_DAY,
	CALIFORNIA_CALENDAR_DATE_UNIT_WEEK,
	CALIFORNIA_CALENDAR_DATE_UNIT_MONTH,
	CALIFORNIA_CALENDAR_DATE_UNIT_YEAR
} CaliforniaCalendarDateUnit;

typedef enum  {
	CALIFORNIA_CALENDAR_ERROR_INVALID
} CaliforniaCalendarError;
#define CALIFORNIA_CALENDAR_ERROR california_calendar_error_quark ()

static gpointer california_calendar_year_parent_class = NULL;
extern CaliforniaCalendarMonth* california_calendar_month_JAN;
extern CaliforniaCalendarMonth* california_calendar_month_DEC;
static GeeComparableIface* california_calendar_year_gee_comparable_parent_iface = NULL;
static GeeHashableIface* california_calendar_year_gee_hashable_parent_iface = NULL;

GType california_base_object_get_type (void) G_GNUC_CONST;
GType california_calendar_span_get_type (void) G_GNUC_CONST;
GType california_calendar_unit_get_type (void) G_GNUC_CONST;
GType california_calendar_date_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterator_get_type (void) G_GNUC_CONST;
GType california_collection_simple_iterable_get_type (void) G_GNUC_CONST;
GType california_calendar_year_get_type (void) G_GNUC_CONST;
#define CALIFORNIA_CALENDAR_YEAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYearPrivate))
enum  {
	CALIFORNIA_CALENDAR_YEAR_DUMMY_PROPERTY,
	CALIFORNIA_CALENDAR_YEAR_VALUE
};
CaliforniaCalendarYear* california_calendar_year_new (gint value);
CaliforniaCalendarYear* california_calendar_year_construct (GType object_type, gint value);
GType california_calendar_date_unit_get_type (void) G_GNUC_CONST;
CaliforniaCalendarUnit* california_calendar_unit_construct_uninitialized (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, CaliforniaCalendarDateUnit date_unit);
static void california_calendar_year_set_value (CaliforniaCalendarYear* self, gint value);
GType california_calendar_day_of_month_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDayOfMonth* california_calendar_day_of_month_first (void);
GType california_calendar_month_get_type (void) G_GNUC_CONST;
GQuark california_calendar_error_quark (void);
CaliforniaCalendarDate* california_calendar_date_new (CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarDate* california_calendar_date_construct (GType object_type, CaliforniaCalendarDayOfMonth* day_of_month, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year, GError** error);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_new (CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
CaliforniaCalendarMonthOfYear* california_calendar_month_of_year_construct (GType object_type, CaliforniaCalendarMonth* month, CaliforniaCalendarYear* year);
GType california_calendar_month_of_year_get_type (void) G_GNUC_CONST;
CaliforniaCalendarDayOfMonth* california_calendar_month_of_year_last_day_of_month (CaliforniaCalendarMonthOfYear* self);
void california_calendar_span_init_span (CaliforniaCalendarSpan* self, CaliforniaCalendarDate* start_date, CaliforniaCalendarDate* end_date);
gchar* california_base_object_to_string (CaliforniaBaseObject* self);
CaliforniaCalendarYear* california_calendar_year_new_from_gdate (GDate* gdate);
CaliforniaCalendarYear* california_calendar_year_construct_from_gdate (GType object_type, GDate* gdate);
GDateYear california_calendar_year_to_date_year (CaliforniaCalendarYear* self);
gint california_calendar_year_get_value (CaliforniaCalendarYear* self);
static CaliforniaCalendarYear* california_calendar_year_real_adjust (CaliforniaCalendarUnit* base, gint quantity);
static gint california_calendar_year_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarYear* other);
static gint california_calendar_year_real_compare_to (GeeComparable* base, CaliforniaCalendarYear* other);
CaliforniaCalendarDate* california_calendar_span_get_start_date (CaliforniaCalendarSpan* self);
static gboolean california_calendar_year_real_equal_to (GeeHashable* base, CaliforniaCalendarYear* other);
static guint california_calendar_year_real_hash (GeeHashable* base);
static gchar* california_calendar_year_real_to_string (CaliforniaBaseObject* base);
static void california_calendar_year_finalize (GObject* obj);
static void _vala_california_calendar_year_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_california_calendar_year_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Creates a new {@link Year} from 1 CE to several thousand years in the future.
     *
     * Negative values and zero are clamped to 1 CE.
     */
CaliforniaCalendarYear* california_calendar_year_construct (GType object_type, gint value) {
	CaliforniaCalendarYear * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GError * _inner_error_ = NULL;
#line 28 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = (CaliforniaCalendarYear*) california_calendar_unit_construct_uninitialized (object_type, CALIFORNIA_CALENDAR_TYPE_YEAR, (GBoxedCopyFunc) g_object_ref, g_object_unref, CALIFORNIA_CALENDAR_DATE_UNIT_YEAR);
#line 30 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = value;
#line 30 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = CLAMP (_tmp0_, 1, G_MAXINT);
#line 30 "/home/jim/git/california/src/calendar/calendar-year.vala"
	california_calendar_year_set_value (self, _tmp1_);
#line 267 "calendar-year.c"
	{
		CaliforniaCalendarDate* _tmp2_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp3_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp4_ = NULL;
		CaliforniaCalendarMonth* _tmp5_ = NULL;
		CaliforniaCalendarDate* _tmp6_ = NULL;
		CaliforniaCalendarDate* _tmp7_ = NULL;
		CaliforniaCalendarDate* _tmp8_ = NULL;
		CaliforniaCalendarMonth* _tmp9_ = NULL;
		CaliforniaCalendarMonthOfYear* _tmp10_ = NULL;
		CaliforniaCalendarMonthOfYear* _tmp11_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp12_ = NULL;
		CaliforniaCalendarDayOfMonth* _tmp13_ = NULL;
		CaliforniaCalendarMonth* _tmp14_ = NULL;
		CaliforniaCalendarDate* _tmp15_ = NULL;
		CaliforniaCalendarDate* _tmp16_ = NULL;
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp3_ = california_calendar_day_of_month_first ();
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp4_ = _tmp3_;
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp5_ = california_calendar_month_JAN;
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp6_ = california_calendar_date_new (_tmp4_, _tmp5_, self, &_inner_error_);
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp7_ = _tmp6_;
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_object_unref0 (_tmp4_);
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp2_ = _tmp7_;
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
			if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 302 "calendar-year.c"
				goto __catch37_california_calendar_error;
			}
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
			g_clear_error (&_inner_error_);
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
			return NULL;
#line 311 "calendar-year.c"
		}
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp9_ = california_calendar_month_DEC;
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp10_ = california_calendar_month_of_year_new (_tmp9_, self);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp11_ = _tmp10_;
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp12_ = california_calendar_month_of_year_last_day_of_month (_tmp11_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp13_ = _tmp12_;
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp14_ = california_calendar_month_DEC;
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp15_ = california_calendar_date_new (_tmp13_, _tmp14_, self, &_inner_error_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp16_ = _tmp15_;
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_object_unref0 (_tmp13_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_object_unref0 (_tmp11_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp8_ = _tmp16_;
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
			_g_object_unref0 (_tmp2_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
			if (_inner_error_->domain == CALIFORNIA_CALENDAR_ERROR) {
#line 341 "calendar-year.c"
				goto __catch37_california_calendar_error;
			}
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
			_g_object_unref0 (_tmp2_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
			g_clear_error (&_inner_error_);
#line 34 "/home/jim/git/california/src/calendar/calendar-year.vala"
			return NULL;
#line 352 "calendar-year.c"
		}
#line 33 "/home/jim/git/california/src/calendar/calendar-year.vala"
		california_calendar_span_init_span (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan), _tmp2_, _tmp8_);
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_object_unref0 (_tmp8_);
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_object_unref0 (_tmp2_);
#line 360 "calendar-year.c"
	}
	goto __finally37;
	__catch37_california_calendar_error:
	{
		GError* calerr = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		calerr = _inner_error_;
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_inner_error_ = NULL;
#line 36 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp17_ = california_base_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_TYPE_BASE_OBJECT, CaliforniaBaseObject));
#line 36 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp18_ = _tmp17_;
#line 36 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp19_ = calerr->message;
#line 36 "/home/jim/git/california/src/calendar/calendar-year.vala"
		g_error ("calendar-year.vala:36: Unable to generate start/end dates of year %s: " \
"%s", _tmp18_, _tmp19_);
#line 36 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_free0 (_tmp18_);
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_g_error_free0 (calerr);
#line 385 "calendar-year.c"
	}
	__finally37:
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		g_clear_error (&_inner_error_);
#line 32 "/home/jim/git/california/src/calendar/calendar-year.vala"
		return NULL;
#line 396 "calendar-year.c"
	}
#line 27 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return self;
#line 400 "calendar-year.c"
}


CaliforniaCalendarYear* california_calendar_year_new (gint value) {
#line 27 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return california_calendar_year_construct (CALIFORNIA_CALENDAR_TYPE_YEAR, value);
#line 407 "calendar-year.c"
}


CaliforniaCalendarYear* california_calendar_year_construct_from_gdate (GType object_type, GDate* gdate) {
	CaliforniaCalendarYear * self = NULL;
	gboolean _tmp0_ = FALSE;
	GDateYear _tmp1_ = 0U;
#line 40 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_val_if_fail (gdate != NULL, NULL);
#line 41 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = g_date_valid (gdate);
#line 41 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_vala_assert (_tmp0_, "gdate.valid()");
#line 43 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = g_date_get_year (gdate);
#line 43 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = (CaliforniaCalendarYear*) california_calendar_year_construct (object_type, (gint) _tmp1_);
#line 40 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return self;
#line 427 "calendar-year.c"
}


CaliforniaCalendarYear* california_calendar_year_new_from_gdate (GDate* gdate) {
#line 40 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return california_calendar_year_construct_from_gdate (CALIFORNIA_CALENDAR_TYPE_YEAR, gdate);
#line 434 "calendar-year.c"
}


GDateYear california_calendar_year_to_date_year (CaliforniaCalendarYear* self) {
	GDateYear result = 0U;
	gint _tmp0_ = 0;
#line 46 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (self), 0U);
#line 47 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = self->priv->_value;
#line 47 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = (GDateYear) _tmp0_;
#line 47 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 449 "calendar-year.c"
}


/**
     * @inheritDoc
     */
static CaliforniaCalendarYear* california_calendar_year_real_adjust (CaliforniaCalendarUnit* base, gint quantity) {
	CaliforniaCalendarYear * self;
	CaliforniaCalendarYear* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CaliforniaCalendarYear* _tmp2_ = NULL;
#line 53 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 54 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = self->priv->_value;
#line 54 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = quantity;
#line 54 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp2_ = california_calendar_year_new (_tmp0_ + _tmp1_);
#line 54 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = _tmp2_;
#line 54 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 474 "calendar-year.c"
}


/**
     * @inheritDoc
     */
static gint california_calendar_year_real_difference (CaliforniaCalendarUnit* base, CaliforniaCalendarYear* other) {
	CaliforniaCalendarYear * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarYear* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 60 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 60 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (other), 0);
#line 61 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = self->priv->_value;
#line 61 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = other;
#line 61 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp2_ = _tmp1_->priv->_value;
#line 61 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = _tmp0_ - _tmp2_;
#line 61 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 501 "calendar-year.c"
}


static gint california_calendar_year_real_compare_to (GeeComparable* base, CaliforniaCalendarYear* other) {
	CaliforniaCalendarYear * self;
	gint result = 0;
	gint _tmp0_ = 0;
	CaliforniaCalendarYear* _tmp1_ = NULL;
#line 64 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 64 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (other), 0);
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = other;
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
	if (self != _tmp1_) {
#line 518 "calendar-year.c"
		CaliforniaCalendarDate* _tmp2_ = NULL;
		CaliforniaCalendarDate* _tmp3_ = NULL;
		CaliforniaCalendarYear* _tmp4_ = NULL;
		CaliforniaCalendarDate* _tmp5_ = NULL;
		CaliforniaCalendarDate* _tmp6_ = NULL;
		gint _tmp7_ = 0;
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp2_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (self, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp3_ = _tmp2_;
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp4_ = other;
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp5_ = california_calendar_span_get_start_date (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CALIFORNIA_CALENDAR_TYPE_SPAN, CaliforniaCalendarSpan));
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp6_ = _tmp5_;
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp7_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COMPARABLE, GeeComparable), _tmp6_);
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp0_ = _tmp7_;
#line 539 "calendar-year.c"
	} else {
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
		_tmp0_ = 0;
#line 543 "calendar-year.c"
	}
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = _tmp0_;
#line 65 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 549 "calendar-year.c"
}


static gboolean california_calendar_year_real_equal_to (GeeHashable* base, CaliforniaCalendarYear* other) {
	CaliforniaCalendarYear * self;
	gboolean result = FALSE;
	CaliforniaCalendarYear* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 68 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 68 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (other), FALSE);
#line 69 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = other;
#line 69 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COMPARABLE, GeeComparable), _tmp0_);
#line 69 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = _tmp1_ == 0;
#line 69 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 570 "calendar-year.c"
}


static guint california_calendar_year_real_hash (GeeHashable* base) {
	CaliforniaCalendarYear * self;
	guint result = 0U;
	gint _tmp0_ = 0;
#line 72 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 73 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = self->priv->_value;
#line 73 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = (guint) _tmp0_;
#line 73 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 586 "calendar-year.c"
}


static gchar* california_calendar_year_real_to_string (CaliforniaBaseObject* base) {
	CaliforniaCalendarYear * self;
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
#line 76 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 77 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = self->priv->_value;
#line 77 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
#line 77 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = _tmp1_;
#line 77 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 605 "calendar-year.c"
}


gint california_calendar_year_get_value (CaliforniaCalendarYear* self) {
	gint result;
	gint _tmp0_ = 0;
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_val_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (self), 0);
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = self->priv->_value;
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	result = _tmp0_;
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	return result;
#line 620 "calendar-year.c"
}


static void california_calendar_year_set_value (CaliforniaCalendarYear* self, gint value) {
	gint _tmp0_ = 0;
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_return_if_fail (CALIFORNIA_CALENDAR_IS_YEAR (self));
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	_tmp0_ = value;
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self->priv->_value = _tmp0_;
#line 20 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_object_notify ((GObject *) self, "value");
#line 634 "calendar-year.c"
}


static void california_calendar_year_class_init (CaliforniaCalendarYearClass * klass) {
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	california_calendar_year_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_type_class_add_private (klass, sizeof (CaliforniaCalendarYearPrivate));
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	((CaliforniaCalendarUnitClass *) klass)->adjust = california_calendar_year_real_adjust;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	((CaliforniaCalendarUnitClass *) klass)->difference = california_calendar_year_real_difference;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	((CaliforniaBaseObjectClass *) klass)->to_string = california_calendar_year_real_to_string;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_california_calendar_year_get_property;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_california_calendar_year_set_property;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	G_OBJECT_CLASS (klass)->finalize = california_calendar_year_finalize;
#line 655 "calendar-year.c"
	/**
	     * The year as an integer.
	     */
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALIFORNIA_CALENDAR_YEAR_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 661 "calendar-year.c"
}


static void california_calendar_year_gee_comparable_interface_init (GeeComparableIface * iface) {
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	california_calendar_year_gee_comparable_parent_iface = g_type_interface_peek_parent (iface);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	iface->compare_to = (gint (*)(GeeComparable*, gconstpointer)) california_calendar_year_real_compare_to;
#line 670 "calendar-year.c"
}


static void california_calendar_year_gee_hashable_interface_init (GeeHashableIface * iface) {
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	california_calendar_year_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	iface->equal_to = (gboolean (*)(GeeHashable*, gconstpointer)) california_calendar_year_real_equal_to;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	iface->hash = (guint (*)(GeeHashable*)) california_calendar_year_real_hash;
#line 681 "calendar-year.c"
}


static void california_calendar_year_instance_init (CaliforniaCalendarYear * self) {
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self->priv = CALIFORNIA_CALENDAR_YEAR_GET_PRIVATE (self);
#line 688 "calendar-year.c"
}


static void california_calendar_year_finalize (GObject* obj) {
	CaliforniaCalendarYear * self;
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	G_OBJECT_CLASS (california_calendar_year_parent_class)->finalize (obj);
#line 698 "calendar-year.c"
}


/**
 * An immutable representation of a calendar year.
 *
 * Because of limitations in GLib's Date representation, years before 1 are unsupported.  Maximum
 * value is described as thousands of years from now.
 */
GType california_calendar_year_get_type (void) {
	static volatile gsize california_calendar_year_type_id__volatile = 0;
	if (g_once_init_enter (&california_calendar_year_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CaliforniaCalendarYearClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) california_calendar_year_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CaliforniaCalendarYear), 0, (GInstanceInitFunc) california_calendar_year_instance_init, NULL };
		static const GInterfaceInfo gee_comparable_info = { (GInterfaceInitFunc) california_calendar_year_gee_comparable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) california_calendar_year_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType california_calendar_year_type_id;
		california_calendar_year_type_id = g_type_register_static (CALIFORNIA_CALENDAR_TYPE_UNIT, "CaliforniaCalendarYear", &g_define_type_info, 0);
		g_type_add_interface_static (california_calendar_year_type_id, GEE_TYPE_COMPARABLE, &gee_comparable_info);
		g_type_add_interface_static (california_calendar_year_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
		g_once_init_leave (&california_calendar_year_type_id__volatile, california_calendar_year_type_id);
	}
	return california_calendar_year_type_id__volatile;
}


static void _vala_california_calendar_year_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarYear * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		case CALIFORNIA_CALENDAR_YEAR_VALUE:
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		g_value_set_int (value, california_calendar_year_get_value (self));
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		break;
#line 735 "calendar-year.c"
		default:
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		break;
#line 741 "calendar-year.c"
	}
}


static void _vala_california_calendar_year_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CaliforniaCalendarYear * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALIFORNIA_CALENDAR_TYPE_YEAR, CaliforniaCalendarYear);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
	switch (property_id) {
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		case CALIFORNIA_CALENDAR_YEAR_VALUE:
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		california_calendar_year_set_value (self, g_value_get_int (value));
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		break;
#line 757 "calendar-year.c"
		default:
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 16 "/home/jim/git/california/src/calendar/calendar-year.vala"
		break;
#line 763 "calendar-year.c"
	}
}



