#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# My Brother Rabbit
# send your bug reports to contact@dotslashplay.it
###

script_version=20241016.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='my-brother-rabbit'
GAME_NAME='My Brother Rabbit'

ARCHIVE_BASE_0_NAME='my_brother_rabbit_gog_2_23945.sh'
ARCHIVE_BASE_0_MD5='e8dd42bb3ac4e10c56cd5da36cb60c99'
ARCHIVE_BASE_0_SIZE='860634'
ARCHIVE_BASE_0_VERSION='2-gog23945'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/my_brother_rabbit'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
MyBrotherRabbit_amd64'
CONTENT_GAME_BIN32_FILES='
MyBrotherRabbit_i386'
CONTENT_GAME_DATA_FILES='
linux
game.json
game.sparkconfig'

APP_MAIN_EXE_BIN32='MyBrotherRabbit_i386'
APP_MAIN_EXE_BIN64='MyBrotherRabbit_amd64'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libidn.so.11
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXinerama.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
