#!/bin/bash
set -e
set -o pipefail

# call as ./svn_build_tar.sh $path_to_svn_or_git_svn_checkout $last_upstream_version_number

UPSDIR=$1
VERSION=$2

test -d "$UPSDIR" || ( echo "No upstream directory"; exit 1 )
test -z "$VERSION" && ( echo "No Version"; exit 1 )

CURDIR=$PWD

#Determine SVN repositories' state
cd $UPSDIR
DATE=$( ( LANG=C svn info || LANG=C git svn info ) | grep "Last Changed Date" | cut -d: -f2 | awk '{print $1}' | perl -pe s/-//g)
REV=$( ( LANG=C svn info  || LANG=C git svn info ) | awk '/^Revision/ { print $2 }')
cd $CURDIR

tmpdir=$(mktemp --tmpdir -d logwatch.XXXXXXX)
logwatch_dir=logwatch-$VERSION+svn${DATE}rev$REV
target_dir=$tmpdir/$logwatch_dir

mkdir -p $target_dir

rsync -av --exclude=.svn --exclude=.git $UPSDIR/ $target_dir

tar -C $tmpdir -cavf $logwatch_dir.tar.xz $logwatch_dir







