#!/bin/sh

# bb-disk.sh
#
# BIG BROTHER MONITORING SCRIPT
# Sean MacGuire
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#
#
# For each system we monitor we watch
#	disk	USES df 
#	cpu	USES uptime
#	procs	CHECKS A LIST
# 	msgs	LOOKS FOR WARNINGS
#
# For the network we care about
#	telnet	USES telnet and checks the results
#	http	USES lynx to check for valid output
#
# THEN SEND THE RESULTS TO THE DISPLAY SERVER USING bb

# echo "***** BBHOME IS SET TO $BBHOME"
# echo "***** BBTMP IS SET TO $BBTMP"

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
	 # echo "*** LOADING BBDEF ***"
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

if test ! "$MACHINEDOTS"		# THIS SHOULD ALREADY BE SET...
then
	# Setup the name of the local host
	# Save a version of the machine name with '.' 
	# instead of ',', if any are there
	MACHINEDOTS=`echo $MACHINE | $SED 's/,/\./g'`
	if [ "$FQDN" != "TRUE" ]
	then
		OLDIFS=$IFS
		IFS='.'
		set $MACHINEDOTS >/dev/null
		IFS=$OLDIFS
		MACHINEMASK="${1}"
	else
		MACHINEMASK="${MACHINEDOTS}"
	fi
	export MACHINEDOTS MACHINEMASK
fi
#
#=====================================================================
# DISK TEST
#=====================================================================
#
# echo "*** DISK TEST 1 ***"
COLOR="green"
REDLINE=""
YELLOWLINE=""

eval "$DFCMD | $EGREP \"$DFUSE\" | $EGREP -v \"$DFEXCLUDE\" | $SORT \"+${DFSORT}\" > $BBTMP/DFOUT.$$"

if [ ! -f $BBTMP/DFOUT.$$ ]
then
	$BBHOME/bin/bb-combo.sh add "status $MACHINE.disk red `date` - BB cannot create $BBTMP/DFOUT.$$ (permissions problem ?)"
elif [ ! -r $BBTMP/DFOUT.$$ ]
then
	$BBHOME/bin/bb-combo.sh add "status $MACHINE.disk red `date` - BB cannot read $BBTMP/DFOUT.$$"
elif [ ! -w $BBTMP/DFOUT.$$ ]
then
	$BBHOME/bin/bb-combo.sh add "status $MACHINE.disk red `date` - BB cannot write to $BBTMP/DFOUT.$$"
elif [ ! -s $BBTMP/DFOUT.$$ ]
then
	$BBHOME/bin/bb-combo.sh add "status $MACHINE.disk red `date` - Filesystem of $BBTMP is FULL"
else
	wclen1=`eval "$DFCMD | $EGREP \"$DFUSE\" | $EGREP -v \"$DFEXCLUDE\" | $SORT \"+${DFSORT}\" | $WC"`
	wclen2=`$CAT $BBTMP/DFOUT.$$ | $WC`
	if [ "$wclen1" -ne "$wclen2" ]
	then
		$BBHOME/bin/bb-combo.sh add "status $MACHINE.disk red `date` - Filesystem of $BBTMP might be FULL"
	else

		$CAT $BBTMP/DFOUT.$$ | {
		while read line
		do
			set $line
			DISKNAME=$6
			DISKDEV=$1
			DISKPCT=`echo $5 | $SED "s/%//"`

			# echo "*** DISK TEST 2 ***"
			#
			# SUPPORT FOR NON-STANDARD df'S
			# Richard Dansereau <dansereau.richard@regis.uqam.ca>
			# Thanks to Thomas Alex <thomas.alex@commgensys.com>
    			#
    			case "$BBOSTYPE"
    			in
        		sco3)   DISKNAME=$1
				DISKPCT=`echo $6 | $SED "s/%//"`
				DISKDEV=$7	# Is this true ?
				;;
			irix)   # Thanks to:    David Brandon
				# and Jeff Younker - jeff@mdli.com
				DISKNAME=$7
				DISKPCT=`echo $6 | $SED "s/%//"`
				;;
    			esac

			# echo "$DISKNAME $DISKPCT"

			DFWARNVAL=$DFWARN               # USE DEFAULT WARN VALUE
			DFPANICVAL=$DFPANIC             # USE DEFAULT PANIC VALUE

			#
			# NEW IN 1.08a
			# Robert Andre Croteau's custom disk file
			# IF WE HAVE A CUSTOM PARTITION FILE, USE IT.
			# DEFAULTS TO etc/bb-dftab
			# FORMAT:	partition:warn%:panic%
			# I.E.:		/usr:96:99
			#
			# multihost bb-dftab based on an idea of Jeff Younker<jeff@mdli.com>
			if test -f "${BBDFTAB}"
			then
				# File format:  [host:]partition:WARN:PANIC
				# Set precedence levels, suggested by Larry Parmelee <parmelee@CS.Cornell.EDU>
				# Check for the partition without the leading host

				# echo "*** CHECKING FOR PARTITION $DISKNAME IN $BBDFTAB"

				# If highest precedence if host is defined
				DISKLINE=`$GREP "^${MACHINEMASK}[   ]*:[ 	]*${DISKNAME}[ 	]*:" $BBDFTAB`
				# echo "*** DISKLINE: $DISKLINE"
				if test "$DISKLINE" = ""
				then
					DISKLINE=`$GREP "^${MACHINEMASK}\..*:[ 	]*${DISKNAME}[ 	]*:" $BBDFTAB`
				fi

				# Then look for localhost:
				if test "$DISKLINE" = ""
				then
					DISKLINE=`$GREP "^localhost[ 	]*:[ 	]*${DISKNAME}[ 	]*:" $BBDFTAB`
				fi

				# Then look for a line that starts with : (equivalent of localhost:)
				if test "$DISKLINE" = ""
				then
					DISKLINE=`$GREP "^[ 	]*:[ 	]*${DISKNAME}[ 	]*:" $BBDFTAB`
					if test "$DISKLINE" != ""
					then
						DISKLINE="localhost${DISKLINE}"
					fi
				fi

				# Finally look for a line that starts with the filesystem
				if test "$DISKLINE" = ""
				then
					DISKLINE=`$GREP "^[ 	]*${DISKNAME}[ 	]*:" $BBDFTAB`
					# echo "*** DISKLINE: $DISKLINE"
					if test "$DISKLINE" != ""
					then
						DISKLINE="localhost:${DISKLINE}"
					fi
				fi

				# We have a match
				if test "$DISKLINE" != ""
				then
					# echo "*** DISKLINE NOT NULL"
					set `echo $DISKLINE | $SED "s/:/ /g"`
       					DFWARNVAL=$3            # GET CURRENT FS WARNING LEVEL
       					DFPANICVAL=$4           # GET CURRENT FS PANIC LEVEL
					# echo "*** WARN AT $DFWARNVAL - PANIC AT $DFPANICVAL"
				fi
			fi

 		   	MARK=""
		    	if test "$DISKPCT" -ge "$DFWARNVAL"         # ABOVE WARNING LEVEL
    			then
        			if test "$DISKPCT" -ge "$DFPANICVAL"    # ABOVE PANIC, RED ALERT !!!
        			then
            				COLOR="red"
            				MARK="PANIC"
	    				MARKLEVEL=$DFPANICVAL
	    				HIGHMARK="PANIC"
					GIFCOLOR="&red"
	        			REDLINE="${GIFCOLOR} ${DISKNAME} (${DISKPCT}%) has reached the defined disk space ${MARK} level (${MARKLEVEL}%)
${REDLINE}"
        			else
            				if test "$COLOR" = "green"          # ONLY IF NOT ALREADY SET
            				then
                				COLOR="yellow"
	        				HIGHMARK="WARNING"
            				fi
            				MARK="WARNING"
	    				MARKLEVEL=$DFWARNVAL
					GIFCOLOR="&yellow"
	        	YELLOWLINE="${GIFCOLOR} ${DISKNAME} (${DISKPCT}%) has reached the defined disk space ${MARK} level (${MARKLEVEL}%)
${YELLOWLINE}"
        			fi
    			fi
		done

		#
		# NOW SEND THIS INFORMATION TO THE BIG BROTHER DISPLAY UNIT
		#
		if [ "$COLOR" = "green" ]
		then
		    LINE="status $MACHINE.disk $COLOR `date` - Disk partitions on $MACHINE OK

`cat $BBTMP/DFOUT.$$`"
		else
		    LINE="status $MACHINE.disk $COLOR `date` - Disk on $MACHINE at $HIGHMARK level
${REDLINE}${YELLOWLINE}
`cat $BBTMP/DFOUT.$$`"
		fi

		$BBHOME/bin/bb-combo.sh add "$LINE"

		}
	fi
fi

$RM -f $BBTMP/DFOUT.$$
