#!/bin/sh
#
# top: Sun Enterprise Server check - BB external script test
#
# version 1.0
# version 2.0 - now supports aix
# version 2.1 - now supports RedHat 6.1
# version 2.2 - properly uses $CAT instead of cat
# version 2.3 - properly uses $MACHINE instead of `uname -n` in bb-hosts check
# version 2.4 - properly uses $THIS_HOST instead of $MACHINE due to fqdn
#                 using comma in name - thanks Craig Cook
# version 3.0 - updates to work properly with BB 1.6
# version 3.1 - changed /tmp to $BBTMP
#                       top to $TEST
#                       $THIS_HOST to $MACHINE
#               removed code that checked for the existence of "top" 
#                 after the server name in bb-hosts
#               corrected red status warning - now does show red
# version 3.2 - removed <BLOCKQUOTE> statements, and other html 
#                 formatting, now more "browser friendly"
#               applied Todd Jimenez style get_header and get_footer functions
#               added check for bbsys.local vars being set
#               top options are now set using a case statement, for OS version
#               restored functionality to check for the existence of "top"
#                 after the server name in bb-hosts, but now optional
#               changed &red and &yellow to variables
#
# BIG BROTHER / XXXXXXXXXXXXXXXX status
#
# Written by Paul A. Luzzi
#  on March 22, 2000
#
# 3.0 Updates by David Levin    3  Jan 2001
# 3.1 Updates by Craig Cook     26 Apr 2001
# 3.2 Updates by Craig Cook     31 Oct 2001

# Feedback/Enhancements welcome: cncook "at" usa dot net

########################################
# NOTE
# This has been tested with BB 1.8c
#
# Tested on :
#   Sun Solaris
########################################

########################################
# INSTALLATION
#  step 1  - update bb-bbexttab to include this bb-top.sh
#            (older BB versions update EXT section of the bbdef.sh script
#             to include this bb-top.sh)
#
#  step 2 - check the section starting with "case $BBOSTYPE", you may need
#           to change the parameters for top, or add your unix version 
#
#  step 3 - copy lines mentioned to bbsys.local (without the #'s)
#
#  step 4 - if you are using an older version of BB without bb-bbexttab
#             and you don't want this run on every client uncomment
#             CHECK_BB_HOSTS="Y" and add the name of this test to
#             bb-hosts for this client. eg.
#             myserver1.domain.com   # top
#
#  step 5 - restart Big Brother
#
# NOTE - the TEST variable in the configuration section, this is the name used
#        as the column header and in the BB-HOSTS file.
########################################

##################################
# CONFIGURE IT HERE
##################################
TEST="top"
BBPROG=$0; export BBPROG

#
# Start of lines to put in bbsys.local
#

TOP="/usr/bin/top"
# export TOP

# End of lines to put in bbsys.local
#

# define colours for graphics
RED_PIC="&red"
YELLOW_PIC="&yellow"

# don't scan through bb-hosts every time
# this is here for older BB versions without bb-bbexttab
# uncomment to activate
#CHECK_BB_HOSTS=Y

# Set options for top
case $BBOSTYPE
in
  solaris )
    TOP_OPT="-b 30"
    ;;

  linux )
    LINUX="Y"
    TOP_OPT="-b"
    ;;

  * )
    TOP_OPT="-b 30"
  ;;
esac

##################################
# Start of script
##################################

if test ! "$BBHOME"
then
        echo "template: BBHOME is not set"
        exit 1
fi

if test ! -d "$BBHOME"
then
        echo "template: BBHOME is invalid"
        exit 1
fi

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
         # echo "*** LOADING BBDEF ***"
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi


#
# Define header
#
get_header()
{
  echo ""
  echo "<FONT SIZE=+2><b>$1</b></FONT> ($2 $3)"
  echo ""
  #If you do not want the header in a bigger font use line below instead
  #  echo "<b>$1</b> ($2 $3)"
}

#
# Define footer
#
get_footer()
{
  echo ""
  echo ""
  #echo "<BR><BR>"
}

#####
#####  Get Status proc - used to get all responses
#####
get_status()
{
  #####
  #####  Setup any and all variables before beginning.
  #####

  # Check defaults have been set
  if [ "$TOP" = "" ]; then
    TOP="/usr/bin/top"
    echo ""
    echo "$YELLOW_PIC TOP command is not defined in etc/bbsys.local - using default: $TOP"
  fi

  if [ "$TOP_OPT" = "" ]; then
    TOP_OPT="-b 30"
    echo ""
    echo "$YELLOW_PIC TOP_OPT is not defined in etc/bbsys.local - using default: $TOP_OPT"
  fi

  #####
  #####    Modified extensively on 03-22-2000 by Paul A. Luzzi
  #####    for use with Big Brother
  #####
  #####  Purpose is to report back to a central server, all "standard"
  #####    detailed information about network, disk, volume, cpu, memory
  #####    which is not reported thru regular "easy" checks.
  #####

  #####
  #####  Setup some variables for use later
  #####
  COLOR="green"
  ## COLOR="clear"

  #####
  #####  Top Processes
  #####

  get_header "Top Process Info" "$TOP" "$TOP_OPT"

  if [ "$LINUX" = "Y" ]; then
      #####
      #####  Linux box
      #####
      CATCH_COMMAND=` $TOP $TOP_OPT | $HEAD -30 > $BBTMP/$MACHINE.$TEST.log `
  else
      #####
      #####  Unix box
      #####
      CATCH_COMMAND=` $TOP $TOP_OPT > $BBTMP/$MACHINE.$TEST.log `
  fi

  RESULT_FLAG="$?"
  if [ -s "$BBTMP/$MACHINE.$TEST.log" ]; then
      $CAT $BBTMP/$MACHINE.$TEST.log
  else
      COLOR="yellow"
      echo "Problem with top command."
  fi
  #####
  #####  Having trouble passing Threshold variable into awk,
  #####    so it is currently setup as a literal, 20.00%.
  #####
  if [ "$LINUX" = "Y" ]; then
      #####
      #####  Linux box - seems to be head unix amount + 9
      #####
      YELLOW_STATUS=`$TOP -b $LINUX_TOP |
                     $HEAD -14 |
                     $TAIL -6 |
                     $AWK ' $10 ~ /[2-3][0-9].[0-9][0-9]/ \
                      { print $2" job, pid "$1" is at "$10" and is using "$6" of memory." } ' `

      RED_STATUS=`$TOP -b $LINUX_TOP |
                  $HEAD -14 |
                  $TAIL -6 |
                  $AWK ' $10 ~ /[4-9][0-9].[0-9][0-9]/ \
                   { print $2" job, pid "$1" is at "$10" and is using "$6" of memory." } ' `

  else
      #####
      #####  Unix box
      #####
      YELLOW_STATUS=`$TOP -b 5 |
                     $TAIL -6 |
                     $AWK ' $10 ~ /[2-3][0-9].[0-9][0-9]/ \
                      { print $2" job, pid "$1" is at "$10" and is using "$6" of memory." } ' `

      RED_STATUS=`$TOP -b 5 |
                  $TAIL -6 |
                  $AWK ' $10 ~ /[4-9][0-9].[0-9][0-9]/ \
                   { print $2" job, pid "$1" is at "$10" and is using "$6" of memory." } ' `
  fi

  if [ ! -z "$YELLOW_STATUS" ]; then
      COLOR="yellow"
#      echo "<CENTER><P><HR><P></CENTER>"
      echo "$YELLOW_PIC Jobs running at greater than 20% :"
      echo "$YELLOW_STATUS"
  fi

  if [ ! -z "$RED_STATUS" ]; then
      COLOR="red"
#      echo "<CENTER><P><HR><P></CENTER>"
      echo "$RED_PIC Jobs running at greater than 40% :"
      echo "$RED_STATUS"
  fi

  #####
  #####  Make sure to export COLOR so that it gets back to "central"
  #####
  export COLOR

#####
#####  End of get_status proc
#####
}

#####
#####  Main body
#####

#not needed since will be auto created
#touch $BBTMP/$MACHINE.$TEST

if [ "$CHECK_BB_HOSTS" = "Y" ]; then
  # convert "," to "." in the hostname
  MACHINE_WITH_DOTS=`echo $MACHINE | $SED 's/,/\./g'`

  $GREP $MACHINE_WITH_DOTS $BBHOSTS | $GREP "$TEST" |
  while read line
  do
    if [ ! -z "$line" ]; then
      get_status > $BBTMP/$MACHINE.$TEST

      # NOW USE THE BB COMMAND TO SEND THE DATA ACROSS
      $BB $BBDISP "status $BBTMP/$MACHINE.$TEST $COLOR `$DATE` `$CAT $BBTMP/$MACHINE.$TEST` "
    fi
  done
else
  get_status > $BBTMP/$MACHINE.$TEST

  # NOW USE THE BB COMMAND TO SEND THE DATA ACROSS
  $BB $BBDISP "status $MACHINE.$TEST $COLOR `$DATE` `$CAT $BBTMP/$MACHINE.$TEST` "
fi

# Clean up our mess
# Checking for existence of files since the whole test may be optional
#   and may not actually run on every client
#
if [ -f $BBTMP/$MACHINE.$TEST ]; then
  $RM $BBTMP/$MACHINE.$TEST $BBTMP/$MACHINE.$TEST.log
fi

##############################################
# end of script
##############################################
