#!/bin/sh
#################################################################
# bb-root.sh  J. David Schronce david.schronce@techie.com
#               Wed Dec 05 10:23:14 EST 2001
#
# A Big Brother External Script
# Monitors wtmp for root logins
# Displays data in BB 'root' column
#
#################################################################
# This software is provided as-is. J. David Schronce
# makes no claims towards its suitability for any purpose 
# and accepts absolutely no liability for any damages
# the software may cause. Use at your own risk.
#
# But for God's sake - read the freakin' instructions!
#################################################################
#
# Instructions:  Modify the variables BBHOME, LOG_HIST_COUNT and WARNCOLOR
#                to match your system and monitoring requirements.
#
#                Add an entry for bb-root.sh in EXT definitions
#                STOP and START BB
#
#                If you remove bb-root.sh you must also
#                delete the *.root data from ~/bbvar/logs 
#                or it will go PURPLE on you.  Also remove 
#                $BBTMP/bb-root.dat - just for good housekeeping
#
#################################################################
#
# Uncomment the line below to run manually
#

#DEBUG="Y"

#
# INITIALIZE VARIABLES WE'LL BE NEEDING
#
TEST="root"				# THE NAME OF OUR TEST
LOG_HIST_COUNT=10                       # Number of root logins to archive
WARNCOLOR="red"                         # Color to turn when new login occurs


if test "$DEBUG" = "Y"
then
        echo "*** BEGIN: ROOT TEST ***"
	set -xv
	BBHOME=/bb; export BBHOME 
fi

#################################################################
#
#   NO CONFIGURATION BEYOND THIS POINT
#
#################################################################

#
# Check that we have a basic environment setup
#
if test "$BBHOME" = ""
then
        echo ERROR: BBHOME variable not set
        exit 1  
fi

if test ! "$BBTMP"			# GET DEFINITIONS IF NEEDED
then
	# echo "*** LOADING BBDEF ***"
	. $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

# THE hostname COMMAND MUST RETURN THE FULL MACHINE NAME (ASSUMING FQDN)
# AND REPLACE "." WITH ","
MACHINE=`hostname | $SED 's/\./,/g'`

#
# Check for processes in `ps`
#

LINE=""
COLOR="green"

# look for data file
if [ -f $BBTMP/bb-root.dat ]
then
# perform test here

# get last entry from bb-root.dat
   LASTTIME=`head -1 $BBTMP/bb-root.dat | $AWK '{print $7}'`
   newroot=`last root -1 | $GREP root | $GREP -v $LASTTIME | wc -l`
   if [ $newroot -gt 0 ]
   then
      echo "WARNING:  ROOT LOGIN(S) OCCURRED!" > $BBTMP/$TEST
      last root -1 | $GREP root \
         >> $BBTMP/$TEST
      COLOR=$WARNCOLOR
 # reset history file to accomodate new logins
      last root | head -$LOG_HIST_COUNT > $BBTMP/bb-root.dat
   else
     echo "No new root logins since `head -1 $BBTMP/bb-root.dat | $AWK '{print $1 $2 $3 $4  $5  $6 $7}'`" > $BBTMP/$TEST
   fi 
else
# initialize bb-root.dat with last root login
   last root | head -$LOG_HIST_COUNT > $BBTMP/bb-root.dat
   echo "bb-root initialized `date`" > $BBTMP/$TEST
fi


# FORMAT IT PROPERLY FOR BB...
LINE="status $MACHINE.$TEST $COLOR `date`
$LINE
`cat $BBTMP/$TEST`
Most recent root logins:

`cat $BBTMP/bb-root.dat`
"

#
# Send a status update to the Big Brother display unit
#

#
# Debugging
#
if test "$DEBUG" = "Y"
then
        echo "COLOR = ${COLOR}"
        echo "LINE  = ${LINE}
	`cat $BBTMP/$TEST`"
        echo "*** END:   MISC TEST ***"
else
	$BB $BBDISP "$LINE"			# SEND IT TO BBDISPLAY
fi

#
# END OF bb-root.sh
#
