# Apple USB keyboard model A1048 with keypad, plastic enclosure
#
# idVendor     0x05ac Apple, Inc.
# idProduct    0x020c Extended Keyboard
#
# Base map without localization specific keys.

keymaps 0,1,4,8,9 # Plain Shift Control Alt Shift+Alt

keycode   31 = Escape
keycode   18 = Delete Delete Delete Delete       Delete
keycode   19 = Tab    Tab    Tab    Tab          Tab
keycode    9 = Return Return Return Return       Return
keycode   58 = space  space  space  nobreakspace nobreakspace

# Modifier keys
# Note: Apple keyboards normally do not distinguish
# between left and right modifiers keys.
keycode   11 = Control    # Left Control
keycode   64 = Control    # Right Control
keycode   43 = Shift      # Left Shift
keycode   29 = Shift      # Right Shift
keycode   42 = Alt        # Left Alt
keycode   66 = Alt        # Right Alt
keycode 125 = VoidSymbol # Left Command
keycode 126 = VoidSymbol # Right Command
keycode   56 = Caps_Lock

# Keypad keys
keycode   78 = U+2327 # Clear
keycode  111 = equal
keycode   65 = slash
keycode  125 = asterisk
keycode  74 = minus
keycode   74 = plus
keycode  94 = Return

keycode   82 = zero
keycode  79 = one
keycode  80 = two
keycode  117 = three
keycode   98 = four
keycode   96 = five
keycode  77 = six
keycode   69 = seven
keycode  72 = eight
keycode  73 = nine
keycode   79 = period

# Edit keys
keycode 110 = Help
keycode   88 = Remove
keycode 102 = Home
keycode   70 = End
keycode 104 = PageUp
keycode   68 = PageDown

keycode 105 = Left
keycode   87 = Up
keycode 108 = Down
keycode 106 = Right

# Function keys, both Alt+F<n> and Control+Alt+F<n> switch to Console_<n>
keycode  105 = F1  F1  VoidSymbol Console_1  Console_1
keycode  106 = F2  F2  VoidSymbol Console_2  Console_2
keycode  108 = F3  F3  VoidSymbol Console_3  Console_3
keycode  103 = F4  F4  VoidSymbol Console_4  Console_4
keycode  63 = F5  F5  VoidSymbol Console_5  Console_5
keycode  64 = F6  F6  VoidSymbol Console_6  Console_6
keycode   83 = F7  F7  VoidSymbol Console_7  Console_7
keycode  66 = F8  F8  VoidSymbol Console_8  Console_8
keycode   55 = F9  F9  VoidSymbol Console_9  Console_9
keycode  68 = F10 F10 VoidSymbol Console_10 Console_10
keycode   76 = F11 F11 VoidSymbol Console_11 Console_11
keycode   77 = F12 F12 VoidSymbol Console_12 Console_12
keycode 183 = F13 F13 VoidSymbol Console_13 Console_13
keycode 184 = F14 F14 VoidSymbol Console_14 Console_14
keycode 185 = F15 F15 VoidSymbol Console_15 Console_15
keycode 186 = F16 F16 VoidSymbol Console_16 Console_16

# Feature keys
keycode  101 = VoidSymbol # Mute
keycode  110 = VoidSymbol # Volume Down
keycode  102 = VoidSymbol # Volume Up
keycode 161 = VoidSymbol # Eject
