/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.editor;

import com.paterva.maltego.automation.CompilationException;
import com.paterva.maltego.automation.MachineCompilation;
import com.paterva.maltego.automation.MachineCompiler;
import com.paterva.maltego.automation.MachineCompilerOptions;
import com.paterva.maltego.automation.view.editor.AllTasesChildFactory;
import com.paterva.maltego.automation.view.editor.EditorHelper;
import com.paterva.maltego.automation.view.editor.InsertTextAction;
import com.paterva.maltego.automation.view.editor.SingleIOControl;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import com.paterva.maltego.util.ui.components.MaltegoSpecComboRenderer;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class MachineEditorControl
extends JPanel
implements ExplorerManager.Provider {
    private JEditorPane _editor;
    private OutlineViewPanel _view = new OutlineViewPanel("Transforms");
    private ExplorerManager _explorer = new ExplorerManager();
    private InputOutput _io;
    private SingleIOControl _ioControl;
    private int _lastDividerLocation = -1;
    private boolean _collapsed;
    private final JComboBox _types;
    private Timer _waitTimer = null;
    private List<String> _expandedNodes;
    private JPanel _mainPanel;
    private JSplitPane _mainSplit;
    private JSplitPane _messageSplit;
    private JToolBar _toolbar;
    private JPanel _transformPanel;
    private JLabel jLabel1;

    public MachineEditorControl() {
        this.initComponents();
        this._editor = EditorHelper.createEditingComponent();
        InsertTextAction.setEditor(this._editor);
        JScrollPane scroll = new JScrollPane(this._editor);
        this._toolbar.add(EditorHelper.getFormatAction(this._editor));
        this._toolbar.add(EditorHelper.getToggleCommentAction(this._editor));
        this._toolbar.addSeparator();
        this._toolbar.add(new CompileAction());
        this._toolbar.setFloatable(false);
        this._mainPanel.add((Component)scroll, "Center");
        this._view.getView().setProperties(new Node.Property[]{new TransformProperties.InputConstraint(Node.EMPTY)});
        this._view.getView().getOutline().getColumnModel().getColumn(1).setPreferredWidth(40);
        this._view.removeFromToolbarLeft();
        this._view.addToToolbarRight(Box.createHorizontalGlue());
        JPanel centrePanel = new JPanel(new GridBagLayout());
        LabelWithBackground filterLabel = new LabelWithBackground("Filter by input:");
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(6, 2, 1, 0), 5, 0);
        centrePanel.add((Component)filterLabel, gbc);
        this._types = new JComboBox();
        this._types.setRenderer(new MaltegoSpecComboRenderer());
        this.updateTypes();
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(6, 0, 1, 2), 30, 0);
        centrePanel.add((Component)this._types, gbc);
        gbc = new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(1, 0, 0, 0), 0, 0);
        centrePanel.add((Component)this._view, gbc);
        this._transformPanel.add((Component)centrePanel, "Center");
        int preferredHeight = Math.min(600, Utilities.getUsableScreenBounds().height - 200);
        int preferredWidth = Math.min(1200, Utilities.getUsableScreenBounds().width - 200);
        this._view.getView().setAllowedDragActions(3);
        this._mainSplit.setDividerLocation(preferredWidth - 250);
        this._mainSplit.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        AbstractNode root = new AbstractNode(Children.create((ChildFactory)new AllTasesChildFactory(this), (boolean)true));
        this._explorer.setRootContext((Node)root);
        final MachineEditorControl thisForAnon = this;
        this._types.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    Node[] nodes;
                    if (MachineEditorControl.this._waitTimer != null) {
                        MachineEditorControl.this._waitTimer.stop();
                    }
                    MachineEditorControl.this._expandedNodes = new ArrayList();
                    for (Node node : nodes = MachineEditorControl.this._explorer.getRootContext().getChildren().getNodes()) {
                        if (!MachineEditorControl.this._view.getView().isExpanded(node)) continue;
                        MachineEditorControl.this._expandedNodes.add(node.getDisplayName());
                    }
                    MachineEditorControl.this._explorer.setRootContext((Node)new AbstractNode(Children.create((ChildFactory)new AllTasesChildFactory(thisForAnon), (boolean)true)));
                    MachineEditorControl.this._waitTimer = new Timer(50, new WaitTimerListener());
                    MachineEditorControl.this._waitTimer.setRepeats(true);
                    MachineEditorControl.this._waitTimer.start();
                }
            }
        });
        this._ioControl = new SingleIOControl();
        this._messageSplit.setBottomComponent(this._ioControl);
        IOContainer container = IOContainer.create((IOContainer.Provider)new CompilationIOProvider());
        this._io = IOProvider.getDefault().getIO("Compilation Output", new Action[]{new CollapseMessagesAction()}, container);
        this._lastDividerLocation = -1;
        this._messageSplit.setDividerLocation(Integer.MAX_VALUE);
        this._collapsed = true;
    }

    private void collapseMessages() {
        this._lastDividerLocation = this._messageSplit.getDividerLocation();
        this._messageSplit.setDividerLocation(Integer.MAX_VALUE);
        this._collapsed = true;
    }

    private void restoreMessages() {
        if (this._collapsed) {
            if (this._lastDividerLocation < 0) {
                this._messageSplit.setDividerLocation(0.7);
            } else {
                this._messageSplit.setDividerLocation(this._lastDividerLocation);
            }
        }
        this._collapsed = false;
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    private void initComponents() {
        this._mainSplit = new JSplitPane();
        this._transformPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this._messageSplit = new JSplitPane();
        this._mainPanel = new JPanel();
        this._toolbar = new JToolBar();
        this.setLayout(new BorderLayout());
        this._mainSplit.setDividerLocation(670);
        this._transformPanel.setLayout(new BorderLayout());
        this.jLabel1.setText(NbBundle.getMessage(MachineEditorControl.class, (String)"MachineEditorControl.jLabel1.text"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this._transformPanel.add((Component)this.jLabel1, "North");
        this._mainSplit.setRightComponent(this._transformPanel);
        this._messageSplit.setOrientation(0);
        this._mainPanel.setLayout(new BorderLayout());
        this._messageSplit.setLeftComponent(this._mainPanel);
        this._mainSplit.setLeftComponent(this._messageSplit);
        this.add((Component)this._mainSplit, "Center");
        this._toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        this._toolbar.setRollover(true);
        this.add((Component)this._toolbar, "North");
    }

    public void setText(String s) {
        this._editor.setText(s);
        this._editor.setCaretPosition(0);
    }

    public String getText() {
        return this._editor.getText();
    }

    public void setReadOnly(boolean readOnly) {
        this._editor.setEditable(!readOnly);
        this._toolbar.setVisible(!readOnly);
        this._transformPanel.setVisible(!readOnly);
    }

    public MachineCompilation compileMachine() throws CompilationException {
        MachineCompilation compilation = null;
        try {
            this._io.select();
            IOColorPrint.print((InputOutput)this._io, (CharSequence)"Compiling machine...\n", (Color)Color.black);
            try {
                compilation = MachineCompiler.getDefault().compile(this.getText(), MachineCompilerOptions.DEFAULT);
                IOColorPrint.print((InputOutput)this._io, (CharSequence)"Success\n", (Color)new Color(34, 177, 76));
            }
            catch (CompilationException e) {
                IOColorPrint.print((InputOutput)this._io, (CharSequence)(e.getMessage() + "\n"), (Color)UIManager.getLookAndFeelDefaults().getColor("7-red"));
                throw e;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return compilation;
    }

    private void updateTypes() {
        MaltegoEntitySpec[] entities;
        Object selectedOption = this.getSelectedOption();
        HashSet<String> typeNames = new HashSet<String>();
        EntityRegistry entityRegistry = EntityRegistry.getDefault();
        Collection c = entityRegistry.getAll();
        for (MaltegoEntitySpec entity : entities = c.toArray(new MaltegoEntitySpec[c.size()])) {
            typeNames.add(entity.getTypeName());
        }
        List<MaltegoEntitySpec> sortedSpecs = MachineEditorControl.getSortedSpecs(entityRegistry, typeNames);
        Object[] options = new Object[sortedSpecs.size() + 1];
        options[0] = "<Any>";
        int i = 0;
        for (MaltegoEntitySpec spec : sortedSpecs) {
            options[++i] = spec;
        }
        this.setOptions(options);
        for (Object option : options) {
            if (!option.equals(selectedOption)) continue;
            this.setSelectedOption(selectedOption);
            break;
        }
    }

    public static List<MaltegoEntitySpec> getSortedSpecs(EntityRegistry registry, Set<String> typeNames) {
        ArrayList<MaltegoEntitySpec> specs = new ArrayList<MaltegoEntitySpec>();
        for (String typeName : typeNames) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
            if (spec == null) continue;
            specs.add(spec);
        }
        Collections.sort(specs, new TypeSpecDisplayNameComparator());
        return specs;
    }

    public Object getSelectedOption() {
        return this._types.getSelectedItem();
    }

    public void setSelectedOption(Object obj) {
        this._types.setSelectedItem(obj);
    }

    public Object[] getOptions() {
        Object[] items = new Object[this._types.getItemCount()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this._types.getItemAt(i);
        }
        return items;
    }

    public void setOptions(Object[] options) {
        this._types.removeAllItems();
        for (Object o : options) {
            this._types.addItem(o);
        }
        if (options.length > 0) {
            this._types.setSelectedIndex(0);
        }
    }

    private class CompilationIOProvider
    implements IOContainer.Provider {
        private CompilationIOProvider() {
        }

        public void open() {
        }

        public void requestActive() {
        }

        public void requestVisible() {
        }

        public boolean isActivated() {
            return false;
        }

        public void add(JComponent jc, IOContainer.CallBacks cb) {
            MachineEditorControl.this._ioControl.setMainComponent(jc);
        }

        public void remove(JComponent jc) {
            MachineEditorControl.this._ioControl.setMainComponent(null);
        }

        public void select(JComponent jc) {
            MachineEditorControl.this.restoreMessages();
        }

        public JComponent getSelected() {
            return MachineEditorControl.this._ioControl.getMainComponent();
        }

        public void setTitle(JComponent jc, String string) {
        }

        public void setToolTipText(JComponent jc, String string) {
        }

        public void setIcon(JComponent jc, Icon icon) {
        }

        public void setToolbarActions(JComponent jc, Action[] actions) {
            MachineEditorControl.this._ioControl.setActions(actions);
        }

        public boolean isCloseable(JComponent jc) {
            return true;
        }
    }

    private class CompileAction
    extends AbstractAction {
        public CompileAction() {
            super("Compile", new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Tick.png")));
            this.putValue("ShortDescription", "Compile the machine code");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MachineEditorControl.this.compileMachine();
            }
            catch (CompilationException compilationException) {
                // empty catch block
            }
        }
    }

    private class CollapseMessagesAction
    extends AbstractAction {
        public CollapseMessagesAction() {
            super("Collapse", new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Collapse.png")));
            this.putValue("ShortDescription", "Collapse this output window");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MachineEditorControl.this.collapseMessages();
        }
    }

    private class WaitTimerListener
    implements ActionListener {
        private WaitTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node[] nodes = MachineEditorControl.this._explorer.getRootContext().getChildren().getNodes();
            boolean finishedLoading = true;
            for (Node node : nodes) {
                String displayName = node.getDisplayName();
                if ("Getting TAS information...".equals(displayName)) {
                    finishedLoading = false;
                    break;
                }
                if (!MachineEditorControl.this._expandedNodes.contains(node.getDisplayName())) continue;
                MachineEditorControl.this._view.getView().expandNode(node);
            }
            if (finishedLoading) {
                MachineEditorControl.this._waitTimer.stop();
            }
        }
    }
}

